<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Symfony\Bundle\FrameworkBundle\Controller;

use Doctrine\Persistence\ManagerRegistry;
use Psr\Container\ContainerInterface;
use Psr\Link\LinkInterface;
use Symfony\Component\DependencyInjection\Exception\ServiceNotFoundException;
use Symfony\Component\DependencyInjection\ParameterBag\ContainerBagInterface;
use Symfony\Component\Form\Extension\Core\Type\FormType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormFactoryInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\ResponseHeaderBag;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\HttpFoundation\StreamedResponse;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpKernel\HttpKernelInterface;
use Symfony\Component\Messenger\Envelope;
use Symfony\Component\Messenger\MessageBusInterface;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Symfony\Component\Routing\RouterInterface;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;
use Symfony\Component\Security\Core\Authorization\AuthorizationCheckerInterface;
use Symfony\Component\Security\Core\Exception\AccessDeniedException;
use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Component\Security\Csrf\CsrfToken;
use Symfony\Component\Security\Csrf\CsrfTokenManagerInterface;
use Symfony\Component\Serializer\SerializerInterface;
use Symfony\Component\WebLink\EventListener\AddLinkHeaderListener;
use Symfony\Component\WebLink\GenericLinkProvider;
use Symfony\Contracts\Service\ServiceSubscriberInterface;
use Twig\Environment;

/**
 * Provides common features needed in controllers.
 *
 * @author Fabien Potencier <fabien@symfony.com>
 */
abstract class AbstractController implements ServiceSubscriberInterface
{
    /**
     * @var ContainerInterface
     */
    protected $container;

    /**
     * @internal
     * @required
     */
    public function setContainer(ContainerInterface $container): ?ContainerInterface
    {
        $previous = $this->container;
        $this->container = $container;

        return $previous;
    }

    /**
     * Gets a container parameter by its name.
     *
     * @return array|bool|float|int|string|null
     */
    protected function getParameter(string $name)
    {
        if (!$this->container->has('parameter_bag')) {
            throw new ServiceNotFoundException('parameter_bag.', null, null, [], sprintf('The "%s::getParameter()" method is missing a parameter bag to work properly. Did you forget to register your controller as a service subscriber? This can be fixed either by using autoconfiguration or by manually wiring a "parameter_bag" in the service locator passed to the controller.', static::class));
        }

        return $this->container->get('parameter_bag')->get($name);
    }

    public static function getSubscribedServices()
    {
        return [
            'router' => '?'.RouterInterface::class,
            'request_stack' => '?'.RequestStack::class,
            'http_kernel' => '?'.HttpKernelInterface::class,
            'serializer' => '?'.SerializerInterface::class,
            'session' => '?'.SessionInterface::class,
            'security.authorization_checker' => '?'.AuthorizationCheckerInterface::class,
            'twig' => '?'.Environment::class,
            'doctrine' => '?'.ManagerRegistry::class,
            'form.factory' => '?'.FormFactoryInterface::class,
            'security.token_storage' => '?'.TokenStorageInterface::class,
            'security.csrf.token_manager' => '?'.CsrfTokenManagerInterface::class,
            'parameter_bag' => '?'.ContainerBagInterface::class,
            'message_bus' => '?'.MessageBusInterface::class,
            'messenger.default_bus' => '?'.MessageBusInterface::class,
        ];
    }

	public function img_path(){
		return "https://ir-ksit.goldenjeweltech.com/";
	}

	public function getOPRMain(){
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		$selOPR = "select * from `operation_type` where `role_status`='1' and operation_type_id IN (SELECT operation_type_id from designs group by operation_type_id) order by operation_type_id desc";
		$CONNOPR = $connection->executeQuery($selOPR);
		$FTCHOPR = $CONNOPR->fetchAll();
		return $FTCHOPR;
	}

	public function getCATMain($opt_id){
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
	    $selCAT = "select * from `design_cat` where `role_status`='1' and operation_type_id='".$opt_id."' and design_cat_id IN(select design_cat_id from designs where role_status='1' and design_image_ext_1!='' group by design_cat_id )";
		$CONNCAT = $connection->executeQuery($selCAT);
		$FTCHCAT = $CONNCAT->fetchAll();
		return $FTCHCAT;
	}

	function order_history($loginId){
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		$order_html =' <div class="wrapper-sub-menu-tab flat-animate-tab">
						<ul class="menu-tab" role="tablist">';
			$selORDER = "SELECT DATE_FORMAT(order_date, '%b %Y') AS order_month, order_date FROM orders where party_id='".$loginId."'  GROUP BY YEAR(order_date), MONTH(order_date) ORDER BY order_date";
			$CONNORDER = $connection->executeQuery($selORDER);
			$FTCHORDER = $CONNORDER->fetchAll();
			$or=0;
			$order_items='';
			foreach($FTCHORDER as $ord){
				$tab_active='';
				if($or==0){
					$tab_active='active';	
				}

				$order_html .='<li class="nav-tab-item" role="presentation">
								<a href="#productLayouts'.$or.'" class="tab-link '.$tab_active.'"
									data-bs-toggle="tab">'.$ord['order_month'].'<i
										class="icon icon-arr-right"></i></a>
							</li>';
				$or++;
			}
			$order_html .='</ul><div class="tab-content">';
			$or1=0;
			foreach($FTCHORDER as $ord1){
				$tab_active1='';
				if($or1==0){
					$tab_active1='active show';	
				}
			$order_html .='<div class="tab-pane '.$tab_active1.'" id="productLayouts'.$or1.'" role="tabpanel"><ul class="list-recent-blog">';
			$order_dt_arr = explode(" ",$ord1['order_date']);
			$order_dt1 = explode("-",$order_dt_arr[0]);
			$order_fnd = $order_dt1['0'].'-'.$order_dt1['1'];
			$selORDER1 = "SELECT * from orders where party_id='".$loginId."' and order_date like '".$order_fnd."%' order by order_date desc";
			$CONNORDER1 = $connection->executeQuery($selORDER1);
			$FTCHORDER1 = $CONNORDER1->fetchAll();
			foreach($FTCHORDER1 as $ordet){
				$mysqlDate = $ordet['order_date'];
				$date = new \DateTime($mysqlDate);

				 $order_html .='<li class="item">
					<a href="blog-single.html" class="img-box">
						<img src="images/blog/recent-1.jpg" alt="img-recent-blog">
					</a>
					<div class="content">
						<a href="ordered-items'.$ordet['order_id'].'" class="fw-medium text-sm link title">Order No: '.$ordet['order_no'].' <br> Order Qty '.number_format((float)$ordet['order_weight'],2).' grams</a>
						<span class="text-xxs text-grey date-post">'.$date->format('M d, Y').'</span>
					</div>
				</li>';
			}

						$order_html .='</ul>
									</div>';
			$or1++;
			}
            $order_html .='</div>';

			$order_html .='</div>';
			return $order_html;
	}


    /**
     * Returns true if the service id is defined.
     */
    protected function has(string $id): bool
    {
        return $this->container->has($id);
    }

    /**
     * Gets a container service by its id.
     *
     * @return object The service
     */
    protected function get(string $id): object
    {
        return $this->container->get($id);
    }

    /**
     * Generates a URL from the given parameters.
     *
     * @see UrlGeneratorInterface
     */
    protected function generateUrl(string $route, array $parameters = [], int $referenceType = UrlGeneratorInterface::ABSOLUTE_PATH): string
    {
        return $this->container->get('router')->generate($route, $parameters, $referenceType);
    }

    /**
     * Forwards the request to another controller.
     *
     * @param string $controller The controller name (a string like Bundle\BlogBundle\Controller\PostController::indexAction)
     */
    protected function forward(string $controller, array $path = [], array $query = []): Response
    {
        $request = $this->container->get('request_stack')->getCurrentRequest();
        $path['_controller'] = $controller;
        $subRequest = $request->duplicate($query, null, $path);

        return $this->container->get('http_kernel')->handle($subRequest, HttpKernelInterface::SUB_REQUEST);
    }

    /**
     * Returns a RedirectResponse to the given URL.
     */
    protected function redirect(string $url, int $status = 302): RedirectResponse
    {
        return new RedirectResponse($url, $status);
    }

    /**
     * Returns a RedirectResponse to the given route with the given parameters.
     */
    protected function redirectToRoute(string $route, array $parameters = [], int $status = 302): RedirectResponse
    {
        return $this->redirect($this->generateUrl($route, $parameters), $status);
    }

    /**
     * Returns a JsonResponse that uses the serializer component if enabled, or json_encode.
     */
    protected function json($data, int $status = 200, array $headers = [], array $context = []): JsonResponse
    {
        if ($this->container->has('serializer')) {
            $json = $this->container->get('serializer')->serialize($data, 'json', array_merge([
                'json_encode_options' => JsonResponse::DEFAULT_ENCODING_OPTIONS,
            ], $context));

            return new JsonResponse($json, $status, $headers, true);
        }

        return new JsonResponse($data, $status, $headers);
    }

    /**
     * Returns a BinaryFileResponse object with original or customized file name and disposition header.
     *
     * @param \SplFileInfo|string $file File object or path to file to be sent as response
     */
    protected function file($file, string $fileName = null, string $disposition = ResponseHeaderBag::DISPOSITION_ATTACHMENT): BinaryFileResponse
    {
        $response = new BinaryFileResponse($file);
        $response->setContentDisposition($disposition, null === $fileName ? $response->getFile()->getFilename() : $fileName);

        return $response;
    }

    /**
     * Adds a flash message to the current session for type.
     *
     * @throws \LogicException
     */
    protected function addFlash(string $type, $message): void
    {
        if (!$this->container->has('session')) {
            throw new \LogicException('You can not use the addFlash method if sessions are disabled. Enable them in "config/packages/framework.yaml".');
        }

        $this->container->get('session')->getFlashBag()->add($type, $message);
    }

    /**
     * Checks if the attribute is granted against the current authentication token and optionally supplied subject.
     *
     * @throws \LogicException
     */
    protected function isGranted($attribute, $subject = null): bool
    {
        if (!$this->container->has('security.authorization_checker')) {
            throw new \LogicException('The SecurityBundle is not registered in your application. Try running "composer require symfony/security-bundle".');
        }

        return $this->container->get('security.authorization_checker')->isGranted($attribute, $subject);
    }

    /**
     * Throws an exception unless the attribute is granted against the current authentication token and optionally
     * supplied subject.
     *
     * @throws AccessDeniedException
     */
    protected function denyAccessUnlessGranted($attribute, $subject = null, string $message = 'Access Denied.'): void
    {
        if (!$this->isGranted($attribute, $subject)) {
            $exception = $this->createAccessDeniedException($message);
            $exception->setAttributes($attribute);
            $exception->setSubject($subject);

            throw $exception;
        }
    }

    /**
     * Returns a rendered view.
     */
    protected function renderView(string $view, array $parameters = []): string
    {
        if (!$this->container->has('twig')) {
            throw new \LogicException('You can not use the "renderView" method if the Twig Bundle is not available. Try running "composer require symfony/twig-bundle".');
        }

        return $this->container->get('twig')->render($view, $parameters);
    }

    /**
     * Renders a view.
     */
    protected function render(string $view, array $parameters = [], Response $response = null): Response
    {
        $content = $this->renderView($view, $parameters);

        if (null === $response) {
            $response = new Response();
        }

        $response->setContent($content);

        return $response;
    }

    /**
     * Streams a view.
     */
    protected function stream(string $view, array $parameters = [], StreamedResponse $response = null): StreamedResponse
    {
        if (!$this->container->has('twig')) {
            throw new \LogicException('You can not use the "stream" method if the Twig Bundle is not available. Try running "composer require symfony/twig-bundle".');
        }

        $twig = $this->container->get('twig');

        $callback = function () use ($twig, $view, $parameters) {
            $twig->display($view, $parameters);
        };

        if (null === $response) {
            return new StreamedResponse($callback);
        }

        $response->setCallback($callback);

        return $response;
    }

    /**
     * Returns a NotFoundHttpException.
     *
     * This will result in a 404 response code. Usage example:
     *
     *     throw $this->createNotFoundException('Page not found!');
     */
    protected function createNotFoundException(string $message = 'Not Found', \Throwable $previous = null): NotFoundHttpException
    {
        return new NotFoundHttpException($message, $previous);
    }

    /**
     * Returns an AccessDeniedException.
     *
     * This will result in a 403 response code. Usage example:
     *
     *     throw $this->createAccessDeniedException('Unable to access this page!');
     *
     * @throws \LogicException If the Security component is not available
     */
    protected function createAccessDeniedException(string $message = 'Access Denied.', \Throwable $previous = null): AccessDeniedException
    {
        if (!class_exists(AccessDeniedException::class)) {
            throw new \LogicException('You can not use the "createAccessDeniedException" method if the Security component is not available. Try running "composer require symfony/security-bundle".');
        }

        return new AccessDeniedException($message, $previous);
    }

    /**
     * Creates and returns a Form instance from the type of the form.
     */
    protected function createForm(string $type, $data = null, array $options = []): FormInterface
    {
        return $this->container->get('form.factory')->create($type, $data, $options);
    }

    /**
     * Creates and returns a form builder instance.
     */
    protected function createFormBuilder($data = null, array $options = []): FormBuilderInterface
    {
        return $this->container->get('form.factory')->createBuilder(FormType::class, $data, $options);
    }

    /**
     * Shortcut to return the Doctrine Registry service.
     *
     * @throws \LogicException If DoctrineBundle is not available
     */
    protected function getDoctrine(): ManagerRegistry
    {
        if (!$this->container->has('doctrine')) {
            throw new \LogicException('The DoctrineBundle is not registered in your application. Try running "composer require symfony/orm-pack".');
        }

        return $this->container->get('doctrine');
    }

    /**
     * Get a user from the Security Token Storage.
     *
     * @return UserInterface|object|null
     *
     * @throws \LogicException If SecurityBundle is not available
     *
     * @see TokenInterface::getUser()
     */
    protected function getUser()
    {
        if (!$this->container->has('security.token_storage')) {
            throw new \LogicException('The SecurityBundle is not registered in your application. Try running "composer require symfony/security-bundle".');
        }

        if (null === $token = $this->container->get('security.token_storage')->getToken()) {
            return null;
        }

        if (!\is_object($user = $token->getUser())) {
            // e.g. anonymous authentication
            return null;
        }

        return $user;
    }

    /**
     * Checks the validity of a CSRF token.
     *
     * @param string      $id    The id used when generating the token
     * @param string|null $token The actual token sent with the request that should be validated
     */
    protected function isCsrfTokenValid(string $id, ?string $token): bool
    {
        if (!$this->container->has('security.csrf.token_manager')) {
            throw new \LogicException('CSRF protection is not enabled in your application. Enable it with the "csrf_protection" key in "config/packages/framework.yaml".');
        }

        return $this->container->get('security.csrf.token_manager')->isTokenValid(new CsrfToken($id, $token));
    }

    /**
     * Dispatches a message to the bus.
     *
     * @param object|Envelope $message The message or the message pre-wrapped in an envelope
     */
    protected function dispatchMessage($message, array $stamps = []): Envelope
    {
        if (!$this->container->has('messenger.default_bus')) {
            $message = class_exists(Envelope::class) ? 'You need to define the "messenger.default_bus" configuration option.' : 'Try running "composer require symfony/messenger".';
            throw new \LogicException('The message bus is not enabled in your application. '.$message);
        }

        return $this->container->get('messenger.default_bus')->dispatch($message, $stamps);
    }

    /**
     * Adds a Link HTTP header to the current response.
     *
     * @see https://tools.ietf.org/html/rfc5988
     */
    protected function addLink(Request $request, LinkInterface $link): void
    {
        if (!class_exists(AddLinkHeaderListener::class)) {
            throw new \LogicException('You can not use the "addLink" method if the WebLink component is not available. Try running "composer require symfony/web-link".');
        }

        if (null === $linkProvider = $request->attributes->get('_links')) {
            $request->attributes->set('_links', new GenericLinkProvider([$link]));

            return;
        }

        $request->attributes->set('_links', $linkProvider->withLink($link));
	}

	protected function check_rights($dept_id,$emp_id,$page_id,$option_type1)
    {
		$connection = $this->getDoctrine()->getManager()->getConnection();

		$check_rgts = "SELECT * FROM `menu_rights` where dept_id='".$dept_id."' and emp_id='".$emp_id."' and page_id='".$page_id."'";
		$CONNrgts = $connection->executeQuery($check_rgts);
		$FTCHrgts	= $CONNrgts->fetchAll();
		$add_option=0;
		if(count($FTCHrgts)>0){

		if($option_type1=='add'){
			$add_option=$FTCHrgts[0]['add_rights'];
		}
		if($option_type1=='edit'){
			$add_option=$FTCHrgts[0]['edit_rights'];
		}

		if($option_type1=='view'){
			$add_option=$FTCHrgts[0]['view_rights'];
		}

		if($option_type1=='status'){
			$add_option=$FTCHrgts[0]['status_rights'];
		}
	}

	if($add_option==''){
		$add_option=0;
	}

	if($emp_id=='1'){
		$add_option=1;
	}

	return $add_option;
	}

	protected function getEmpName($emp_id)
    {
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$QURYEmp	= "select * from employees where emp_id='".$emp_id."'";
		$CONNEmp	= $connection->executeQuery($QURYEmp);
		$FTCHEmp	= $CONNEmp->fetchAll();

		return $FTCHEmp[0]['emp_name'];

	}

	protected function getSubId($sub_name)
    {
		$connection = $this->getDoctrine()->getManager()->getConnection();

		$QURYCat	= "select * from subcategories where subcat_name='".$sub_name."'";
		$CONNCat	= $connection->executeQuery($QURYCat);
		$FTCHCat	= $CONNCat->fetchAll();

		return $FTCHCat[0]['id'];
	}

	protected function getSubCatName($cat_id,$sub_id)
    {
		$connection = $this->getDoctrine()->getManager()->getConnection();

		$QURYSCat	= "select * from subcategories where cat_id='".$cat_id."' and id='".$sub_id."'";
		$CONNSCat	= $connection->executeQuery($QURYSCat);
		$FTCHSCat	= $CONNSCat->fetchAll();

		return $FTCHSCat[0]['subcat_name'];
	}

	protected function notify_count(){
		$connection = $this->getDoctrine()->getManager()->getConnection();	
		$check_vrgts = "SELECT * FROM `tempemployees` where approval_status='0' group by emp_id";
		$CONNvrgts   = $connection->executeQuery($check_vrgts);
		$FTCHvrgts	 = $CONNvrgts->fetchAll();

		$check_prdts1 = "SELECT * FROM `tempproducts` where approve_status='0' and record_type!='0' group by product_id";
		$CONNvrgts1   = $connection->executeQuery($check_prdts1);
		$FTCHvrgts1	  = $CONNvrgts1->fetchAll();

		$session = $this->container->get('session');
		$sessionId  = $session->get('empId');
		$cnt_msg ='';
		if($sessionId=='1'){
			$cnt_msg =  count($FTCHvrgts)+count($FTCHvrgts1);
		} 

		return $cnt_msg;
	}

	protected function notify_count_user(){
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$session = $this->container->get('session');
		$sessionId  = $session->get('empId');

		$check_vrgts = "SELECT * FROM `tempemployees` where approval_status='1' and emp_id='".$sessionId."' and notify_message='0' group by emp_id";
		$CONNvrgts   = $connection->executeQuery($check_vrgts);
		$FTCHvrgts	 = $CONNvrgts->fetchAll();

		$check_vrgts1 = "SELECT * FROM `tempproducts` where approve_status!='0' and requested_by='".$sessionId."' and notify_message='0'";
		$CONNvrgts1   = $connection->executeQuery($check_vrgts1);
		$FTCHvrgts1	 = $CONNvrgts1->fetchAll();

		$cnt_msg ='';
		if($sessionId!='1'){
			$cnt_msg =  count($FTCHvrgts)+count($FTCHvrgts1);
		}
		return $cnt_msg;
	}

	protected function notify_messages(){
		$connection = $this->getDoctrine()->getManager()->getConnection();

		$session = $this->container->get('session');
		$sessionId  = $session->get('empId');
		$check_vrgts = "SELECT * FROM `tempemployees` where approval_status='0' group by emp_id";
		$CONNvrgts   = $connection->executeQuery($check_vrgts);
		$FTCHvrgts	 = $CONNvrgts->fetchAll();
		$message_html='';
		foreach($FTCHvrgts as $fr){
			$empid = $fr['emp_id'];
			$temp_id = $fr['temp_id'];
			$req_date = $fr['request_date'];
			$req_date_arr = explode(" ",$fr['request_date']);
			$time = strtotime($req_date_arr[0]);
			$time_arr = explode(" ",$fr['request_date']);
			$time1 = $time_arr[1];

			$newformat = date("M d, y",$time).'&nbsp;-&nbsp;('.date('D', strtotime($fr['request_date'])).')&nbsp;-&nbsp;'.date('h:i A',strtotime($req_date_arr[1]));

			$check_emp = "SELECT * FROM `employees` where emp_id='".$fr['emp_id']."'";
			$CONNemp   = $connection->executeQuery($check_emp);
			$FTCHemp   = $CONNemp->fetchAll();
			$img_name = '/employees/'.$FTCHemp[0]['profile_photo'];
			$emp_name_org = $FTCHemp[0]['emp_name'];

			$emp_len = strlen($emp_name_org);

			if($emp_len>20){
				$emp_name = substr($emp_name_org,0,20).'...';
			} else {
				$emp_name = $emp_name_org;
			}
			if($sessionId=='1'){
			$message_html .= '<li class="notification-unread" style="notify_'.$temp_id.'">
                              <a href="/requested-profile/'.$empid.'">
                              <img class="float-left mr-3 avatar-img" src="'.$img_name.'" alt="">
                              <div class="notification-content">
                              <div class="notification-heading" title="'.$emp_name_org.'">'.$emp_name.'</div>
								<div class="notification-timestamp">'.$newformat.'</div>
								<div class="notification-text">Requested to update their profile.</div>
							</div>
						</a>
						</li>';
			}
		}

		// For products notifications 

		$check_vrgts = "SELECT * FROM `tempproducts` where approve_status='0' and record_type!='0' group by product_id";
		$CONNvrgts   = $connection->executeQuery($check_vrgts);
		$FTCHvrgts	 = $CONNvrgts->fetchAll();
		//$message_html .=$check_vrgts;
		foreach($FTCHvrgts as $fr){
			$prd_id = $fr['product_id'];
			$req_date = $fr['requested_date'];
			$req_date_arr = explode(" ",$fr['requested_date']);
			$time = strtotime($req_date_arr[0]);
			$time_arr = explode(" ",$fr['requested_date']);
			$time1 = $time_arr[1];

			$newformat = date("M d, y",$time).'&nbsp;-&nbsp;('.date('D', strtotime($fr['requested_date'])).')&nbsp;-&nbsp;'.date('h:i A',strtotime($req_date_arr[1]));

			$check_prod = "SELECT * FROM `products` where product_id ='".$prd_id."'";
			$CONNprod   = $connection->executeQuery($check_prod);
			$FTCHprod   = $CONNprod->fetchAll();
			$pname = $FTCHprod[0]['product_name'];

			$check_emp = "SELECT * FROM `employees` where emp_id='".$fr['requested_by']."'";
			$CONNemp   = $connection->executeQuery($check_emp);
			$FTCHemp   = $CONNemp->fetchAll();
			$img_name = '/employees/'.$FTCHemp[0]['profile_photo'];
			$emp_name_org = $FTCHemp[0]['emp_name'];

			$emp_len = strlen($emp_name_org);

			if($emp_len>20){
				$emp_name = substr($emp_name_org,0,20).'...';
			} else {
				$emp_name = $emp_name_org;
			}
			if($sessionId=='1'){
			$message_html .= '<li class="notification-unread" style="notify_'.$temp_id.'">
                              <a href="/request-edit-prod/'.$prd_id.'">
                              <img class="float-left mr-3 avatar-img" src="'.$img_name.'" alt="">
                              <div class="notification-content">
                              <div class="notification-heading" title="'.$emp_name_org.'">'.$emp_name.'</div>
								<div class="notification-timestamp">'.$newformat.'</div>
								<div class="notification-text">Requested to update '.$pname.' product details.</div>
							</div>
						</a>
						</li>';
			}
		}
		return $message_html;
	}

	protected function notify_messages_user(){
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$session = $this->container->get('session');
		$sessionId  = $session->get('empId');
		$check_vrgts = "SELECT * FROM `tempemployees` where approval_status='1' and emp_id='".$sessionId."' and notify_message='0' group by emp_id";
		$CONNvrgts   = $connection->executeQuery($check_vrgts);
		$FTCHvrgts	 = $CONNvrgts->fetchAll();
		$message_html='';
		foreach($FTCHvrgts as $fr){
			$empid = $fr['emp_id'];
			$tempid = $fr['temp_id'];
			$req_date = $fr['approval_date'];
			$req_date_arr = explode(" ",$fr['approval_date']);
			$time = strtotime($req_date);
			$time_arr = explode(" ",$fr['approval_date']);
			$time1 = $time_arr[1];
			$newformat = date("M d, y",$time).'&nbsp;-&nbsp;('.date('D', strtotime($time)).')&nbsp;-&nbsp;'.date('h:i A',strtotime($req_date_arr[1]));

			$check_emp = "SELECT * FROM `employees` where emp_id='".$fr['emp_id']."'";
			$CONNemp   = $connection->executeQuery($check_emp);
			$FTCHemp   = $CONNemp->fetchAll();
			$img_name = '/employees/'.$FTCHemp[0]['profile_photo'];
			$emp_name_org = $FTCHemp[0]['emp_name'];
			$emp_len = strlen($emp_name_org);

			if($emp_len>20){
				$emp_name = substr($emp_name_org,0,20).'...';
			} else {
				$emp_name = $emp_name_org;
			}
			if($sessionId!='1'){
			$message_html .= '<li class="notification-unread" style="notify_'.$temp_id.'">
								<a href="javascript:void()">
									<span class="mr-3 avatar-icon bg-danger-lighten-2"><i class="icon-present"></i></span>
									<div class="notification-content">
								<h6 class="notification-heading">Admin Approved you profile request.</h6>
								<span class="notification-text">'.$newformat.'</span>
								</div>
								</a><span style="float:right; vertical-align:top; margin-top: -60px;"><a href="javascript:;" onclick="hide_notify('.$tempid.');">X</a></span>
							</li>';
			}
		}

		// For product logs

		$check_vrgts = "SELECT * FROM `tempproducts` where approve_status!='0' and requested_by='".$sessionId."' and notify_message='0'";
		$CONNvrgts   = $connection->executeQuery($check_vrgts);
		$FTCHvrgts	 = $CONNvrgts->fetchAll();
		foreach($FTCHvrgts as $fr){
			$tempid = $fr['temp_id'];
			$req_date = $fr['approval_date'];
			$req_date_arr = explode(" ",$fr['approval_date']);
			$time = strtotime($req_date);
			$time_arr = explode(" ",$fr['approval_date']);
			$time1 = $time_arr[1];
			$newformat = date("M d, y",$time).'&nbsp;-&nbsp;('.date('D', strtotime($time)).')&nbsp;-&nbsp;'.date('h:i A',strtotime($req_date_arr[1]));

			$app_status = 'Approved';

			if($fr['approve_status']=='2'){
				$app_status = 'Cancelled';
			}
			if($sessionId!='1'){
			$message_html .= '<li class="notification-unread" style="notify_'.$temp_id.'">
								<a href="javascript:void()">
									<span class="mr-3 avatar-icon bg-danger-lighten-2"><i class="icon-present"></i></span>
									<div class="notification-content">
								<h6 class="notification-heading">Admin '.$app_status.' your product request.</h6>
								<span class="notification-text">'.$newformat.'</span> 
								</div>
								</a><span style="float:right;vertical-align: top;margin-top: -60px;"><a href="javascript:;" onclick="hide_notify_prod('.$tempid.');">X</a></span>
							</li>';
			}
		}

		return $message_html;
	}

	protected function check_views($emp_id)
    {
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$view_option = array();

		if($emp_id=='1'){
			$check_vrgts = "SELECT * FROM `menu_pages`";
			$CONNvrgts   = $connection->executeQuery($check_vrgts);
			$FTCHvrgts	 = $CONNvrgts->fetchAll();
			if(count($FTCHvrgts)>0){
				foreach($FTCHvrgts as $rgths){
					$pageId = $rgths['menu_page_id'];
					$view_option[]=$pageId;
				}
			}
		} else {
			$check_vrgts = "SELECT page_id,view_rights FROM `menu_rights` where emp_id='".$emp_id."' and view_rights='1'";
			$CONNvrgts = $connection->executeQuery($check_vrgts);
			$FTCHvrgts	= $CONNvrgts->fetchAll();
			if(count($FTCHvrgts)>0){
				foreach($FTCHvrgts as $rgths){
					$pageId = $rgths['page_id'];
					$view_option[]=$pageId;
				}
			}
		}
	return $view_option;
	}

	protected function browse_cat()
    {
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$QURYMenu	= "select * from categories where status='0' and cat_id IN(select cat_id from products where status='0') order by cat_id desc";
		$CONNMenu	= $connection->executeQuery($QURYMenu);
		$FTCHMenu	= $CONNMenu->fetchAll();

		return $FTCHMenu;
	}

	protected function menu_cats()
    {
		$connection = $this->getDoctrine()->getManager()->getConnection();

		//$QURYMenu	= "SELECT * FROM `categories` WHERE status='0' and cat_id IN(SELECT cat_id FROM subcategories WHERE status='0') order by cat_id desc";
		$QURYMenu	= "SELECT * FROM `categories` WHERE status='0' and cat_id IN(SELECT cat_id FROM products WHERE status='0') order by cat_id desc";
		$CONNMenu	= $connection->executeQuery($QURYMenu);
		$FTCHMenu	= $CONNMenu->fetchAll();

		return $FTCHMenu;
	}
	protected function menulists($cat_id)
    {
		$connection = $this->getDoctrine()->getManager()->getConnection();

		//$QURYMenu	= "select s.* from subcategories s, products p where s.cat_id='".$cat_id."' and s.status='0' and s.id=p.subcat_id and p.status='0'";

		$QURYMenu	= "select * from subcategories where cat_id='".$cat_id."' and status='0' and id IN(select subcat_id from products where status='0')";
		$CONNMenu	= $connection->executeQuery($QURYMenu);
		$FTCHMenu	= $CONNMenu->fetchAll();
		$submenu_arr = array();
		foreach($FTCHMenu as $cmnu){
			$submenu_arr[] = $cmnu['subcat_name'];
		}
		return $submenu_arr;
	}

	protected function productMenu()
    {
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$QURYMenu	= "select * from products where cat_id='4' and status='0' order by disp_by";
		$CONNMenu	= $connection->executeQuery($QURYMenu);
		$FTCHMenu	= $CONNMenu->fetchAll();
		$prod_list = '';
		foreach($FTCHMenu as $cmnu){
			$prd_link = $cmnu['product_name']."/".$cmnu['product_id'];
			$prod_list .= '<li><a href="/product/'.$prd_link.'">'.$cmnu['product_name'].'</a></li>';
		}
		return $prod_list;
	}
	protected function cart_total_old($login_id)
    {
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$total_cart = '';

		$QURYCart = "SELECT sum(total_price) as TP FROM cart where login_id ='".$login_id."' and status='0'";
		$CONNCart	= $connection->executeQuery($QURYCart);
		$FTCHCart	= $CONNCart->fetchAll();

		return number_format($FTCHCart[0]['TP'],2);
	}
	protected function cart_total($login_id)
    {
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$total_cart = '';

		$QURYCart = "SELECT * FROM cart where login_id ='".$login_id."'  and status='0'";
		$CONNCart	= $connection->executeQuery($QURYCart);
		$FTCHCart	= $CONNCart->fetchAll();
		$ctotal=0;
		foreach($FTCHCart as $crts){
				$ctotal = $ctotal+$crts['total_price'];
		}
		return number_format($ctotal,2);
	}

	protected function pro_img_url()
    {
		$pro_img_url = 'https://mngpro.fotindia.com/products/';
		return $pro_img_url;
	}
	
	protected function gen_img_url()
    {
		$gen_img_url = 'https://mngpro.fotindia.com/';
		return $gen_img_url;
	}
	protected function check_stock($product_id,$weight_id)
    {
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$QURYStock = "SELECT * from stock_details where product_id='".$product_id."' and product_weight_id='".$weight_id."'  and status='0'";
		$CONNStock	= $connection->executeQuery($QURYStock);
		$FTCHStock	= $CONNStock->fetchAll();
		if(count($FTCHStock)>0){
			$stock_det =1;
		} else {
			$stock_det =0;
		}
		return $stock_det;
	}
	protected function getStates($state_name='')
    {
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$QURYStates = "select * from state_table";
		$CONNStates	= $connection->executeQuery($QURYStates);
		$FTCHStates	= $CONNStates->fetchAll();
		$state_list='';
		if($state_name==''){
			$state_name = 'Tamil Nadu';
		}

		foreach($FTCHStates as $states){
			if($state_name==$states['State_name']){
				$state_list .='<option selected value="'.$states['State_name'].'">'.$states['State_name'].'</option>';
			} else {
				$state_list .='<option  value="'.$states['State_name'].'">'.$states['State_name'].'</option>';
			}
		}
		return $state_list;
	}

	protected function getCities_start($stname,$city_name='')
    {
		$connection   = $this->getDoctrine()->getManager()->getConnection();
	    if($stname==''){
			$stname = 'Tamil Nadu';
		}

		$QURYStates1 = "select * from state_table where State_name='".$stname."'";
		$CONNStates1	= $connection->executeQuery($QURYStates1);
		$FTCHStates1	= $CONNStates1->fetchAll();

		$QURYStates = "select * from district_table where State_key='".$FTCHStates1[0]['State_key']."'";
		$CONNStates	= $connection->executeQuery($QURYStates);
		$FTCHStates	= $CONNStates->fetchAll();
		$city_list ='<option value="">--Select City--</option>';
		foreach($FTCHStates as $states){
			if($city_name==$states['District_name']){
				$city_list .='<option selected value="'.$states['District_name'].'">'.$states['District_name'].'</option>';
			} else {
				$city_list .='<option value="'.$states['District_name'].'">'.$states['District_name'].'</option>';
			}
		}
		return $city_list;
	}
	protected function getShipmentToken()
    {
		$curl = curl_init();
		curl_setopt_array($curl, array(
		CURLOPT_URL => "https://apiv2.shiprocket.in/v1/external/auth/login",
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => "",
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 0,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => "POST",
		CURLOPT_POSTFIELDS =>"{\n    \"email\": \"deepak@ksit.tech\",\n    \"password\": \"Deepak@123\"\n}",
		CURLOPT_HTTPHEADER => array(
		  "Content-Type: application/json"
		),
	  ));
	  $SR_login_Response = curl_exec($curl);
	  curl_close($curl);
	  $SR_login_Response_out = json_decode($SR_login_Response);
	  //print_r($SR_login_Response_out);
	  return $token = $SR_login_Response_out->{'token'};
	}

protected function cart_index_header($login_id)
    {
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$shop_html='';
		$cart_pr = array('1'=>'Pack of 1','2'=>'Pack of 3','3'=>'Pack of 5');
		$pro_img_url = $this->pro_img_url();

		$session = $this->container->get('session');
		$sessionId  = $session->get('loginId');
		if($sessionId!=''){
		$QURYCart = "SELECT ct.*,p.* FROM cart ct,products p where ct.login_id='".$login_id."' and ct.product_id=p.product_id and ct.status='0' order by ct.cart_id desc";
		$CONNCart	= $connection->executeQuery($QURYCart);
		$FTCHCart	= $CONNCart->fetchAll();
		$ccount = count($FTCHCart);
		$total_cprice=0;
		$shop_html = '
      <button class="closeButton border-theme bg-theme-hover sideMenuCls" ><i class="far fa-times"></i></button>
      <div class="widget widget_shopping_cart">
        <h3 class="widget_title">Shopping cart</h3><div class="widget_shopping_cart_content">';
		if($ccount>0){
			$shop_html .='

          <ul class="cart_list">';
		  $ct=0;
		foreach($FTCHCart as $crt){
			$disc_val = $this->discount_price();
		  $act_price = $crt['prd_price']-($crt['prd_price']*$disc_val)/100;
			$total_cprice = $total_cprice+($crt['prd_qty']*$act_price);

			$pack_name = $cart_pr[$crt['pack_id']];
			
			$QURYCart2 = "SELECT wgt_grms FROM product_weights where id='".$crt['weight_id']."'";
			$CONNCart2	= $connection->executeQuery($QURYCart2);
			$FTCHCart2	= $CONNCart2->fetchAll();
			$wname = $FTCHCart2[0]['wgt_grms'];
			//$rtotal = $crt['prd_qty']*$crt['prd_price'];
			$rtotal = $crt['prd_qty']*$act_price;

			$shop_html .= '<li class="mini_cart_item" id="cart_'.$crt['cart_id'].'"><a href="javascript:;" class="remove" title="Remove Product" onclick="remove_hcart(\''.$crt['cart_id'].'\',\''.$login_id.'\');" style="top: 17%; left: 97%;"><i class="fal fa-trash-alt"></i></a>
			<input type="hidden" size="3" id="prc_'.$ct.'" value="'.$act_price.'">
			  <a href="javascript:;"><img src="'.$pro_img_url.$crt['prd_image'].'" alt="Cart Image">'.$crt['product_name'].'</a>
			  <span style="font-size:13px; letter-spacing:1px; color:gray; font-weight:600;">('.$pack_name.' - '.$wname.'g)</span><br>
			  <div class="cart_table quantity" style="margin-bottom:0px !important;">
				<button class="quantity-minus qut-btn" onclick="add_to_cart_dec(\''.$crt['product_id'].'\',\''.$crt['weight_id'].'\',\''.$ct.'\');"><i class="far fa-minus quantity-minus"></i> </button> 
				<input type="number" class="qty-input qIt1" value="'.$crt['prd_qty'].'" min="0" max="99" readonly="" style="border:2px solid gray" id="quantity'.$ct.'">
				<button class="quantity-plus qut-btn" onclick="add_to_cart_inc(\''.$crt['product_id'].'\',\''.$crt['weight_id'].'\',\''.$ct.'\');"> <i class="far fa-plus"></i> </button><!--&nbsp;&nbsp;×--> <span class="amount" style="font-weight:600; color:#666666;">&nbsp;&nbsp; Rs.'.number_format($act_price,2).' <del  style="font-weight:400; color:gray;">Rs.'.number_format($crt['prd_price'],2).'</del></span>
              </div>
              </span><br><span id="crtlist'.$ct.'" style="font-weight:500; color:#000000; font-size:14px;">Rs. '.number_format($rtotal,2).'
            </li>';
			$ct++;
		}

		$total_cprice = number_format($total_cprice,2);
        $shop_html .='</ul>
          <div class="total">
            <strong>Cart Total:</strong> <span class="amount"><span>Rs.</span><span id="sprice">'.$total_cprice.'</span></span>
          </div><div class="buttons">
            <a href="/checkout" class="vs-btn style4">Checkout</a>
          </div>
        </div>
      </div>';
		} else {
			$shop_html .='Your cart is empty';
		}
		$shop_html .='</div>';
		} else {
			$QURYCart = "SELECT ct.*,p.* FROM temp_cart ct,products p where ct.login_id='".$login_id."' and ct.product_id=p.product_id and ct.status='0' order by ct.tempcart_id desc";
		$CONNCart	= $connection->executeQuery($QURYCart);
		$FTCHCart	= $CONNCart->fetchAll();
		$ccount = count($FTCHCart);
		$total_cprice=0;
		$shop_html = '
      <button class="closeButton border-theme bg-theme-hover sideMenuCls" ><i class="far fa-times"></i></button>
      <div class="widget widget_shopping_cart">
        <h3 class="widget_title">Shopping cart</h3><div class="widget_shopping_cart_content">';
		if($ccount>0){
			$shop_html .='
          <ul class="cart_list">';
		/*foreach($FTCHCart as $crt){
			$total_cprice = $total_cprice+($crt['prd_qty']*$crt['prd_price']);
			$pack_name = $cart_pr[$crt['pack_id']];
			
			$QURYCart2 = "SELECT wgt_grms FROM product_weights where id='".$crt['weight_id']."'";
			$CONNCart2	= $connection->executeQuery($QURYCart2);
			$FTCHCart2	= $CONNCart2->fetchAll();
			$wname = $FTCHCart2[0]['wgt_grms'];
			$rtotal = $crt['prd_qty']*$crt['prd_price'];
			
			$shop_html .= '<li class="mini_cart_item" id="cart_'.$crt['tempcart_id'].'">
              <a href="javascript:;" class="remove" title="Remove Product" onclick="remove_hcart_temp(\''.$crt['tempcart_id'].'\',\''.$login_id.'\');"><i class="fal fa-trash-alt"></i></a>
			  <a href="javascript:;"><img src="'.$pro_img_url.$crt['prd_image'].'" alt="Cart Image">'.$crt['product_name'].'</a>
			  <span style="font-size:13px; letter-spacing:1px; color:gray; font-weight:600;">('.$pack_name.' - '.$wname.'g)</span><br>
              <span class="quantity">
                '.$crt['prd_qty'].' × <span class="amount"><span>&nbsp; Rs.</span>'.number_format($crt['prd_price'],2).'</span>
              </span><br>Rs. '.number_format($rtotal,2).'
            </li>';
		}
		*/
		$ct=0;
		foreach($FTCHCart as $crt){
			//$total_cprice = $total_cprice+($crt['prd_qty']*$crt['prd_price']);
			$pack_name = $cart_pr[$crt['pack_id']];

			$QURYCart2 = "SELECT * FROM product_weights where id='".$crt['weight_id']."'";
			$CONNCart2	= $connection->executeQuery($QURYCart2);
			$FTCHCart2	= $CONNCart2->fetchAll();
			if(count($FTCHCart2)>0){
				$wname = $FTCHCart2[0]['wgt_grms'];
			} 

			$disc_val = $this->discount_price();
			$act_price = $FTCHCart2[0]['price']-($FTCHCart2[0]['price']*$disc_val)/100;
			$total_cprice = $total_cprice+($crt['prd_qty']*$act_price);

			//$rtotal = $crt['prd_qty']*$crt['prd_price'];
			$rtotal = $crt['prd_qty']*$act_price;

			$shop_html .= '<li class="mini_cart_item" id="cart_'.$crt['tempcart_id'].'"><input type="hidden" id="cart_'.$ct.'" value="'.$crt['tempcart_id'].'"><a href="javascript:;" class="remove" title="Remove Product" onclick="remove_hcart_temp(\''.$crt['tempcart_id'].'\',\''.$login_id.'\');" style="top: 17%; left: 97%;"><i class="fal fa-trash-alt"></i></a>
			<input type="hidden" size="3" id="prc_'.$ct.'" value="'.$act_price.'">
			  <a href="javascript:;"><img src="'.$pro_img_url.$crt['prd_image'].'" alt="Cart Image">'.$crt['product_name'].'</a>
			  <span style="font-size:13px; letter-spacing:1px; color:gray; font-weight:600;">('.$pack_name.' - '.$wname.'g)</span><br>
			  <div class="cart_table quantity" style="margin-bottom:0px !important;">
			 <button class="quantity-minus qut-btn" onclick="add_to_cart_dec(\''.$crt['product_id'].'\',\''.$crt['weight_id'].'\',\''.$ct.'\');"><i class="far fa-minus quantity-minus"></i> </button> 
				<input type="number" class="qty-input qIt1" value="'.$crt['prd_qty'].'" min="0" step="1" max="99" readonly="" style="border:2px solid gray" id="cquantity'.$ct.'">
				<button class="quantity-plus qut-btn" onclick="add_to_cart_inc(\''.$crt['product_id'].'\',\''.$crt['weight_id'].'\',\''.$ct.'\');"> <i class="far fa-plus"></i> </button><!--&nbsp;&nbsp;×--> <span class="amount"  id="amtdisp_'.$ct.'"  style="font-weight:600; color:#666666;">&nbsp;&nbsp; Rs.'.number_format($act_price,2).' <del style="font-weight:400; color:gray;">Rs.'.number_format($FTCHCart2[0]['price'],2).'</del></span>
              </div>
              </span><br><span id="crtlist'.$ct.'" style="font-weight:500; color:#000000; font-size:14px;">Rs.'.number_format($rtotal,2).'
            </li>';
			$ct++;
		}
		$total_cprice = number_format($total_cprice,2);
        $shop_html .='</ul>
          <div class="total">
            <strong>Cart Total:</strong> <span class="amount"><span>Rs.</span><span id="sprice">'.$total_cprice.'</span></span>
          </div><div class="buttons">
            <a href="/checkout" class="vs-btn style4">Checkout</a>
          </div>
        </div>
      </div>';
		} else {
			$shop_html .='Your cart is empty';
		}
		$shop_html .='</div>';
			
		}
		return $shop_html;
	}

protected function cart_index($login_id)
    {
	$connection = $this->getDoctrine()->getManager()->getConnection();
		$session = $this->container->get('session');
		$sessionId  = $session->get('loginId');
		$shop_html='';
		$cart_pr = array('1'=>'Pack of 1','2'=>'Pack of 3','3'=>'Pack of 5');
		$pro_img_url = 'https://mngpro.fotindia.com/products/';

		$disc_val = $this->discount_price();

		if($sessionId!=''){
		$QURYCart = "SELECT ct.*,p.* FROM cart ct,products p where ct.login_id='".$login_id."' and ct.product_id=p.product_id and ct.status='0' order by ct.cart_id desc";
		$CONNCart	= $connection->executeQuery($QURYCart);
		$FTCHCart	= $CONNCart->fetchAll();
		$ccount = count($FTCHCart);
		$total_cprice=0; //d-none
		$shop_html = '<div class="sideCart-wrapper offcanvas-wrapper  d-lg-block" id="sdecrt" style="z-index:9998;" >
    <div class="sidemenu-content" id="sidecart">
      <button class="closeButton border-theme bg-theme-hover sideMenuCls"><i class="far fa-times"></i></button>
      <div class="widget widget_shopping_cart">
        <h3 class="widget_title">Shopping cart</h3><div class="widget_shopping_cart_content">';
		if($ccount>0){
			$shop_html .='
          <ul class="cart_list">';
		$ct=0;
		foreach($FTCHCart as $crt){
			//$total_cprice = $total_cprice+($crt['prd_qty']*$crt['prd_price']);
			$pack_name = $cart_pr[$crt['pack_id']];

			$QURYCart2 = "SELECT * FROM product_weights where id='".$crt['weight_id']."'";
			$CONNCart2	= $connection->executeQuery($QURYCart2);
			$FTCHCart2	= $CONNCart2->fetchAll();
			if(count($FTCHCart2)>0){
				$wname = $FTCHCart2[0]['wgt_grms'];
			} 

			$disc_val = $this->discount_price();
			$act_price = $FTCHCart2[0]['price']-($FTCHCart2[0]['price']*$disc_val)/100;
			$total_cprice = $total_cprice+($crt['prd_qty']*$act_price);

			//$rtotal = $crt['prd_qty']*$crt['prd_price'];
			$rtotal = $crt['prd_qty']*$act_price;

			$shop_html .= '<li class="mini_cart_item" id="cart_'.$crt['cart_id'].'"><input type="hidden" id="cart_'.$ct.'" value="'.$crt['cart_id'].'"><a href="javascript:;" class="remove" title="Remove Product" onclick="remove_hcart(\''.$crt['cart_id'].'\',\''.$login_id.'\');" style="top: 17%; left: 97%;"><i class="fal fa-trash-alt"></i></a>
			<input type="hidden" size="3" id="prc_'.$ct.'" value="'.$act_price.'">
			  <a href="javascript:;"><img src="'.$pro_img_url.$crt['prd_image'].'" alt="Cart Image">'.$crt['product_name'].'</a>
			  <span style="font-size:13px; letter-spacing:1px; color:gray; font-weight:600;">('.$pack_name.' - '.$wname.'g)</span><br>
			  <div class="cart_table quantity" style="margin-bottom:0px !important;">
			 <button class="quantity-minus qut-btn" onclick="add_to_cart_dec(\''.$crt['product_id'].'\',\''.$crt['weight_id'].'\',\''.$ct.'\');"><i class="far fa-minus quantity-minus"></i> </button> 
				<input type="number" class="qty-input qIt1" value="'.$crt['prd_qty'].'" min="0" step="1" max="99" readonly="" style="border:2px solid gray" id="cquantity'.$ct.'">
				<button class="quantity-plus qut-btn" onclick="add_to_cart_inc(\''.$crt['product_id'].'\',\''.$crt['weight_id'].'\',\''.$ct.'\');"> <i class="far fa-plus"></i> </button><!--&nbsp;&nbsp;×--> <span class="amount"  id="amtdisp_'.$ct.'" style="font-weight:600; color:#666666;">&nbsp;&nbsp; Rs.'.number_format($act_price,2).' <del style="font-weight:400; color:gray;">Rs.'.number_format($FTCHCart2[0]['price'],2).'</del></span>
              </div>
              </span><br><span id="crtlist'.$ct.'" style="font-weight:500; color:#000000; font-size:14px;">Rs. '.number_format($rtotal,2).'
            </li>';
			$ct++;
		}

		$total_cprice = number_format($total_cprice,2);
        $shop_html .='</ul>
          <div class="total">
            <strong>Cart Total:</strong> <span class="amount"><span>Rs.</span><span id="sprice">'.$total_cprice.'</span></span>
          </div><div class="buttons">
            <a href="/checkout" class="vs-btn style4">Checkout</a>
          </div>
        </div>
      </div>';
		} else {
			$shop_html .='Your cart is empty';
		}
		$shop_html .='</div>
        </div>
      </div>';
		} else {
			$login_id = $session->get('temp_id');
		$QURYCart = "SELECT ct.*,p.* FROM temp_cart ct,products p where ct.login_id='".$login_id."' and ct.product_id=p.product_id and ct.status='0' order by ct.tempcart_id desc";
		$CONNCart	= $connection->executeQuery($QURYCart);
		$FTCHCart	= $CONNCart->fetchAll();
		$ccount = count($FTCHCart);
		$total_cprice=0; //d-none
		$shop_html = '<div class="sideCart-wrapper offcanvas-wrapper  d-lg-block" id="sdecrt1" style="z-index:9998;">
    <div class="sidemenu-content" id="sidecart">
      <button class="closeButton border-theme bg-theme-hover sideMenuCls"><i class="far fa-times"></i></button>
      <div class="widget widget_shopping_cart">
        <h3 class="widget_title">Shopping cart</h3><div class="widget_shopping_cart_content">';
		if($ccount>0){
			$shop_html .='
          <ul class="cart_list">';
		$ct=0;
		foreach($FTCHCart as $crt){
			//$total_cprice = $total_cprice+($crt['prd_qty']*$crt['prd_price']);
			$pack_name = $cart_pr[$crt['pack_id']];

			$QURYCart2 = "SELECT * FROM product_weights where id='".$crt['weight_id']."'";
			$CONNCart2	= $connection->executeQuery($QURYCart2);
			$FTCHCart2	= $CONNCart2->fetchAll();
			if(count($FTCHCart2)>0){
				$wname = $FTCHCart2[0]['wgt_grms'];
			} 

			$disc_val = $this->discount_price();
			$act_price = $FTCHCart2[0]['price']-($FTCHCart2[0]['price']*$disc_val)/100;
			$total_cprice = $total_cprice+($crt['prd_qty']*$act_price);

			//$rtotal = $crt['prd_qty']*$crt['prd_price'];
			$rtotal = $crt['prd_qty']*$act_price;

			$shop_html .= '<li class="mini_cart_item" id="cart_'.$crt['tempcart_id'].'"><input type="hidden" id="cart_'.$ct.'" value="'.$crt['tempcart_id'].'"><a href="javascript:;" class="remove" title="Remove Product" onclick="remove_hcart_temp(\''.$crt['tempcart_id'].'\',\''.$login_id.'\');" style="top: 17%; left: 97%;"><i class="fal fa-trash-alt"></i></a>
			<input type="hidden" size="3" id="prc_'.$ct.'" value="'.$act_price.'">
			  <a href="javascript:;"><img src="'.$pro_img_url.$crt['prd_image'].'" alt="Cart Image">'.$crt['product_name'].'</a>
			  <span style="font-size:13px; letter-spacing:1px; color:gray; font-weight:600;">('.$pack_name.' - '.$wname.'g)</span><br>
			  <div class="cart_table quantity" style="margin-bottom:0px !important;">
			 <button class="quantity-minus qut-btn" onclick="add_to_cart_dec_temp(\''.$crt['product_id'].'\',\''.$crt['weight_id'].'\',\''.$ct.'\');"><i class="far fa-minus quantity-minus"></i> </button> 
				<input type="number" class="qty-input qIt1" value="'.$crt['prd_qty'].'" min="0" step="1" max="99" readonly="" style="border:2px solid gray" id="cquantity'.$ct.'">
				<button class="quantity-plus qut-btn" onclick="add_to_cart_inc_temp(\''.$crt['product_id'].'\',\''.$crt['weight_id'].'\',\''.$ct.'\');"> <i class="far fa-plus"></i> </button><!--&nbsp;&nbsp;×--> <span class="amount"  id="amtdisp_'.$ct.'" style="font-weight:600; color:#666666;">&nbsp;&nbsp; Rs.'.number_format($act_price,2).' <del style="font-weight:400; color:gray;">Rs.'.number_format($FTCHCart2[0]['price'],2).'</del></span>
              </div>
              </span><br><span id="crtlist'.$ct.'" style="font-weight:500; color:#000000; font-size:14px;">Rs. '.number_format($rtotal,2).'
            </li>';
			$ct++;
		}

		$total_cprice = number_format($total_cprice,2);
        $shop_html .='</ul>
          <div class="total">
            <strong>Cart Total:</strong> <span class="amount"><span>Rs.</span><span id="sprice">'.$total_cprice.'</span></span>
          </div><div class="buttons">
            <a href="/checkout" class="vs-btn style4">Checkout</a>
          </div>
        </div>
      </div>';
		} else {
			$shop_html .= 'Your cart is empty';
		}
		$shop_html .='</div>
        </div>
      </div>';
		}
		return $shop_html;
	}

	protected function order_index($login_id)
    {
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$shop_html='';

		$pro_img_url = 'https://mngpro.fotindia.com/products/';
		$QURYCart = "SELECT ct.*,p.* FROM cart ct,products p where ct.login_id='".$login_id."' and ct.product_id=p.product_id and   ct.status='0' order by ct.cart_id desc";
		$CONNCart	= $connection->executeQuery($QURYCart);
		$FTCHCart	= $CONNCart->fetchAll();
		$ccount = count($FTCHCart);
		$total_cprice=0;
		if($ccount>0){
			$shop_html .='<div class="dropdown-cart-products" >';
		foreach($FTCHCart as $crt){
			$shop_html .='<div class="product" id="'.$crt['product_id'].'">
						<div class="product-cart-details">
							<h4 class="product-title">
							<a href="/product/'.$crt['product_name'].'/'.$crt['product_id'].'">'.$crt['product_name'].'</a>
							</h4>
							<span class="cart-product-info">
							<span class="cart-product-qty">'.$crt['prd_qty'].'</span>x Rs. '.number_format($crt['prd_price'],2).'
							</span>
						</div>
						<figure class="product-image-container">';
			$total_cprice = $total_cprice+$crt['total_price'];
			$shop_html .='<a href="javascript:void(0);" class="product-image"><img src="'.$pro_img_url.$crt['prd_image'].'" width="50" height="50" alt="product"></a></figure></div>';
		}
		$total_cprice = number_format($total_cprice,2);
        $shop_html .='</div><div class="dropdown-cart-total">
                      <span>Total</span><span class="cart-total-price">Rs. '.$total_cprice.'</span></div>';
		} 
		return $shop_html;
	}

	public function fname()
    {
		$fname = '';
		return $fname;
	}
	
	public function get_opt_id($cat_id){
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$QURYCat = "select * from design_cat where design_cat_id='".$cat_id."'";
		$CONNCat	= $connection->executeQuery($QURYCat);
		$FTCHCat	= $CONNCat->fetchAll();
		return $FTCHCat[0]['operation_type_id'];
	}
	
	public function get_opt_name($opt_id){
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$QURYCat = "select * from operation_type where operation_type_id='".$opt_id."'";
		$CONNCat	= $connection->executeQuery($QURYCat);
		$FTCHCat	= $CONNCat->fetchAll();
		return $FTCHCat[0]['operation_type_name'];
	}
	
	public function get_gender_name($gender_id){
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$QURYCat = "select * from genders where genders_id='".$gender_id."'";
		$CONNCat	= $connection->executeQuery($QURYCat);
		$FTCHCat	= $CONNCat->fetchAll();
		return $FTCHCat[0]['gender_name'];
	}

	public function get_subcat_name($scat_id){
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$QURYCat = "select * from design_subcat where design_subcat_id='".$scat_id."'";
		$CONNCat	= $connection->executeQuery($QURYCat);
		$FTCHCat	= $CONNCat->fetchAll();
		return $FTCHCat[0]['design_subcat_name'];
	}

	public function cart_count($party_id){
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$QURYCart = "select sum(coun_t) as cart_cnt from des_sel_temp where party_det_id='".$party_id."'";
		$CONNCart = $connection->executeQuery($QURYCart);
		$FTCHCart = $CONNCart->fetchAll();
		$cart_qty=0;
		if($FTCHCart[0]['cart_cnt']!='' ){
			$cart_qty = $FTCHCart[0]['cart_cnt'];
		}
		return $cart_qty;
	}

	public function cart_weight($party_id){
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$QURYCart = "select sum(tot_qty_wgt) as cart_wgt from cart where party_id='".$party_id."' and cart_status='0'";
		$CONNCart = $connection->executeQuery($QURYCart);
		$FTCHCart = $CONNCart->fetchAll();
		$cart_wgt1=0;
		if($FTCHCart[0]['cart_wgt']!='' ){
			$cart_wgt1 = number_format($FTCHCart[0]['cart_wgt'],2);
		}
		return $cart_wgt1;
	}

	public function opr_name($operation_type_id){
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$QURYCart = "select * from operation_type where operation_type_id='".$operation_type_id."'";
		$CONNCart = $connection->executeQuery($QURYCart);
		$FTCHCart = $CONNCart->fetchAll();
		$operation_type_name='';
		if(count($FTCHCart)>0){
			$operation_type_name = $FTCHCart[0]['operation_type_name'];
		}
		return $operation_type_name;
	}
	
	public function opr_id($operation_type_name){
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$QURYCart = "select * from operation_type where operation_type_name='".$operation_type_name."'";
		$CONNCart = $connection->executeQuery($QURYCart);
		$FTCHCart = $CONNCart->fetchAll();
		$operation_type_id='';
		if(count($FTCHCart)>0){
			$operation_type_id = $FTCHCart[0]['operation_type_id'];
		}
		return $operation_type_id;
	}
	public function getgender($genders_id){
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$QURYCart = "select * from genders where genders_id='".$genders_id."'";
		$CONNCart = $connection->executeQuery($QURYCart);
		$FTCHCart = $CONNCart->fetchAll();
		$design_cat_name='';
		if(count($FTCHCart)>0){
			$design_cat_name = $FTCHCart[0]['gender_name'];
		}
		return $design_cat_name;
	}
	public function getgenderId($genders_name){
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$QURYCart = "select * from genders where gender_name='".$genders_name."'";
		$CONNCart = $connection->executeQuery($QURYCart);
		$FTCHCart = $CONNCart->fetchAll();
		$genders_id='';
		if(count($FTCHCart)>0){
			$genders_id = $FTCHCart[0]['genders_id'];
		}
		return $genders_id;
	}
	public function getCatName($operation_type_id,$cat_id){
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$QURYCart = "select * from design_cat where operation_type_id='".$operation_type_id."' and design_cat_id='".$cat_id."'";
		$CONNCart = $connection->executeQuery($QURYCart);
		$FTCHCart = $CONNCart->fetchAll();
		$design_cat_name='';
		if(count($FTCHCart)>0){
			$design_cat_name = $FTCHCart[0]['design_cat_name'];
		}
		return $design_cat_name;
	}
	
	public function getCatId($operation_type_id,$cat_name){
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$QURYCart = "select * from design_cat where operation_type_id='".$operation_type_id."' and design_cat_name='".$cat_name."'";
		$CONNCart = $connection->executeQuery($QURYCart);
		$FTCHCart = $CONNCart->fetchAll();
		$design_cat_id='';
		if(count($FTCHCart)>0){
			$design_cat_id = $FTCHCart[0]['design_cat_id'];
		}
		return $design_cat_id;
	}
	public function mobile_menu(){
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$mob_menu='';
		$mob_menu .=' <li class="nav-mb-item">
                            <a href="#dropdown-menu-shop" class="collapsed mb-menu-link" data-bs-toggle="collapse"
                                aria-expanded="true" aria-controls="dropdown-menu-shop">
                                <span>eJCatalogue</span>
                                <span class="btn-open-sub"></span>
                            </a>
                            <div id="dropdown-menu-shop" class="collapse">
                                <ul class="sub-nav-menu">';
			$selopt1 = "select * from operation_type where role_status='1' and operation_type_id IN(select operation_type_id from designs where design_image_ext_1!='' group by operation_type_id)";
			$CONNopt1 = $connection->executeQuery($selopt1);
			$FTCHopt1 = $CONNopt1->fetchAll();
			foreach($FTCHopt1 as $opt1){
                $mob_menu .='<li>
                                        <a href="#sub-shop-styles'.$opt1['operation_type_id'].'" class="sub-nav-link collapsed"
                                            data-bs-toggle="collapse" aria-expanded="true"
                                            aria-controls="sub-shop-styles'.$opt1['operation_type_id'].'">
                                            <span>'.$opt1['operation_type_name'].'</span>
                                            <span class="btn-open-sub"></span>
                                        </a>
                                        <div id="sub-shop-styles'.$opt1['operation_type_id'].'" class="collapse">
                                            <ul class="sub-nav-menu sub-menu-level-2">';
				$selopt2 = "select * from design_cat where role_status='1' and operation_type_id='".$opt1['operation_type_id']."' and design_cat_id IN(select design_cat_id from designs where design_image_ext_1!='' and operation_type_id='".$opt1['operation_type_id']."' group by design_cat_id)";
				$CONNopt2 = $connection->executeQuery($selopt2);
				$FTCHopt2 = $CONNopt2->fetchAll();	
				foreach($FTCHopt2 as $opt2){
					$desginc = base64_encode($opt2['design_cat_id']);
					$mob_menu .='<li><a href="/showcase'.$desginc.'" class="sub-nav-link">'.$opt2['design_cat_name'].'</a></li>';
				}
                         $mob_menu .='</ul>
                                        </div>
                                    </li>';
            }                        
          $mob_menu .='</ul>
                            </div>';
        $mob_menu .='</li>';
		return $mob_menu;
	}

	public function getCatlistDropdown($search_by){
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$srch_qry = '';
		if($search_by!=''){
			$srch_qry .=" and MC.master_cad_type_id='".$search_by."'";
		}
		$QURYCat = "SELECT MC.* FROM mas_finishing AS MS,design_det AS DD,master_cat MC, show_Case as SC WHERE MS.design_det_id=DD.design_det_id AND DD.master_cat_id=MC.master_cat_id AND MS.design_det_id = SC.design_det_id  GROUP BY MC.cat_name ".$srch_qry." ORDER BY MC.master_cat_id ASC";
		$CONNCat = $connection->executeQuery($QURYCat);
		$FTCHCart = $CONNCat->fetchAll();
		return $FTCHCart;
	}

	// cart lists in header
	protected function header_cart($login_id)
    {
		$connection = $this->getDoctrine()->getManager()->getConnection();

		$shop_html='';

		$pro_img_url = 'https://mngpro.fotindia.com/products/';
		$QURYCart = "SELECT ct.*,p.* FROM cart ct,products p where ct.login_id='".$login_id."' and ct.product_id=p.product_id and ct.status='0' order  by ct.cart_id desc";
		$CONNCart	= $connection->executeQuery($QURYCart);
		$FTCHCart	= $CONNCart->fetchAll();
		$cart_count = count($FTCHCart);
		$shop_html .= '<div class="dropdown cart-dropdown" id="cartlists">
                            <a href="#" class="dropdown-toggle" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" data-display="static">
                                <i class="icon-shopping-cart"></i>
                                <span class="cart-count">'.$cart_count.'</span>
                            </a>';
		foreach($FTCHCart as $crt){
                     $shop_html .= '<div class="dropdown-menu dropdown-menu-right">
					<div class="dropdown-cart-products">
						<div class="product">
							<div class="product-cart-details">
								<h4 class="product-title">
									<a href="javascript:;">'.$crt['product_name'].'</a>
								</h4>
							<span class="cart-product-info">
								<span class="cart-product-qty">'.$crt['prd_qty'].'</span>
								x Rs. '.$crt['total_price'].'
							</span>
							</div>
							<figure class="product-image-container">
								<a href="javascript:;" class="product-image">
									<img src="'.$pro_img_url.$crt['prd_image'].'" alt="product">
								</a>
							</figure>
                        <a href="#" class="btn-remove" title="Remove Product"><i class="icon-close"></i></a></div>';
		}

		$shop_html .= '<div class="dropdown-cart-action">
                      <a href="/checkout" class="btn btn-outline-primary-2"><span>Checkout</span><i class="icon-long-arrow-right"></i></a>
                      </div>
                      </div>
                    </div>';
		return $shop_html;// new JsonResponse($shop_html);
	}


function resizer ($source, $destination, $size, $quality) : void {

// $source - Original image file
// $destination - Resized image file name
// $size - Single number for percentage resize
//         Array of 2 numbers for fixed width + height
// $quality - Optional image quality. JPG & WEBP = 0 to 100, PNG = -1 to 9

  // (A) CHECKS
  if (!file_exists($source)) { throw new Exception("Source image file not found"); }
  $sExt = strtolower(pathinfo($source)["extension"]);
  $dExt = strtolower(pathinfo($destination)["extension"]);
  $allowed = ["bmp", "gif", "jpg", "jpeg", "png", "webp"];
  if (!in_array($sExt, $allowed)) { throw new Exception("$sExt - Invalid image file type"); }
  if (!in_array($dExt, $allowed)) { throw new Exception("$dExt - Invalid image file type"); }
  if ($quality != null) {
    if (in_array($dExt, ["jpg", "jpeg", "webp"]) && ($quality<0 || $quality>100)) { $quality = 70; }
    if ($dExt == "png" && ($quality<-1 || $quality>9)) { $quality = -1; }
    if (!in_array($dExt, ["png", "jpg", "jpeg", "webp"])) { $quality = null; }
  }

  // (B) NEW IMAGE DIMENSIONS
  if (is_array($size)) {
    $new_width = $size[0];
    $new_height = $size[1];
  } else {
    $dimensions = getimagesize($source);
    $new_width = ceil(($size/100) * $dimensions[0]);
    $new_height = ceil(($size/100) * $dimensions[1]);
  }
  // (C) RESIZE
  $fnCreate = "imagecreatefrom" . ($sExt=="jpg" ? "jpeg" : $sExt);
  $original = $fnCreate($source);
  $resized = imagescale($original, $new_width, $new_height, IMG_BICUBIC);

  // (D) OUTPUT & CLEAN UP
  $fnOutput = "image" . ($dExt=="jpg" ? "jpeg" : $dExt);
  if (is_numeric($quality)) {
    $fnOutput($resized, $destination, $quality);
  } else {
    $fnOutput($resized, $destination);
  }
  imagedestroy($original);
  imagedestroy($resized);
}

}
