<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class VendorController extends AbstractController
{
    /**
     * @Route("/vendor-list", name="vendor-list")
     */
    public function vendorLISTact(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		########-[ GET VENDOR LIST
		$QURYlist	= "SELECT * FROM `vendor` ORDER BY `vid` DESC";
		$CONNlist	= $connection->executeQuery($QURYlist);
		$FTCHlist	= $CONNlist->fetchAll();
		
		return $this->render('vendor/vendor-list.html.twig', [
			'vendorList' => $FTCHlist,
			'controller_name' => 'VendorController'
        ]);
    }
	
	
    /**
     * @Route("/vendor-reg", name="vendor-reg")
     */
    public function vendorREGact(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		########-[ GET VID
		$QURYmaxVID			= "SELECT MAX(`vid`) AS v_id FROM `vendor`";
		$CONNmaxVID			= $connection->executeQuery($QURYmaxVID);
		$FTCHmaxVID			= $CONNmaxVID->fetchAll();
		$FTCHmaxVID['v_id'] = $FTCHmaxVID[0]['v_id'];
		
		if($request->getMethod() == 'POST')
		{
			$vid		= $request->get('vid');
			$metal_blnc	= $request->get('metal_blnc');
			$concern_nm	= $request->get('concern_name');
			$person_nm	= $request->get('person_name');
			$gst_no		= $request->get('gst_no');
			$mbl1		= $request->get('mbl1');
			$mbl2		= $request->get('mbl2');
			$email1		= $request->get('email1');
			$email2		= $request->get('email2');
			$door_no	= $request->get('door_no');
			$street1	= $request->get('street1');
			$street2	= $request->get('street2');
			$city		= $request->get('city');
			$state		= $request->get('state');
			$sessionId  = $session->get('empId');
			
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime = date("Y-m-d H:i:s");
			
			########-[ INSERT - DETAILS
			$QRinsert = "INSERT INTO `vendor`(`vid`, `metal_blnc`, `concern_name`, `vendor_name`, `gst_no`, `mbl1`, `mbl2`, `email1`, `email2`, `door_no`, `street1`, `street2`, `city`, `state`, `post_by`, `post_dt`) VALUES ('$vid','$metal_blnc','$concern_nm','$person_nm','$gst_no','$mbl1','$mbl2','$email1','$email2','$door_no','$street1','$street2','$city','$state','$sessionId','$nwDateTime')";
			$CNexecut = $connection->executeQuery($QRinsert);
			
			return $this->redirectToRoute('vendor-list');
		}
		
		return $this->render('vendor/vendor-reg.html.twig', [
			'maxVID' => $FTCHmaxVID,
			'controller_name' => 'VendorController'
        ]);
    }	


    /**
     * @Route("/vendor-dlt{vendor_dlt_id}", name="vendor-dlt")
     */
    public function vendorDLTact(Request $request, $vendor_dlt_id) 
    {	
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 	
		
		########-[ DELETE - DETAILS
		$QRdltPARTY = "DELETE FROM `vendor` WHERE `vendor_id`=".$vendor_dlt_id;
		$CNdltPARTY = $connection->executeQuery($QRdltPARTY);
		
		return $this->redirectToRoute('vendor-list');
	}	


    /**
     * @Route("/vendor-upt{vendor_upt_id}", name="vendor-upt")
     */
    public function vendorUPTact(Request $request, $vendor_upt_id) 
    {	
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 	
		
		########-[ GET UPDATE DATA
		$QURYuptDATA	= "SELECT * FROM `vendor` WHERE vendor_id = ".$vendor_upt_id;
		$CONNuptDATA	= $connection->executeQuery($QURYuptDATA);
		$FTCHuptDATA	= $CONNuptDATA->fetchAll();
		
		if($request->getMethod() == 'POST')
		{
			$metal_blnc	= $request->get('metal_blnc');
			$concern_nm	= $request->get('concern_name');
			$person_nm	= $request->get('person_name');
			$gst_no		= $request->get('gst_no');
			$mbl1		= $request->get('mbl1');
			$mbl2		= $request->get('mbl2');
			$email1		= $request->get('email1');
			$email2		= $request->get('email2');
			$door_no	= $request->get('door_no');
			$street1	= $request->get('street1');
			$street2	= $request->get('street2');
			$city		= $request->get('city');
			$state		= $request->get('state');
			$sessionId  = $session->get('empId');
			
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime = date("Y-m-d H:i:s");
			
			########-[ INSERT - DETAILS
			$QRuptDATA = "UPDATE `vendor` SET `metal_blnc`='$metal_blnc',`concern_name`='$concern_nm',`vendor_name`='$person_nm',`gst_no`='$gst_no',`mbl1`='$mbl1',`mbl2`='$mbl2',`email1`='$email1',`email2`='$email2',`door_no`='$door_no',`street1`='$street1',`street2`='$street2',`city`='$city',`state`='$state',`update_by`='$sessionId',`update_dt`='$nwDateTime' WHERE `vendor_id`=".$vendor_upt_id;
			$CNuptDATA = $connection->executeQuery($QRuptDATA);
			
			return $this->redirectToRoute('vendor-list');
		}
		
		return $this->render('vendor/vendor-upt.html.twig', [
			'vendorUPDTdata' => $FTCHuptDATA,
			'controller_name' => 'VendorController'
        ]);
	}	
}
