<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class TallyReportController extends AbstractController
{
    /**
     * @Route("/dept-wise-tally-report", name="dept-wise-tally-report") 
     */
    public function deptWiseTallyReportACT(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		date_default_timezone_set("Asia/Kolkata");
		$nwDate 	= date("Y-m-d");
		
		########-[ GET JC No
		$QURYjcNOlist	= "SELECT JC.po_open_ord_det_id, JC.jc_no, CONCAT(PO.po_open_ord_code,'',PO.po_open_ord_no) AS poNO FROM `po_open_ord_det` AS JC, prod_iss_rec AS PIR, po_open_ord AS PO WHERE PIR.po_id = JC.po_open_ord_det_id AND JC.po_open_ord_id=PO.po_open_ord_id GROUP BY JC.jc_no ORDER BY JC.jc_no DESC";
		$CONNjcNOlist	= $connection->executeQuery($QURYjcNOlist);
		$FTCHjcNOlist	= $CONNjcNOlist->fetchAll();

		########-[ GET DEPT LIST
		$QURYdeptlist	= "SELECT `dept_id`, `dept_name` FROM `dept` WHERE `role_status`=1 AND `avail_dept`=1 ORDER BY `dept_name` ASC";
		$CONNdeptlist	= $connection->executeQuery($QURYdeptlist);
		$FTCHdeptlist	= $CONNdeptlist->fetchAll();
		
		if($request->getMethod() == 'POST')
		{
			$dept			= $request->get('dept');
			$jc_no			= $request->get('jc_no');
			$frm_date		= $request->get('frm_date');
			$frm_date 		= explode("-",$frm_date);
			$frm_date 		= $frm_date[2]."-".$frm_date[1]."-".$frm_date[0];
			$to_date		= $request->get('to_date');
			$to_date 		= explode("-",$to_date);
			$to_date 		= $to_date[2]."-".$to_date[1]."-".$to_date[0];
			
			if($dept != "" && $jc_no == "" && $request->get('frm_date') == "" && $request->get('to_date') == "")
			{

				$condition = "AND PIR.`dept_id`='$dept'";

				$condISSUE = "`dept_id`='$dept' AND `type`='iss'";
				$condRECVE = "`dept_id`='$dept' AND `type`='rec'";
				$condRECop = "`dept_id`='$dept' AND `type`='rec' AND `work_status`='1'";
			} 
			else if($dept == "" && $jc_no != "" && $request->get('frm_date') == "" && $request->get('to_date') == "")
			{

				$condition = "AND PIR.`po_id`='$jc_no'";

				$condISSUE = "`po_id`='$jc_no' AND `type`='iss'";
				$condRECVE = "`po_id`='$jc_no' AND `type`='rec'";
				$condRECop = "`po_id`='$jc_no' AND `type`='rec' AND `rec_wgt`!=''";
			} 
			elseif($dept != "" && $jc_no == "" &&  $request->get('frm_date') != "" && $request->get('to_date') != "")
			{
				$condition = "AND PIR.`dept_id`='$dept' AND PIR.`trans_date` BETWEEN '$frm_date' AND '$to_date'";
				
				$condISSUE = "`dept_id`='$dept' AND `type`='iss' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
				$condRECVE = "`dept_id`='$dept' AND `type`='rec' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
				$condRECop = "`dept_id`='$dept' AND `type`='rec' AND `rec_wgt`!='' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
			}
			elseif($dept == "" && $jc_no != "" && $request->get('frm_date') != "" && $request->get('to_date') != "")
			{
				$condition = "AND PIR.`po_id`='$jc_no' AND PIR.`trans_date` BETWEEN '$frm_date' AND '$to_date'";
				
				$condISSUE = "`type`='iss' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
				$condRECVE = "`type`='rec' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
				$condRECop = "`type`='rec' AND `rec_wgt`!='' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
			}	
			elseif($dept == "" && $jc_no == "" && $request->get('frm_date') != "" && $request->get('to_date') != "")
			{
				$condition = "AND PIR.`trans_date` BETWEEN '$frm_date' AND '$to_date'";
				
				$condISSUE = "`type`='iss' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
				$condRECVE = "`type`='rec' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
				$condRECop = "`type`='rec' AND `rec_wgt`!='' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
			}
			elseif($dept != "" && $jc_no != "" && $request->get('frm_date') != "" && $request->get('to_date') != "")
			{
				$condition = "AND PIR.`dept_id`='$dept' AND PIR.`po_id`='$jc_no' AND PIR.`trans_date` BETWEEN '$frm_date' AND '$to_date'";
				
				$condISSUE = "`type`='iss' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
				$condRECVE = "`type`='rec' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
				$condRECop = "`type`='rec' AND `rec_wgt`!='' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
			}		
			
			
			########-[ FETCH PROD TRAN - DEPT WISE REPORT WITH FILTER
			$QURYdeptREPORT	= "SELECT PIR.*, D.dept_name FROM `prod_iss_rec` AS PIR, dept AS D WHERE PIR.dept_id = D.dept_id ".$condition." GROUP BY PIR.trans_no ORDER BY PIR.trans_no ASC";
			$CONNdeptREPORT	= $connection->executeQuery($QURYdeptREPORT);
			$FTCHdeptREPORT	= $CONNdeptREPORT->fetchAll();
			$CONTdeptREPORT	= count($FTCHdeptREPORT) - 1;
			
			$deptDATAreport = "";
	
			for($i=0; $i<=$CONTdeptREPORT; $i++)
			{
				#--------[ ISS WGT
				$QURYissWGT	= "SELECT SUM(`wgt`) AS issWGT FROM `prod_iss_rec` WHERE `type`='iss' AND `trans_no`='".$FTCHdeptREPORT[$i]['trans_no']."'";
				$CONNissWGT	= $connection->executeQuery($QURYissWGT);
				$FTCHissWGT	= $CONNissWGT->fetchAll();
				$RSLTissWGT	= number_format($FTCHissWGT[0]['issWGT'], 3);
				
				#--------[ REC ORNAMENT WGT
				$QURYrecWGT	= "SELECT SUM(`wgt`) AS recORNwgt FROM `prod_iss_rec` WHERE `type`='rec' AND `trans_no`='".$FTCHdeptREPORT[$i]['trans_no']."'";
				$CONNrecWGT	= $connection->executeQuery($QURYrecWGT);
				$FTCHrecWGT	= $CONNrecWGT->fetchAll();
				$RSLTrecORN	= number_format($FTCHrecWGT[0]['recORNwgt'], 3);
				
				#--------[ REC RECOVERY WGT
				$QURYrecWGT	= "SELECT SUM(`rec_wgt`) AS recRECOVwgt FROM `prod_iss_rec` WHERE `type`='rec' AND `trans_no`='".$FTCHdeptREPORT[$i]['trans_no']."'";
				$CONNrecWGT	= $connection->executeQuery($QURYrecWGT);
				$FTCHrecWGT	= $CONNrecWGT->fetchAll();
				$RSLTrecRECO= number_format($FTCHrecWGT[0]['recRECOVwgt'], 3);
				$RSLTrecWGT	= number_format(($RSLTrecORN + $RSLTrecRECO), 3);
				
				
				$deptDATAreport	.='<tr>
									<td title="Transaction No." style="text-align:left; vertical-align:middle;">'.($i+1).'</td>
									<td title="Transaction No." style="text-align:left; vertical-align:middle;">'.$FTCHdeptREPORT[$i]['trans_no'].'</td>
									<td title="Date of Transaction" style="text-align:left; vertical-align:middle;">'.date("M d, Y",strtotime($FTCHdeptREPORT[$i]['trans_date'])).'</td>
									<td title="Department" style="text-align:left; vertical-align:middle;">'.$FTCHdeptREPORT[$i]['dept_name'].'</td>';
	//			$deptDATAreport	.= '<td title="Ord Quantity" style="text-align:center; vertical-align:middle;">Ord Qty</td>';
				$deptDATAreport	.= '<td title="Iss Weight (grams)" style="text-align:right; vertical-align:middle;">'.$RSLTissWGT.'</td>
									<td title="Rec Weight (grams)" style="text-align:right; vertical-align:middle;">'.$RSLTrecORN.'</td>';
	//			$deptDATAreport	.= '<td title="Rec Weight (grams)" style="text-align:right; vertical-align:middle;">'.$RSLTrecRECO.'</td>';
				$deptDATAreport	.= '<td title="Wastage" style="text-align:right; vertical-align:middle;">'.(number_format($RSLTissWGT - $RSLTrecORN, 3)).'</td>';
// 				$deptDATAreport	.= '<td title="Wastage (%) per Piece" style="text-align:right; vertical-align:middle;">Wastage/Pcs <small>(%)</small></td>';
			 $deptDATAreport	.='</tr>';
			}			
			
			########-[ FETCH - ISSUE WEIGHT
			$QURYissWEIGHT	= "SELECT SUM(`wgt`) AS TOTissWgt, SUM(`st_wt`) AS TOTissStWgt FROM `prod_iss_rec` WHERE ".$condISSUE;
			$CONNissWEIGHT	= $connection->executeQuery($QURYissWEIGHT);
			$FTCHissWEIGHT	= $CONNissWEIGHT->fetchAll();
			$TOTissWgt		= $FTCHissWEIGHT[0]['TOTissWgt'];
			$TOTissStWgt	= $FTCHissWEIGHT[0]['TOTissStWgt'];			
			
			########-[ FETCH - RECEIVE WEIGHT
			$QURYrecWEIGHT	= "SELECT SUM(`wgt`) AS TOTrecWgt, SUM(`st_wt`) AS TOTrecStWgt FROM `prod_iss_rec` WHERE ".$condRECVE;
			$CONNrecWEIGHT	= $connection->executeQuery($QURYrecWEIGHT);
			$FTCHrecWEIGHT	= $CONNrecWEIGHT->fetchAll();
			$TOTrecWgt		= $FTCHrecWEIGHT[0]['TOTrecWgt'];	
			$TOTrecStWgt	= $FTCHrecWEIGHT[0]['TOTrecStWgt'];
			
			########-[ FETCH - RECEIVE WEIGHT with OPEN JOB
			$QURYrecOPwgt	= "SELECT SUM(`wgt`) AS TOTrecOPwgt FROM `prod_iss_rec` WHERE ".$condRECop;
			$CONNrecOPwgt	= $connection->executeQuery($QURYrecOPwgt);
			$FTCHrecOPwgt	= $CONNrecOPwgt->fetchAll();
			$TOTrecOPwgt	= number_format($FTCHrecOPwgt[0]['TOTrecOPwgt'], 2);
			
			########-[ FETCH - ST LOSS/PROFIT CAL
//			$STlossPROFIT	= -$TOTissStWgt + $TOTrecStWgt;
			$STlossPROFIT	= $TOTissStWgt - $TOTrecStWgt;
			$GETstlossPROFIT= substr($STlossPROFIT, 0,1);			
			
			########-[ FETCH - LOSS/PROFIT CAL
//			$lossPROFIT		= (-$TOTissWgt + $TOTrecWgt)+$STlossPROFIT;
			$lossPROFIT		= ($TOTissWgt - $TOTrecWgt)+$STlossPROFIT;
			$GETlossPROFIT  = substr($lossPROFIT, 0,1);			
		
			########-[ FETCH - OPEN JOB - DIFFERENCE
			if($FTCHrecOPwgt[0]['TOTrecOPwgt'] != 0)
			{
				$difference		= -$FTCHrecOPwgt[0]['TOTrecOPwgt'] + $lossPROFIT;
				$difference  	= number_format($difference, 2);
				$GETldiffLOSprf = substr($difference, 0,1);
			}
			else
			{
				$difference  	= "0.00";
			}
			
			if($GETlossPROFIT == "-")
			{
				$GETlossPROFIT = "Loss";	########- 1st letter is caps as same used in Lable also
			}
			else
			{
				$GETlossPROFIT = "Profit";	########- 1st letter is caps as same used in Lable also
			}
			
			if($GETstlossPROFIT == "-")
			{
				$GETstlossPROFIT = "Loss";	########- 1st letter is caps as same used in Lable also
			}
			else
			{
				$GETstlossPROFIT = "Profit";	########- 1st letter is caps as same used in Lable also
			}			
			
			if($GETldiffLOSprf == "-")
			{
				$GETldiffLOSprf = "Loss";	########- 1st letter is caps as same used in Lable also
			}
			else
			{
				$GETldiffLOSprf = "Profit";	########- 1st letter is caps as same used in Lable also
			}			
			
			########-[ PERCENTAGE
			$percentage		= "91.75%";	
			$perc			= 91.75;	
			
			########-[ FETCH - PURE CAL
			$pure			= ($lossPROFIT * $perc) / 100;					
			
		}
		
		return $this->render('reports/dept-wise-tally-report.html.twig', [
			'deptlist' => $FTCHdeptlist,
			'jcNOlist' => $FTCHjcNOlist,
			'postJOno' => $request->get('jc_no'),			
			'postDEPT' => $dept,
			'postTYPE' => $type,
			'postFRMdt' => $request->get('frm_date'),
			'postTOdt' => $request->get('to_date'),
			'deptREPORT' => $FTCHdeptREPORT,
			'deptDATAreport' => $deptDATAreport,
			'TOTissWgt' => $TOTissWgt,
			'TOTrecWgt' => $TOTrecWgt,
			'TOTissStWgt' => $TOTissStWgt,
			'TOTrecStWgt' => $TOTrecStWgt,			
			'lossPROFIT' => $lossPROFIT,
			'STlossPROFIT' => $STlossPROFIT,
			'percentage' => $percentage,
			'pure' => $pure,
			'GETlossPROFIT' => $GETlossPROFIT,
			'GETstlossPROFIT' => $GETstlossPROFIT,
			'TOTrecOPwgt' => $TOTrecOPwgt,
			'difference' => $difference,
			'GETldiffLOSprf' => $GETldiffLOSprf,
			'controller_name' => 'TallyReportController'
        ]);
    }
	
	
    /**
     * @Route("/worker-wise-tally-report", name="worker-wise-tally-report")
     */
    public function workerWiseTallyReportACT(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		########-[ GET DEPT LIST
		$QURYdeptlist	= "SELECT `dept_id`, `dept_name` FROM `dept` WHERE `role_status`=1 ORDER BY `dept_name` ASC";
		$CONNdeptlist	= $connection->executeQuery($QURYdeptlist);
		$FTCHdeptlist	= $CONNdeptlist->fetchAll();

		
		########-[ GET PROD - DEPT WISE REPORT
		$QURYdeptREPORT	= "SELECT * FROM `prod_iss_rec` LIMIT 0,0";
		$CONNdeptREPORT	= $connection->executeQuery($QURYdeptREPORT);
		$FTCHdeptREPORT	= $CONNdeptREPORT->fetchAll();

		if($request->getMethod() == 'POST')
		{
			$dept			= $request->get('dept');
			$worker_id		= $request->get('worker_id');
			$frm_date		= $request->get('frm_date');
			$frm_date 		= explode("-",$frm_date);
			$frm_date 		= $frm_date[2]."-".$frm_date[1]."-".$frm_date[0];
			$to_date		= $request->get('to_date');
			$to_date 		= explode("-",$to_date);
			$to_date 		= $to_date[2]."-".$to_date[1]."-".$to_date[0];
			
			
			########-[ GET WORKER LIST
			$QuryDEPTworker	= "SELECT `employee_id`, `eid`, `emp_name`, metal_blnc FROM `employee` WHERE `dept`=$dept ORDER BY `emp_name` ASC";
			$stmtDEPTworker	= $connection->executeQuery($QuryDEPTworker);
			$listDEPTworker = $stmtDEPTworker->fetchAll();
			$empMETALblnc   = $listDEPTworker[0]['metal_blnc'];
			
			
			if($dept != "" && $worker_id!= "" && $request->get('frm_date') == "" && $request->get('to_date') == "")
			{
				$condition = "`dept_id`='$dept' AND `employee_id`='$worker_id'";
				$condISSUE = "`dept_id`='$dept' AND `employee_id`='$worker_id' AND `type`='iss'";
				$condRECVE = "`dept_id`='$dept' AND `employee_id`='$worker_id' AND `type`='rec'";
			} 
			elseif($dept != "" && $worker_id!= "" && $request->get('frm_date') != "" && $request->get('to_date') != "")
			{
				$condition = "`dept_id`='$dept' AND `employee_id`='$worker_id' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
				$condISSUE = "`dept_id`='$dept' AND `employee_id`='$worker_id' AND `type`='iss' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
				$condRECVE = "`dept_id`='$dept' AND `employee_id`='$worker_id' AND `type`='rec' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
			}
			
			########-[ FETCH PROD TRAN - DEPT WISE REPORT WITH FILTER
			$QURYdeptREPORT	= "SELECT * FROM `prod_iss_rec` WHERE ".$condition." ORDER BY prod_iss_rec_id DESC";
			$CONNdeptREPORT	= $connection->executeQuery($QURYdeptREPORT);
			$FTCHdeptREPORT	= $CONNdeptREPORT->fetchAll();

			
			########-[ FETCH - ISSUE WEIGHT
			$QURYissWEIGHT	= "SELECT SUM(`wgt`) AS TOTissWgt FROM `prod_iss_rec` WHERE ".$condISSUE;
			$CONNissWEIGHT	= $connection->executeQuery($QURYissWEIGHT);
			$FTCHissWEIGHT	= $CONNissWEIGHT->fetchAll();
			$TOTissWgt		= $FTCHissWEIGHT[0]['TOTissWgt'];			
			
			########-[ FETCH - RECEIVE WEIGHT
			$QURYrecWEIGHT	= "SELECT SUM(`wgt`) AS TOTrecWgt, SUM(`rec_wgt`) AS recmtTOTrecWgt FROM `prod_iss_rec` WHERE ".$condRECVE;
			$CONNrecWEIGHT	= $connection->executeQuery($QURYrecWEIGHT);
			$FTCHrecWEIGHT	= $CONNrecWEIGHT->fetchAll();
			$TOTrecWgt		= $FTCHrecWEIGHT[0]['TOTrecWgt'];
			$RECmtTOTrecWGT	= $FTCHrecWEIGHT[0]['recmtTOTrecWgt'];		
			
			########-[ FETCH - LOSS/PROFIT CAL
//			$lossPROFIT		= -$TOTissWgt + $TOTrecWgt;		//- ACTUAL CAL

			$lossPROFIT		= (($TOTissWgt + $empMETALblnc) - $TOTrecWgt) - $RECmtTOTrecWGT;	
			$GETlossPROFIT  = substr($lossPROFIT, 0,1);
			
			if($GETlossPROFIT == "-")
			{
				$GETlossPROFIT = "Minus";	########- 1st letter is caps as same used in Lable also
			}
			else
			{
				$GETlossPROFIT = "Plus";	########- 1st letter is caps as same used in Lable also
			}
			
			########-[ PERCENTAGE
			$percentage		= "91.75%";	
			$perc			= 91.75;	
			
			########-[ FETCH - PURE CAL
			$pure			= ($lossPROFIT * $perc) / 100;					
			
		}
		else
		{
			$listDEPTworker = "";
		}
		
		return $this->render('reports/worker-wise-tally-report.html.twig', [
			'deptlist' => $FTCHdeptlist,
			'DEPTworker' => $listDEPTworker,
			'postDEPT' => $dept,
			'postWORKER' => $worker_id,
			'postTYPE' => $type,
			'postFRMdt' => $request->get('frm_date'),
			'postTOdt' => $request->get('to_date'),
			'deptREPORT' => $FTCHdeptREPORT,
			'TOTissWgt' => $TOTissWgt,
			'TOTrecWgt' => $TOTrecWgt,
			'lossPROFIT' => $lossPROFIT,
			'percentage' => $percentage,
			'pure' => $pure,
			'GETlossPROFIT' => $GETlossPROFIT,
			'controller_name' => 'TallyReportController'
        ]);
    }	

	
   /** 
	* @Route("/loadDeptWISEworker", name="loadDeptWISEworker") 
	*/ 
	public function loadDeptWISEworkerACT(Request $request) 
	{ 
	    $var	= $request->get('deptID');
	 
		$connection   = $this->getDoctrine()->getManager()->getConnection(); 

		########-[ FETCH - DEPT WISE WORKER LIST
		$QuryDEPTworker	= "SELECT `employee_id`, `eid`, `emp_name` FROM `employee` WHERE `dept`=$var ORDER BY `emp_name` ASC";
		$stmtDEPTworker	= $connection->executeQuery($QuryDEPTworker);
		$listDEPTworker  = $stmtDEPTworker->fetchAll();

		$rslt = $listDEPTworker;
		return  new JsonResponse($rslt);
	} 
	
		
    /**
     * @Route("/party-wise-tally-report", name="party-wise-tally-report")
     */
    public function partyWiseTallyReportACT(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		########-[ GET PARTY LIST
		$QURYpartylist	= "SELECT `party_id`, `concern_name`, `party_name`, `pid` FROM `party` WHERE `role_status`=1 ORDER BY `party_name` ASC";
		$CONNpartylist	= $connection->executeQuery($QURYpartylist);
		$FTCHpartylist	= $CONNpartylist->fetchAll();
		
//		########-[ GET PARTY WISE TRAN LIST
//		$QURYprtyREPORT	= "SELECT * FROM `pvs_iss_rec` LIMIT 0,0";
//		$CONNprtyREPORT	= $connection->executeQuery($QURYprtyREPORT);
//		$FTCHprtyREPORT	= $CONNprtyREPORT->fetchAll();
//
//		if($request->getMethod() == 'POST')
//		{
//			$party_id		= $request->get('party_id');
//			$frm_date		= $request->get('frm_date');
//			$frm_date 		= explode("-",$frm_date);
//			$frm_date 		= $frm_date[2]."-".$frm_date[1]."-".$frm_date[0];
//			$to_date		= $request->get('to_date');
//			$to_date 		= explode("-",$to_date);
//			$to_date 		= $to_date[2]."-".$to_date[1]."-".$to_date[0];
//			
//			
//			if($party_id != "" && $request->get('frm_date') == "" && $request->get('to_date') == "")
//			{
//				$condition = "`trans_type`='p' AND `pvs_id`='$party_id'";
//				$condISSUE = "`trans_type`='p' AND `pvs_id`='$party_id' AND `type`='iss'";
//				$condRECVE = "`trans_type`='p' AND `pvs_id`='$party_id' AND `type`='rec'";
//			}
//			elseif($party_id != "" && /*$type == "all" &&*/ $request->get('frm_date') != "" && $request->get('to_date') != "")
//			{
//				$condition = "`trans_type`='p' AND `pvs_id`='$party_id' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
//				$condISSUE = "`trans_type`='p' AND `pvs_id`='$party_id' AND `type`='iss' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
//				$condRECVE = "`trans_type`='p' AND `pvs_id`='$party_id' AND `type`='rec' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
//			}
//			
//			########-[ FETCH PROD TRAN - DEPT WISE REPORT WITH FILTER
//			$QURYprtyREPORT	= "SELECT * FROM `pvs_iss_rec` WHERE ".$condition." ORDER BY pvs_iss_rec_id DESC";
//			$CONNprtyREPORT	= $connection->executeQuery($QURYprtyREPORT);
//			$FTCHprtyREPORT	= $CONNprtyREPORT->fetchAll();
//		
//	
//			########-[ FETCH - TOT ISSUE WEIGHT
//			$QURYissWEIGHT	= "SELECT SUM(`wgt`) AS TOTissWgt FROM `pvs_iss_rec` WHERE ".$condISSUE;
//			$CONNissWEIGHT	= $connection->executeQuery($QURYissWEIGHT);
//			$FTCHissWEIGHT	= $CONNissWEIGHT->fetchAll();
//			$TOTissWgt		= $FTCHissWEIGHT[0]['TOTissWgt'];			
//
//			########-[ FETCH - TOT RECEIVE WEIGHT
//			$QURYrecWEIGHT	= "SELECT SUM(`wgt`) AS TOTrecWgt FROM `pvs_iss_rec` WHERE ".$condRECVE;
//			$CONNrecWEIGHT	= $connection->executeQuery($QURYrecWEIGHT);
//			$FTCHrecWEIGHT	= $CONNrecWEIGHT->fetchAll();
//			$TOTrecWgt		= $FTCHrecWEIGHT[0]['TOTrecWgt'];		
//		
//			
//			########-[ PERCENTAGE
//			$percentage		= "91.75%";	
//			$perc			= 91.75;	
//			
//			########-[ GET PARTY TRANS - ISSUE BLNC PURE
//			$QURYissBLNC = "SELECT FORMAT(SUM((`wgt` * `purity`)/100), 3) AS issBLNCpurity FROM `pvs_iss_rec` WHERE ".$condISSUE;
//			$CONNissBLNC = $connection->executeQuery($QURYissBLNC);
//			$FTCHissBLNC = $CONNissBLNC->fetchAll();
//			$issBLNCpuri = $FTCHissBLNC[0]['issBLNCpurity'];
//			
//			########-[ GET PARTY TRANS - REC BLNC PURE
//			$QURYrecBLNC = "SELECT FORMAT(SUM((`wgt` * `percentage`)/100), 3) AS recBLNCpurity FROM `pvs_iss_rec` WHERE ".$condRECVE;
//			$CONNrecBLNC = $connection->executeQuery($QURYrecBLNC);
//			$FTCHrecBLNC = $CONNrecBLNC->fetchAll();
//			$recBLNCpuri = $FTCHrecBLNC[0]['recBLNCpurity'];
//			
//			$RSLTbalADV = $issBLNCpuri + $recBLNCpuri;
//			
//			
//			########-[ GET PARTY TRANS - LOSS/EXS
//			$QURYlossEXS = "SELECT FORMAT(SUM(`wgt`), 3) AS goldWt, FORMAT(SUM((`wgt` * `purity`)/100), 3) AS pur, FORMAT(SUM((`wgt` * `percentage`)/100), 3) AS recBLNCpurity FROM `pvs_iss_rec` WHERE ".$condRECVE;
//			$CONNlossEXS = $connection->executeQuery($QURYlossEXS);
//			$FTCHlossEXS = $CONNlossEXS->fetchAll();
//			
//			$rsltLOSSexs = $FTCHlossEXS[0]['pur'] - $FTCHlossEXS[0]['recBLNCpurity'];
//			$rsltPURITY  = $FTCHlossEXS[0]['goldWt'];	
//			
//			$GETlossPROFIT  = substr($rsltLOSSexs, 0,1);
//			
//			if($GETlossPROFIT == "-")
//			{
//				$GETlossPROFIT = "Loss";	########- 1st letter is caps as same used in Lable also
//			}
//			else
//			{
//				$GETlossPROFIT = "Exc";	########- 1st letter is caps as same used in Lable also
//			}						
//			
//		}

		########-[ GET PARTY WISE TRAN LIST
		$QURYprtyREPORT	= "SELECT * FROM `gold_stock_iss_rec` LIMIT 0,0";
		$CONNprtyREPORT	= $connection->executeQuery($QURYprtyREPORT);
		$FTCHprtyREPORT	= $CONNprtyREPORT->fetchAll();

		if($request->getMethod() == 'POST')
		{
			$party_id		= $request->get('party_id');
			$frm_date		= $request->get('frm_date');
			$frm_date 		= explode("-",$frm_date);
			$frm_date 		= $frm_date[2]."-".$frm_date[1]."-".$frm_date[0];
			$to_date		= $request->get('to_date');
			$to_date 		= explode("-",$to_date);
			$to_date 		= $to_date[2]."-".$to_date[1]."-".$to_date[0];
			
			
			if($party_id != "" && $request->get('frm_date') == "" && $request->get('to_date') == "")
			{
				$condition = "`parti_id`!='1' AND `party_id`='$party_id'";
				$condISSUE = "`parti_id`!='1' AND `party_id`='$party_id' AND `type`='iss'";
				$condRECVE = "`parti_id`!='1' AND `parti_id`!='5' AND `party_id`='$party_id' AND `type`='rec'";
			}
			elseif($party_id != "" && /*$type == "all" &&*/ $request->get('frm_date') != "" && $request->get('to_date') != "")
			{
				$condition = "`parti_id`!='1' AND `party_id`='$party_id' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
				$condISSUE = "`parti_id`!='1' AND `party_id`='$party_id' AND `type`='iss' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
				$condRECVE = "`parti_id`!='1' AND `parti_id`!='5' AND `party_id`='$party_id' AND `type`='rec' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
			}
			elseif($party_id == "" && /*$type == "all" &&*/ $request->get('frm_date') != "" && $request->get('to_date') != "")
			{
				$condition = "`parti_id`!='1' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
				$condISSUE = "`parti_id`!='1' AND `type`='iss' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
				$condRECVE = "`parti_id`!='1' AND `parti_id`!='5' AND `type`='rec' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
			}			
			
			########-[ FETCH PROD TRAN - DEPT WISE REPORT WITH FILTER
			$QURYprtyREPORT	= "SELECT * FROM `gold_stock_iss_rec` WHERE ".$condition." ORDER BY gold_stock_iss_rec_id DESC";
			$CONNprtyREPORT	= $connection->executeQuery($QURYprtyREPORT);
			$FTCHprtyREPORT	= $CONNprtyREPORT->fetchAll();
		
	
			########-[ FETCH - TOT ISSUE WEIGHT
			$QURYissWEIGHT	= "SELECT SUM(`wgt`) AS TOTissWgt FROM `gold_stock_iss_rec` WHERE ".$condISSUE;
			$CONNissWEIGHT	= $connection->executeQuery($QURYissWEIGHT);
			$FTCHissWEIGHT	= $CONNissWEIGHT->fetchAll();
			$TOTissWgt		= $FTCHissWEIGHT[0]['TOTissWgt'];			

			########-[ FETCH - TOT RECEIVE WEIGHT
			$QURYrecWEIGHT	= "SELECT SUM(`wgt`) AS TOTrecWgt FROM `gold_stock_iss_rec` WHERE ".$condRECVE;
			$CONNrecWEIGHT	= $connection->executeQuery($QURYrecWEIGHT);
			$FTCHrecWEIGHT	= $CONNrecWEIGHT->fetchAll();
			$TOTrecWgt		= $FTCHrecWEIGHT[0]['TOTrecWgt'];		
		
			
			########-[ PERCENTAGE
			$percentage		= "91.75%";	
			$perc			= 91.75;	
			
			########-[ GET PARTY TRANS - ISSUE BLNC PURE
			$QURYissBLNC = "SELECT FORMAT(SUM((`wgt` * `piece_bit`)/100), 3) AS issBLNCpurity FROM `gold_stock_iss_rec` WHERE ".$condISSUE;
			$CONNissBLNC = $connection->executeQuery($QURYissBLNC);
			$FTCHissBLNC = $CONNissBLNC->fetchAll();
			$issBLNCpuri = $FTCHissBLNC[0]['issBLNCpurity'];

			########-[ GET PARTY TRANS - REC BLNC PURE
			$QURYrecBLNC = "SELECT FORMAT(SUM((`wgt` * `purity`)/100), 3) AS recBLNCpurity FROM `gold_stock_iss_rec` WHERE ".$condRECVE;
			$CONNrecBLNC = $connection->executeQuery($QURYrecBLNC);
			$FTCHrecBLNC = $CONNrecBLNC->fetchAll();
			$recBLNCpuri = $FTCHrecBLNC[0]['recBLNCpurity'];

			$RSLTbalADV = $issBLNCpuri + $recBLNCpuri;
			
			
			########-[ GET PARTY TRANS - LOSS/EXS
			$QURYlossEXS = "SELECT FORMAT(SUM(`wgt`), 3) AS goldWt, FORMAT(SUM((`wgt` * `piece_bit`)/100), 3) AS pur, FORMAT(SUM((`wgt` * `purity`)/100), 3) AS recBLNCpurity FROM `gold_stock_iss_rec` WHERE ".$condRECVE;
			$CONNlossEXS = $connection->executeQuery($QURYlossEXS);
			$FTCHlossEXS = $CONNlossEXS->fetchAll();
			
			$rsltLOSSexs = $FTCHlossEXS[0]['pur'] - $FTCHlossEXS[0]['recBLNCpurity'];
			$rsltPURITY  = $FTCHlossEXS[0]['goldWt'];	
			
			$GETlossPROFIT  = substr($rsltLOSSexs, 0,1);
			
			if($GETlossPROFIT == "-")
			{
				$GETlossPROFIT = "Loss";	########- 1st letter is caps as same used in Lable also
			}
			else
			{
				$GETlossPROFIT = "Exc";	########- 1st letter is caps as same used in Lable also
			}						
			
		}
		
		return $this->render('reports/party-wise-tally-report.html.twig', [
			'partylist' => $FTCHpartylist,
			'postPARTYid' => $party_id,
			'postTYPE' => $type,
			'postFRMdt' => $request->get('frm_date'),
			'postTOdt' => $request->get('to_date'),
			'prtyREPORT' => $FTCHprtyREPORT,
			'TOTissWgt' => $TOTissWgt,
			'TOTrecWgt' => $TOTrecWgt,
			'lossPROFIT' => $lossPROFIT,
			'percentage' => $percentage,
			'pure' => $pure,
			'GETlossPROFIT' => $GETlossPROFIT,
			'balADV' => $RSLTbalADV,
			'LOSSexs' => $rsltLOSSexs,
			'purity' => $rsltPURITY,
			'controller_name' => 'TallyReportController'
        ]);
    }
	
		
    /**
     * @Route("/vendor-wise-tally-report", name="vendor-wise-tally-report")
     */
    public function vendorWiseTallyReportACT(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		########-[ GET VENDOR LIST
		$QURYvendorlist	= "SELECT `vendor_id`, `concern_name`, `vendor_name`, `vid` FROM `vendor` WHERE `role_status`=1 ORDER BY `vendor_name` ASC";
		$CONNvendorlist	= $connection->executeQuery($QURYvendorlist);
		$FTCHvendorlist	= $CONNvendorlist->fetchAll();
		
		########-[ GET PARTY WISE TRAN LIST
		$QURYprtyREPORT	= "SELECT * FROM `pvs_iss_rec` LIMIT 0,0";
		$CONNprtyREPORT	= $connection->executeQuery($QURYprtyREPORT);
		$FTCHprtyREPORT	= $CONNprtyREPORT->fetchAll();

		if($request->getMethod() == 'POST')
		{
			$vendor_id		= $request->get('vendor_id');
			$frm_date		= $request->get('frm_date');
			$frm_date 		= explode("-",$frm_date);
			$frm_date 		= $frm_date[2]."-".$frm_date[1]."-".$frm_date[0];
			$to_date		= $request->get('to_date');
			$to_date 		= explode("-",$to_date);
			$to_date 		= $to_date[2]."-".$to_date[1]."-".$to_date[0];
			
			
			if($vendor_id != "" && $request->get('frm_date') == "" && $request->get('to_date') == "")
			{
				$condition = "`trans_type`='v' AND `pvs_id`='$vendor_id'";
				$condISSUE = "`trans_type`='v' AND `pvs_id`='$vendor_id' AND `type`='iss'";
				$condRECVE = "`trans_type`='v' AND `pvs_id`='$vendor_id' AND `type`='rec'";
			}
			elseif($vendor_id != "" && $request->get('frm_date') != "" && $request->get('to_date') != "")
			{
				$condition = "`trans_type`='v' AND `pvs_id`='$vendor_id' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
				$condISSUE = "`trans_type`='v' AND `pvs_id`='$vendor_id' AND `type`='iss' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
				$condRECVE = "`trans_type`='v' AND `pvs_id`='$vendor_id' AND `type`='rec' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
			}
			
			########-[ FETCH PROD TRAN - DEPT WISE REPORT WITH FILTER
			$QURYprtyREPORT	= "SELECT * FROM `pvs_iss_rec` WHERE ".$condition." ORDER BY pvs_iss_rec_id DESC";
			$CONNprtyREPORT	= $connection->executeQuery($QURYprtyREPORT);
			$FTCHprtyREPORT	= $CONNprtyREPORT->fetchAll();
		
	
			########-[ FETCH - TOT ISSUE WEIGHT
			$QURYissWEIGHT	= "SELECT SUM(`wgt`) AS TOTissWgt FROM `pvs_iss_rec` WHERE ".$condISSUE;
			$CONNissWEIGHT	= $connection->executeQuery($QURYissWEIGHT);
			$FTCHissWEIGHT	= $CONNissWEIGHT->fetchAll();
			$TOTissWgt		= $FTCHissWEIGHT[0]['TOTissWgt'];			

			########-[ FETCH - TOT RECEIVE WEIGHT
			$QURYrecWEIGHT	= "SELECT SUM(`wgt`) AS TOTrecWgt FROM `pvs_iss_rec` WHERE ".$condRECVE;
			$CONNrecWEIGHT	= $connection->executeQuery($QURYrecWEIGHT);
			$FTCHrecWEIGHT	= $CONNrecWEIGHT->fetchAll();
			$TOTrecWgt		= $FTCHrecWEIGHT[0]['TOTrecWgt'];		
		
			
			########-[ PERCENTAGE
			$percentage		= "91.75%";	
			$perc			= 91.75;	
			
			########-[ GET PARTY TRANS - ISSUE BLNC PURE
			$QURYissBLNC = "SELECT FORMAT(SUM((`wgt` * `purity`)/100), 3) AS issBLNCpurity FROM `pvs_iss_rec` WHERE ".$condISSUE;
			$CONNissBLNC = $connection->executeQuery($QURYissBLNC);
			$FTCHissBLNC = $CONNissBLNC->fetchAll();
			$issBLNCpuri = $FTCHissBLNC[0]['issBLNCpurity'];
			
			########-[ GET PARTY TRANS - REC BLNC PURE
			$QURYrecBLNC = "SELECT FORMAT(SUM((`wgt` * `percentage`)/100), 3) AS recBLNCpurity FROM `pvs_iss_rec` WHERE ".$condRECVE;
			$CONNrecBLNC = $connection->executeQuery($QURYrecBLNC);
			$FTCHrecBLNC = $CONNrecBLNC->fetchAll();
			$recBLNCpuri = $FTCHrecBLNC[0]['recBLNCpurity'];
			
			$RSLTbalADV = $issBLNCpuri + $recBLNCpuri;
			
			
			########-[ GET PARTY TRANS - LOSS/EXS
			$QURYlossEXS = "SELECT FORMAT(SUM(`wgt`), 3) AS goldWt, FORMAT(SUM((`wgt` * `purity`)/100), 3) AS pur, FORMAT(SUM((`wgt` * `percentage`)/100), 3) AS recBLNCpurity FROM `pvs_iss_rec` WHERE ".$condRECVE;
			$CONNlossEXS = $connection->executeQuery($QURYlossEXS);
			$FTCHlossEXS = $CONNlossEXS->fetchAll();
			
			$rsltLOSSexs = $FTCHlossEXS[0]['pur'] - $FTCHlossEXS[0]['recBLNCpurity'];
			$rsltPURITY  = $FTCHlossEXS[0]['goldWt'];	
			
			$GETlossPROFIT  = substr($rsltLOSSexs, 0,1);
			
			if($GETlossPROFIT == "-")
			{
				$GETlossPROFIT = "Loss";	########- 1st letter is caps as same used in Lable also
			}
			else
			{
				$GETlossPROFIT = "Exc";	########- 1st letter is caps as same used in Lable also
			}						
			
		}
		
		return $this->render('reports/vendor-wise-tally-report.html.twig', [
			'vendorlist' => $FTCHvendorlist,
			'postVENDORid' => $vendor_id,
			'postFRMdt' => $request->get('frm_date'),
			'postTOdt' => $request->get('to_date'),
			'prtyREPORT' => $FTCHprtyREPORT,
			'TOTissWgt' => $TOTissWgt,
			'TOTrecWgt' => $TOTrecWgt,
			'lossPROFIT' => $lossPROFIT,
			'percentage' => $percentage,
			'pure' => $pure,
			'GETlossPROFIT' => $GETlossPROFIT,
			'balADV' => $RSLTbalADV,
			'LOSSexs' => $rsltLOSSexs,
			'purity' => $rsltPURITY,
			'controller_name' => 'TallyReportController'
        ]);
    }
	
	
    /**
     * @Route("/sales-partner-wise-tally-report", name="sales-partner-wise-tally-report")
     */
    public function salesPartnerWiseTallyReportACT(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		########-[ GET VENDOR LIST
		$QURYsalesPlist	= "SELECT `sales_partner_id`, `sales_partner_name`, `spid` FROM `sales_partner` WHERE `role_status`=1 ORDER BY `sales_partner_name` ASC";
		$CONNsalesPlist	= $connection->executeQuery($QURYsalesPlist);
		$FTCHsalesPlist	= $CONNsalesPlist->fetchAll();
		
		########-[ GET PARTY WISE TRAN LIST
		$QURYprtyREPORT	= "SELECT * FROM `pvs_iss_rec` LIMIT 0,0";
		$CONNprtyREPORT	= $connection->executeQuery($QURYprtyREPORT);
		$FTCHprtyREPORT	= $CONNprtyREPORT->fetchAll();

		if($request->getMethod() == 'POST')
		{
			$sales_partner_id 	= $request->get('sales_partner_id');
			$frm_date			= $request->get('frm_date');
			$frm_date 			= explode("-",$frm_date);
			$frm_date 			= $frm_date[2]."-".$frm_date[1]."-".$frm_date[0];
			$to_date			= $request->get('to_date');
			$to_date 			= explode("-",$to_date);
			$to_date 			= $to_date[2]."-".$to_date[1]."-".$to_date[0];
			
			if($sales_partner_id != "" && $request->get('frm_date') == "" && $request->get('to_date') == "")
			{
				$condition = "`trans_type`='s' AND `pvs_id`='$sales_partner_id'";
				$condISSUE = "`trans_type`='s' AND `pvs_id`='$sales_partner_id' AND `type`='iss'";
				$condRECVE = "`trans_type`='s' AND `pvs_id`='$sales_partner_id' AND `type`='rec'";
			}
			elseif($sales_partner_id != "" && $request->get('frm_date') != "" && $request->get('to_date') != "")
			{
				$condition = "`trans_type`='s' AND `pvs_id`='$sales_partner_id' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
				$condISSUE = "`trans_type`='s' AND `pvs_id`='$sales_partner_id' AND `type`='iss' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
				$condRECVE = "`trans_type`='s' AND `pvs_id`='$sales_partner_id' AND `type`='rec' AND `trans_date` BETWEEN '$frm_date' AND '$to_date'";
			}
			
			########-[ FETCH PROD TRAN - DEPT WISE REPORT WITH FILTER
			$QURYprtyREPORT	= "SELECT * FROM `pvs_iss_rec` WHERE ".$condition." ORDER BY pvs_iss_rec_id DESC";
			$CONNprtyREPORT	= $connection->executeQuery($QURYprtyREPORT);
			$FTCHprtyREPORT	= $CONNprtyREPORT->fetchAll();
		
	
			########-[ FETCH - TOT ISSUE WEIGHT
			$QURYissWEIGHT	= "SELECT SUM(`wgt`) AS TOTissWgt FROM `pvs_iss_rec` WHERE ".$condISSUE;
			$CONNissWEIGHT	= $connection->executeQuery($QURYissWEIGHT);
			$FTCHissWEIGHT	= $CONNissWEIGHT->fetchAll();
			$TOTissWgt		= $FTCHissWEIGHT[0]['TOTissWgt'];			

/*			########-[ FETCH - TOT RECEIVE WEIGHT
			$QURYrecWEIGHT	= "SELECT SUM(`wgt`) AS TOTrecWgt FROM `pvs_iss_rec` WHERE ".$condRECVE;
			$CONNrecWEIGHT	= $connection->executeQuery($QURYrecWEIGHT);
			$FTCHrecWEIGHT	= $CONNrecWEIGHT->fetchAll();
			$TOTrecWgt		= $FTCHrecWEIGHT[0]['TOTrecWgt'];*/		
		
			
/*			########-[ PERCENTAGE
			$percentage		= "91.75%";	
			$perc			= 91.75;*/	
			
			########-[ GET TRANS - ISSUE - BLNC PURE
			$QURYissBLNCpure = "SELECT FORMAT(SUM((`wgt` * `percentage`)/100), 3) AS issBLNCpurity FROM `pvs_iss_rec` WHERE ".$condISSUE;
			$CONNissBLNCpure = $connection->executeQuery($QURYissBLNCpure);
			$FTCHissBLNCpure = $CONNissBLNCpure->fetchAll();
			$issBLNCpuri 	 = $FTCHissBLNCpure[0]['issBLNCpurity'];
			
			########-[ GET TRANS - REC - ADVC PURE
			$QURYrecADVCpure = "SELECT FORMAT(SUM((`wgt` * `purity`)/100), 3) AS recADVCpurity FROM `pvs_iss_rec` WHERE ".$condRECVE;
			$CONNrecADVCpure = $connection->executeQuery($QURYrecADVCpure);
			$FTCHrecADVCpure = $CONNrecADVCpure->fetchAll();
			$recADVCpuri     = $FTCHrecADVCpure[0]['recADVCpurity'];
			
			########-[ BAL/ADV CAL
			$RSLTbalADV = $issBLNCpuri + $recADVCpuri;
			
			
			########-[ GET TRANS - ISSUE - ITEM PURE
			$QURYissITEMpure = "SELECT FORMAT(SUM((`wgt` * `purity`)/100), 3) AS issBLNCpurity FROM `pvs_iss_rec` WHERE ".$condISSUE;
			$CONNissITEMpure = $connection->executeQuery($QURYissITEMpure);
			$FTCHissITEMpure = $CONNissITEMpure->fetchAll();
			$issITEMpure     = $FTCHissITEMpure[0]['issBLNCpurity'];
			
			########-[ LOSS/EXS CAL
			$RSLTlossEXS = $issITEMpure - $issBLNCpuri;
			
/*			########-[ GET PARTY TRANS - LOSS/EXS
			$QURYlossEXS = "SELECT FORMAT(SUM(`wgt`), 3) AS goldWt, FORMAT(SUM((`wgt` * `purity`)/100), 3) AS pur, FORMAT(SUM((`wgt` * `percentage`)/100), 3) AS recBLNCpurity FROM `pvs_iss_rec` WHERE ".$condRECVE;
			$CONNlossEXS = $connection->executeQuery($QURYlossEXS);
			$FTCHlossEXS = $CONNlossEXS->fetchAll();
			
			$rsltLOSSexs = $FTCHlossEXS[0]['pur'] - $FTCHlossEXS[0]['recBLNCpurity'];
			$rsltPURITY  = $FTCHlossEXS[0]['goldWt'];*/	
			
			$GETlossPROFIT  = substr($RSLTlossEXS, 0,1);
			
			if($GETlossPROFIT == "-")
			{
				$GETlossPROFIT = "Loss";	########- 1st letter is caps as same used in Lable also
			}
			else
			{
				$GETlossPROFIT = "Exc";	########- 1st letter is caps as same used in Lable also
			}						
			
		}
		
		return $this->render('reports/sales-partner-wise-tally-report.html.twig', [
			'salesPlist' => $FTCHsalesPlist,
			'postSALESPid' => $sales_partner_id,
			'postFRMdt' => $request->get('frm_date'),
			'postTOdt' => $request->get('to_date'),
			'prtyREPORT' => $FTCHprtyREPORT,
			'TOTissWgt' => $TOTissWgt,
			'TOTrecWgt' => $TOTrecWgt,
			'lossPROFIT' => $lossPROFIT,
			'percentage' => $percentage,
			'pure' => $pure,
			'GETlossPROFIT' => $GETlossPROFIT,
			'balADV' => $RSLTbalADV,
			'LOSSexs' => $RSLTlossEXS,
			'purity' => $rsltPURITY,
			'controller_name' => 'TallyReportController'
        ]);
    }			
}
