<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class SalesPartnerController extends AbstractController
{
    /**
     * @Route("/sales-partner-list", name="sales-partner-list")
     */
    public function salesPartnerLISTact(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		########-[ GET SALES PARTNER LIST
		$QURYlist	= "SELECT * FROM `sales_partner` ORDER BY `spid` DESC";
		$CONNlist	= $connection->executeQuery($QURYlist);
		$FTCHlist	= $CONNlist->fetchAll();
		
		return $this->render('sales-partner/sales-partner-list.html.twig', [
			'salesPARTNERList' => $FTCHlist,
			'controller_name' => 'SalesPartnerController'
        ]);
    }
	
	
    /**
     * @Route("/sales-partner-reg", name="sales-partner-reg")
     */
    public function salesPartnerREGact(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		########-[ GET SPID
		$QURYmaxSPID			= "SELECT MAX(`spid`) AS sp_id FROM `sales_partner`";
		$CONNmaxSPID			= $connection->executeQuery($QURYmaxSPID);
		$FTCHmaxSPID			= $CONNmaxSPID->fetchAll();
		$FTCHmaxSPID['sp_id']	= $FTCHmaxSPID[0]['sp_id'];
		
		if($request->getMethod() == 'POST')
		{
			$spid		= $request->get('spid');
			$metal_blnc	= $request->get('metal_blnc');
			$person_nm	= $request->get('partner_name');
			$gst_no		= $request->get('gst_no');
			$mbl1		= $request->get('mbl1');
			$mbl2		= $request->get('mbl2');
			$email1		= $request->get('email1');
			$email2		= $request->get('email2');
			$door_no	= $request->get('door_no');
			$street1	= $request->get('street1');
			$street2	= $request->get('street2');
			$city		= $request->get('city');
			$state		= $request->get('state');
			$sessionId  = $session->get('empId');
			
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime = date("Y-m-d H:i:s");
			
			########-[ INSERT - DETAILS
			$QRinsert = "INSERT INTO `sales_partner`(`spid`, `metal_blnc`, `sales_partner_name`, `gst_no`, `mbl1`, `mbl2`, `email1`, `email2`, `door_no`, `street1`, `street2`, `city`, `state`, `post_by`, `post_dt`) VALUES ('$spid','$metal_blnc','$person_nm','$gst_no','$mbl1','$mbl2','$email1','$email2','$door_no','$street1','$street2','$city','$state','$sessionId','$nwDateTime')";
			$CNexecut = $connection->executeQuery($QRinsert);
			
			return $this->redirectToRoute('sales-partner-list');
		}
		
		return $this->render('sales-partner/sales-partner-reg.html.twig', [
			'maxSPID' => $FTCHmaxSPID,
			'controller_name' => 'SalesPartnerController'
        ]);
    }	


    /**
     * @Route("/sales-partner-dlt{sales_partner_dlt_id}", name="sales-partner-dlt")
     */
    public function salesPartnerDLTact(Request $request, $sales_partner_dlt_id) 
    {	
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 	
		
		########-[ DELETE - DETAILS
		$QRdltPARTY = "DELETE FROM `sales_partner` WHERE `sales_partner_id`=".$sales_partner_dlt_id;
		$CNdltPARTY = $connection->executeQuery($QRdltPARTY);
		
		return $this->redirectToRoute('sales-partner-list');
	}	


    /**
     * @Route("/sales-partner-upt{sales_partner_upt_id}", name="sales-partner-upt")
     */
    public function salesPartnerUPTact(Request $request, $sales_partner_upt_id) 
    {	
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 	
		
		########-[ GET UPDATE DATA
		$QURYuptDATA	= "SELECT * FROM `sales_partner` WHERE `sales_partner_id` = ".$sales_partner_upt_id;
		$CONNuptDATA	= $connection->executeQuery($QURYuptDATA);
		$FTCHuptDATA	= $CONNuptDATA->fetchAll();
		
		if($request->getMethod() == 'POST')
		{
			$spid		= $request->get('spid');
			$metal_blnc	= $request->get('metal_blnc');
			$person_nm	= $request->get('partner_name');
			$gst_no		= $request->get('gst_no');
			$mbl1		= $request->get('mbl1');
			$mbl2		= $request->get('mbl2');
			$email1		= $request->get('email1');
			$email2		= $request->get('email2');
			$door_no	= $request->get('door_no');
			$street1	= $request->get('street1');
			$street2	= $request->get('street2');
			$city		= $request->get('city');
			$state		= $request->get('state');
			$sessionId  = $session->get('empId');
			
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime = date("Y-m-d H:i:s");
			
			########-[ INSERT - DETAILS
			$QRuptDATA = "UPDATE `sales_partner` SET `metal_blnc`='$metal_blnc',`sales_partner_name`='$person_nm',`gst_no`='$gst_no',`mbl1`='$mbl1',`mbl2`='$mbl2',`email1`='$email1',`email2`='$email2',`door_no`='$door_no',`street1`='$street1',`street2`='$street2',`city`='$city',`state`='$state',`update_by`='$sessionId',`update_dt`='$nwDateTime' WHERE `sales_partner_id`=".$sales_partner_upt_id;
			$CNuptDATA = $connection->executeQuery($QRuptDATA);
			
			return $this->redirectToRoute('sales-partner-list');
		}
		
		return $this->render('sales-partner/sales-partner-upt.html.twig', [
			'salesPartnerUPDTdata' => $FTCHuptDATA,
			'controller_name' => 'PartiesController'
        ]);
	}		
}
