<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class ReportsController extends AbstractController
{

    /**
     * @Route("/po-report", name="po-report")
     */
    public function poReportact(Request $request)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		#--------[ FETCH - PARTY DATA's
		$QURYpartDATAs = "SELECT `party_id`, CONCAT(`concern_name`,' - ',`party_name`,' - [',`pid`,']') AS partyName FROM `party` WHERE `role_status`=1 ORDER BY `concern_name` ASC";
		$CONNpartDATAs = $connection->executeQuery($QURYpartDATAs);
		$FTCHpartDATAs = $CONNpartDATAs->fetchAll();
		
		if($request->getMethod() == 'POST')
		{
			$partyID 	= $request->get('partyID');
			$ord_type 	= $request->get('ord_type');
			$order_no 	= $request->get('order_no');
			$prod_name 	= $request->get('prod_name');
			$prod_type 	= $request->get('prod_type');
			$ordDATEfrm	= explode("-", $request->get('ordDATEfrm'));
			$ordDATEfrm	= $ordDATEfrm[0]."-".$ordDATEfrm[1]."-".$ordDATEfrm[2];			
			$ordDATEto	= explode("-", $request->get('ordDATEto'));
			$ordDATEto	= $ordDATEto[0]."-".$ordDATEto[1]."-".$ordDATEto[2];
			
			if($prod_type == "pl"){
				$prod_type = 0;
			} elseif($prod_type == "st") {
				$prod_type = 1;
			}
			
			if($partyID != NULL){
				$searchWHEREcond .= ' AND (OP.`party_id` = "'.$partyID.'") ';
			}
			
			if($ord_type != NULL){
				$searchWHEREcond .= ' AND (OP.po_open_ord_code LIKE "'.$ord_type.'%") ';
			}
			
			if($order_no != NULL){
				$searchWHEREcond .= " AND CONCAT_WS( '', OP.po_open_ord_code, OP.po_open_ord_no ) = '".$order_no."'";
			}
			
			if($prod_name != NULL){
				$searchWHEREcond .= " AND (OPD.cat_shortname = '".$prod_name."' )";
			}
			
			if($prod_type != NULL){
				$searchWHEREcond .= " AND (OPD.typ_e = '".$prod_type."' )";
			}
			
			if($ordDATEfrm != "--"){
				$searchWHEREcond .= "AND( OPD.`post_dt` BETWEEN '".$ordDATEfrm."' AND '".$ordDATEto."' )";
			}

			$whereCOND	= "OPD.po_open_ord_id = OP.po_open_ord_id AND OP.party_id = P.party_id AND OPD.jc_no_split_status = 'Yes' ".$searchWHEREcond." ";
		}
		else
		{
			$partyID 	= "";
			$ord_type 	= "";
			$order_no 	= "";
			$prod_name 	= "";
			$prod_type 	= "";
			$ordDATEfrm	= "";
			$ordDATEto	= "";
			
			$whereCOND	= "OPD.po_open_ord_id = OP.po_open_ord_id AND OP.party_id = P.party_id AND OPD.jc_no_split_status = 'Yes' ";
		}
		
		#--------[ FETCH - JC
		$QURYopenORD = "SELECT OPD.`po_open_ord_det_id`, OP.po_open_ord_id, CONCAT(OP.po_open_ord_code,'',OP.po_open_ord_no) AS opNO, OPD.jc_no, FORMAT(OP.avg_tot_wgt, 2) AS ordTOTwgt, DATE_FORMAT(OP.post_dt, '%b %D, %y %I:%i %p') AS entry_date, P.concern_name, P.party_name, OPD.cat_shortname, OPD.typ_e, FORMAT(OPD.wgt_range_from, 2) AS wgt_range_from, FORMAT(OPD.wgt_range_to, 3) AS wgt_range_to, FORMAT(OPD.avg_wgt_per_pcs , 3) AS avg_wgt_per_pcs, OPD.ord_qty, FORMAT(OPD.avg_wgt_range , 3) AS avg_wgt_range, OPD.ord_spec FROM `po_open_ord_det` AS OPD, `po_open_ord` AS OP, `party` AS P WHERE ".$whereCOND." ORDER BY OP.po_open_ord_id DESC";
		$CONNopenORD = $connection->executeQuery($QURYopenORD);
		$FTCHopenORD = $CONNopenORD->fetchAll();
		$CONTopenORD = count($FTCHopenORD) - 1;
		
		
		$openORDdata = "";
		for($i=0; $i<=$CONTopenORD; $i++)
		{			
			#--------[ CHECK - JC in WAX ENTRY
			$QURYwxENT = "SELECT `wax_entry_id` FROM `wax_entry` WHERE `po_open_ord_id`='".$FTCHopenORD[$i]['po_open_ord_id']."'";
			$CONNwxENT = $connection->executeQuery($QURYwxENT);
			$FTCHwxENT = $CONNwxENT->fetchAll();
			$CHCKwxENT = $FTCHwxENT[0]['wax_entry_id'];	
			
			$QURYmxPOID = "SELECT MAX(`po_open_ord_det_id`) AS po_open_ord_det_id FROM `po_open_ord_det` WHERE `po_open_ord_id`='".$FTCHopenORD[$i]['po_open_ord_id']."'";
			$CONNmxPOID = $connection->executeQuery($QURYmxPOID);
			$FTCHmxPOID = $CONNmxPOID->fetchAll();
			$CHCKmxPOID = $FTCHmxPOID[0]['po_open_ord_det_id'];	

		
			if($FTCHopenORD[$i]['typ_e'] == 1){ $itemTYPE = "Stone"; } else if($FTCHopenORD[$i]['typ_e'] == 0) { $itemTYPE = "Plain"; }
			
			$openORDdata .='<tr>
							  <td title="Serial No." style="text-align:center; vertical-align: middle;">'.($i+1).'</td>
							  <td title="Showing - Party Name" style="text-align:left; vertical-align: middle;">'.$FTCHopenORD[$i]['party_name'].'</td>
							  <td title="Showing - Order No." style="text-align:left; vertical-align:middle;">'.$FTCHopenORD[$i]['opNO'].'</td>
							  <td title="Showing - Job Card No." style="text-align:left; vertical-align:middle;">'.$FTCHopenORD[$i]['jc_no'].'</td>
							  <td title="Showing - Product" style="text-align:left; vertical-align:middle;">'.$FTCHopenORD[$i]['cat_shortname'].'</td>
							  <td title="Showing - Type" style="text-align:left; vertical-align:middle;">'.$itemTYPE.'</td>
							  <td title="Showing - Weight Range From in grams" style="text-align:right; vertical-align: middle;">'.$FTCHopenORD[$i]['wgt_range_from'].'</td>
							  <td title="Showing - Weight Range To in grams" style="text-align:right; vertical-align: middle;">'.$FTCHopenORD[$i]['wgt_range_to'].'</td>
							  <td title="Showing - Average Weight/Piece in grams" style="text-align:right; vertical-align: middle;">'.$FTCHopenORD[$i]['avg_wgt_per_pcs'].'</td>
							  <td title="Showing - Order Quantity" style="text-align:center; vertical-align: middle;">'.$FTCHopenORD[$i]['ord_qty'].'</td>
							  <td title="Showing - Job Card Weight in grams" style="text-align:right; vertical-align: middle;">'.$FTCHopenORD[$i]['ordTOTwgt'].'</td>
							  <td title="Showing - Entry Date & Time of an event that a computer records" style="text-align:right; vertical-align: middle;">'.$FTCHopenORD[$i]['entry_date'].'</td>
						   </tr>';
			
		}
		
		return $this->render('reports/po-report.html.twig', [
			'postPartyID' => $partyID,
			'postOrdType' => $ord_type,
			'postOrdNo' => $order_no,
			'postProdName' => $prod_name,
			'postProdType' => $prod_type,
			'postOrdDATEfrm' => $ordDATEfrm,
			'postOrdDATEto' => $ordDATEto,
			'partDATAs' => $FTCHpartDATAs,
			'openORDlist' => $FTCHopenORD,
			'openORDdata' => $openORDdata,
			'controller_name' => 'ReportsController'
        ]);
    }
	
	
    /**
     * @Route("/worker-metal-tran-report", name="worker-metal-tran-report")
     */
    public function workerMetalTranReportact(Request $request)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		
		########-[ QUICK VARIABLES
		$tableName	= "metal_w2w_trans";
		$tablePrmID	= "metal_w2w_trans_id";

		#--------[ FETCH - ALL EMP LISTED
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM `metal_w2w_trans` AS WT, employee AS E WHERE WT.iss_employee_id=E.employee_id GROUP BY WT.rec_employee_id ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();	
		
		if($request->getMethod() == 'POST')
		{
			$iss_work_id	= $request->get('iss_work_id');
			$DATEfrm		= explode("-", $request->get('DATEfrm'));
			$DATEfrm		= $DATEfrm[0]."-".$DATEfrm[1]."-".$DATEfrm[2];			
			$DATEto			= explode("-", $request->get('DATEto'));
			$DATEto			= $DATEto[0]."-".$DATEto[1]."-".$DATEto[2];			
			
			if($iss_work_id != NULL){
				$searchWHEREcond .= ' AND w2W.iss_employee_id="'.$iss_work_id.'" ';
			}
			
			if($DATEfrm != '--'){
				$searchWHEREcond .= ' AND W2W.`post_dt` BETWEEN "'.$DATEfrm.' 00:00:00" AND "'.$DATEto.' 23:59:59" ';
			}
		}
		else
		{
			$iss_work_id	= "";
			$DATEfrm		= "";
			$DATEto			= "";
		}
			
		########-[ LIST 
		$QURYlistDet = "SELECT w2w.rec_employee_id, w2w.iss_employee_id, MA.metal_accessories_name, FORMAT(w2w.issed_wgt, 2) AS issed_wgt, E.emp_name, DATE_FORMAT(w2w.post_dt, '%b %d, %Y - %r') AS entryDT FROM `metal_w2w_trans` AS w2w, metal_accessories AS MA, employee AS E WHERE w2w.metal_accessories_id=MA.metal_accessories_id AND w2w.post_by=E.employee_id ".$searchWHEREcond." ORDER BY w2w.metal_w2w_trans_id DESC";
		$CONNlistDet = $connection->executeQuery($QURYlistDet);
		$FTCHlistDet = $CONNlistDet->fetchAll();
		$CONTlistDet= count($FTCHlistDet);
		
		$data = "";
		for($i=0; $i<=$CONTlistDet-1; $i++)
		{
			
			$QURYrecEMP = "SELECT emp_name FROM `employee` WHERE employee_id=".$FTCHlistDet[$i]['rec_employee_id'];
			$CONNrecEMP = $connection->executeQuery($QURYrecEMP);
			$FTCHrecEMP = $CONNrecEMP->fetchAll();

			$QURYissEMP = "SELECT emp_name FROM `employee` WHERE employee_id=".$FTCHlistDet[$i]['iss_employee_id'];
			$CONNissEMP = $connection->executeQuery($QURYissEMP);
			$FTCHissEMP = $CONNissEMP->fetchAll();
			
			if($FTCHlistDet[$i]['rec_employee_id'] == 0){
				$receiver = "Metal Dept.";
			} else {
				$receiver = $FTCHrecEMP[0]['emp_name'];
			}
			
			$data .= '<tr>
						<td title="Showing - Serial No." style="text-align:center; vertical-align: middle;">'. ($i+1) .'</td>
						<td title="Showing - Receiver" style="text-align:left; vertical-align: middle;">'.$receiver.'</td>
						<td title="Showing - Issue Worker" style="text-align:left; vertical-align: middle;">'.$FTCHissEMP[0]['emp_name'].'</td>
						<td title="Showing - Product/Accessories" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['metal_accessories_name'].'</td>
						<td title="Showing - Issed Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]['issed_wgt'].'</td>
						<td title="Showing - Entered Person Name" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['emp_name'].'</td>
						<td title="Showing - Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['entryDT'].'</td>';
			$data .= '</tr>';
		}		
		
		return $this->render('reports/worker-metal-tran-report.html.twig', [
			'postIssWrkID' => $iss_work_id,
			'postDATEfrm' => $DATEfrm,
			'postDATEto' => $DATEto,
			'empDATAs' => $FTCHemp,
			'w2wMtranDATA' => $data,
			'controller_name' => 'ReportsController'
        ]);
    }

    /**
     * @Route("/daily-tally-report", name="daily-tally-report")
     */
    public function dailyTALLYreportACT(Request $request)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		
		
		########-[ QUICK VARIABLES
		$tableName	= "metal_daily_tally";
		$tablePrmID	= "metal_daily_tally_id";
		
		#--------[ FETCH - ALL EMP LISTED
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM `metal_daily_tally` AS MDT, employee AS E WHERE MDT.employee_id=E.employee_id AND E.role_status=1 GROUP BY MDT.employee_id ORDER BY E.emp_name ASC";
		//$QURYemp	= "SELECT E.employee_id, E.emp_name FROM employee AS E WHERE E.role_status=1 ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();	
		
		if($request->getMethod() == 'POST')
		{
			$work_id	= $request->get('work_id');
			$DATEfrm	= explode("-", $request->get('DATEfrm'));
			$DATEfrm	= $DATEfrm[0]."-".$DATEfrm[1]."-".$DATEfrm[2];			
			$DATEto		= explode("-", $request->get('DATEto'));
			$DATEto		= $DATEto[0]."-".$DATEto[1]."-".$DATEto[2];			
			
			if($work_id != NULL){
				$searchWHEREcond .= ' AND MDT.employee_id="'.$work_id.'" ';
			}
			
			if($DATEfrm != '--'){
				$searchWHEREcond .= ' AND MDT.`post_dt` BETWEEN "'.$DATEfrm.' 00:00:00" AND "'.$DATEto.' 23:59:59" ';
			}
		}
		else
		{
			$work_id	= "";
			$DATEfrm	= "";
			$DATEto		= "";
		}
		 
		########-[ LIST 
		$QURYlistDet = "SELECT MDT.employee_id, FORMAT(MDT.`exist_stock_wgt_rfrnc`, 2) AS exist_stock_wgt_rfrnc, FORMAT(MDT.`rec_wgt`, 2) AS rec_wgt, E.emp_name, DATE_FORMAT(MDT.post_dt, '%b %d, %Y - %r') AS entryDT FROM `metal_daily_tally` AS MDT, employee AS E WHERE MDT.post_by=E.employee_id ".$searchWHEREcond." ORDER BY MDT.`metal_daily_tally_id` DESC";
		$CONNlistDet = $connection->executeQuery($QURYlistDet);
		$FTCHlistDet = $CONNlistDet->fetchAll();
		$CONTlistDet= count($FTCHlistDet);
		
		$data = "";
		for($i=0; $i<=$CONTlistDet-1; $i++)
		{
			$QURYrecEMP = "SELECT emp_name FROM `employee` WHERE employee_id=".$FTCHlistDet[$i]['employee_id'];
			$CONNrecEMP = $connection->executeQuery($QURYrecEMP);
			$FTCHrecEMP = $CONNrecEMP->fetchAll();		

			$data .= '<tr>
						<td title="Serial No." style="text-align:center; vertical-align: middle;">'.($i+1).'</td>
						<td title="Showing - Worker Name" style="text-align:left; vertical-align: middle;">'.$FTCHrecEMP[0]['emp_name'].'</td>
              			<td title="Showing - Last Carry Forword Balance Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]['exist_stock_wgt_rfrnc'].'</td>
						<td title="Showing - Difference/Actual Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]['rec_wgt'].'</td>
						<td title="Showing - Entered Person Name" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['emp_name'].'</td>
						<td title="Showing - Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['entryDT'].'</td>';
			$data .= '</tr>';
		}		
		
		return $this->render('reports/daily-tally-report.html.twig', [
			'postWrkID' => $work_id,
			'postDATEfrm' => $DATEfrm,
			'postDATEto' => $DATEto,
			'empDATAs' =>  $FTCHemp,
			'DAILYtallyDATAs' =>  $data,
			'controller_name' => 'ReportsController'
        ]);
    }
	
    /**
     * @Route("/recovery-report", name="recovery-report") 
     */
    public function recoveryREPORTact(Request $request)  
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		date_default_timezone_set("Asia/Kolkata");
		$nwDate 	= date("Y-m-d");
		
		#--------[ GET DEPT LIST
		$QURYdeptlist	= "SELECT `dept_id`, `dept_name` FROM `dept` WHERE `role_status`=1 AND `avail_dept`=1 ORDER BY `dept_name` ASC";
		$CONNdeptlist	= $connection->executeQuery($QURYdeptlist);
		$FTCHdeptlist	= $CONNdeptlist->fetchAll();
		
		########-[ GET LAST INSERTED TRANSATION NO
//		$QURYlastDeptID = "SELECT `dept_id` FROM `prod_iss_rec` WHERE `prod_iss_rec_id`=(SELECT MAX(`prod_iss_rec_id`) FROM `prod_iss_rec`)";
		$QURYlastTRANno = "SELECT `trans_no` AS lastTRANinstNO FROM `prod_iss_rec` WHERE `prod_iss_rec_id`=(SELECT MAX(`prod_iss_rec_id`) FROM `prod_iss_rec`)";
		$CONNlastTRANno	= $connection->executeQuery($QURYlastTRANno);
		$FTCHlastTRANno	= $CONNlastTRANno->fetchAll();
		$RSLTlastTRANno	= $FTCHlastTRANno[0]['lastTRANinstNO'];
		
		########-[ GET LAST INSERTED DEPT ID
		$QURYlastDeptID = "SELECT `dept_id` FROM `prod_iss_rec` WHERE `trans_no`='".$RSLTlastTRANno."'";
		$CONNlastDeptID	= $connection->executeQuery($QURYlastDeptID);
		$FTCHlastDeptID	= $CONNlastDeptID->fetchAll();
		$RSLTlastDeptID	= $FTCHlastDeptID[0]['dept_id'];		
		
		if($request->getMethod() == 'POST')
		{
			#--------[ GET EMPLOYEE LIST
			//$QURYemplist	= "SELECT Emp.employee_id, Emp.emp_name FROM `prod_iss_rec` AS prodISSrec, employee AS Emp WHERE prodISSrec.dept_id='".$dept_id."' AND prodISSrec.employee_id=Emp.employee_id AND prodISSrec.recovered_wgt_id=0 GROUP BY prodISSrec.employee_id ORDER BY Emp.emp_name";
			
			$dept_id	= $request->get('dept_id');
			$employee_id= $request->get('employee_id');
			$DATEfrm	= explode("-", $request->get('DATEfrm'));
			$DATEfrm	= $DATEfrm[0]."-".$DATEfrm[1]."-".$DATEfrm[2];			
			$DATEto		= explode("-", $request->get('DATEto'));
			$DATEto		= $DATEto[0]."-".$DATEto[1]."-".$DATEto[2];			
			
			if($DATEfrm != '--'){
				$searchWHEREcond .= ' AND prodISSrec.trans_date BETWEEN "'.$DATEfrm.'" AND "'.$DATEto.'" ';
			}

			$QURYemplist	= "SELECT Emp.employee_id, Emp.emp_name FROM `prod_iss_rec` AS prodISSrec, employee AS Emp WHERE prodISSrec.dept_id='".$dept_id."' AND prodISSrec.employee_id=Emp.employee_id GROUP BY prodISSrec.employee_id ORDER BY Emp.emp_name";
			$CONNemplist	= $connection->executeQuery($QURYemplist);
			$FTCHemplist	= $CONNemplist->fetchAll();			

			$QURYtranslist	= "SELECT D.dept_name, E.emp_name, prodISSrec.recovered_wgt_id, SUM(prodISSrec.`wgt`) AS wgt, SUM(prodISSrec.`no_of_pieces`) AS no_of_pieces, SUM(prodISSrec.`spare_wgt`) AS spare_wgt, SUM(prodISSrec.`st_wt`) AS st_wt, SUM(prodISSrec.`enam_wgt`) AS enam_wgt FROM `prod_iss_rec` AS prodISSrec, `dept` AS D, `employee` AS E WHERE prodISSrec.dept_id='$dept_id' AND prodISSrec.employee_id='$employee_id' AND prodISSrec.`type`='iss' AND prodISSrec.dept_id=D.dept_id AND prodISSrec.employee_id=E.employee_id ";
			$CONNtranslist	= $connection->executeQuery($QURYtranslist);
			$FTCHtranslist	= $CONNtranslist->fetchAll();
			$CONTtranslist	= count($FTCHtranslist) - 1;
			
			$issRECtranDATA = "";
			$recWGT	= 0;
			for($i=0; $i<=$CONTtranslist; $i++)
			{
			
				if($DATEfrm != '--'){
					$searchWHEREcond1 .= ' AND post_dt BETWEEN "'.$DATEfrm.' 00:00:00" AND "'.$DATEto.' 23:59:59" ';
				}
				
				$QURYtranRECwgt	= "SELECT SUM(recovered_wgt) AS recoveredWgt, SUM(loss_wgt) AS lossWgt, notes, post_by, DATE_FORMAT(post_dt, '%b %d, %Y - %r') AS entryDT FROM `recovered_wgt` WHERE dept_id ='".$dept_id."' AND employee_id='".$employee_id."' AND role_status=1 ".$searchWHEREcond1;
				$CONNtranRECwgt	= $connection->executeQuery($QURYtranRECwgt);
				$FTCHtranRECwgt	= $CONNtranRECwgt->fetchAll();
				
				if(!isset($FTCHtranRECwgt[0]['recoveredWgt'])){
					$recoveredWgt  = "0.00";
				} else {
					$recoveredWgt  = $FTCHtranRECwgt[0]['recoveredWgt'];
				}
				
				$QURYentryName	= "SELECT emp_name AS entName FROM `employee` WHERE employee_id='".$FTCHtranRECwgt[0]['post_by']."' ";
				$CONNentryName	= $connection->executeQuery($QURYentryName);
				$FTCHentryName	= $CONNentryName->fetchAll();
				
				$issRECtranDATA .= '<tr>
										<td title="Serial No." style="text-align:center; vertical-align: middle; width:5%;">'.($i+1).'</td>';
					$issRECtranDATA .= '<td title="Department" style="text-align:left; vertical-align: middle; width:15%;">'.$FTCHtranslist[$i]['dept_name'].'</td>';
					$issRECtranDATA .= '<td title="Employee" style="text-align:left; vertical-align: middle; width:15%;">'.$FTCHtranslist[$i]['emp_name'].'</td>';
					$issRECtranDATA .= '<td title="Recovered Weight (grams)" style="text-align:right; vertical-align: middle; width:15%;"><div id="recoveredWGTcal'.$i.'">'.(number_format($recoveredWgt, 2)).'</div></td>';
					$issRECtranDATA .= '<td title="Loss Weight (grams)" style="text-align:right; vertical-align: middle; width:15%;"><div id="recoveredWGTcal'.$i.'">'.(number_format($lossWgt, 2)).'</div></td>';
					$issRECtranDATA .= '<td title="Notes" style="text-align:center; vertical-align: middle;">'.$FTCHtranRECwgt[0]['notes'].'</td>';
					$issRECtranDATA .= '<td title="Entered Person Name" style="text-align:center; vertical-align: middle;">'.$FTCHentryName[0]['entName'].'</td>';
					$issRECtranDATA .= '<td title="Action" style="text-align:center; vertical-align: middle;">'.$FTCHtranRECwgt[0]['entryDT'].'</td>';
				$issRECtranDATA .= '</tr>';
			}
		}
		else
		{
			$dept_id	= "";
			$employee_id= "";
			$DATEfrm	= "";
			$DATEto		= "";			
		}		

		return $this->render('reports/recovery-report.html.twig', [
			'postDEPTid' => $dept_id,
			'postEMPLid' => $employee_id,
			'postDATEfrm' => $DATEfrm,
			'postDATEto' => $DATEto,
			'deptlist' => $FTCHdeptlist,
			'emplist' => $FTCHemplist,
//			'prodTRANSlist' => $FTCHtranslist,
			'issRECtranDATA' => $issRECtranDATA,
			'recTOTwgt' => $recTOTwgt,
			'controller_name' => 'ReportsController'
        ]);
    }


    /**
     * @Route("/metal-acknow-report", name="metal-acknow-report")
     */
    public function metalAcknowREPORTact(Request $request)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");

		if($request->getMethod() == 'POST')
		{
			$issued_by 	= $request->get('issued_by');
			$DATEfrm 	= explode("-", $request->get('DATEfrm'));
			$DATEfrm 	= $DATEfrm[0]."-".$DATEfrm[1]."-".$DATEfrm[2];			
			$DATEto  	= explode("-", $request->get('DATEto'));
			$DATEto  	= $DATEto[0]."-".$DATEto[1]."-".$DATEto[2];			
			
			if($issued_by != NULL){
				$searchWHEREcond .= ' AND MI.metal_issued_by="'.$issued_by.'" ';
			}
			
			if($DATEfrm != '--'){
				$searchWHEREcond .= ' AND MI.`post_dt` BETWEEN "'.$DATEfrm.' 00:00:00" AND "'.$DATEto.' 23:59:59" ';
			}
		}	
		else
		{
			$issued_by = '';
			$DATEfrm = '';
			$DATEto  = '';
		}
		
		########-[ LIST 
		//$QURYlistDet= "SELECT MI.metal_issue_id, MA.metal_accessories_name, FORMAT(MI.issed_wgt, 2) AS issed_wgt, E.emp_name, DATE_FORMAT(MI.post_dt, '%b %d, %Y - %r') AS entryDT, MI.acknow_post_by, FORMAT(MI.acknow_wgt, 2) AS acknow_wgt, DATE_FORMAT(MI.`acknow_post_dt`, '%b %d, %Y - %r') AS acknowDT, MI.issued_to_flag, MI.acknow_status FROM `metal_issue` AS MI, metal_accessories AS MA, employee AS E WHERE MI.metal_accessories_id=MA.metal_accessories_id AND MI.post_by=E.employee_id AND MI.`issued_to_flag`='PIS' ORDER BY MI.`metal_issue_id` DESC";
		//$QURYlistDet= "SELECT MI.metal_issue_id, MA.metal_accessories_name, FORMAT(MI.issed_wgt, 2) AS issed_wgt, E.emp_name, DATE_FORMAT(MI.post_dt, '%b %d, %Y - %r') AS entryDT, MI.acknow_post_by, FORMAT(MI.acknow_wgt, 2) AS acknow_wgt, DATE_FORMAT( MI.`acknow_post_dt`, '%b %d, %Y - %r' ) AS acknowDT, MI.issued_to_flag, MI.acknow_status FROM `metal_issue` AS MI, metal_accessories AS MA, employee AS E WHERE MI.metal_accessories_id=MA.metal_accessories_id AND MI.post_by=E.employee_id AND MI.`issued_to_flag`='PIS' ORDER BY MI.`metal_issue_id` DESC";
		
		$QURYlistDet= "SELECT MI.metal_issue_id, MA.metal_accessories_name, FORMAT(MI.issed_wgt, 2) AS issed_wgt, E.emp_name, DATE_FORMAT(MI.post_dt, '%b %d, %Y - %r') AS entryDT, MI.acknow_post_by, FORMAT(MI.acknow_wgt, 2) AS acknow_wgt, DATE_FORMAT(MI.`acknow_post_dt`, '%b %d, %Y - %r') AS acknowDT, MI.issued_to_flag, MI.acknow_status FROM `metal_issue` AS MI, metal_accessories AS MA, employee AS E WHERE MI.metal_accessories_id=MA.metal_accessories_id AND MI.post_by=E.employee_id ".$searchWHEREcond."  ORDER BY MI.`metal_issue_id` DESC";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();
		$CONTlistDet= count($FTCHlistDet);
		
		$data = "";
		for($i=0; $i<=$CONTlistDet-1; $i++)
		{
			
			if($FTCHlistDet[$i]['acknow_wgt'] == 0)
			{
				$acknow_wgt = "";
				$readonly	= "";
			}
			else
			{
				$acknow_wgt = $FTCHlistDet[$i]['acknow_wgt'];
				$readonly	= "readonly";
			}
			
			if($FTCHlistDet[$i]['acknow_post_by'] == 0)
			{
				$acknowBY = "Nil";
				$acknowDT = "MMM DD, YYYY - HH:MM";
			}
			else
			{
				$QURY	  = "SELECT `emp_name` FROM `employee` WHERE `employee_id`=".$FTCHlistDet[$i]['acknow_post_by'];
				$CONN	  = $connection->executeQuery($QURY);
				$FTCH	  = $CONN->fetchAll();
				$acknowBY = $FTCH[0]['emp_name'];				
				
				$acknowDT = $FTCHlistDet[$i]['acknowDT'];				
			}


			$acknow_status 	= $FTCHlistDet[$i]['acknow_status'];
			
			if($acknow_status == "Awaiting")
			{
				$font_color = "orange";
			}
			else if($acknow_status == "Accepted")
			{
				$font_color = "#66CC00";
			}
			else if($acknow_status == "Found Diff.")
			{
				$font_color = "#ff0000";
			}
			
			$data .= '<tr>
						<td title="Serial No." style="text-align:center; vertical-align: middle;">'. ($i+1) .'</td>
						<td title="Showing - Metal/Spares/Accessories Name" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['metal_accessories_name'].'</td>
              			  <td title="Showing - Issued Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]['issed_wgt'].'</td>
						  <td title="Showing - Issued Person Name" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['emp_name'].'</td>
						  <td title="Showing - Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['entryDT'].'</td>';
				/*
				$data .= '<td title="Showing - Acknowledged Weight in Grams" style="text-align:right; vertical-align: middle;"><input type="text" class="form-control" id="acknowWGT'.$i.'" name="acknowWGT'.$i.'" value="'.number_format($acknow_wgt, 2).'" '.$readonly.' placeholder="0.00"  style="text-align:right; width:100px;" />&nbsp;<i class="fas fa-check-circle" title="Accept" onclick="return acceptACKNOW('.$i.', '.$FTCHlistDet[$i]['metal_issue_id'].', '.$FTCHlistDet[$i]['issed_wgt'].' )"></i></td>';
				*/
				$data .= '<td title="Showing - Acknowledged Weight in Grams" style="text-align:right; vertical-align: middle;">'.number_format($acknow_wgt, 2).'</td>';
				$data .= '<td title="Showing - Acknowledged Person Name" style="text-align:left; vertical-align: middle;">'.$acknowBY.'</td>
						  <td title="Showing - Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;">'.$acknowDT.'</td>
						  <td title="Showing - Status of Acknowledgement" id="acknowST'.$i.'" style="text-align:center; vertical-align: middle; color:'.$font_color.'; font-weight:800;"><span id="acknowST'.$i.'">'.$acknow_status.'</span></td>';
			$data .= '</tr>';
		}		
		
		return $this->render('reports/metal-acknow-report.html.twig', [
			'postISSUEDby' => $issued_by,
			'postDATEfrm' => $DATEfrm,
			'postDATEto' => $DATEto,
			'acknowDATAlist' => $data,
			'controller_name' => 'ReportsController'
        ]);
    }
	
    /**
     * @Route("/metal-name-change-report", name="metal-name-change-report")
     */
    public function metalNAMEchangeREPORTact(Request $request)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta");
		$nowDateTime = date("Y-m-d H:i:s");
		
		#--------[ FETCH Metal Items of Metal Name Change
		$QURYmetITEM = "SELECT MA.metal_accessories_id, MA.metal_accessories_name FROM `metal_conver_acces` AS MCA, `metal_accessories` AS MA WHERE MCA.metal_accessories_id=MA.metal_accessories_id ORDER BY MA.metal_accessories_name ASC";
		$CONNmetITEM = $connection->executeQuery($QURYmetITEM);
		$FTCHmetITEM = $CONNmetITEM->fetchAll();
		
		if($request->getMethod() == 'POST')
		{
			$prod_id	= $request->get('prod_id');
			$DATEfrm	= explode("-", $request->get('DATEfrm'));
			$DATEfrm	= $DATEfrm[0]."-".$DATEfrm[1]."-".$DATEfrm[2];			
			$DATEto		= explode("-", $request->get('DATEto'));
			$DATEto		= $DATEto[0]."-".$DATEto[1]."-".$DATEto[2];			
			
			if($prod_id != NULL){
				$searchWHEREcond .= ' AND MCA.metal_accessories_id="'.$prod_id.'" ';
			}
			
			if($DATEfrm != '--'){
				$searchWHEREcond .= ' AND MCA.`post_dt` BETWEEN "'.$DATEfrm.' 00:00:00" AND "'.$DATEto.' 23:59:59" ';
			}
		}
		else
		{
			$prod_id	= "";
			$DATEfrm	= "";
			$DATEto		= "";
		}
		
		#--------[ FETCH
		$QURY = "SELECT MCA.`metal_conver_acces_id`, MA.`metal_accessories_name`, FORMAT(MCA.`acces_conver_wgt`, 2) AS acces_conver_wgt, FORMAT(MCA.`acces_conver_loss_wgt`, 2) AS acces_conver_loss_wgt, LENGTH(MCA.`remarks_qr`) AS remarksLENGTH, SUBSTRING(MCA.`remarks_qr`, 1,9) AS remarksSUBSTR, MCA.`remarks_qr`, E.`emp_name`, DATE_FORMAT(MCA.`post_dt`, '%b %d, %Y - %r') AS entryDT FROM `metal_conver_acces` AS MCA, `metal_accessories` AS MA, `employee` AS E WHERE MCA.`metal_accessories_id`=MA.`metal_accessories_id` AND MCA.`role_status`=1 AND E.`employee_id`=MCA.`post_by` ".$searchWHEREcond." ORDER BY MCA.`metal_conver_acces_id` DESC";
		$CONN = $connection->executeQuery($QURY);
		$FTCH = $CONN->fetchAll();		
		
		
		return $this->render('reports/metal-name-change-report.html.twig', [
			'postPRODid' => $prod_id,
			'postDATEfrm' => $DATEfrm,
			'postDATEto' => $DATEto,
			'metITEM' => $FTCHmetITEM,
			'metCONVacesLIST' => $FTCH,
			'controller_name' => 'ReportsController'
        ]);
    }

	
    /**
     * @Route("/wax-entry-report", name="wax-entry-report")
     */
    public function waxEntryREPORTact(Request $request)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta");
		$nowDateTime = date("Y-m-d H:i:s");

		#--------[ FETCH - ALL EMP LISTED
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM employee AS E WHERE E.role_status=1 ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();	

		
		if($request->getMethod() == 'POST')
		{
			$emp_id		= $request->get('emp_id');
			$process_id	= $request->get('process_id');
			$ordNo		= $request->get('ordNo');
			$DATEfrm	= explode("-", $request->get('DATEfrm'));
			$DATEfrm	= $DATEfrm[0]."-".$DATEfrm[1]."-".$DATEfrm[2];			
			$DATEto		= explode("-", $request->get('DATEto'));
			$DATEto		= $DATEto[0]."-".$DATEto[1]."-".$DATEto[2];			
			
			if($emp_id != NULL && $process_id != NULL){
				if($process_id == "injection"){  
					$searchWHEREcond .= ' AND WE.injection_emp_id="'.$emp_id.'" ';
				} elseif($process_id == "cleaning"){ 
					$searchWHEREcond .= ' AND WE.cleaning_emp_id="'.$emp_id.'" ';
				}elseif($process_id == "sizing"){ 
					$searchWHEREcond .= ' AND WE.sizing_emp_id="'.$emp_id.'" ';
				}
			}
			
			if($ordNo != NULL){
				$searchWHEREcond .= ' AND CONCAT( OP.po_open_ord_code, "", OP.po_open_ord_no )="'.$ordNo.'" ';
			}
			
			if($DATEfrm != '--'){
				$searchWHEREcond .= ' AND WE.`post_dt` BETWEEN "'.$DATEfrm.' 00:00:00" AND "'.$DATEto.' 23:59:59" ';
			}
		}
		else
		{
			$emp_id		= "";
			$process_id = "";
			$ordNo 		= "";
			$DATEfrm	= "";
			$DATEto		= "";
		}
		
		#--------[ FETCH
		$QURY = "SELECT WE.injection_emp_id, WE.cleaning_emp_id, WE.sizing_emp_id, OPD.`po_open_ord_det_id`, OP.po_open_ord_id, CONCAT( OP.po_open_ord_code, '', OP.po_open_ord_no ) AS opNO, OPD.jc_no, FORMAT(OP.avg_tot_wgt, 2) AS ordTOTwgt, DATE_FORMAT(OP.post_dt, '%b %D, %y %I:%i %p') AS entry_date, P.concern_name, P.party_name, OPD.cat_shortname, OPD.typ_e, FORMAT(OPD.wgt_range_from, 2) AS wgt_range_from, FORMAT(OPD.wgt_range_to, 2) AS wgt_range_to, FORMAT(OPD.avg_wgt_per_pcs, 2) AS avg_wgt_per_pcs, OPD.ord_qty, FORMAT(OPD.avg_wgt_range, 2) AS avg_wgt_range, OPD.ord_spec FROM `po_open_ord_det` AS OPD, `po_open_ord` AS OP, `party` AS P, `wax_entry` AS WE WHERE OPD.po_open_ord_id = OP.po_open_ord_id AND OP.party_id = P.party_id AND OPD.jc_no_split_status = 'Yes' AND OPD.design_id = 0 AND OPD.wgt_range_to != 0 AND(ord_type != 'sp' OR ord_type != 'rp') AND WE.po_open_ord_id=OP.po_open_ord_id AND WE.po_open_ord_det_id=OPD.po_open_ord_det_id ".$searchWHEREcond." ORDER BY OP.po_open_ord_id DESC";
		$CONN = $connection->executeQuery($QURY);
		$FTCH = $CONN->fetchAll();
		$CONT = count($FTCH) - 1;
		
		$data = "";	
		for($i=0; $i<=$CONT; $i++)
		{
			$data .= '<tr>
						<td title="Serial No." style="text-align:center; vertical-align: middle;">'.($i+1).'</td>
					  	<td title="Showing - Party Name" style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['party_name'].'</td>
					  	<td title="Showing - Order No." style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['opNO'].'</td>
					  	<td title="Showing - JC No." style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['jc_no'].'</td>
					  	<td title="Showing - Product Name" style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['cat_shortname'].'</td>';
			  			
						if($FTCH[$i]['typ_e'] == 0){ $type = "Plain"; } else { $type = "Stone"; }
						
			  $data .= '<td title="Showing - Type (Stone/Plain)" style="text-align:left; vertical-align: middle;">'.$type.'</td>
					  	<td title="Showing - Average Weight in grams" style="text-align:right; vertical-align: middle;">'.$FTCH[$i]['avg_wgt_range'].'</td>
					  	<td title="Showing - Quantity" style="text-align:center; vertical-align: middle;">'.$FTCH[$i]['ord_qty'].'</td>';
									
						$quryJCwgt = "SELECT FORMAT(`wgt`, 2) AS jcWGT FROM `prod_iss_rec` WHERE `po_id`='".$FTCH[$i]['po_open_ord_det_id']."' ORDER BY `prod_iss_rec_id` DESC LIMIT 1";
						$connJCwgt = $connection->executeQuery($quryJCwgt);
						$ftchJCwgt = $connJCwgt->fetchAll();
						$rsltJCwgt = $ftchJCwgt[0]['jcWGT'];
						
			  $data .= '<td title="Showing - JC Weight in grams" style="text-align:right; vertical-align: middle;">'.$rsltJCwgt.'</td>';
			  		
						
						$quryINJemp = "SELECT E.emp_name FROM `wax_entry` AS WE, employee AS E WHERE WE.po_open_ord_det_id='".$FTCH[$i]['po_open_ord_det_id']."' AND WE.injection_emp_id=E.employee_id";
						$connINJemp = $connection->executeQuery($quryINJemp);
						$ftchINJemp = $connINJemp->fetchAll();
						
						if($process_id == ""){
							$INJECTNemp = $ftchINJemp[0]['emp_name'];
						} elseif($process_id == "injection"){
							$INJECTNemp = $ftchINJemp[0]['emp_name'];
						} else {
							$INJECTNemp = "";
						}

						$quryCLEemp = "SELECT E.emp_name FROM `wax_entry` AS WE, employee AS E WHERE WE.po_open_ord_det_id='".$FTCH[$i]['po_open_ord_det_id']."' AND WE.cleaning_emp_id=E.employee_id";
						$connCLEemp = $connection->executeQuery($quryCLEemp);
						$ftchCLEemp = $connCLEemp->fetchAll();
						
						if($process_id == ""){
							$CLEANINemp = $ftchCLEemp[0]['emp_name'];
						} elseif($process_id == "cleaning"){
							$CLEANINemp = $ftchCLEemp[0]['emp_name'];
						} else {
							$CLEANINemp = "";
						}						
						
						$qurySZGemp = "SELECT E.emp_name FROM `wax_entry` AS WE, employee AS E WHERE WE.po_open_ord_det_id='".$FTCH[$i]['po_open_ord_det_id']."' AND WE.sizing_emp_id=E.employee_id";
						$connSZGemp = $connection->executeQuery($qurySZGemp);
						$ftchSZGemp = $connSZGemp->fetchAll();
						
						if($process_id == ""){
							$SIZINGemp  = $ftchSZGemp[0]['emp_name'];
						} elseif($process_id == "sizing"){
							$SIZINGemp  = $ftchSZGemp[0]['emp_name'];
						} else {
							$SIZINGemp  = "";
						}
						
			  $data .= '<td title="Showing - Injection Process" style="text-align:left; vertical-align: middle;">'.$INJECTNemp.'</td>
			  			<td title="Showing - Cleaning Process" style="text-align:left; vertical-align: middle;">'.$CLEANINemp.'</td>
						<td title="Showing - Sizing Process" style="text-align:left; vertical-align: middle;">'.$SIZINGemp.'</td>';	
			  /*
			  $data .= '<td title="Showing - Opt Worker Name" style="text-align:left; vertical-align: middle;">Opt Name</td>';
			  */
			  $data .= '<td title="Showing - Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['entry_date'].'</td>
					</tr>';
		}
		
		
		return $this->render('reports/wax-entry-report.html.twig', [
			'postEMPid' => $emp_id,
			'postPROCid' => $process_id,
			'postORDno' => $ordNo,
			'postDATEfrm' => $DATEfrm,
			'postDATEto' => $DATEto,
			'empDATAs' => $FTCHemp,
			'data' => $data,
			'controller_name' => 'ReportsController'
        ]);
    }
	
		
    /**
     * @Route("/wax-setting-report", name="wax-setting-report")
     */
    public function waxSettingREPORTact(Request $request)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta");
		$nowDateTime = date("Y-m-d H:i:s");

		#--------[ FETCH - ALL EMP LISTED
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM employee AS E WHERE E.role_status=1 ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();	
		
		#--------[ FETCH - PARTY DATA's
		$QURYpartDATAs = "SELECT `party_id`, CONCAT(`concern_name`,' - ',`party_name`,' - [',`pid`,']') AS partyName FROM `party` WHERE `role_status`=1 ORDER BY `concern_name` ASC";
		$CONNpartDATAs = $connection->executeQuery($QURYpartDATAs);
		$FTCHpartDATAs = $CONNpartDATAs->fetchAll();	

		
		if($request->getMethod() == 'POST')
		{
			$emp_id		= $request->get('emp_id');
			$party_id	= $request->get('party_id');
			$ordNo		= $request->get('ordNo');
			$prodName	= $request->get('prodName');
			$DATEfrm	= explode("-", $request->get('DATEfrm'));
			$DATEfrm	= $DATEfrm[0]."-".$DATEfrm[1]."-".$DATEfrm[2];			
			$DATEto		= explode("-", $request->get('DATEto'));
			$DATEto		= $DATEto[0]."-".$DATEto[1]."-".$DATEto[2];			
			
			if($emp_id != NULL){
				$searchWHEREcond .= ' AND WSD.st_source_emp_id="'.$emp_id.'" ';
			}
			
			if($party_id != NULL){
				$searchWHEREcond .= ' AND PO.party_id="'.$party_id.'" ';
			}
			
			if($ordNo != NULL){
				$searchWHEREcond .= ' AND CONCAT( PO.po_open_ord_code, "", PO.po_open_ord_no )="'.$ordNo.'" ';
			}
			
			if($prodName != NULL){
				$searchWHEREcond .= ' AND POD.cat_shortname="'.$prodName.'" ';
			}
			
			if($DATEfrm != '--'){
				$searchWHEREcond .= ' AND WS.`post_dt` BETWEEN "'.$DATEfrm.' 00:00:00" AND "'.$DATEto.' 23:59:59" ';
			}
		}
		else
		{
			$emp_id		= "";
			$party_id 	= "";
			$ordNo 		= "";
			$prodName   = "";
			$DATEfrm	= "";
			$DATEto		= "";
		}
		
		#--------[ FETCH
		$QURY = "SELECT
					POD.po_open_ord_det_id,
					P.party_name,
					CONCAT(
						PO.po_open_ord_code,
						'',
						PO.po_open_ord_no
					) AS opNO,
					POD.jc_no,
					POD.cat_shortname,
					POD.typ_e,
					FORMAT(POD.avg_wgt_per_pcs, 2) AS avg_wgt_per_pcs,
					POD.ord_qty,
					S.stone_shape,
					S.stone_color,
					S.stone_size,
					WS.tot_st_qty,
					FORMAT(WS.tot_st_wgt, 2) AS stWgt,
					FORMAT(WSD.st_wt_sub_tot, 2) AS masterSTwgt,
					FORMAT(WSD.st_wt_sub_tot_diff, 2) AS actSTwgt,
					E.emp_name,
					DATE_FORMAT(WS.post_dt, '%b %D, %y %I:%i %p') AS entry_date
				FROM
					`wax_setting` AS WS,
					`wax_setting_det` AS WSD,
					`po_open_ord` AS PO,
					`po_open_ord_det` AS POD,
					`stones` AS S,
					`employee` AS E,
					`party` AS P
				WHERE
					WSD.po_open_ord_id = PO.po_open_ord_id AND WSD.po_open_ord_det_id = POD.po_open_ord_det_id AND WSD.stones_id = S.stones_id AND WSD.`wax_setting_id` = WS.wax_setting_id AND WS.st_source_emp_id = E.employee_id AND PO.party_id=P.party_id ".$searchWHEREcond."
				ORDER BY
					WSD.`wax_setting_id`
				DESC
					,
					WSD.`row_no` ASC";
		$CONN = $connection->executeQuery($QURY);
		$FTCH = $CONN->fetchAll();
		$CONT = count($FTCH) - 1;
		
		$data = "";	
		for($i=0; $i<=$CONT; $i++)
		{
			$data .= '<tr>
						<td title="Serial No." style="text-align:center; vertical-align: middle;">'.($i+1).'</td>
					  	<td title="Showing - Party Name" style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['party_name'].'</td>
					  	<td title="Showing - Order No." style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['opNO'].'</td>
					  	<td title="Showing - JC No." style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['jc_no'].'</td>
					  	<td title="Showing - Product Name" style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['cat_shortname'].'</td>';
			  			
						if($FTCH[$i]['typ_e'] == 0){ $type = "Plain"; } else { $type = "Stone"; }
						
			  $data .= '<td title="Showing - Type (Stone/Plain)" style="text-align:left; vertical-align: middle;">'.$type.'</td>
					  	<td title="Showing - Average Weight in grams" style="text-align:right; vertical-align: middle;">'.$FTCH[$i]['avg_wgt_per_pcs'].'</td>
					  	<td title="Showing - Quantity" style="text-align:center; vertical-align: middle;">'.$FTCH[$i]['ord_qty'].'</td>';
									
						$quryJCwgt = "SELECT FORMAT(`wgt`, 2) AS jcWGT FROM `prod_iss_rec` WHERE `po_id`='".$FTCH[$i]['po_open_ord_det_id']."' ORDER BY `prod_iss_rec_id` DESC LIMIT 1";
						$connJCwgt = $connection->executeQuery($quryJCwgt);
						$ftchJCwgt = $connJCwgt->fetchAll();
						$rsltJCwgt = $ftchJCwgt[0]['jcWGT'];
						
			  $data .= '<td title="Showing - JC Weight in grams" style="text-align:right; vertical-align: middle;">'.$rsltJCwgt.'</td>';
						
			  $data .= '<td title="Showing - Stone Shape" style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['stone_shape'].'</td>
  					    <td title="Showing - Stone Color" style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['stone_color'].'</td>
					    <td title="Showing - Stone Size" style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['stone_size'].'</td>
					    <td title="Showing - Stone Quantity" style="text-align:center; vertical-align: middle;">'.$FTCH[$i]['tot_st_qty'].'</td>
					    <td title="Showing - Stone Weight in grams" style="text-align:right; vertical-align: middle;">'.$FTCH[$i]['stWgt'].'</td>
					    <td title="Showing - Master Stone Weight in grams" style="text-align:right; vertical-align: middle;">'.$FTCH[$i]['masterSTwgt'].'</td>
					    <td title="Showing - Actual Stone Weight in grams" style="text-align:right; vertical-align: middle;">'.$FTCH[$i]['actSTwgt'].'</td>
						<td title="Showing - Stone Setting Employee" style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['emp_name'].'</td>';	
			  /*
			  $data .= '<td title="Showing - Opt Worker Name" style="text-align:left; vertical-align: middle;">Opt Name</td>';
			  */
			  $data .= '<td title="Showing - Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['entry_date'].'</td>
					</tr>';
		}
		
		
		return $this->render('reports/wax-setting-report.html.twig', [
			'postEMPid' => $emp_id,
			'postPARTYid' => $party_id,
			'postORDno' => $ordNo,
			'postPRDname' => $prodName,
			'postDATEfrm' => $DATEfrm,
			'postDATEto' => $DATEto,
			'empDATAs' => $FTCHemp,
			'partDATAs' => $FTCHpartDATAs,
			'data' => $data,
			'controller_name' => 'ReportsController'
        ]);
    }	
	
	
    /**
     * @Route("/wax-tree-making-report", name="wax-tree-making-report")
     */
    public function waxTreeMakingReportActions(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		#--------[ FETCH - ALL EMP LISTED
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM employee AS E WHERE E.role_status=1 ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();	
		
		#--------[ FETCH - PARTY DATA's
		$QURYpartDATAs = "SELECT `party_id`, CONCAT(`concern_name`,' - ',`party_name`,' - [',`pid`,']') AS partyName FROM `party` WHERE `role_status`=1 ORDER BY `concern_name` ASC";
		$CONNpartDATAs = $connection->executeQuery($QURYpartDATAs);
		$FTCHpartDATAs = $CONNpartDATAs->fetchAll();	

		if($request->getMethod() == 'POST')
		{
			$emp_id		= $request->get('emp_id');
			$party_id	= $request->get('party_id');
			$ordNo		= $request->get('ordNo');
			$treeNo		= $request->get('treeNo');
			$DATEfrm	= explode("-", $request->get('DATEfrm'));
			$DATEfrm	= $DATEfrm[0]."-".$DATEfrm[1]."-".$DATEfrm[2];			
			$DATEto		= explode("-", $request->get('DATEto'));
			$DATEto		= $DATEto[0]."-".$DATEto[1]."-".$DATEto[2];			
			
			if($emp_id != NULL){
				$searchWHEREcond .= ' AND TM.emp_id="'.$emp_id.'" ';
			}
			
			if($party_id != NULL){
				$searchWHEREcond .= ' AND ORD.party_id="'.$party_id.'" ';
			}
			
			if($ordNo != NULL){
				$searchWHEREcond .= ' AND CONCAT( ORD.po_open_ord_code, "", ORD.po_open_ord_no )="'.$ordNo.'" ';
			}
			
			if($treeNo != NULL){
				$searchWHEREcond .= ' AND CONCAT( TM.tree_no_code, "/", TM.tree_no )="'.$treeNo.'" ';
			}
			
			if($DATEfrm != '--'){
				$searchWHEREcond .= ' AND TMD.`post_dt` BETWEEN "'.$DATEfrm.' 00:00:00" AND "'.$DATEto.' 23:59:59" ';
			}
		}
		else
		{
			$emp_id		= "";
			$party_id 	= "";
			$ordNo 		= "";
			$treeNo   	= "";
			$DATEfrm	= "";
			$DATEto		= "";
		}
		
		#--------[ FETCH
		$QURY	= "SELECT E.emp_name, JC.po_open_ord_det_id, P.party_name, TMD.wax_tree_making_id, CONCAT( `po_open_ord_code`, `po_open_ord_no` ) AS openORDno, JC.jc_no, CONCAT(TM.tree_no_code, '/', TM.tree_no) AS tree_no, JC.cat_shortname, JC.typ_e, FORMAT(JC.avg_wgt_per_pcs, 3) AS avg_wgt_per_pcs, JC.ord_qty, FORMAT(TMD.st_wg, 3) AS st_wg, DATE_FORMAT(TM.post_dt, '%b %D, %y %I:%i %p') AS entry_date FROM `wax_tree_making_det` AS TMD, `wax_tree_making` AS TM, po_open_ord_det AS JC, po_open_ord AS ORD, employee AS E, party AS P WHERE TMD.wax_tree_making_id = TM.wax_tree_making_id AND TMD.po_open_ord_det_id = JC.po_open_ord_det_id AND TM.emp_id = E.employee_id AND JC.po_open_ord_id = ORD.po_open_ord_id AND ORD.party_id=P.party_id AND TM.emp_id=E.employee_id ".$searchWHEREcond." ORDER BY TMD.wax_tree_making_det_id DESC";
		$CONN	= $connection->executeQuery($QURY);
		$FTCH	= $CONN->fetchAll();
		$CONT	= count($FTCH);	
		
		$data = "";
		for($j=0; $j<=$CONT-1; $j++)
		{
			$jc_no = explode("-", $FTCH[$j]['jc_no']);
			$jc_no = $jc_no[1];		
			
			#--------[ FETCH - JC COUNT
			$QURYjcCONT = "SELECT COUNT(`wax_tree_making_det_id`) AS countJCs FROM `wax_tree_making_det` WHERE `wax_tree_making_id`='".$FTCH[$j]['wax_tree_making_id']."'";
			$CONNjcCONT = $connection->executeQuery($QURYjcCONT);
			$FTCHjcCONT = $CONNjcCONT->fetchAll();	
			$countJCs   = $FTCHjcCONT[0]['countJCs'];	
			
			#--------[ CHECK - JC in WAX ENTRY
			$QURYwxENT = "SELECT casting_iss_id FROM `casting_iss` WHERE `wax_tree_making_id`='".$FTCH[$j]['wax_tree_making_id']."'";
			$CONNwxENT = $connection->executeQuery($QURYwxENT);
			$FTCHwxENT = $CONNwxENT->fetchAll();
			$CHCKwxENT = $FTCHwxENT[0]['casting_iss_id'];					
		
			$data .= '<tr>
						<td title="Serial No." style="text-align:center; vertical-align: middle;">'.($j+1).'</td>
						<td title="Showing - Party Name" style="text-align:center; vertical-align: middle;">'.$FTCH[$j]['party_name'].'</td>
						<td title="Showing - Order No." style="text-align:left; vertical-align: middle;">'.$FTCH[$j]['openORDno'].'</td>
             		 	<td title="Showing - Job Card No." style="text-align:left; vertical-align: middle;">'.$FTCH[$j]['jc_no'].'</td>
						<td title="Showing - Tree No." style="text-align:center; vertical-align: middle;">'.$FTCH[$j]['tree_no'].'</td>
						<td title="Showing - Product Name" style="text-align:left; vertical-align: middle;">'.$FTCH[$j]['cat_shortname'].'</td>';
						
						if($FTCH[$i]['typ_e'] == 0){ $type = "Plain"; } else { $type = "Stone"; }
						
			  $data .= '<td title="Showing - Type (Stone/Plain)" style="text-align:left; vertical-align: middle;">'.$type.'</td>
						<td title="Showing - Average Weight in grams" style="text-align:right; vertical-align: middle;">'.$FTCH[$j]['avg_wgt_per_pcs'].'</td>
						<td title="Showing - Quantity" style="text-align:center; vertical-align: middle;">'.$FTCH[$j]['ord_qty'].'</td>';
						
						$quryJCwgt = "SELECT FORMAT(`wgt`, 2) AS jcWGT FROM `prod_iss_rec` WHERE `po_id`='".$FTCH[$i]['po_open_ord_det_id']."' ORDER BY `prod_iss_rec_id` DESC LIMIT 1";
						$connJCwgt = $connection->executeQuery($quryJCwgt);
						$ftchJCwgt = $connJCwgt->fetchAll();
						$rsltJCwgt = $ftchJCwgt[0]['jcWGT'];
						
			  $data .= '<td title="Showing - JC Weight in grams" style="text-align:right; vertical-align: middle;">'.$rsltJCwgt.'</td>
						<td title="Showing - Stone Weight in grams" style="text-align:right; vertical-align: middle;">'.$FTCH[$j]['st_wg'].'</td>
						<td title="Showing - Emp Name" style="text-align:left; vertical-align: middle;">'.$FTCH[$j]['emp_name'].'</td>
						<td title="Showing - Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;">'.$FTCH[$j]['entry_date'].'</td>
            		</tr>';
		}		

		return $this->render('reports/wax-tree-making-report.html.twig', [
			'postEMPid' => $emp_id,
			'postPARTYid' => $party_id,
			'postORDno' => $ordNo,
			'postTREEno' => $treeNo,
			'postDATEfrm' => $DATEfrm,
			'postDATEto' => $DATEto,
			'empDATAs' => $FTCHemp,
			'partDATAs' => $FTCHpartDATAs,
			'treeMAKING' => $FTCH,
			'data' => $data,
			'controller_name' => 'ReportsController'
        ]);	
	}

	
    /**
     * @Route("/tree-metal-casting-iss-rec-report", name="tree-metal-casting-iss-rec-report")
     */
    public function treeMetalCastingIssRecReportActions(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		if($request->getMethod() == 'POST')
		{
			$treeNo		= $request->get('treeNo');
			$DATEfrm	= explode("-", $request->get('DATEfrm'));
			$DATEfrm	= $DATEfrm[0]."-".$DATEfrm[1]."-".$DATEfrm[2];			
			$DATEto		= explode("-", $request->get('DATEto'));
			$DATEto		= $DATEto[0]."-".$DATEto[1]."-".$DATEto[2];			
			
			if($treeNo != NULL){
				$searchWHEREcond .= ' AND CONCAT( TM.tree_no_code, "/", TM.tree_no )="'.$treeNo.'" ';
			}
			
			if($DATEfrm != '--'){
				$searchWHEREcond .= ' AND CREC.`post_dt` BETWEEN "'.$DATEfrm.' 00:00:00" AND "'.$DATEto.' 23:59:59" ';
			}
		}
		else
		{
			$treeNo   	= "";
			$DATEfrm	= "";
			$DATEto		= "";
		}
		
		#--------[ FETCH
		$QURY	= "SELECT DISTINCT CONCAT(TM.tree_no_code, '/', TM.tree_no) AS tree_no, FORMAT(TM.`tot_wgt`, 3) AS waxTREEwgt, FORMAT(TM.tot_st_wgt, 3) AS StWgt, FORMAT(CISS.act_iss_mt_wt, 3) AS act_iss_mt_wt, FORMAT(CISS.iss_mt_wt, 3) AS iss_mt_wt, FORMAT(CREC.`orn_wgt`, 3) AS orn_wgt, FORMAT(CREC.mt_wgt, 3) AS mt_wgt, FORMAT(CREC.`loss_wgt`, 3) AS loss_wgt, E.emp_name, CREC.notess, DATE_FORMAT( CREC.post_dt, '%b %D, %y %I:%i %p' ) AS entry_date FROM `casting_rec` AS CREC, `casting_iss` AS CISS, `wax_tree_making` AS TM, `employee` AS E, `wax_tree_making_det` AS TMD WHERE CREC.wax_tree_making_id = TM.wax_tree_making_id AND TM.wax_tree_making_id = TMD.wax_tree_making_id AND CREC.emp_id = E.employee_id AND CREC.casting_iss_id=CISS.casting_iss_id ".$searchWHEREcond." ORDER BY CREC.`casting_rec_id` DESC";
		$CONN	= $connection->executeQuery($QURY);
		$FTCH	= $CONN->fetchAll();
		
		return $this->render('reports/tree-metal-casting-iss-rec-report.html.twig', [
			'postTREEno' => $treeNo,
			'postDATEfrm' => $DATEfrm,
			'postDATEto' => $DATEto,
			'empDATAs' => $FTCHemp,
			'partDATAs' => $FTCHpartDATAs,
			'FTCH' => $FTCH,
			'controller_name' => 'ReportsController'
        ]);	
	}
	
	
    /**
     * @Route("/sepration-report", name="sepration-report")
     */
    public function seprationReportActions(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		if($request->getMethod() == 'POST')
		{
			$treeNo		= $request->get('treeNo');
			$DATEfrm	= explode("-", $request->get('DATEfrm'));
			$DATEfrm	= $DATEfrm[0]."-".$DATEfrm[1]."-".$DATEfrm[2];			
			$DATEto		= explode("-", $request->get('DATEto'));
			$DATEto		= $DATEto[0]."-".$DATEto[1]."-".$DATEto[2];			
			
			if($treeNo != NULL){
				$searchWHEREcond .= ' AND CONCAT( TM.tree_no_code, "/", TM.tree_no )="'.$treeNo.'" ';
			}
			
			if($DATEfrm != '--'){
				$searchWHEREcond .= ' AND TMD.`sepration_date` BETWEEN "'.$DATEfrm.' 00:00:00" AND "'.$DATEto.' 23:59:59" ';
			}
		}
		else
		{
			$treeNo   	= "";
			$DATEfrm	= "";
			$DATEto		= "";
		}
		
		#--------[ FETCH
		$QURY	= "SELECT POD.po_open_ord_det_id, CONCAT(TM.tree_no_code, '/', TM.tree_no) AS tree_no, P.party_name, POD.jc_no, POD.cat_shortname, POD.typ_e, FORMAT(POD.avg_wgt_per_pcs, 3) AS avg_wgt_per_pcs, POD.ord_qty, FORMAT(TMD.jc_orn_wgt, 3) AS jc_orn_wgt, E.emp_name, DATE_FORMAT( TMD.sepration_date, '%b %D, %y %I:%i %p' ) AS entry_date FROM `wax_tree_making_det` AS TMD, `wax_tree_making` AS TM, po_open_ord_det AS POD, po_open_ord AS POO, party AS P, employee AS E WHERE TMD.wax_tree_making_id = TM.wax_tree_making_id AND TMD.po_open_ord_det_id = POD.po_open_ord_det_id AND TMD.jc_orn_wgt != 0 AND POD.po_open_ord_id=POO.po_open_ord_id AND POO.party_id=P.party_id AND TMD.sepration_emp_id=E.employee_id ".$searchWHEREcond." ORDER BY TMD.jc_no DESC";
		$CONN	= $connection->executeQuery($QURY);
		$FTCH	= $CONN->fetchAll();
		$CONT	= count($FTCH) - 1;
		
		$data = "";
		for($i=0; $i<=$CONT; $i++)
		{
			$data .= '<tr>
					   <td title="Serial No." style="text-align:center; vertical-align: middle;">'.($i + 1).'</td>
					   <td title="Showing - Tree No" style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['tree_no'].'</td>
					   <td title="Showing - Party Name" style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['party_name'].'</td>
					   <td title="Showing - Job Card No." style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['jc_no'].'</td>
					   <td title="Showing - Product Name" style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['cat_shortname'].'</td>';
					   
						if($FTCH[$i]['typ_e'] == 0){ $type = "Plain"; } else { $type = "Stone"; }
								   
			 $data .= '<td title="Showing - Type (Stone/Plain)" style="text-align:right; vertical-align: middle;">'.$type.'</td>
					   <td title="Showing - Average Weight in grams" style="text-align:right; vertical-align: middle;">'.$FTCH[$i]['avg_wgt_per_pcs'].'</td>
					   <td title="Showing - Quantity" style="text-align:center; vertical-align: middle;">'.$FTCH[$i]['ord_qty'].'</td>';
					   
					   	$quryJCwgt = "SELECT FORMAT(`wgt`, 2) AS jcWGT FROM `prod_iss_rec` WHERE `po_id`='".$FTCH[$i]['po_open_ord_det_id']."' ORDER BY `prod_iss_rec_id` DESC LIMIT 1";
						$connJCwgt = $connection->executeQuery($quryJCwgt);
						$ftchJCwgt = $connJCwgt->fetchAll();
						$rsltJCwgt = $ftchJCwgt[0]['jcWGT'];
					   
			 $data .= '<td title="Showing - Job Card Weight in grams" style="text-align:right; vertical-align: middle;">'.$rsltJCwgt.'</td>
					   <td title="Showing - Ornament Issue Weight in grams" style="text-align:right; vertical-align: middle;">'.$FTCH[$i]['jc_orn_wgt'].'</td>
					   <td title="Showing - Emp Name" style="text-align:right; vertical-align: middle;">'.$FTCH[$i]['emp_name'].'</td>
					   <td title="Showing - Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['entry_date'].'</td>
					 </tr>';		
		}
		
		return $this->render('reports/sepration-report.html.twig', [
			'postTREEno' => $treeNo,
			'postDATEfrm' => $DATEfrm,
			'postDATEto' => $DATEto,
			'data' => $data,
			'controller_name' => 'ReportsController'
        ]);	
	}	
	
	
    /**
     * @Route("/jc-dispatch-report", name="jc-dispatch-report")
     */
    public function jcDispatchReportActions(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		#--------[ FETCH - PARTY DATA's
		$QURYpartDATAs = "SELECT `party_id`, CONCAT(`concern_name`,' - ',`party_name`,' - [',`pid`,']') AS partyName FROM `party` WHERE `role_status`=1 ORDER BY `concern_name` ASC";
		$CONNpartDATAs = $connection->executeQuery($QURYpartDATAs);
		$FTCHpartDATAs = $CONNpartDATAs->fetchAll();		

		if($request->getMethod() == 'POST')
		{
			$party_id	= $request->get('party_id');
			//$order_no	= $request->get('order_no');
			$jc_no		= $request->get('jc_no');
			$prod_type	= $request->get('prod_type');
			$DATEfrm	= explode("-", $request->get('DATEfrm'));
			$DATEfrm	= $DATEfrm[0]."-".$DATEfrm[1]."-".$DATEfrm[2];			
			$DATEto		= explode("-", $request->get('DATEto'));
			$DATEto		= $DATEto[0]."-".$DATEto[1]."-".$DATEto[2];			
			
			if($party_id != NULL){
				$searchWHEREcond .= ' AND P.party_id="'.$party_id.'" ';
			}
			
			//if($order_no != NULL){
			if($jc_no != NULL){
				//$searchWHEREcond .= ' AND CONCAT(POO.po_open_ord_code, "", POO.po_open_ord_no)="'.$order_no.'" ';
				$searchWHEREcond .= ' AND POdet.jc_no="'.$jc_no.'" ';
			}
			
			if($prod_type != NULL){
				$searchWHEREcond .= ' AND POdet.typ_e="'.$prod_type.'" ';
			}
			
			if($DATEfrm != '--'){
				$searchWHEREcond .= ' AND jcDwgt.`post_dt` BETWEEN "'.$DATEfrm.' 00:00:00" AND "'.$DATEto.' 23:59:59" ';
			}
		}
		else
		{
			$party_id  	= "";
			$order_no  	= "";
			$prod_type 	= "";
			$DATEfrm	= "";
			$DATEto		= "";
		}
		
		#--------[ FETCH
		$QURY	= "SELECT P.party_name, POdet.jc_no, POdet.cat_shortname, POdet.typ_e, FORMAT(POdet.avg_wgt_per_pcs, 2) AS avg_wgt_per_pcs, jcDwgt.orn_fin_qty, FORMAT(jcDwgt.orn_fin_wgt, 2) AS orn_fin_wgt, jcDwgt.notess, DATE_FORMAT(POO.entry_date, '%b %D, %y %I:%i %p') AS poDATE, DATE_FORMAT(jcDwgt.post_dt, '%b %D, %y %I:%i %p') AS dispaDATE FROM `jc_dispatch_wgt` AS jcDwgt, po_open_ord_det AS POdet, po_open_ord AS POO, party AS P WHERE jcDwgt.jc_id = POdet.po_open_ord_det_id AND jcDwgt.party_id = P.party_id AND POdet.po_open_ord_id=POO.po_open_ord_id ".$searchWHEREcond." ORDER BY jcDwgt.jc_dispatch_wgt_id DESC";
		$CONN	= $connection->executeQuery($QURY);
		$FTCH	= $CONN->fetchAll();
		$CONT	= count($FTCH) - 1;
		
		$data = "";
		for($i=0; $i<=$CONT; $i++)
		{
			$data .= '<tr>
					   <td title="Serial No." style="text-align:center; vertical-align: middle;">'.($i+1).'</td>
					   <td title="Showing - Party Name" style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['party_name'].'</td>
					   <td title="Showing - Job Card No." style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['jc_no'].'</td>
					   <td title="Showing - Product Name" style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['cat_shortname'].'</td>';
					   
					   if($FTCH[$i]['typ_e'] == 0){ $type = "Plain"; } else { $type = "Stone"; }
					   
			 $data .= '<td title="Showing - Type (Stone/Plain)" style="text-align:right; vertical-align: middle;">'.$type.'</small></td>
					   <td title="Showing - Average Weight in grams" style="text-align:right; vertical-align: middle;">'.$FTCH[$i]['avg_wgt_per_pcs'].'</td>
					   <td title="Showing - Dispatch Quantity" style="text-align:center; vertical-align: middle;">'.$FTCH[$i]['orn_fin_qty'].'</td>
					   <td title="Showing - Dispatch Weight in grams" style="text-align:right; vertical-align: middle;">'.$FTCH[$i]['orn_fin_wgt'].'</td>
					   <td title="Showing - Notes" style="text-align:right; vertical-align: middle;">'.$FTCH[$i]['notess'].'</td>
					   <td title="Showing - Iss Date" style="text-align:right; vertical-align: middle;">'.$FTCH[$i]['poDATE'].'</td>
					   <td title="Showing - Rec Date" style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['dispaDATE'].'</td>
					 </tr>';		
		}
		
		return $this->render('reports/jc-dispatch-report.html.twig', [
			'postPARTYid' => $party_id,
			//'postORDERno' => $order_no,
			'postJCno' => $jc_no,
			'postPRODtype' => $prod_type,						
			'postDATEfrm' => $DATEfrm,
			'postDATEto' => $DATEto,
			'partDATAs' => $FTCHpartDATAs,
			'data' => $data,
			'controller_name' => 'ReportsController'
        ]);	
	}			


    /**
     * @Route("/dept-loss-report", name="dept-loss-report") 
     */
    public function deptLossREPORTact(Request $request)  
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		date_default_timezone_set("Asia/Kolkata");
		$nwDate 	= date("Y-m-d");
		
		#--------[ GET DEPT LIST
		//$QURYdeptlist	= "SELECT `dept_id`, `dept_name` FROM `dept` WHERE `role_status`=1 AND `avail_dept`=1 ORDER BY `dept_name` ASC";
		$QURYdeptlist	= "SELECT d.`dept_id`, d.`dept_name` FROM `recovered_wgt` AS rWGT, `dept` AS d WHERE rWGT.dept_id=d.dept_id GROUP BY rWGT.`dept_id` ORDER BY d.`dept_name`";
		$CONNdeptlist	= $connection->executeQuery($QURYdeptlist);
		$FTCHdeptlist	= $CONNdeptlist->fetchAll();
		
		if($request->getMethod() == 'POST')
		{
			$dept_id	= $request->get('dept_id');
			$employee_id= $request->get('employee_id');
			$DATEfrm	= explode("-", $request->get('DATEfrm'));
			$DATEfrm	= $DATEfrm[0]."-".$DATEfrm[1]."-".$DATEfrm[2];			
			$DATEto		= explode("-", $request->get('DATEto'));
			$DATEto		= $DATEto[0]."-".$DATEto[1]."-".$DATEto[2];			
			
			if($dept_id != NULL){
				$searchWHEREcond .= ' AND rWGT.dept_id = "'.$dept_id.'" ';
			}
			
			if($employee_id != NULL){
				$searchWHEREcond .= 'AND rWGT.employee_id = "'.$employee_id.'" ';
			}
			
			if($DATEfrm != '--'){
				$searchWHEREcond .= ' AND rWGT.`post_dt` BETWEEN "'.$DATEfrm.' 00:00:00" AND "'.$DATEto.' 23:59:59" ';
			}

			$QURYemplist	= "SELECT Emp.employee_id, Emp.emp_name FROM `prod_iss_rec` AS prodISSrec, employee AS Emp WHERE prodISSrec.dept_id='".$dept_id."' AND prodISSrec.employee_id=Emp.employee_id GROUP BY prodISSrec.employee_id ORDER BY Emp.emp_name";
			$CONNemplist	= $connection->executeQuery($QURYemplist);
			$FTCHemplist	= $CONNemplist->fetchAll();			
			
			$QURYtranslist	= "SELECT d.dept_name, e.emp_name, SUM(rWGT.`loss_wgt`) AS lossWGT FROM `recovered_wgt` AS rWGT, `dept` AS d, `employee` AS e WHERE rWGT.dept_id=d.dept_id AND rWGT.employee_id=e.employee_id ".$searchWHEREcond;
			$CONNtranslist	= $connection->executeQuery($QURYtranslist);
			$FTCHtranslist	= $CONNtranslist->fetchAll();
		}

		return $this->render('reports/dept-loss-report.html.twig', [
			'postDEPTid' => $dept_id,
			'postEMPLid' => $employee_id,
			'postDATEfrm' => $DATEfrm,
			'postDATEto' => $DATEto,
			'deptlist' => $FTCHdeptlist,
			'emplist' => $FTCHemplist,
			'translist' => $FTCHtranslist,
			'controller_name' => 'ReportsController'
        ]);
    }
}
