<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class ProductionStockController extends AbstractController
{
    /**
     * @Route("/prod-stock{prodStockID}", name="prod-stock")
     */
    public function prodSTOCKact(Request $request, $prodStockID) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$fitting_id = $request->get('fitting_id');
		
		date_default_timezone_set("Asia/Kolkata");
		$current_dt = date("Y-m-d");
		
		########-[ QUICK VARIABLES
		$tableName1	= "prod_stock";
		$tablePrmID1= "prod_stock_id";
		$getVARIid1	= $prodStockID;

		$tableName2	= "fitting";
		$tablePrmID2= "fitting_id";
		
		########-[ LIST - MASTER 1
		$QURYmst1Det= "SELECT * FROM ".$tableName2." ORDER BY ".$tablePrmID2." DESC";
		$CONNmst1Det= $connection->executeQuery($QURYmst1Det);
		$FTCHmst1Det= $CONNmst1Det->fetchAll();		

		########-[ LIST - DETAILS
		$QURYlistDet= "SELECT *, DATE_FORMAT( TBL1.`post_dt`, '%b %D, %Y - %l:%S %p' ) AS postDt FROM ".$tableName1." AS TBL1, ".$tableName2." AS TBL2 WHERE TBL1.".$tablePrmID2." = TBL2.".$tablePrmID2." GROUP BY fitting_name ORDER BY TBL2.fitting_name ASC";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();
		
		$data = "";
		for($i=0; $i<=count($FTCHlistDet)-1; $i++)
		{
			#--------[ FETCH IN-STOCK WGT SPARE-WISE
			$QURYinstockWT = "SELECT SUM(`wgt`) AS instockWT FROM `prod_stock` WHERE `fitting_id`='".$FTCHlistDet[$i]['fitting_id']."'";
			$CONNinstockWT = $connection->executeQuery($QURYinstockWT);
			$FTCHinstockWT = $CONNinstockWT->fetchAll();
			
			#--------[ FETCH ISS WGT - SPARE-WISE
			$QURYissueWGT  = "SELECT SUM(`wgt`) AS issWGT FROM `prod_iss_rec` WHERE `fitting_id`='".$FTCHlistDet[$i]['fitting_id']."' AND type='iss' AND `dept_flag`!='s'";
			$CONNissueWGT  = $connection->executeQuery($QURYissueWGT);
			$FTCHissueWGT  = $CONNissueWGT->fetchAll();	
			
			#--------[ FETCH REC WGT - SPARE-WISE
			$QURYreceiveWT = "SELECT SUM(`wgt`) AS recWGT FROM `prod_iss_rec` WHERE `fitting_id`='".$FTCHlistDet[$i]['fitting_id']."' AND type='rec'";
			$CONNreceiveWT = $connection->executeQuery($QURYreceiveWT);
			$FTCHreceiveWT = $CONNreceiveWT->fetchAll();						
			
			$data .= '<tr>
						<td title="Serial No." style="text-align:center;">'.($i+1).'</td>
						<td title="Spares" style="text-align:left;">'.$FTCHlistDet[$i]["fitting_name"].'</td>
						<td title="No. of Pieces" style="text-align:right;">'.$FTCHlistDet[$i]["pcs"].'</td>
						<td title="Length" style="text-align:right;">'.( $FTCHinstockWT[0]["instockWT"] - ($FTCHissueWGT[0]["issWGT"] - $FTCHreceiveWT[0]["recWGT"]) ).'</td>
						<td title="Length" style="text-align:right;">'.$FTCHlistDet[$i]["length"].'</td>';
						/*<td title="Stock Entry Date & Time" style="text-align:left;">'.$FTCHlistDet[$i]["postDt"].'</td>*/
			  /*
			  $data .= '<td title="Action" style="text-align:center;">
							<a href="/prod-stock'.$FTCHlistDet[$i]["prod_stock_id"].'" class="btn btn-icon btn-primary" title="Update"><i class="far fa-edit"></i></a>
						</td>
			  */		
			$data .= '</tr>';
		}


		########-[ SUM OF TOTAL PRODUCTION SPARES STOCK WEIGHT
		$QURYsumSPAREStotWGT = "SELECT sum(`wgt`) AS totSPARESwgt FROM ".$tableName1." ORDER BY ".$tablePrmID1." DESC";
		$CONNsumSPAREStotWGT = $connection->executeQuery($QURYsumSPAREStotWGT);
		$FTCHsumSPAREStotWGT = $CONNsumSPAREStotWGT->fetchAll();
		$totSPARESwgt		 = $FTCHsumSPAREStotWGT[0]['totSPARESwgt'];	

		#--------[ FETCH TOT ISS WGT
		$QURYissueTOTwgt  = "SELECT SUM(`wgt`) AS issWGT FROM `prod_iss_rec` WHERE type='iss' AND `dept_flag`!='s'";
		$CONNissueTOTwgt  = $connection->executeQuery($QURYissueTOTwgt);
		$FTCHissueTOTwgt  = $CONNissueTOTwgt->fetchAll();	

		#--------[ FETCH TOT REC WGT
		$QURYreceiveTOTwg = "SELECT SUM(`wgt`) AS recWGT FROM `prod_iss_rec` WHERE type='rec'";
		$CONNreceiveTOTwg = $connection->executeQuery($QURYreceiveTOTwg);
		$FTCHreceiveTOTwg = $CONNreceiveTOTwg->fetchAll();

		$currentTOTspareWGT = $totSPARESwgt - ($FTCHissueTOTwgt[0]["issWGT"] - $FTCHreceiveTOTwg[0]["recWGT"]);

		if($getVARIid1 != 0)
		{
			########-[ GET UPDATE - DETAILS
			$QURYupdtDet	= "SELECT * FROM ".$tableName1." WHERE ".$tablePrmID1."=".$getVARIid1;
			$CONNupdtDet	= $connection->executeQuery($QURYupdtDet);
			$FTCHupdtDet	= $CONNupdtDet->fetchAll();
			
			$FTCHupdtDet['fitting_id'] 	= $FTCHupdtDet[0]['fitting_id'];
			$FTCHupdtDet['pcs'] 		= $FTCHupdtDet[0]['pcs'];
			$FTCHupdtDet['wgt'] 		= $FTCHupdtDet[0]['wgt'];
			$FTCHupdtDet['length'] 		= $FTCHupdtDet[0]['length'];
		}
		else
		{
			$FTCHupdtDet = "";
		}
		
		if($request->getMethod() == 'POST')
		{
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime = date("Y-m-d H:i:s");
			
			$current_dt = date("Y-m-d");
			$fitting_id = $request->get('fitting_id');
			$pcs 		= $request->get('pcs');
			$wgt 		= $request->get('wgt');
			$length		= $request->get('length');
			$sessionId  = $session->get('empId');
			
			if($getVARIid1 == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO ".$tableName1."(`fitting_id`, `pcs`, `wgt`, `length`, `post_by`, `post_dt`) VALUES ('$fitting_id','$pcs','$wgt','$length','$sessionId', '$nwDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
			}
			else
			{
				########-[ UPDATE - DETAILS			
				$QRupdate 	= "UPDATE ".$tableName1." SET `fitting_id`='$fitting_id', `pcs`='$pcs', `wgt`='$wgt', `length`='$length', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE ".$tablePrmID1."=".$getVARIid1;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}
		
		
		return $this->render('prod-stock/prod-stock-data.html.twig', [
			'FTCHlistDet' => $FTCHlistDet,
			'FTCHupdtDet' => $FTCHupdtDet,
			'FTCHmst1Det' => $FTCHmst1Det,
			'fitting_id' => $fitting_id,
			'data' => $data,
			'currentTOTspareWGT' => number_format($currentTOTspareWGT, 2),
			'controller_name' => 'ProductionStockController'
        ]);
    }
}
