<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class ProductionDailyClosingController extends AbstractController
{
    /**
     * @Route("/prod-daily-closing-list", name="prod-daily-closing-list") 
     */
    public function prodDailyClosingListACT(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		########-[ GET LIST
		$QURYlist	= "SELECT PO.po_status, PODC.po_daily_closing_id, PO.po_id, DATE_FORMAT(PODC.`closing_date`, '%b %d, %Y') as closingDATE, CONCAT(PO.po_financial_yr,'',PO.po_no) AS poNo, SUM(PODC.qty) AS qty, SUM(PODC.wgt) AS wgt FROM `po_daily_closing` AS PODC, po AS PO WHERE PODC.po_id=PO.po_id GROUP BY PODC.`po_id`, PODC.`closing_date` ORDER BY PODC.`closing_date` DESC";
		$CONNlist	= $connection->executeQuery($QURYlist);
		$FTCHlist	= $CONNlist->fetchAll();
		
		return $this->render('prod-daily-closing/prod-daily-closing-list.html.twig', [
			'list' => $FTCHlist,
			'controller_name' => 'ProductionDailyClosingController'
        ]);
    }
	
	
    /**
     * @Route("/prod-daily-closing-updt{dcID}", name="prod-daily-closing-updt")
     */
    public function prodDailyClosingUpdtACT(Request $request, $dcID) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		if($dcID != 0)
		{
			########-[ GET CLOSING DATE & PO NO on EDIT ACTION
			$QURYcldtPOID	= "SELECT DATE_FORMAT(`closing_date`, '%b %d, %Y') AS closingDATE, `po_id`, closing_date FROM `po_daily_closing` WHERE `po_daily_closing_id`=".$dcID;
			$CONNcldtPOID	= $connection->executeQuery($QURYcldtPOID);
			$FTCHcldtPOID	= $CONNcldtPOID->fetchAll();	
			
			$FTCHcldtPOID['closingDATE'] = $FTCHcldtPOID[0]['closingDATE'];
			$FTCHcldtPOID['po_id'] 		 = $FTCHcldtPOID[0]['po_id'];
			
			
			########-[ GET PO STATUS
			$QURYpoSTATUS	= "SELECT `po_status`, CONCAT(`po_financial_yr`,'',`po_no`) AS poNo FROM `po` WHERE `po_id`=".$_GET['poID'];
			$CONNpoSTATUS	= $connection->executeQuery($QURYpoSTATUS);
			$FTCHpoSTATUS	= $CONNpoSTATUS->fetchAll();	
			
			$po_status 		= $FTCHpoSTATUS[0]['po_status'];
			$poNo 			= $FTCHpoSTATUS[0]['poNo'];
		}

		
		########-[ GET PO LIST
		//$QURYpoLIST	= "SELECT PO.po_id, CONCAT(PO.po_financial_yr,'',PO.po_no) AS poNo FROM `prod_iss_rec` AS PIR, po AS PO WHERE PIR.po_id=PO.po_id AND PO.po_status=0 GROUP BY PIR.po_id ORDER BY poNo DESC";				#-------- CONDITION TO CHECK DO, PO COMES IN PRODUCTION
		
		//$QURYpoLIST	= "SELECT PO.po_id, CONCAT(PO.po_financial_yr, '', PO.po_no) AS poNo FROM `gold_stock_iss_rec` AS GSIR, po AS PO WHERE GSIR.parti_id = 1 AND GSIR.other_ids=PO.po_id AND PO.po_status=0 GROUP BY PO.po_id ORDER BY poNo DESC";		#-------- CONDITION TO CHECK DO, GOLD STOCK ALOTED TO PO
		
		$QURYpoLIST	= "SELECT PO.po_id, CONCAT(PO.po_financial_yr, '', PO.po_no) AS poNo FROM `gold_stock_iss_rec` AS GSIR, po AS PO WHERE GSIR.parti_id = 1 AND PO.po_status = 0 GROUP BY PO.po_id ORDER BY poNo DESC";		#-------- CONDITION TO CHECK DO, GOLD STOCK ALOTED TO PO
		$CONNpoLIST	= $connection->executeQuery($QURYpoLIST);
		$FTCHpoLIST	= $CONNpoLIST->fetchAll();
		
		if($dcID == 0)
		{
			if($request->getMethod() == 'POST')
			{
				$po_id			= $request->get('po_id');
				
				########-[ GET PO DESIGNS
				//$QURYpoDSGNs	= "SELECT design_cat.design_cat_name, design_subcat.design_subcat_name, designs.design_no, POD.qty, POD.closing_qty, POD.closing_wgt, designs.design_id, POD.po_det_id, designs.gross_wgt, po_daily_closing.qty, po_daily_closing.wgt FROM `po_det` AS POD LEFT JOIN designs ON POD.design_id=designs.design_id LEFT JOIN design_cat ON POD.design_cat_id=design_cat.design_cat_id LEFT JOIN design_subcat ON POD.design_subcat_id=design_subcat.design_subcat_id LEFT JOIN po_daily_closing ON POD.po_det_id=po_daily_closing.po_det_id WHERE POD.role_status = 1 AND POD.po_id = '2' ORDER BY designs.design_no ASC";
				$QURYpoDSGNs	= "SELECT DC.design_cat_name, DSC.design_subcat_name, D.design_no, POD.qty AS poQTY, POD.closing_qty, POD.closing_wgt, D.design_id, POD.po_det_id, D.gross_wgt FROM `po_det` AS POD, designs AS D, design_cat AS DC, design_subcat AS DSC WHERE POD.design_id=D.design_id AND POD.design_cat_id=DC.design_cat_id AND POD.design_subcat_id=DSC.design_subcat_id AND POD.role_status=1 AND POD.po_id='$po_id' ORDER BY D.design_no ASC";			
				$CONNpoDSGNs	= $connection->executeQuery($QURYpoDSGNs);
				$FTCHpoDSGNs	= $CONNpoDSGNs->fetchAll();			
				$CONTpoDSGNs	= count($FTCHpoDSGNs);
				
				########-[ GET PO STATUS
				$QURYpoSTATUS	= "SELECT `po_status`, CONCAT(`po_financial_yr`,'',`po_no`) AS poNo FROM `po` WHERE `po_id`=".$po_id;
				$CONNpoSTATUS	= $connection->executeQuery($QURYpoSTATUS);
				$FTCHpoSTATUS	= $CONNpoSTATUS->fetchAll();	
				
				$po_status 		= $FTCHpoSTATUS[0]['po_status'];		
				$poNo 			= $FTCHpoSTATUS[0]['poNo'];		
			}
		}	
		elseif($dcID != 0)
		{
			//echo
			$QURYpoDSGNs	= "SELECT DC.design_cat_name, DSC.design_subcat_name, D.design_no, POD.qty AS poQTY, POD.closing_qty AS calCLOSINGqty, POD.closing_wgt, D.gross_wgt, PODC.qty AS closing_qty, PODC.wgt AS closing_wgt, POD.po_det_id, PODC.`po_daily_closing_id` FROM `po_daily_closing` AS PODC LEFT JOIN `po_det` AS POD ON PODC.po_det_id = POD.po_det_id LEFT JOIN designs AS D ON POD.design_id = D.design_id LEFT JOIN design_cat AS DC ON POD.design_cat_id = DC.design_cat_id LEFT JOIN design_subcat AS DSC ON POD.design_subcat_id = DSC.design_subcat_id WHERE PODC.`po_id` = '".$_GET['poID']."' AND PODC.`closing_date` = '".$FTCHcldtPOID[0]['closing_date']."' ORDER BY D.design_no ASC";
			//$QURYpoDSGNs	= "SELECT DC.design_cat_name, DSC.design_subcat_name, D.design_no, POD.qty AS poQTY, POD.closing_qty AS calCLOSINGqty, POD.closing_wgt, D.gross_wgt, PODC.qty AS closing_qty, PODC.wgt AS closing_wgt, POD.po_det_id, PODC.`po_daily_closing_id` FROM `po_daily_closing` AS PODC LEFT JOIN `po_det` AS POD ON PODC.po_det_id = POD.po_det_id LEFT JOIN designs AS D ON POD.design_id = D.design_id LEFT JOIN design_cat AS DC ON POD.design_cat_id = DC.design_cat_id LEFT JOIN design_subcat AS DSC ON POD.design_subcat_id = DSC.design_subcat_id WHERE POD.`po_id` = '".$_GET['poID']."' ORDER BY D.design_no ASC";			
			$CONNpoDSGNs	= $connection->executeQuery($QURYpoDSGNs);
			$FTCHpoDSGNs	= $CONNpoDSGNs->fetchAll();			
		}
		
		return $this->render('prod-daily-closing/prod-daily-closing-updt.html.twig', [
			'poLIST' => $FTCHpoLIST,
			'poDSGNs' => $FTCHpoDSGNs,
			'CONTpoDSGNs' => $CONTpoDSGNs,
			'po_id' => $po_id,
			'FTCHcldtPOID' => $FTCHcldtPOID,
			'po_status' => $po_status,
			'poNo' => $poNo,
			'controller_name' => 'ProductionDailyClosingController'
        ]);
    }	
	
	
   /** 
	* @Route("/closingPOqty", name="closingPOqty") 
	*/ 
	public function closingPOqtyACT(Request $request) 
	{ 
		$session 	= $request->getSession();
		
	    $connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$poID	  	= $request->get('poID');
		$cQty	  	= $request->get('cQty');
		$cWgt	  	= $request->get('cWgt');
		$po_det_id 	= $request->get('i');
		$cDAT 		= $request->get('cDAT');
		$cDAT_EXP	= explode("-",$cDAT);
		$cDate	 	= $cDAT_EXP[2]."-".$cDAT_EXP[1]."-".$cDAT_EXP[0];
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta");
		$nowDateTime = date("Y-m-d H:i:s");		
		
		#--------[ INSERT - DAILY CLOSING QTY with DATE
		$QURYdailyCLOSING	= "INSERT INTO `po_daily_closing`(`po_id`, `po_det_id`, `qty`, `wgt`, `closing_date`, `post_by`, `post_dt`) VALUES ('$poID', '$po_det_id', '$cQty', '$cWgt', '$cDate', '$sessionId', '$nowDateTime')";
		$CONNdailyCLOSING	= $connection->executeQuery($QURYdailyCLOSING);	
		
		
		#--------[ COUNT - DAILY CLOSING QTY
		//$QURYcontCLqt		= "SELECT SUM(`qty`) AS closedTOTqty FROM `po_daily_closing` WHERE `po_id` = '$poID' AND `po_det_id` = '$po_det_id'";
		$QURYcontCLqt		= "SELECT SUM(DC.`qty`) AS closedTOTqty, SUM(DC.`wgt`) AS closedTOTwgt, POD.qty, POD.closing_qty FROM `po_daily_closing` AS DC, po_det AS POD WHERE DC.`po_id` = '$poID' AND DC.`po_det_id` = '$po_det_id' AND DC.po_det_id=POD.po_det_id";
		$CONNcontCLqt		= $connection->executeQuery($QURYcontCLqt);
		$FTCHcontCLqt		= $CONNcontCLqt->fetchAll();
		$closedTOTqty		= $FTCHcontCLqt[0]['closedTOTqty'];
		$closedTOTwgt		= $FTCHcontCLqt[0]['closedTOTwgt'];
		$qty				= $FTCHcontCLqt[0]['qty'];
		$closing_qty		= $FTCHcontCLqt[0]['closing_qty'];
		
		
		if($closedTOTqty <= $qty)
		{
			#--------[ UPDATE - DAILY CLOSING QTY with PO_DET TABLE
			$QURYupdtdailyCL	= "UPDATE `po_det` SET `closing_qty`='$closedTOTqty', `closing_wgt`='$closedTOTwgt', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE `po_det_id`='$po_det_id'";
			$CONNupdtdailyCL	= $connection->executeQuery($QURYupdtdailyCL);			
		}
		
		$rslt = $closedTOTqty."#*#".$qty."#*#".$closedTOTwgt;
		return  new JsonResponse($rslt);		
	}	
	
	
   /** 
	* @Route("/updtClosingPOqty", name="updtClosingPOqty") 
	*/ 
	public function updtClosingPOqtyACT(Request $request) 
	{ 
		$session 	= $request->getSession();
		
	    $connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$po_daily_closing_id 	= $request->get('i');
		$po_det_id 				= $request->get('ii');
		$poID	 				= $request->get('poID');
		$cQty	  				= $request->get('cQty');
		$cWgt	  				= $request->get('cWgt');
		
		$sessionId  			= $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta");
		$nowDateTime 			= date("Y-m-d H:i:s");		
		

		#--------[ UPDATE - DAILY CLOSING QTY with PO_DET TABLE
		$QURYupdtdailyCLOSING	= "UPDATE `po_daily_closing` SET `qty`='$cQty', `wgt`='$cWgt', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE `po_daily_closing_id`='$po_daily_closing_id'";
		$CONNupdtdailyCLOSING	= $connection->executeQuery($QURYupdtdailyCLOSING);		
		

		#--------[ COUNT - DAILY CLOSING QTY
		//$QURYcontCLqt		= "SELECT SUM(`qty`) AS closedTOTqty FROM `po_daily_closing` WHERE `po_id` = '$poID' AND `po_det_id` = '$po_det_id'";
		$QURYcontCLqt		= "SELECT SUM(DC.`qty`) AS closedTOTqty, SUM(DC.`wgt`) AS closedTOTwgt, POD.qty, POD.closing_qty FROM `po_daily_closing` AS DC, po_det AS POD WHERE DC.`po_id` = '$poID' AND DC.`po_det_id` = '$po_det_id' AND DC.po_det_id=POD.po_det_id";
		$CONNcontCLqt		= $connection->executeQuery($QURYcontCLqt);
		$FTCHcontCLqt		= $CONNcontCLqt->fetchAll();
		$closedTOTqty		= $FTCHcontCLqt[0]['closedTOTqty'];
		$closedTOTwgt		= $FTCHcontCLqt[0]['closedTOTwgt'];
		$qty				= $FTCHcontCLqt[0]['qty'];
		$closing_qty		= $FTCHcontCLqt[0]['closing_qty'];
		
		if($closedTOTqty <= $qty)
		{
			#--------[ UPDATE - DAILY CLOSING QTY with PO_DET TABLE
			$QURYupdtdailyCL	= "UPDATE `po_det` SET `closing_qty`='$closedTOTqty', `closing_wgt`='$closedTOTwgt', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE `po_det_id`='$po_det_id'";
			$CONNupdtdailyCL	= $connection->executeQuery($QURYupdtdailyCL);			
		}			
		
//		$rslt = $closedTOTqty."#*#".$qty."#*#".$closedTOTwgt;
		$rslt = "success";
		return  new JsonResponse($rslt);		
	}	
	
	
    /**
     * @Route("/prodDAILYclosingDLT{dcDLTid}", name="prodDAILYclosingDLT") 
     */
    public function prodDAILYclosingDLTact(Request $request, $dcDLTid) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		########-[ DELETE
		$QURY	= "DELETE FROM `po_daily_closing` WHERE `po_daily_closing_id`=".$dcDLTid;
		$CONN	= $connection->executeQuery($QURY);
		
		#--------[ COUNT - DAILY CLOSING QTY
		//$QURYcontCLqt		= "SELECT SUM(`qty`) AS closedTOTqty FROM `po_daily_closing` WHERE `po_id` = '$poID' AND `po_det_id` = '$po_det_id'";
		$QURYcontCLqt		= "SELECT SUM(DC.`qty`) AS closedTOTqty, SUM(DC.`wgt`) AS closedTOTwgt, POD.qty, POD.closing_qty FROM `po_daily_closing` AS DC, po_det AS POD WHERE DC.`po_id` = '".$_GET['poID']."' AND DC.`po_det_id` = '".$_GET['po_det_id']."' AND DC.po_det_id=POD.po_det_id";
		$CONNcontCLqt		= $connection->executeQuery($QURYcontCLqt);
		$FTCHcontCLqt		= $CONNcontCLqt->fetchAll();
		$closedTOTqty		= $FTCHcontCLqt[0]['closedTOTqty'];
		$closedTOTwgt		= $FTCHcontCLqt[0]['closedTOTwgt'];
		$qty				= $FTCHcontCLqt[0]['qty'];
		$closing_qty		= $FTCHcontCLqt[0]['closing_qty'];
		
		if($closedTOTqty <= $qty)
		{
			#--------[ UPDATE - DAILY CLOSING QTY with PO_DET TABLE
			$QURYupdtdailyCL	= "UPDATE `po_det` SET `closing_qty`='$closedTOTqty', `closing_wgt`='$closedTOTwgt', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE `po_det_id`='".$_GET['po_det_id']."'";
			$CONNupdtdailyCL	= $connection->executeQuery($QURYupdtdailyCL);			
		}			
		
		return $this->redirectToRoute('prod-daily-closing-updt', array('dcID' => $dcDLTid, 'poID' => $_GET['poID']));
    }	
	
	
    /**
     * @Route("/poSUBMITvali", name="poSUBMITvali") 
     */
    public function poSUBMITvaliACT(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$po_id 		= $request->get('po_id');
		
		$sessionId 	= $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta");
		$nowDateTime = date("Y-m-d H:i:s");			
		
		$QURYpoSUBMITval = "SELECT `qty`, `closing_qty` FROM `po_det` WHERE `po_id`='".$po_id."' ORDER BY design_id ASC";
		$CONNpoSUBMITval = $connection->executeQuery($QURYpoSUBMITval);
		$FTCHpoSUBMITval = $CONNpoSUBMITval->fetchAll();
		$CONTpoSUBMITval = count($FTCHpoSUBMITval);
		
		for($i = 0; $i <= $CONTpoSUBMITval; $i++)
		{
			if($FTCHpoSUBMITval[$i]['qty'] != $FTCHpoSUBMITval[$i]['closing_qty'])
			{
				$msg = "Looks like some Design's not yet Completed !!";
			}
		}
		
		if($msg != "Looks like some Design's not yet Completed !!")
		{
			$QURYupdtCLOSEpo	= "UPDATE `po` SET `po_status`='1',`update_by`='$sessionId',`update_dt`='$nowDateTime' WHERE `po_id`=".$po_id;
			$CONNupdtCLOSEpo	= $connection->executeQuery($QURYupdtCLOSEpo);				
		}
		
		$rslt = $msg;
		//$rslt = $CONTpoSUBMITval;
		return  new JsonResponse($rslt);		
    }
}