<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class PoCustomerOrderController extends AbstractController
{

	/**
     * @Route("/po-customer-order-list", name="po-customer-order-list")    
     */
    public function poOpenOrderListAct(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		#--------[ FETCH - JC
		$QURYopenORD = "SELECT OPD.`po_open_ord_det_id`, OP.po_open_ord_id, CONCAT(OP.po_open_ord_code,'',OP.po_open_ord_no) AS opNO, OPD.jc_no, FORMAT(OP.avg_tot_wgt, 2) AS ordTOTwgt, DATE_FORMAT(OP.post_dt, '%b %D, %y %I:%i %p') AS entry_date, P.concern_name, P.party_name, OPD.cat_shortname, OPD.typ_e, FORMAT(OPD.wgt_range_from, 2) AS wgt_range_from, FORMAT(OPD.wgt_range_to, 3) AS wgt_range_to, FORMAT(OPD.avg_wgt_per_pcs , 3) AS avg_wgt_per_pcs, OPD.ord_qty, FORMAT(OPD.avg_wgt_range , 3) AS avg_wgt_range, OPD.ord_spec FROM `po_open_ord_det` AS OPD, `po_open_ord` AS OP, `party` AS P WHERE OPD.po_open_ord_id=OP.po_open_ord_id AND OP.party_id=P.party_id AND OPD.jc_no_split_status='Yes' AND OPD.design_id=0 AND OPD.wgt_range_to!=0 AND ord_type='cust' ORDER BY OP.po_open_ord_id DESC";
		$CONNopenORD = $connection->executeQuery($QURYopenORD);
		$FTCHopenORD = $CONNopenORD->fetchAll();
		$CONTopenORD = count($FTCHopenORD) - 1;
		
		
		$openORDdata = "";
		for($i=0; $i<=$CONTopenORD; $i++)
		{
/*			$jc_no = explode("-", $FTCHopenORD[$i]['jc_no']);
			$jc_no = $jc_no[1];*/
			
/*			#--------[ FETCH - JC COUNT
			$QURYjcCONT = "SELECT COUNT(`po_open_ord_id`) AS countJCs FROM `po_open_ord_det` WHERE `po_open_ord_id`='".$FTCHopenORD[$i]['po_open_ord_id']."'";
			$CONNjcCONT = $connection->executeQuery($QURYjcCONT);
			$FTCHjcCONT = $CONNjcCONT->fetchAll();	
			$countJCs   = $FTCHjcCONT[0]['countJCs'];*/
			
			#--------[ CHECK - JC in WAX ENTRY
			$QURYwxENT = "SELECT `wax_entry_id` FROM `wax_entry` WHERE `po_open_ord_id`='".$FTCHopenORD[$i]['po_open_ord_id']."'";
			$CONNwxENT = $connection->executeQuery($QURYwxENT);
			$FTCHwxENT = $CONNwxENT->fetchAll();
			$CHCKwxENT = $FTCHwxENT[0]['wax_entry_id'];	
			
			$QURYmxPOID = "SELECT MAX(`po_open_ord_det_id`) AS po_open_ord_det_id FROM `po_open_ord_det` WHERE `po_open_ord_id`='".$FTCHopenORD[$i]['po_open_ord_id']."'";
			$CONNmxPOID = $connection->executeQuery($QURYmxPOID);
			$FTCHmxPOID = $CONNmxPOID->fetchAll();
			$CHCKmxPOID = $FTCHmxPOID[0]['po_open_ord_det_id'];	

			
			$openORDdata .='<tr>
						  <td title="Serial No." style="text-align:center; vertical-align: middle;">'.($i+1).'</td>
						  <td title="Showing - PO No./Job Card No." style="text-align:left; vertical-align: middle;"><b><u>'.$FTCHopenORD[$i]['opNO'].'</u><br>'.$FTCHopenORD[$i]['ordTOTwgt'].' <small>(g)</small></b><br>'.$FTCHopenORD[$i]['jc_no'].'</td>
						  <td title="Showing - PO Date/Specification" style="text-align:left; vertical-align: middle;"><u>'.$FTCHopenORD[$i]['entry_date'].'</u><br>'.$FTCHopenORD[$i]['ord_spec'].'</td>
						  <td title="Showing - Concern Name/Party Name" style="text-align:left; vertical-align: middle;"><u>'.$FTCHopenORD[$i]['concern_name'].'</u><br>'.$FTCHopenORD[$i]['party_name'].'</td>';
			
			if($FTCHopenORD[$i]['typ_e'] == 1){ $itemTYPE = "Stone"; } else if($FTCHopenORD[$i]['typ_e'] == 0) { $itemTYPE = "Plain"; }
			
		  $openORDdata .='<td title="Showing - Category Short Name / Type" style="text-align:center; vertical-align: middle;"><u>'.$FTCHopenORD[$i]['cat_shortname'].'</u> <br>'.$itemTYPE.'</td>
						  <td title="Showing - Weight Range From in grams" style="text-align:right; vertical-align: middle;">'.$FTCHopenORD[$i]['wgt_range_from'].'</td>
						  <td title="Showing - Weight Range To in grams" style="text-align:right; vertical-align: middle;">'.$FTCHopenORD[$i]['wgt_range_to'].'</td>
              			  <td title="Showing - Average Weight/Piece in grams" style="text-align:center; vertical-align: middle;">'.$FTCHopenORD[$i]['avg_wgt_per_pcs'].'</td>
			              <td title="Showing - Cat Order Quantity" style="text-align:center; vertical-align: middle;">'.$FTCHopenORD[$i]['ord_qty'].'</td>
			              <td title="Showing - Total Average Weight in grams" style="text-align:center; vertical-align: middle;">'.$FTCHopenORD[$i]['avg_wgt_range'].'</td>
						  <td title="Action" style="text-align:center; vertical-align: middle;">';

/*  	  if($CHCKwxENT == "")
		  {
			  if($jc_no >= $countJCs)
			  {	
			  $openORDdata .='<a href="po-customer-order-upd'.$FTCHopenORD[$i]['po_open_ord_id'].'"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>
								&nbsp;&nbsp;&nbsp;
							  <a href="po-customer-order-dlt'.$FTCHopenORD[$i]['po_open_ord_id'].'"><i class="fa fa-trash" aria-hidden="true" style="color:red;"></i></a>';
			   }
		   }
		   else if($CHCKwxENT != "")
		   {
			  if($jc_no >= $countJCs)
			  {		   
			  $openORDdata .='<i class="fa fa-pencil-square-o" aria-hidden="true" style="color:#E8E8E8"></i>
								&nbsp;&nbsp;&nbsp;
							  <i class="fa fa-trash" aria-hidden="true" style="color:#E8E8E8;"></i>';
			  }
		   }*/
		   
  		  if($CHCKwxENT == "")
		  {
			  if($CHCKmxPOID == $FTCHopenORD[$i]['po_open_ord_det_id'])
			  {	
			  $openORDdata .='<a href="po-customer-order-upd'.$FTCHopenORD[$i]['po_open_ord_id'].'"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>
								&nbsp;&nbsp;&nbsp;
							  <a href="po-customer-order-dlt'.$FTCHopenORD[$i]['po_open_ord_id'].'"><i class="fa fa-trash" aria-hidden="true" style="color:red;"></i></a>';
			   }
		   }
		   else if($CHCKwxENT != "")
		   {
			  if($CHCKmxPOID == $FTCHopenORD[$i]['po_open_ord_det_id'])
			  {		   
			  $openORDdata .='<i class="fa fa-pencil-square-o" aria-hidden="true" style="color:#E8E8E8"></i>
								&nbsp;&nbsp;&nbsp;
							  <i class="fa fa-trash" aria-hidden="true" style="color:#E8E8E8;"></i>';
			  }
		   }		   
		
		$openORDdata .='</td>
					</tr>';
		
		}
		
		return $this->render('po-customer-order/po-customer-order-list.html.twig', [
			'openORDlist' => $FTCHopenORD,
			'openORDdata' => $openORDdata,
			'controller_name' => 'PoCustomerOrderController'
        ]);
    }
	
	
	/**
     * @Route("/po-customer-order-add", name="po-customer-order-add")   
     */
    public function poOpenOrderAddAct(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection();
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");	 

		
		#--------[ FETCH - OPEN ORDER NO - AUTO GENERATE
		$QURYopenORDpoAUTOGEN = "SELECT IFNULL(MAX(LPAD(`po_open_ord_no` + 1, 3, '0')), '001') AS openORDno FROM `po_open_ord` WHERE `role_status`=1 AND `post_dt` LIKE '%-".date('m')."-%'";
		$CONNopenORDpoAUTOGEN = $connection->executeQuery($QURYopenORDpoAUTOGEN);
		$FTCHopenORDpoAUTOGEN = $CONNopenORDpoAUTOGEN->fetchAll();
		$RSLTopenORDpoAUTOGEN = "CU".date('m').$FTCHopenORDpoAUTOGEN[0]['openORDno'];
		$RSLTopenORDjcAUTOGEN = date('m').$FTCHopenORDpoAUTOGEN[0]['openORDno'];
		
		
		#--------[ FETCH - PARTY DATA's
		$QURYpartDATAs = "SELECT `party_id`, CONCAT(`concern_name`,' - ',`party_name`,' - [',`pid`,']') AS partyName FROM `party` WHERE `role_status`=1 ORDER BY `concern_name` ASC";
		$CONNpartDATAs = $connection->executeQuery($QURYpartDATAs);
		$FTCHpartDATAs = $CONNpartDATAs->fetchAll();
		
		
		if($request->getMethod() == 'POST')
		{
			$open_order_po_code	= "CU".date('m');
			$open_order_po_no 	= $FTCHopenORDpoAUTOGEN[0]['openORDno'];
			$entry_date			= explode("-", $request->get('entry_date'));
			$entry_date			= $entry_date[2]."-".$entry_date[1]."-".$entry_date[0];
			$party_id 			= $request->get('party_id');
			$tot_open_ord_qty 	= $request->get('tot_open_ord_qty');
			$tot_open_ordAvg_wt = $request->get('tot_open_ord_avg_wt');
			$tot_vari_cat_shtnm = count($request->get('job_card_no'));
			
			
			#--------[INSERT OPEN ORDER - BASIC DATA
			$instOPENordBASICdata = "INSERT INTO `po_open_ord`(`po_open_ord_code`, `po_open_ord_no`, `entry_date`, `party_id`, `avg_tot_wgt`, `tot_qty`, `tot_variety_cat_shortname`, `post_by`, `post_dt`) VALUES ('$open_order_po_code', '$open_order_po_no', '$entry_date', '$party_id', '$tot_open_ordAvg_wt', '$tot_open_ord_qty', '$tot_vari_cat_shtnm', '$sessionId', '$nowDateTime')";
			$stmtOPENordBASICdata = $connection->executeQuery($instOPENordBASICdata);
			$po_open_ord_id 	  = $connection->lastInsertId();
			
			
			for($i=0; $i<=$tot_vari_cat_shtnm-1; $i++)
			{
				$job_card_no 	= $request->get('job_card_no')[$i];
				$cat_short_name = $request->get('cat_short_name')[$i];
				$type 			= $request->get('type')[$i];
				$wgt_range_frm 	= $request->get('wgt_range_frm')[$i];
				$wgt_range_to 	= $request->get('wgt_range_to')[$i];
				$avg_wgt_per_pcs= $request->get('avgWGTrangePERitemHIDDEN')[$i];
				$qty 			= $request->get('qty')[$i];
				$avg_wgt_range	= $request->get('avg_wgt_range')[$i];
				$specification 	= addslashes($request->get('specification')[$i]);
				
				if($qty != 0)
				{
				#--------[ INSERT OPEN ORDER - DETAILS
				$instOPENordDETAILS = "INSERT INTO `po_open_ord_det`(`po_open_ord_id`, `ord_type`, `jc_no`, `cat_shortname`, `typ_e`, `wgt_range_from`, `wgt_range_to`, `avg_wgt_per_pcs`, `ord_qty`, `avg_wgt_range`, `ord_spec`, `post_by`, `post_dt`) VALUES ('$po_open_ord_id', 'cust', '$job_card_no', '$cat_short_name', '$type', '$wgt_range_frm', '$wgt_range_to', '$avg_wgt_per_pcs', '$qty', '$avg_wgt_range', '$specification', '$sessionId', '$nowDateTime')";
				$stmtOPENordDETAILS = $connection->executeQuery($instOPENordDETAILS);
				}
			}
			
			return $this->redirect('po-customer-order-list');
		}

		return $this->render('po-customer-order/po-customer-order-add.html.twig', [
			'openORDno' => $RSLTopenORDpoAUTOGEN,
			'openORDjc' => $RSLTopenORDjcAUTOGEN,
			'partDATAs' => $FTCHpartDATAs,
			'controller_name' => 'PoCustomerOrderController'
        ]);
    }	
	

	/**
     * @Route("/po-customer-order-upd{poOPENordID}", name="po-customer-order-upd")   
     */
    public function poOpenOrderUpdAct(Request $request, $poOPENordID) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection();
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");	 

		
		#--------[ FETCH - OPEN ORDER BASIC DATA's
		$QURYopenORDpoBASICdt = "SELECT po_open_ord_id, po_open_ord_code, po_open_ord_no, entry_date, party_id, tot_qty, avg_tot_wgt FROM `po_open_ord` WHERE `po_open_ord_id`='".$poOPENordID."'";
		$CONNopenORDpoBASICdt = $connection->executeQuery($QURYopenORDpoBASICdt);
		$FTCHopenORDpoBASICdt = $CONNopenORDpoBASICdt->fetchAll();
		
		$FTCHopenORDpoBASICdt['po_open_ord_no']	= $FTCHopenORDpoBASICdt[0]['po_open_ord_code'].$FTCHopenORDpoBASICdt[0]['po_open_ord_no'];
		$FTCHopenORDpoBASICdt['entry_date'] 	= explode("-", $FTCHopenORDpoBASICdt[0]['entry_date']);
		$FTCHopenORDpoBASICdt['entry_date'] 	= $FTCHopenORDpoBASICdt['entry_date'][2]."-".$FTCHopenORDpoBASICdt['entry_date'][1]."-".$FTCHopenORDpoBASICdt['entry_date'][0];
		$FTCHopenORDpoBASICdt['party_id'] 		= $FTCHopenORDpoBASICdt[0]['party_id'];
		$FTCHopenORDpoBASICdt['tot_qty']		= $FTCHopenORDpoBASICdt[0]['tot_qty'];
		$FTCHopenORDpoBASICdt['avg_tot_wgt'] 	= number_format($FTCHopenORDpoBASICdt[0]['avg_tot_wgt'], 2);
		$openORDjc								= explode("CU", $FTCHopenORDpoBASICdt['po_open_ord_no']);
		$openORDjc								= $openORDjc[1];
		$FTCHopenORDpoBASICdt['po_open_ord_id']	= $FTCHopenORDpoBASICdt[0]['po_open_ord_id'];
		
		#--------[ FETCH - PARTY DATA's
		$QURYpartDATAs = "SELECT `party_id`, CONCAT(`concern_name`,' - ',`party_name`,' - [',`pid`,']') AS partyName FROM `party` WHERE `role_status`=1 ORDER BY `concern_name` ASC";
		$CONNpartDATAs = $connection->executeQuery($QURYpartDATAs);
		$FTCHpartDATAs = $CONNpartDATAs->fetchAll();
		
		
		#--------[ FETCH - OPEN ORDER PARTICULAR's
		$QURYopenORDpoPARTICU = "SELECT * FROM `po_open_ord_det` WHERE `po_open_ord_id`='".$poOPENordID."' ORDER BY `po_open_ord_det_id` ASC";
		$CONNopenORDpoPARTICU = $connection->executeQuery($QURYopenORDpoPARTICU);
		$FTCHopenORDpoPARTICU = $CONNopenORDpoPARTICU->fetchAll();
		$contopenORDpoPARTICU = count($FTCHopenORDpoPARTICU) - 1;
		$RSLTopenORDpoPARTICU = count($FTCHopenORDpoPARTICU);
		
		if($request->getMethod() == 'POST')
		{
			$open_order_po_code	= "CU".date('m');
			$open_order_po_no 	= $FTCHopenORDpoAUTOGEN[0]['openORDno'];
			$entry_date			= explode("-", $request->get('entry_date'));
			$entry_date			= $entry_date[2]."-".$entry_date[1]."-".$entry_date[0];
			$party_id 			= $request->get('party_id');
			$tot_open_ord_qty 	= $request->get('tot_open_ord_qty');
			$tot_open_ordAvg_wt = $request->get('tot_open_ord_avg_wt');
			$tot_vari_cat_shtnm = count($request->get('job_card_no'))-1;
			
			
			#--------[UPDATE OPEN ORDER - BASIC DATA
			$updtOPENordBASICdata = "UPDATE `po_open_ord` SET `party_id`='$party_id', `avg_tot_wgt`='$tot_open_ordAvg_wt', `tot_qty`='$tot_open_ord_qty', `tot_variety_cat_shortname`='$tot_vari_cat_shtnm', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE `po_open_ord_id`='".$FTCHopenORDpoBASICdt['po_open_ord_id']."'";
			$stmtOPENordBASICdata = $connection->executeQuery($updtOPENordBASICdata);
			
			for($j=0; $j<=$contopenORDpoPARTICU; $j++)
			{
				$job_card_no 	= $request->get('job_card_no')[$j];
				$cat_short_name = $request->get('cat_short_name')[$j];
				$type 			= $request->get('type')[$j];
				$wgt_range_frm 	= $request->get('wgt_range_frm')[$j];
				$wgt_range_to 	= $request->get('wgt_range_to')[$j];
				$avg_wgt_per_pcs= $request->get('avgWGTrangePERitemHIDDEN')[$j];
				$qty 			= $request->get('qty')[$j];
				$avg_wgt_range	= $request->get('avg_wgt_range')[$j];
				$specification 	= addslashes($request->get('specification')[$j]);
				$po_open_ord_det_id = $request->get('po_open_ord_det_id')[$j];
				
				$updtOPENordDETAILS = "UPDATE `po_open_ord_det` SET `jc_no`='$job_card_no', `cat_shortname`='$cat_short_name', `typ_e`='$type', `wgt_range_from`='$wgt_range_frm', `wgt_range_to`='$wgt_range_to', `avg_wgt_per_pcs`='$avg_wgt_per_pcs', `ord_qty`='$qty', `avg_wgt_range`='$avg_wgt_range', `ord_spec`='$specification', `update_by`='$sessionId',`update_dt`='$nowDateTime' WHERE `po_open_ord_det_id`='$po_open_ord_det_id'";
				$stmtOPENordDETAILS = $connection->executeQuery($updtOPENordDETAILS);
			}
			
			for($i=$RSLTopenORDpoPARTICU; $i<=$tot_vari_cat_shtnm; $i++)
			{
				$po_open_ord_id = $FTCHopenORDpoBASICdt['po_open_ord_id'];
				$job_card_no 	= $request->get('job_card_no')[$i];
				$cat_short_name = $request->get('cat_short_name')[$i];
				$type 			= $request->get('type')[$i];
				$wgt_range_frm 	= $request->get('wgt_range_frm')[$i];
				$wgt_range_to 	= $request->get('wgt_range_to')[$i];
				$avg_wgt_per_pcs= $request->get('avgWGTrangePERitemHIDDEN')[$i];
				$qty 			= $request->get('qty')[$i];
				$avg_wgt_range	= $request->get('avg_wgt_range')[$i];
				$specification 	= addslashes($request->get('specification')[$i]);
				
				#--------[ INSERT OPEN ORDER - DETAILS
				$instOPENordDETAILS = "INSERT INTO `po_open_ord_det`(`po_open_ord_id`, `ord_type`, `jc_no`, `cat_shortname`, `typ_e`, `wgt_range_from`, `wgt_range_to`, `avg_wgt_per_pcs`, `ord_qty`, `avg_wgt_range`, `ord_spec`, `post_by`, `post_dt`) VALUES ('$po_open_ord_id', 'cust', '$job_card_no', '$cat_short_name', '$type', '$wgt_range_frm', '$wgt_range_to', '$avg_wgt_per_pcs', '$qty', '$avg_wgt_range', '$specification', '$sessionId', '$nowDateTime')";
				$stmtOPENordDETAILS = $connection->executeQuery($instOPENordDETAILS);
			}

		return $this->redirect('po-customer-order-list');
		}

		return $this->render('po-customer-order/po-customer-order-upd.html.twig', [
			'openORDpoBASICdt' => $FTCHopenORDpoBASICdt,
			'openORDjc' => $openORDjc,
			'openORDpoPARTICU' => $FTCHopenORDpoPARTICU,
			'partDATAs' => $FTCHpartDATAs,
			'RSLTopenORDpoPARTICU' => $RSLTopenORDpoPARTICU,
			'controller_name' => 'PoCustomerOrderController'
        ]);
    }

	
	/**
     * @Route("/po-customer-order-jc-dlt{poJCdltID}", name="po-customer-order-jc-dlt")   
     */
    public function poOpenOrderJCdltAct(Request $request, $poJCdltID) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		#--------[ DEELTE - JC No
		$QURYjc = "DELETE FROM `po_open_ord_det` WHERE `po_open_ord_det_id`='".$poJCdltID."'";
		$CONNjc = $connection->executeQuery($QURYjc);

		return $this->redirectToRoute('po-customer-order-upd', ['poOPENordID' => $_GET['poOPENordID']]);
    }
	
	
	/**
     * @Route("/po-customer-order-dlt{poJCdltID}", name="po-customer-order-dlt")   
     */
    public function poOpenOrderDltAct(Request $request, $poJCdltID) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		#--------[ DEELTE - ORDER No
		$QURYOr = "DELETE FROM `po_open_ord` WHERE `po_open_ord_id`='".$poJCdltID."'";
		$CONNOr = $connection->executeQuery($QURYOr);
		
		#--------[ DEELTE - JC No
		$QURYjc = "DELETE FROM `po_open_ord_det` WHERE `po_open_ord_id`='".$poJCdltID."'";
		$CONNjc = $connection->executeQuery($QURYjc);		

		return $this->redirectToRoute('po-customer-order-list');
    }			
}