<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class PoCatalogueOrdersController extends AbstractController
{


	/**
     * @Route("/po-catalogue-orders-search", name="po-catalogue-orders-search")
     */
    public function poCatalogueOrderSearchAct(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection();
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");	
		
		########-[ LIST DESIGN CAT - DETAILS
		$QURYdesgCAT	= "SELECT * FROM `design_cat` ORDER BY `design_cat_name` ASC";
		$CONNdesgCAT	= $connection->executeQuery($QURYdesgCAT);
		$FTCHdesgCAT	= $CONNdesgCAT->fetchAll();	
		
		
		if($request->getMethod() == 'POST')
		{
			$desg_cat 		= $request->get('desg_cat');
			$short_name_exp = $request->get('short_name_exp');
			$desg_scat 		= $request->get('desg_scat');
			$wgt_range_frm 	= $request->get('wgt_range_frm');
			$wgt_range_to 	= $request->get('wgt_range_to');
			
			#--------[ LIST DESIGN SHORTFORM - DETAILS
			$QURYshrtFORM	= "SELECT `design_gen_cat_id`, CONCAT(`short_form`, ' - ',`expansion`) AS shortForm FROM `design_gen_cat` WHERE `design_cat_id`='".$desg_cat ."' ORDER BY `short_form` ASC";
			$CONNshrtFORM	= $connection->executeQuery($QURYshrtFORM);
			$FTCHshrtFORM	= $CONNshrtFORM->fetchAll();
			
			#--------[ LIST SUBDESIGN CAT - DETAILS
			$QURYdesgSCAT	= "SELECT DISTINCT DSC.`design_subcat_id`, DSC.`design_subcat_name` FROM `design_gen_cat_det` AS DGCD, design_subcat AS DSC WHERE DGCD.`design_gen_cat_id`='".$short_name_exp."' AND DGCD.`design_subcat_id`=DSC.`design_subcat_id` ORDER BY DSC.`design_subcat_name` ASC";
			$CONNdesgSCAT	= $connection->executeQuery($QURYdesgSCAT);
			$FTCHdesgSCAT	= $CONNdesgSCAT->fetchAll();			

			#--------[SEARCH QUERY
			$QURYcataDSGNs = "SELECT designs.`design_id`, designs.`design_image_ext_1`, CONCAT( designs.`design_short_form`, '', designs.`design_no` ) AS design_no, design_cat.design_cat_name, design_subcat.design_subcat_name, designs.no_of_st, designs.st_wgt, designs.gross_wgt, po_open_ord_det.design_id AS checkCATALOGdsgnAVAIL FROM designs LEFT JOIN design_cat ON designs.design_cat_id = design_cat.design_cat_id LEFT JOIN design_subcat ON designs.design_subcat_id = design_subcat.design_subcat_id LEFT JOIN po_open_ord_det ON designs.design_id = po_open_ord_det.design_id AND po_open_ord_det.po_open_ord_id = 0 WHERE designs.`design_cat_id` = '".$desg_cat."' AND designs.`design_subcat_id` = '".$desg_scat."' AND designs.`design_gen_cat_id` = '".$short_name_exp."' AND designs.`gross_wgt` BETWEEN '".$wgt_range_frm."' AND '".$wgt_range_to."' ORDER BY designs.`design_id`";			
			$CONNcataDSGNs = $connection->executeQuery($QURYcataDSGNs);
			$FTCHcataDSGNs = $CONNcataDSGNs->fetchAll();
			
		}
		else
		{
			$FTCHshrtFORM = "";
			$FTCHdesgSCAT = "";
		}

		return $this->render('po-catalogue-orders/po-catalogue-orders-search.html.twig', [
			'desgCAT' => $FTCHdesgCAT,
			'postDsgnCAT' => $desg_cat,
			'postDsgnSHT' => $short_name_exp,
			'postDsgnSCAT' => $desg_scat,
			'postWGTfrm' => $wgt_range_frm,
			'postWGTto' => $wgt_range_to,
			'searchCATAdsgns' => $FTCHcataDSGNs,
			'shrtFORM' => $FTCHshrtFORM,
			'desgSCAT' => $FTCHdesgSCAT,
			'controller_name' => 'PoCatalogueOrdersController'
        ]);
    }
	
	
	/**
     * @Route("/po-catalogue-orders-add", name="po-catalogue-orders-add")
     */
    public function poCatalogueOrderAddAct(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection();
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");	 

		
		#--------[ FETCH - OPEN ORDER NO - AUTO GENERATE
		$QURYopenORDpoAUTOGEN = "SELECT IFNULL(MAX(LPAD(`po_open_ord_no` + 1, 3, '0')), '001') AS openORDno FROM `po_open_ord` WHERE `role_status`=1 AND `post_dt` LIKE '%-".date('m')."-%'";
		$CONNopenORDpoAUTOGEN = $connection->executeQuery($QURYopenORDpoAUTOGEN);
		$FTCHopenORDpoAUTOGEN = $CONNopenORDpoAUTOGEN->fetchAll();
		$RSLTopenORDpoAUTOGEN = "CT".date('m').$FTCHopenORDpoAUTOGEN[0]['openORDno'];
		$RSLTopenORDjcAUTOGEN = date('m').$FTCHopenORDpoAUTOGEN[0]['openORDno'];
		
		
		#--------[ FETCH - PARTY DATA's
		$QURYpartDATAs = "SELECT `party_id`, CONCAT(`concern_name`,' - ',`party_name`,' - [',`pid`,']') AS partyName FROM `party` WHERE `role_status`=1 ORDER BY `concern_name` ASC";
		$CONNpartDATAs = $connection->executeQuery($QURYpartDATAs);
		$FTCHpartDATAs = $CONNpartDATAs->fetchAll();
		
		
		#--------[ FETCH - CATA DESIGNs
		$QURYcataDSGNs = "SELECT CONCAT( D.`design_short_form`, '', D.`design_no` ) AS design_no, D.`design_id`, D.`design_image_ext_1`, D.`design_short_form`, D.`gross_wgt`, GC.design_type_id FROM `designs` AS D, `po_open_ord_det` AS poORD, `design_gen_cat` AS GC WHERE poORD.`po_open_ord_id` = 0 AND poORD.design_id = D.design_id AND D.design_gen_cat_id=GC.design_gen_cat_id ORDER BY D.design_id ASC";
		$CONNcataDSGNs = $connection->executeQuery($QURYcataDSGNs);
		$FTCHcataDSGNs = $CONNcataDSGNs->fetchAll();
		
		
		if($request->getMethod() == 'POST')
		{
			$open_order_po_code	= "CT".date('m');
			$open_order_po_no 	= $FTCHopenORDpoAUTOGEN[0]['openORDno'];
			$entry_date			= explode("-", $request->get('entry_date'));
			$entry_date			= $entry_date[2]."-".$entry_date[1]."-".$entry_date[0];
			$party_id 			= $request->get('party_id');
			$tot_open_ord_qty 	= $request->get('tot_open_ord_qty');
			$tot_open_ordAvg_wt = $request->get('tot_open_ord_avg_wt');
			$tot_vari_cat_shtnm = count($request->get('job_card_no'));
			
			
			#--------[INSERT OPEN ORDER - BASIC DATA
			$instOPENordBASICdata = "INSERT INTO `po_open_ord`(`po_open_ord_code`, `po_open_ord_no`, `entry_date`, `party_id`, `avg_tot_wgt`, `tot_qty`, `tot_variety_cat_shortname`, `post_by`, `post_dt`) VALUES ('$open_order_po_code', '$open_order_po_no', '$entry_date', '$party_id', '$tot_open_ordAvg_wt', '$tot_open_ord_qty', '$tot_vari_cat_shtnm', '$sessionId', '$nowDateTime')";
			$stmtOPENordBASICdata = $connection->executeQuery($instOPENordBASICdata);
			$po_open_ord_id 	  = $connection->lastInsertId();
			

			$QURYcataDSGNs = "SELECT poORD.po_open_ord_det_id FROM `designs` AS D, `po_open_ord_det` AS poORD, `design_gen_cat` AS GC WHERE poORD.`po_open_ord_id` = 0 AND poORD.design_id = D.design_id AND D.design_gen_cat_id=GC.design_gen_cat_id ORDER BY D.design_id ASC";
			$CONNcataDSGNs = $connection->executeQuery($QURYcataDSGNs);
			$FTCHcataDSGNs = $CONNcataDSGNs->fetchAll();				
			$CONTcataDSGNs = count($FTCHcataDSGNs);
			
			
			for($i=0; $i<=$CONTcataDSGNs-1; $i++)
			{
				$job_card_no 	= $request->get('job_card_no')[$i];
				$cat_short_name = $request->get('cat_short_name')[$i];
				$type 			= $request->get('type')[$i];
				$wgt_range_frm 	= $request->get('wgt_range_frm')[$i];
				$wgt_range_to 	= $request->get('wgt_range_to')[$i];
				$avg_wgt_per_pcs= $request->get('avgWGTrangePERitemHIDDEN')[$i];
				$qty 			= $request->get('qty')[$i];
				$avg_wgt_range	= $request->get('avg_wgt_range')[$i];
				$specification 	= addslashes($request->get('specification')[$i]);
				
				$updt = "UPDATE `po_open_ord_det` SET `po_open_ord_id`='$po_open_ord_id', `jc_no`='$job_card_no', `typ_e`='$type', `wgt_range_from`='$wgt_range_frm', `wgt_range_to`='$wgt_range_to', `avg_wgt_per_pcs`='$avg_wgt_per_pcs', `ord_qty`='$qty', `avg_wgt_range`='$avg_wgt_range', `ord_spec`='$specification', `update_by`='$sessionId',`update_dt`='$nowDateTime' WHERE `po_open_ord_det_id`='".$FTCHcataDSGNs[$i]['po_open_ord_det_id']."' ";
				$stmt = $connection->executeQuery($updt);
			}
			
			return $this->redirect('po-catalogue-orders-list');
		}

		return $this->render('po-catalogue-orders/po-catalogue-orders-add.html.twig', [
			'openORDno' => $RSLTopenORDpoAUTOGEN,
			'openORDjc' => $RSLTopenORDjcAUTOGEN,
			'partDATAs' => $FTCHpartDATAs,
			'cataDSGNs' => $FTCHcataDSGNs,
			'controller_name' => 'PoCatalogueOrdersController'
        ]);
    }


	/**
     * @Route("/po-catalogue-orders-list", name="po-catalogue-orders-list")
     */
    public function poCatalogueOrderListAct(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		#--------[ FETCH - JC
		$QURYopenORD = "SELECT OPD.`po_open_ord_det_id`, OP.po_open_ord_id, CONCAT(OP.po_open_ord_code,'',OP.po_open_ord_no) AS opNO, OPD.jc_no, FORMAT(OP.avg_tot_wgt, 2) AS ordTOTwgt, DATE_FORMAT(OP.post_dt, '%b %D, %y %I:%i %p') AS entry_date, P.concern_name, P.party_name, OPD.cat_shortname, OPD.typ_e, FORMAT(OPD.wgt_range_from, 2) AS wgt_range_from, FORMAT(OPD.wgt_range_to, 3) AS wgt_range_to, FORMAT(OPD.avg_wgt_per_pcs , 3) AS avg_wgt_per_pcs, OPD.ord_qty, FORMAT(OPD.avg_wgt_range , 3) AS avg_wgt_range, OPD.ord_spec FROM `po_open_ord_det` AS OPD, `po_open_ord` AS OP, `party` AS P WHERE OPD.po_open_ord_id=OP.po_open_ord_id AND OP.party_id=P.party_id AND OPD.jc_no_split_status='Yes' AND OPD.design_id!=0 ORDER BY OP.po_open_ord_id DESC";
		$CONNopenORD = $connection->executeQuery($QURYopenORD);
		$FTCHopenORD = $CONNopenORD->fetchAll();
		$CONTopenORD = count($FTCHopenORD) - 1;
		
		
		$openORDdata = "";
		for($i=0; $i<=$CONTopenORD; $i++)
		{
/*			$jc_no = explode("-", $FTCHopenORD[$i]['jc_no']);
			$jc_no = $jc_no[1];*/
			
/*			#--------[ FETCH - JC COUNT
			$QURYjcCONT = "SELECT COUNT(`po_open_ord_id`) AS countJCs FROM `po_open_ord_det` WHERE `po_open_ord_id`='".$FTCHopenORD[$i]['po_open_ord_id']."'";
			$CONNjcCONT = $connection->executeQuery($QURYjcCONT);
			$FTCHjcCONT = $CONNjcCONT->fetchAll();	
			$countJCs   = $FTCHjcCONT[0]['countJCs'];*/
			
			#--------[ CHECK - JC in WAX ENTRY
			$QURYwxENT = "SELECT `wax_entry_id` FROM `wax_entry` WHERE `po_open_ord_id`='".$FTCHopenORD[$i]['po_open_ord_id']."'";
			$CONNwxENT = $connection->executeQuery($QURYwxENT);
			$FTCHwxENT = $CONNwxENT->fetchAll();
			$CHCKwxENT = $FTCHwxENT[0]['wax_entry_id'];	
			
			$QURYmxPOID = "SELECT MAX(`po_open_ord_det_id`) AS po_open_ord_det_id FROM `po_open_ord_det` WHERE `po_open_ord_id`='".$FTCHopenORD[$i]['po_open_ord_id']."'";
			$CONNmxPOID = $connection->executeQuery($QURYmxPOID);
			$FTCHmxPOID = $CONNmxPOID->fetchAll();
			$CHCKmxPOID = $FTCHmxPOID[0]['po_open_ord_det_id'];	

			
			$openORDdata .='<tr>
						  <td title="Serial No." style="text-align:center; vertical-align: middle;">'.($i+1).'</td>
						  <td title="Showing - PO No./Job Card No." style="text-align:left; vertical-align: middle;"><b><u>'.$FTCHopenORD[$i]['opNO'].'</u><br>'.$FTCHopenORD[$i]['ordTOTwgt'].' <small>(g)</small></b><br>'.$FTCHopenORD[$i]['jc_no'].'</td>
						  <td title="Showing - PO Date/Specification" style="text-align:left; vertical-align: middle;"><u>'.$FTCHopenORD[$i]['entry_date'].'</u><br>'.$FTCHopenORD[$i]['ord_spec'].'</td>
						  <td title="Showing - Concern Name/Party Name" style="text-align:left; vertical-align: middle;"><u>'.$FTCHopenORD[$i]['concern_name'].'</u><br>'.$FTCHopenORD[$i]['party_name'].'</td>';
			
			if($FTCHopenORD[$i]['typ_e'] == 1){ $itemTYPE = "Stone"; } else if($FTCHopenORD[$i]['typ_e'] == 0) { $itemTYPE = "Plain"; }
			
		  $openORDdata .='<td title="Showing - Category Short Name / Type" style="text-align:center; vertical-align: middle;"><u>'.$FTCHopenORD[$i]['cat_shortname'].'</u> <br>'.$itemTYPE.'</td>';
		  /*
		  $openORDdata .='<td title="Showing - Weight Range From in grams" style="text-align:right; vertical-align: middle;">'.$FTCHopenORD[$i]['wgt_range_from'].'</td>
						  <td title="Showing - Weight Range To in grams" style="text-align:right; vertical-align: middle;">'.$FTCHopenORD[$i]['wgt_range_to'].'</td>
              			  <td title="Showing - Average Weight/Piece in grams" style="text-align:center; vertical-align: middle;">'.$FTCHopenORD[$i]['avg_wgt_per_pcs'].'</td>';
		  */
		  $openORDdata .='<td title="Showing - Cat Order Quantity" style="text-align:center; vertical-align: middle;">'.$FTCHopenORD[$i]['ord_qty'].'</td>
			              <td title="Showing - Total Average Weight in grams" style="text-align:center; vertical-align: middle;">'.$FTCHopenORD[$i]['avg_wgt_range'].'</td>
						  <td title="Action" style="text-align:center; vertical-align: middle;">';

/*  	  if($CHCKwxENT == "")
		  {
			  if($jc_no >= $countJCs)
			  {	
			  $openORDdata .='<a href="po-catalogue-orders-upd'.$FTCHopenORD[$i]['po_open_ord_id'].'"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>
								&nbsp;&nbsp;&nbsp;
							  <a href="po-open-order-dlt'.$FTCHopenORD[$i]['po_open_ord_id'].'"><i class="fa fa-trash" aria-hidden="true" style="color:red;"></i></a>';
			   }
		   }
		   else if($CHCKwxENT != "")
		   {
			  if($jc_no >= $countJCs)
			  {		   
			  $openORDdata .='<i class="fa fa-pencil-square-o" aria-hidden="true" style="color:#E8E8E8"></i>
								&nbsp;&nbsp;&nbsp;
							  <i class="fa fa-trash" aria-hidden="true" style="color:#E8E8E8;"></i>';
			  }
		   }*/
		   
  		  if($CHCKwxENT == "")
		  {
			  if($CHCKmxPOID == $FTCHopenORD[$i]['po_open_ord_det_id'])
			  {	
			  $openORDdata .='<a href="po-catalogue-orders-upd'.$FTCHopenORD[$i]['po_open_ord_id'].'"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>
								&nbsp;&nbsp;&nbsp;
							  <a href="po-open-order-dlt'.$FTCHopenORD[$i]['po_open_ord_id'].'"><i class="fa fa-trash" aria-hidden="true" style="color:red;"></i></a>';
			   }
		   }
		   else if($CHCKwxENT != "")
		   {
			  if($CHCKmxPOID == $FTCHopenORD[$i]['po_open_ord_det_id'])
			  {		   
			  $openORDdata .='<i class="fa fa-pencil-square-o" aria-hidden="true" style="color:#E8E8E8"></i>
								&nbsp;&nbsp;&nbsp;
							  <i class="fa fa-trash" aria-hidden="true" style="color:#E8E8E8;"></i>';
			  }
		   }		   
		
		$openORDdata .='</td>
					</tr>';
		
		}
		
		return $this->render('po-catalogue-orders/po-catalogue-orders-list.html.twig', [
			'openORDlist' => $FTCHopenORD,
			'openORDdata' => $openORDdata,
			'controller_name' => 'PoOpenOrderController'
        ]);
    }		
	

	/**
     * @Route("/po-catalogue-orders-upd{poOPENordID}", name="po-catalogue-orders-upd")   
     */
    public function poOpenOrderUpdAct(Request $request, $poOPENordID) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection();
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");	 

		
		#--------[ FETCH - OPEN ORDER BASIC DATA's
		$QURYopenORDpoBASICdt = "SELECT po_open_ord_id, po_open_ord_code, po_open_ord_no, entry_date, party_id, tot_qty, avg_tot_wgt FROM `po_open_ord` WHERE `po_open_ord_id`='".$poOPENordID."'";
		$CONNopenORDpoBASICdt = $connection->executeQuery($QURYopenORDpoBASICdt);
		$FTCHopenORDpoBASICdt = $CONNopenORDpoBASICdt->fetchAll();
		
		$FTCHopenORDpoBASICdt['po_open_ord_no']	= $FTCHopenORDpoBASICdt[0]['po_open_ord_code'].$FTCHopenORDpoBASICdt[0]['po_open_ord_no'];
		$FTCHopenORDpoBASICdt['entry_date'] 	= explode("-", $FTCHopenORDpoBASICdt[0]['entry_date']);
		$FTCHopenORDpoBASICdt['entry_date'] 	= $FTCHopenORDpoBASICdt['entry_date'][2]."-".$FTCHopenORDpoBASICdt['entry_date'][1]."-".$FTCHopenORDpoBASICdt['entry_date'][0];
		$FTCHopenORDpoBASICdt['party_id'] 		= $FTCHopenORDpoBASICdt[0]['party_id'];
		$FTCHopenORDpoBASICdt['tot_qty']		= $FTCHopenORDpoBASICdt[0]['tot_qty'];
		$FTCHopenORDpoBASICdt['avg_tot_wgt'] 	= number_format($FTCHopenORDpoBASICdt[0]['avg_tot_wgt'], 2);
		$openORDjc								= explode("CT", $FTCHopenORDpoBASICdt['po_open_ord_no']);
		$openORDjc								= $openORDjc[1];
		$FTCHopenORDpoBASICdt['po_open_ord_id']	= $FTCHopenORDpoBASICdt[0]['po_open_ord_id'];
		
		#--------[ FETCH - PARTY DATA's
		$QURYpartDATAs = "SELECT `party_id`, CONCAT(`concern_name`,' - ',`party_name`,' - [',`pid`,']') AS partyName FROM `party` WHERE `role_status`=1 ORDER BY `concern_name` ASC";
		$CONNpartDATAs = $connection->executeQuery($QURYpartDATAs);
		$FTCHpartDATAs = $CONNpartDATAs->fetchAll();
		
		#--------[ FETCH - CATA DESIGNs
		$QURYcataDSGNs = "SELECT poORD.`po_open_ord_det_id` AS catNEWentryID, CONCAT( D.`design_short_form`, '', D.`design_no` ) AS design_no, D.`design_id`, D.`design_image_ext_1`, D.`design_short_form`, D.`gross_wgt`, GC.design_type_id, poORD.jc_no FROM `designs` AS D, `po_open_ord_det` AS poORD, `design_gen_cat` AS GC WHERE poORD.`po_open_ord_id` = 0 AND poORD.design_id = D.design_id AND D.design_gen_cat_id=GC.design_gen_cat_id ORDER BY D.design_id ASC";
		$CONNcataDSGNs = $connection->executeQuery($QURYcataDSGNs);
		$FTCHcataDSGNs = $CONNcataDSGNs->fetchAll();	
		$CONTcataDSGNs = count($FTCHcataDSGNs) - 1;	

		#--------[ FETCH - OPEN ORDER PARTICULAR's
		$QURYopenORDpoPARTICU = "SELECT OPD.`po_open_ord_det_id` AS catNEWentryID, D.`design_id`, D.`design_image_ext_1`, CONCAT( D.`design_short_form`, '', D.`design_no` ) AS design_no, OPD.* FROM `po_open_ord_det` AS OPD, designs AS D WHERE OPD.`po_open_ord_id`='".$poOPENordID."' AND OPD.design_id=D.design_id ORDER BY OPD.`po_open_ord_det_id` ASC";
		$CONNopenORDpoPARTICU = $connection->executeQuery($QURYopenORDpoPARTICU);
		$FTCHopenORDpoPARTICU = $CONNopenORDpoPARTICU->fetchAll();
		$contopenORDpoPARTICU = count($FTCHopenORDpoPARTICU) - 1;
		$RSLTopenORDpoPARTICU = count($FTCHopenORDpoPARTICU);
		
		if($request->getMethod() == 'POST')
		{
			$open_order_po_code	= "CT".date('m');
			$open_order_po_no 	= $FTCHopenORDpoAUTOGEN[0]['openORDno'];
			$entry_date			= explode("-", $request->get('entry_date'));
			$entry_date			= $entry_date[2]."-".$entry_date[1]."-".$entry_date[0];
			$party_id 			= $request->get('party_id');
			$tot_open_ord_qty 	= $request->get('tot_open_ord_qty');
			$tot_open_ordAvg_wt = $request->get('tot_open_ord_avg_wt');
			$tot_vari_cat_shtnm = count($request->get('job_card_no'))-1;
			
			
			#--------[UPDATE OPEN ORDER - BASIC DATA
			$updtOPENordBASICdata = "UPDATE `po_open_ord` SET `party_id`='$party_id', `avg_tot_wgt`='$tot_open_ordAvg_wt', `tot_qty`='$tot_open_ord_qty', `tot_variety_cat_shortname`='$tot_vari_cat_shtnm', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE `po_open_ord_id`='".$FTCHopenORDpoBASICdt['po_open_ord_id']."'";
			$stmtOPENordBASICdata = $connection->executeQuery($updtOPENordBASICdata);
			
			for($j=0; $j<=$tot_vari_cat_shtnm; $j++)
			{
				$job_card_no 	= $request->get('job_card_no')[$j];
				$cat_short_name = $request->get('cat_short_name')[$j];
				$type 			= $request->get('type')[$j];
				$wgt_range_frm 	= $request->get('wgt_range_frm')[$j];
				$wgt_range_to 	= $request->get('wgt_range_to')[$j];
				$avg_wgt_per_pcs= $request->get('avgWGTrangePERitemHIDDEN')[$j];
				$qty 			= $request->get('qty')[$j];
				$avg_wgt_range	= $request->get('avg_wgt_range')[$j];
				$specification 	= addslashes($request->get('specification')[$j]);
				$po_open_ord_det_id = $request->get('po_open_ord_det_id')[$j];
				$catNEWentryID = $request->get('catNEWentryID')[$j];

				$updtOPENordDETAILS = "UPDATE `po_open_ord_det` SET `po_open_ord_id`='".$poOPENordID."', `jc_no`='$job_card_no', `cat_shortname`='$cat_short_name', `typ_e`='$type', `wgt_range_from`='$wgt_range_frm', `wgt_range_to`='$wgt_range_to', `avg_wgt_per_pcs`='$avg_wgt_per_pcs', `ord_qty`='$qty', `avg_wgt_range`='$avg_wgt_range', `ord_spec`='$specification', `update_by`='$sessionId',`update_dt`='$nowDateTime' WHERE `po_open_ord_det_id`='$catNEWentryID'";
				$stmtOPENordDETAILS = $connection->executeQuery($updtOPENordDETAILS);
			}
//			
//			for($i=$j; $i<=$CONTcataDSGNs; $i++)
//			{
//				$po_open_ord_id = $FTCHopenORDpoBASICdt['po_open_ord_id'];
//				$job_card_no 	= $request->get('job_card_no')[$i];
//				$cat_short_name = $request->get('cat_short_name')[$i];
//				$type 			= $request->get('type')[$i];
//				$wgt_range_frm 	= $request->get('wgt_range_frm')[$i];
//				$wgt_range_to 	= $request->get('wgt_range_to')[$i];
//				$avg_wgt_per_pcs= $request->get('avgWGTrangePERitemHIDDEN')[$i];
//				$qty 			= $request->get('qty')[$i];
//				$avg_wgt_range	= $request->get('avg_wgt_range')[$i];
//				$specification 	= addslashes($request->get('specification')[$i]);
//				
//				#--------[ INSERT OPEN ORDER - DETAILS
//				echo
//				$instOPENordDETAILS = "INSERT INTO `po_open_ord_det`(`po_open_ord_id`, `design_id`, `jc_no`, `cat_shortname`, `typ_e`, `wgt_range_from`, `wgt_range_to`, `avg_wgt_per_pcs`, `ord_qty`, `avg_wgt_range`, `ord_spec`, `post_by`, `post_dt`) VALUES ('$po_open_ord_id', '$job_card_no', '$cat_short_name', '$type', '$wgt_range_frm', '$wgt_range_to', '$avg_wgt_per_pcs', '$qty', '$avg_wgt_range', '$specification', '$sessionId', '$nowDateTime')";
//				echo "<br>";
//				//$stmtOPENordDETAILS = $connection->executeQuery($instOPENordDETAILS);*/
//				
//				echo
//				$updtCATordDETAILS = "UPDATE `po_open_ord_det` SET `jc_no`='$job_card_no', `cat_shortname`='$cat_short_name', `typ_e`='$type', `wgt_range_from`='$wgt_range_frm', `wgt_range_to`='$wgt_range_to', `avg_wgt_per_pcs`='$avg_wgt_per_pcs', `ord_qty`='$qty', `avg_wgt_range`='$avg_wgt_range', `ord_spec`='$specification', `update_by`='$sessionId',`update_dt`='$nowDateTime' WHERE `po_open_ord_det_id`='".$FTCHcataDSGNs[$i]['catNEWentryID']."' ";
//				echo "<br>";
//				//$stmtCATordDETAILS = $connection->executeQuery($updtCATordDETAILS);				
//			}
		return $this->redirect('po-catalogue-orders-list');
		}

		return $this->render('po-catalogue-orders/po-catalogue-orders-upd.html.twig', [
			'openORDpoBASICdt' => $FTCHopenORDpoBASICdt,
			'openORDjc' => $openORDjc,
			'openORDpoPARTICU' => $FTCHopenORDpoPARTICU,
			'partDATAs' => $FTCHpartDATAs,
			'RSLTopenORDpoPARTICU' => $RSLTopenORDpoPARTICU,
			'cataDSGNs' => $FTCHcataDSGNs,
			'controller_name' => 'PoOpenOrderController'
        ]);
    }	
}