<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class PartiesController extends AbstractController
{
    /**
     * @Route("/party-list", name="party-list")
     */
    public function partyLISTact(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		########-[ GET PARTY LIST
		$QURYlist	= "SELECT * FROM `party` ORDER BY `pid` DESC";
		$CONNlist	= $connection->executeQuery($QURYlist);
		$FTCHlist	= $CONNlist->fetchAll();
		
		return $this->render('parties/party-list.html.twig', [
			'partyList' => $FTCHlist,
			'controller_name' => 'PartiesController'
        ]);
    }
	
	
    /**
     * @Route("/party-reg", name="party-reg")
     */
    public function partyREGact(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		########-[ GET PID
		$QURYmaxPID			= "SELECT MAX(`pid`) AS p_id FROM `party`";
		$CONNmaxPID			= $connection->executeQuery($QURYmaxPID);
		$FTCHmaxPID			= $CONNmaxPID->fetchAll();
		$FTCHmaxPID['p_id'] = $FTCHmaxPID[0]['p_id'];
		
		if($request->getMethod() == 'POST')
		{
			$pid		= $request->get('pid');
			$metal_blnc	= $request->get('metal_blnc');
			$concern_nm	= $request->get('concern_name');
			$person_nm	= $request->get('person_name');
			$gst_no		= $request->get('gst_no');
			$mbl1		= $request->get('mbl1');
			$mbl2		= $request->get('mbl2');
			$email1		= $request->get('email1');
			$email2		= $request->get('email2');
			$door_no	= $request->get('door_no');
			$street1	= $request->get('street1');
			$street2	= $request->get('street2');
			$city		= $request->get('city');
			$state		= $request->get('state');
			$sessionId  = $session->get('empId');
			
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime = date("Y-m-d H:i:s");
			
			########-[ INSERT - DETAILS
			$QRinsert = "INSERT INTO `party`(`pid`, `metal_blnc`, `concern_name`, `party_name`, `gst_no`, `mbl1`, `mbl2`, `email1`, `email2`, `door_no`, `street1`, `street2`, `city`, `state`, `post_by`, `post_dt`) VALUES ('$pid','$metal_blnc','$concern_nm','$person_nm','$gst_no','$mbl1','$mbl2','$email1','$email2','$door_no','$street1','$street2','$city','$state','$sessionId','$nwDateTime')";
			$CNexecut = $connection->executeQuery($QRinsert);
			
			return $this->redirectToRoute('party-list');
		}
		
		return $this->render('parties/party-reg.html.twig', [
			'maxPID' => $FTCHmaxPID,
			'controller_name' => 'PartiesController'
        ]);
    }


    /**
     * @Route("/party-dlt{party_dlt_id}", name="party-dlt")
     */
    public function partyDLTact(Request $request, $party_dlt_id) 
    {	
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 	
		
		########-[ DELETE - DETAILS
		$QRdltPARTY = "DELETE FROM `party` WHERE `party_id`=".$party_dlt_id;
		$CNdltPARTY = $connection->executeQuery($QRdltPARTY);
		
		return $this->redirectToRoute('party-list');
	}


    /**
     * @Route("/party-upt{party_upt_id}", name="party-upt")
     */
    public function partyUPTact(Request $request, $party_upt_id) 
    {	
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 	
		
		########-[ GET UPDATE DATA
		$QURYuptDATA	= "SELECT * FROM `party` WHERE party_id = ".$party_upt_id;
		$CONNuptDATA	= $connection->executeQuery($QURYuptDATA);
		$FTCHuptDATA	= $CONNuptDATA->fetchAll();
		
		if($request->getMethod() == 'POST')
		{
			$metal_blnc	= $request->get('metal_blnc');
			$concern_nm	= $request->get('concern_name');
			$person_nm	= $request->get('person_name');
			$gst_no		= $request->get('gst_no');
			$mbl1		= $request->get('mbl1');
			$mbl2		= $request->get('mbl2');
			$email1		= $request->get('email1');
			$email2		= $request->get('email2');
			$door_no	= $request->get('door_no');
			$street1	= $request->get('street1');
			$street2	= $request->get('street2');
			$city		= $request->get('city');
			$state		= $request->get('state');
			$sessionId  = $session->get('empId');
			
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime = date("Y-m-d H:i:s");
			
			########-[ INSERT - DETAILS
			$QRuptDATA = "UPDATE `party` SET `metal_blnc`='$metal_blnc',`concern_name`='$concern_nm',`party_name`='$person_nm',`gst_no`='$gst_no',`mbl1`='$mbl1',`mbl2`='$mbl2',`email1`='$email1',`email2`='$email2',`door_no`='$door_no',`street1`='$street1',`street2`='$street2',`city`='$city',`state`='$state',`update_by`='$sessionId',`update_dt`='$nwDateTime' WHERE `party_id`=".$party_upt_id;
			$CNuptDATA = $connection->executeQuery($QRuptDATA);
			
			return $this->redirectToRoute('party-list');
		}
		
		return $this->render('parties/party-upt.html.twig', [
			'partyUPDTdata' => $FTCHuptDATA,
			'controller_name' => 'PartiesController'
        ]);
	}	
}
