<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class PVSIssueReceiveController extends AbstractController
{
    /**
     * @Route("/pvs-iss-rec-data{pvsIssRecID}", name="pvs-iss-rec-data")
     */
    public function PVSIssRecLISTact(Request $request, $pvsIssRecID) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		if($request->getMethod() == 'POST')
		{
			$type			= $request->get('type');
			$tran_no		= $request->get('tran_no');
			$iss_rec_date	= $request->get('iss_rec_date');
			$iss_rec_date 	= explode("-",$iss_rec_date);
			$iss_rec_date 	= $iss_rec_date[2]."-".$iss_rec_date[1]."-".$iss_rec_date[0];
			$iss_rec_to		= $request->get('iss_rec_to');
			$notes			= $request->get('notes');
			$wgt			= $request->get('wgt');
			$touch			= $request->get('touch');
			$profit_perc	= $request->get('profit_perc');
			$trans_type		= $request->get('trans_type');
			
			$sessionId  	= $session->get('empId');
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime 	= date("Y-m-d H:i:s");
			
			if($pvsIssRecID == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO `pvs_iss_rec`(`type`, `trans_no`, `trans_date`, `pvs_id`, `notes`, `wgt`, `purity`, `percentage`, `trans_type`, `post_by`, `post_dt`) VALUES ('$type', '$tran_no', '$iss_rec_date', '$iss_rec_to', '$notes', '$wgt', '$touch', '$profit_perc', '$trans_type', '$sessionId', '$nwDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
			}
			else
			{
				########-[ UPDATE - DETAILS
				$QRupdate = "UPDATE `pvs_iss_rec` SET `type`='$type', `trans_no`='$tran_no', `trans_date`='$iss_rec_date', `pvs_id`='$iss_rec_to', `notes`='$notes', `wgt`='$wgt', `purity`='$touch', `percentage`='$profit_perc', `trans_type`='$trans_type', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `pvs_iss_rec_id`='$pvsIssRecID'";
				$CNexecut = $connection->executeQuery($QRupdate);
			}
		
		return $this->redirectToRoute('pvs-iss-rec-data', array('pvsIssRecID' => $pvsIssRecID, 'pg' => $_GET["pg"]) );		
		}

		
		if($_GET["pg"] == "party")
		{
			########-[ GET TRANS NO
			$QURYtransNO	= "SELECT IF(MAX(`trans_no`) IS NULL,1,MAX(`trans_no`)+1) AS transNo FROM `pvs_iss_rec` WHERE `statu_s`=1 AND `trans_type`='p'";
			$CONNtransNO	= $connection->executeQuery($QURYtransNO);
			$FTCHtransNO	= $CONNtransNO->fetchAll();
			$RSLTtransNO	= $FTCHtransNO[0]['transNo'];


			########-[ GET PARTY LIST
			$QURYpartylist	= "SELECT `party_id`, `pid`, `concern_name`, `party_name` FROM `party` WHERE `role_status`=1 ORDER BY `concern_name` ASC";
			$CONNpartylist	= $connection->executeQuery($QURYpartylist);
			$FTCHpartylist	= $CONNpartylist->fetchAll();
			
			
			########-[ GET PARTY TRANS LIST
			$QURYtranslist	= "SELECT pvs.*, p.concern_name FROM `pvs_iss_rec` AS pvs, `party` AS p WHERE pvs.`trans_type`='p' AND p.`party_id`=pvs.`pvs_id` AND pvs.`statu_s`=1 ORDER BY pvs.`pvs_iss_rec_id` DESC";
			$CONNtranslist	= $connection->executeQuery($QURYtranslist);
			$FTCHtranslist	= $CONNtranslist->fetchAll();
			
			
			########-[ GET PARTY TRANS DATA to UPDATE
			$QURYtransDATA				= "SELECT * FROM `pvs_iss_rec` WHERE pvs_iss_rec_id='$pvsIssRecID'";
			$CONNtransDATA				= $connection->executeQuery($QURYtransDATA);
			$FTCHtransDATA				= $CONNtransDATA->fetchAll();
			$FTCHtransDATA['type'] 		= $FTCHtransDATA[0]['type'];
			$FTCHtransDATA['trans_no'] 	= $FTCHtransDATA[0]['trans_no'];
			$FTCHtransDATA['trans_date']= $FTCHtransDATA[0]['trans_date'];
			$FTCHtransDATA['pvs_id'] 	= $FTCHtransDATA[0]['pvs_id'];
			$FTCHtransDATA['notes'] 	= $FTCHtransDATA[0]['notes'];
			$FTCHtransDATA['wgt'] 		= $FTCHtransDATA[0]['wgt'];
			$FTCHtransDATA['purity'] 	= $FTCHtransDATA[0]['purity'];
			$FTCHtransDATA['percentage']= $FTCHtransDATA[0]['percentage'];
			
	
			return $this->render('parties-iss-rec/parties-iss-rec-data.html.twig', [
				'transNO' => $RSLTtransNO,
				'partylist' => $FTCHpartylist,
				'partyTRANSlist' => $FTCHtranslist,
				'FTCHtransDATA' => $FTCHtransDATA,
				'controller_name' => 'PVSIssueReceiveController'
			]);
		}
		else if($_GET["pg"] == "vendor")
		{
			########-[ GET TRANS NO
			$QURYtransNO	= "SELECT IF(MAX(`trans_no`) IS NULL,1,MAX(`trans_no`)+1) AS transNo FROM `pvs_iss_rec` WHERE `statu_s`=1 AND `trans_type`='v'";
			$CONNtransNO	= $connection->executeQuery($QURYtransNO);
			$FTCHtransNO	= $CONNtransNO->fetchAll();
			$RSLTtransNO	= $FTCHtransNO[0]['transNo'];


			########-[ GET VENDOR LIST
			$QURYvendorlist	= "SELECT `vendor_id`, `vid`, `concern_name`, `vendor_name` FROM `vendor` WHERE `role_status`=1 ORDER BY `concern_name` ASC";
			$CONNvendorlist	= $connection->executeQuery($QURYvendorlist);
			$FTCHvendorlist	= $CONNvendorlist->fetchAll();
			
			
			########-[ GET VENDOR TRANS LIST
			$QURYtranslist	= "SELECT pvs.*, v.concern_name FROM `pvs_iss_rec` AS pvs, `vendor` AS v WHERE pvs.`trans_type`='v' AND v.`vendor_id`=pvs.`pvs_id` AND pvs.`statu_s`=1 ORDER BY pvs.`pvs_iss_rec_id` DESC";
			$CONNtranslist	= $connection->executeQuery($QURYtranslist);
			$FTCHtranslist	= $CONNtranslist->fetchAll();
			
			
			########-[ GET VENDOR TRANS DATA to UPDATE
			$QURYtransDATA	= "SELECT * FROM `pvs_iss_rec` WHERE pvs_iss_rec_id='$pvsIssRecID'";
			$CONNtransDATA	= $connection->executeQuery($QURYtransDATA);
			$FTCHtransDATA	= $CONNtransDATA->fetchAll();
			$FTCHtransDATA['type'] 		= $FTCHtransDATA[0]['type'];
			$FTCHtransDATA['trans_no'] 	= $FTCHtransDATA[0]['trans_no'];
			$FTCHtransDATA['trans_date']= $FTCHtransDATA[0]['trans_date'];
			$FTCHtransDATA['pvs_id'] 	= $FTCHtransDATA[0]['pvs_id'];
			$FTCHtransDATA['notes'] 	= $FTCHtransDATA[0]['notes'];
			$FTCHtransDATA['wgt'] 		= $FTCHtransDATA[0]['wgt'];
			$FTCHtransDATA['purity'] 	= $FTCHtransDATA[0]['purity'];
			$FTCHtransDATA['percentage']= $FTCHtransDATA[0]['percentage'];
			
			return $this->render('vendor-iss-rec/vendor-iss-rec-data.html.twig', [
				'transNO' => $RSLTtransNO,
				'vendorlist' => $FTCHvendorlist,
				'vendorTRANSlist' => $FTCHtranslist,
				'FTCHtransDATA' => $FTCHtransDATA,
				'controller_name' => 'PVSIssueReceiveController'
			]);
		}
		else if($_GET["pg"] == "salespartner")
		{
			########-[ GET TRANS NO
			$QURYtransNO	= "SELECT IF(MAX(`trans_no`) IS NULL,1,MAX(`trans_no`)+1) AS transNo FROM `pvs_iss_rec` WHERE `statu_s`=1 AND `trans_type`='s'";
			$CONNtransNO	= $connection->executeQuery($QURYtransNO);
			$FTCHtransNO	= $CONNtransNO->fetchAll();
			$RSLTtransNO	= $FTCHtransNO[0]['transNo'];


			########-[ GET SALES LIST
			$QURYsalpartlist = "SELECT `sales_partner_id`, `spid`, `sales_partner_name` FROM `sales_partner` WHERE `role_status`=1 ORDER BY `sales_partner_name` ASC";
			$CONNsalpartlist = $connection->executeQuery($QURYsalpartlist);
			$FTCHsalpartlist = $CONNsalpartlist->fetchAll();
			
			
			########-[ GET SALES PARTNER TRANS LIST
			$QURYtranslist	= "SELECT pvs.*, sp.sales_partner_name FROM `pvs_iss_rec` AS pvs, `sales_partner` AS sp WHERE pvs.`trans_type`='s' AND sp.`sales_partner_id`=pvs.`pvs_id` AND pvs.`statu_s`=1 ORDER BY pvs.`pvs_iss_rec_id` DESC";
			$CONNtranslist	= $connection->executeQuery($QURYtranslist);
			$FTCHtranslist	= $CONNtranslist->fetchAll();
			
			
			########-[ GET SALES PARTNER TRANS DATA to UPDATE
			$QURYtransDATA				= "SELECT * FROM `pvs_iss_rec` WHERE pvs_iss_rec_id='$pvsIssRecID'";
			$CONNtransDATA				= $connection->executeQuery($QURYtransDATA);
			$FTCHtransDATA				= $CONNtransDATA->fetchAll();
			$FTCHtransDATA['type'] 		= $FTCHtransDATA[0]['type'];
			$FTCHtransDATA['trans_no'] 	= $FTCHtransDATA[0]['trans_no'];
			$FTCHtransDATA['trans_date']= $FTCHtransDATA[0]['trans_date'];
			$FTCHtransDATA['pvs_id'] 	= $FTCHtransDATA[0]['pvs_id'];
			$FTCHtransDATA['notes'] 	= $FTCHtransDATA[0]['notes'];
			$FTCHtransDATA['wgt'] 		= $FTCHtransDATA[0]['wgt'];
			$FTCHtransDATA['purity'] 	= $FTCHtransDATA[0]['purity'];
			$FTCHtransDATA['percentage']= $FTCHtransDATA[0]['percentage'];
			
			return $this->render('sales-partner-iss-rec/sales-partner-iss-rec-data.html.twig', [
				'transNO' => $RSLTtransNO,
				'salPartlist' => $FTCHsalpartlist,
				'salPartTRANSlist' => $FTCHtranslist,
				'FTCHtransDATA' => $FTCHtransDATA,
				'controller_name' => 'SalesPartnerIssueReceiveController'
			]);
		}		
    }
	
	
	/**
     * @Route("/pvs-iss-rec-ind-data{pvsIssRecIndID}", name="pvs-iss-rec-ind-data")
     */
    public function PVSIssRecIndLISTact(Request $request, $pvsIssRecIndID) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection();
		
		if($_GET["pg"] == "party")
		{
			########-[ GET PARTY TRANS LIST
			$QURYtranslist	= "SELECT pvs.*, p.concern_name FROM `pvs_iss_rec` AS pvs, `party` AS p WHERE pvs.`pvs_id` = '$pvsIssRecIndID' AND pvs.`trans_type`='p' AND p.`party_id`=pvs.`pvs_id` AND pvs.`statu_s`=1 ORDER BY pvs.`pvs_iss_rec_id` DESC";
			$CONNtranslist	= $connection->executeQuery($QURYtranslist);
			$FTCHtranslist	= $CONNtranslist->fetchAll();
			$RSLTconcernNM  = $FTCHtranslist[0]['concern_name'];
			

			########################-[ CALCULATION of BAL/ADV, LOSS/EXS, PUR - start ]-######################## 
			
			########-[ GET PARTY TRANS - ISSUE BLNC PURE
			$QURYissBLNC = "SELECT ROUND(SUM((`wgt` * `purity`)/100), 3) AS issBLNCpurity FROM `pvs_iss_rec` WHERE `pvs_id`='$pvsIssRecIndID' AND `type`='iss' AND `trans_type`='p'";
			$CONNissBLNC = $connection->executeQuery($QURYissBLNC);
			$FTCHissBLNC = $CONNissBLNC->fetchAll();
			$issBLNCpuri = $FTCHissBLNC[0]['issBLNCpurity'];
			
			########-[ GET PARTY TRANS - REC BLNC PURE
			$QURYrecBLNC = "SELECT ROUND(SUM((`wgt` * `percentage`)/100), 3) AS recBLNCpurity FROM `pvs_iss_rec` WHERE `pvs_id`='$pvsIssRecIndID' AND `type`='rec' AND `trans_type`='p'";
			$CONNrecBLNC = $connection->executeQuery($QURYrecBLNC);
			$FTCHrecBLNC = $CONNrecBLNC->fetchAll();
			$recBLNCpuri = $FTCHrecBLNC[0]['recBLNCpurity'];
			
			$RSLTbalADV = $issBLNCpuri + $recBLNCpuri;
			
			
			########-[ GET PARTY TRANS - LOSS/EXS
			$QURYlossEXS = "SELECT ROUND(SUM(`wgt`), 3) AS goldWt, ROUND(SUM((`wgt` * `purity`)/100), 3) AS pur, ROUND(SUM((`wgt` * `percentage`)/100), 3) AS recBLNCpurity FROM `pvs_iss_rec` WHERE `pvs_id`='$pvsIssRecIndID' AND `type`='rec' AND `trans_type`='p'";
			$CONNlossEXS = $connection->executeQuery($QURYlossEXS);
			$FTCHlossEXS = $CONNlossEXS->fetchAll();
			$rsltLOSSexs = $FTCHlossEXS[0]['pur'] - $FTCHlossEXS[0]['recBLNCpurity'];
			$rsltPURITY  = $FTCHlossEXS[0]['goldWt'];
				
			
			########################-[ CALCULATION of BAL/ADV, LOSS/EXS, PUR - start ]-######################## 				
			
			return $this->render('parties-iss-rec/parties-iss-rec-ind-data.html.twig', [
				'partyTRANSlist' => $FTCHtranslist,
				'balADV' => $RSLTbalADV,
				'LOSSexs' => $rsltLOSSexs,
				'purity' => $rsltPURITY,
				'concernNM' => $RSLTconcernNM,
				'controller_name' => 'PVSIssueReceiveController'
			]);
		} 
	}	
}
