<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class InstockMetalController extends AbstractController
{
    /**
     * @Route("/instock-metal{instockMetalID}", name="instock-metal")
     */
    public function instockMETALact(Request $request, $instockMetalID) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		date_default_timezone_set("Asia/Kolkata");
		$current_dt = date("Y-m-d");
		
		########-[ QUICK VARIABLES
		$tableName	= "instock_metal";
		$tablePrmID	= "instock_metal_id";
		$getVARIid	= $instockMetalID;
		
		########-[ LIST - DETAILS
		$QURYlistDet= "SELECT * FROM ".$tableName." WHERE inward_mode='others' ORDER BY ".$tablePrmID." DESC";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();
		
		if($getVARIid != 0)
		{
			########-[ GET UPDATE - DETAILS
			$QURYupdtDet	= "SELECT * FROM ".$tableName." WHERE ".$tablePrmID."=".$getVARIid;
			$CONNupdtDet	= $connection->executeQuery($QURYupdtDet);
			$FTCHupdtDet	= $CONNupdtDet->fetchAll();
			
			$FTCHupdtDet['entry_dt'] = $FTCHupdtDet[0]['entry_date'];
			$FTCHupdtDet['carat_22'] = $FTCHupdtDet[0]['carat_22'];
			$FTCHupdtDet['carat_24'] = $FTCHupdtDet[0]['carat_24'];
		}
		else
		{
			$FTCHupdtDet = "";
		}
		
		if($request->getMethod() == 'POST')
		{
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime = date("Y-m-d H:i:s");
			
			$current_dt 			= date("Y-m-d");
			$inward_mode 			= "others";
			$metal_inward_carat_24	= $request->get('metal_inward_carat_24');
			$sessionId  			= $session->get('empId');
			
			if($getVARIid == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO ".$tableName."(`entry_date`, `inward_mode`, `carat_24`, `post_by`, `post_dt`) VALUES ('$current_dt', '$inward_mode', '$metal_inward_carat_24', '$sessionId', '$nwDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
			}
			else
			{
				########-[ UPDATE - DETAILS			
				$QRupdate 	= "UPDATE ".$tableName." SET `inward_mode`='$inward_mode', `carat_24`='$metal_inward_carat_24', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE ".$tablePrmID."=".$getVARIid;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}
		
		
		return $this->render('instock-metal/instock-metal-data.html.twig', [
			'FTCHlistDet' => $FTCHlistDet,
			'FTCHupdtDet' => $FTCHupdtDet,
			'controller_name' => 'InstockMetalController'
        ]);
    }
}
