<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\HttpFoundation\JsonResponse;

class CatalogDesignsPageWiseController extends AbstractController
{

    /**
     * @Route("/catalog-designs-list", name="catalog-designs-list")  
     */
    public function catlogDesignsLIST(Request $request)
    {
        $session =$request->getSession();
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('/index');
        }

		$connection = $this->getDoctrine()->getManager()->getConnection();	

		########-[ LIST
		$QURYlistCUSTPRD = "SELECT CD.`catalog_designs_id`, CONCAT(DGC.short_form,' - ',DGC.expansion) AS shortFORM, DC.design_cat_name, DSC.design_subcat_name, P.`page_no`, P.`pages_id` FROM `catalog_designs` AS CD, `pages` AS P, `designs` AS D, `design_cat` AS DC, `design_subcat` AS DSC, `design_gen_cat` AS DGC WHERE CD.`pages_id` = P.`pages_id` AND CD.`design_cat_id` = D.design_cat_id AND D.`design_cat_id` = DC.design_cat_id AND CD.design_subcat_id = D.design_subcat_id AND D.design_subcat_id = DSC.design_subcat_id AND CD.design_gen_cat_id=DGC.design_gen_cat_id GROUP BY CD.`pages_id`, CD.design_cat_id";
		$CONClistCUSTPRD = $connection->executeQuery($QURYlistCUSTPRD);
		$FTCHlistCUSTPRD = $CONClistCUSTPRD->fetchAll();	
		$CONTlistCUSTPRD = count($FTCHlistCUSTPRD);

		$data = "";
		for($i=0; $i <= $CONTlistCUSTPRD - 1; $i++)
		{
			########-[ GET COUNT OF ITEMS OF PAGE
			$QURYcountITEMS = "SELECT COUNT(`pages_id`) AS itemCOUNT FROM `catalog_designs` WHERE `pages_id`=".$FTCHlistCUSTPRD[$i]['pages_id'];
			$CONCcountITEMS = $connection->executeQuery($QURYcountITEMS);
			$FTCHcountITEMS = $CONCcountITEMS->fetchAll();

			$data .= '<tr>
						<td title="Showing Page No." style="text-align:center;">'.$FTCHlistCUSTPRD[$i]['page_no'].'</td>
						<td title="Showing Design Category" style="text-align:left;">'.$FTCHlistCUSTPRD[$i]['design_cat_name'].'</td>
						<td title="Showing Design - Short Name & Expansion" style="text-align:left;">'.$FTCHlistCUSTPRD[$i]['shortFORM'].'</td>						
						<td title="Showing Design Subcategory" style="text-align:left;">'.$FTCHlistCUSTPRD[$i]['design_subcat_name'].'</td>
						<td title="Showing Count per Page" style="text-align:center;">'.$FTCHcountITEMS[0]['itemCOUNT'].'</td>
						<td title="Action" style="text-align:center;"><a href="catalog-pagewise-designs-list0?pid='.$FTCHlistCUSTPRD[$i]['pages_id'].'" class="btn btn-icon btn-primary" title="Check Page - Designs"><i class="fa fa-book" aria-hidden="true"></i></a> <a href="catalog-designs-upd0?pid='.$FTCHlistCUSTPRD[$i]['pages_id'].'" class="btn btn-icon btn-primary" title="Update"><i class="far fa-edit"></i></a></td>
					</tr>';
		}

        return $this->render('catalog-designs/catalog-designs-list.html.twig', [
			'data' => $data,
            'controller_name' => 'CatalogDesignsPageWiseController'
        ]);
    }


    /** 
	* @Route("/catalogDesgnsPageWise", name="catalogDesgnsPageWise") 
	*/ 
	public function GETcatalogDesgnsPageWise(Request $request) 
	{
		$session 		= $request->getSession();
        $connection   	= $this->getDoctrine()->getManager()->getConnection(); 

		$cat_id			= $request->get('cat_id');
		$sub_cat_id		= $request->get('sub_cat_id');

		$QURYcatalogPAGE = "SELECT `pages_id` FROM `catalog_designs` WHERE `design_cat_id`='$cat_id' AND `design_subcat_id`='$sub_cat_id'";
		$CONNcatalogPAGE = $connection->executeQuery($QURYcatalogPAGE);
		$FTCHcatalogPAGE = $CONNcatalogPAGE->fetchAll();

		$rslt = $FTCHcatalogPAGE;
		return new JsonResponse($rslt);
	}	
		
		
   /** 
	* @Route("/loadsubcat", name="loadsubcat") 
	*/ 
	public function loadsubcat(Request $request) 
	{ 
	    $var	= $request->get('catID');

		$connection   = $this->getDoctrine()->getManager()->getConnection(); 

		$Qury	= "SELECT * FROM design_subcat WHERE design_cat_id = '".$var."' AND role_status=1 ORDER BY design_subcat_name ASC";
		$stmt	= $connection->executeQuery($Qury);
		$list   = $stmt->fetchAll();
		return  new JsonResponse($list);
	} 

   /** 
	* @Route("/po-loadsubcat", name="po-loadsubcat") 
	*/ 
	public function POloadsubcat(Request $request) 
	{ 
	    $var	= $request->get('desg_cat_id');

		$connection   = $this->getDoctrine()->getManager()->getConnection(); 

		$Qury	= "SELECT * FROM design_subcat WHERE design_cat_id = '".$var."' AND role_status=1 ORDER BY design_subcat_name ASC";
		$stmt	= $connection->executeQuery($Qury);
		$list   = $stmt->fetchAll();
		return  new JsonResponse($list);
	}

   /**
    * @Route("/catalog-designs-add", name="catalog-designs-add")
    */
    public function catalogDesignsADD(Request $request) : Response
    {
        $session = $request->getSession();
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('/index');
        }

		$connection = $this->getDoctrine()->getManager()->getConnection();

		$cat_id 			= $request->get('cat_id');
		$short_name_exp		= $request->get('short_name_exp');
		$sub_cat_id 		= $request->get('sub_cat_id');
		$page_type 			= $request->get('page_type');

		########-[ LIST - CAT DETAILS
		$QURYlistCAT = "SELECT * FROM design_cat WHERE role_status=1 ORDER BY design_cat_name ASC";
		$CONNlistCAT = $connection->executeQuery($QURYlistCAT);
		$FTCHlistCAT = $CONNlistCAT->fetchAll();

		########-[ LIST DESIGN SHORTFORM - DETAILS
		$QURYshrtFORM	= "SELECT `design_gen_cat_id`, CONCAT(`short_form`, ' - ',`expansion`) AS shortForm FROM `design_gen_cat` WHERE `design_cat_id`='".$cat_id."' ORDER BY `short_form` ASC";
		$CONNshrtFORM	= $connection->executeQuery($QURYshrtFORM);
		$FTCHshrtFORM	= $CONNshrtFORM->fetchAll();		

		########-[ LIST - SUBCAT DETAILS
		//$QURYlistSUBCAT = "SELECT * FROM design_subcat WHERE role_status=1 AND design_cat_id='$cat_id' ORDER BY design_subcat_name ASC";
		$QURYlistSUBCAT = "SELECT DISTINCT DSC.`design_subcat_id`, DSC.`design_subcat_name` FROM `design_gen_cat_det` AS DGCD, design_subcat AS DSC WHERE DGCD.`design_gen_cat_id`='".$short_name_exp."' AND DGCD.`design_subcat_id`=DSC.`design_subcat_id` ORDER BY DSC.`design_subcat_name` ASC";
		$CONNlistSUBCAT = $connection->executeQuery($QURYlistSUBCAT);
		$FTCHlistSUBCAT = $CONNlistSUBCAT->fetchAll();		
		
		
		########-[ LIST - PAGES DETAILS
		$QURYlistPAGE = "SELECT P.`pages_id`, P.`page_no` FROM `pages` AS P, `catalog_designs` AS CD WHERE P.`pages_id`=CD.`pages_id` AND `design_cat_id`= '$cat_id' AND `design_subcat_id`='$sub_cat_id' GROUP BY CD.`pages_id`";
		$CONNlistPAGE = $connection->executeQuery($QURYlistPAGE);
		$FTCHlistPAGE = $CONNlistPAGE->fetchAll();	
		
		########-[ GET PAGE NO
		//$QURYmaxPNO		= "SELECT `pages_id`, (`page_no` + 1) AS `page_no` FROM `pages` WHERE `pages_id` = (SELECT MAX(`page_no`) FROM `pages`)";
		$QURYmaxPNO			= "SELECT MAX(`page_no` + 1) AS `page_no` FROM `pages`";
		$CONNmaxPNO			= $connection->executeQuery($QURYmaxPNO);
		$FTCHmaxPNO			= $CONNmaxPNO->fetchAll();

		if($FTCHmaxPNO[0]['page_no'] == ""){
			$FTCHmax_PNO = 1;
		}elseif($FTCHmaxPNO[0]['page_no'] != ""){
			$FTCHmax_PNO = $FTCHmaxPNO[0]['page_no'];
		}

		if($request->getMethod() == 'POST')
		{

			if($page_type == "new"){
				$page_no		= $request->get('new_page_no');
				$pages_id		= "";
				$FTCHslctITEMS 	= ""; 
				$pages_id_cond  = "";
				$prod_id_cond   = "";
			} else if($page_type == "old"){
				$page_no	= "";
				$pages_id	= $request->get('old_page_no');

				$pages_id_cond = "AND CP.`pages_id`='$pages_id'";
				$prod_id_cond  = "AND CP.`products_id` IS NULL";

				#--------[FTCH SELECTED ITEMS
				$QURYslctITEMS = "SELECT
							-- P.`products_id` AS prodID,
							P.`products_id`,
							P.`product_design_no`,
							P.`product_die_no`,
							CP.`cust_prod_id`,
							CP.`products_id` AS CUSTprodID,
							CP.`pages_id`
						FROM
							`products` AS P
						LEFT JOIN `cust_prod` AS CP
						ON
							P.`products_id` = CP.`products_id` AND CP.`cust_id`='$cust_id' AND CP.`pages_id`='$pages_id'
						WHERE
							P.`categories_id`='$cat_id' AND P.`sub_cat_id`='$sub_cat_id' AND P.`sup_sub_cat_id`='$super_sub_cat_id' AND CP.`products_id` IS NOT NULL
						ORDER BY
							CP.`cust_prod_id` ASC";

				$CONNslctITEMS = $connection->executeQuery($QURYslctITEMS);
				$FTCHslctITEMS = $CONNslctITEMS->fetchAll();	
				}

				$catlog_desgn_ids 	= $request->get('catlog_desgn_ids');
				$catlog_desgn_ids   = explode(",",$catlog_desgn_ids);
				$catlog_desgn_cnt 	= count($catlog_desgn_ids);
				$action 			= $request->get('action');
				$sessionId  		= $session->get('empId');
				
				date_default_timezone_set("Asia/Calcutta") ;
				$nowDateTime = date("Y-m-d H:i:s");						

				if($action == "Pin the Designs to Catalogue")	
				{
					if($page_type == "new")
					{
						#--------[INSERT NEW PAGE NO
						$instNEWpage = "INSERT INTO `pages`(`page_no`, `post_by`, `post_dt`) VALUES ('$page_no', '$sessionId', '$nowDateTime')";
						$stmtNEWpage = $connection->executeQuery($instNEWpage);
						$pages_id 	 = $connection->lastInsertId();
					}

					for($i = 0; $i <= $catlog_desgn_cnt-1; $i++)
					{
						$catlog_desgnIds = $catlog_desgn_ids[$i];

						#--------[INSERT CATOLOG DESIGNS PAGE WISE
						$instCUSTPROD	= "INSERT INTO `catalog_designs`(`pages_id`, `design_cat_id`, `design_subcat_id`, `design_gen_cat_id`, `design_id`, `post_by`, `post_dt`) VALUES ('$pages_id','$cat_id','$sub_cat_id','$short_name_exp','$catlog_desgnIds','$sessionId','$nowDateTime')";
						$stmtCUSTPROD	= $connection->executeQuery($instCUSTPROD);
					}

					return $this->redirect('catalog-designs-list');
				}

			/*########[ LIST OF DESIGNS CAT & SUB-CAT WISE ]########*/
			$QURYlistPROD = "SELECT
									D.`design_id` AS desgnID,
									D.design_image_ext_1,
									CONCAT(D.`design_short_form`,'',D.`design_no`) AS design_no,
									CD.`catalog_designs_id`,
									CD.`design_id` AS CATLOGdesgnID,
									CD.`pages_id`
								FROM
									`designs` AS D
								LEFT JOIN `catalog_designs` AS CD
								ON
									D.`design_id` = CD.`design_id`
								WHERE
									D.`design_cat_id` = '$cat_id' AND D.`design_subcat_id` = '$sub_cat_id'
								ORDER BY
									D.`design_no` ASC;";
			$CONNlistPROD = $connection->executeQuery($QURYlistPROD);
			$FTCHlistPROD = $CONNlistPROD->fetchAll();
		}
		else
		{
			$cat_id 			= "";
			$sub_cat_id 		= "";
			$page_type 			= "";
			$page_no			= "";
			$pages_id			= "";

			$FTCHlistPROD 		= "";
			$FTCHlistSUBCAT		= "";
			$FTCHlistSUPsubCAT	= "";
			$FTCHslctITEMS      = "";
		}

        return $this->render('catalog-designs/catalog-designs-add.html.twig', [
			'FTCHlistCAT' => $FTCHlistCAT,
			'FTCHlistSUBCAT' => $FTCHlistSUBCAT,
			'FTCHlistPAGE' => $FTCHlistPAGE,
			'SEARCHrsltPRODlist' => $FTCHlistPROD,
			'cat_id' => $cat_id,
			'short_name_exp' => $short_name_exp,
			'sub_cat_id' => $sub_cat_id,
			'page_type' => $page_type,
			'postedPage_no' => $page_no,
			'pages_id' => $pages_id,
			'maxPAGEno' => $FTCHmax_PNO,
			'shrtFORM' => $FTCHshrtFORM,
			'controller_name' => 'CatalogDesignsPageWiseController'
        ]);
    }



    /**
     * @Route("/catalog-designs-upd{did}", name="catalog-designs-upd")
     */
    public function catalogDesignsUpd(Request $request, $did) : Response	
    {
        $session =$request->getSession();
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('/index');
        }

		$connection = $this->getDoctrine()->getManager()->getConnection();
		$pid		= $_GET['pid'];

		########[ FETCH PAGE DETAILS ]########
		$QURYpageDET = "SELECT DISTINCT DC.design_cat_id, DC.design_cat_name, DGC.design_gen_cat_id, CONCAT(DGC.short_form,' - ', DGC.expansion) AS shortForm, DSC.design_subcat_id, DSC.design_subcat_name, P.page_no, P.pages_id  FROM `pages` AS P, `catalog_designs` AS CD, `design_cat` AS DC, `design_subcat` AS DSC, `design_gen_cat` AS DGC WHERE P.pages_id = '$pid' AND P.pages_id = CD.pages_id AND CD.design_cat_id = DC.design_cat_id AND CD.design_gen_cat_id = DGC.design_gen_cat_id AND CD.design_subcat_id = DSC.design_subcat_id";
		$CONNpageDET = $connection->executeQuery($QURYpageDET);
		$FTCHpageDET = $CONNpageDET->fetchAll();

		$FTCHpageDET['pages_id'] 			= $FTCHpageDET[0]['pages_id'];
		$FTCHpageDET['page_no'] 			= $FTCHpageDET[0]['page_no'];
		$FTCHpageDET['design_cat_id'] 		= $FTCHpageDET[0]['design_cat_id'];
		$FTCHpageDET['design_cat_name'] 	= $FTCHpageDET[0]['design_cat_name'];
		$FTCHpageDET['design_gen_cat_id'] 	= $FTCHpageDET[0]['design_gen_cat_id'];
		$FTCHpageDET['shortForm'] 			= $FTCHpageDET[0]['shortForm'];
		$FTCHpageDET['design_subcat_id'] 	= $FTCHpageDET[0]['design_subcat_id'];
		$FTCHpageDET['design_subcat_name'] 	= $FTCHpageDET[0]['design_subcat_name'];		
		
		if($request->getMethod() == 'POST')
		{
			########-[ DELETE AND INSERT NEW CATALOGUE LIST
			$QURYdlt = "DELETE FROM `catalog_designs` WHERE `pages_id`=".$pid;
			$STMTdlt = $connection->executeQuery($QURYdlt);
			$catlog_desgn_ids 	= $request->get('catlog_desgn_ids');
			$catlog_desgn_ids   = explode(",",$catlog_desgn_ids);
			$catlog_desgn_cnt 	= count($catlog_desgn_ids);
			$action 			= $request->get('action');
			$sessionId  		= $session->get('empId');

			date_default_timezone_set("Asia/Calcutta") ;
			$nowDateTime = date("Y-m-d H:i:s");	

			if($action == "Pin the Designs to Catalogue")	
			{
				for($i = 0; $i <= $catlog_desgn_cnt-1; $i++)
				{
					$catlog_desgnIds = $catlog_desgn_ids[$i];

					#--------[INSERT CATOLOG DESIGNS PAGE WISE
					$instCUSTPROD	= "INSERT INTO `catalog_designs`(`pages_id`, `design_cat_id`, `design_subcat_id`, design_gen_cat_id, `design_id`, `post_by`, `post_dt`) VALUES ('".$FTCHpageDET['pages_id']."','".$FTCHpageDET['design_cat_id']."','".$FTCHpageDET['design_subcat_id']."','".$FTCHpageDET['design_gen_cat_id']."','".$catlog_desgnIds."','$sessionId','$nowDateTime')";
					$stmtCUSTPROD	= $connection->executeQuery($instCUSTPROD);
				}

				return $this->redirect('catalog-designs-list');
			}				
		}
		
		
		########[ LIST OF DESIGNS - CAT & SUB-CAT WISE ]########
		$QURYlistPROD = "SELECT
								D.`design_id` AS desgnID,
								D.`design_no`,
								D.`design_image_ext_1`,
								CD.`catalog_designs_id`,
								CD.`design_id` AS CATLOGdesgnID,
								CD.`pages_id`
							FROM
								`designs` AS D
							LEFT JOIN `catalog_designs` AS CD
							ON
								D.`design_id` = CD.`design_id`
							WHERE
								D.`design_cat_id` = '".$FTCHpageDET['design_cat_id']."' AND D.`design_subcat_id` = '".$FTCHpageDET['design_subcat_id']."'
							ORDER BY
								D.`design_no` ASC";
		$CONNlistPROD = $connection->executeQuery($QURYlistPROD);
		$FTCHlistPROD = $CONNlistPROD->fetchAll();


		/*########[ LIST OF DESIGNS in PARTICULAR PAGE ]########*/
		$QURYpageDESG = "SELECT D.design_id, D.`design_image_ext_1`, D.design_no FROM `catalog_designs` AS CD, designs AS D WHERE CD.`pages_id`=".$FTCHpageDET['pages_id']." AND CD.design_id=D.design_id";
		$CONNpageDESG = $connection->executeQuery($QURYpageDESG);
		$FTCHpageDESG = $CONNpageDESG->fetchAll();
		
		
        return $this->render('catalog-designs/catalog-designs-upd.html.twig', [
			'FTCHpageDET' => $FTCHpageDET,
			'SEARCHrsltPRODlist' => $FTCHlistPROD,	
			'FTCHpageDESG' => $FTCHpageDESG,		
			'controller_name' => 'CatalogDesignsPageWiseController'
        ]);		
	}


    /**
     * @Route("/catalog-pagewise-designs-list{pid}", name="catalog-pagewise-designs-list")
     */
    public function catalogPageWiseDesignsList(Request $request, $pid) : Response	
    {
        $session =$request->getSession();
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('/index');
        }
		
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$pid 		= $_GET['pid'];
		
		#######[ FETCH PAGE DETAILS ]########
		$QURYpageDET = "SELECT CONCAT(DGC.short_form,' - ',DGC.expansion) AS shortFORM, D.design_id, D.design_no, D.design_image_ext_1, P.page_no, DC.design_cat_name, DSC.design_subcat_name FROM catalog_designs AS CD, design_cat AS DC, design_subcat AS DSC, pages AS P, designs AS D, `design_gen_cat` AS DGC WHERE CD.pages_id='$pid' AND CD.pages_id=P.`pages_id` AND CD.design_cat_id=DC.design_cat_id AND CD.design_subcat_id=DSC.design_subcat_id AND CD.design_id=D.design_id AND CD.design_gen_cat_id=DGC.design_gen_cat_id";
		$CONNpageDET = $connection->executeQuery($QURYpageDET);
		$FTCHpageDET = $CONNpageDET->fetchAll();
		$page_no	 = $FTCHpageDET[0]['page_no'];

		
	    return $this->render('catalog-designs/catalog-pagewise-designs-list.html.twig', [
			'FTCHpageDET' => $FTCHpageDET,
			'page_no' => $page_no,
			'controller_name' => 'CatalogDesignsPageWiseController'
        ]);		
	}
}
