<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class AccountsController_new extends AbstractController
{
    /**
     * @Route("/accounts{ac_id}", name="accounts")
     */
    public function goldRATESact(Request $request, $ac_id) 
    {
		$session = $request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		########-[ CASH BLNC
		$QURYcashBL = "SELECT FORMAT((SUM(`amt`) - SUM(`exp_amt`))+OP.`cash_op_blnc`, 2) AS cash_op_blnc FROM `accounts` AS A, `cash_op_blnc` AS OP";
		$CONNcashBL = $connection->executeQuery($QURYcashBL);
		$FTCHcashBL = $CONNcashBL->fetchAll();
		$cashOPblnc = $FTCHcashBL[0]['cash_op_blnc'];
		
		########-[ LIST of INCOME/EXPANSE - DETAILS
		$QURYexpInc = "SELECT * FROM `expanse_cat` WHERE role_status=1 ORDER BY `expanse_cat_name` ASC";
		$CONNexpInc = $connection->executeQuery($QURYexpInc);
		$FTCHexpInc = $CONNexpInc->fetchAll();
		
		########-[ LIST - DETAILS
		$QURYlistDet= "SELECT A.accounts_id, DATE_FORMAT(A.entry_date, '%b %d, %Y') AS entry_date, IF(A.tran_type=1 , 'Income', 'Expanse') AS tran_type, EC.expanse_cat_name, FORMAT(A.amt,2) AS amt, FORMAT(A.exp_amt,2) AS exp_amt FROM `accounts` AS A, `expanse_cat` AS EC WHERE A.expanse_cat_id=EC.expanse_cat_id ORDER BY A.entry_date DESC";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();
		
		########-[ GET UPDATE - DETAILS
		$QURYupdtDet	= "SELECT * FROM `accounts` WHERE `accounts_id`=".$ac_id;
		$CONNupdtDet	= $connection->executeQuery($QURYupdtDet);
		$FTCHupdtDet	= $CONNupdtDet->fetchAll();
		
		$FTCHupdtDet['entry_date'] 		= $FTCHupdtDet[0]['entry_date'];
		$FTCHupdtDet['tran_type'] 		= $FTCHupdtDet[0]['tran_type'];
		$FTCHupdtDet['expanse_cat_id'] 	= $FTCHupdtDet[0]['expanse_cat_id'];
		
		if($FTCHupdtDet['tran_type'] == 1){
			$FTCHupdtDet['amt'] = $FTCHupdtDet[0]['amt'];
		} elseif($FTCHupdtDet['tran_type'] == 2){
			$FTCHupdtDet['amt'] = $FTCHupdtDet[0]['exp_amt'];
		}		
		
		
		if($request->getMethod() == 'POST')
		{
			$entry_date		= $request->get('entry_date');
			$entry_date 	= explode("-", $entry_date);
			$entry_date 	= $entry_date[2]."-".$entry_date[1]."-".$entry_date[0];
			$tran_type		= $request->get('tran_type');
			$expanse_cat_id	= $request->get('expanse_cat_id');
			
			if($tran_type == 1){
				$exp_amt	= "";
				$amt		= $request->get('tran_amt');
			} elseif($tran_type == 2){
				$exp_amt	= $request->get('tran_amt');
				$amt		= "";
			}
			
			
			$sessionId  	= $session->get('empId');
			
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime = date("Y-m-d H:i:s");
			
			if($ac_id == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO `accounts`(`entry_date`, `tran_type`, `expanse_cat_id`, `exp_amt`, `amt`, `post_by`, `post_dt`) VALUES ('$entry_date','$tran_type','$expanse_cat_id','$exp_amt','$amt','$sessionId','$nwDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
			}
			else
			{
				########-[ UPDATE - DETAILS			
				$QRupdate 	= "UPDATE `accounts` SET `entry_date`='$entry_date', `tran_type`='$tran_type', `expanse_cat_id`='$expanse_cat_id', `exp_amt`='$exp_amt', `amt`='$amt', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `accounts_id`=".$ac_id;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}		
		
		return $this->render('accounts/accounts-data.html.twig', [
			'cashOPblnc' => $cashOPblnc,			
			'RSLTopBLNC' => $RSLTopBLNC,
			'FTCHexpInc' => $FTCHexpInc,
			'ftchLISTdata' => $FTCHlistDet,
			'ftchUPDTdata' => $FTCHupdtDet,
			'controller_name' => 'AccountsController'
        ]);
    }
	
    /**
     * @Route("/op-account-blnc{opac_id}", name="op-account-blnc")
     */
    public function opACCOUNTblnc(Request $request, $opac_id) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		########-[ LIST - DETAILS
		$QURYlistDet= "SELECT * FROM `cash_op_blnc`";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();
		
		if($opac_id != 0)
		{
			########-[ GET UPDATE - DETAILS
			$QURYupdtDet	= "SELECT * FROM `cash_op_blnc` WHERE `cash_op_blnc_id`=".$opac_id;
			$CONNupdtDet	= $connection->executeQuery($QURYupdtDet);
			$FTCHupdtDet	= $CONNupdtDet->fetchAll();
			
			$FTCHupdtDet['cash_op_blnc'] = $FTCHupdtDet[0]['cash_op_blnc'];
		}
		else
		{
			$FTCHupdtDet = "";
		}
		
		if($request->getMethod() == 'POST')
		{
			$cash_op_blnc	= $request->get('cash_op_blnc');

			$sessionId  	= $session->get('empId');
			
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime = date("Y-m-d H:i:s");
			
			if($opac_id == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO `cash_op_blnc`(`cash_op_blnc`, `post_by`, `post_dt`) VALUES ('$cash_op_blnc','$sessionId','$nwDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
			}
			else
			{
				########-[ UPDATE - DETAILS			
				$QRupdate 	= "UPDATE `cash_op_blnc` SET `cash_op_blnc`='$cash_op_blnc', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE cash_op_blnc_id=".$opac_id;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}		
		
		return $this->render('accounts/op-account-blnc-data.html.twig', [
			'ftchLISTdata' => $FTCHlistDet,
			'ftchUPDTdata' => $FTCHupdtDet,
			'controller_name' => 'DesignsController'
        ]);
    }	
}
