<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ProdTagging
 *
 * @ORM\Table(name="prod_tagging")
 * @ORM\Entity
 */
class ProdTagging
{
    /**
     * @var int
     *
     * @ORM\Column(name="prod_tag_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $prodTagId;

    /**
     * @var int
     *
     * @ORM\Column(name="prod_tag_rfrnc_id", type="integer", nullable=false)
     */
    private $prodTagRfrncId;

    /**
     * @var string
     *
     * @ORM\Column(name="prod_tag_name", type="string", length=50, nullable=false)
     */
    private $prodTagName;

    /**
     * @var string
     *
     * @ORM\Column(name="role_status", type="string", length=1, nullable=false, options={"default"="'1'","comment"="1 - Active, 0 - In-Active"})
     */
    private $roleStatus = '\'1\'';

    /**
     * @var string
     *
     * @ORM\Column(name="action_type", type="string", length=10, nullable=false, options={"comment"="inst - Insert, edit - Edit, dlt - Delete, role - Role Status"})
     */
    private $actionType;

    /**
     * @var string
     *
     * @ORM\Column(name="active_row", type="string", length=3, nullable=false, options={"comment"="Lat - Latest Row, Old - Old Row"})
     */
    private $activeRow;

    /**
     * @var int
     *
     * @ORM\Column(name="post_by", type="integer", nullable=false)
     */
    private $postBy;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="post_dt", type="datetime", nullable=false)
     */
    private $postDt;

    /**
     * @var int
     *
     * @ORM\Column(name="update_by", type="integer", nullable=false)
     */
    private $updateBy;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="update_dt", type="datetime", nullable=false)
     */
    private $updateDt;

    public function getProdTagId(): ?int
    {
        return $this->prodTagId;
    }

    public function getProdTagRfrncId(): ?int
    {
        return $this->prodTagRfrncId;
    }

    public function setProdTagRfrncId(int $prodTagRfrncId): self
    {
        $this->prodTagRfrncId = $prodTagRfrncId;

        return $this;
    }

    public function getProdTagName(): ?string
    {
        return $this->prodTagName;
    }

    public function setProdTagName(string $prodTagName): self
    {
        $this->prodTagName = $prodTagName;

        return $this;
    }

    public function getRoleStatus(): ?string
    {
        return $this->roleStatus;
    }

    public function setRoleStatus(string $roleStatus): self
    {
        $this->roleStatus = $roleStatus;

        return $this;
    }

    public function getActionType(): ?string
    {
        return $this->actionType;
    }

    public function setActionType(string $actionType): self
    {
        $this->actionType = $actionType;

        return $this;
    }

    public function getActiveRow(): ?string
    {
        return $this->activeRow;
    }

    public function setActiveRow(string $activeRow): self
    {
        $this->activeRow = $activeRow;

        return $this;
    }

    public function getPostBy(): ?int
    {
        return $this->postBy;
    }

    public function setPostBy(int $postBy): self
    {
        $this->postBy = $postBy;

        return $this;
    }

    public function getPostDt(): ?\DateTimeInterface
    {
        return $this->postDt;
    }

    public function setPostDt(\DateTimeInterface $postDt): self
    {
        $this->postDt = $postDt;

        return $this;
    }

    public function getUpdateBy(): ?int
    {
        return $this->updateBy;
    }

    public function setUpdateBy(int $updateBy): self
    {
        $this->updateBy = $updateBy;

        return $this;
    }

    public function getUpdateDt(): ?\DateTimeInterface
    {
        return $this->updateDt;
    }

    public function setUpdateDt(\DateTimeInterface $updateDt): self
    {
        $this->updateDt = $updateDt;

        return $this;
    }


}
