<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class EmployeeController extends AbstractController
{
    /**
     * @Route("/employee-list", name="employee-list")
     */
    public function employeeLISTact(Request $request) 
    {
		$session =$request->getSession();

        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }

		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		
		$emp_id = $request->get('search_emp');
		$department_id = $request->get('department_id');
		$doj = $request->get('search_doj');
		$salary = $request->get('search_salary');
		$where='';

		if($emp_id!=''){
			$where .=' and e.employee_id="'.$emp_id.'"';
		}

		if($department_id!=''){
			$where .=' and D.department_id="'.$department_id.'"';
		}

		if($doj!=''){
			$where .=' and e.doj="'.$doj.'"';
		}
		
		if($salary!=''){
		  $sal_exp = explode("-",$salary);
		  $sal_count = count($sal_exp);

		  if($sal_count=='1'){
			  $where .=" and e.salary ".$sal_exp['0']."";
		  } else {
			  $where .=" and e.salary between ".$sal_exp['0']." and ".$sal_exp['1']."";
			}
		}

		########-[ GET EMPLOYEE LIST
		 $QURYlist	= "SELECT E.*, D.department_name,  D.department_id,De.designation_name FROM `employee` AS E,  department AS D,designation AS De   WHERE E.dept=D.department_id and E.designation=De.designation_id ".$where."  ORDER BY E.eid DESC";

		$CONNlist	= $connection->executeQuery($QURYlist);
		$FTCHlist	= $CONNlist->fetchAll();

		$QURYdept	= "SELECT `department_id`, `department_name` FROM `department` WHERE `status`=1 ORDER BY `department_name` ASC";
		$CONNdept	= $connection->executeQuery($QURYdept);
		$FTCHdept	= $CONNdept->fetchAll();

		return $this->render('employee/employee-list.html.twig', [
			'EMPlist' => $FTCHlist,
			'deptLIST' => $FTCHdept,
			'empl_id'=>$emp_id,
			'doj_val'=>$doj,
			'department_id'=>$department_id,
			'emp_salary'=>$salary,			
			'controller_name' => 'EmployeeController'
        ]);
    }

 /**
     * @Route("/employee-img-list", name="employee-img-list")
     */
    public function employeeLISTImgact(Request $request) 
    {
		$session =$request->getSession();

        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }

		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		
		$emp_id = $request->get('search_emp');
		$department_id = $request->get('department_id');
		$doj = $request->get('search_doj');
		$salary = $request->get('search_salary');
		$where='';

		if($emp_id!=''){
			$where .=' and e.employee_id="'.$emp_id.'"';
		}

		if($department_id!=''){
			$where .=' and D.department_id="'.$department_id.'"';
		}

		if($doj!=''){
			$where .=' and e.doj="'.$doj.'"';
		}
		
		if($salary!=''){
		  $sal_exp = explode("-",$salary);
		  $sal_count = count($sal_exp);

		  if($sal_count=='1'){
			  $where .=" and e.salary ".$sal_exp['0']."";
		  } else {
			  $where .=" and e.salary between ".$sal_exp['0']." and ".$sal_exp['1']."";
			}
		}

		########-[ GET EMPLOYEE LIST
		 $QURYlist	= "SELECT E.*, D.department_name,  D.department_id,De.designation_name FROM `employee` AS E,  department AS D,designation AS De   WHERE E.dept=D.department_id and E.designation=De.designation_id ".$where."  ORDER BY E.eid DESC";

		$CONNlist	= $connection->executeQuery($QURYlist);
		$FTCHlist	= $CONNlist->fetchAll();

		$QURYdept	= "SELECT `department_id`, `department_name` FROM `department` WHERE `status`=1 ORDER BY `department_name` ASC";
		$CONNdept	= $connection->executeQuery($QURYdept);
		$FTCHdept	= $CONNdept->fetchAll();

		return $this->render('employee/employee-img-list.html.twig', [
			'EMPlist' => $FTCHlist,
			'deptLIST' => $FTCHdept,
			'empl_id'=>$emp_id,
			'doj_val'=>$doj,
			'department_id'=>$department_id,
			'emp_salary'=>$salary,			
			'controller_name' => 'EmployeeController'
        ]);
    }


    /**
     * @Route("/employee-reg", name="employee-reg")
     */
    public function employeeREGact(Request $request) 
    {
		$session =$request->getSession();

        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }

		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		########-[ GET PID
		$QURYmaxEID			= "SELECT MAX(`eid`) AS e_id FROM `employee`";
		$CONNmaxEID			= $connection->executeQuery($QURYmaxEID);
		$FTCHmaxEID			= $CONNmaxEID->fetchAll();
		$FTCHmaxEID['e_id'] = $FTCHmaxEID[0]['e_id'];

		########-[ GET DEPT
		//$QURYdept	= "SELECT * FROM `dept` ORDER BY `dept_name` ASC";
		$QURYdept	= "SELECT `department_id`, `department_name` FROM `department` WHERE `status`=1 ORDER BY `department_name` ASC";
		$CONNdept	= $connection->executeQuery($QURYdept);
		$FTCHdept	= $CONNdept->fetchAll();

		########-[ GET ROLES
		$QURYroles	= "SELECT * FROM `roles` ORDER BY `roles_name` ASC";
		$CONNroles	= $connection->executeQuery($QURYroles);
		$FTCHroles	= $CONNroles->fetchAll();
		$edu_arr = implode(",",$request->get('edu_level'));

		if($request->getMethod() == 'POST')
		{
			$eid				= $request->get('eid');
			$metal_blnc			= $request->get('metal_blnc');
			$emp_dept			= $request->get('department_id');
			$emp_desg			= $request->get('emp_desg');
			$emp_dob			= $request->get('emp_dob');
			$emp_doj			= $request->get('emp_doj');
			$emp_gender			= $request->get('rad_gender');
			//$emp_roles		= $request->get('emp_roles');	// HIDDEN FIELD
			$emp_roles			= 1;
			$emp_name			= $request->get('emp_name');
			$emp_father_name	= $request->get('emp_father_name');
			$emp_aadhar_no		= $request->get('emp_aadhar_no');
			$emp_pan_no			= $request->get('emp_pan_no');
			$rfrnc_persn		= $request->get('rfrnc_person');
			$rfrnc_mbl			= $request->get('rfrnc_mbl');
			$emp_mbl1			= $request->get('emp_mbl1');
			$emp_mbl2			= $request->get('emp_mbl2');
			$emp_email1			= $request->get('emp_email1');
			$emp_email2			= $request->get('emp_email2');
			$perm_door_no		= $request->get('perm_door_no');
			$perm_street1		= $request->get('perm_street1');
			$perm_street2		= $request->get('perm_street2');
			$perm_city			= $request->get('perm_city');
			$perm_state			= $request->get('perm_state');
			$local_door_no		= $request->get('local_door_no');
			$local_street1		= $request->get('local_street1');
			$local_street2		= $request->get('local_street2');
			$local_city			= $request->get('local_city');
			$local_state		= $request->get('local_state');
			$emp_salary			= $request->get('emp_salary');
			
			

			$sessionId  = $session->get('empId');

			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime = date("Y-m-d H:i:s");

			#--------[IMAGE 1 UPLOAD
			if($_FILES['upload_image_1']['name'] !=""){
				$upload_image_1	= $_FILES['upload_image_1']['name']; 
				$getprdExtn1	= $_FILES['upload_image_1']['type'];
				$getprdExtn2	= explode("/", $getprdExtn1);
				$prod_extn1		= $getprdExtn2[1];
				//$prod_name	= $design_id_img_name;
				$prod_name		= $eid."aadhar";
				$file_name1		= $prod_name.".".$prod_extn1;
				move_uploaded_file($_FILES["upload_image_1"]["tmp_name"], "emp_docs_photos/" . $file_name1);
			}else{
				$upload_image_1 = "";
			}

			#--------[IMAGE 2 UPLOAD
			if($_FILES['upload_image_2']['name'] !=""){
				$upload_image_2 = $_FILES['upload_image_2']['name']; 
				$getprdExtn1_med= $_FILES['upload_image_2']['type'];
				$getprdExtn2_med= explode("/", $getprdExtn1_med);
				$prod_extn1_med	= $getprdExtn2_med[1];
				//$prod_name	= $design_id_img_name;
				$prod_name_med= $eid."photo";
				$file_name1_med	= $prod_name_med.".".$prod_extn1_med;
				move_uploaded_file($_FILES["upload_image_2"]["tmp_name"], "emp_docs_photos/" . $file_name1_med);
			}else{
				$upload_image_2 = "";
			}

			#--------[IMAGE 3 UPLOAD
			if($_FILES['upload_image_3']['name'] !=""){
				$upload_image_3 = $_FILES['upload_image_3']['name']; 
				$getprdExtn1_sml= $_FILES['upload_image_3']['type'];
				$getprdExtn2_sml= explode("/", $getprdExtn1_sml);
				$prod_extn1_sml	= $getprdExtn2_sml[1];
				//$prod_name	= $design_id_img_name;
				$prod_name_sml	= $eid."other_id";
				$file_name1_sml	= $prod_name_sml.".".$prod_extn1_sml;
				move_uploaded_file($_FILES["upload_image_3"]["tmp_name"], "emp_docs_photos/" . $file_name1_sml);
			}else{
				$upload_image_3 = "";
			}

			########-[ INSERT - DETAILS
			$QRinsert = "INSERT INTO `employee`(`eid`, `gender`,`metal_blnc`, `dept`, `designation`,`roles`, `emp_name`,`dob`, `doj`,`salary`,`emp_father_name`, `aadhar_no`, `pan_no`, `rfrnc_person`, `rfrnc_mbl`, `aadhar_extn`, `photo_extn`, `other_id_extn`, `mbl1`, `mbl2`, `email1`, `email2`, `perm_door_no`, `perm_street1`, `perm_street2`, `perm_city`, `perm_state`, `local_door_no`, `local_street1`, `local_street2`, `local_city`, `local_state`,`edu_level`, `post_by`, `post_dt`) VALUES ('$eid','$emp_gender','$metal_blnc','$emp_dept','$emp_desg','$emp_roles','$emp_name','$emp_dob','$emp_doj','$emp_salary','$emp_father_name','$emp_aadhar_no','$emp_pan_no','$rfrnc_persn','$rfrnc_mbl','$prod_extn1','$prod_extn1_med','$prod_extn1_sml','$emp_mbl1','$emp_mbl2','$emp_email1','$emp_email2','$perm_door_no','$perm_street1','$perm_street2','$perm_city','$perm_state','$local_door_no','$local_street1','$local_street2','$local_city','$local_state','$edu_arr','$sessionId','$nwDateTime')";
			$CNexecut = $connection->executeQuery($QRinsert);

			########-[ GET INSERT ID
			$QURYfinalINSRTID	= "SELECT MAX(`employee_id`) AS employee_id FROM `employee`";
			$CONNfinalINSRTID	= $connection->executeQuery($QURYfinalINSRTID);
			$FTCHfinalINSRTID	= $CONNfinalINSRTID->fetchAll();
			$LASTinstEMPID		= $FTCHfinalINSRTID[0]['employee_id'];

		

			return $this->redirectToRoute('employee-list');
		}
		return $this->render('employee/employee-reg.html.twig', [
			'maxEID' => $FTCHmaxEID,
			'deptLIST' => $FTCHdept,
			'rolesLIST' => $FTCHroles,
			'controller_name' => 'EmployeeController'
        ]);
    }

    /**
     * @Route("/employee-reg-updt{emp_updt_id}", name="employee-reg-updt")
     */
    public function employeeREGupdtACT(Request $request, $emp_updt_id) 
    {
		$session =$request->getSession();

        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }

		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		########-[ GET EMP DATAs
		$QURYempDATAs	= "SELECT * FROM `employee` WHERE employee_id = '".$emp_updt_id."'";
		$CONNempDATAs	= $connection->executeQuery($QURYempDATAs);
		$FTCHempDATAs	= $CONNempDATAs->fetchAll();

		########-[ GET EMP SALARY DATAs
		$QURYempSAL	= "SELECT * FROM `employee_salary` WHERE employee_id = '".$emp_updt_id."'";
		$CONNempSAL	= $connection->executeQuery($QURYempSAL);
		$FTCHempSAL	= $CONNempSAL->fetchAll();

		$CONTempINC	= count($FTCHempSAL);		

		########-[ GET DEPT
		//$QURYdept	= "SELECT * FROM `dept` ORDER BY `dept_name` ASC";
		$QURYdept	= "SELECT `department_id`, `department_name` FROM `department` WHERE `status`=1  ORDER BY `department_name` ASC";
		$CONNdept	= $connection->executeQuery($QURYdept);
		$FTCHdept	= $CONNdept->fetchAll();

		########-[ GET ROLES
		$QURYroles	= "SELECT * FROM `roles` ORDER BY `roles_name` ASC";
		$CONNroles	= $connection->executeQuery($QURYroles);
		$FTCHroles	= $CONNroles->fetchAll();
		

		if($request->getMethod() == 'POST')
		{
			$eid				= $request->get('eid');
			//$metal_blnc			= $request->get('metal_blnc');
			$emp_dept			= $request->get('department_id');
			$emp_desg			= $request->get('emp_des');
			$emp_gender			= $request->get('rad_gender');
			//$emp_roles			= $request->get('emp_roles');
			$emp_name			= $request->get('emp_name');
			$emp_dob 			= $request->get('emp_dob');
			$emp_doj			= $request->get('emp_doj');
			$emp_father_name	= $request->get('emp_father_name');
			$emp_aadhar_no		= $request->get('emp_aadhar_no');
			$emp_pan_no			= $request->get('emp_pan_no');
			$rfrnc_persn		= $request->get('rfrnc_person');
			$rfrnc_mbl			= $request->get('rfrnc_mbl');
			$emp_mbl1			= $request->get('emp_mbl1');
			$emp_mbl2			= $request->get('emp_mbl2');
			$emp_email1			= $request->get('emp_email1');
			$emp_email2			= $request->get('emp_email2');
			$perm_door_no		= $request->get('perm_door_no');
			$perm_street1		= $request->get('perm_street1');
			$perm_street2		= $request->get('perm_street2');
			$perm_city			= $request->get('perm_city');
			$perm_state			= $request->get('perm_state');
			$local_door_no		= $request->get('local_door_no');
			$local_street1		= $request->get('local_street1');
			$local_street2		= $request->get('local_street2');
			$local_city			= $request->get('local_city');
			$local_state		= $request->get('local_state');
			$edu_arr 			= implode(",",$request->get('edu_level'));
			$emp_salary         = $request->get('emp_salary');

			$sessionId  = $session->get('empId');
			

			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime = date("Y-m-d H:i:s");

			#--------[UPDATE DESIGN - LARGE
			if($_FILES['upload_image_1']['name'] !=""){
				$prod_img1 	= $_FILES['upload_image_1']['name']; 
				$getprdExtn1= $_FILES['upload_image_1']['type'];
				$getprdExtn2= explode("/", $getprdExtn1);

				if($FTCHempDATAs[0]['aadhar_extn'] != ""){
					$prod_extn1	= $FTCHempDATAs[0]['aadhar_extn'];
				} else if($FTCHempDATAs[0]['aadhar_extn'] == ""){
					$prod_extn1	= $getprdExtn2[1];
				}

				//$prod_name	= $FTCHempDATAs[0]['design_id'];
				$prod_name	= $eid."aadhar";
				$prodImgExtn= $FTCHempDATAs[0]['aadhar_extn'];
				$file_name1	= $prod_name.".".$prod_extn1;

				if($prodImgExtn != ""){
					unlink("emp_docs_photos/" . $file_name1);
				}

				move_uploaded_file($_FILES["upload_image_1"]["tmp_name"], "emp_docs_photos/" . $file_name1);
			}else{
				$prod_extn1 = $FTCHempDATAs[0]['aadhar_extn'];
			}

			#--------[UPDATE DESIGN - MEDIUM
			if($_FILES['upload_image_2']['name'] !=""){
				$prod_img1_med 	= $_FILES['upload_image_2']['name']; 
				$getprdExtn1_med= $_FILES['upload_image_2']['type'];
				$getprdExtn2_med= explode("/", $getprdExtn1_med);

				if($FTCHempDATAs[0]['photo_extn'] != ""){
					$prod_extn1_med	= $FTCHempDATAs[0]['photo_extn'];
				} else if($FTCHempDATAs[0]['photo_extn'] == ""){
					$prod_extn1_med	= $getprdExtn2_med[1];
				}

				//$prod_name	= $FTCHempDATAs[0]['design_id'];
				$prod_name_med	= $eid."photo";
				$prodImgExtn_med= $FTCHempDATAs[0]['upload_image_2'];
				$file_name1_med	= $prod_name_med.".".$prod_extn1_med;

				if($prodImgExtn_med != ""){
					unlink("emp_docs_photos/" . $file_name1_med);
				}

				move_uploaded_file($_FILES["upload_image_2"]["tmp_name"], "emp_docs_photos/" . $file_name1_med);
			}else{
				$prod_extn1_med = $FTCHempDATAs[0]['photo_extn'];
			}
			
			#--------[UPDATE DESIGN - SMALL
			if($_FILES['upload_image_3']['name'] !=""){
				$prod_img1_sml 	= $_FILES['upload_image_3']['name']; 
				$getprdExtn1_sml= $_FILES['upload_image_3']['type'];
				$getprdExtn2_sml= explode("/", $getprdExtn1_sml);

				if($FTCHempDATAs[0]['other_id_extn'] != ""){
					$prod_extn1_sml	= $FTCHempDATAs[0]['other_id_extn'];
				} else if($FTCHempDATAs[0]['other_id_extn'] == ""){
					$prod_extn1_sml	= $getprdExtn2_sml[1];
				}

				//$prod_name	= $FTCHempDATAs[0]['design_id'];
				$prod_name_sml	= $eid."other_id";
				$prodImgExtn_sml= $FTCHempDATAs[0]['other_id_extn'];
				$file_name1_sml	= $prod_name_sml.".".$prod_extn1_sml;

				if($prodImgExtn_sml != ""){
					unlink("emp_docs_photos/" . $file_name1_sml);
				}

				move_uploaded_file($_FILES["upload_image_3"]["tmp_name"], "emp_docs_photos/" . $file_name1_sml);
			}else{
				$prod_extn1_sml = $FTCHempDATAs[0]['other_id_extn'];
			}

			#--------[UPDATE DESIGN
			$quryEMPupdt	= "UPDATE `employee` SET gender='$emp_gender', `dept`='$emp_dept', `designation`='$emp_desg', `emp_name`='$emp_name',`dob`='$emp_dob',`doj`='$emp_doj',`salary`='$emp_salary', `emp_father_name`='$emp_father_name', `aadhar_no`='$emp_aadhar_no', `pan_no`='$emp_pan_no', `rfrnc_person`='$rfrnc_persn', `rfrnc_mbl`='$rfrnc_mbl', `aadhar_extn`='$prod_extn1', `photo_extn`='$prod_extn1_med', `other_id_extn`='$prod_extn1_sml', `mbl1`='$emp_mbl1', `mbl2`='$emp_mbl2', `email1`='$emp_email1', `email2`='$emp_email2', `perm_door_no`='$perm_door_no', `perm_street1`='$perm_street1', `perm_street2`='$perm_street2', `perm_city`='$perm_city', `perm_state`='$perm_state', `local_door_no`='$local_door_no', `local_street1`='$local_street1', `local_street2`='$local_street2', `local_city`='$local_city', `local_state`='$local_state', `edu_level`='$edu_arr',`update_by`='$sessionId',`update_dt`='$nwDateTime' WHERE `employee_id`='".$emp_updt_id."'";
			$stmtEMPupdt  = $connection->executeQuery($quryEMPupdt);

			#--------[UPDATE SAL DETAILS - ALREADY ADDED
			$noOFinc = $request->get('incre_date');
			echo 
			$noOFinc = count($noOFinc) - 1;

			for($i=0; $i<=$noOFinc; $i++)
			{
				$incre_dat 		= explode( "-" , $request->get('incre_date')[$i]);
				$incre_dat 		= $incre_dat[2]."-".$incre_dat[1]."-".$incre_dat[0];
				$incre_amt 		= $request->get('incre_amtt')[$i];
				$incre_cmt 		= $request->get('incre_cmt')[$i];
				$emp_salary_id	= $request->get('employee_salary_id')[$i];

				//if($stoneQty > 0)
				//{

				$QRupdtSTDT = "UPDATE `employee_salary` SET `sal_incre_date`='$incre_dat', `sal_incre_amt`='$incre_amt', `comments`='$incre_cmt', `update_by`='$sessionId',`update_dt`='$nwDateTime' WHERE `employee_salary_id`='$emp_salary_id'";
				$CNupdtSTDT = $connection->executeQuery($QRupdtSTDT);
				//}
			}
//			die();
			#--------[UPDATE STONE DETAILS - ADD NEW STONES		
			if($CONTempINC < $noOFinc)
			{	
				for($j=$CONTempINC; $j<=$noOFinc; $j++)
				{
					$incre_typ		= $_POST['sal_incre_type'][$j];
					$incre_dat 		= explode( "-" , $request->get('incre_date')[$j]);
					$incre_dat 		= $incre_dat[2]."-".$incre_dat[1]."-".$incre_dat[0];
					$incre_amt 		= $_POST['incre_amtt'][$j];
					$incre_cmt 		= $_POST['incre_cmt'][$j];

					$QRinstSTONEdt = "INSERT INTO `employee_salary`(`employee_id`, `sal_inc_type`, `sal_incre_date`, `sal_incre_amt`, `comments`, `post_by`, `post_dt`) VALUES ('$emp_updt_id', '$incre_typ.$j', '$incre_dat', '$incre_amt', '$incre_cmt', '$sessionId', '$nwDateTime')";
					$CNinstSTONEdt = $connection->executeQuery($QRinstSTONEdt);
				}
			}
//			die();
			return $this->redirectToRoute('employee-list');
		}

		return $this->render('employee/employee-reg-updt.html.twig', [
			'empDATAs' => $FTCHempDATAs,
			'deptLIST' => $FTCHdept,
			//'rolesLIST' => $FTCHroles,
			'empSAL' => $FTCHempSAL,
			'controller_name' => 'EmployeeController'
        ]);
    }

    /**
     * @Route("/employee-dlt{employee_dlt_id}", name="employee-dlt")
     */
    public function employeeDLTact(Request $request, $employee_dlt_id) 
    {
		$session =$request->getSession();

        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }

		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 	

		########-[ DELETE - DETAILS
		$QRdltemployee = "DELETE FROM `employee` WHERE `employee_id`=".$employee_dlt_id;
		$CNdltemployee = $connection->executeQuery($QRdltemployee);

		return $this->redirectToRoute('employee-list');
	}
}
