<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;
use Symfony\Component\HttpFoundation\RedirectResponse;

class DesignationController extends AbstractController
{

    /**
     * @Route("/designation{stID}", name="designation")
     */
    public function designationListActions(Request $request, $stID) 
    {
		$session =$request->getSession();

        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }

		error_reporting(0);
	  $connection = $this->getDoctrine()->getManager()->getConnection();

		date_default_timezone_set("Asia/Kolkata");
		$current_dt = date("Y-m-d");

		########-[ QUICK VARIABLES
		$tableName	= "designation";
		$tablePrmID	= "designation_id";
		$getVARIid	= $stID;

		########-[ LIST of STONES - DETAILS
		$QURYlistDet= "SELECT a.*,b.department_name FROM ".$tableName." a, department b WHERE b.department_id=a.department_id ORDER BY ".$tablePrmID." DESC";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();

		$QURYdept	= "SELECT `department_id`, `department_name` FROM `department` WHERE `status`=1 ORDER BY `department_name` ASC";
		$CONNdept	= $connection->executeQuery($QURYdept);
		$FTCHdept	= $CONNdept->fetchAll();

		if($getVARIid != 0)
		{
			########-[ GET UPDATE - DETAILS
			$QURYupdtDet	= "SELECT * FROM ".$tableName." WHERE ".$tablePrmID."=".$getVARIid;
			$CONNupdtDet	= $connection->executeQuery($QURYupdtDet);
			$FTCHupdtDet	= $CONNupdtDet->fetchAll();

			$FTCHupdtDet['department_id'] = $FTCHupdtDet[0]['department_id'];
			$FTCHupdtDet['designation_name'] = $FTCHupdtDet[0]['designation_name'];
			$FTCHupdtDet['status'] = $FTCHupdtDet[0]['status'];
		}
		else
		{
			$FTCHupdtDet['department_id']  = "";
			$FTCHupdtDet['designation_name'] = "";
			$FTCHupdtDet['status'] = "";
		}

		if($request->getMethod() == 'POST')
		{
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime  = date("Y-m-d H:i:s");

			$department_id = $request->get('department_id');
			$designation_name  = $request->get('designation_name');
			$status   = $request->get('status');
			$sessionId    = $session->get('empId');

			if($getVARIid == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO ".$tableName."(`department_id`,`designation_name`, `status`, `post_by`, `post_dt`) VALUES ('$department_id','$designation_name', '$status', '$sessionId', '$nwDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
			}
			else
			{
				########-[ UPDATE - DETAILS
				$QRupdate 	= "UPDATE ".$tableName." SET `department_id`='$department_id', `designation_name`='$designation_name', `status`='$status', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE ".$tablePrmID."=".$getVARIid;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}

		return $this->render('designation/designation-data.html.twig', [
			'FTCHlistDet' => $FTCHlistDet,
			'FTCHupdtDet' => $FTCHupdtDet,
			'dept_list' => $FTCHdept,
			'controller_name' => 'DesignationController'
        ]);
    }
}
