<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;
use Symfony\Component\HttpFoundation\RedirectResponse;

class DesignSelectionController extends AbstractController
{
   /**
     * @Route("/DesignSelection/{cat}/{cad}/{sp}/{sub}/{wrange}/{stone}/{selcat}/{selcad}/{selsp}", name="DesignSelection")
     */
	 public function DesignListActions(Request $request){
		$session 	= $request->getSession();
		$connection = $this->getDoctrine()->getManager()->getConnection();
		if($session->get('admin_id')=='')
        {
        	return $this->redirectToRoute('index');
        }

		$sessionId  = $session->get('empId');
		$session_user = $session->get('admin_id');
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime= date("Y-m-d H:i:s");
		$tableName	= "design_det";
		$tablePrmID	= "design_det_id";
		$str_limit=0;

		$cat = base64_decode($request->get('cat'));
		$cad = base64_decode($request->get('cad'));
		$sp =  base64_decode($request->get('sp'));
		$sub = $request->get('sub');
		$wrange = $request->get('wrange');
		$srange = $request->get('stone');
		$selcat = base64_decode($request->get('selcat'));
		$selcad = base64_decode($request->get('selcad'));
		$selsp = base64_decode($request->get('selsp'));
		//echo "===".$selcat."====".$selcad."=====".$selsp;
		//get sub cat id
		if($sub !='0'){
		   $QURYlistSub="SELECT * FROM `master_sub_category` WHERE sub_category_name='".$sub."'";
			$CONNlistSub= $connection->executeQuery($QURYlistSub);
			$FTCHlistSub= $CONNlistSub->fetchAll();
			$sub_name = $FTCHlistSub[0]['master_sub_category_id'];
		} else {
			$sub_name='0';
		}
		//get cad

	    $QURYlistCad="select master_cad_type_id from master_cad_type where type_name='".$cad."'";

		$CONNlistCad= $connection->executeQuery($QURYlistCad);
		$FTCHlistCad= $CONNlistCad->fetchAll();
		$cad_name = $FTCHlistCad[0]['master_cad_type_id'];

		//get cat

	   $QURYlistCat="select master_cat_id from master_cat where cat_name='".$cat."' and master_cad_type_id='".$cad_name."' and category='".$sp."' group by cat_name";

		$CONNlistCat= $connection->executeQuery($QURYlistCat);
		$FTCHlistCat= $CONNlistCat->fetchAll();
		$cat_name = $FTCHlistCat[0]['master_cat_id'];
		if($request->get('start')!=''){
			$str_limit = $request->get('start');
		}

		if($request->get('start')!=''){
			$str_limit = $request->get('start');
		}

		$QURYlistDet = "SELECT a.*,b.*,c.*,d.* FROM design_det a INNER JOIN show_case b ON a.design_det_id = b.design_det_id INNER JOIN mas_finishing c ON c.design_det_id = a.design_det_id INNER JOIN master_cat d ON d.master_cat_id = a.master_cat_id AND a.statu_s='active' AND b.up_status='no' AND a.up_status='no' AND c.up_status='no' AND c.design_det_id = b.design_det_id and d.master_cad_type_id='1' and d.category='stone' and d.master_cat_id='2' ORDER BY b.show_case_id DESC limit ".$str_limit.",9";

		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();
		$product_cnt = count($FTCHlistDet);
		$html='';
		//$html .= "=====".$QURYlistDet;
		$no_rec =0;
		//$html .= '<div class="">';

		foreach($FTCHlistDet as $value){
			$des_img_url = 'https://thahaayaa.com/mas_fin_images/';
			$cad_img_url = 'https://thahaayaa.com/cad_fin_images/';
			$mas_img_url = 'https://thahaayaa.com/design_images/';
			$mas_fin_ext = $value['mas_fin_ext'];
			$cad_fin_ext = $value['cad_fin_ext'];
			$imag_ext 	 = $value['imag_ext'];

			if($mas_fin_ext!=''){ $imag = $des_img_url."S.".$mas_fin_ext; $imag1 = $des_img_url."L.".$mas_fin_ext; }

			else if($cad_fin_ext!=''){ $imag = $cad_img_url."S.".$cad_fin_ext;  $imag1 = $cad_img_url."L.".$cad_fin_ext;}

			else if($imag_ext!=''){ $imag = $mas_img_url."S.".$imag_ext; $imag1 = $mas_img_url."L.".$imag_ext; }

			$QURYlistWgt = "SELECT design_height,design_width FROM emp_current_design WHERE design_det_id='".$value['design_det_id']."'";

		$CONNlistWgt= $connection->executeQuery($QURYlistWgt);
		$FTCHlistWgt= $CONNlistWgt->fetchAll();
		$des_count = count($FTCHlistWgt);
		$design_height='';
		$design_width='';

		if($des_count>0){
			$design_height =$FTCHlistWgt['0']['design_height'];
			$design_width  =$FTCHlistWgt['0']['design_width'];
		} 

			if($design_height==''){
				$design_height = '--';
			} else {
				$design_height = str_replace(","," / ",$design_height);
			}
			if($design_width=='') {
				$design_width = '--';
			} else {
				$design_width = str_replace(","," / ",$design_width);
			}

		$pop_table ='<table  class=tbl1 style=margin-left:43%><tr><td colspan=4>'.$value['master_cat_name']." ".str_pad($value['design_no'],4,"0",STR_PAD_LEFT).'</td></tr><tr><td>Gold<br>Weight</td><td>Design<br> Height</td><td>Design<br>Width</td><td>Stone <br>Percentage</td></tr>
		<tr><td>'.$value['mas_weight'].'&nbsp;g</td><td>'.$design_width.'</td><td>'.$design_height.'</td><td>0.00%</td></tr>
		</table>';

		$QURYcDet = "SELECT * FROM login_details as l,ac_party_det as a WHERE  a.party_det_id = l.party_det_id AND l.admin_id='".$session_user."'";

		    $CONNcDet= $connection->executeQuery($QURYcDet);
		    $FTCHcDet= $CONNcDet->fetchAll();

			if(count($FTCHcDet)>0){
				$getPartyId = $FTCHcDet['0']['party_det_id'];
			} else {
				$getPartyId =0;
			}
			$add_html = '';
			 $sel_cart = "select * from des_sel_temp_des where design_det_id='".$value['design_det_id']."' and  party_det_id='".$getPartyId."'";

				$CONNcDet111= $connection->executeQuery($sel_cart);
				$FTCHcDetcart= $CONNcDet111->fetchAll();
				if(count($FTCHcDetcart)==0){
					$add_html = '<a style="color:#fff; font-size:100%;" href="javascript:;" onclick="click_add(\''.$value['design_no'].'\',\''.$value['design_det_id'].'\',\''.$value['master_cat_id'].'\');">Add</a>';
				} else {
					$add_html = 'ADDED';
				}

		$html .='<div class="col-xl-3 col-md-6 container1">
		<div class="card">
			<div class="card-block" style="height:230px;">
				<img src="'.$imag1.'" width="100%" style="border:1px solid #C8C9C9;">
			</div>
			<div class="card-footer">
				<div class="row align-items-center">
					<div class="col-9">
						<p class="text-black m-b-0"><b>'.$value['master_cat_name']." ".str_pad($value['design_no'],4,"0",STR_PAD_LEFT).' <br> <small>'.number_format($value['mas_weight'],2).'&nbsp;grms</small></b></p>
					</div>
					<div class="col-3 text-right">
						<span id="cart'.$value['design_no'].'"><label class="label label-danger" >'.$add_html.'</label></span>
					</div>
				</div>
			</div>
		</div><div class="overlay">
    <div class="text"> <a title="View" href="'.$imag1.'" data-fancybox="images" data-caption="'.$pop_table.'">
    <i class="fa fa-search" style="
    top: 50%;position: absolute;margin-top: 0px; color:#fff; margin-left:45%;"></i>
  </a>
	<table align="center" style="width:85%;font-size:12px; border-color:#fff; color:#000; margin:15px;" border="0" class="tbl" cellpadding="0" cellspacing="0"><tbody><tr><td colspan="2" align="center" style="padding:2px;"><strong>Height</strong></td><td colspan="2" align="center" style="padding:2px;">'.$design_height.'&nbsp;mm</td></tr><tr><td colspan="2" align="center" style="padding:2px;"><strong>Width</strong></td><td colspan="2" align="center" style="padding:2px;">'.$design_width.'&nbsp;mm</td></tr>';

	if($value['category']!='Plain'){
	$html.='<tr><td align="center" style="padding:2px;width:25% "><strong>Stone<br>Shape</strong></td><td align="center" style="padding:2px;width:25% "><strong>Stone<br>Size </strong></td><td align="center" style="padding:2px;width:23% "><strong>Stone<br>Quantity</strong></td><td align="center" style="padding:2px;width:27% "><strong>Total<br>Weight</strong></td></tr>';

	$QURYEmpdes = "SELECT * FROM emp_current_design_stone WHERE design_det_id='".$value['design_det_id']."'";
	$CONNEmpdes= $connection->executeQuery($QURYEmpdes);
	$FTCHEmpdes= $CONNEmpdes->fetchAll();
	$totl_qty = 0;
	$totl_wigh = 0;
	$tot_e = count($FTCHEmpdes);
	if($tot_e>0){
	foreach($FTCHEmpdes as $value2){

		$mas_stone_type_id  = $value2['mas_stone_type_id'];
		$stone_weight       = $value2['stone_weight'];
		$quantity           = $value2['quantity'];
		$total_weight       = $value2['total_weight'];

	$ctname = $this->getstone($value2['mas_stone_cat_id']);
	$stonename = $this->getstonename($value2['mas_stone_type_id']);
	$html .= '<tr><td align="center">'.$ctname.'</td><td align="center">'.$stonename.'</td><td align="center">'.$value2['quantity'].'</td><td align="center">'.number_format($value2['total_weight'],2).' g</td></tr>';
			$totl_qty = $totl_qty +	$quantity;
			$totl_wigh = $totl_wigh +	$total_weight;
	}
	}
	$html .= '<tr style="margin-top: black solid 1px"><td align="center" colspan="2"><b>Total</b></td><td align="center"><b>'.$totl_qty.'&nbsp;no\'s</b></td><td align="center"><b>'.number_format($totl_wigh,2).' g</b></td></tr><tr><td align="center" colspan="2"><b>Stone %</b></td><td align="center" colspan="2"><b>'.number_format(($totl_wigh/$value['mas_weight']*100),2).' %</b></td></tr>';
		}
	$desn_no = $value['design_no'];
	$design_det_id = $value['design_det_id'];
	$master_cat_id = $value['master_cat_id'];
	$html .= '</tbody></table>
	</div>
  </div>
</div>';

	$no_rec++;
	}
		$menu_arr = $this->navmenulist();
		$menuarr1 = $menu_arr[0];
		$menucatcnt = $menu_arr[1];
		$menucatcnt1 = $menu_arr[2];
		$menucatcnt2 = $menu_arr[3];
		$menucatcnt3 = $menu_arr[4];
		$menucategory = $menu_arr[5];

		$cat_place = array_search($cat, $menucategory)+1; 
		$cad_keys=array_keys($menuarr1[$cat]);
		$cad_place = array_search($cad, $cad_keys)+1; 
	//	$sp_keys=array_keys($menuarr1[$cat][$cad]);
	$sp_keys = [];

if (
    isset($menuarr1[$cat]) &&
    isset($menuarr1[$cat][$cad]) &&
    is_array($menuarr1[$cat][$cad])
) {
    $sp_keys = array_keys($menuarr1[$cat][$cad]);
}

		$sp_place = array_search($sp, $sp_keys)+1; 

		$menu_select = $cat_place.$cad_place.$sp_place;

		$cart_list= $this->getCartItems($session_user);
		$c=0;

		$cmp_name = $this->company_name($session_user);
		$getPartyId = $this->getPartyId($session_user);

		$pending_order = $this->Orderpen($session_user);
		$pending_amount = $this->OrderpenAmt($getPartyId,$cmp_name);
		$item_count = $this->CartItemCount($getPartyId);

	return $this->render('DesignSelection/DesignSelection-list.html.twig', [
			'session_user' => $session_user,
			'pending_amount'=>$pending_amount,
			'pending_order'=>$pending_order,
			'FTCHlistDet' => $html,
			'sidemenu'=>$menuarr1,
			'catcount'=>$menucatcnt,
			'catcount1'=>$menucatcnt1,
			'catcount2'=>$menucatcnt2,
			'catcount3'=>$menucatcnt3,
			'cmp_name'=>$cmp_name,
			'item_count'=>count($item_count),
			'tot_prod'=>'',//$pv,
			'cart_list'=>$cart_list,
			'st_name'=>$request->get('sp'),
			'msg'=>'',
			'cat'=>$cat_name,
			'menu_select'=>$menu_select,
			'category_name'=>$cat,
			'cad'=>$cad,
			'wrange'=>$wrange,
			'srange'=>$srange,
			'sp'=>$sp,
			'sub'=>$sub,
			'sub_name'=>$sub_name,
			'total_products' => '',
			'product_count' => '',
			'selcat'=>$selcat,
			'selcad'=>$selcad,
			'selsp'=>$selsp,
			'controller_name' => 'DesignSelectionController'
        ]);
	}

	function getstone($mas_stone_cat_id){
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		$QURYlistDet = "SELECT * FROM mas_stone_cat WHERE mas_stone_cat_id ='".$mas_stone_cat_id."'";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();
		if(count($FTCHlistDet)>0){
			foreach($FTCHlistDet as $value){
				$cat_name = $value['cat_name'];
			}
		}else {
			$cat_name ='';
		}
		return $cat_name;
	}

	function getstonename($mas_stone_type_id){
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		$QURYlistDet = "SELECT * FROM mas_stone_type WHERE mas_stone_type_id ='".$mas_stone_type_id."'";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();
		if(count($FTCHlistDet)>0){
		foreach($FTCHlistDet as $value){
			$stone_name = $value['stone_name'];
		} }else {
			$stone_name ='';
		}
		return $stone_name;
	}

	function getstoneweight($mas_stone_type_id){
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		$QURYlistDet = "SELECT * FROM mas_stone_type WHERE mas_stone_type_id ='".$mas_stone_type_id."'";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();
		if(count($FTCHlistDet)>0){
		foreach($FTCHlistDet as $value){
			$stone_weight = $value['stone_weight'];
		} }else {
			$stone_weight ='';
		}
		return $stone_weight;
	}
}
