<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;
use Symfony\Component\HttpFoundation\RedirectResponse;

class DepartmentController extends AbstractController
{

    /**
     * @Route("/department{stID}", name="department")
     */
    public function departmentListActions(Request $request, $stID) 
    {
		$session =$request->getSession();

        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }

		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		date_default_timezone_set("Asia/Kolkata");
		$current_dt = date("Y-m-d");

		########-[ QUICK VARIABLES
		$tableName	= "department";
		$tablePrmID	= "department_id";
		$getVARIid	= $stID;

		########-[ LIST of STONES - DETAILS
		$QURYlistDet= "SELECT * FROM ".$tableName." ORDER BY ".$tablePrmID." DESC";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();

		if($getVARIid != 0)
		{
			########-[ GET UPDATE - DETAILS
			$QURYupdtDet	= "SELECT * FROM ".$tableName." WHERE ".$tablePrmID."=".$getVARIid;
			$CONNupdtDet	= $connection->executeQuery($QURYupdtDet);
			$FTCHupdtDet	= $CONNupdtDet->fetchAll();

			$FTCHupdtDet['department_name']  = $FTCHupdtDet[0]['department_name'];
			$FTCHupdtDet['status'] 	 = $FTCHupdtDet[0]['status'];
		}
		else
		{
			$FTCHupdtDet['department_name']="";
			$FTCHupdtDet['status'] = "";
		}

		if($request->getMethod() == 'POST')
		{
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime  = date("Y-m-d H:i:s");

			$department_name  = $request->get('department_name');
			$status   = $request->get('status');
			$sessionId    = $session->get('empId');

			if($getVARIid == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO ".$tableName."(`department_name`, `status`, `post_by`, `post_dt`) VALUES ('$department_name', '$status', '$sessionId', '$nwDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
			}
			else
			{
				########-[ UPDATE - DETAILS			
				$QRupdate 	= "UPDATE ".$tableName." SET `department_name`='$department_name', `status`='$status', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE ".$tablePrmID."=".$getVARIid;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}

		return $this->render('department/department-data.html.twig', [
			'FTCHlistDet' => $FTCHlistDet,
			'FTCHupdtDet' => $FTCHupdtDet,
			'controller_name' => 'DepartmentController'
        ]);
    }
	
	
	
    
    /**
     * @Route("/dept-dlt{department_dlt_id}", name="dept-dlt")
     */
    public function departmentDLTact(Request $request, $department_dlt_id) 
    {
		$session =$request->getSession();

        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }

		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 	

		########-[ DELETE - DETAILS
		$QRdltemployee = "DELETE FROM `department` WHERE `department_id`=".$department_dlt_id;
		$CNdltemployee = $connection->executeQuery($QRdltemployee);
//die();
		return $this->redirectToRoute('department0');
	}
}
