<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class WaxDeptController extends AbstractController
{

    /**
     * @Route("/wax-entry-data{wxID}", name="wax-entry-data")
     */
    public function waxEntryDatatActions(Request $request, $wxID) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		
		#--------[ FETCH - OPEN ORDER NO
		$QURYopenORDno = "SELECT `po_open_ord_id`, CONCAT(`po_open_ord_code`,`po_open_ord_no`) AS openORDno FROM `po_open_ord` WHERE `ord_status`='open' AND `role_status`='1' AND `po_open_ord_code` NOT LIKE 'SP%' AND `po_open_ord_code` NOT LIKE 'RP%' ORDER BY `po_open_ord_id` ASC";
		$CONNopenORDno = $connection->executeQuery($QURYopenORDno);
		$FTCHopenORDno = $CONNopenORDno->fetchAll();
		
		#--------[ FETCH - EMP LIST
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM `employee` AS E, employee_salary AS ES, dept AS D, roles AS R WHERE E.dept=D.dept_id AND E.roles=R.roles_id AND E.employee_id=ES.employee_id AND E.role_status=1 GROUP BY ES.employee_id ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();
		
		########-[ QUICK VARIABLES
		$tableName	= "wax_entry";
		$tablePrmID	= "wax_entry_id";
		$getVARIid	= $wxID;
				
		########-[ LIST 
		$QURYlistDet= "SELECT POD.po_open_ord_det_id, WE.wax_entry_id, CONCAT(PO.po_open_ord_code,'',PO.po_open_ord_no) AS opNO, POD.jc_no, DATE_FORMAT(WE.entry_date, '%b %D, %Y  %H:%i') AS entry_date, WE.injection_emp_id, WE.cleaning_emp_id, WE.sizing_emp_id, WE.setting_emp_id, WE.tree_making_emp_id FROM `wax_entry` AS WE, po_open_ord AS PO, po_open_ord_det AS POD WHERE WE.po_open_ord_id=PO.po_open_ord_id AND WE.po_open_ord_det_id=POD.po_open_ord_det_id ORDER BY `wax_entry_id` DESC";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();
		$CONTlistDet= count($FTCHlistDet);
		
		$data = "";
		for($i=0; $i<=$CONTlistDet-1; $i++)
		{
			$injection_emp_id 	= $FTCHlistDet[$i]['injection_emp_id'];
			$cleaning_emp_id  	= $FTCHlistDet[$i]['cleaning_emp_id'];
			$sizing_emp_id  	= $FTCHlistDet[$i]['sizing_emp_id'];
			$setting_emp_id  	= $FTCHlistDet[$i]['setting_emp_id'];
			$tree_making_emp_id	= $FTCHlistDet[$i]['tree_making_emp_id'];
			
			$QURYinjEMP = "SELECT E.emp_name FROM `wax_entry` AS WE, `employee` AS E WHERE WE.injection_emp_id='$injection_emp_id' AND WE.injection_emp_id=E.employee_id";
			$CONNinjEMP = $connection->executeQuery($QURYinjEMP);
			$FTCHinjEMP = $CONNinjEMP->fetchAll();
			
			$QURYclnEMP = "SELECT E.emp_name FROM `wax_entry` AS WE, `employee` AS E WHERE WE.cleaning_emp_id='$cleaning_emp_id' AND WE.cleaning_emp_id=E.employee_id";
			$CONNclnEMP = $connection->executeQuery($QURYclnEMP);
			$FTCHclnEMP = $CONNclnEMP->fetchAll();
			
			$QURYsizEMP = "SELECT E.emp_name FROM `wax_entry` AS WE, `employee` AS E WHERE WE.sizing_emp_id='$sizing_emp_id' AND WE.sizing_emp_id=E.employee_id";
			$CONNsizEMP = $connection->executeQuery($QURYsizEMP);
			$FTCHsizEMP = $CONNsizEMP->fetchAll();
			
/*			$QURYsetEMP = "SELECT E.emp_name FROM `wax_entry` AS WE, `employee` AS E WHERE WE.setting_emp_id='$setting_emp_id' AND WE.setting_emp_id=E.employee_id";
			$CONNsetEMP = $connection->executeQuery($QURYsetEMP);
			$FTCHsetEMP = $CONNsetEMP->fetchAll();
			
			$QURYtreEMP = "SELECT E.emp_name FROM `wax_entry` AS WE, `employee` AS E WHERE WE.tree_making_emp_id='$tree_making_emp_id' AND WE.tree_making_emp_id=E.employee_id";
			$CONNtreEMP = $connection->executeQuery($QURYtreEMP);
			$FTCHtreEMP = $CONNtreEMP->fetchAll(); */	
			
			#--------[ CHECK - JC in WAX SETTING
			$QURYwxSETT = "SELECT `wax_setting_id` FROM `wax_setting` WHERE `po_open_ord_det_id`='".$FTCHlistDet[$i]['po_open_ord_det_id']."'";
			$CONNwxSETT = $connection->executeQuery($QURYwxSETT);
			$FTCHwxSETT = $CONNwxSETT->fetchAll();	
			$CHCKwxSETT = $FTCHwxSETT[0]['wax_setting_id'];				
		
			$data .= '<tr>
						<td title="Showing - Serial No." style="text-align:center; vertical-align: middle;">'. ($i+1) .'</td>
						<td title="Showing - Order No." style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]["opNO"].'</td>
						<td title="Showing - Job Card No." style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]["jc_no"].'</td>
						<td title="Showing - Job Card Entry Date" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]["entry_date"].'</td>
						<td title="Showing - Injection Emp" style="text-align:left; vertical-align: middle;">'.$FTCHinjEMP[0]["emp_name"].'</td>
						<td title="Showing - Cleaning Emp" style="text-align:left; vertical-align: middle;">'.$FTCHclnEMP[0]["emp_name"].'</td>
						<td title="Showing - Sizing Emp" style="text-align:left; vertical-align: middle;">'.$FTCHsizEMP[0]["emp_name"].'</td>
						<td title="Action" style="text-align:center; vertical-align: middle;">';
				
				if($CHCKwxSETT == "")
				{
				  $data .= '<a href="wax-entry-data'.$FTCHlistDet[$i]['wax_entry_id'].'"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>
							&nbsp;&nbsp;&nbsp;
							<a href="wax-entry-dlt'.$FTCHlistDet[$i]['wax_entry_id'].'"><i class="fa fa-trash" aria-hidden="true" style="color:red;"></i></a>';
				} 
				else 
				{
			     $data .='<i class="fa fa-pencil-square-o" aria-hidden="true" style="color:#E8E8E8"></i>
								&nbsp;&nbsp;&nbsp;
						  <i class="fa fa-trash" aria-hidden="true" style="color:#E8E8E8;"></i>';				
				}
				$data .= '</td>';
						/*
						<td title="Showing - Setting Emp" style="text-align:left; vertical-align: middle;">'.$FTCHsetEMP[0]["emp_name"].'</td>
						<td title="Showing - Tree Making Emp" style="text-align:left; vertical-align: middle;">'.$FTCHtreEMP[0]["emp_name"].'</td>
						*/
			$data .= '</tr>';
		}
		
		if($getVARIid != 0)
		{
			########-[ GET UPDATE - DETAILS
			$QURYupdtDet	= "SELECT * FROM ".$tableName." WHERE ".$tablePrmID."=".$getVARIid;
			$CONNupdtDet	= $connection->executeQuery($QURYupdtDet);
			$FTCHupdtDet	= $CONNupdtDet->fetchAll();
			
			$FTCHupdtDet['po_open_ord_id']  	= $FTCHupdtDet[0]['po_open_ord_id'];
			$FTCHupdtDet['po_open_ord_det_id']	= $FTCHupdtDet[0]['po_open_ord_det_id'];
			$FTCHupdtDet['injection_emp_id'] 	= $FTCHupdtDet[0]['injection_emp_id'];
			$FTCHupdtDet['cleaning_emp_id']  	= $FTCHupdtDet[0]['cleaning_emp_id'];
			$FTCHupdtDet['sizing_emp_id']  		= $FTCHupdtDet[0]['sizing_emp_id'];
			$FTCHupdtDet['jc_no']  				= $FTCHupdtDet[0]['jc_no'];
			
			########-[ GET JC NO's
			$QURYjcGET	= "SELECT `po_open_ord_det_id`, `jc_no` FROM `po_open_ord_det` WHERE `po_open_ord_id`='".$FTCHupdtDet['po_open_ord_id']."' AND `role_status`=1 ORDER BY `po_open_ord_det_id` ASC";
			$CONNjcGET	= $connection->executeQuery($QURYjcGET);
			$FTCHjcGET	= $CONNjcGET->fetchAll();			
		}
		else
		{
			$FTCHupdtDet = "";
			$FTCHjcGET	 = "";	
		}
		
		if($request->getMethod() == 'POST')
		{
			$open_ord_id  		= $request->get('open_ord_id');
			$open_ord_jc_id 	= $request->get('open_ord_jc_id');
			$entry_date1		= explode(" ", $request->get('entry_date'));
			$entry_date2		= explode("-", $entry_date1[0]);
			$entry_date			= $entry_date2[2]."-".$entry_date2[1]."-".$entry_date2[0]." ".$entry_date1[1];

			$injection_emp_id	= $request->get('injection_emp_id');
			$cleaned_emp_id  	= $request->get('cleaned_emp_id');
			$sizing_emp_id  	= $request->get('sizing_emp_id');
			$jcHIDDENid  		= $request->get('jcHIDDENid');
			$jc_no  			= $request->get('jc_no');
			
			if($getVARIid == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO ".$tableName."(`po_open_ord_id`, `po_open_ord_det_id`, `jc_no`, `entry_date`, `injection_emp_id`, `cleaning_emp_id`, `sizing_emp_id`, `po_open_ord_det_id_multi`, `post_by`, `post_dt`) VALUES ('$open_ord_id', '$open_ord_jc_id', '$jc_no', '$entry_date', '$injection_emp_id', '$cleaned_emp_id', '$sizing_emp_id', '$jcHIDDENid', '$sessionId', '$nowDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
			}
			else
			{
				########-[ UPDATE - DETAILS			
				$QRupdate 	= "UPDATE ".$tableName." SET `po_open_ord_id`='$open_ord_id', `po_open_ord_det_id`='$open_ord_jc_id', `jc_no`='$jc_no', `entry_date`='$entry_date', `injection_emp_id`='$injection_emp_id', `cleaning_emp_id`='$cleaned_emp_id', `sizing_emp_id`='$sizing_emp_id', `setting_emp_id`='value', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE ".$tablePrmID."=".$getVARIid;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}
		
		return $this->render('dept/wax-entry-data.html.twig', [
			'openORDno' => $FTCHopenORDno,
			'empLIST' => $FTCHemp,
			'data' => $data,
			'FTCHupdtDet' => $FTCHupdtDet,
			'FTCHjcGET' => $FTCHjcGET,
			'controller_name' => 'WaxDeptController'
        ]);
    }
	
	
    /**
     * @Route("/wax-setting-list", name="wax-setting-list")
     */
    public function waxSettingListActions(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		#--------[ FETCH
		$QURY = "SELECT WSD.wax_setting_id, WSD.row_no, POD.po_open_ord_det_id, CONCAT(PO.po_open_ord_code,'',PO.po_open_ord_no) AS opNO, POD.jc_no, DATE_FORMAT(WS.post_dt, '%b %D, %y %I:%i %p') AS entry_date, FORMAT(S.stone_weight, 3) AS stWgt, WSD.st_qty, FORMAT(WSD.st_wt_sub_tot, 3) AS subSTwgt, FORMAT(WSD.st_wt_sub_tot_diff, 3) AS subSTwgtDIFF, E.emp_name FROM `wax_setting` AS WS, `wax_setting_det` AS WSD, po_open_ord AS PO, po_open_ord_det AS POD, stones AS S, employee AS E WHERE WSD.po_open_ord_id=PO.po_open_ord_id AND WSD.po_open_ord_det_id=POD.po_open_ord_det_id AND WSD.stones_id=S.stones_id AND WSD.`wax_setting_id`=WS.wax_setting_id AND WS.emp_id=E.employee_id ORDER BY WSD.`wax_setting_id`DESC, WSD.`row_no` ASC";
		$CONN = $connection->executeQuery($QURY);
		$FTCH = $CONN->fetchAll();
		$CONT = count($FTCH) - 1;
		
		$data = "";
		for($i=0; $i<=$CONT; $i++)
		{
			$row_no = $FTCH[$i]['row_no'];
		
			#--------[ CHECK - JC COUNT
			$QURYjcCONT = "SELECT COUNT(`wax_setting_det_id`) AS countJCs FROM `wax_setting_det` WHERE `po_open_ord_det_id`='".$FTCH[$i]['po_open_ord_det_id']."'";
			$CONNjcCONT = $connection->executeQuery($QURYjcCONT);
			$FTCHjcCONT = $CONNjcCONT->fetchAll();	
			$countJCs   = $FTCHjcCONT[0]['countJCs'];	
			
			#--------[ CHECK - JC in WAX ENTRY
			
			$QURYwxENT = "SELECT `wax_tree_making_det_id` FROM `wax_tree_making_det` WHERE `po_open_ord_det_id`='".$FTCH[$i]['po_open_ord_det_id']."'";
			$CONNwxENT = $connection->executeQuery($QURYwxENT);
			$FTCHwxENT = $CONNwxENT->fetchAll();
			$CHCKwxENT = $FTCHwxENT[0]['wax_tree_making_det_id'];						
		
			$data .= '<tr>
						<td title="Serial No." style="text-align:center; vertical-align: middle;">'.($i+1).'</td>
						<td title="Showing - Order No." style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['opNO'].'</td>
						<td title="Showing - Job Card No." style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['jc_no'].'</td>
						<td title="Showing - Entry Date" style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['entry_date'].'</td>
						<td title="Showing - Stone Weight in grams" style="text-align:right; vertical-align: middle;">'.$FTCH[$i]['stWgt'].'</td>
						<td title="Showing - Stone Quantity" style="text-align:center; vertical-align: middle;">'.$FTCH[$i]['st_qty'].'</td>
						<td title="Showing - Sub Stone Master Weight(from Master) in grams" style="text-align:right; vertical-align: middle;">'.$FTCH[$i]['subSTwgt'].'</td>
						<td title="Showing - Sub Stone Actual Weight(Actual Weight) in grams" style="text-align:right; vertical-align: middle;">'.$FTCH[$i]['subSTwgtDIFF'].'</td>
						<td title="Showing - Emp Name" style="text-align:left; vertical-align: middle;">'.$FTCH[$i]['emp_name'].'</td>
						<td title="Action" style="text-align:center; vertical-align: middle;">';
						if($CHCKwxENT == "")
						{					
							if($row_no >= $countJCs)
							{	
							$data .='<a href="wax-setting-upd'.$FTCH[$i]['wax_setting_id'].'"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>
									&nbsp;&nbsp;&nbsp;
								 <a href="wax-setting-dlt'.$FTCH[$i]['wax_setting_id'].'"><i class="fa fa-trash" aria-hidden="true" style="color:red;"></i></a>';
							}
						}
						else if($CHCKwxENT != "")
						{
							if($row_no >= $countJCs)
							{		   
							$data .= '<i class="fa fa-pencil-square-o" aria-hidden="true" style="color:#E8E8E8"></i>
											&nbsp;&nbsp;&nbsp;
										  <i class="fa fa-trash" aria-hidden="true" style="color:#E8E8E8;"></i>';
							}
						}				
            $data .= '</tr>';
		}	
		
		return $this->render('dept/wax-setting-list.html.twig', [
			'waxSETTINGlist' => $FTCH,
			'data' => $data,
			'controller_name' => 'WaxDeptController'
        ]);	
	}
	
	
    /**
     * @Route("/wax-setting-add", name="wax-setting-add")
     */
    public function waxSettingAddActions(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		
		#--------[ LIST - STONE DETAILS
		$QURYlistST = "SELECT * FROM stones WHERE role_status=1 GROUP BY `stone_shape` ORDER BY `stone_shape` ASC";
		$CONNlistST = $connection->executeQuery($QURYlistST);
		$FTCHlistST = $CONNlistST->fetchAll();
		
		#--------[ FETCH - OPEN ORDER NO
		$QURYopenORDno = "SELECT `po_open_ord_id`, CONCAT(`po_open_ord_code`,`po_open_ord_no`) AS openORDno FROM `po_open_ord` WHERE `ord_status`='open' AND `role_status`='1' AND `po_open_ord_code` NOT LIKE 'SP%' AND `po_open_ord_code` NOT LIKE 'RP%' ORDER BY `po_open_ord_id` ASC";
		$CONNopenORDno = $connection->executeQuery($QURYopenORDno);
		$FTCHopenORDno = $CONNopenORDno->fetchAll();		
		
		#--------[ FETCH - EMP LIST
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM `employee` AS E, employee_salary AS ES, dept AS D, roles AS R WHERE E.dept=D.dept_id AND E.roles=R.roles_id AND E.employee_id=ES.employee_id AND E.role_status=1 GROUP BY ES.employee_id ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();		
		
		if($request->getMethod() == 'POST')
		{
			$open_ord_id 		= $request->get('open_ord_id');
			$open_ord_jc_id 	= $request->get('open_ord_jc_id');
			$jc_no 				= $request->get('jc_no');
			$entry_date1		= explode(" ", $request->get('entry_date'));
			$entry_date2		= explode("-", $entry_date1[0]);
			$entry_date			= $entry_date2[2]."-".$entry_date2[1]."-".$entry_date2[0]." ".$entry_date1[1];
			$st_source_emp_id	= $request->get('st_source_emp_id');
			$no_of_stone 		= $request->get('no_of_stone');
			$stone_weight 		= $request->get('stone_weight');
			$emp_id 			= $request->get('emp_id');
			$tot_st_varieties 	= count($request->get('stone_shape_size'));

			
			#--------[INSERT WAX SETTING - BASIC DATA
			$instWAXsetBASICdata = "INSERT INTO `wax_setting`(`po_open_ord_id`, `po_open_ord_det_id`, `jc_no`, `entry_date`, `st_source_emp_id`, `tot_st_varieties`, `tot_st_qty`, `tot_st_wgt`, `emp_id`, `post_by`, `post_dt`) VALUES ('$open_ord_id', '$open_ord_jc_id', '$jc_no', '$entry_date', '$st_source_emp_id', '$tot_st_varieties', '$no_of_stone', '$stone_weight', '$emp_id', '$sessionId', '$nowDateTime')";
			$stmtWAXsetBASICdata = $connection->executeQuery($instWAXsetBASICdata);
			$wax_setting_id 	 = $connection->lastInsertId();
			for($i=0; $i<=$tot_st_varieties-1; $i++)
			{
				$stoneShapeSize = $request->get('stone_shape_size')[$i];
				$stones_id 		= $request->get('stones_id')[$i];
				$stone_qty 		= $request->get('stone_qty')[$i];
				$st_wt_sub_tot	= $request->get('st_wt_sub_tot')[$i];
				$st_wt_sub_totD = $request->get('st_wt_sub_tot_diff')[$i];
				$row_no			= $i+1; 
				
				if($stone_qty == 0 && $stoneShapeSize == "Plain")
				{
				#--------[ INSERT WAX SETTING STONE DATAs
				$instWAXsetSTONEdata = "INSERT INTO `wax_setting_det`(`wax_setting_id`, `po_open_ord_id`, `po_open_ord_det_id`, `jc_no`, `row_no`, `st_source_emp_id`, `stones_id`, `st_qty`, `st_wt_sub_tot`, `st_wt_sub_tot_diff`, `post_by`, `post_dt`) VALUES ('$wax_setting_id', '$open_ord_id', '$open_ord_jc_id', '$jc_no', '$row_no', '$st_source_emp_id', '$stones_id', '$stone_qty', '$st_wt_sub_tot', '$st_wt_sub_totD', '$sessionId', '$nowDateTime')";
				$stmtWAXsetSTONEdata = $connection->executeQuery($instWAXsetSTONEdata);
				}
				else
				{
				$instWAXsetSTONEdata = "INSERT INTO `wax_setting_det`(`wax_setting_id`, `po_open_ord_id`, `po_open_ord_det_id`, `jc_no`, `row_no`, `st_source_emp_id`, `stones_id`, `st_qty`, `st_wt_sub_tot`, `st_wt_sub_tot_diff`, `post_by`, `post_dt`) VALUES ('$wax_setting_id', '$open_ord_id', '$open_ord_jc_id', '$jc_no', '$row_no', '$st_source_emp_id', '$stones_id', '$stone_qty', '$st_wt_sub_tot', '$st_wt_sub_totD', '$sessionId', '$nowDateTime')";
				$stmtWAXsetSTONEdata = $connection->executeQuery($instWAXsetSTONEdata);
				}
			}
			return $this->redirect('wax-setting-list');
		}		
		
		return $this->render('dept/wax-setting-add.html.twig', [
			'openORDno' => $FTCHopenORDno,
			'FTCHlistST' => $FTCHlistST,
			'empLIST' => $FTCHemp,
			'controller_name' => 'WaxDeptController'
        ]);	
	}	
	
	
    /**
     * @Route("/wax-setting-upd{jcWAXsettID}", name="wax-setting-upd")
     */
    public function waxSettingUPDActions(Request $request, $jcWAXsettID) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		
		#--------[ FETCH - OPEN ORDER NO
		$QURYopenORDno = "SELECT `po_open_ord_id`, CONCAT(`po_open_ord_code`,`po_open_ord_no`) AS openORDno FROM `po_open_ord` WHERE `ord_status`='open' AND `role_status`='1' AND `po_open_ord_code` NOT LIKE 'SP%' AND `po_open_ord_code` NOT LIKE 'RP%' ORDER BY `po_open_ord_id` ASC";
		$CONNopenORDno = $connection->executeQuery($QURYopenORDno);
		$FTCHopenORDno = $CONNopenORDno->fetchAll();		
		
		#--------[ FETCH - EMP LIST
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM `employee` AS E, employee_salary AS ES, dept AS D, roles AS R WHERE E.dept=D.dept_id AND E.roles=R.roles_id AND E.employee_id=ES.employee_id AND E.role_status=1 GROUP BY ES.employee_id ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();		
		
		#--------[ FETCH - WAX SETTING - BASIC DATA's
		$QURYwxSETT	= "SELECT * FROM `wax_setting` WHERE `wax_setting_id`='".$jcWAXsettID."'";
		$CONNwxSETT	= $connection->executeQuery($QURYwxSETT);
		$FTCHwxSETT	= $CONNwxSETT->fetchAll();	
		
		$FTCHwxSETT['wax_setting_id'] 		= $FTCHwxSETT[0]['wax_setting_id'];
		$FTCHwxSETT['jc_no'] 				= $FTCHwxSETT[0]['jc_no'];
		$FTCHwxSETT['po_open_ord_id'] 		= $FTCHwxSETT[0]['po_open_ord_id'];
		$FTCHwxSETT['po_open_ord_det_id'] 	= $FTCHwxSETT[0]['po_open_ord_det_id'];
		$FTCHwxSETT['tot_st_qty'] 			= $FTCHwxSETT[0]['tot_st_qty'];
		$FTCHwxSETT['tot_st_wgt'] 			= number_format($FTCHwxSETT[0]['tot_st_wgt'], 2);
		$FTCHwxSETT['emp_id'] 				= $FTCHwxSETT[0]['emp_id'];
		
		#--------[ GET JC NO's
		$QURYjcGET	= "SELECT `po_open_ord_det_id`, `jc_no` FROM `po_open_ord_det` WHERE `po_open_ord_id`='".$FTCHwxSETT['po_open_ord_id']."' AND `role_status`=1 ORDER BY `po_open_ord_det_id` ASC";
		$CONNjcGET	= $connection->executeQuery($QURYjcGET);
		$FTCHjcGET	= $CONNjcGET->fetchAll();
		
		#--------[ FETCH - WAX SETTING - STONE DATA's
		$QURYwxSTdt	= "SELECT S.stones_id, S.stone_shape, S.stone_size, S.stone_color, S.stone_weight, WSD.`po_open_ord_id`, WSD.`po_open_ord_det_id`, WSD.st_qty, WSD.wax_setting_det_id, WSD.wax_setting_id, WSD.st_wt_sub_tot, WSD.st_wt_sub_tot_diff FROM `wax_setting_det` AS WSD, stones AS S WHERE WSD.`wax_setting_id`='".$jcWAXsettID."'  AND WSD.stones_id=S.stones_id";
		$CONNwxSTdt	= $connection->executeQuery($QURYwxSTdt);
		$FTCHwxSTdt	= $CONNwxSTdt->fetchAll();		
		$CONTwxSTdt	= count($FTCHwxSTdt);
		
		#--------[ LIST - STONE SHAPE
		$QURYstoneSH = "SELECT stones_id, stone_shape FROM stones WHERE role_status=1 GROUP BY `stone_shape` ORDER BY `stone_shape` ASC";
		$CONNstoneSH = $connection->executeQuery($QURYstoneSH);
		$FTCHstoneSH = $CONNstoneSH->fetchAll();
		$CONTstoneSH = count($FTCHstoneSH);
		
		$dataSTdatas = "";
		for($k=0; $k<=$CONTwxSTdt-1; $k++)
		{
		
			#--------[ LIST - STONE SIZE
			$QURYstoneSZ = "SELECT stones_id, stone_size FROM stones WHERE `stone_shape`='".$FTCHwxSTdt[$k]['stone_shape']."' AND role_status=1 GROUP BY `stone_size` ORDER BY `stone_size` ASC";
			$CONNstoneSZ = $connection->executeQuery($QURYstoneSZ);
			$FTCHstoneSZ = $CONNstoneSZ->fetchAll();	
			$CONTstoneSZ = count($FTCHstoneSZ);
			
			#--------[ LIST - STONE COLOR
			$QURYstoneCL = "SELECT stones_id, stone_color FROM stones WHERE `stone_shape`='".$FTCHwxSTdt[$k]['stone_shape']."' AND stone_size='".$FTCHwxSTdt[$k]['stone_size']."' AND role_status=1 GROUP BY `stone_color` ORDER BY `stone_color` ASC";
			$CONNstoneCL = $connection->executeQuery($QURYstoneCL);
			$FTCHstoneCL = $CONNstoneCL->fetchAll();	
			$CONTstoneCL = count($FTCHstoneCL);						
		
			$dataSTdatas .= '<div class="form-group row mb-4">
							   <div class="form-group col-sm-2 col-md-2">
								<label title="Choose Stone Shape">St Shape </label>
								<select class="form-control" name="stone_shape_size[]" id="stone_shape_size'.$k.'" onchange="return stoneSIZE('.$k.');" required>
								  <option value="">St Shape</option>';
								  
								  for($sh=0; $sh<=$CONTstoneSH-1; $sh++)
								  {
								  	if($FTCHstoneSH[$sh]['stone_shape'] == $FTCHwxSTdt[$k]['stone_shape']){ $selected = "selected";  } else { $selected = ""; }
								  
  				  $dataSTdatas .= '<option value="'.$FTCHstoneSH[$sh]['stone_shape'].'" '.$selected.' >'.$FTCHstoneSH[$sh]['stone_shape'].'</option>';
		
				  				  }		
				$dataSTdatas .= '</select>';
				$dataSTdatas .= '<input type="hidden" name="stones_id[]" id="stones_id'.$k.'" value="'.$FTCHwxSTdt[$k]['stones_id'].'" >
								 <input type="hidden" name="wax_setting_det_id[]" id="wax_setting_det_id'.$k.'" value="'.$FTCHwxSTdt[$k]['wax_setting_det_id'].'" >';					
			
				$dataSTdatas .= '<select class="form-control" name="stone_size[]" id="stone_size'.$k.'" onchange="return stoneCOLOR('.$k.');" required>
								  <option value="">St Size</option>';
								  
								  for($sz=0; $sz<=$CONTstoneSZ-1; $sz++)
								  {
								  	if($FTCHstoneSZ[$sz]['stone_size'] == $FTCHwxSTdt[$k]['stone_size']){ $selected = "selected";  } else { $selected = ""; }
								  
				 $dataSTdatas .= '<option value="'.$FTCHstoneSZ[$sz]['stone_size'].'" '.$selected.' >'.$FTCHstoneSZ[$sz]['stone_size'].' <small>mm</small></option>';
								  }
				$dataSTdatas .= '</select>
							  </div>
							  
							  <div class="form-group col-sm-2 col-md-2">
								<label title="Choose Stone Color">St Color</label>
								<select class="form-control" name="stone_color[]" id="stone_color'.$k.'"  onchange="return stoneWGT('.$k.');" required>
								  <option value="">St Color</option>';
								  for($cl=0; $cl<=$CONTstoneCL-1; $cl++)
								  {
								  	if($FTCHstoneCL[$cl]['stone_color'] == $FTCHwxSTdt[$k]['stone_color']){ $selected = "selected";  } else { $selected = ""; }
								  
				 $dataSTdatas .= '<option value="'.$FTCHstoneCL[$cl]['stone_color'].'" '.$selected.' >'.$FTCHstoneCL[$cl]['stone_color'].'</option>';
								  }								  
			   $dataSTdatas .= '</select>
								<input type="text" class="form-control" name="stone_wgt[]" id="stone_wgt'.$k.'" value="'.$FTCHwxSTdt[$k]['stone_weight'].'" placeholder="St Weight" style="text-align:right" readonly />
							  </div>
							  
							  <div class="form-group col-sm-2 col-md-2" style="text-align:center;">
								<label title="Stone Quantity"><center>Qty</center></label>
								<input type="text" class="form-control" name="stone_qty[]" id="stone_qty'.$k.'" value="'.$FTCHwxSTdt[$k]['st_qty'].'" placeholder="0" oninput="return subTotCal();" onkeyup="return subTotCal();" onblur="return subTotCal();" required style="text-align:center;" maxlength="4" />
							  </div>
			
							  <div class="form-group col-sm-2 col-md-2">
								<label title="Sub Stone Master Weight(from Master) in grams">Master St Wt <small>(g)</small></label>
								<input type="text" class="form-control" name="st_wt_sub_tot[]" id="st_wt_sub_tot'.$k.'" value="'.$FTCHwxSTdt[$k]['st_wt_sub_tot'].'" placeholder="0.00" readonly style="text-align:right;" />
							  </div>
			
							  <div class="form-group col-sm-2 col-md-2">
								<label title="Sub Stone Actual Weight(Actual Weight) in grams">Actual St Wt <small>(g)</small></label>
								<input type="text" class="form-control" name="st_wt_sub_tot_diff[]" id="st_wt_sub_tot_diff'.$k.'" value="'.$FTCHwxSTdt[$k]['st_wt_sub_tot_diff'].'" placeholder="0.00" style="text-align:right;"  onkeyup="return subTotCalDIFF();" onblur="return subTotCalDIFF();" />
							  </div>';
			
			if($k != 0){
			$dataSTdatas .= '<div class="form-group col-sm-2 col-md-2">
								<label>&nbsp;</label>
								<a href="wax-setting-st-dlt'.$FTCHwxSTdt[$k]['wax_setting_det_id'].'?wax_setting_id='.$FTCHwxSTdt[$k]['wax_setting_id'].'"><button class="btn btn-danger remove" type="button" onclick=foo("'.$k.'") style="margin-top:28px;"><i class="fas fa-trash-alt" title="Delete"></i></button></a>
							  </div>';
			}				  
			$dataSTdatas .= '</div>';
		}
		
		if($request->getMethod() == 'POST')
		{
			$open_ord_id 		= $request->get('open_ord_id');
			$open_ord_jc_id 	= $request->get('open_ord_jc_id');
			$jc_no 				= $request->get('jc_no');
			$entry_date1		= explode(" ", $request->get('entry_date'));
			$entry_date2		= explode("-", $entry_date1[0]);
			$entry_date			= $entry_date2[2]."-".$entry_date2[1]."-".$entry_date2[0]." ".$entry_date1[1];
			$no_of_stone 		= $request->get('no_of_stone');
			$stone_weight 		= $request->get('stone_weight');
			$emp_id 			= $request->get('emp_id');
			$tot_st_varieties 	= count($request->get('stone_shape_size')) - 1;
			
			
			#--------[UPDATE WAX SETTING - BASIC DATA
			$updtWAXsetBASICdata = "UPDATE `wax_setting` SET `jc_no`='$jc_no', `tot_st_varieties`='$tot_st_varieties', `tot_st_qty`='$no_of_stone', `tot_st_wgt`='$stone_weight', `emp_id`='$emp_id', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE `wax_setting_id`='".$jcWAXsettID."'";	/*`po_open_ord_id`='$open_ord_id', `po_open_ord_det_id`='$open_ord_jc_id',*/
			$stmtWAXsetBASICdata = $connection->executeQuery($updtWAXsetBASICdata);
			
			
			for($i=0; $i<=$CONTwxSTdt-1; $i++)
			{
				$wax_setting_det_id = $request->get('wax_setting_det_id')[$i];
				$stones_id 			= $request->get('stones_id')[$i];
				$stone_qty 			= $request->get('stone_qty')[$i];
				$st_wt_sub_tot		= $request->get('st_wt_sub_tot')[$i];
				$st_wt_sub_totD 	= $request->get('st_wt_sub_tot_diff')[$i];
				$row_no				= $i+1; 
				
				#--------[ UPDATE WAX SETTING STONE DATAs
				$updtWAXsetSTONEdata = "UPDATE `wax_setting_det` SET `jc_no`='$jc_no', `row_no`='$row_no', `stones_id`='$stones_id', `st_qty`='$stone_qty', `st_wt_sub_tot`='$st_wt_sub_tot', `st_wt_sub_tot_diff`='$st_wt_sub_totD', `update_by`='$sessionId',`update_dt`='$nowDateTime' WHERE `wax_setting_det_id`='$wax_setting_det_id'";	/*`po_open_ord_id`='$open_ord_id', `po_open_ord_det_id`='$open_ord_jc_id',*/
				$stmtWAXsetSTONEdata = $connection->executeQuery($updtWAXsetSTONEdata);
			}
			
			for($j=$CONTwxSTdt; $j<=$tot_st_varieties; $j++)
			{
				$wax_setting_det_id = $request->get('wax_setting_det_id')[$j];
				$stones_id 			= $request->get('stones_id')[$j];
				$stone_qty 			= $request->get('stone_qty')[$j];
				$st_wt_sub_tot		= $request->get('st_wt_sub_tot')[$j];
				$st_wt_sub_totD 	= $request->get('st_wt_sub_tot_diff')[$j];
				$row_no				= $j+1; 
				
				#--------[ INSERT WAX SETTING STONE DATAs
				$instWAXsetSTONEdata = "INSERT INTO `wax_setting_det`(`wax_setting_id`, `po_open_ord_id`, `po_open_ord_det_id`, `jc_no`, `row_no`, `stones_id`, `st_qty`, `st_wt_sub_tot`, `st_wt_sub_tot_diff`, `post_by`, `post_dt`) VALUES ('".$FTCHwxSTdt[0]['wax_setting_id']."', '".$FTCHwxSTdt[0]['po_open_ord_id']."', '".$FTCHwxSTdt[0]['po_open_ord_det_id']."', '$jc_no', '$row_no', '$stones_id', '$stone_qty', '$st_wt_sub_tot', '$st_wt_sub_totD', '$sessionId', '$nowDateTime')";
				$stmtWAXsetSTONEdata = $connection->executeQuery($instWAXsetSTONEdata);
			}			

			return $this->redirect('wax-setting-list');
		}		
		
		return $this->render('dept/wax-setting-upd.html.twig', [
			'openORDno' => $FTCHopenORDno,
			'stoneSHAPE' => $FTCHstoneSH,
			'stoneSIZE' => $FTCHstoneSZ,
			'empLIST' => $FTCHemp,
			'wxSETTdataS' => $FTCHwxSETT,
			'FTCHjcGET' => $FTCHjcGET,
			'FTCHwxSTdt' => $FTCHwxSTdt,
			'dataSTdatas' => $dataSTdatas,
			'CONTwxSTdt' => $CONTwxSTdt,
			'controller_name' => 'WaxDeptController'
        ]);	
	}
	
	
    /**
     * @Route("/wax-tree-making-list", name="wax-tree-making-list")
     */
    public function waxTreeMakingListActions(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		#--------[ FETCH
		$QURY	= "SELECT TMD.wax_tree_making_id, CONCAT(TM.tree_no_code,'/',TM.tree_no) AS tree_no, FORMAT(TM.tot_wgt, 3) AS tot_wgt, CONCAT(`po_open_ord_code`,`po_open_ord_no`) AS openORDno, JC.jc_no, DATE_FORMAT(TM.post_dt, '%b %D, %y %I:%i %p') AS entry_date, FORMAT(TMD.m_wgt, 3) AS mWGT, FORMAT(TMD.st_wg, 3) AS stWGT, E.emp_name FROM `wax_tree_making_det` AS TMD, `wax_tree_making` AS TM, po_open_ord_det AS JC, po_open_ord AS ORD, employee AS E WHERE TMD.wax_tree_making_id=TM.wax_tree_making_id AND TMD.po_open_ord_det_id=JC.po_open_ord_det_id AND TM.emp_id=E.employee_id AND JC.po_open_ord_id=ORD.po_open_ord_id ORDER BY TMD.wax_tree_making_det_id DESC";
		$CONN	= $connection->executeQuery($QURY);
		$FTCH	= $CONN->fetchAll();
		$CONT	= count($FTCH);	
		
		$data = "";
		for($j=0; $j<=$CONT-1; $j++)
		{
			$jc_no = explode("-", $FTCH[$j]['jc_no']);
			$jc_no = $jc_no[1];		
			
			#--------[ FETCH - JC COUNT
			$QURYjcCONT = "SELECT COUNT(`wax_tree_making_det_id`) AS countJCs FROM `wax_tree_making_det` WHERE `wax_tree_making_id`='".$FTCH[$j]['wax_tree_making_id']."'";
			$CONNjcCONT = $connection->executeQuery($QURYjcCONT);
			$FTCHjcCONT = $CONNjcCONT->fetchAll();	
			$countJCs   = $FTCHjcCONT[0]['countJCs'];	
			
			#--------[ CHECK - JC in WAX ENTRY
			$QURYwxENT = "SELECT casting_iss_id FROM `casting_iss` WHERE `wax_tree_making_id`='".$FTCH[$j]['wax_tree_making_id']."'";
			$CONNwxENT = $connection->executeQuery($QURYwxENT);
			$FTCHwxENT = $CONNwxENT->fetchAll();
			$CHCKwxENT = $FTCHwxENT[0]['casting_iss_id'];					
		
			$data .= '<tr>
						<td title="Serial No." style="text-align:center; vertical-align: middle;">'.($j+1).'</td>
						<td title="Showing - Tree No./Tree Weight in Grams" style="text-align:center; vertical-align: middle;"><u>'.$FTCH[$j]['tree_no'].'</u><br>'.$FTCH[$j]['tot_wgt'].'</td>
              			<td title="Showing - Order No." style="text-align:left; vertical-align: middle;">'.$FTCH[$j]['openORDno'].'</td>
             		 	<td title="Showing - Job Card No." style="text-align:left; vertical-align: middle;">'.$FTCH[$j]['jc_no'].'</td>
						<td title="Showing - Entry Date" style="text-align:left; vertical-align: middle;">'.$FTCH[$j]['entry_date'].'</td>
              			<td title="Showing - Stone Weigt in Tree - grams" style="text-align:right; vertical-align: middle;">'.$FTCH[$j]['stWGT'].'</td>
						<td title="Showing - Emp Name" style="text-align:left; vertical-align: middle;">'.$FTCH[$j]['emp_name'].'</td>
						<td title="Serial No." style="text-align:center; vertical-align: middle;">';
					  	/*<a href="wax-tree-making-upd'.$FTCH[$j]['wax_tree_making_id'].'"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>
								&nbsp;&nbsp;&nbsp;*/
				  if($CHCKwxENT == "")
				  {						
						if($jc_no >= $countJCs)
					  	{							
				  $data .= '<a href="wax-tree-making-dlt'.$FTCH[$j]['wax_tree_making_id'].'"><i class="fa fa-trash" aria-hidden="true" style="color:red;"></i></a>';					
						}
				  }
				  else if($CHCKwxENT != "")
				  {
						if($jc_no >= $countJCs)
					  	{							
				  $data .= '<i class="fa fa-trash" aria-hidden="true" style="color:#E8E8E8;"></i>';					
						}			  
				  }		
				  		
			    $data .= '</td>
            		</tr>';
		}		

		return $this->render('dept/wax-tree-making-list.html.twig', [
			'treeMAKING' => $FTCH,
			'data' => $data,
			'controller_name' => 'WaxDeptController'
        ]);	
	}
		
	
    /**
     * @Route("/wax-tree-making-add", name="wax-tree-making-add")
     */
    public function waxTreeMakingAddActions(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");	 

		
		#--------[ FETCH - TREE NO - AUTO GENERATE
		//$QURYtreeNOautoGEN = "SELECT IFNULL(MAX(LPAD(`tree_no` + 1, 2, '0')), '01') AS treeNO FROM `wax_tree_making` WHERE `role_status`=1 AND right(`tree_no_code`, 2)='".date('d')."'";	#-------- Reset - TREE No - MONTH-WISE 
		$QURYtreeNOautoGEN = "SELECT IFNULL(MAX(LPAD(`tree_no` + 1, 2, '0')), '01') AS treeNO, left(`tree_no_code`, 2) FROM `wax_tree_making` WHERE `role_status`=1 AND left(`tree_no_code`, 2)='".date('d')."'";	#-------- Reset - TREE No - DAY-WISE
		$CONNtreeNOautoGEN = $connection->executeQuery($QURYtreeNOautoGEN);
		$FTCHtreeNOautoGEN = $CONNtreeNOautoGEN->fetchAll();
		$RSLTtreeNOautoGEN = date('d').date('m')."/".$FTCHtreeNOautoGEN[0]['treeNO'];

		#--------[ FETCH - OPEN ORDER NO
		$QURYopenORDno = "SELECT `po_open_ord_id`, CONCAT(`po_open_ord_code`,`po_open_ord_no`) AS openORDno FROM `po_open_ord` WHERE `ord_status`='open' AND `role_status`='1' AND `po_open_ord_code` NOT LIKE 'SP%' AND `po_open_ord_code` NOT LIKE 'RP%' ORDER BY `po_open_ord_id` ASC";
		$CONNopenORDno = $connection->executeQuery($QURYopenORDno);
		$FTCHopenORDno = $CONNopenORDno->fetchAll();		
		
		#--------[ LIST - STONE DETAILS
		$QURYlistST = "SELECT * FROM stones WHERE role_status=1 ORDER BY stone_shape ASC";
		$CONNlistST = $connection->executeQuery($QURYlistST);
		$FTCHlistST = $CONNlistST->fetchAll();
		
		#--------[ FETCH - EMP LIST
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM `employee` AS E, employee_salary AS ES, dept AS D, roles AS R WHERE E.dept=D.dept_id AND E.roles=R.roles_id AND E.employee_id=ES.employee_id AND E.role_status=1 GROUP BY ES.employee_id ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();		
		
		if($request->getMethod() == 'POST')
		{
			$tree_no_code		= date('d').date('m');
			$tree_no 			= explode("/", $request->get('tree_no'));
			$tree_no 			= $tree_no[1];
			//$open_ord_id 		= $request->get('hidden_open_ord_id');
			$entry_date			= explode("-", $request->get('entry_date'));
			$entry_date			= $entry_date[2]."-".$entry_date[1]."-".$entry_date[0];
			$tot_m_wgt	 		= $request->get('tot_m_wgt');
			$tot_st_wgt	 		= $request->get('tot_st_wgt');
			$emp_id 			= $request->get('emp_id');
			$tot_tree_count 	= count($request->get('open_ord_jc_id'));
			
			
			#--------[INSERT WAX TREE MAKING - BASIC DATA
//			$instWAXtreeMAKINGbasicDATA = "INSERT INTO `wax_tree_making`(`tree_no`, `po_open_ord_id`, `entry_date`, `tot_job_card`, `tot_wgt`, `tot_st_wgt`, `emp_id`, `post_by`, `post_dt`) VALUES ('$tree_no', '$open_ord_id', '$entry_date', '$tot_tree_count', '$tot_m_wgt', '$tot_st_wgt', '$emp_id', '$sessionId', '$nowDateTime')";
		
			$instWAXtreeMAKINGbasicDATA = "INSERT INTO `wax_tree_making`(`tree_no_code`, `tree_no`, `entry_date`, `tot_job_card`, `tot_wgt`, `tot_st_wgt`, `emp_id`, `post_by`, `post_dt`) VALUES ('$tree_no_code', '$tree_no', '$entry_date', '$tot_tree_count', '$tot_m_wgt', '$tot_st_wgt', '$emp_id', '$sessionId', '$nowDateTime')";
			$stmtWAXtreeMAKINGbasicDATA = $connection->executeQuery($instWAXtreeMAKINGbasicDATA);
			$wax_tree_making_id 	 	= $connection->lastInsertId();
			
			for($i=0; $i<=$tot_tree_count-1; $i++)
			{
				$dlt_row			= $request->get('dlt_row')[$i];
				$open_ord_id 		= $request->get('open_ord_id')[$i];
				$open_ord_jc_id 	= $request->get('open_ord_jc_id')[$i];
				$jc_no 				= $request->get('jc_no')[$i];
				//$wgt 				= $request->get('wgt')[$i];
				$stone_wgt			= $request->get('stone_wgt')[$i];
				
				if($dlt_row == 1)
				{
				#--------[ INSERT WAX TREE MAKING - JOB CART WEIGHT DATAs
				$instWAXtreeMAKINGwgtDATA = "INSERT INTO `wax_tree_making_det`(`wax_tree_making_id`, `po_open_ord_id`, `po_open_ord_det_id`,`jc_no`, `st_wg`, `post_by`, `post_dt`) VALUES ('$wax_tree_making_id', '$open_ord_id', '$open_ord_jc_id', '$jc_no', '$stone_wgt', '$sessionId', '$nowDateTime')";
				$stmtWAXtreeMAKINGwgtDATA = $connection->executeQuery($instWAXtreeMAKINGwgtDATA);
				}
			}

			return $this->redirect('wax-tree-making-list');
		}
		
		return $this->render('dept/wax-tree-making-add.html.twig', [
			'treeNO' => $RSLTtreeNOautoGEN,
			'openORDno' => $FTCHopenORDno,
			'FTCHlistST' => $FTCHlistST,
			'empLIST' => $FTCHemp,			
			'controller_name' => 'WaxDeptController'
        ]);	
	}
	
	
   /**
     * @Route("/wax-tree-making-upd{treeMAKINGupdID}", name="wax-tree-making-upd")
     */
    public function waxTreeMakingUpdActions(Request $request, $treeMAKINGupdID) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");	 

		
		#--------[ FETCH - TREE NO - AUTO GENERATE
		//$QURYtreeNOautoGEN = "SELECT IFNULL(MAX(LPAD(`tree_no` + 1, 2, '0')), '01') AS treeNO FROM `wax_tree_making` WHERE `role_status`=1 AND right(`tree_no_code`, 2)='".date('d')."'";	#-------- Reset - TREE No - MONTH-WISE 
		$QURYtreeNOautoGEN = "SELECT IFNULL(MAX(LPAD(`tree_no` + 1, 2, '0')), '01') AS treeNO, left(`tree_no_code`, 2) FROM `wax_tree_making` WHERE `role_status`=1 AND left(`tree_no_code`, 2)='".date('d')."'";	#-------- Reset - TREE No - DAY-WISE
		$CONNtreeNOautoGEN = $connection->executeQuery($QURYtreeNOautoGEN);
		$FTCHtreeNOautoGEN = $CONNtreeNOautoGEN->fetchAll();
		$RSLTtreeNOautoGEN = date('d').date('m')."/".$FTCHtreeNOautoGEN[0]['treeNO'];
		
		#--------[ FETCH - TREE BASIC DATAs
		$QURYtreeBASICdt = "SELECT `wax_tree_making_id`, CONCAT(`tree_no_code`,'/',`tree_no`) AS treeNO, tot_job_card, tot_wgt, tot_st_wgt, emp_id FROM `wax_tree_making` WHERE `wax_tree_making_id`='$treeMAKINGupdID' AND `role_status`='1'";
		$CONNtreeBASICdt = $connection->executeQuery($QURYtreeBASICdt);
		$FTCHtreeBASICdt = $CONNtreeBASICdt->fetchAll();		
		
		$FTCHtreeBASICdt['wax_tree_making_id'] 	= $FTCHtreeBASICdt[0]['wax_tree_making_id'];
		$FTCHtreeBASICdt['treeNO'] 				= $FTCHtreeBASICdt[0]['treeNO'];
		$FTCHtreeBASICdt['tot_job_card'] 		= $FTCHtreeBASICdt[0]['tot_job_card'];
		$FTCHtreeBASICdt['tot_wgt'] 			= $FTCHtreeBASICdt[0]['tot_wgt'];
		$FTCHtreeBASICdt['tot_st_wgt'] 			= $FTCHtreeBASICdt[0]['tot_st_wgt'];
		$FTCHtreeBASICdt['emp_id'] 				= $FTCHtreeBASICdt[0]['emp_id'];
		
		#--------[ FETCH - OPEN ORDER NO
		$QURYopenORDno = "SELECT `po_open_ord_id`, CONCAT(`po_open_ord_code`,`po_open_ord_no`) AS openORDno FROM `po_open_ord` WHERE `ord_status`='open' AND `role_status`='1' ORDER BY `po_open_ord_id` ASC";
		$CONNopenORDno = $connection->executeQuery($QURYopenORDno);
		$FTCHopenORDno = $CONNopenORDno->fetchAll();		
		$CONTopenORDno = count($FTCHopenORDno);
		
		#--------[ LIST - STONE DETAILS
		$QURYlistST = "SELECT * FROM stones WHERE role_status=1 ORDER BY stone_shape ASC";
		$CONNlistST = $connection->executeQuery($QURYlistST);
		$FTCHlistST = $CONNlistST->fetchAll();
		
		#--------[ FETCH - EMP LIST
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM `employee` AS E, employee_salary AS ES, dept AS D, roles AS R WHERE E.dept=D.dept_id AND E.roles=R.roles_id AND E.employee_id=ES.employee_id AND E.role_status=1 GROUP BY ES.employee_id ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();		
		
		#--------[ FETCH - TREE - JC DATAs
		$QURYtreeJCdataS = "SELECT wax_tree_making_det_id, wax_tree_making_id, po_open_ord_id, po_open_ord_det_id, jc_no, st_wg FROM `wax_tree_making_det` WHERE `wax_tree_making_id`='$treeMAKINGupdID' AND `role_status`='1'";
		$CONNtreeJCdataS = $connection->executeQuery($QURYtreeJCdataS);
		$FTCHtreeJCdataS = $CONNtreeJCdataS->fetchAll();
		$CONTtreeJCdataS = count($FTCHtreeJCdataS);
		
		$data = "";
		for($k=0; $k<=$CONTtreeJCdataS-1; $k++)
		{
			
			#--------[ FETCH - JC DATAs
			$QURYtreeJCnoS = "SELECT po_open_ord_det_id, jc_no FROM `po_open_ord_det` WHERE `po_open_ord_id`='".$FTCHtreeJCdataS[$k]['po_open_ord_id']."' AND `role_status`='1'";
			$CONNtreeJCnoS = $connection->executeQuery($QURYtreeJCnoS);
			$FTCHtreeJCnoS = $CONNtreeJCnoS->fetchAll();
			$CONTtreeJCnoS = count($FTCHtreeJCnoS);
			
			$data .= '<div class="form-group row mb-4">
						  <div class="form-group col-sm-4 col-md-4">
							  <label title="Choose a Order No">Order No <span id="changeORDno" align="right"></span></label>
							  <select name="open_ord_id[]" id="open_ord_id'.$k.'" class="form-control" required onchange="return pickJOBcardNOsloop( '.$k.' );" autofocus />
								<option value="">Choose a Order No.</option>';
								
								for($j=0; $j<=$CONTopenORDno-1; $j++)
								{
									if($FTCHopenORDno[$j]['po_open_ord_id'] == $FTCHtreeJCdataS[$k]['po_open_ord_id']){  $selected = "selected"; } else { $selected = ""; }
					  $data .= '<option value="'.$FTCHopenORDno[$j]['po_open_ord_id'].'" '.$selected.' >'.$FTCHopenORDno[$j]['openORDno'].'</option>';
								}
					$data .= '</select>
						  </div>
		
						  <div class="form-group col-sm-4 col-md-4">
							<label title="Choose a Job Card No.">Job Card No.</label>
							<select name="open_ord_jc_id[]" id="open_ord_jc_id'.$k.'" class="form-control" onchange="return getJOBcardSTwgt( '.$k.' );" required />
								<option value="">Choose a JC No.</option>';
								
								for($m=0; $m<=$CONTtreeJCnoS-1; $m++)
								{
									if($FTCHtreeJCdataS[$m]['jc_no'] == $FTCHtreeJCnoS[$k]['jc_no']){  $selected = "selected"; } else { $selected = ""; }
						$data .= '<option value="'.$FTCHtreeJCnoS[$m]['jc_no'].'" '.$selected.' >'.$FTCHtreeJCnoS[$m]['jc_no'].'</option>';	
								}
								
   				  $data .= '</select>
							<input type="hidxden" name="tot_tree_count_hidden" id="tot_tree_count_hidden" value="1">
							<input type="hidxden" name="jc_no[]" id="jc_no'.$k.'" value="'.$FTCHtreeJCnoS[$k]['jc_no'].'">
						  </div>
						  		
						  <div class="form-group col-sm-3 col-md-3">
							<label title="Stone Weight in Grams">Stone Weight <small>(grams)</small></label>
							<input type="text" class="form-control" name="stone_wgt[]" id="stone_wgt'.$k.'" value="'.$FTCHtreeJCdataS[$k]['st_wg'].'" placeholder="0.000" style="text-align:right;" readonly required />
						  </div>
						 </div>
						</div>';
		}
		
		if($request->getMethod() == 'POST')
		{
			$tree_no_code		= date('d').date('m');
			$tree_no 			= explode("/", $request->get('tree_no'));
			$tree_no 			= $tree_no[1];
			//$open_ord_id 		= $request->get('hidden_open_ord_id');
			$entry_date			= explode("-", $request->get('entry_date'));
			$entry_date			= $entry_date[2]."-".$entry_date[1]."-".$entry_date[0];
			$tot_m_wgt	 		= $request->get('tot_m_wgt');
			$tot_st_wgt	 		= $request->get('tot_st_wgt');
			$emp_id 			= $request->get('emp_id');
			$tot_tree_count 	= count($request->get('open_ord_jc_id'));
			
			
			#--------[INSERT WAX TREE MAKING - BASIC DATA
//			$instWAXtreeMAKINGbasicDATA = "INSERT INTO `wax_tree_making`(`tree_no`, `po_open_ord_id`, `entry_date`, `tot_job_card`, `tot_wgt`, `tot_st_wgt`, `emp_id`, `post_by`, `post_dt`) VALUES ('$tree_no', '$open_ord_id', '$entry_date', '$tot_tree_count', '$tot_m_wgt', '$tot_st_wgt', '$emp_id', '$sessionId', '$nowDateTime')";
		
			$instWAXtreeMAKINGbasicDATA = "INSERT INTO `wax_tree_making`(`tree_no_code`, `tree_no`, `entry_date`, `tot_job_card`, `tot_wgt`, `tot_st_wgt`, `emp_id`, `post_by`, `post_dt`) VALUES ('$tree_no_code', '$tree_no', '$entry_date', '$tot_tree_count', '$tot_m_wgt', '$tot_st_wgt', '$emp_id', '$sessionId', '$nowDateTime')";
			$stmtWAXtreeMAKINGbasicDATA = $connection->executeQuery($instWAXtreeMAKINGbasicDATA);
			$wax_tree_making_id 	 	= $connection->lastInsertId();
			
			for($i=0; $i<=$tot_tree_count-1; $i++)
			{
				$open_ord_id 		= $request->get('open_ord_id')[$i];
				$open_ord_jc_id 	= $request->get('open_ord_jc_id')[$i];
				$jc_no 				= $request->get('jc_no')[$i];
				//$wgt 				= $request->get('wgt')[$i];
				$stone_wgt			= $request->get('stone_wgt')[$i];
				#--------[ INSERT WAX TREE MAKING - JOB CART WEIGHT DATAs
				$instWAXtreeMAKINGwgtDATA = "INSERT INTO `wax_tree_making_det`(`wax_tree_making_id`, `po_open_ord_id`, `po_open_ord_det_id`,`jc_no`, `st_wg`, `post_by`, `post_dt`) VALUES ('$wax_tree_making_id', '$open_ord_id', '$open_ord_jc_id', '$jc_no', '$stone_wgt', '$sessionId', '$nowDateTime')";
				$stmtWAXtreeMAKINGwgtDATA = $connection->executeQuery($instWAXtreeMAKINGwgtDATA);
			}

			return $this->redirect('wax-tree-making-list');
		}
		
		return $this->render('dept/wax-tree-making-upd.html.twig', [
			'treeNO' => $RSLTtreeNOautoGEN,
			'openORDno' => $FTCHopenORDno,
			'FTCHlistST' => $FTCHlistST,
			'empLIST' => $FTCHemp,		
			'treeBASICdt' => $FTCHtreeBASICdt,
			'treeJCdataS' => $data,
			'controller_name' => 'WaxDeptController'
        ]);	
	}				
	
	
	/**
     * @Route("/wax-entry-dlt{wxENTRYdataID}", name="wax-entry-dlt")   
     */
    public function waxEntryDataDltACT(Request $request, $wxENTRYdataID) 
    {	
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		#--------[ DEELTE - JC No
		$QURYjc = "DELETE FROM `wax_entry` WHERE `wax_entry_id`='".$wxENTRYdataID."'";
		$CONNjc = $connection->executeQuery($QURYjc);

		return $this->redirectToRoute('wax-entry-data', ['wxID' => 0]);
    }
	
	
	/**
     * @Route("/wax-setting-st-dlt{wxSETTstDATAid}", name="wax-setting-st-dlt")   
     */
    public function waxSettingSTdltACT(Request $request, $wxSETTstDATAid) 
    {	
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		#--------[ DEELTE - JC No
		$QURYjc = "DELETE FROM `wax_setting_det` WHERE `wax_setting_det_id`='".$wxSETTstDATAid."'";
		$CONNjc = $connection->executeQuery($QURYjc);

		return $this->redirectToRoute('wax-setting-upd', ['jcWAXsettID' => $_GET['wax_setting_id']]);
    }
	
	
	/**
     * @Route("/wax-setting-dlt{wxSETTid}", name="wax-setting-st-dlt")   
     */
    public function waxSettingDltACT(Request $request, $wxSETTid) 
    {	
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		#--------[ DEELTE - JC BASIC DATA
		$QURYjc = "DELETE FROM `wax_setting` WHERE `wax_setting_id`='".$wxSETTid."'";
		$CONNjc = $connection->executeQuery($QURYjc);
		
		#--------[ DEELTE - COMPLETE JC No
		$QURYallJC = "DELETE FROM `wax_setting_det` WHERE `wax_setting_id`='".$wxSETTid."'";
		$CONNallJC = $connection->executeQuery($QURYallJC);		

		return $this->redirectToRoute('wax-setting-list');
    }
	
	
	/**
     * @Route("/wax-tree-making-dlt{wxTReeID}", name="wax-tree-making-dlt")   
     */
    public function waxTreeMakingDltACT(Request $request, $wxTReeID) 
    {	
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		#--------[ DEELTE - JC BASIC DATA
		$QURYjc = "DELETE FROM `wax_tree_making` WHERE `wax_tree_making_id`='".$wxTReeID."'";
		$CONNjc = $connection->executeQuery($QURYjc);
		
		#--------[ DEELTE - COMPLETE JC No
		$QURYallJC = "DELETE FROM `wax_tree_making_det` WHERE `wax_tree_making_id`='".$wxTReeID."'";
		$CONNallJC = $connection->executeQuery($QURYallJC);		

		return $this->redirectToRoute('wax-tree-making-list');
    }			
}