<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class StoneDeptController extends AbstractController
{
    /**
     * @Route("/stn-receipt-data{stRECid}", name="stn-receipt-data")
     */ 
    public function stoneRECPTdataACT(Request $request, $stRECid)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		
		#--------[ LIST - STONE DETAILS
		$QURYlistST = "SELECT * FROM stones WHERE role_status=1 GROUP BY `stone_shape` ORDER BY `stone_shape` ASC";
		$CONNlistST = $connection->executeQuery($QURYlistST);
		$FTCHlistST = $CONNlistST->fetchAll();
		
		########-[ QUICK VARIABLES
		$tableName	= "purch_stone_receipt";
		$tablePrmID	= "purch_stone_receipt_id";
		$getVARIid	= $stRECid;
				
		########-[ LIST 
		$QURYlistDet = "SELECT PSR.`purch_stone_receipt_id`, S.stone_shape, S.stone_size, S.stone_color, FORMAT(PSR.rec_st_qty, 2) AS rec_st_qty, FORMAT(PSR.rec_st_wgt, 2) AS rec_st_wgt, E.`emp_name`, DATE_FORMAT(PSR.`post_dt`, '%b %d, %Y - %r') AS entryDT FROM `purch_stone_receipt` AS PSR, `stones` AS S, `employee` AS E WHERE PSR.`stones_id`=S.`stones_id` AND PSR.`post_by`=E.`employee_id` AND PSR.`role_status`=1 ORDER BY PSR.`purch_stone_receipt_id`";
		$CONNlistDet = $connection->executeQuery($QURYlistDet);
		$FTCHlistDet = $CONNlistDet->fetchAll();
/*		$CONTlistDet= count($FTCHlistDet);
		
		$data = "";
		for($i=0; $i<=$CONTlistDet-1; $i++)
		{
			$injection_emp_id 	= $FTCHlistDet[$i]['injection_emp_id'];
			$cleaning_emp_id  	= $FTCHlistDet[$i]['cleaning_emp_id'];
			$sizing_emp_id  	= $FTCHlistDet[$i]['sizing_emp_id'];
			$setting_emp_id  	= $FTCHlistDet[$i]['setting_emp_id'];
			$tree_making_emp_id	= $FTCHlistDet[$i]['tree_making_emp_id'];
			
			$QURYinjEMP = "SELECT E.emp_name FROM `wax_entry` AS WE, `employee` AS E WHERE WE.injection_emp_id='$injection_emp_id' AND WE.injection_emp_id=E.employee_id";
			$CONNinjEMP = $connection->executeQuery($QURYinjEMP);
			$FTCHinjEMP = $CONNinjEMP->fetchAll();
			
			$QURYclnEMP = "SELECT E.emp_name FROM `wax_entry` AS WE, `employee` AS E WHERE WE.cleaning_emp_id='$cleaning_emp_id' AND WE.cleaning_emp_id=E.employee_id";
			$CONNclnEMP = $connection->executeQuery($QURYclnEMP);
			$FTCHclnEMP = $CONNclnEMP->fetchAll();
			
			$QURYsizEMP = "SELECT E.emp_name FROM `wax_entry` AS WE, `employee` AS E WHERE WE.sizing_emp_id='$sizing_emp_id' AND WE.sizing_emp_id=E.employee_id";
			$CONNsizEMP = $connection->executeQuery($QURYsizEMP);
			$FTCHsizEMP = $CONNsizEMP->fetchAll();
			
			$data .= '<tr>
						<td title="Showing - Serial No." style="text-align:center; vertical-align: middle;">'. ($i+1) .'</td>
						<td title="Showing - Order No." style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]["opNO"].'</td>
						<td title="Showing - Job Card No." style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]["jc_no"].'</td>
						<td title="Showing - Job Card Entry Date" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]["entry_date"].'</td>
						<td title="Showing - Injection Emp" style="text-align:left; vertical-align: middle;">'.$FTCHinjEMP[0]["emp_name"].'</td>
						<td title="Showing - Cleaning Emp" style="text-align:left; vertical-align: middle;">'.$FTCHclnEMP[0]["emp_name"].'</td>
						<td title="Showing - Sizing Emp" style="text-align:left; vertical-align: middle;">'.$FTCHsizEMP[0]["emp_name"].'</td>';
			$data .= '</tr>';
		}
*/	
		if($getVARIid != 0)
		{
			#--------[ EDIT DATA's
			$QURYupdtDet = "SELECT * FROM `purch_stone_receipt` WHERE `purch_stone_receipt_id`='".$getVARIid."' ";
			$CONNupdtDet = $connection->executeQuery($QURYupdtDet);
			$FTCHupdtDet = $CONNupdtDet->fetchAll();
			
			$FTCHupdtDet['stones_id'] 	= $FTCHupdtDet[0]['stones_id'];
			$FTCHupdtDet['rec_st_qty'] 	= $FTCHupdtDet[0]['rec_st_qty'];
			$FTCHupdtDet['rec_st_wgt']	= $FTCHupdtDet[0]['rec_st_wgt'];
			
			
			$QURYupdtStD = "SELECT * FROM `stones` WHERE `stones_id`='".$FTCHupdtDet['stones_id']."' ";
			$CONNupdtStD = $connection->executeQuery($QURYupdtStD);
			$FTCHupdtStD = $CONNupdtStD->fetchAll();
			
			$FTCHupdtStD['stone_shape'] = $FTCHupdtStD[0]['stone_shape'];
			$FTCHupdtStD['stone_size'] 	= $FTCHupdtStD[0]['stone_size'];
			$FTCHupdtStD['stone_color'] = $FTCHupdtStD[0]['stone_color'];
		}
		
		if($request->getMethod() == 'POST')
		{
			$stones_id 		= $request->get('stones_id');
			$rec_st_qty		= $request->get('rec_st_qty');
			$rec_st_wgt		= $request->get('rec_st_wgt');
			
			if($getVARIid == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO ".$tableName."(`stones_id`, `rec_st_qty`, `rec_st_wgt`, `post_by`, `post_dt`) VALUES ('$stones_id', '$rec_st_qty', '$rec_st_wgt', '$sessionId', '$nowDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
			}
			else
			{
				########-[ UPDATE - DETAILS			
				$QRupdate 	= "UPDATE ".$tableName." SET `rec_st_qty`='$rec_st_qty', `rec_st_wgt`='$rec_st_wgt', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE ".$tablePrmID."=".$getVARIid;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}		
		
		
		return $this->render('stone/stone-receipt-data.html.twig', [
			'listSTrecDet' => $FTCHlistDet,
			'FTCHlistST' => $FTCHlistST,
			'FTCHupdtDet' => $FTCHupdtDet,
			'FTCHupdtStD' => $FTCHupdtStD,
			'controller_name' => 'StoneDeptController'
        ]);
    }
	
	
    /**
     * @Route("/stn-issue-data{stISSid}", name="stn-issue-data")
     */
    public function stoneISSdataACT(Request $request, $stISSid)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		
		#--------[ FETCH - EMP LIST
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM `employee` AS E, employee_salary AS ES, dept AS D, roles AS R WHERE E.dept=D.dept_id AND E.roles=R.roles_id AND E.employee_id=ES.employee_id AND E.role_status=1 GROUP BY ES.employee_id ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();		
		
		#--------[ LIST - STONE DETAILS
		$QURYlistST = "SELECT * FROM stones WHERE role_status=1 GROUP BY `stone_shape` ORDER BY `stone_shape` ASC";
		$CONNlistST = $connection->executeQuery($QURYlistST);
		$FTCHlistST = $CONNlistST->fetchAll();
		
		########-[ QUICK VARIABLES
		$tableName	= "stone_iss";
		$tablePrmID	= "stone_iss_id";
		$getVARIid	= $stISSid;
				
		########-[ LIST 
		$QURYlistDet = "SELECT SI.`stone_iss_id`, S.stone_shape, S.stone_size, S.stone_color, SI.`issued_id`, SI.iss_st_qty, FORMAT(SI.iss_st_wgt, 2) AS iss_st_wgt, E.`emp_name`, DATE_FORMAT(SI.`post_dt`, '%b %d, %Y - %r') AS entryDT FROM `stone_iss` AS SI, `stones` AS S, `employee` AS E WHERE SI.`stones_id`=S.`stones_id` AND SI.`post_by`=E.`employee_id` AND SI.`role_status`=1 AND SI.entry='sms' ORDER BY SI.`stone_iss_id`";
		$CONNlistDet = $connection->executeQuery($QURYlistDet);
		$FTCHlistDet = $CONNlistDet->fetchAll();
		$CONTlistDet= count($FTCHlistDet);
		
		$data = "";
		for($i=0; $i<=$CONTlistDet-1; $i++)
		{	
			$QURYempNAME = "SELECT E.emp_name FROM `employee` AS E WHERE E.employee_id='".$FTCHlistDet[$i]['issued_id']."'";
			$CONNempNAME = $connection->executeQuery($QURYempNAME);
			$FTCHempNAME = $CONNempNAME->fetchAll();
			
			if($FTCHlistDet[$i]['issued_id'] == 800001)
			{
				$issedTO 	= "Inventory";
				$actionLINK = '<a href="stn-issue-data'.$FTCHlistDet[$i]['stone_iss_id'].'"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>';
			}
			else
			{
				$issedTO 	= $FTCHempNAME[0]['emp_name'];
				$actionLINK = '<a style="color:#E8E8E8"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>';
				//$actionLINK = '<a href="stn-issue-data'.$FTCHlistDet[$i]['stone_iss_id'].'"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>';
			}
			
			$data .= '<tr>
						<td title="Showing - Serial No." style="text-align:center; vertical-align: middle;">'.($i+1).'</td>
						<td title="Showing - Issued Worker" style="text-align:left; vertical-align: middle;">'.$issedTO.'</td>
						<td title="Showing - Stone Shape" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['stone_shape'].'</td>
						<td title="Showing - Stone Size" style="text-align:center; vertical-align: middle;">'.$FTCHlistDet[$i]['stone_size'].'</td>
						<td title="Showing - Stone Color" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['stone_color'].'</td>
						<td title="Showing - Quantity" style="text-align:center; vertical-align: middle;">'.$FTCHlistDet[$i]['iss_st_qty'].'</td>
						<td title="Showing - Received Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]['iss_st_wgt'].'</td>
						<td title="Showing - Entered Person Name / Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;"><u>'.$FTCHlistDet[$i]['emp_name'].'</u><br> '.$FTCHlistDet[$i]['entryDT'].'</td>
						<td title="Action" style="text-align:center; vertical-align: middle;">'.$actionLINK.'</td>
					</tr>';
		}

		if($getVARIid != 0)
		{
			#--------[ EDIT DATA's
			$QURYupdtDet = "SELECT * FROM `stone_iss` WHERE `stone_iss_id`='".$getVARIid."' ";
			$CONNupdtDet = $connection->executeQuery($QURYupdtDet);
			$FTCHupdtDet = $CONNupdtDet->fetchAll();
			
			$FTCHupdtDet['stones_id'] 	= $FTCHupdtDet[0]['stones_id'];
			$FTCHupdtDet['issued_id'] 	= $FTCHupdtDet[0]['issued_id'];
			$FTCHupdtDet['iss_st_qty'] 	= $FTCHupdtDet[0]['iss_st_qty'];
			$FTCHupdtDet['iss_st_wgt']	= $FTCHupdtDet[0]['iss_st_wgt'];
			
			
			$QURYupdtStD = "SELECT * FROM `stones` WHERE `stones_id`='".$FTCHupdtDet['stones_id']."' ";
			$CONNupdtStD = $connection->executeQuery($QURYupdtStD);
			$FTCHupdtStD = $CONNupdtStD->fetchAll();
			
			$FTCHupdtStD['stone_shape'] = $FTCHupdtStD[0]['stone_shape'];
			$FTCHupdtStD['stone_size'] 	= $FTCHupdtStD[0]['stone_size'];
			$FTCHupdtStD['stone_color'] = $FTCHupdtStD[0]['stone_color'];
		}
	
		if($request->getMethod() == 'POST')
		{
			$employee_id	= $request->get('employee_id');
			$stones_id 		= $request->get('stones_id');
			$iss_st_qty		= $request->get('iss_st_qty');
			$iss_st_wgt		= $request->get('iss_st_wgt');
			$entry			= "sms";
			
			if($getVARIid == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO ".$tableName."(`issued_id`, `workerID`, `entry`, `stones_id`, `iss_st_qty`, `iss_st_wgt`, `post_by`, `post_dt`) VALUES ('$employee_id', '$employee_id', '$entry', '$stones_id', '$iss_st_qty', '$iss_st_wgt', '$sessionId', '$nowDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
			}
			else
			{
				########-[ UPDATE - DETAILS			
				$QRupdate 	= "UPDATE ".$tableName." SET `iss_st_qty`='$iss_st_qty', `iss_st_wgt`='$iss_st_wgt', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE ".$tablePrmID."=".$getVARIid;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}		
		
		
		return $this->render('stone/stone-issue-data.html.twig', [
			'empDATAs' => $FTCHemp,
			'listSTrecDet' => $FTCHlistDet,
			'FTCHlistST' => $FTCHlistST,
			'stoneISSdata' => $data,
			'FTCHupdtDet' => $FTCHupdtDet,
			'FTCHupdtStD' => $FTCHupdtStD,
			'controller_name' => 'StoneDeptController'
        ]);
    }	
	
	
	/**
	 * @Route("/stn-invent-iss-dept-data{stINVissID}", name="stn-invent-iss-dept-data")
	 */
    public function stoneInventIssDeptDataACT(Request $request, $stINVissID)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		
		#--------[ FETCH - EMP LIST
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM `employee` AS E, employee_salary AS ES, dept AS D, roles AS R WHERE E.dept=D.dept_id AND E.roles=R.roles_id AND E.employee_id=ES.employee_id AND E.role_status=1 GROUP BY ES.employee_id ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();		
		
		#--------[ LIST - STONE DETAILS
		$QURYlistST = "SELECT * FROM stones WHERE role_status=1 GROUP BY `stone_shape` ORDER BY `stone_shape` ASC";
		$CONNlistST = $connection->executeQuery($QURYlistST);
		$FTCHlistST = $CONNlistST->fetchAll();
		
		########-[ QUICK VARIABLES
		$tableName	= "stone_iss";
		$tablePrmID	= "stone_iss_id";
		$getVARIid	= $stINVissID;
				
		########-[ LIST 
		$QURYlistDet = "SELECT SI.stone_iss_id, S.stone_shape, S.stone_size, S.stone_color, SI.`issued_id`, SI.iss_st_qty, FORMAT(SI.iss_st_wgt, 2) AS iss_st_wgt, E.`emp_name`, DATE_FORMAT(SI.`post_dt`, '%b %d, %Y - %r') AS entryDT FROM `stone_iss` AS SI, `stones` AS S, `employee` AS E WHERE SI.`stones_id`=S.`stones_id` AND SI.`post_by`=E.`employee_id` AND SI.`role_status`=1 AND SI.entry='inv' ORDER BY SI.`stone_iss_id`";
		$CONNlistDet = $connection->executeQuery($QURYlistDet);
		$FTCHlistDet = $CONNlistDet->fetchAll();
		$CONTlistDet= count($FTCHlistDet);
		
		$data = "";
		for($i=0; $i<=$CONTlistDet-1; $i++)
		{	
			$QURYempNAME = "SELECT E.emp_name FROM `employee` AS E WHERE E.employee_id='".$FTCHlistDet[$i]['issued_id']."'";
			$CONNempNAME = $connection->executeQuery($QURYempNAME);
			$FTCHempNAME = $CONNempNAME->fetchAll();
			
			if($FTCHlistDet[$i]['issued_id'] == 800000)	//800001 - Stone Main Stock
			{
				$issedTO 	= "Stone Main Stock";
				$actionLINK = '<a href="stn-invent-iss-dept-data'.$FTCHlistDet[$i]['stone_iss_id'].'"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>';
			}
			else
			{
				$issedTO 	= $FTCHempNAME[0]['emp_name'];
				$actionLINK = '<a style="color:#E8E8E8"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>';
			}
			
			$data .= '<tr>
						<td title="Showing - Serial No." style="text-align:center; vertical-align: middle;">'.($i+1).'</td>
						<td title="Showing - Issued Worker" style="text-align:left; vertical-align: middle;">'.$issedTO.'</td>
						<td title="Showing - Stone Shape" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['stone_shape'].'</td>
						<td title="Showing - Stone Size" style="text-align:center; vertical-align: middle;">'.$FTCHlistDet[$i]['stone_size'].'</td>
						<td title="Showing - Stone Color" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['stone_color'].'</td>
						<td title="Showing - Quantity" style="text-align:center; vertical-align: middle;">'.$FTCHlistDet[$i]['iss_st_qty'].'</td>
						<td title="Showing - Received Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]['iss_st_wgt'].'</td>
						<td title="Showing - Entered Person Name / Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;"><u>'.$FTCHlistDet[$i]['emp_name'].'</u><br> '.$FTCHlistDet[$i]['entryDT'].'</td>';
		/*	$data .= '<td title="Action" style="text-align:left; vertical-align: middle;">'.$actionLINK.'</td>';	*/
			$data .= '</tr>';
		}
		
		if($getVARIid != 0)
		{
			#--------[ EDIT DATA's
			$QURYupdtDet = "SELECT * FROM `stone_iss` WHERE `stone_iss_id`='".$getVARIid."' ";
			$CONNupdtDet = $connection->executeQuery($QURYupdtDet);
			$FTCHupdtDet = $CONNupdtDet->fetchAll();
			
			$FTCHupdtDet['stones_id'] 	= $FTCHupdtDet[0]['stones_id'];
			$FTCHupdtDet['issued_id'] 	= $FTCHupdtDet[0]['issued_id'];
			$FTCHupdtDet['iss_st_qty'] 	= $FTCHupdtDet[0]['iss_st_qty'];
			$FTCHupdtDet['iss_st_wgt']	= $FTCHupdtDet[0]['iss_st_wgt'];
			
			
			$QURYupdtStD = "SELECT * FROM `stones` WHERE `stones_id`='".$FTCHupdtDet['stones_id']."' ";
			$CONNupdtStD = $connection->executeQuery($QURYupdtStD);
			$FTCHupdtStD = $CONNupdtStD->fetchAll();
			
			$FTCHupdtStD['stone_shape'] = $FTCHupdtStD[0]['stone_shape'];
			$FTCHupdtStD['stone_size'] 	= $FTCHupdtStD[0]['stone_size'];
			$FTCHupdtStD['stone_color'] = $FTCHupdtStD[0]['stone_color'];
		
		}
		
		if($request->getMethod() == 'POST')
		{
			$employee_id	= $request->get('employee_id');
			$stones_id 		= $request->get('stones_id');
			$iss_st_qty		= $request->get('iss_st_qty');
			$iss_st_wgt		= $request->get('iss_st_wgt');
			$entry			= "inv";
			
			if($getVARIid == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO ".$tableName."(`issued_id`, `workerID`, `entry`, `stones_id`, `iss_st_qty`, `iss_st_wgt`, `post_by`, `post_dt`) VALUES ('$employee_id', '$employee_id', '$entry', '$stones_id', '$iss_st_qty', '$iss_st_wgt', '$sessionId', '$nowDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
			}
			else
			{
				########-[ UPDATE - DETAILS			
				$QRupdate 	= "UPDATE ".$tableName." SET `iss_st_qty`='$iss_st_qty', `iss_st_wgt`='$iss_st_wgt', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE ".$tablePrmID."=".$getVARIid;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}		
		
		
		return $this->render('stone/stone-invent-iss-dept-data.html.twig', [
			'empDATAs' => $FTCHemp,
			'listSTrecDet' => $FTCHlistDet,
			'FTCHlistST' => $FTCHlistST,
			'stoneISSdata' => $data,
			'FTCHupdtDet' => $FTCHupdtDet,
			'FTCHupdtStD' => $FTCHupdtStD,
			'controller_name' => 'StoneDeptController'
        ]);
    }


	/**
	 * @Route("/stn-worker-iss-dept-data{stWRKissID}", name="stn-worker-iss-dept-data")
	 */
    public function stoneWorkerIssDeptDataACT(Request $request, $stWRKissID)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		

		#--------[ FETCH - EMP LIST only with STONE STOCK
		//$QURYempSTNstck	= "SELECT Emp.employee_id, Emp.emp_name FROM `stone_iss` AS stnISS, employee AS Emp WHERE stnISS.workerID=Emp.employee_id AND (stnISS.issued_id!=800000 or stnISS.issued_id!=800001) GROUP BY stnISS.issued_id ORDER BY Emp.emp_name ASC";	// 800000 - Stone Main Stock, 800001 - Inventory
		$QURYempSTNstck	= "SELECT Emp.employee_id, Emp.emp_name FROM `stone_iss` AS stnISS, employee AS Emp WHERE stnISS.workerID=Emp.employee_id AND stnISS.workerID!=0 AND (stnISS.issued_id!=800000 or stnISS.issued_id!=800001) GROUP BY stnISS.workerID ORDER BY Emp.emp_name ASC";	// 800000 - Stone Main Stock, 800001 - Inventory
		$CONNempSTNstck	= $connection->executeQuery($QURYempSTNstck);
		$FTCHempSTNstck	= $CONNempSTNstck->fetchAll();	
		
		
		#--------[ FETCH - EMP LIST
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM `employee` AS E, employee_salary AS ES, dept AS D, roles AS R WHERE E.dept=D.dept_id AND E.roles=R.roles_id AND E.employee_id=ES.employee_id AND E.role_status=1 GROUP BY ES.employee_id ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();		
		
		#--------[ LIST - STONE DETAILS
		$QURYlistST = "SELECT * FROM stones WHERE role_status=1 GROUP BY `stone_shape` ORDER BY `stone_shape` ASC";
		$CONNlistST = $connection->executeQuery($QURYlistST);
		$FTCHlistST = $CONNlistST->fetchAll();
		
		########-[ QUICK VARIABLES
		$tableName	= "stone_iss";
		$tablePrmID	= "stone_iss_id";
		$getVARIid	= $stWRKissID;
				
		########-[ LIST 
		$QURYlistDet = "SELECT SI.stone_iss_id, S.stone_shape, S.stone_size, S.stone_color, SI.`issued_id`, SI.`w2w_tran_type`, SI.`rec_id`, SI.iss_st_qty, FORMAT(SI.iss_st_wgt, 2) AS iss_st_wgt, E.`emp_name`, DATE_FORMAT(SI.`post_dt`, '%b %d, %Y - %r') AS entryDT FROM `stone_iss` AS SI, `stones` AS S, `employee` AS E WHERE SI.`stones_id` = S.`stones_id` AND SI.`post_by` = E.`employee_id` /*AND SI.w2w_tran_type = 'rec'*/ AND SI.`role_status` = 1 AND SI.entry = 'wrk' ORDER BY SI.`stone_iss_id` DESC";
		$CONNlistDet = $connection->executeQuery($QURYlistDet);
		$FTCHlistDet = $CONNlistDet->fetchAll();
		$CONTlistDet= count($FTCHlistDet);
		
		$data = "";
		for($i=0; $i<=$CONTlistDet-1; $i++)
		{	

			$QURYrecEMP = "SELECT E.emp_name FROM `employee` AS E WHERE E.employee_id='".$FTCHlistDet[$i]['rec_id']."'";
			$CONNrecEMP = $connection->executeQuery($QURYrecEMP);
			$FTCHrecEMP = $CONNrecEMP->fetchAll();
			
			if($FTCHlistDet[$i]['rec_id'] == 800000)		//800000 - Stone Main Stock
			{
				$recTO = "Stn Main Stock";
			}
			elseif($FTCHlistDet[$i]['rec_id'] == 800001)	//800001 - Inventory
			{
				$recTO = "Inventory";
			}
			else
			{
				$recTO 		= $FTCHrecEMP[0]['emp_name'];
			}
			
			$QURYissEMP = "SELECT E.emp_name FROM `employee` AS E WHERE E.employee_id='".$FTCHlistDet[$i]['issued_id']."'";
			$CONNissEMP = $connection->executeQuery($QURYissEMP);
			$FTCHissEMP = $CONNissEMP->fetchAll();
			
			if($FTCHlistDet[$i]['issued_id'] == 800000)		//800000 - Stone Main Stock
			{
				$issedTO = "Stn Main Stock";
			}
			elseif($FTCHlistDet[$i]['issued_id'] == 800001)	//800001 - Inventory
			{
				$issedTO = "Inventory";
			}			
			else
			{
				$issedTO = $FTCHissEMP[0]['emp_name'];
			}
			
			if($FTCHlistDet[$i]['w2w_tran_type'] == "iss")
			{
				$recTO 		= $recTO;
				$issedTO 	= $FTCHissEMP[0]['emp_name'];
			}
			
			
			$data .= '<tr>
						<td title="Showing - Serial No." style="text-align:center; vertical-align: middle;">'.($i+1).'</td>
						<td title="Showing - Issued Worker" style="text-align:left; vertical-align: middle;">'.$recTO.'</td>
						<td title="Showing - Issued Worker" style="text-align:left; vertical-align: middle;">'.$issedTO.'</td>
						<td title="Showing - Stone Shape" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['stone_shape'].'</td>
						<td title="Showing - Stone Size" style="text-align:center; vertical-align: middle;">'.$FTCHlistDet[$i]['stone_size'].'</td>
						<td title="Showing - Stone Color" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['stone_color'].'</td>
						<td title="Showing - Quantity" style="text-align:center; vertical-align: middle;">'.$FTCHlistDet[$i]['iss_st_qty'].'</td>
						<td title="Showing - Received Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]['iss_st_wgt'].'</td>
						<td title="Showing - Entered Person Name / Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;"><u>'.$FTCHlistDet[$i]['emp_name'].'</u><br> '.$FTCHlistDet[$i]['entryDT'].'</td>
					</tr>';
		}
	
		if($request->getMethod() == 'POST')
		{
			$employee_id	= $request->get('employee_id');
			$empRECid		= $request->get('empRECid');
			$stones_id 		= $request->get('stones_id');
			$iss_st_qty		= $request->get('iss_st_qty');
			$iss_st_wgt		= $request->get('iss_st_wgt');
			$entry			= "wrk";
			
			if($empRECid == "sms")
			{
				$empRECid = 800000;
			} 
			else if($empRECid == "inv")
			{
				$empRECid = 800001;
			}
			else
			{
				$empRECid = $empRECid;
				$receiver = "w";
			}
			
			
			if($getVARIid == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert1 = "INSERT INTO ".$tableName."(`issued_id`, `workerID`, `entry`, `stones_id`, `w2w_tran_type`, `rec_id`, `iss_st_qty`, `iss_st_wgt`, `post_by`, `post_dt`) VALUES ('$employee_id', '$empRECid', '$entry', '$stones_id', 'iss', '$empRECid', '$iss_st_qty', '$iss_st_wgt', '$sessionId', '$nowDateTime')";
				$CNexecut1 = $connection->executeQuery($QRinsert1);
				
				########-[ INSERT - DETAILS
				//$QRinsert2 = "INSERT INTO ".$tableName."(`issued_id`, `workerID`, `entry`, `stones_id`, `w2w_tran_type`, `rec_id`, `iss_st_qty`, `iss_st_wgt`, `post_by`, `post_dt`) VALUES ('$empRECid', '', '$entry', '$stones_id', 'rec', '$employee_id', '$iss_st_qty', '$iss_st_wgt', '$sessionId', '$nowDateTime')";
				//$CNexecut2 = $connection->executeQuery($QRinsert2);				
			}
			else
			{
				########-[ UPDATE - DETAILS			
				$QRupdate 	= "UPDATE ".$tableName." SET `stone_shape`='$stone_shape', `stone_size`='$stone_size', `stone_weight`='$stone_weight', `stone_color`='$stone_color', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE ".$tablePrmID."=".$getVARIid;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}		
		
		
		return $this->render('stone/stone-worker-iss-dept-data.html.twig', [
			'empSTNstck' => $FTCHempSTNstck,
			'empDATAs' => $FTCHemp,
			'listSTrecDet' => $FTCHlistDet,
			'FTCHlistST' => $FTCHlistST,
			'stoneISSdata' => $data,
			'controller_name' => 'StoneDeptController'
        ]);
    }		
}