<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class SeparationDeptController extends AbstractController
{
	
    /**
     * @Route("/separation-list", name="separation-list")
     */
    public function separationListActions(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		#--------[ FETCH
		$QURY	= "SELECT CONCAT(TM.tree_no_code,'/',TM.tree_no) AS tree_no, DATE_FORMAT(TMD.post_dt, '%b %D, %y %I:%i %p') AS entry_date, FORMAT(TM.tot_wgt, 3) AS tot_wgt, TMD.jc_no, TMD.jc_no_split_status, TMD.jc_no_split_status, TMD.item_qty, TMD.act_po_open_ord_det_id, TMD.po_open_ord_det_id, FORMAT(TMD.jc_orn_wgt, 3) AS jc_orn_wgt, TMD.wax_tree_making_det_id FROM `wax_tree_making_det` AS TMD, `wax_tree_making` AS TM, po_open_ord_det AS POD WHERE TMD.wax_tree_making_id=TM.wax_tree_making_id AND TMD.po_open_ord_det_id=POD.po_open_ord_det_id AND TMD.jc_orn_wgt!=0 ORDER BY TMD.jc_no DESC";
		$CONN	= $connection->executeQuery($QURY);
		$FTCH	= $CONN->fetchAll();	

		
		return $this->render('dept/separation-list.html.twig', [
			'seprateLIST' => $FTCH,
			'controller_name' => 'SeparationDeptController'
        ]);	
	}	

    /**
     * @Route("/separation-add", name="separation-add")
     */
    public function separationAddActions(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		date_default_timezone_set("Asia/Kolkata");
		$current_dt = date("Y-m-d");
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");	
		
		#--------[ FETCH - TREE NO
		//$QURYtreeNO = "SELECT `wax_tree_making_id`, CONCAT(tree_no_code,'/',tree_no) AS tree_no FROM `wax_tree_making` WHERE `role_status`=1 ORDER BY `wax_tree_making_id` ASC";
		$QURYtreeNO = "SELECT DISTINCT WTM.`wax_tree_making_id`, CONCAT(WTM.tree_no_code,'/',WTM.tree_no) AS tree_no FROM `wax_tree_making` AS WTM, `wax_tree_making_det` AS WTMD WHERE WTM.`role_status`=1 AND WTM.wax_tree_making_id=WTMD.wax_tree_making_id AND WTMD.jc_orn_wgt = '0' ORDER BY WTM.`wax_tree_making_id` DESC";
		$CONNtreeNO = $connection->executeQuery($QURYtreeNO);
		$FTCHtreeNO = $CONNtreeNO->fetchAll();			
		
		#--------[ FETCH - EMP LIST
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM `employee` AS E, employee_salary AS ES, dept AS D, roles AS R WHERE E.dept=D.dept_id AND E.roles=R.roles_id AND E.employee_id=ES.employee_id AND E.role_status=1 GROUP BY ES.employee_id ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();	
		
		if($request->getMethod() == 'POST')
		{
			$jcCONT  			= $request->get('jcCONT');
			$entry_date			= explode("-", $request->get('entry_date'));
			$entry_date			= $entry_date[2]."-".$entry_date[1]."-".$entry_date[0];
			$emp_id    			= $request->get('emp_id');
			
			for($i=0; $i<=$jcCONT; $i++)
			{
				$tree_making_det_id = $request->get('tree_making_det_id')[$i];
				$item_qty			= $request->get('item_qty')[$i];
				$wgt  				= $request->get('wgt')[$i];
				########-[ UPDATE - JC SEPRATION WGT

				$QRupdt = "UPDATE `wax_tree_making_det` SET `jc_orn_wgt`='$wgt', `item_qty`='$item_qty', `sepration_emp_id`='$emp_id', `sepration_date`='$entry_date' WHERE `wax_tree_making_det_id`='$tree_making_det_id'";
				$CNupdt = $connection->executeQuery($QRupdt);						
			}
			
			return $this->redirect('separation-list');
		}		
		
		return $this->render('dept/separation-add.html.twig', [
			'treeNOlist' => $FTCHtreeNO,
			'empLIST' => $FTCHemp,
			'controller_name' => 'SeparationDeptController'
        ]);	
	}			
}