<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class ProductionIssueReceiveController extends AbstractController
{
	
	/**
     * @Route("/prod-iss-rec-data-with-pagination{prodIssRecID}", name="prod-iss-rec-data-with-pagination") 
     */
    public function prodIssRecLISTwithPAGINATIONact(Request $request, $prodIssRecID)  
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		date_default_timezone_set("Asia/Kolkata");
		$nwDate 	= date("Y-m-d");
		
		########-[ GET JC LIST
		//$QURYjcLIST		= "SELECT JC.po_open_ord_det_id, JC.jc_no FROM `wax_tree_making_det` AS TMD, `po_open_ord_det` AS JC WHERE TMD.po_open_ord_det_id=JC.po_open_ord_det_id AND TMD.`sepration_emp_id`!='' ORDER BY TMD.po_open_ord_det_id DESC";		//-OLD
		
		//$QURYjcLIST		= "SELECT TMD.`wax_tree_making_det_id`, TMD.jc_no FROM `wax_tree_making_det` AS TMD, `po_open_ord_det` AS JC WHERE TMD.po_open_ord_det_id=JC.po_open_ord_det_id AND TMD.`sepration_emp_id`!='' AND TMD.jc_no_split_status='Yes' AND JC.jc_status='on process' ORDER BY TMD.po_open_ord_det_id DESC";	//-CHECKING
		$QURYjcLIST		= "SELECT IF( TMD.`act_po_open_ord_det_id` = 0, TMD.`po_open_ord_det_id`, TMD.`wax_tree_making_det_id` ) AS wax_tree_making_det_id, JC.jc_no, TMD.`po_open_ord_det_id` FROM `wax_tree_making_det` AS TMD, `po_open_ord_det` AS JC WHERE TMD.po_open_ord_det_id=JC.po_open_ord_det_id AND TMD.`sepration_emp_id`!='' AND TMD.jc_no_split_status='Yes' AND JC.jc_status='on process' ORDER BY TMD.po_open_ord_det_id DESC";
		$CONNjcLIST		= $connection->executeQuery($QURYjcLIST);
		$FTCHjcLIST		= $CONNjcLIST->fetchAll();		
		
		$jcLIST = "";		
		for($ii=0; $ii<=count($FTCHjcLIST)-1; $ii++)
		{
			########--- CHECK WORK STATUS
			$QURYchkWRKst = "SELECT `po_id`, `work_status` FROM `prod_iss_rec` WHERE `po_id`='".$FTCHjcLIST[$ii]['po_open_ord_det_id']."' AND `work_status`!='0' ORDER BY po_id DESC LIMIT 1";
			$CONNchkWRKst = $connection->executeQuery($QURYchkWRKst);
			$FTCHchkWRKst = $CONNchkWRKst->fetchAll();
			
			if($FTCHchkWRKst[0]['po_id'] == "")
			{
				if($FTCHjcLIST[$ii]['wax_tree_making_det_id'] == $FTCHjcLIST[$ii]['po_id']){
					$select  = "selected";
				} else {
					$select  = "";
				}
				
				$jcLIST .= '<option value="'.$FTCHjcLIST[$ii]['wax_tree_making_det_id'].'" '.$select.'>'.$FTCHjcLIST[$ii]['jc_no'].'</option>';
			}
		}		
		
		########-[ GET TRANS NO
		$QURYtransNO	= "SELECT IF(MAX(`trans_no`) IS NULL,1,MAX(`trans_no`)+1) AS transNo FROM `prod_iss_rec` WHERE `statu_s`=1";
		$CONNtransNO	= $connection->executeQuery($QURYtransNO);
		$FTCHtransNO	= $CONNtransNO->fetchAll();
		$RSLTtransNO	= $FTCHtransNO[0]['transNo'];

		
		########-[ GET DEPT LIST
		$QURYdeptlist	= "SELECT `dept_id`, `dept_name` FROM `dept` WHERE `role_status`=1 AND `avail_dept`=1 ORDER BY `dept_name` ASC";
		$CONNdeptlist	= $connection->executeQuery($QURYdeptlist);
		$FTCHdeptlist	= $CONNdeptlist->fetchAll();
		
		
		########-[ GET EMPLOYEE LIST
/*		$QURYemplist	= "SELECT `employee_id`, `eid`, `emp_name` FROM `employee` WHERE `role_status`=1 ORDER BY `emp_name` ASC";
		$CONNemplist	= $connection->executeQuery($QURYemplist);
		$FTCHemplist	= $CONNemplist->fetchAll();*/
		
		
		########-[ GET EMPLOYEE LIST
		//$QURYemplist	= "SELECT `employee_id`, `eid`, `emp_name` FROM `employee` WHERE `role_status`=1 ORDER BY `emp_name` ASC";
		$QURYemplist	= "SELECT E.employee_id, E.emp_name FROM `employee` AS E, employee_salary AS ES, dept AS D, roles AS R WHERE E.dept=D.dept_id AND E.roles=R.roles_id AND E.employee_id=ES.employee_id AND E.role_status=1 GROUP BY ES.employee_id ORDER BY E.emp_name ASC";		
		$CONNemplist	= $connection->executeQuery($QURYemplist);
		$FTCHemplist	= $CONNemplist->fetchAll();
		
		
		########-[ GET Trans. Particulars / FITTINGS
		$QURYfittingsLT = "SELECT `fitting_id`, `fitting_name` FROM `fitting` WHERE `role_status`=1 AND fitting_id > 0 ORDER BY `fitting_name` ASC";
		$CONNfittingsLT	= $connection->executeQuery($QURYfittingsLT);
		$FTCHfittingsLT	= $CONNfittingsLT->fetchAll();
		
		
		########-[ GET LAST INSERTED TRANSATION NO
//		$QURYlastDeptID = "SELECT `dept_id` FROM `prod_iss_rec` WHERE `prod_iss_rec_id`=(SELECT MAX(`prod_iss_rec_id`) FROM `prod_iss_rec`)";
		$QURYlastTRANno = "SELECT `trans_no` AS lastTRANinstNO FROM `prod_iss_rec` WHERE `prod_iss_rec_id`=(SELECT MAX(`prod_iss_rec_id`) FROM `prod_iss_rec`)";
		$CONNlastTRANno	= $connection->executeQuery($QURYlastTRANno);
		$FTCHlastTRANno	= $CONNlastTRANno->fetchAll();
		$RSLTlastTRANno	= $FTCHlastTRANno[0]['lastTRANinstNO'];
		
		########-[ GET LAST INSERTED DEPT ID
		$QURYlastDeptID = "SELECT `dept_id` FROM `prod_iss_rec` WHERE `trans_no`='".$RSLTlastTRANno."'";
		$CONNlastDeptID	= $connection->executeQuery($QURYlastDeptID);
		$FTCHlastDeptID	= $CONNlastDeptID->fetchAll();
		$RSLTlastDeptID	= $FTCHlastDeptID[0]['dept_id'];		

		
		$record_per_page = 40;
		
		$page = '';
		
		if(isset($_GET["page"])){
			$page = $_GET["page"];
		}else{
		 	$page = 1;
		}

		$start_from = ($page-1) * $record_per_page;		
		
		$limitCOND		 = "LIMIT $start_from, $record_per_page";	
		
		########-[ GET PROD TRANS LIST
		//$QURYtranslist	= "SELECT PIR.*, D.dept_name, E.emp_name FROM `prod_iss_rec` AS PIR, dept AS D, employee AS E WHERE PIR.dept_id=D.dept_id AND PIR.employee_id=E.employee_id AND PIR.statu_s=1 ORDER BY prod_iss_rec_id DESC";
		//$QURYtranslist	= "SELECT CONCAT(PO.po_financial_yr,'',PO.po_no) AS poNO, PIR.*, D.dept_name, E.emp_name, PIR.work_status, PIR.notes, FT.fitting_name FROM `prod_iss_rec` AS PIR, dept AS D, employee AS E, po AS PO, fitting AS FT WHERE PIR.fitting_id = FT.fitting_id AND PIR.dept_id = D.dept_id AND PIR.employee_id = E.employee_id AND PIR.statu_s = 1 AND PIR.po_id=PO.po_id ORDER BY prod_iss_rec_id DESC";
		//$QURYtranslist	= "SELECT PIR.*, D.dept_name, E.emp_name, FT.fitting_name FROM `prod_iss_rec` AS PIR, dept AS D, employee AS E, fitting AS FT WHERE PIR.fitting_id = FT.fitting_id AND PIR.dept_id = D.dept_id AND PIR.employee_id = E.employee_id AND PIR.statu_s = 1 ORDER BY prod_iss_rec_id DESC";
		
		//$QURYtranslist	= "SELECT PIR.*, CONCAT(PO.`po_financial_yr`,'',PO.`po_no`) AS poNO, D.dept_name, E.emp_name, FT.fitting_name FROM `prod_iss_rec` AS PIR, `dept` AS D, `employee` AS E, `fitting` AS FT, `PO` AS PO WHERE PIR.fitting_id = FT.fitting_id AND PIR.dept_id = D.dept_id AND PIR.employee_id = E.employee_id AND PIR.statu_s = 1 AND PO.po_id = PIR.po_id AND PIR.trans_date='$nwDate' AND PIR.dept_id='$RSLTlastDeptID' ORDER BY prod_iss_rec_id DESC";
		
		$QURYtranslist	= "SELECT PIR.`jc_no` AS prodISSrecJCno, PIR.po_open_ord_id, PIR.split_flag, PIR.prod_iss_rec_id, PIR.po_id, PIR.trans_no, PIR.trans_date, PIR.notes, PIR.type, PIR.st_wt, PIR.wgt, PIR.no_of_pieces, JC.`jc_no`, D.dept_name, E.emp_name, FT.fitting_name, DATE_FORMAT(PIR.`post_dt`, '%b %d, %Y - %r') AS entryDT FROM `prod_iss_rec` AS PIR, `dept` AS D, `employee` AS E, `fitting` AS FT, `po_open_ord_det` AS JC WHERE PIR.fitting_id = FT.fitting_id AND PIR.dept_id = D.dept_id AND PIR.employee_id = E.employee_id AND PIR.statu_s = 1 AND JC.jc_no = PIR.jc_no AND PIR.type='iss' /*AND PIR.trans_date='$nwDate' AND PIR.dept_id='$RSLTlastDeptID'*/ GROUP BY PIR.po_id, PIR.trans_no ORDER BY PIR.prod_iss_rec_id DESC ".$limitCOND;
		$CONNtranslist	= $connection->executeQuery($QURYtranslist);
		$FTCHtranslist	= $CONNtranslist->fetchAll();
		$prdISSrecRWcn	= count($FTCHtranslist);
		$CONTtranslist	= count($FTCHtranslist) - 1;
		
		
		$issRECtranDATA = "";
		
		for($i=0; $i<=$CONTtranslist; $i++)
		{
/*			$QURYjcNO		= "SELECT `wgt`, `no_of_pieces`, spare_wgt, st_wt, enam_wgt FROM `prod_iss_rec` WHERE `trans_no`='".$FTCHtranslist[$i]['trans_no']."' AND po_id='".$FTCHtranslist[$i]['po_id']."' AND `type`='rec'";
			$CONNjcNO	= $connection->executeQuery($QURYtranRECtyp);
			$FTCHjcNO	= $CONNtranRECtyp->fetchAll();*/
			
			//$QURYtranRECtyp	= "SELECT `split_flag`, `prod_iss_rec_id`, `wgt`, `no_of_pieces`, spare_wgt, st_wt, st_pcs, enam_wgt, cutting_met_wgt FROM `prod_iss_rec` WHERE `trans_no`='".$FTCHtranslist[$i]['trans_no']."' AND po_id='".$FTCHtranslist[$i]['po_id']."' AND `type`='rec'";
			
			$QURYtranRECtyp	= "SELECT `split_flag`, `prod_iss_rec_id`, `wgt`, `no_of_pieces`, spare_wgt, st_wt, st_pcs, enam_wgt, cutting_met_wgt FROM `prod_iss_rec` WHERE `trans_no`='".$FTCHtranslist[$i]['trans_no']."' AND jc_no='".$FTCHtranslist[$i]['jc_no']."' AND `type`='rec'";
			$CONNtranRECtyp	= $connection->executeQuery($QURYtranRECtyp);
			$FTCHtranRECtyp	= $CONNtranRECtyp->fetchAll();
			
			$QURYtranIRtyp	= "SELECT `split_flag`, `prod_iss_rec_id`, `wgt`, `no_of_pieces`, spare_wgt, st_wt, st_pcs, enam_wgt, cutting_met_wgt FROM `prod_iss_rec` WHERE `trans_no`='".$FTCHtranslist[$i]['trans_no']."' AND po_id='".$FTCHtranslist[$i]['po_id']."'";
			$CONNtranIRtyp	= $connection->executeQuery($QURYtranIRtyp);
			$FTCHtranIRtyp	= $CONNtranIRtyp->fetchAll();			
			
			
			#--------[ CHECKING - split status
			$QURYsplitST= "SELECT `act_po_open_ord_det_id` FROM `wax_tree_making_det` WHERE `po_open_ord_det_id`= '".$FTCHtranslist[$i]['po_id']."' AND `act_po_open_ord_det_id`!=0 ORDER BY `wax_tree_making_det_id` ASC";
			$CONNsplitST= $connection->executeQuery($QURYsplitST);
			$FTCHsplitST= $CONNsplitST->fetchAll();
			
			if(!isset($FTCHsplitST[0]['act_po_open_ord_det_id'])){
				$splitSTATUS = 0;	// SPLIT NOT AVAIL THIS ORDER
			} else {
				$splitSTATUS = 1;	// SPLIT AVAIL THIS ORDER
			}			

			if($splitSTATUS == 1)
			{
			$QURYpartyNM	= "SELECT P.concern_name, P.party_name, TREE.jc_no FROM `prod_iss_rec` AS PROD, `wax_tree_making_det` AS TREE, po_open_ord AS POord, party AS P WHERE PROD.prod_iss_rec_id = '".$FTCHtranslist[$i]['prod_iss_rec_id']."' AND PROD.po_id = TREE.po_open_ord_det_id AND PROD.po_open_ord_id=POord.po_open_ord_id AND POord.party_id=P.party_id";
			
			$QURYjcNO	= "SELECT TMD.`wax_tree_making_det_id`, TMD.jc_no FROM `wax_tree_making_det` AS TMD, `po_open_ord_det` AS JC WHERE TMD.po_open_ord_det_id = JC.po_open_ord_det_id AND TMD.`wax_tree_making_det_id` = '".$FTCHtranslist[$i]['po_id']."' ";			
			}
			else if($splitSTATUS == 0)
			{
			//$QURYpartyNM	= "SELECT P.concern_name, P.party_name, TREE.jc_no FROM `prod_iss_rec` AS PROD, `wax_tree_making_det` AS TREE, `po_open_ord` AS JC, `party` AS P WHERE PROD.prod_iss_rec_id = '".$FTCHtranslist[$i]['prod_iss_rec_id']."' AND PROD.po_id=TREE.wax_tree_making_det_id AND TREE.po_open_ord_id=JC.po_open_ord_id AND JC.party_id=P.party_id";
			$QURYpartyNM	= "SELECT P.concern_name, P.party_name, TREE.jc_no FROM `prod_iss_rec` AS PROD, `wax_tree_making_det` AS TREE, `po_open_ord` AS JC, `party` AS P WHERE PROD.prod_iss_rec_id = '".$FTCHtranslist[$i]['prod_iss_rec_id']."' AND PROD.`jc_no` = TREE.`jc_no` AND TREE.`po_open_ord_id` = JC.po_open_ord_id AND JC.party_id = P.party_id";
			
			$QURYjcNO	= "SELECT TMD.`wax_tree_making_det_id`, TMD.jc_no FROM `wax_tree_making_det` AS TMD, `po_open_ord_det` AS JC WHERE TMD.po_open_ord_det_id = JC.po_open_ord_det_id AND TMD.`po_open_ord_det_id` = '".$FTCHtranslist[$i]['po_id']."' ";
			}

			$CONNpartyNM	= $connection->executeQuery($QURYpartyNM);
			$FTCHpartyNM	= $CONNpartyNM->fetchAll();
			$RLSTconceNM	= $FTCHpartyNM[0]['concern_name'];
			$RLSTpartyNM	= $FTCHpartyNM[0]['party_name'];
			$jc_no			= $FTCHpartyNM[0]['jc_no'];
			
			$CONNjcNO	= $connection->executeQuery($QURYjcNO);
			$FTCHjcNO	= $CONNjcNO->fetchAll();
			$jc_no		= $FTCHjcNO[0]['jc_no'];			
			
			if($FTCHtranRECtyp[0]['wgt'] != "")
			{
				$receiveWGT	= number_format($FTCHtranRECtyp[0]['wgt'], 2);
			} 
			else if($FTCHtranRECtyp[0]['wgt'] == "")
			{
				$receiveWGT	= "-";
			}
			
			if($FTCHtranRECtyp[0]['no_of_pieces'] != ""){
				$no_of_pieces = number_format($FTCHtranRECtyp[0]['no_of_pieces']);
			} else if($FTCHtranRECtyp[0]['no_of_pieces'] == ""){
				$no_of_pieces = "-";
			}
			
			if($FTCHtranRECtyp[0]['spare_wgt'] != ""){
				$spare_wgt = number_format($FTCHtranRECtyp[0]['spare_wgt'], 2);
			}else if($FTCHtranRECtyp[0]['spare_wgt'] == 0){
				$spare_wgt = "-";
			}
			
			if($FTCHtranRECtyp[0]['st_wt'] != ""){
				$st_wt = number_format($FTCHtranRECtyp[0]['st_wt'], 2);
			}else if($FTCHtranRECtyp[0]['st_wt'] == 0){
				$st_wt = "-";
			}	
			
			if($FTCHtranRECtyp[0]['st_pcs'] != ""){
				$st_qty = $FTCHtranRECtyp[0]['st_pcs'];
			}else if($FTCHtranRECtyp[0]['st_pcs'] == 0){
				$st_qty = "-";
			}	
			
			if($FTCHtranRECtyp[0]['enam_wgt'] != ""){
				$enam_wgt = number_format($FTCHtranRECtyp[0]['enam_wgt'], 2);
			}else if($FTCHtranRECtyp[0]['enam_wgt'] == 0){
				$enam_wgt = "-";
			}			
			
			if($FTCHtranRECtyp[0]['cutting_met_wgt'] != ""){
				$cut_met_wgt = number_format($FTCHtranRECtyp[0]['cutting_met_wgt'], 2);
			}else if($FTCHtranRECtyp[0]['cutting_met_wgt'] == 0){
				$cut_met_wgt = "-";
			}						
			
			
			#-------- CHECK JC ENTRY's - no of rows
			$QURYchckJCrows = "SELECT COUNT(`prod_iss_rec_id`) AS countJCentries FROM `prod_iss_rec` WHERE `po_id`='".$FTCHtranslist[$i]['po_id']."' ";
			$CONNchckJCrows	= $connection->executeQuery($QURYchckJCrows);
			$FTCHchckJCrows	= $CONNchckJCrows->fetchAll();
			$countJCentries	= $FTCHchckJCrows[0]['countJCentries'];
			
			#-------- GET LATEST JC ENTRY for EDIT OPTION
			$QURYjcLATEST	= "SELECT MAX(`prod_iss_rec_id`) AS JClatestENTRYprimID, work_status FROM `prod_iss_rec` WHERE `po_id`='".$FTCHtranslist[$i]['po_id']."' AND `type`='rec' AND statu_s = 1";
			$CONNjcLATEST	= $connection->executeQuery($QURYjcLATEST);
			$FTCHjcLATEST	= $CONNjcLATEST->fetchAll();

			if(!isset($FTCHjcLATEST[0]['JClatestENTRYprimID']))
			{
				$JClatestENTRYprimID = 0;
			}
			else
			{
				$JClatestENTRYprimID = $FTCHjcLATEST[0]['JClatestENTRYprimID'];
			}
			
			if($FTCHtranIRtyp[0]['split_flag'] == 1)
			{
				$fontCOLORcss = 'style="color:#C8C8C8;"';
			}
			else
			{
				$fontCOLORcss = '';
			}
			
			#-------- GET WORK STATUS of JC	
			$QURYjcWORKstat	= "SELECT prod_iss_rec_id, work_status FROM `prod_iss_rec` WHERE `prod_iss_rec_id`='".$FTCHjcLATEST[0]['JClatestENTRYprimID']."' AND `type`='rec'";
			$CONNjcWORKstat	= $connection->executeQuery($QURYjcWORKstat);
			$FTCHjcWORKstat	= $CONNjcWORKstat->fetchAll();			
			/*
			$issRECtranDATA .= '<tr '.$fontCOLORcss.'> 
									<td title="Serial No." style="text-align:center; vertical-align: middle; width:5%;">'.($i+1).'</td>
									<td title="Concern Name / Party Name" style="text-align:left; vertical-align: middle; width:17%;"><u>'.$RLSTconceNM.'</u> <br> '.$RLSTpartyNM.'</td>
									<td title="Department / Employee Transaction" style="text-align:left; vertical-align: middle; width:15%;"><u>'.$FTCHtranslist[$i]['dept_name'].'</u> <br> '.$FTCHtranslist[$i]['emp_name'].'</td>
									<td title="Job Card No. / Date" style="text-align:left; vertical-align: middle; width:15%;"><u>'.$jc_no.'</u> <br> '.$FTCHtranslist[$i]['entryDT'].'</td>
									<td title=" Iss Weight (grams) / Iss Qty" style="text-align:right; vertical-align: middle; width:15%;">'.number_format($FTCHtranslist[$i]['wgt'], 2).' <small>(Grm)</small><br>'.$FTCHtranslist[$i]['no_of_pieces'].' <small>(No\'s)</small></td>
									<td title="Rec Weight (grams) / Rec Qty" style="text-align:right; vertical-align: middle; width:15%;">'.$receiveWGT.'<br>'.$no_of_pieces.' <small>(No\'s)</small></td>
									<td title="Spare Weight" style="text-align:right; vertical-align: middle; width:15%;">'.$spare_wgt.' <small>(Grm)</small></td>
									<td title="Stone Weight (g)/ Enamel Weight (g)" style="text-align:right; vertical-align: middle;">'.$st_wt.' <small>(g)</small><br>'.$enam_wgt.' <small>(g)</small></td>';
			*/	

			
			if($fontCOLORcss == "")
			{
			//$issRECtranDATA .= '<tr '.$fontCOLORcss.'>';
			$issRECtranDATA .= '<tr>'; 
			$issRECtranDATA .= '	<td title="Serial No." style="text-align:center; vertical-align: middle; width:5%;">'.($start_from+$i+1).'</td>
									<td title="Party Name" style="text-align:left; vertical-align: middle; width:17%;">'.$RLSTpartyNM.'</td>
									<td title="Department" style="text-align:left; vertical-align: middle; width:15%;">'.$FTCHtranslist[$i]['dept_name'].'</td>
									<td title="Employee Transaction" style="text-align:left; vertical-align: middle; width:15%;">'.$FTCHtranslist[$i]['emp_name'].'</td>
									<td title="Job Card No." style="text-align:left; vertical-align: middle; width:15%;">'.$FTCHtranslist[$i]['prodISSrecJCno'].'</td>
									<td title="Date" style="text-align:left; vertical-align: middle; width:15%;">'.$FTCHtranslist[$i]['entryDT'].'</td>
									<td title="Iss Weight" style="text-align:right; vertical-align: middle; width:15%;">'.number_format($FTCHtranslist[$i]['wgt'], 2).'</td>
									<td title="Iss Qty" style="text-align:right; vertical-align: middle; width:15%;">'.$FTCHtranslist[$i]['no_of_pieces'].'</td>
									<td title="Rec Weight (grams)" style="text-align:right; vertical-align: middle; width:15%;">'.$receiveWGT.'</td>
									<td title="Rec Qty" style="text-align:right; vertical-align: middle; width:15%;">'.$no_of_pieces.'</td>
									<td title="Spare Weight" style="text-align:right; vertical-align: middle; width:15%;">'.$spare_wgt.'</td>
									<td title="Stone Weight (g)" style="text-align:right; vertical-align: middle;">'.$st_wt.'</td>
									<td title="Stone Qty" style="text-align:right; vertical-align: middle;">'.$st_qty.'</td>
									<td title="Enamel Weight (g)" style="text-align:right; vertical-align: middle;">'.$enam_wgt.'</td>
									<td title="Cutting Metal Weight (g)" style="text-align:right; vertical-align: middle;">'.$cut_met_wgt.'</td>';			
				
				if($FTCHjcWORKstat[0]['work_status'] != 3 && $FTCHjcWORKstat[0]['work_status'] != 4)
				{
					if($countJCentries == 1)
					{
						if($FTCHtranIRtyp[0]['split_flag'] == 0){
						$issRECtranDATA .= '<td title="Work Status / Action" style="text-align:center; vertical-align: middle;"><a href="prod-iss-rec-data-with-pagination'.$FTCHtranslist[$i]['prod_iss_rec_id'].'?page='.$_GET["page"].'"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a></td>';				
						} else {
						$issRECtranDATA .= '<td title="Work Status / Action" style="text-align:center; vertical-align: middle;"><i class="fa fa-pencil-square-o" aria-hidden="true" style="color:#E8E8E8;"></i></td>';
						}
					}
					else
					{
						if($FTCHtranRECtyp[0]['prod_iss_rec_id'] == $JClatestENTRYprimID && $FTCHtranRECtyp[0]['split_flag'] == 0)
						{
							if(!isset($FTCHtranIRtyp[0]['prod_iss_rec_id']))	//- only 1 row in db ie very 1st entry on table
							{
								$editPRODissRECid = 1;
							}
							else
							{
								$editPRODissRECid = $FTCHtranRECtyp[0]['prod_iss_rec_id'];
							}
							
							$issRECtranDATA .= '<td title="Work Status / Action" style="text-align:center; vertical-align: middle;"><a href="prod-iss-rec-data-with-pagination'.$editPRODissRECid.'?page='.$_GET["page"].'"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a></td>';
						} else {
						$issRECtranDATA .= '<td title="Work Status / Action" style="text-align:center; vertical-align: middle;"><i class="fa fa-pencil-square-o" aria-hidden="true" style="color:#E8E8E8;"></i></td>';
						}
					}
				}
				else if($FTCHjcWORKstat[0]['work_status'] == 3)
				{
					if($FTCHtranRECtyp[0]['prod_iss_rec_id'] == $FTCHjcLATEST[0]['JClatestENTRYprimID'])
					{
						$issRECtranDATA .= '<td title="Work Status / Action" style="text-align:center; vertical-align: middle;"><i class="fa fa-check-circle" style="font-size:17px; color:green"></i> <br> <center><small><b>JC Finished<b></small></center></td>';
					}	
					else
					{
						$issRECtranDATA .= '<td title="Work Status / Action" style="text-align:center; vertical-align: middle;"><i class="fa fa-pencil-square-o" aria-hidden="true" style="color:#E8E8E8;"></i></td>';
					}
				}
				else if($FTCHjcWORKstat[0]['work_status'] == 4)
				{
					//$issRECtranDATA .= '<td title="Work Status / Action" style="text-align:center; vertical-align: middle;"><i class="fa fa-check-circle" style="font-size:17px; color:green"></i> <br> <center><small><b>Return<b></small></center></td>';
					
					if($FTCHtranRECtyp[0]['prod_iss_rec_id'] == $FTCHjcLATEST[0]['JClatestENTRYprimID'])
					{
						$issRECtranDATA .= '<td title="Work Status / Action" style="text-align:center; vertical-align: middle;"><i class="fa fa-check-circle" style="font-size:17px; color:green"></i> <br> <center><small><b>Return<b></small></center></td>';
					}	
					else
					{
						$issRECtranDATA .= '<td title="Work Status / Action" style="text-align:center; vertical-align: middle;"><i class="fa fa-pencil-square-o" aria-hidden="true" style="color:#E8E8E8;"></i></td>';
					}
					
				}
			$issRECtranDATA .= '</tr>';
			}
		}
		
		

		
		#--------[ GET PROD TRANS DATA to UPDATE
		$QURYtransDATA					= "SELECT * FROM `prod_iss_rec` WHERE prod_iss_rec_id='$prodIssRecID'";
		$CONNtransDATA					= $connection->executeQuery($QURYtransDATA);
		$FTCHtransDATA					= $CONNtransDATA->fetchAll();
		//$FTCHtransDATA['metal_status']	= $FTCHtransDATA[0]['metal_status'];
		$FTCHtransDATA['metal_status']	= "";										//-Hidden
		$FTCHtransDATA['po_open_ord_id']= $FTCHtransDATA[0]['po_open_ord_id'];
		$FTCHtransDATA['jc_no']			= $FTCHtransDATA[0]['jc_no'];
		$FTCHtransDATA['type'] 			= $FTCHtransDATA[0]['type'];
		$FTCHtransDATA['trans_no'] 		= $FTCHtransDATA[0]['trans_no'];
		$FTCHtransDATA['trans_date']	= $FTCHtransDATA[0]['trans_date'];
		$FTCHtransDATA['po_id']			= $FTCHtransDATA[0]['po_id'];
		$FTCHtransDATA['dept_id'] 		= $FTCHtransDATA[0]['dept_id'];
		$FTCHtransDATA['employee_id']	= $FTCHtransDATA[0]['employee_id'];
		$FTCHtransDATA['fitting_id']	= $FTCHtransDATA[0]['fitting_id'];	
		$FTCHtransDATA['notes'] 		= $FTCHtransDATA[0]['notes'];
		$FTCHtransDATA['wgt'] 			= $FTCHtransDATA[0]['wgt'];
		$FTCHtransDATA['no_of_pieces']	= $FTCHtransDATA[0]['no_of_pieces'];		
		$FTCHtransDATA['purity'] 		= $FTCHtransDATA[0]['purity'];
		$FTCHtransDATA['work_status']	= $FTCHtransDATA[0]['work_status'];
		$FTCHtransDATA['post_dt']		= $FTCHtransDATA[0]['post_dt'];
		$FTCHtransDATA['enam_wgt']		= $FTCHtransDATA[0]['enam_wgt'];
		$FTCHtransDATA['st_wt']			= $FTCHtransDATA[0]['st_wt'];
		$FTCHtransDATA['st_wt']			= $FTCHtransDATA[0]['st_wt'];
		$FTCHtransDATA['st_pcs']		= $FTCHtransDATA[0]['st_pcs'];
		$FTCHtransDATA['cutMwgt']		= $FTCHtransDATA[0]['cutting_met_wgt'];
		$FTCHtransDATA['post_dt']		= $FTCHtransDATA[0]['post_dt'];
		
		#--------[ GET JC COUNT
		$QURYjcTRANSdata				= "SELECT COUNT(`prod_iss_rec_id`) AS jcTRANsCONT FROM `prod_iss_rec` WHERE po_id='".$FTCHtransDATA['po_id']."'";
		$CONNjcTRANSdata				= $connection->executeQuery($QURYjcTRANSdata);
		$FTCHjcTRANSdata				= $CONNjcTRANSdata->fetchAll();		
		$prdISSrecRWcnJCwise			= $FTCHjcTRANSdata[0]['jcTRANsCONT'];
		
		########-[ GET JC No
		//echo
		//$QURYjcNO	= "SELECT `jc_no` FROM `wax_tree_making_det` WHERE (`po_open_ord_det_id`='".$FTCHtransDATA['po_id']."' AND `act_po_open_ord_det_id`!=0) OR (`wax_tree_making_det_id`='".$FTCHtransDATA['po_id']."' AND `act_po_open_ord_det_id`=0)";
		$QURYjcNO	= "SELECT * FROM `prod_iss_rec` WHERE `prod_iss_rec_id`= '".$prodIssRecID."' ";
		$CONNjcNO	= $connection->executeQuery($QURYjcNO);
		$FTCHjcNO	= $CONNjcNO->fetchAll();	
		$RSLTjcNO	= $FTCHjcNO[0]['jc_no'];			
		
		#--------[ GET PROD TRANS NEXT (rec) DATA to UPDATE
		if($prodIssRecID != 0)
		{
		$QURYtransNXTrecDATA			= "SELECT MIN(`prod_iss_rec_id`) AS prodISSrecID, dept_id, employee_id, trans_date FROM prod_iss_rec WHERE `prod_iss_rec_id` > ".$prodIssRecID." ORDER BY `prod_iss_rec_id`";
		$CONNtransNXTrecDATA			= $connection->executeQuery($QURYtransNXTrecDATA);
		$FTCHtransNXTrecDATA			= $CONNtransNXTrecDATA->fetchAll();
		
		$FTCHtransNXTrecDATA['prodISSrecID']= $FTCHtransNXTrecDATA[0]['prodISSrecID'];
		$FTCHtransNXTrecDATA['trans_date'] 	= $FTCHtransNXTrecDATA[0]['trans_date'];
		$FTCHtransNXTrecDATA['dept_id'] 	= $FTCHtransNXTrecDATA[0]['dept_id'];
		$FTCHtransNXTrecDATA['employee_id']	= $FTCHtransNXTrecDATA[0]['employee_id'];
		}
		else
		{
		$FTCHtransNXTrecDATA['prodISSrecID']= "";
		$FTCHtransNXTrecDATA['trans_date'] 	= "";
		$FTCHtransNXTrecDATA['dept_id'] 	= "";
		$FTCHtransNXTrecDATA['employee_id']	= "";
		}
		
		#--------[ GET PROD NEXT DAY OPEN TRANS - DATE
		$QURYnextTRANSdate		= "SELECT trans_date, dept_id FROM `prod_iss_rec` WHERE `trans_no`='".$FTCHtransDATA['trans_no']."' AND `type`='iss'";
		$CONNnextTRANSdate		= $connection->executeQuery($QURYnextTRANSdate);
		$FTCHnextTRANSdate		= $CONNnextTRANSdate->fetchAll();

		$FTCHnextTRANSdate['trans_date']= $FTCHnextTRANSdate[0]['trans_date'];	
		$FTCHnextTRANSdate['dept_id'] 	= $FTCHnextTRANSdate[0]['dept_id'];		
		
		if($FTCHtransDATA['work_status'] == 1)
		{
			$QURYgetNXTDT	= "SELECT trans_date FROM `prod_iss_rec` WHERE `post_dt`='".$FTCHtransDATA['post_dt']."' AND `type`='iss' AND `trans_no`='".$FTCHtransDATA['trans_no']."'";
			$CONNgetNXTDT	= $connection->executeQuery($QURYgetNXTDT);
			$FTCHgetNXTDT	= $CONNgetNXTDT->fetchAll();			
			$RSLTgetNXTDT	= $FTCHgetNXTDT[0]['trans_date'];
		}
		else
		{
			$RSLTgetNXTDT = "";
		}
		
		if($FTCHtransDATA['dept_id'] == 5 || $FTCHtransDATA['dept_id'] == 11 || $FTCHtransDATA['dept_id'] == 13 || $FTCHtransDATA['dept_id'] == 14)
		{
			$quryISSdataVIEW	= "SELECT PIR.prod_iss_rec_id, CONCAT(P.party_name,' / ',PIR.wgt, ' g / ',PIR.no_of_pieces,' pcs / ') AS issDATAview FROM `prod_iss_rec` AS PIR, PO AS PO, party AS P WHERE PIR.`dept_id`='".$FTCHtransDATA['dept_id']."' AND `type`='iss' AND PIR.po_id='".$FTCHtransDATA['po_id']."' AND PIR.po_id=PO.po_id AND PO.party_id=P.party_id AND PIR.`update_dt`='".$FTCHtransDATA['post_dt']."'";
			
			$stmtISSdataVIEW	= $connection->executeQuery($quryISSdataVIEW);
			$ftchISSdataVIEW	= $stmtISSdataVIEW->fetchAll();	
			$issDATAview		= $ftchISSdataVIEW[0]['issDATAview'];	
		}
		else
		{
			$issDATAview		= "";
		}		
		
		if($request->getMethod() == 'POST')
		{
			$metal_status	= $request->get('metal_status');
			$type			= $request->get('type');
			$tran_no		= $request->get('tran_no');
			$iss_rec_date	= $request->get('iss_rec_date');
			$iss_rec_date 	= explode("-",$iss_rec_date);
			$iss_rec_date 	= $iss_rec_date[2]."-".$iss_rec_date[1]."-".$iss_rec_date[0];
			$po_open_ord_id	= $request->get('po_open_ord_id');		//THIS IS ORDER PRIMARY NO/KEY.
			$po_id			= $request->get('po_id');				//THIS IS JOB CARD NO/KEY.
			$jcNo			= $request->get('jcNoH');	
			$dept			= $request->get('dept');
			$emp			= $request->get('emp');
			$fitting_id		= $request->get('fitting_id');
			$notes			= addcslashes($request->get('notes'), "'");;
			$wgt			= $request->get('wgt');
			$spare_wgt		= $request->get('spare_wgt');
			$STpieces		= $request->get('STpieces');
			$STwgt			= $request->get('STwgt');
			$ENMwgt			= $request->get('ENMwgt');
			$cutMwgt		= $request->get('cutMwgt');
			//$purity		= $request->get('purity');
			$purity			= "91.75";						//THIS FIELD HIDDED IN SCREEN
			//$profit_perc	= $request->get('profit_perc');
			//$pieces		= $request->get('pieces');
			$pieces			= $request->get('jcQTY');
//			$recovery_wgt	= $request->get('recovery_wgt');	//THIS FIELD HIDDED IN SCREEN
			$recovery_wgt   = "";
			$trans_type		= $request->get('trans_type');
			
			$work_status	= $request->get('work_status');	
			$nxtWrkIssTecDat= $request->get('nxt_wrk_iss_rec_date');	
			$nxtWrkIssTecDat= explode("-",$nxtWrkIssTecDat);
			$nxtWrkIssTecDat= $nxtWrkIssTecDat[2]."-".$nxtWrkIssTecDat[1]."-".$nxtWrkIssTecDat[0];			
				
			$next_dept		= $request->get('next_dept');
			$next_emp		= $request->get('next_emp');
			
			$searchRECwgt	= $request->get('searchRECwgt');
			$searchUPDdat	= $request->get('searchUPDdat');
			
			if($request->get('work_status') == ""){
				$work_status	= 0;	
			} else {
				$work_status	= $request->get('work_status');	
			}
			
				
		/*	$qurySPLITstat	= "SELECT `po_open_ord_det_id` FROM `wax_tree_making_det` WHERE `wax_tree_making_det_id`='".$po_id."' AND `act_po_open_ord_det_id`!=0";
			$stmrSPLITstat	= $connection->executeQuery($qurySPLITstat);
			$ftchSPLITstat	= $stmrSPLITstat->fetchAll();	
			
			if(!isset($ftchSPLITstat[0]['po_open_ord_det_id']))
			{
				$po_id = $po_id;
			}
			else
			{
				$po_id = $ftchSPLITstat[0]['po_open_ord_det_id'];				
			}			*/
			
			
			$sessionId  	= $session->get('empId');
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime 	= date("Y-m-d H:i:s");
			
			if($prodIssRecID == 0)
			{
				#--------[ INSERT 
				$QRinsert = "INSERT INTO `prod_iss_rec`(`metal_status`, `type`, `trans_no`, `trans_date`, `po_open_ord_id`, `po_id`, `jc_no`, `dept_id`, `employee_id`, `fitting_id`, `notes`, `wgt`, spare_wgt, `rec_wgt`, enam_wgt, cutting_met_wgt, st_wt, st_pcs, `no_of_pieces`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('$metal_status', '$type', '$tran_no', '$iss_rec_date', '$po_open_ord_id', '$po_id', '$jcNo', '$dept', '$emp', '$fitting_id', '$notes', '$wgt', '$spare_wgt', '$recovery_wgt', '$ENMwgt', '$cutMwgt', '$STwgt', '$STpieces', '$pieces', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);

				if($work_status == "0" && $type == 'rec') 
				{
					$tran_no = str_pad( $tran_no + 1, 4, "0", STR_PAD_LEFT );
					
					$QRinsert = "INSERT INTO `prod_iss_rec`(`metal_status`,`type`, `trans_no`, `trans_date`, `po_open_ord_id`, `po_id`, `jc_no`, `dept_id`, `employee_id`, `fitting_id`, `notes`, `wgt`, spare_wgt, enam_wgt, cutting_met_wgt, st_wt, st_pcs, `no_of_pieces`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('$metal_status', 'iss', '$tran_no', '$iss_rec_date', '$po_open_ord_id', '$po_id', '$jcNo', '$next_dept', '$next_emp', '$fitting_id', '$notes', '$wgt', '$spare_wgt', '$ENMwgt', '$cutMwgt', '$STwgt', '$STpieces', '$pieces', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
					$CNexecut = $connection->executeQuery($QRinsert);					
				} 
				
				if($work_status == 3)
				{
					$updtJCstatus 	= "UPDATE `po_open_ord_det` SET `jc_status`='finished' WHERE `jc_no`='$jcNo'";
					$connJCstatus	= $connection->executeQuery($updtJCstatus);	
				}
				
				#--------				
				$quryCHKjcENTRIES	= "SELECT COUNT(iSSrec.`prod_iss_rec_id`) AS jcENTRYcont, TREE.act_po_open_ord_det_id FROM `prod_iss_rec` AS iSSrec, wax_tree_making_det AS TREE WHERE iSSrec.`jc_no`='".$jcNo."' AND iSSrec.jc_no=TREE.jc_no";
				$stmtCHKjcENTRIES	= $connection->executeQuery($quryCHKjcENTRIES);
				$ftchCHKjcENTRIES	= $stmtCHKjcENTRIES->fetchAll();
				
				if($ftchCHKjcENTRIES[0]['jcENTRYcont'] >= 2)
				{
				#--------
				$updtJCdltFLAG 		= "UPDATE `wax_tree_making_det` SET `jc_dlt_flag`='2' WHERE `act_po_open_ord_det_id`='".$ftchCHKjcENTRIES[0]['act_po_open_ord_det_id']."' ";
				$connJCdltFLAG		= $connection->executeQuery($updtJCdltFLAG);	
				}
			
/*				if(($dept == 5 || $dept == 11 || $dept == 13 || $dept == 14) && ($type == 'rec'))
				{
					########-[ UPDATE REC WGT - Only for Papper Wheel, Buff, Buff Wheel, Magnet
					$QRupdate = "UPDATE `prod_iss_rec` SET `rec_wgt`='$wgt', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `prod_iss_rec_id`='$work_status'";
					$CNexecut = $connection->executeQuery($QRupdate);
					
					$work_status = 0; #-- AFTER ABOVE UPDATE, REGULAT REC. WGT ENTRY POSTED WITH WORK STATUS 0 As DEFAULT as WORK STATUS CLOSED AUTOMATICALLY
				}
				
				if($dept == 1)	#--------[ INSERT STONE SETTINGS(DEPT) - CONDITION
				{
					########-[ INSERT STONE SETTINGS with (ST WGT, ST PCS)
					$QRinsert = "INSERT INTO `prod_iss_rec`(`type`, `trans_no`, `trans_date`, `po_id`, `dept_id`, `employee_id`, `fitting_id`, `notes`, `wgt`, `no_of_pieces`, `st_wt`, `st_pcs`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('$type', '$tran_no', '$iss_rec_date', '$po_id', '$dept', '$emp', '$fitting_id', '$notes', '$wgt', '$pieces', '".$request->get('STwgt')."', '".$request->get('STpieces')."', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
					$CNexecut = $connection->executeQuery($QRinsert);
					
					//if($work_status == "1" && $type == 'rec') #----[ OPEN status into ISSUE 
					if($work_status == "0" && $type == 'rec') #----[ OPEN status into ISSUE 
					{
						$nxt_wrk_iss_rec_date 	= explode("-",$request->get('nxt_wrk_iss_rec_date'));
						$nxt_wrk_iss_rec_date 	= $nxt_wrk_iss_rec_date[2]."-".$nxt_wrk_iss_rec_date[1]."-".$nxt_wrk_iss_rec_date[0];

						########-[ WORK STATUS - OPEN will be INSERTED AUTOMATICALLY TO ISSUE OF NEXT DAY/SELECTED DATE
						//$QRinstOPtoISS = "INSERT INTO `prod_iss_rec`(`type`, `trans_no`, `trans_date`, `po_id`, `dept_id`, `employee_id`, `fitting_id`, `notes`, `wgt`, `no_of_pieces`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('iss', '$tran_no', '".$nxt_wrk_iss_rec_date."', '$po_id', '$dept', '$emp', '$fitting_id', '$notes', '$wgt', '$pieces', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
						$QRinstOPtoISS = "INSERT INTO `prod_iss_rec`(`type`, `trans_no`, `trans_date`, `po_id`, `dept_id`, `employee_id`, `fitting_id`, `notes`, `wgt`, `no_of_pieces`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('iss', '$tran_no', '".$nxt_wrk_iss_rec_date."', '$po_id', '$next_dept', '".$request->get('next_emp')."', '$fitting_id', '$notes', '$wgt', '$pieces', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
						$CNexecOPtoISS = $connection->executeQuery($QRinstOPtoISS);
					}					
				}
				else	#--------[ INSERT OTHER DEPT - CONDITION
				{
					########-[ INSERT OTHER DEPT without (ST WGT, ST PCS)
					$QRinsert = "INSERT INTO `prod_iss_rec`(`type`, `trans_no`, `trans_date`, `po_id`, `dept_id`, `employee_id`, `fitting_id`, `notes`, `wgt`, `rec_wgt`, `no_of_pieces`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('$type', '$tran_no', '$iss_rec_date', '$po_id', '$dept', '$emp', '$fitting_id', '$notes', '$wgt', '$recovery_wgt', '$pieces', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
					$CNexecut = $connection->executeQuery($QRinsert);

					if($dept == 13 && $type == 'rec') #-------- WHILE REC IN BUFF DEPT. AUTOMATICALLY IT INSERTS Sandblast too
					{
						$QRinsert = "INSERT INTO `prod_iss_rec`(`type`, `trans_no`, `trans_date`, `po_id`, `dept_id`, `employee_id`, `fitting_id`, `notes`, `wgt`, `no_of_pieces`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('iss', '$tran_no', '$iss_rec_date', '$po_id', '10', '$emp', '$fitting_id', '$notes', '$wgt', '$pieces', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
						$CNexecut = $connection->executeQuery($QRinsert);					
					}
					
					if($work_status == "1" && $type == 'rec') #----[ OPEN status into ISSUE 
					{
						$nxt_wrk_iss_rec_date 	= explode("-",$request->get('nxt_wrk_iss_rec_date'));
						$nxt_wrk_iss_rec_date 	= $nxt_wrk_iss_rec_date[2]."-".$nxt_wrk_iss_rec_date[1]."-".$nxt_wrk_iss_rec_date[0];

						########-[ WORK STATUS - OPEN will be INSERTED AUTOMATICALLY TO ISSUE OF NEXT DAY/SELECTED DATE
						$QRinstOPtoISS = "INSERT INTO `prod_iss_rec`(`type`, `trans_no`, `trans_date`, `po_id`, `dept_id`, `dept_flag`, `employee_id`, `fitting_id`, `notes`, `wgt`, `no_of_pieces`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('iss', '$tran_no', '".$nxt_wrk_iss_rec_date."', '$po_id', '$dept', 's', '$emp', '$fitting_id', '$notes', '$wgt', '$pieces', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
						$CNexecOPtoISS = $connection->executeQuery($QRinstOPtoISS);
					}
					else if($type == 'rec' && $work_status == "0" && $next_dept != "")	#----[ CLOSING status inserted to next department
					{
						$nxt_wrk_iss_rec_date 	= explode("-",$request->get('nxt_wrk_iss_rec_date'));
						$nxt_wrk_iss_rec_date 	= $nxt_wrk_iss_rec_date[2]."-".$nxt_wrk_iss_rec_date[1]."-".$nxt_wrk_iss_rec_date[0];

						########-[ WORK STATUS - CLOSE will be INSERTED AUTOMATICALLY TO NEXT DEPARTMENT in ISSUE
						$QRinstOPtoISS = "INSERT INTO `prod_iss_rec`(`type`, `trans_no`, `trans_date`, `po_id`, `dept_id`, `dept_flag`, `employee_id`, `fitting_id`, `notes`, `wgt`, `no_of_pieces`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('iss', '$tran_no', '".$nxt_wrk_iss_rec_date."', '$po_id', '$next_dept', 's', '".$request->get('next_emp')."', '$fitting_id', '$notes', '$wgt', '$pieces', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
						$CNexecOPtoISS = $connection->executeQuery($QRinstOPtoISS);					
					}
				}*/
			}
			else
			{
				if($prdISSrecRWcn == 1)
				{	
														/* `po_open_ord_id`='$po_open_ord_id', `po_id`='$po_id', */
					$qury = "UPDATE `prod_iss_rec` SET `employee_id`='$emp', `notes`='$notes', `no_of_pieces`='$pieces', `wgt`='$wgt', `enam_wgt`='$ENMwgt', `st_pcs`='$STpieces', `st_wt`='$STwgt', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `prod_iss_rec_id`='$prodIssRecID'";
					$exec = $connection->executeQuery($qury);
				}
				else
				{
					if($prdISSrecRWcnJCwise == 1)
					{
					
						$qury = "UPDATE `prod_iss_rec` SET `employee_id`='$emp', `notes`='$notes', `no_of_pieces`='$pieces', `wgt`='$wgt', `enam_wgt`='$ENMwgt', `st_pcs`='$STpieces', `st_wt`='$STwgt', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `prod_iss_rec_id`='$prodIssRecID'";
						$exec = $connection->executeQuery($qury);					
					}
					else
					{
						$qury1 = "UPDATE `prod_iss_rec` SET `notes`='$notes', `no_of_pieces`='$pieces', `wgt`='$wgt', `enam_wgt`='$ENMwgt', `st_pcs`='$STpieces', `st_wt`='$STwgt', `work_status`='$work_status', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `prod_iss_rec_id`='$prodIssRecID'";
						$exec1 = $connection->executeQuery($qury1);

						$qury2 = "UPDATE `prod_iss_rec` SET `no_of_pieces`='$pieces', `wgt`='$wgt', `enam_wgt`='$ENMwgt', `trans_date`='$nxtWrkIssTecDat', `dept_id`='$next_dept', `employee_id`='$next_emp', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `prod_iss_rec_id`='".$FTCHtransNXTrecDATA['prodISSrecID']."'";
						$exec2 = $connection->executeQuery($qury2);
					}
				}

				/*				
				if(($dept == 5 || $dept == 11 || $dept == 13 || $dept == 14) && ($type == 'rec'))
				{
					########-[ UPDATE REC WGT - Only for Papper Wheel, Buff, Buff Wheel
					$QRupdate = "UPDATE `prod_iss_rec` SET `rec_wgt`='$wgt' WHERE `rec_wgt`='$searchRECwgt' AND `dept_id`='$dept' AND `update_dt`='$searchUPDdat'";
					$CNexecut = $connection->executeQuery($QRupdate);
					
					$work_status = 0; #-- AFTER ABOVE UPDATE, REGULAT REC. WGT ENTRY POSTED WITH WORK STATUS 0 As DEFAULT as WORK STATUS CLOSED AUTOMATICALLY
				}
				
				if($dept == 1)	#--------[ UPDATE STONE SETTINGS(DEPT) - CONDITION
				{			
					########-[ UPDATE STONE SETTINGS with (ST WGT, ST PCS)
					$QRupdate = "UPDATE `prod_iss_rec` SET `type`='$type', `trans_no`='$tran_no', `trans_date`='$iss_rec_date', `po_id`='$po_id', `dept_id`='$dept', `employee_id`='$emp', `fitting_id`='$fitting_id', `notes`='$notes', `wgt`='$wgt', spare_wgt='$spare_wgt', enam_wgt='$ENMwgt', st_wt='$STwgt', `purity`='$purity', `no_of_pieces`='$pieces', `st_wt`='".$request->get('STwgt')."', `st_pcs`='".$request->get('STpieces')."', `work_status`='$work_status', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `prod_iss_rec_id`='$prodIssRecID'";
					$CNexecut = $connection->executeQuery($QRupdate);
					
					if($work_status == "1" && $type == 'rec') #----[ OPEN status into ISSUE 
					{
						$nxt_wrk_iss_rec_date 	= explode("-",$request->get('nxt_wrk_iss_rec_date'));
						$nxt_wrk_iss_rec_date 	= $nxt_wrk_iss_rec_date[2]."-".$nxt_wrk_iss_rec_date[1]."-".$nxt_wrk_iss_rec_date[0];
						
						########-[	GETTING RELATED ROW to UPDATE
						$SLCTgetID 	= "SELECT `trans_no`, `post_dt` FROM `prod_iss_rec` WHERE `prod_iss_rec_id`='$prodIssRecID'";
						$CONNgetID 	= $connection->executeQuery($SLCTgetID);
						$FTCHgetID 	= $CONNgetID->fetchAll();
						$trans_no	= $FTCHgetID[0]['trans_no'];
						$RSLTpostDt = $FTCHgetID[0]['post_dt'];

						########-[ WORK STATUS - OPEN will be UPDATE AUTOMATICALLY TO ISSUE OF NEXT DAY/SELECTED DATE
						//echo
						$QRupdateOPtoISS = "UPDATE `prod_iss_rec` SET `type`='iss', `trans_no`='$tran_no', `trans_date`='".$nxt_wrk_iss_rec_date."', `po_id`='$po_id', `dept_id`='$dept', `employee_id`='$emp', `fitting_id`='$fitting_id', `notes`='$notes', `wgt`='$wgt', spare_wgt='$spare_wgt', enam_wgt='$ENMwgt', st_wt='$STwgt', `purity`='$purity', `no_of_pieces`='$pieces', `work_status`='$work_status', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `post_dt`='$RSLTpostDt' AND `type`='iss' AND `trans_no`='$trans_no'";
						$CNexecutOPtoISS = $connection->executeQuery($QRupdateOPtoISS);						
					}					
				}
				else	#--------[ UPDATE OTHER DEPT - CONDITION
				{
					########-[ UPDATE OTHER DEPT without (ST WGT, ST PCS)
					$QRupdate = "UPDATE `prod_iss_rec` SET `type`='$type', `trans_no`='$tran_no', `trans_date`='$iss_rec_date', `po_id`='$po_id', `dept_id`='$dept', `employee_id`='$emp', `fitting_id`='$fitting_id', `notes`='$notes', `wgt`='$wgt', spare_wgt='$spare_wgt', enam_wgt='$ENMwgt', st_wt='$STwgt', `rec_wgt`='$recovery_wgt', `purity`='$purity', `no_of_pieces`='$pieces', `work_status`='$work_status', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `prod_iss_rec_id`='$prodIssRecID'";
					$CNexecut = $connection->executeQuery($QRupdate);

					if($work_status == "1" && $type == 'rec') #----[ OPEN status into ISSUE 
					{
						$nxt_wrk_iss_rec_date 	= explode("-",$request->get('nxt_wrk_iss_rec_date'));
						$nxt_wrk_iss_rec_date 	= $nxt_wrk_iss_rec_date[2]."-".$nxt_wrk_iss_rec_date[1]."-".$nxt_wrk_iss_rec_date[0];
						
						########-[	GETTING RELATED ROW to UPDATE
//						$SLCTgetID 	= "SELECT `trans_no`, `post_dt` FROM `prod_iss_rec` WHERE `prod_iss_rec_id`='$prodIssRecID'";
						$SLCTgetID 	= "SELECT `trans_no`, `post_dt` FROM `prod_iss_rec` WHERE `trans_no`='$tran_no'";
						$CONNgetID 	= $connection->executeQuery($SLCTgetID);
						$FTCHgetID 	= $CONNgetID->fetchAll();
						$CONTgetID 	= count($FTCHgetID);
						$trans_no	= $FTCHgetID[0]['trans_no'];
						$RSLTpostDt = $FTCHgetID[0]['post_dt'];
						
						########-[ WORK STATUS - OPEN will be UPDATE AUTOMATICALLY TO ISSUE OF NEXT DAY/SELECTED DATE
//						$QRupdateOPtoISS = "UPDATE `prod_iss_rec` SET `type`='iss', `trans_no`='$tran_no', `trans_date`='".$nxt_wrk_iss_rec_date."', `po_id`='$po_id', `dept_id`='$dept', `employee_id`='$emp', `fitting_id`='$fitting_id', `notes`='$notes', `wgt`='$wgt', `purity`='$purity', `no_of_pieces`='$pieces', `work_status`='$work_status', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `post_dt`='$RSLTpostDt' AND `type`='iss' AND `trans_no`='$trans_no'";
//						$CNexecutOPtoISS = $connection->executeQuery($QRupdateOPtoISS);			
						
						if($CONTgetID == 1)
						{
							########-[ WORK STATUS - OPEN will be INSERTED AUTOMATICALLY TO ISSUE OF NEXT DAY/SELECTED DATE
							$QRinstOPtoISS = "INSERT INTO `prod_iss_rec`(`type`, `trans_no`, `trans_date`, `po_id`, `dept_id`, `employee_id`, `fitting_id`, `notes`, `wgt`, spare_wgt, enam_wgt, st_wt, `no_of_pieces`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('iss', '$tran_no', '".$nxt_wrk_iss_rec_date."', '$po_id', '$dept', '$emp', '$fitting_id', '$notes', '$wgt', '$spare_wgt', '$ENMwgt', '$STwgt', '$pieces', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
							$CNexecOPtoISS = $connection->executeQuery($QRinstOPtoISS);
						}
						else if($CONTgetID == 2)
						{
							########-[ WORK STATUS - OPEN will be UPDATE AUTOMATICALLY TO ISSUE OF NEXT DAY/SELECTED DATE
							$QRupdateOPtoISS = "UPDATE `prod_iss_rec` SET `trans_no`='$tran_no', `trans_date`='".$nxt_wrk_iss_rec_date."', `po_id`='$po_id', `dept_id`='$dept', `employee_id`='$emp', `fitting_id`='$fitting_id', `notes`='$notes', `wgt`='$wgt', spare_wgt='$spare_wgt', enam_wgt='$ENMwgt', st_wt='$STwgt', `purity`='$purity', `no_of_pieces`='$pieces', `work_status`='$work_status', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `type`='iss' AND `trans_no`='$trans_no'"; // `post_dt`='$RSLTpostDt' AND 
							$CNexecutOPtoISS = $connection->executeQuery($QRupdateOPtoISS);						
						
						}
					}
					else if($type == 'rec' && $work_status == "0" && $next_dept == "")
					{
						########-[	GETTING ID to DELETE ISSUED ON NEXT DAY/SELECTED DATE
						$QURYdltISS	= "DELETE FROM `prod_iss_rec` WHERE `trans_no`='$tran_no' AND `type`='iss'";
						$CONNdltISS	= $connection->executeQuery($QURYdltISS);
					}	
					else if($type == 'rec' && $work_status == "0" && $next_dept != "")
					{
						$nxt_wrk_iss_rec_date 	= explode("-",$request->get('nxt_wrk_iss_rec_date'));
						$nxt_wrk_iss_rec_date 	= $nxt_wrk_iss_rec_date[2]."-".$nxt_wrk_iss_rec_date[1]."-".$nxt_wrk_iss_rec_date[0];
						
						########-[ GETTING ID to UPDATE row ON NEXT DAY/SELECTED DATE
						$SLCTgetIDtoUPD	= "SELECT MAX(`prod_iss_rec_id`) AS dltID, COUNT(`trans_no`) AS cntTRANno FROM `prod_iss_rec` WHERE `trans_no`='$tran_no'";
						$CONNgetIDtoUPD	= $connection->executeQuery($SLCTgetIDtoUPD);
						$FTCHgetIDtoUPD	= $CONNgetIDtoUPD->fetchAll();
						$RSLTgetIDtoUPD	= $FTCHgetIDtoUPD[0]['dltID'];
						$RSLTcntTRANno	= $FTCHgetIDtoUPD[0]['cntTRANno'];
						
						if($RSLTcntTRANno == 1)	#--------[ INSERTING DATA's TO NEXT DEPT. while updating 
						{
							$QRinstOPtoISS = "INSERT INTO `prod_iss_rec`(`type`, `trans_no`, `trans_date`, `po_id`, `dept_id`, `dept_flag`, `employee_id`, `fitting_id`, `notes`, `wgt`, spare_wgt, enam_wgt, st_wt, `no_of_pieces`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('iss', '$tran_no', '".$nxt_wrk_iss_rec_date."', '$po_id', '$next_dept', 's', '".$request->get('next_emp')."', '$fitting_id', '$notes', '$wgt', '$spare_wgt', '$ENMwgt', '$STwgt', '$pieces', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
							$CNexecOPtoISS = $connection->executeQuery($QRinstOPtoISS);
						}
						else if($RSLTcntTRANno == 2)	#--------[ UPDATING DATA's TO NEXT DEPT. while updating 
						{
							$QRupdate = "UPDATE `prod_iss_rec` SET `type`='iss', `trans_no`='$tran_no', `trans_date`='".$nxt_wrk_iss_rec_date."', `po_id`='$po_id', `dept_id`='$next_dept', `employee_id`='".$request->get('next_emp')."', `fitting_id`='$fitting_id', `notes`='$notes', `wgt`='$wgt', spare_wgt='$spare_wgt', enam_wgt='$ENMwgt', st_wt='$STwgt', `purity`='$purity', `no_of_pieces`='$pieces', `work_status`='$work_status', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `prod_iss_rec_id`='$RSLTgetIDtoUPD'";
							$CNexecut = $connection->executeQuery($QRupdate);
						}
					}	
					else if($type == 'iss')
					{
						########-[ GETTING ID to DELETE ISSUED ON NEXT DAY/SELECTED DATE
						$SLCTgetIDtoDLT	= "SELECT MAX(`prod_iss_rec_id`) AS dltID, count(`trans_no`) AS contTRANno FROM `prod_iss_rec` WHERE `trans_no`='$tran_no'";
						$CONNgetIDtoDLT	= $connection->executeQuery($SLCTgetIDtoDLT);
						$FTCHgetIDtoDLT	= $CONNgetIDtoDLT->fetchAll();
						$RSLTgetIDtoDLT	= $FTCHgetIDtoDLT[0]['dltID'];
						
						if($contTRANno == 2)
						{
						########-[ DELETE ISSUED ON NEXT DAY/SELECTED DATE
						$QURYdltISS	= "DELETE FROM `prod_iss_rec` WHERE `prod_iss_rec_id`='".$RSLTgetIDtoDLT."' AND `type`='iss'";
						$CONNdltISS	= $connection->executeQuery($QURYdltISS);
						}
					}						
				}
				*/
			}
			
//die();
		return $this->redirectToRoute('prod-iss-rec-data-with-pagination', array('prodIssRecID' => $prodIssRecID, 'page' => $_GET['page']) );		
		}


		########-[ GET No. of PAGE's
		$QURYpages	= "SELECT PIR.`jc_no` AS prodISSrecJCno, PIR.po_open_ord_id, PIR.split_flag, PIR.prod_iss_rec_id, PIR.po_id, PIR.trans_no, PIR.trans_date, PIR.notes, PIR.type, PIR.st_wt, PIR.wgt, PIR.no_of_pieces, JC.`jc_no`, D.dept_name, E.emp_name, FT.fitting_name, DATE_FORMAT(PIR.`post_dt`, '%b %d, %Y - %r') AS entryDT FROM `prod_iss_rec` AS PIR, `dept` AS D, `employee` AS E, `fitting` AS FT, `po_open_ord_det` AS JC WHERE PIR.fitting_id = FT.fitting_id AND PIR.dept_id = D.dept_id AND PIR.employee_id = E.employee_id AND PIR.statu_s = 1 AND JC.jc_no = PIR.jc_no AND PIR.type='iss' /*AND PIR.trans_date='$nwDate' AND PIR.dept_id='$RSLTlastDeptID'*/ GROUP BY PIR.po_id, PIR.trans_no ORDER BY PIR.prod_iss_rec_id DESC";
		$CONNpages	= $connection->executeQuery($QURYpages);
		$FTCHpages	= count($CONNpages->fetchAll());
		
		$total_pages = ceil($FTCHpages/$record_per_page);
		$start_loop  = $page;
		$difference  = $total_pages - $page;
		
		if($difference <= 10){
			$start_loop = $total_pages - 10;
		}
			$end_loop = $start_loop + (9);			
		
		return $this->render('prod-iss-rec/prod-iss-rec-data-with-pagination.html.twig', [
			'poLIST' => $FTCHpoLIST,
			//'jcLIST' => $FTCHjcLIST,
			'jcLIST' => $jcLIST,
			'transNO' => $RSLTtransNO,
			'deptlist' => $FTCHdeptlist,
			'emplist' => $FTCHemplist,
			'fittingsLT' => $FTCHfittingsLT,
			'prodTRANSlist' => $FTCHtranslist,
			'issRECtranDATA' => $issRECtranDATA,
			'FTCHtransDATA' => $FTCHtransDATA,
			'issDATAview' => $issDATAview,
			'RSLTgetNXTDT' => $RSLTgetNXTDT,
			'FTCHnextTRANSdate' => $FTCHnextTRANSdate,
			'FTCHtransNXTrecDATA' => $FTCHtransNXTrecDATA,
			'prdISSrecRWcn' => $prdISSrecRWcn,
			'jcNO' => $RSLTjcNO,
			'page' => $page,
			'record_per_page' => $record_per_page,
			'start_from' => $start_from,
			'start_loop' => $start_loop,
			'end_loop' => $end_loop,
			'total_pages' => $total_pages,
			'searchQRYrslt' => $FTCHpages,
			'controller_name' => 'ProductionIssueReceiveController'
        ]);
    }
	
	
    /**
     * @Route("/issRecLossTODAYvalue", name="issRecLossTODAYvalue")
     */
    public function issRecLossTODAYvalueAJAX(Request $request) 
    {
		$connection	= $this->getDoctrine()->getManager()->getConnection();
		
		$po_id		= $request->get('po_id');
		$jc_noVAL	= $request->get('jc_noVAL');
		$issRCty	= $request->get('issRCt');
		$deptID		= $request->get('deptID');
		$issDate 	= $request->get('isredt');
		$issDate 	= explode("-",$request->get('isredt'));
		$issDate 	= $issDate[2]."-".$issDate[1]."-".$issDate[0];
//		$issDate    = date("Y-m-d");
		$workSt 	= $request->get('workSt');
		
//		$quryISS	= "SELECT SUM(`wgt`) AS issWGT FROM `prod_iss_rec` WHERE `trans_date`='".$issDate."' AND `dept_id`='$deptID' AND `type`='iss'";
//		$quryISS	= "SELECT SUM(`wgt`) AS issWGT, SUM(`st_wt`) AS TOTissStWgt FROM `prod_iss_rec` WHERE `trans_date`='".$issDate."' AND `dept_id`='$deptID' AND `type`='iss'";
		$quryISS	= "SELECT SUM(`wgt`) AS issWGT, SUM(`st_wt`) AS TOTissStWgt FROM `prod_iss_rec` WHERE `po_id`='".$po_id."' AND `dept_id`='$deptID' AND `type`='iss'";
		$stmtISS	= $connection->executeQuery($quryISS);
		$ftchISS	= $stmtISS->fetchAll();
		$issWGT		= $ftchISS[0]['issWGT'];
		$STissWGT	= $ftchISS[0]['TOTissStWgt'];
		
//		$quryREC	= "SELECT SUM(`wgt`) AS recWGT FROM `prod_iss_rec` WHERE `trans_date`='".$issDate."' AND `dept_id`='$deptID' AND `type`='rec'";
//		$quryREC	= "SELECT SUM(`wgt`) AS recWGT, SUM(`st_wt`) AS TOTrecStWgt FROM `prod_iss_rec` WHERE `trans_date`='".$issDate."' AND `dept_id`='$deptID' AND `type`='rec'";
		$quryREC	= "SELECT SUM(`wgt`) AS recWGT, SUM(`st_wt`) AS TOTrecStWgt FROM `prod_iss_rec` WHERE `po_id`='".$po_id."' AND `dept_id`='$deptID' AND `type`='rec'";
		$stmtREC	= $connection->executeQuery($quryREC);
		$ftchREC	= $stmtREC->fetchAll();	
		$recWGT		= $ftchREC[0]['recWGT'];
		$STrecWGT	= $ftchREC[0]['TOTrecStWgt'];
		
//		$lossProf   = -$issWGT + $recWGT;
		
		########-[ FETCH - ST LOSS/PROFIT CAL
		$STlossPROFIT	= -$STissWGT + $STrecWGT;
//		$STlossPROFIT	= $STissWGT - $STrecWGT;
		
		########-[ FETCH - LOSS/PROFIT CAL
		$lossProf		= (-$issWGT + $recWGT)+$STlossPROFIT;
//		$lossPROFIT		= ($issWGT - $recWGT)+$STlossPROFIT;
	
	
		if($deptID == 1)
		{
/*		$issRECdata 	= '<button type="button" class="btn btn-primary" style="font-weight:bold">
								Showing Date of <span class="badge badge-transparent" style="font-weight:bold" id="reportDATE">'.$request->get('isredt').'</span>
							</button>';*/
		$issRECdata 	= '<button type="button" class="btn btn-primary" style="font-weight:bold">
								Showing JC No. <span class="badge badge-transparent" style="font-weight:bold" id="reportDATE">'.$jc_noVAL.'</span>
							</button>
							<button type="button" class="btn btn-primary" style="font-weight:bold">
								M Iss <span class="badge badge-transparent" style="font-weight:bold" id="CRNTissWGT">'.number_format($issWGT, 2).'</span>
							</button>
							<button type="button" class="btn btn-primary" style="font-weight:bold">
								M Rec <span class="badge badge-transparent" style="font-weight:bold" id="CRNTrecWGT">'.number_format($recWGT, 2).'</span>
							</button>
							<button type="button" class="btn btn-primary" style="font-weight:bold">
								M P/L <span class="badge badge-transparent" style="font-weight:bold" id="CRNTlsProf">'.number_format($lossProf, 2).'</span>
							</button>
							<br><br>
							<button type="button" class="btn btn-primary" style="font-weight:bold">
								S Iss <span class="badge badge-transparent" style="font-weight:bold">'.number_format($STissWGT, 2).'</span>
							</button>
							<button type="button" class="btn btn-primary" style="font-weight:bold">
								S Rec <span class="badge badge-transparent" style="font-weight:bold">'.number_format($STrecWGT, 2).'</span>
							</button>
							<button type="button" class="btn btn-primary" style="font-weight:bold">
								S P/L <span class="badge badge-transparent" style="font-weight:bold">'.number_format($STlossPROFIT, 2).'</span>
							</button>';
		}
		else
		{
/*		$issRECdata 	= '<button type="button" class="btn btn-primary" style="font-weight:bold">
								Showing Date of <span class="badge badge-transparent" style="font-weight:bold" id="reportDATE">'.$request->get('isredt').'</span>
							</button>';*/
		$issRECdata 	= '<button type="button" class="btn btn-primary" style="font-weight:bold">
								Showing JC No. <span class="badge badge-transparent" style="font-weight:bold" id="reportDATE">'.$jc_noVAL.'</span>
							</button>							
							<button type="button" class="btn btn-primary" style="font-weight:bold">
								M Iss <span class="badge badge-transparent" style="font-weight:bold" id="CRNTissWGT">'.number_format($issWGT, 2).'</span>
							</button>
							<button type="button" class="btn btn-primary" style="font-weight:bold">
								M Rec <span class="badge badge-transparent" style="font-weight:bold" id="CRNTrecWGT">'.number_format($recWGT, 2).'</span>
							</button>
							<button type="button" class="btn btn-primary" style="font-weight:bold">
								M P/L <span class="badge badge-transparent" style="font-weight:bold" id="CRNTlsProf">'.number_format($lossProf, 2).'</span>
							</button>';
		}					
		
/*		if($deptID == 11)
		{
			$quryISSdata	= "SELECT PIR.prod_iss_rec_id,CONCAT(P.party_name,' / ',PIR.no_of_pieces,' / ',PIR.wgt) AS issDATA FROM `prod_iss_rec` AS PIR, PO AS PO, party AS P WHERE PIR.`dept_id`='$deptID' AND PIR.`rec_wgt`='' AND PIR.po_id=PO.po_id AND PO.party_id=P.party_id ORDER BY PIR.prod_iss_rec_id ASC";
			$stmtISSdata	= $connection->executeQuery($quryISSdata);
			$ftchISSdata	= $stmtISSdata->fetchAll();			
			
			//$rslt = $request->get('isredt')."#*#".number_format($issWGT, 2)."#*#".number_format($recWGT, 2)."#*#".number_format($lossProf, 2)."#*#".$ftchISSdata;
			$rslt = $ftchISSdata;
		}
		else
		{
			$rslt = $request->get('isredt')."#*#".number_format($issWGT, 2)."#*#".number_format($recWGT, 2)."#*#".number_format($lossProf, 2);
		}	*/
		
/*		if($issRCty != "" && $deptID != "" && $issDate != "" && $workSt != "")
		{
			$whereCOND = "AND PIR.trans_date='".$issDate."' AND PIR.dept_id='".$deptID."' AND `type`='".$issRCty."' AND `work_status`='".$workSt."'";
		}
		else if($issDate != "" && $deptID != "")
		{
			$whereCOND = "AND PIR.trans_date='".$issDate."' AND PIR.dept_id='".$deptID."'";
		}*/
		
		$whereCOND = "AND PIR.trans_date='".$issDate."' AND PIR.dept_id='".$deptID."'";
		
		$QURYtranslistAJAX	= "SELECT PIR.*, CONCAT(PO.`po_financial_yr`,'',PO.`po_no`) AS poNO, D.dept_name, E.emp_name, FT.fitting_name FROM `prod_iss_rec` AS PIR, `dept` AS D, `employee` AS E, `fitting` AS FT, `PO` AS PO WHERE PIR.fitting_id = FT.fitting_id AND PIR.dept_id = D.dept_id AND PIR.employee_id = E.employee_id AND PIR.statu_s = 1 AND PO.po_id = PIR.po_id ".$whereCOND." ORDER BY prod_iss_rec_id DESC";
		$CONNtranslistAJAX	= $connection->executeQuery($QURYtranslistAJAX);
		$FTCHtranslistAJAX	= $CONNtranslistAJAX->fetchAll();		
		
		$data = "";
		
/*		if(count($FTCHtranslistAJAX == 0))
		{
			$data .= '<tr>
						<td title="Serial No." style="text-align:center; vertical-align: middle;">'.($i+1).'</td>
					  </tr>';	
		}	*/		
		
		for($i=0; $i<=(count($FTCHtranslistAJAX)-1); $i++)	
		{
			$data .= '<tr>
						<td title="Serial No." style="text-align:center; vertical-align: middle;">'.($i+1).'</td>
						<td title="Production Issue / Receive - Transaction No." style="text-align:left; vertical-align: middle;">'.$FTCHtranslistAJAX[$i]['trans_no'].' <br> '.$FTCHtranslistAJAX[$i]['trans_date'].'</td>
						<td title="Production - Department / Employee Transaction" style="text-align:left; vertical-align: middle;">'.$FTCHtranslistAJAX[$i]['dept_name'].' <br> '.$FTCHtranslistAJAX[$i]['emp_name'].'</td>
						<td title="Production Trans. Particulars / Notes" style="text-align:left; vertical-align: middle;">
							'.$FTCHtranslistAJAX[$i]['poNO'].'
							<br>'; 

							if($FTCHtranslistAJAX[$i]['notes'])
							{
								$data .= $FTCHtranslistAJAX[$i]['notes'];
							}
							else
							{
								$data .= "No Data";
							}

			  $data .= '</td>
						<td title="Production Transaction - Issue Weight (grams)" style="text-align:right; vertical-align: middle; padding-right:26px;">';

							if($FTCHtranslistAJAX[$i]['type'] == "iss")
							{
								if(($FTCHtranslistAJAX[$i]['st_wt'] != "0" && $FTCHtranslistAJAX[$i]['st_wt'] != "") && ($FTCHtranslistAJAX[$i]['wgt'] != "0" && $FTCHtranslistAJAX[$i]['wgt'] != ""))
								{
									$data .= number_format($FTCHtranslistAJAX[$i]['st_wt'], 2)." <br><small>(Stone Wgt)</small>";
									$data .= "<br>";
									$data .= number_format($FTCHtranslistAJAX[$i]['wgt'], 2)." <br><small>(Metal Wgt)</small>";
								}
								elseif($FTCHtranslistAJAX[$i]['st_wt'] != "0" && $FTCHtranslistAJAX[$i]['st_wt'] != "")
								{
									$data .= number_format($FTCHtranslistAJAX[$i]['st_wt'], 2)." <br><small>(Stone Wgt)</small>";
								}
								elseif($FTCHtranslistAJAX[$i]['wgt'] != "0" && $FTCHtranslistAJAX[$i]['wgt'] != "")
								{
									$data .= number_format($FTCHtranslistAJAX[$i]['wgt'], 2)." <br><small>(Metal Wgt)</small>";
								}
							}
						
			  $data .= '</td>
						<td title="Production Transaction - Receive Weight (grams)" style="text-align:right; vertical-align: middle; padding-right:26px;">';
							
							if($FTCHtranslistAJAX[$i]['type'] == "rec")
							{
								if(($FTCHtranslistAJAX[$i]['st_wt'] != "0" && $FTCHtranslistAJAX[$i]['st_wt'] != "") && ($FTCHtranslistAJAX[$i]['wgt'] != "0" && $FTCHtranslistAJAX[$i]['wgt'] != ""))
								{
									$data .= number_format($FTCHtranslistAJAX[$i]['st_wt'], 2)." <br><small>(Stone Wgt)</small>";
									$data .= "<br>";
									$data .= number_format($FTCHtranslistAJAX[$i]['wgt'], 2)." <br><small>(Metal Wgt)</small>";
								}
								elseif($FTCHtranslistAJAX[$i]['st_wt'] != "0" && $FTCHtranslistAJAX[$i]['st_wt'] != "")
								{
									$data .= number_format($FTCHtranslistAJAX[$i]['st_wt'], 2)." <br><small>(Stone Wgt)</small>";
								}
								elseif($FTCHtranslistAJAX[$i]['wgt'] != "0" && $FTCHtranslistAJAX[$i]['wgt'] != "")
								{
									$data .= number_format($FTCHtranslistAJAX[$i]['wgt'], 2)." <br><small>(Metal Wgt)</small>";
								}
							}

			  $data .= '</td>
						<td title="No. of Pieces" style="text-align:center; vertical-align: middle;">'.$FTCHtranslistAJAX[$i]['no_of_pieces'].'</td>';
//			  $data .= '<td title="Purity (%)" style="text-align:right; vertical-align: middle; padding-right:26px;">'.$FTCHtranslistAJAX[$i]['purity'].'</td>';
			  $data .= '<td title="Work Status" style="text-align:center; vertical-align: middle; padding-right:26px;">';

							if($FTCHtranslistAJAX[$i]['type'] == "rec")
							{
								if($FTCHtranslistAJAX[$i]['work_status'] == "1")
								{
									$data .= 'Open <br> <i class="far fa-times-circle" style="color:red; font-size:17px;" title="Process - Open"></i>';	
								}
								else if($FTCHtranslistAJAX[$i]['work_status'] == "0")
								{
									$data .= '<i class="fas fa-check-circle" style="color:#44DF5D; font-size:17px;" title="Process - Closed"></i>
											  <br>
											  Closed';
								}
							}	

			  $data .= '</td>
						<td title="Action" style="text-align:center; vertical-align: middle;">
						<a href="/prod-iss-rec-data-with-pagination'.$FTCHtranslistAJAX[$i]['prod_iss_rec_id'].'?page='.$_GET["page"].'" title="Update"><i class="fas fa-edit"></i></a>
						&nbsp;
						<a href="javascript:void(0);" title="Delete" onclick="return confirm(- Are you sure to delete this Production Transaction ?\n- Deleted Production Transaction cannot recover again\n- Please think twice before processing )"><i class="fas fa-trash-alt" style="color:red;"></i></a>
						</td>
					</tr>';
		}
		
		$qury	= "SELECT ISSrec.prod_iss_rec_id, ISSrec.trans_no, ISSrec.`dept_id`, TREEdet.sepration_emp_id, FORMAT(TREEdet.jc_orn_wgt, 3) AS jc_orn_wgt, FORMAT(ISSrec.`wgt`, 3) AS `wgt` FROM `wax_tree_making_det` AS TREEdet LEFT JOIN `prod_iss_rec` AS ISSrec ON TREEdet.po_open_ord_det_id = ISSrec.po_id LEFT JOIN `wax_tree_making` AS TREE ON TREEdet.wax_tree_making_id = TREE.wax_tree_making_id WHERE TREEdet.po_open_ord_det_id = '".$po_id."' AND ISSrec.dept_id = '".$deptID."' AND ISSrec.type = 'iss' ORDER BY ISSrec.`prod_iss_rec_id` DESC LIMIT 0, 1";
		$stmt	= $connection->executeQuery($qury);
		$list	= $stmt->fetchAll();
		
		if(!isset($list[0]['dept_id'])){
			$jcORNwt = $list[0]['jc_orn_wgt'];
			$transNo = $list[0]['trans_no'];
		}else{
			$jcORNwt = $list[0]['wgt'];
			$transNo = $list[0]['trans_no'];
		}
				
		
//		$rslt = $request->get('isredt')."#*#".number_format($issWGT, 2)."#*#".number_format($recWGT, 2)."#*#".number_format($lossProf, 2)."#*#".$data;
//		$rslt = $request->get('isredt')."#*#".number_format($issWGT, 2)."#*#".number_format($recWGT, 2)."#*#".number_format($lossProf, 2)."#*#".$data."#*#".$issRECdata;
		$rslt = $data."#*#".$issRECdata."#*#".$QURYtranslistAJAX."#*#".$jcORNwt."#*#".$transNo;
		return  new JsonResponse($rslt);	
	}		
	
	
    /**
     * @Route("/issVALUE", name="issVALUE")
     */
    public function issVALUEAJAX(Request $request) 
    {
		$connection	= $this->getDoctrine()->getManager()->getConnection();
		
		$deptID		= $request->get('deptID');	
		
		$quryISSdata	= "SELECT PIR.prod_iss_rec_id, CONCAT(P.party_name,' / ',PIR.wgt, ' g / ',PIR.no_of_pieces,' pcs / ') AS issDATA FROM `prod_iss_rec` AS PIR, PO AS PO, party AS P WHERE PIR.`dept_id`='$deptID' AND `type`='iss' AND PIR.`rec_wgt`='' AND PIR.po_id=PO.po_id AND PO.party_id=P.party_id ORDER BY PIR.prod_iss_rec_id ASC";
		$stmtISSdata	= $connection->executeQuery($quryISSdata);
		$ftchISSdata	= $stmtISSdata->fetchAll();			
		
		$rslt = $ftchISSdata;		
//		$rslt = $quryISSdata;		
		return  new JsonResponse($rslt);	
	}
	

	/**
     * @Route("/prod-iss-rec-data{prodIssRecID}", name="prod-iss-rec-data") 
     */
    public function prodIssRecLISTact(Request $request, $prodIssRecID)  
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		date_default_timezone_set("Asia/Kolkata");
		$nwDate 	= date("Y-m-d");
		
		########-[ GET JC LIST
		//$QURYjcLIST		= "SELECT JC.po_open_ord_det_id, JC.jc_no FROM `wax_tree_making_det` AS TMD, `po_open_ord_det` AS JC WHERE TMD.po_open_ord_det_id=JC.po_open_ord_det_id AND TMD.`sepration_emp_id`!='' ORDER BY TMD.po_open_ord_det_id DESC";		//-OLD
		
		//$QURYjcLIST		= "SELECT TMD.`wax_tree_making_det_id`, TMD.jc_no FROM `wax_tree_making_det` AS TMD, `po_open_ord_det` AS JC WHERE TMD.po_open_ord_det_id=JC.po_open_ord_det_id AND TMD.`sepration_emp_id`!='' AND TMD.jc_no_split_status='Yes' AND JC.jc_status='on process' ORDER BY TMD.po_open_ord_det_id DESC";	//-CHECKING
		$QURYjcLIST		= "SELECT IF( TMD.`act_po_open_ord_det_id` = 0, TMD.`po_open_ord_det_id`, TMD.`wax_tree_making_det_id` ) AS wax_tree_making_det_id, JC.jc_no, TMD.`po_open_ord_det_id` FROM `wax_tree_making_det` AS TMD, `po_open_ord_det` AS JC WHERE TMD.po_open_ord_det_id=JC.po_open_ord_det_id AND TMD.`sepration_emp_id`!='' AND TMD.jc_no_split_status='Yes' AND JC.jc_status='on process' ORDER BY TMD.po_open_ord_det_id DESC";
		$CONNjcLIST		= $connection->executeQuery($QURYjcLIST);
		$FTCHjcLIST		= $CONNjcLIST->fetchAll();		
		
		$jcLIST = "";		
		for($ii=0; $ii<=count($FTCHjcLIST)-1; $ii++)
		{
			########--- CHECK WORK STATUS
			$QURYchkWRKst = "SELECT `po_id`, `work_status` FROM `prod_iss_rec` WHERE `po_id`='".$FTCHjcLIST[$ii]['po_open_ord_det_id']."' AND `work_status`!='0' ORDER BY po_id DESC LIMIT 1";
			$CONNchkWRKst = $connection->executeQuery($QURYchkWRKst);
			$FTCHchkWRKst = $CONNchkWRKst->fetchAll();
			
			if($FTCHchkWRKst[0]['po_id'] == "")
			{
				if($FTCHjcLIST[$ii]['wax_tree_making_det_id'] == $FTCHjcLIST[$ii]['po_id']){
					$select  = "selected";
				} else {
					$select  = "";
				}
				
				$jcLIST .= '<option value="'.$FTCHjcLIST[$ii]['wax_tree_making_det_id'].'" '.$select.'>'.$FTCHjcLIST[$ii]['jc_no'].'</option>';
			}
		}		
		
		########-[ GET TRANS NO
		$QURYtransNO	= "SELECT IF(MAX(`trans_no`) IS NULL,1,MAX(`trans_no`)+1) AS transNo FROM `prod_iss_rec` WHERE `statu_s`=1";
		$CONNtransNO	= $connection->executeQuery($QURYtransNO);
		$FTCHtransNO	= $CONNtransNO->fetchAll();
		$RSLTtransNO	= $FTCHtransNO[0]['transNo'];

		
		########-[ GET DEPT LIST
		$QURYdeptlist	= "SELECT `dept_id`, `dept_name` FROM `dept` WHERE `role_status`=1 AND `avail_dept`=1 ORDER BY `dept_name` ASC";
		$CONNdeptlist	= $connection->executeQuery($QURYdeptlist);
		$FTCHdeptlist	= $CONNdeptlist->fetchAll();
		
		
		########-[ GET EMPLOYEE LIST
/*		$QURYemplist	= "SELECT `employee_id`, `eid`, `emp_name` FROM `employee` WHERE `role_status`=1 ORDER BY `emp_name` ASC";
		$CONNemplist	= $connection->executeQuery($QURYemplist);
		$FTCHemplist	= $CONNemplist->fetchAll();*/
		
		
		########-[ GET EMPLOYEE LIST
		//$QURYemplist	= "SELECT `employee_id`, `eid`, `emp_name` FROM `employee` WHERE `role_status`=1 ORDER BY `emp_name` ASC";
		$QURYemplist	= "SELECT E.employee_id, E.emp_name FROM `employee` AS E, employee_salary AS ES, dept AS D, roles AS R WHERE E.dept=D.dept_id AND E.roles=R.roles_id AND E.employee_id=ES.employee_id AND E.role_status=1 GROUP BY ES.employee_id ORDER BY E.emp_name ASC";		
		$CONNemplist	= $connection->executeQuery($QURYemplist);
		$FTCHemplist	= $CONNemplist->fetchAll();
		
		
		########-[ GET Trans. Particulars / FITTINGS
		$QURYfittingsLT = "SELECT `fitting_id`, `fitting_name` FROM `fitting` WHERE `role_status`=1 AND fitting_id > 0 ORDER BY `fitting_name` ASC";
		$CONNfittingsLT	= $connection->executeQuery($QURYfittingsLT);
		$FTCHfittingsLT	= $CONNfittingsLT->fetchAll();


		
		
		########-[ GET LAST INSERTED TRANSATION NO
//		$QURYlastDeptID = "SELECT `dept_id` FROM `prod_iss_rec` WHERE `prod_iss_rec_id`=(SELECT MAX(`prod_iss_rec_id`) FROM `prod_iss_rec`)";
		$QURYlastTRANno = "SELECT `trans_no` AS lastTRANinstNO FROM `prod_iss_rec` WHERE `prod_iss_rec_id`=(SELECT MAX(`prod_iss_rec_id`) FROM `prod_iss_rec`)";
		$CONNlastTRANno	= $connection->executeQuery($QURYlastTRANno);
		$FTCHlastTRANno	= $CONNlastTRANno->fetchAll();
		$RSLTlastTRANno	= $FTCHlastTRANno[0]['lastTRANinstNO'];
		
		########-[ GET LAST INSERTED DEPT ID
		$QURYlastDeptID = "SELECT `dept_id` FROM `prod_iss_rec` WHERE `trans_no`='".$RSLTlastTRANno."'";
		$CONNlastDeptID	= $connection->executeQuery($QURYlastDeptID);
		$FTCHlastDeptID	= $CONNlastDeptID->fetchAll();
		$RSLTlastDeptID	= $FTCHlastDeptID[0]['dept_id'];		
		
		
		########-[ GET PROD TRANS LIST
		//$QURYtranslist	= "SELECT PIR.*, D.dept_name, E.emp_name FROM `prod_iss_rec` AS PIR, dept AS D, employee AS E WHERE PIR.dept_id=D.dept_id AND PIR.employee_id=E.employee_id AND PIR.statu_s=1 ORDER BY prod_iss_rec_id DESC";
		//$QURYtranslist	= "SELECT CONCAT(PO.po_financial_yr,'',PO.po_no) AS poNO, PIR.*, D.dept_name, E.emp_name, PIR.work_status, PIR.notes, FT.fitting_name FROM `prod_iss_rec` AS PIR, dept AS D, employee AS E, po AS PO, fitting AS FT WHERE PIR.fitting_id = FT.fitting_id AND PIR.dept_id = D.dept_id AND PIR.employee_id = E.employee_id AND PIR.statu_s = 1 AND PIR.po_id=PO.po_id ORDER BY prod_iss_rec_id DESC";
		//$QURYtranslist	= "SELECT PIR.*, D.dept_name, E.emp_name, FT.fitting_name FROM `prod_iss_rec` AS PIR, dept AS D, employee AS E, fitting AS FT WHERE PIR.fitting_id = FT.fitting_id AND PIR.dept_id = D.dept_id AND PIR.employee_id = E.employee_id AND PIR.statu_s = 1 ORDER BY prod_iss_rec_id DESC";
		
		//$QURYtranslist	= "SELECT PIR.*, CONCAT(PO.`po_financial_yr`,'',PO.`po_no`) AS poNO, D.dept_name, E.emp_name, FT.fitting_name FROM `prod_iss_rec` AS PIR, `dept` AS D, `employee` AS E, `fitting` AS FT, `PO` AS PO WHERE PIR.fitting_id = FT.fitting_id AND PIR.dept_id = D.dept_id AND PIR.employee_id = E.employee_id AND PIR.statu_s = 1 AND PO.po_id = PIR.po_id AND PIR.trans_date='$nwDate' AND PIR.dept_id='$RSLTlastDeptID' ORDER BY prod_iss_rec_id DESC";
		
		$QURYtranslist	= "SELECT PIR.`jc_no` AS prodISSrecJCno, PIR.po_open_ord_id, PIR.split_flag, PIR.prod_iss_rec_id, PIR.po_id, PIR.trans_no, PIR.trans_date, PIR.notes, PIR.type, PIR.st_wt, PIR.wgt, PIR.no_of_pieces, JC.`jc_no`, D.dept_name, E.emp_name, FT.fitting_name, DATE_FORMAT(PIR.`post_dt`, '%b %d, %Y - %r') AS entryDT FROM `prod_iss_rec` AS PIR, `dept` AS D, `employee` AS E, `fitting` AS FT, `po_open_ord_det` AS JC WHERE PIR.fitting_id = FT.fitting_id AND PIR.dept_id = D.dept_id AND PIR.employee_id = E.employee_id AND PIR.statu_s = 1 AND JC.jc_no = PIR.jc_no AND PIR.type='iss' /*AND PIR.trans_date='$nwDate' AND PIR.dept_id='$RSLTlastDeptID'*/ GROUP BY PIR.po_id, PIR.trans_no ORDER BY PIR.prod_iss_rec_id DESC";
		$CONNtranslist	= $connection->executeQuery($QURYtranslist);
		$FTCHtranslist	= $CONNtranslist->fetchAll();
		$prdISSrecRWcn	= count($FTCHtranslist);
		$CONTtranslist	= count($FTCHtranslist) - 1;
		
		
		$issRECtranDATA = "";
		
		for($i=0; $i<=$CONTtranslist; $i++)
		{
/*			$QURYjcNO		= "SELECT `wgt`, `no_of_pieces`, spare_wgt, st_wt, enam_wgt FROM `prod_iss_rec` WHERE `trans_no`='".$FTCHtranslist[$i]['trans_no']."' AND po_id='".$FTCHtranslist[$i]['po_id']."' AND `type`='rec'";
			$CONNjcNO	= $connection->executeQuery($QURYtranRECtyp);
			$FTCHjcNO	= $CONNtranRECtyp->fetchAll();*/
			
			//$QURYtranRECtyp	= "SELECT `split_flag`, `prod_iss_rec_id`, `wgt`, `no_of_pieces`, spare_wgt, st_wt, st_pcs, enam_wgt, cutting_met_wgt FROM `prod_iss_rec` WHERE `trans_no`='".$FTCHtranslist[$i]['trans_no']."' AND po_id='".$FTCHtranslist[$i]['po_id']."' AND `type`='rec'";
			$QURYtranRECtyp	= "SELECT `split_flag`, `prod_iss_rec_id`, `wgt`, `no_of_pieces`, spare_wgt, st_wt, st_pcs, enam_wgt, cutting_met_wgt FROM `prod_iss_rec` WHERE `trans_no`='".$FTCHtranslist[$i]['trans_no']."' AND jc_no='".$FTCHtranslist[$i]['jc_no']."' AND `type`='rec'";
			$CONNtranRECtyp	= $connection->executeQuery($QURYtranRECtyp);
			$FTCHtranRECtyp	= $CONNtranRECtyp->fetchAll();
			
			$QURYtranIRtyp	= "SELECT `split_flag`, `prod_iss_rec_id`, `wgt`, `no_of_pieces`, spare_wgt, st_wt, st_pcs, enam_wgt, cutting_met_wgt FROM `prod_iss_rec` WHERE `trans_no`='".$FTCHtranslist[$i]['trans_no']."' AND po_id='".$FTCHtranslist[$i]['po_id']."'";
			$CONNtranIRtyp	= $connection->executeQuery($QURYtranIRtyp);
			$FTCHtranIRtyp	= $CONNtranIRtyp->fetchAll();			
			
			
			#--------[ CHECKING - split status
			$QURYsplitST= "SELECT `act_po_open_ord_det_id` FROM `wax_tree_making_det` WHERE `po_open_ord_det_id`= '".$FTCHtranslist[$i]['po_id']."' AND `act_po_open_ord_det_id`!=0 ORDER BY `wax_tree_making_det_id` ASC";
			$CONNsplitST= $connection->executeQuery($QURYsplitST);
			$FTCHsplitST= $CONNsplitST->fetchAll();
			
			if(!isset($FTCHsplitST[0]['act_po_open_ord_det_id'])){
				$splitSTATUS = 0;	// SPLIT NOT AVAIL THIS ORDER
			} else {
				$splitSTATUS = 1;	// SPLIT AVAIL THIS ORDER
			}			

			if($splitSTATUS == 1)
			{
			$QURYpartyNM	= "SELECT P.concern_name, P.party_name, TREE.jc_no FROM `prod_iss_rec` AS PROD, `wax_tree_making_det` AS TREE, po_open_ord AS POord, party AS P WHERE PROD.prod_iss_rec_id = '".$FTCHtranslist[$i]['prod_iss_rec_id']."' AND PROD.po_id = TREE.po_open_ord_det_id AND PROD.po_open_ord_id=POord.po_open_ord_id AND POord.party_id=P.party_id";
			
			$QURYjcNO	= "SELECT TMD.`wax_tree_making_det_id`, TMD.jc_no FROM `wax_tree_making_det` AS TMD, `po_open_ord_det` AS JC WHERE TMD.po_open_ord_det_id = JC.po_open_ord_det_id AND TMD.`wax_tree_making_det_id` = '".$FTCHtranslist[$i]['po_id']."' ";			
			}
			else if($splitSTATUS == 0)
			{
			//$QURYpartyNM	= "SELECT P.concern_name, P.party_name, TREE.jc_no FROM `prod_iss_rec` AS PROD, `wax_tree_making_det` AS TREE, `po_open_ord` AS JC, `party` AS P WHERE PROD.prod_iss_rec_id = '".$FTCHtranslist[$i]['prod_iss_rec_id']."' AND PROD.po_id=TREE.wax_tree_making_det_id AND TREE.po_open_ord_id=JC.po_open_ord_id AND JC.party_id=P.party_id";
			$QURYpartyNM	= "SELECT P.concern_name, P.party_name, TREE.jc_no FROM `prod_iss_rec` AS PROD, `wax_tree_making_det` AS TREE, `po_open_ord` AS JC, `party` AS P WHERE PROD.prod_iss_rec_id = '".$FTCHtranslist[$i]['prod_iss_rec_id']."' AND PROD.`jc_no` = TREE.`jc_no` AND TREE.`po_open_ord_id` = JC.po_open_ord_id AND JC.party_id = P.party_id";
			
			$QURYjcNO	= "SELECT TMD.`wax_tree_making_det_id`, TMD.jc_no FROM `wax_tree_making_det` AS TMD, `po_open_ord_det` AS JC WHERE TMD.po_open_ord_det_id = JC.po_open_ord_det_id AND TMD.`po_open_ord_det_id` = '".$FTCHtranslist[$i]['po_id']."' ";
			}

			$CONNpartyNM	= $connection->executeQuery($QURYpartyNM);
			$FTCHpartyNM	= $CONNpartyNM->fetchAll();
			$RLSTconceNM	= $FTCHpartyNM[0]['concern_name'];
			$RLSTpartyNM	= $FTCHpartyNM[0]['party_name'];
			$jc_no			= $FTCHpartyNM[0]['jc_no'];
			
			$CONNjcNO	= $connection->executeQuery($QURYjcNO);
			$FTCHjcNO	= $CONNjcNO->fetchAll();
			$jc_no		= $FTCHjcNO[0]['jc_no'];			
			
			if($FTCHtranRECtyp[0]['wgt'] != "")
			{
				$receiveWGT	= number_format($FTCHtranRECtyp[0]['wgt'], 2);
			} 
			else if($FTCHtranRECtyp[0]['wgt'] == "")
			{
				$receiveWGT	= "-";
			}
			
			if($FTCHtranRECtyp[0]['no_of_pieces'] != ""){
				$no_of_pieces = number_format($FTCHtranRECtyp[0]['no_of_pieces']);
			} else if($FTCHtranRECtyp[0]['no_of_pieces'] == ""){
				$no_of_pieces = "-";
			}
			
			if($FTCHtranRECtyp[0]['spare_wgt'] != ""){
				$spare_wgt = number_format($FTCHtranRECtyp[0]['spare_wgt'], 2);
			}else if($FTCHtranRECtyp[0]['spare_wgt'] == 0){
				$spare_wgt = "-";
			}
			
			if($FTCHtranRECtyp[0]['st_wt'] != ""){
				$st_wt = number_format($FTCHtranRECtyp[0]['st_wt'], 2);
			}else if($FTCHtranRECtyp[0]['st_wt'] == 0){
				$st_wt = "-";
			}	
			
			if($FTCHtranRECtyp[0]['st_pcs'] != ""){
				$st_qty = $FTCHtranRECtyp[0]['st_pcs'];
			}else if($FTCHtranRECtyp[0]['st_pcs'] == 0){
				$st_qty = "-";
			}	
			
			if($FTCHtranRECtyp[0]['enam_wgt'] != ""){
				$enam_wgt = number_format($FTCHtranRECtyp[0]['enam_wgt'], 2);
			}else if($FTCHtranRECtyp[0]['enam_wgt'] == 0){
				$enam_wgt = "-";
			}			
			
			if($FTCHtranRECtyp[0]['cutting_met_wgt'] != ""){
				$cut_met_wgt = number_format($FTCHtranRECtyp[0]['cutting_met_wgt'], 2);
			}else if($FTCHtranRECtyp[0]['cutting_met_wgt'] == 0){
				$cut_met_wgt = "-";
			}						
			
			
			#-------- CHECK JC ENTRY's - no of rows
			$QURYchckJCrows = "SELECT COUNT(`prod_iss_rec_id`) AS countJCentries FROM `prod_iss_rec` WHERE `po_id`='".$FTCHtranslist[$i]['po_id']."' ";
			$CONNchckJCrows	= $connection->executeQuery($QURYchckJCrows);
			$FTCHchckJCrows	= $CONNchckJCrows->fetchAll();
			$countJCentries	= $FTCHchckJCrows[0]['countJCentries'];
			
			#-------- GET LATEST JC ENTRY for EDIT OPTION
			$QURYjcLATEST	= "SELECT MAX(`prod_iss_rec_id`) AS JClatestENTRYprimID, work_status FROM `prod_iss_rec` WHERE `po_id`='".$FTCHtranslist[$i]['po_id']."' AND `type`='rec' AND statu_s = 1";
			$CONNjcLATEST	= $connection->executeQuery($QURYjcLATEST);
			$FTCHjcLATEST	= $CONNjcLATEST->fetchAll();

			if(!isset($FTCHjcLATEST[0]['JClatestENTRYprimID']))
			{
				$JClatestENTRYprimID = 0;
			}
			else
			{
				$JClatestENTRYprimID = $FTCHjcLATEST[0]['JClatestENTRYprimID'];
			}
			
			if($FTCHtranIRtyp[0]['split_flag'] == 1)
			{
				$fontCOLORcss = 'style="color:#C8C8C8;"';
			}
			else
			{
				$fontCOLORcss = '';
			}
			
			#-------- GET WORK STATUS of JC	
			$QURYjcWORKstat	= "SELECT prod_iss_rec_id, work_status FROM `prod_iss_rec` WHERE `prod_iss_rec_id`='".$FTCHjcLATEST[0]['JClatestENTRYprimID']."' AND `type`='rec'";
			$CONNjcWORKstat	= $connection->executeQuery($QURYjcWORKstat);
			$FTCHjcWORKstat	= $CONNjcWORKstat->fetchAll();			
			/*
			$issRECtranDATA .= '<tr '.$fontCOLORcss.'> 
									<td title="Serial No." style="text-align:center; vertical-align: middle; width:5%;">'.($i+1).'</td>
									<td title="Concern Name / Party Name" style="text-align:left; vertical-align: middle; width:17%;"><u>'.$RLSTconceNM.'</u> <br> '.$RLSTpartyNM.'</td>
									<td title="Department / Employee Transaction" style="text-align:left; vertical-align: middle; width:15%;"><u>'.$FTCHtranslist[$i]['dept_name'].'</u> <br> '.$FTCHtranslist[$i]['emp_name'].'</td>
									<td title="Job Card No. / Date" style="text-align:left; vertical-align: middle; width:15%;"><u>'.$jc_no.'</u> <br> '.$FTCHtranslist[$i]['entryDT'].'</td>
									<td title=" Iss Weight (grams) / Iss Qty" style="text-align:right; vertical-align: middle; width:15%;">'.number_format($FTCHtranslist[$i]['wgt'], 2).' <small>(Grm)</small><br>'.$FTCHtranslist[$i]['no_of_pieces'].' <small>(No\'s)</small></td>
									<td title="Rec Weight (grams) / Rec Qty" style="text-align:right; vertical-align: middle; width:15%;">'.$receiveWGT.'<br>'.$no_of_pieces.' <small>(No\'s)</small></td>
									<td title="Spare Weight" style="text-align:right; vertical-align: middle; width:15%;">'.$spare_wgt.' <small>(Grm)</small></td>
									<td title="Stone Weight (g)/ Enamel Weight (g)" style="text-align:right; vertical-align: middle;">'.$st_wt.' <small>(g)</small><br>'.$enam_wgt.' <small>(g)</small></td>';
			*/	

			
			if($fontCOLORcss == "")
			{
			//$issRECtranDATA .= '<tr '.$fontCOLORcss.'>';
			$issRECtranDATA .= '<tr>'; 
			$issRECtranDATA .= '	<td title="Serial No." style="text-align:center; vertical-align: middle; width:5%;">'.($i+1).'</td>
									<td title="Party Name" style="text-align:left; vertical-align: middle; width:17%;">'.$RLSTpartyNM.'</td>
									<td title="Department" style="text-align:left; vertical-align: middle; width:15%;">'.$FTCHtranslist[$i]['dept_name'].'</td>
									<td title="Employee Transaction" style="text-align:left; vertical-align: middle; width:15%;">'.$FTCHtranslist[$i]['emp_name'].'</td>
									<td title="Job Card No." style="text-align:left; vertical-align: middle; width:15%;">'.$FTCHtranslist[$i]['prodISSrecJCno'].'</td>
									<td title="Date" style="text-align:left; vertical-align: middle; width:15%;">'.$FTCHtranslist[$i]['entryDT'].'</td>
									<td title="Iss Weight" style="text-align:right; vertical-align: middle; width:15%;">'.number_format($FTCHtranslist[$i]['wgt'], 2).'</td>
									<td title="Iss Qty" style="text-align:right; vertical-align: middle; width:15%;">'.$FTCHtranslist[$i]['no_of_pieces'].'</td>
									<td title="Rec Weight (grams)" style="text-align:right; vertical-align: middle; width:15%;">'.$receiveWGT.'</td>
									<td title="Rec Qty" style="text-align:right; vertical-align: middle; width:15%;">'.$no_of_pieces.'</td>
									<td title="Spare Weight" style="text-align:right; vertical-align: middle; width:15%;">'.$spare_wgt.'</td>
									<td title="Stone Weight (g)" style="text-align:right; vertical-align: middle;">'.$st_wt.'</td>
									<td title="Stone Qty" style="text-align:right; vertical-align: middle;">'.$st_qty.'</td>
									<td title="Enamel Weight (g)" style="text-align:right; vertical-align: middle;">'.$enam_wgt.'</td>
									<td title="Cutting Metal Weight (g)" style="text-align:right; vertical-align: middle;">'.$cut_met_wgt.'</td>';			
				
				if($FTCHjcWORKstat[0]['work_status'] != 3 && $FTCHjcWORKstat[0]['work_status'] != 4)
				{
					if($countJCentries == 1)
					{
						if($FTCHtranIRtyp[0]['split_flag'] == 0){
						$issRECtranDATA .= '<td title="Work Status / Action" style="text-align:center; vertical-align: middle;"><a href="prod-iss-rec-data'.$FTCHtranslist[$i]['prod_iss_rec_id'].'"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a></td>';				
						} else {
						$issRECtranDATA .= '<td title="Work Status / Action" style="text-align:center; vertical-align: middle;"><i class="fa fa-pencil-square-o" aria-hidden="true" style="color:#E8E8E8;"></i></td>';
						}
					}
					else
					{
						if($FTCHtranRECtyp[0]['prod_iss_rec_id'] == $JClatestENTRYprimID && $FTCHtranRECtyp[0]['split_flag'] == 0)
						{
							if(!isset($FTCHtranIRtyp[0]['prod_iss_rec_id']))	//- only 1 row in db ie very 1st entry on table
							{
								$editPRODissRECid = 1;
							}
							else
							{
								$editPRODissRECid = $FTCHtranRECtyp[0]['prod_iss_rec_id'];
							}
							
							$issRECtranDATA .= '<td title="Work Status / Action" style="text-align:center; vertical-align: middle;"><a href="prod-iss-rec-data'.$editPRODissRECid.'"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a></td>';
						} else {
						$issRECtranDATA .= '<td title="Work Status / Action" style="text-align:center; vertical-align: middle;"><i class="fa fa-pencil-square-o" aria-hidden="true" style="color:#E8E8E8;"></i></td>';
						}
					}
				}
				else if($FTCHjcWORKstat[0]['work_status'] == 3)
				{
					if($FTCHtranRECtyp[0]['prod_iss_rec_id'] == $FTCHjcLATEST[0]['JClatestENTRYprimID'])
					{
						$issRECtranDATA .= '<td title="Work Status / Action" style="text-align:center; vertical-align: middle;"><i class="fa fa-check-circle" style="font-size:17px; color:green"></i> <br> <center><small><b>JC Finished<b></small></center></td>';
					}	
					else
					{
						$issRECtranDATA .= '<td title="Work Status / Action" style="text-align:center; vertical-align: middle;"><i class="fa fa-pencil-square-o" aria-hidden="true" style="color:#E8E8E8;"></i></td>';
					}
				}
				else if($FTCHjcWORKstat[0]['work_status'] == 4)
				{
					//$issRECtranDATA .= '<td title="Work Status / Action" style="text-align:center; vertical-align: middle;"><i class="fa fa-check-circle" style="font-size:17px; color:green"></i> <br> <center><small><b>Return<b></small></center></td>';
					
					if($FTCHtranRECtyp[0]['prod_iss_rec_id'] == $FTCHjcLATEST[0]['JClatestENTRYprimID'])
					{
						$issRECtranDATA .= '<td title="Work Status / Action" style="text-align:center; vertical-align: middle;"><i class="fa fa-check-circle" style="font-size:17px; color:green"></i> <br> <center><small><b>Return<b></small></center></td>';
					}	
					else
					{
						$issRECtranDATA .= '<td title="Work Status / Action" style="text-align:center; vertical-align: middle;"><i class="fa fa-pencil-square-o" aria-hidden="true" style="color:#E8E8E8;"></i></td>';
					}
					
				}
			$issRECtranDATA .= '</tr>';
			}
		}
		
		

		
		#--------[ GET PROD TRANS DATA to UPDATE
		$QURYtransDATA					= "SELECT * FROM `prod_iss_rec` WHERE prod_iss_rec_id='$prodIssRecID'";
		$CONNtransDATA					= $connection->executeQuery($QURYtransDATA);
		$FTCHtransDATA					= $CONNtransDATA->fetchAll();
		//$FTCHtransDATA['metal_status']	= $FTCHtransDATA[0]['metal_status'];
		$FTCHtransDATA['metal_status']	= "";										//-Hidden
		$FTCHtransDATA['po_open_ord_id']= $FTCHtransDATA[0]['po_open_ord_id'];
		$FTCHtransDATA['jc_no']			= $FTCHtransDATA[0]['jc_no'];
		$FTCHtransDATA['type'] 			= $FTCHtransDATA[0]['type'];
		$FTCHtransDATA['trans_no'] 		= $FTCHtransDATA[0]['trans_no'];
		$FTCHtransDATA['trans_date']	= $FTCHtransDATA[0]['trans_date'];
		$FTCHtransDATA['po_id']			= $FTCHtransDATA[0]['po_id'];
		$FTCHtransDATA['dept_id'] 		= $FTCHtransDATA[0]['dept_id'];
		$FTCHtransDATA['employee_id']	= $FTCHtransDATA[0]['employee_id'];
		$FTCHtransDATA['fitting_id']	= $FTCHtransDATA[0]['fitting_id'];	
		$FTCHtransDATA['notes'] 		= $FTCHtransDATA[0]['notes'];
		$FTCHtransDATA['wgt'] 			= $FTCHtransDATA[0]['wgt'];
		$FTCHtransDATA['no_of_pieces']	= $FTCHtransDATA[0]['no_of_pieces'];		
		$FTCHtransDATA['purity'] 		= $FTCHtransDATA[0]['purity'];
		$FTCHtransDATA['work_status']	= $FTCHtransDATA[0]['work_status'];
		$FTCHtransDATA['post_dt']		= $FTCHtransDATA[0]['post_dt'];
		$FTCHtransDATA['enam_wgt']		= $FTCHtransDATA[0]['enam_wgt'];
		$FTCHtransDATA['st_wt']			= $FTCHtransDATA[0]['st_wt'];
		$FTCHtransDATA['st_wt']			= $FTCHtransDATA[0]['st_wt'];
		$FTCHtransDATA['st_pcs']		= $FTCHtransDATA[0]['st_pcs'];
		$FTCHtransDATA['cutMwgt']		= $FTCHtransDATA[0]['cutting_met_wgt'];
		$FTCHtransDATA['post_dt']		= $FTCHtransDATA[0]['post_dt'];
		
		#--------[ GET JC COUNT
		$QURYjcTRANSdata				= "SELECT COUNT(`prod_iss_rec_id`) AS jcTRANsCONT FROM `prod_iss_rec` WHERE po_id='".$FTCHtransDATA['po_id']."'";
		$CONNjcTRANSdata				= $connection->executeQuery($QURYjcTRANSdata);
		$FTCHjcTRANSdata				= $CONNjcTRANSdata->fetchAll();		
		$prdISSrecRWcnJCwise			= $FTCHjcTRANSdata[0]['jcTRANsCONT'];
		
		########-[ GET JC No
		//echo
		//$QURYjcNO	= "SELECT `jc_no` FROM `wax_tree_making_det` WHERE (`po_open_ord_det_id`='".$FTCHtransDATA['po_id']."' AND `act_po_open_ord_det_id`!=0) OR (`wax_tree_making_det_id`='".$FTCHtransDATA['po_id']."' AND `act_po_open_ord_det_id`=0)";
		$QURYjcNO	= "SELECT * FROM `prod_iss_rec` WHERE `prod_iss_rec_id`= '".$prodIssRecID."' ";
		$CONNjcNO	= $connection->executeQuery($QURYjcNO);
		$FTCHjcNO	= $CONNjcNO->fetchAll();	
		$RSLTjcNO	= $FTCHjcNO[0]['jc_no'];			
		
		#--------[ GET PROD TRANS NEXT (rec) DATA to UPDATE
		if($prodIssRecID != 0)
		{
		$QURYtransNXTrecDATA			= "SELECT MIN(`prod_iss_rec_id`) AS prodISSrecID, dept_id, employee_id, trans_date FROM prod_iss_rec WHERE `prod_iss_rec_id` > ".$prodIssRecID." ORDER BY `prod_iss_rec_id`";
		$CONNtransNXTrecDATA			= $connection->executeQuery($QURYtransNXTrecDATA);
		$FTCHtransNXTrecDATA			= $CONNtransNXTrecDATA->fetchAll();
		
		$FTCHtransNXTrecDATA['prodISSrecID']= $FTCHtransNXTrecDATA[0]['prodISSrecID'];
		$FTCHtransNXTrecDATA['trans_date'] 	= $FTCHtransNXTrecDATA[0]['trans_date'];
		$FTCHtransNXTrecDATA['dept_id'] 	= $FTCHtransNXTrecDATA[0]['dept_id'];
		$FTCHtransNXTrecDATA['employee_id']	= $FTCHtransNXTrecDATA[0]['employee_id'];
		}
		else
		{
		$FTCHtransNXTrecDATA['prodISSrecID']= "";
		$FTCHtransNXTrecDATA['trans_date'] 	= "";
		$FTCHtransNXTrecDATA['dept_id'] 	= "";
		$FTCHtransNXTrecDATA['employee_id']	= "";
		}
		
		#--------[ GET PROD NEXT DAY OPEN TRANS - DATE
		$QURYnextTRANSdate		= "SELECT trans_date, dept_id FROM `prod_iss_rec` WHERE `trans_no`='".$FTCHtransDATA['trans_no']."' AND `type`='iss'";
		$CONNnextTRANSdate		= $connection->executeQuery($QURYnextTRANSdate);
		$FTCHnextTRANSdate		= $CONNnextTRANSdate->fetchAll();

		$FTCHnextTRANSdate['trans_date']= $FTCHnextTRANSdate[0]['trans_date'];	
		$FTCHnextTRANSdate['dept_id'] 	= $FTCHnextTRANSdate[0]['dept_id'];		
		
		if($FTCHtransDATA['work_status'] == 1)
		{
			$QURYgetNXTDT	= "SELECT trans_date FROM `prod_iss_rec` WHERE `post_dt`='".$FTCHtransDATA['post_dt']."' AND `type`='iss' AND `trans_no`='".$FTCHtransDATA['trans_no']."'";
			$CONNgetNXTDT	= $connection->executeQuery($QURYgetNXTDT);
			$FTCHgetNXTDT	= $CONNgetNXTDT->fetchAll();			
			$RSLTgetNXTDT	= $FTCHgetNXTDT[0]['trans_date'];
		}
		else
		{
			$RSLTgetNXTDT = "";
		}
		
		if($FTCHtransDATA['dept_id'] == 5 || $FTCHtransDATA['dept_id'] == 11 || $FTCHtransDATA['dept_id'] == 13 || $FTCHtransDATA['dept_id'] == 14)
		{
			$quryISSdataVIEW	= "SELECT PIR.prod_iss_rec_id, CONCAT(P.party_name,' / ',PIR.wgt, ' g / ',PIR.no_of_pieces,' pcs / ') AS issDATAview FROM `prod_iss_rec` AS PIR, PO AS PO, party AS P WHERE PIR.`dept_id`='".$FTCHtransDATA['dept_id']."' AND `type`='iss' AND PIR.po_id='".$FTCHtransDATA['po_id']."' AND PIR.po_id=PO.po_id AND PO.party_id=P.party_id AND PIR.`update_dt`='".$FTCHtransDATA['post_dt']."'";
			
			$stmtISSdataVIEW	= $connection->executeQuery($quryISSdataVIEW);
			$ftchISSdataVIEW	= $stmtISSdataVIEW->fetchAll();	
			$issDATAview		= $ftchISSdataVIEW[0]['issDATAview'];	
		}
		else
		{
			$issDATAview		= "";
		}		
		
		if($request->getMethod() == 'POST')
		{
			$metal_status	= $request->get('metal_status');
			$type			= $request->get('type');
			$tran_no		= $request->get('tran_no');
			$iss_rec_date	= $request->get('iss_rec_date');
			$iss_rec_date 	= explode("-",$iss_rec_date);
			$iss_rec_date 	= $iss_rec_date[2]."-".$iss_rec_date[1]."-".$iss_rec_date[0];
			$po_open_ord_id	= $request->get('po_open_ord_id');		//THIS IS ORDER PRIMARY NO/KEY.
			$po_id			= $request->get('po_id');				//THIS IS JOB CARD NO/KEY.
			$jcNo			= $request->get('jcNoH');	
			$dept			= $request->get('dept');
			$emp			= $request->get('emp');
			$fitting_id		= $request->get('fitting_id');
			$notes			= addcslashes($request->get('notes'), "'");;
			$wgt			= $request->get('wgt');
			$spare_wgt		= $request->get('spare_wgt');
			$STpieces		= $request->get('STpieces');
			$STwgt			= $request->get('STwgt');
			$ENMwgt			= $request->get('ENMwgt');
			$cutMwgt		= $request->get('cutMwgt');
			//$purity		= $request->get('purity');
			$purity			= "91.75";						//THIS FIELD HIDDED IN SCREEN
			//$profit_perc	= $request->get('profit_perc');
			//$pieces		= $request->get('pieces');
			$pieces			= $request->get('jcQTY');
//			$recovery_wgt	= $request->get('recovery_wgt');	//THIS FIELD HIDDED IN SCREEN
			$recovery_wgt   = "";
			$trans_type		= $request->get('trans_type');
			
			$work_status	= $request->get('work_status');	
			$nxtWrkIssTecDat= $request->get('nxt_wrk_iss_rec_date');	
			$nxtWrkIssTecDat= explode("-",$nxtWrkIssTecDat);
			$nxtWrkIssTecDat= $nxtWrkIssTecDat[2]."-".$nxtWrkIssTecDat[1]."-".$nxtWrkIssTecDat[0];			
				
			$next_dept		= $request->get('next_dept');
			$next_emp		= $request->get('next_emp');
			
			$searchRECwgt	= $request->get('searchRECwgt');
			$searchUPDdat	= $request->get('searchUPDdat');
			
			if($request->get('work_status') == ""){
				$work_status	= 0;	
			} else {
				$work_status	= $request->get('work_status');	
			}
			
				
		/*	$qurySPLITstat	= "SELECT `po_open_ord_det_id` FROM `wax_tree_making_det` WHERE `wax_tree_making_det_id`='".$po_id."' AND `act_po_open_ord_det_id`!=0";
			$stmrSPLITstat	= $connection->executeQuery($qurySPLITstat);
			$ftchSPLITstat	= $stmrSPLITstat->fetchAll();	
			
			if(!isset($ftchSPLITstat[0]['po_open_ord_det_id']))
			{
				$po_id = $po_id;
			}
			else
			{
				$po_id = $ftchSPLITstat[0]['po_open_ord_det_id'];				
			}			*/
			
			
			$sessionId  	= $session->get('empId');
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime 	= date("Y-m-d H:i:s");
			
			if($prodIssRecID == 0)
			{
				#--------[ INSERT 
				$QRinsert = "INSERT INTO `prod_iss_rec`(`metal_status`, `type`, `trans_no`, `trans_date`, `po_open_ord_id`, `po_id`, `jc_no`, `dept_id`, `employee_id`, `fitting_id`, `notes`, `wgt`, spare_wgt, `rec_wgt`, enam_wgt, cutting_met_wgt, st_wt, st_pcs, `no_of_pieces`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('$metal_status', '$type', '$tran_no', '$iss_rec_date', '$po_open_ord_id', '$po_id', '$jcNo', '$dept', '$emp', '$fitting_id', '$notes', '$wgt', '$spare_wgt', '$recovery_wgt', '$ENMwgt', '$cutMwgt', '$STwgt', '$STpieces', '$pieces', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);

				if($work_status == "0" && $type == 'rec') 
				{
					$tran_no = str_pad( $tran_no + 1, 4, "0", STR_PAD_LEFT );
					
					$QRinsert = "INSERT INTO `prod_iss_rec`(`metal_status`,`type`, `trans_no`, `trans_date`, `po_open_ord_id`, `po_id`, `jc_no`, `dept_id`, `employee_id`, `fitting_id`, `notes`, `wgt`, spare_wgt, enam_wgt, cutting_met_wgt, st_wt, st_pcs, `no_of_pieces`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('$metal_status', 'iss', '$tran_no', '$iss_rec_date', '$po_open_ord_id', '$po_id', '$jcNo', '$next_dept', '$next_emp', '$fitting_id', '$notes', '$wgt', '$spare_wgt', '$ENMwgt', '$cutMwgt', '$STwgt', '$STpieces', '$pieces', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
					$CNexecut = $connection->executeQuery($QRinsert);					
				} 
				
				if($work_status == 3)
				{
					$updtJCstatus 	= "UPDATE `po_open_ord_det` SET `jc_status`='finished' WHERE `jc_no`='$jcNo'";
					$connJCstatus	= $connection->executeQuery($updtJCstatus);	
				}
				
				#--------				
				$quryCHKjcENTRIES	= "SELECT COUNT(iSSrec.`prod_iss_rec_id`) AS jcENTRYcont, TREE.act_po_open_ord_det_id FROM `prod_iss_rec` AS iSSrec, wax_tree_making_det AS TREE WHERE iSSrec.`jc_no`='".$jcNo."' AND iSSrec.jc_no=TREE.jc_no";
				$stmtCHKjcENTRIES	= $connection->executeQuery($quryCHKjcENTRIES);
				$ftchCHKjcENTRIES	= $stmtCHKjcENTRIES->fetchAll();
				
				if($ftchCHKjcENTRIES[0]['jcENTRYcont'] >= 2)
				{
				#--------
				$updtJCdltFLAG 		= "UPDATE `wax_tree_making_det` SET `jc_dlt_flag`='2' WHERE `act_po_open_ord_det_id`='".$ftchCHKjcENTRIES[0]['act_po_open_ord_det_id']."' ";
				$connJCdltFLAG		= $connection->executeQuery($updtJCdltFLAG);	
				}
			
/*				if(($dept == 5 || $dept == 11 || $dept == 13 || $dept == 14) && ($type == 'rec'))
				{
					########-[ UPDATE REC WGT - Only for Papper Wheel, Buff, Buff Wheel, Magnet
					$QRupdate = "UPDATE `prod_iss_rec` SET `rec_wgt`='$wgt', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `prod_iss_rec_id`='$work_status'";
					$CNexecut = $connection->executeQuery($QRupdate);
					
					$work_status = 0; #-- AFTER ABOVE UPDATE, REGULAT REC. WGT ENTRY POSTED WITH WORK STATUS 0 As DEFAULT as WORK STATUS CLOSED AUTOMATICALLY
				}
				
				if($dept == 1)	#--------[ INSERT STONE SETTINGS(DEPT) - CONDITION
				{
					########-[ INSERT STONE SETTINGS with (ST WGT, ST PCS)
					$QRinsert = "INSERT INTO `prod_iss_rec`(`type`, `trans_no`, `trans_date`, `po_id`, `dept_id`, `employee_id`, `fitting_id`, `notes`, `wgt`, `no_of_pieces`, `st_wt`, `st_pcs`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('$type', '$tran_no', '$iss_rec_date', '$po_id', '$dept', '$emp', '$fitting_id', '$notes', '$wgt', '$pieces', '".$request->get('STwgt')."', '".$request->get('STpieces')."', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
					$CNexecut = $connection->executeQuery($QRinsert);
					
					//if($work_status == "1" && $type == 'rec') #----[ OPEN status into ISSUE 
					if($work_status == "0" && $type == 'rec') #----[ OPEN status into ISSUE 
					{
						$nxt_wrk_iss_rec_date 	= explode("-",$request->get('nxt_wrk_iss_rec_date'));
						$nxt_wrk_iss_rec_date 	= $nxt_wrk_iss_rec_date[2]."-".$nxt_wrk_iss_rec_date[1]."-".$nxt_wrk_iss_rec_date[0];

						########-[ WORK STATUS - OPEN will be INSERTED AUTOMATICALLY TO ISSUE OF NEXT DAY/SELECTED DATE
						//$QRinstOPtoISS = "INSERT INTO `prod_iss_rec`(`type`, `trans_no`, `trans_date`, `po_id`, `dept_id`, `employee_id`, `fitting_id`, `notes`, `wgt`, `no_of_pieces`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('iss', '$tran_no', '".$nxt_wrk_iss_rec_date."', '$po_id', '$dept', '$emp', '$fitting_id', '$notes', '$wgt', '$pieces', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
						$QRinstOPtoISS = "INSERT INTO `prod_iss_rec`(`type`, `trans_no`, `trans_date`, `po_id`, `dept_id`, `employee_id`, `fitting_id`, `notes`, `wgt`, `no_of_pieces`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('iss', '$tran_no', '".$nxt_wrk_iss_rec_date."', '$po_id', '$next_dept', '".$request->get('next_emp')."', '$fitting_id', '$notes', '$wgt', '$pieces', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
						$CNexecOPtoISS = $connection->executeQuery($QRinstOPtoISS);
					}					
				}
				else	#--------[ INSERT OTHER DEPT - CONDITION
				{
					########-[ INSERT OTHER DEPT without (ST WGT, ST PCS)
					$QRinsert = "INSERT INTO `prod_iss_rec`(`type`, `trans_no`, `trans_date`, `po_id`, `dept_id`, `employee_id`, `fitting_id`, `notes`, `wgt`, `rec_wgt`, `no_of_pieces`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('$type', '$tran_no', '$iss_rec_date', '$po_id', '$dept', '$emp', '$fitting_id', '$notes', '$wgt', '$recovery_wgt', '$pieces', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
					$CNexecut = $connection->executeQuery($QRinsert);

					if($dept == 13 && $type == 'rec') #-------- WHILE REC IN BUFF DEPT. AUTOMATICALLY IT INSERTS Sandblast too
					{
						$QRinsert = "INSERT INTO `prod_iss_rec`(`type`, `trans_no`, `trans_date`, `po_id`, `dept_id`, `employee_id`, `fitting_id`, `notes`, `wgt`, `no_of_pieces`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('iss', '$tran_no', '$iss_rec_date', '$po_id', '10', '$emp', '$fitting_id', '$notes', '$wgt', '$pieces', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
						$CNexecut = $connection->executeQuery($QRinsert);					
					}
					
					if($work_status == "1" && $type == 'rec') #----[ OPEN status into ISSUE 
					{
						$nxt_wrk_iss_rec_date 	= explode("-",$request->get('nxt_wrk_iss_rec_date'));
						$nxt_wrk_iss_rec_date 	= $nxt_wrk_iss_rec_date[2]."-".$nxt_wrk_iss_rec_date[1]."-".$nxt_wrk_iss_rec_date[0];

						########-[ WORK STATUS - OPEN will be INSERTED AUTOMATICALLY TO ISSUE OF NEXT DAY/SELECTED DATE
						$QRinstOPtoISS = "INSERT INTO `prod_iss_rec`(`type`, `trans_no`, `trans_date`, `po_id`, `dept_id`, `dept_flag`, `employee_id`, `fitting_id`, `notes`, `wgt`, `no_of_pieces`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('iss', '$tran_no', '".$nxt_wrk_iss_rec_date."', '$po_id', '$dept', 's', '$emp', '$fitting_id', '$notes', '$wgt', '$pieces', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
						$CNexecOPtoISS = $connection->executeQuery($QRinstOPtoISS);
					}
					else if($type == 'rec' && $work_status == "0" && $next_dept != "")	#----[ CLOSING status inserted to next department
					{
						$nxt_wrk_iss_rec_date 	= explode("-",$request->get('nxt_wrk_iss_rec_date'));
						$nxt_wrk_iss_rec_date 	= $nxt_wrk_iss_rec_date[2]."-".$nxt_wrk_iss_rec_date[1]."-".$nxt_wrk_iss_rec_date[0];

						########-[ WORK STATUS - CLOSE will be INSERTED AUTOMATICALLY TO NEXT DEPARTMENT in ISSUE
						$QRinstOPtoISS = "INSERT INTO `prod_iss_rec`(`type`, `trans_no`, `trans_date`, `po_id`, `dept_id`, `dept_flag`, `employee_id`, `fitting_id`, `notes`, `wgt`, `no_of_pieces`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('iss', '$tran_no', '".$nxt_wrk_iss_rec_date."', '$po_id', '$next_dept', 's', '".$request->get('next_emp')."', '$fitting_id', '$notes', '$wgt', '$pieces', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
						$CNexecOPtoISS = $connection->executeQuery($QRinstOPtoISS);					
					}
				}*/
			}
			else
			{
				if($prdISSrecRWcn == 1)
				{	
														/* `po_open_ord_id`='$po_open_ord_id', `po_id`='$po_id', */
					$qury = "UPDATE `prod_iss_rec` SET `employee_id`='$emp', `notes`='$notes', `no_of_pieces`='$pieces', `wgt`='$wgt', `enam_wgt`='$ENMwgt', `st_pcs`='$STpieces', `st_wt`='$STwgt', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `prod_iss_rec_id`='$prodIssRecID'";
					$exec = $connection->executeQuery($qury);
				}
				else
				{
					if($prdISSrecRWcnJCwise == 1)
					{
					
						$qury = "UPDATE `prod_iss_rec` SET `employee_id`='$emp', `notes`='$notes', `no_of_pieces`='$pieces', `wgt`='$wgt', `enam_wgt`='$ENMwgt', `st_pcs`='$STpieces', `st_wt`='$STwgt', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `prod_iss_rec_id`='$prodIssRecID'";
						$exec = $connection->executeQuery($qury);					
					}
					else
					{
						$qury1 = "UPDATE `prod_iss_rec` SET `notes`='$notes', `no_of_pieces`='$pieces', `wgt`='$wgt', `enam_wgt`='$ENMwgt', `st_pcs`='$STpieces', `st_wt`='$STwgt', `work_status`='$work_status', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `prod_iss_rec_id`='$prodIssRecID'";
						$exec1 = $connection->executeQuery($qury1);

						$qury2 = "UPDATE `prod_iss_rec` SET `no_of_pieces`='$pieces', `wgt`='$wgt', `enam_wgt`='$ENMwgt', `trans_date`='$nxtWrkIssTecDat', `dept_id`='$next_dept', `employee_id`='$next_emp', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `prod_iss_rec_id`='".$FTCHtransNXTrecDATA['prodISSrecID']."'";
						$exec2 = $connection->executeQuery($qury2);
					}
				}

				/*				
				if(($dept == 5 || $dept == 11 || $dept == 13 || $dept == 14) && ($type == 'rec'))
				{
					########-[ UPDATE REC WGT - Only for Papper Wheel, Buff, Buff Wheel
					$QRupdate = "UPDATE `prod_iss_rec` SET `rec_wgt`='$wgt' WHERE `rec_wgt`='$searchRECwgt' AND `dept_id`='$dept' AND `update_dt`='$searchUPDdat'";
					$CNexecut = $connection->executeQuery($QRupdate);
					
					$work_status = 0; #-- AFTER ABOVE UPDATE, REGULAT REC. WGT ENTRY POSTED WITH WORK STATUS 0 As DEFAULT as WORK STATUS CLOSED AUTOMATICALLY
				}
				
				if($dept == 1)	#--------[ UPDATE STONE SETTINGS(DEPT) - CONDITION
				{			
					########-[ UPDATE STONE SETTINGS with (ST WGT, ST PCS)
					$QRupdate = "UPDATE `prod_iss_rec` SET `type`='$type', `trans_no`='$tran_no', `trans_date`='$iss_rec_date', `po_id`='$po_id', `dept_id`='$dept', `employee_id`='$emp', `fitting_id`='$fitting_id', `notes`='$notes', `wgt`='$wgt', spare_wgt='$spare_wgt', enam_wgt='$ENMwgt', st_wt='$STwgt', `purity`='$purity', `no_of_pieces`='$pieces', `st_wt`='".$request->get('STwgt')."', `st_pcs`='".$request->get('STpieces')."', `work_status`='$work_status', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `prod_iss_rec_id`='$prodIssRecID'";
					$CNexecut = $connection->executeQuery($QRupdate);
					
					if($work_status == "1" && $type == 'rec') #----[ OPEN status into ISSUE 
					{
						$nxt_wrk_iss_rec_date 	= explode("-",$request->get('nxt_wrk_iss_rec_date'));
						$nxt_wrk_iss_rec_date 	= $nxt_wrk_iss_rec_date[2]."-".$nxt_wrk_iss_rec_date[1]."-".$nxt_wrk_iss_rec_date[0];
						
						########-[	GETTING RELATED ROW to UPDATE
						$SLCTgetID 	= "SELECT `trans_no`, `post_dt` FROM `prod_iss_rec` WHERE `prod_iss_rec_id`='$prodIssRecID'";
						$CONNgetID 	= $connection->executeQuery($SLCTgetID);
						$FTCHgetID 	= $CONNgetID->fetchAll();
						$trans_no	= $FTCHgetID[0]['trans_no'];
						$RSLTpostDt = $FTCHgetID[0]['post_dt'];

						########-[ WORK STATUS - OPEN will be UPDATE AUTOMATICALLY TO ISSUE OF NEXT DAY/SELECTED DATE
						//echo
						$QRupdateOPtoISS = "UPDATE `prod_iss_rec` SET `type`='iss', `trans_no`='$tran_no', `trans_date`='".$nxt_wrk_iss_rec_date."', `po_id`='$po_id', `dept_id`='$dept', `employee_id`='$emp', `fitting_id`='$fitting_id', `notes`='$notes', `wgt`='$wgt', spare_wgt='$spare_wgt', enam_wgt='$ENMwgt', st_wt='$STwgt', `purity`='$purity', `no_of_pieces`='$pieces', `work_status`='$work_status', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `post_dt`='$RSLTpostDt' AND `type`='iss' AND `trans_no`='$trans_no'";
						$CNexecutOPtoISS = $connection->executeQuery($QRupdateOPtoISS);						
					}					
				}
				else	#--------[ UPDATE OTHER DEPT - CONDITION
				{
					########-[ UPDATE OTHER DEPT without (ST WGT, ST PCS)
					$QRupdate = "UPDATE `prod_iss_rec` SET `type`='$type', `trans_no`='$tran_no', `trans_date`='$iss_rec_date', `po_id`='$po_id', `dept_id`='$dept', `employee_id`='$emp', `fitting_id`='$fitting_id', `notes`='$notes', `wgt`='$wgt', spare_wgt='$spare_wgt', enam_wgt='$ENMwgt', st_wt='$STwgt', `rec_wgt`='$recovery_wgt', `purity`='$purity', `no_of_pieces`='$pieces', `work_status`='$work_status', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `prod_iss_rec_id`='$prodIssRecID'";
					$CNexecut = $connection->executeQuery($QRupdate);

					if($work_status == "1" && $type == 'rec') #----[ OPEN status into ISSUE 
					{
						$nxt_wrk_iss_rec_date 	= explode("-",$request->get('nxt_wrk_iss_rec_date'));
						$nxt_wrk_iss_rec_date 	= $nxt_wrk_iss_rec_date[2]."-".$nxt_wrk_iss_rec_date[1]."-".$nxt_wrk_iss_rec_date[0];
						
						########-[	GETTING RELATED ROW to UPDATE
//						$SLCTgetID 	= "SELECT `trans_no`, `post_dt` FROM `prod_iss_rec` WHERE `prod_iss_rec_id`='$prodIssRecID'";
						$SLCTgetID 	= "SELECT `trans_no`, `post_dt` FROM `prod_iss_rec` WHERE `trans_no`='$tran_no'";
						$CONNgetID 	= $connection->executeQuery($SLCTgetID);
						$FTCHgetID 	= $CONNgetID->fetchAll();
						$CONTgetID 	= count($FTCHgetID);
						$trans_no	= $FTCHgetID[0]['trans_no'];
						$RSLTpostDt = $FTCHgetID[0]['post_dt'];
						
						########-[ WORK STATUS - OPEN will be UPDATE AUTOMATICALLY TO ISSUE OF NEXT DAY/SELECTED DATE
//						$QRupdateOPtoISS = "UPDATE `prod_iss_rec` SET `type`='iss', `trans_no`='$tran_no', `trans_date`='".$nxt_wrk_iss_rec_date."', `po_id`='$po_id', `dept_id`='$dept', `employee_id`='$emp', `fitting_id`='$fitting_id', `notes`='$notes', `wgt`='$wgt', `purity`='$purity', `no_of_pieces`='$pieces', `work_status`='$work_status', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `post_dt`='$RSLTpostDt' AND `type`='iss' AND `trans_no`='$trans_no'";
//						$CNexecutOPtoISS = $connection->executeQuery($QRupdateOPtoISS);			
						
						if($CONTgetID == 1)
						{
							########-[ WORK STATUS - OPEN will be INSERTED AUTOMATICALLY TO ISSUE OF NEXT DAY/SELECTED DATE
							$QRinstOPtoISS = "INSERT INTO `prod_iss_rec`(`type`, `trans_no`, `trans_date`, `po_id`, `dept_id`, `employee_id`, `fitting_id`, `notes`, `wgt`, spare_wgt, enam_wgt, st_wt, `no_of_pieces`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('iss', '$tran_no', '".$nxt_wrk_iss_rec_date."', '$po_id', '$dept', '$emp', '$fitting_id', '$notes', '$wgt', '$spare_wgt', '$ENMwgt', '$STwgt', '$pieces', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
							$CNexecOPtoISS = $connection->executeQuery($QRinstOPtoISS);
						}
						else if($CONTgetID == 2)
						{
							########-[ WORK STATUS - OPEN will be UPDATE AUTOMATICALLY TO ISSUE OF NEXT DAY/SELECTED DATE
							$QRupdateOPtoISS = "UPDATE `prod_iss_rec` SET `trans_no`='$tran_no', `trans_date`='".$nxt_wrk_iss_rec_date."', `po_id`='$po_id', `dept_id`='$dept', `employee_id`='$emp', `fitting_id`='$fitting_id', `notes`='$notes', `wgt`='$wgt', spare_wgt='$spare_wgt', enam_wgt='$ENMwgt', st_wt='$STwgt', `purity`='$purity', `no_of_pieces`='$pieces', `work_status`='$work_status', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `type`='iss' AND `trans_no`='$trans_no'"; // `post_dt`='$RSLTpostDt' AND 
							$CNexecutOPtoISS = $connection->executeQuery($QRupdateOPtoISS);						
						
						}
					}
					else if($type == 'rec' && $work_status == "0" && $next_dept == "")
					{
						########-[	GETTING ID to DELETE ISSUED ON NEXT DAY/SELECTED DATE
						$QURYdltISS	= "DELETE FROM `prod_iss_rec` WHERE `trans_no`='$tran_no' AND `type`='iss'";
						$CONNdltISS	= $connection->executeQuery($QURYdltISS);
					}	
					else if($type == 'rec' && $work_status == "0" && $next_dept != "")
					{
						$nxt_wrk_iss_rec_date 	= explode("-",$request->get('nxt_wrk_iss_rec_date'));
						$nxt_wrk_iss_rec_date 	= $nxt_wrk_iss_rec_date[2]."-".$nxt_wrk_iss_rec_date[1]."-".$nxt_wrk_iss_rec_date[0];
						
						########-[ GETTING ID to UPDATE row ON NEXT DAY/SELECTED DATE
						$SLCTgetIDtoUPD	= "SELECT MAX(`prod_iss_rec_id`) AS dltID, COUNT(`trans_no`) AS cntTRANno FROM `prod_iss_rec` WHERE `trans_no`='$tran_no'";
						$CONNgetIDtoUPD	= $connection->executeQuery($SLCTgetIDtoUPD);
						$FTCHgetIDtoUPD	= $CONNgetIDtoUPD->fetchAll();
						$RSLTgetIDtoUPD	= $FTCHgetIDtoUPD[0]['dltID'];
						$RSLTcntTRANno	= $FTCHgetIDtoUPD[0]['cntTRANno'];
						
						if($RSLTcntTRANno == 1)	#--------[ INSERTING DATA's TO NEXT DEPT. while updating 
						{
							$QRinstOPtoISS = "INSERT INTO `prod_iss_rec`(`type`, `trans_no`, `trans_date`, `po_id`, `dept_id`, `dept_flag`, `employee_id`, `fitting_id`, `notes`, `wgt`, spare_wgt, enam_wgt, st_wt, `no_of_pieces`, `purity`, `work_status`, `post_by`, `post_dt`) VALUES ('iss', '$tran_no', '".$nxt_wrk_iss_rec_date."', '$po_id', '$next_dept', 's', '".$request->get('next_emp')."', '$fitting_id', '$notes', '$wgt', '$spare_wgt', '$ENMwgt', '$STwgt', '$pieces', '$purity', '$work_status', '$sessionId', '$nwDateTime')";
							$CNexecOPtoISS = $connection->executeQuery($QRinstOPtoISS);
						}
						else if($RSLTcntTRANno == 2)	#--------[ UPDATING DATA's TO NEXT DEPT. while updating 
						{
							$QRupdate = "UPDATE `prod_iss_rec` SET `type`='iss', `trans_no`='$tran_no', `trans_date`='".$nxt_wrk_iss_rec_date."', `po_id`='$po_id', `dept_id`='$next_dept', `employee_id`='".$request->get('next_emp')."', `fitting_id`='$fitting_id', `notes`='$notes', `wgt`='$wgt', spare_wgt='$spare_wgt', enam_wgt='$ENMwgt', st_wt='$STwgt', `purity`='$purity', `no_of_pieces`='$pieces', `work_status`='$work_status', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `prod_iss_rec_id`='$RSLTgetIDtoUPD'";
							$CNexecut = $connection->executeQuery($QRupdate);
						}
					}	
					else if($type == 'iss')
					{
						########-[ GETTING ID to DELETE ISSUED ON NEXT DAY/SELECTED DATE
						$SLCTgetIDtoDLT	= "SELECT MAX(`prod_iss_rec_id`) AS dltID, count(`trans_no`) AS contTRANno FROM `prod_iss_rec` WHERE `trans_no`='$tran_no'";
						$CONNgetIDtoDLT	= $connection->executeQuery($SLCTgetIDtoDLT);
						$FTCHgetIDtoDLT	= $CONNgetIDtoDLT->fetchAll();
						$RSLTgetIDtoDLT	= $FTCHgetIDtoDLT[0]['dltID'];
						
						if($contTRANno == 2)
						{
						########-[ DELETE ISSUED ON NEXT DAY/SELECTED DATE
						$QURYdltISS	= "DELETE FROM `prod_iss_rec` WHERE `prod_iss_rec_id`='".$RSLTgetIDtoDLT."' AND `type`='iss'";
						$CONNdltISS	= $connection->executeQuery($QURYdltISS);
						}
					}						
				}
				*/
			}
//die();
		return $this->redirectToRoute('prod-iss-rec-data', array('prodIssRecID' => $prodIssRecID) );		
		}
		
		
		return $this->render('prod-iss-rec/prod-iss-rec-data.html.twig', [
			'poLIST' => $FTCHpoLIST,
			//'jcLIST' => $FTCHjcLIST,
			'jcLIST' => $jcLIST,
			'transNO' => $RSLTtransNO,
			'deptlist' => $FTCHdeptlist,
			'emplist' => $FTCHemplist,
			'fittingsLT' => $FTCHfittingsLT,
			'prodTRANSlist' => $FTCHtranslist,
			'issRECtranDATA' => $issRECtranDATA,
			'FTCHtransDATA' => $FTCHtransDATA,
			'issDATAview' => $issDATAview,
			'RSLTgetNXTDT' => $RSLTgetNXTDT,
			'FTCHnextTRANSdate' => $FTCHnextTRANSdate,
			'FTCHtransNXTrecDATA' => $FTCHtransNXTrecDATA,
			'prdISSrecRWcn' => $prdISSrecRWcn,
			'jcNO' => $RSLTjcNO,
			'controller_name' => 'ProductionIssueReceiveController'
        ]);
    }	
	
}
