<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class PoController extends AbstractController
{

	/**
     * @Route("/po-generate-submit{pordID}", name="po-generate-submit")
     */
    public function poGenerateSUBMITAct(Request $request, $pordID) 
    {	
		$session = $request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		date_default_timezone_set("Asia/Calcutta");
		
		$po_no  	 = $request->get('po_no_hidden');
		$po_noEXP	 = explode("/",$po_no);
		$po_noACCym  = $po_noEXP[0]."/".$po_noEXP[1]."/".$po_noEXP[2]."/";
		$po_no 		 = $po_noEXP[3];
		$nowTime 	 = date("H:i:s");
		$po_date  	 = $request->get('po_date_hidden');
		$po_dateEXP	 = explode("-",$po_date);
		$po_date	 = $po_dateEXP[2]."-".$po_dateEXP[1]."-".$po_dateEXP[0]." ".$nowTime;
		$item_remarks= $request->get('item_remarks');

		$party_id  	 = $request->get('party_id_hidden');
		
//		$poGENid  	 = $request->get('poGENid');
//		$poGENidEXP	 = explode(",",$poGENid);
//		$poGENidCNT	 = count($poGENidEXP);
		$sessionId   = $session->get('empId');
		$nowDateTime = date("Y-m-d H:i:s");			
		
		#--------[GET COUNT of PO DESIGN's
		$QURYcontPOdsgn	= "SELECT COUNT(`po_det_id`) AS cntPOdsgn FROM `po_det` WHERE `party_id` = ".$party_id;
		$CONNcontPOdsgn	= $connection->executeQuery($QURYcontPOdsgn);
		$FTCHcontPOdsgn	= $CONNcontPOdsgn->fetchAll();		
		$RSLTcontPOdsgn	= $FTCHcontPOdsgn[0]['cntPOdsgn'];
		
		if($pordID == 0)
		{
			#--------[GENERATE PO
			$QURY	= "INSERT INTO `po`(`po_financial_yr`, `po_no`, `po_date`, `party_id`, `item_remarks`, `post_by`, `post_dt`) VALUES ('$po_noACCym', '$po_no', '$po_date', '$party_id', '$item_remarks', '$sessionId', '$nowDateTime')";
			$CONN	= $connection->executeQuery($QURY);
			$po_id  = $connection->lastInsertId();
		}
		else if($pordID != 0)
		{
			$po_id  = $pordID;		
		}

		for($i = 0; $i <= $RSLTcontPOdsgn - 1; $i++)
		{
			#--------[UPDATE PO 
			$updtPO	= "UPDATE `po_det` SET `po_id`='".$po_id."' WHERE `party_id`='".$party_id."' AND po_id=0";
			$stmtPO	= $connection->executeQuery($updtPO);
		}
		
		return $this->redirect('po-list');
	}	
	

	/**
     * @Route("/po-list", name="po-list")  
     */
    public function poLISTact(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		########-[ GET DESIGN LIST
		//$QURYlist	= "SELECT P.po_id, CONCAT(P.po_financial_yr, P.po_no) AS poNO, DATE_FORMAT(P.po_date,'%b %d, %y - %a') AS poDATE, PR.pid AS partyCD, PR.concern_name AS partyNm, COUNT(PD.po_det_id) AS poDSGNcont, SUM(D.st_wgt * PD.qty) AS poSTwt, SUM(D.gross_wgt * PD.qty) AS poGROSSwt FROM `po` AS P, `po_det` AS PD, `party` AS PR, `designs` AS D WHERE P.po_id=PD.po_id AND PD.design_id=D.design_id AND P.party_id=PR.party_id GROUP BY poNO ORDER BY P.`po_id` DESC";
		$QURYlist	= "SELECT
							P.po_id,
							P.`ornament_stock_status`,
							CONCAT(P.po_financial_yr, P.po_no) AS poNO,
							DATE_FORMAT(P.po_date, '%b %d, %y - %a') AS poDATE,
							PR.pid AS partyCD,
							PR.concern_name AS partyNm,
							COUNT(PD.po_det_id) AS poDSGNcont,
							SUM(D.st_wgt * PD.qty) AS poSTwt,
							SUM(D.gross_wgt * PD.qty) AS poGROSSwt,
							-- GSIR.other_ids AS goldSTOCKadded,
							SUM(PD.closing_wgt) AS prodWT,
							P.po_status
						FROM
							`po` AS P
						LEFT JOIN `po_det` AS PD
						ON
							P.po_id = PD.po_id
						LEFT JOIN `designs` AS D
						ON
							PD.design_id = D.design_id
						LEFT JOIN `party` AS PR
						ON
							P.party_id = PR.party_id
						-- LEFT JOIN `gold_stock_iss_rec` AS GSIR
						-- ON
							-- GSIR.parti_id = 1 AND GSIR.other_ids = P.po_id
						GROUP BY
							poNO
						ORDER BY
							P.`ornament_stock_status` = '2',
							P.`update_dt`
						DESC
							,
							P.`po_id`
						DESC";
		$CONNlist	= $connection->executeQuery($QURYlist);
		$FTCHlist	= $CONNlist->fetchAll();
		
		return $this->render('po/po-list.html.twig', [
			'list' => $FTCHlist,
			'controller_name' => 'PoController'
        ]);
    }


	/**
     * @Route("/po-generate{pordID}", name="po-generate")
     */
    public function poGenerateAct(Request $request, $pordID) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		if($pordID == 0)
		{
			#--------[ GET CURRENT FINANCAL YEAR
			if(date('m') > 4)
			{
				$startYear 	= date('y');
				$endingYear = date('y', strtotime('+1 year'));
	//			$financalYr = $startYear."-04-01".":".$endingYear."-03-31";
				$financalYr = "PO/".$startYear."-".$endingYear;
				$financalYM = $startYear."-".$endingYear."/".date('m');
			}
			else
			{
				$startYear = date('y', strtotime('-1 year'));
				$endingYear = date('y');
	//			$financalYr = $startYear."-04-01".":".$endingYear."-03-31";
				$financalYr = "PO/".$startYear."-".$endingYear;
				$financalYM = $startYear."-".$endingYear."/".date('m');
			}
		
			#--------[ GET - PO AUTO GENERATE NO
			$QURYpoAUTOGENno = "SELECT MAX(LPAD(`po_no` + 1, 4, '0')) AS POno FROM `po` WHERE `po_financial_yr` LIKE '".$financalYr."%'";
		}
		else if($pordID != 0)
		{
			#--------[ GET - PO NO from PO TABLE
			$QURYpoAUTOGENno = "SELECT CONCAT(P.po_financial_yr,'',po_no) AS POno, DATE_FORMAT(P.po_date,'%b %d, %y - %a') AS POdate, P.party_id, CONCAT(PRT.pid,' - ',PRT.concern_name) AS partyNAME, P.item_remarks FROM `po` AS P, party AS PRT WHERE P.`po_id` ='".$pordID."' AND P.party_id=PRT.party_id";
		}
		$CONNpoAUTOGENno = $connection->executeQuery($QURYpoAUTOGENno);
		$FTCHpoAUTOGENno = $CONNpoAUTOGENno->fetchAll();
		
		if($pordID == 0)
		{
			if(!isset($FTCHpoAUTOGENno[0]['POno']))
			{
				$poGENno 	= "PO/".$financalYM."/0001";
				$poGENdt	= "";
				$poPARTYid	= "";
				$partyNAME	= "";
				$itemRemrks = "";
			}
			else
			{
				$poGENno 	= "PO/".$financalYM."/".$FTCHpoAUTOGENno[0]['POno'];
				$poGENdt	= "";
				$poPARTYid	= "";	
				$partyNAME	= "";	
				$itemRemrks = "";						
			}
		}
		else if($pordID != 0)
		{	
			$poGENno 	= $FTCHpoAUTOGENno[0]['POno'];
			$poGENdt 	= $FTCHpoAUTOGENno[0]['POdate'];
			$poPARTYid	= $FTCHpoAUTOGENno[0]['party_id'];
			$partyNAME	= $FTCHpoAUTOGENno[0]['partyNAME'];
			$itemRemrks = $FTCHpoAUTOGENno[0]['item_remarks'];
		}

		#-------- FETCH LIST OF PARTIES
		$QURYparties	= "SELECT * FROM `party` WHERE `role_status`=1 ORDER BY `pid` ASC";
		$CONNparties	= $connection->executeQuery($QURYparties);
		$FTCHparties	= $CONNparties->fetchAll();
		
		#-------- FETCH LIST OF CATEGORIES
		$QURYcategories	= "SELECT
								CAT.design_cat_id,
								CAT.design_cat_name
							FROM
								`design_cat` AS CAT
							WHERE
								EXISTS(
								SELECT
									SCAT.design_cat_id
								FROM
									`design_subcat` AS SCAT,
									designs AS D
								WHERE
									D.design_cat_id=CAT.design_cat_id AND D.design_subcat_id=SCAT.design_subcat_id AND D.role_status=1 
							) AND CAT.role_status = 1
							ORDER BY
								`CAT`.`design_cat_name` ASC";
								
		$CONNcategories	= $connection->executeQuery($QURYcategories);
		$FTCHcategories	= $CONNcategories->fetchAll();		
		
		if($request->getMethod() == 'POST')
		{
			$party_id		= $request->get('party_id');
			$desg_cat		= $request->get('cat_id');
			$desg_scat		= $request->get('sub_cat_id');
			$wgt_range_from	= $request->get('wgt_range_from');
			$wgt_range_to	= $request->get('wgt_range_to');
			$dsgn_type		= $request->get('dsgn_type');
			
			if($pordID == 0)
			{
				$CONDpo_id = "PD.`po_id`=0";
			}
			else if($pordID != 0)
			{
				$CONDpo_id = "PD.`po_id`='".$pordID."'";
			}
			
			if($dsgn_type == 0)
			{
				$no_of_st = "`no_of_st` = 0";
			}
			else
			{
				$no_of_st = "`no_of_st` != 0";			
			}

			$sessionId  = $session->get('empId');
			
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime = date("Y-m-d H:i:s");
			
			#--------[ SEARCH CONDITIONS
			
			if($desg_cat != "" && $desg_scat  != "" && $wgt_range_from != "" && $wgt_range_to  != "" && $dsgn_type  != "")
			{
				$whereCONDITION = "AND D.`design_cat_id` = '".$desg_cat."' AND D.`design_subcat_id` = '".$desg_scat."' AND D.`gross_wgt` BETWEEN '".$wgt_range_from."' AND '".$wgt_range_to."' AND ".$no_of_st." ";
			}
			else if($desg_cat != "" && $wgt_range_from != "" && $wgt_range_to  != "" && $dsgn_type  != "")
			{
				$whereCONDITION = "AND D.`design_cat_id` = '".$desg_cat."' AND D.`gross_wgt` BETWEEN '".$wgt_range_from."' AND '".$wgt_range_to."' AND ".$no_of_st." ";
			}
			else if($desg_cat != "" && $desg_scat  != "" && $wgt_range_from != "" && $wgt_range_to != "")
			{
				$whereCONDITION = "AND D.`design_cat_id` = '".$desg_cat."' AND D.`design_subcat_id` = '".$desg_scat."' AND D.`gross_wgt` BETWEEN '".$wgt_range_from."' AND '".$wgt_range_to."'";
			}
			else if($desg_cat != "" && $wgt_range_from != "" && $wgt_range_to  != "")
			{
				$whereCONDITION = "AND D.`design_cat_id` = '".$desg_cat."' AND D.`gross_wgt` BETWEEN '".$wgt_range_from."' AND '".$wgt_range_to."'";
			}			
			else if($desg_cat != "" && $desg_scat  != "")
			{
				$whereCONDITION = "AND D.`design_cat_id` = '".$desg_cat."' AND D.`design_subcat_id` = '".$desg_scat."'";
			}
			else if($desg_cat != "" && $dsgn_type  != "")
			{
				$whereCONDITION = "AND D.`design_cat_id` = '".$desg_cat."' AND ".$no_of_st." ";
			}
			else if($desg_cat != "")
			{
				$whereCONDITION = "AND D.`design_cat_id` = '".$desg_cat."'";
			}
			
						
			#--------[ FETCH - SUB CAT from SELECTED CAT to RETAIN AFTER SEARCH SUBMIT
			$QurySUBcat	= "SELECT SC.design_subcat_id, SC.design_subcat_name FROM `design_subcat` AS SC, design_cat AS C WHERE SC.design_cat_id='".$desg_cat."' AND SC.design_cat_id=C.design_cat_id ORDER BY SC.design_subcat_name ASC";
			$stmtSUBcat	= $connection->executeQuery($QurySUBcat);
			$listSUBcat  = $stmtSUBcat->fetchAll();
			
			#--------[ FETCH - DESINGS ALREADY ADDES in PO with a PARTICULAR PARTY
			$QuryPARTYdsgn	= "SELECT D.design_id, D.design_no, D.no_of_st, D.st_wgt, D.gross_wgt, PD.qty, PD.po_det_id FROM `po_det` AS PD, designs AS D WHERE PD.`party_id`='".$party_id."' AND PD.`design_id`=D.`design_id` AND ".$CONDpo_id." ORDER BY D.design_no ASC";
			$stmtPARTYdsgn	= $connection->executeQuery($QuryPARTYdsgn);
			$listPARTYdsgn  = $stmtPARTYdsgn->fetchAll();
			$contPARTYdsgn  = count($listPARTYdsgn);			
			
			#--------[ FETCH SEARCH DESIGNS to GENEATE PO
			//$QURYsearchDSGN	= "SELECT * FROM `designs` WHERE `design_cat_id`='".$desg_cat."' AND `design_subcat_id`='".$desg_scat."' AND `gross_wgt` BETWEEN '".$wgt_range_from."' AND '".$wgt_range_to."' AND ".$no_of_st;
			$QURYsearchDSGN	= "SELECT
									D.design_id, D.design_no, D.no_of_st, D.st_wgt, D.gross_wgt
								FROM
									`designs` AS D
								WHERE NOT
									EXISTS(
									SELECT
										PD.po_id
									FROM
										`po_det` AS PD
									WHERE
										PD.design_id = D.design_id AND D.role_status = 1  AND PD.`party_id`='".$party_id."' AND ".$CONDpo_id."
								) ".$whereCONDITION."
								ORDER BY
									D.design_no ASC";
									
			$CONNsearchDSGN	= $connection->executeQuery($QURYsearchDSGN);
			$FTCHsearchDSGN	= $CONNsearchDSGN->fetchAll();
			
			//return $this->redirectToRoute("po-generate", array("pordID" => $pordID));
		}
		else
		{
			#--------[ FETCH - DESINGS ALREADY ADDES in PO with a PARTICULAR PARTY
			$QuryPARTYdsgn	= "SELECT D.design_id, D.design_no, D.no_of_st, D.st_wgt, D.gross_wgt, PD.qty, PD.po_det_id FROM `po_det` AS PD, designs AS D WHERE PD.`party_id`='".$poPARTYid."' AND PD.`design_id`=D.`design_id` AND PD.`po_id`='".$pordID."' ORDER BY D.design_no ASC";
			$stmtPARTYdsgn	= $connection->executeQuery($QuryPARTYdsgn);
			$listPARTYdsgn  = $stmtPARTYdsgn->fetchAll();		
		
			$contPARTYdsgn  = "";
			//$listPARTYdsgn  = "";
			$listSUBcat		= "";
			$FTCHsearchDSGN = "";
			$dsgn_type		= "";
		}
		
		return $this->render('po/po-generate.html.twig', [
			'postPARTYid' => $party_id,
			'postCATid' => $desg_cat,
			'listSUBcat' => $listSUBcat,
			'postSCATid' => $desg_scat,
			'postWGTrngFRM' => $wgt_range_from,
			'postWGTrngTO' => $wgt_range_to,
			'postDSGNtype' => $dsgn_type,
			'poGENno' => $poGENno,
			'poGENdt' => $poGENdt,
			'poPARTYid' => $poPARTYid,
			'partyNAME' => $partyNAME,
			'parties' => $FTCHparties,
			'categories' => $FTCHcategories,
			'desgCAT' => $FTCHdesgCAT,
			'desgSCAT' => $FTCHdesgSCAT,
			'searchDSGN' => $FTCHsearchDSGN,
			'partyDSGNS' => $listPARTYdsgn,
			'contPARTYdsgn' => $contPARTYdsgn,
			'itemRemrks' => $itemRemrks,
			'controller_name' => 'PoController'
        ]);
    }	
	
	
   /** 
	* @Route("/poGEN", name="poGEN") 
	*/ 
	public function poGENact(Request $request) 
	{ 
		$session 	= $request->getSession();
		
	    $connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$pordID  	= $request->get('pordID');
		$party_id  	= $request->get('party_id');
		$poGENid  	= $request->get('poGENid');
		$poGENidEXP	= explode(",",$poGENid);
		$poGENidCNT	= count($poGENidEXP);

		$poGENdsgnQY= $request->get('poGENdsgnQTY');
		$poGENdqtEXP= explode(",",$poGENdsgnQY);		
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");			
		
		if($pordID == 0)
		{
			$po_id  = 0;	
			$poCOND = "`po_id`=0";
		}
		else if($pordID != 0)
		{
			$po_id  = $pordID;
			$poCOND = "`po_id`='".$pordID."'";
		}

		#--------[CHECK DUPLICATION. DELETE ALL OLD ENTRIES AND MAINT. CURRENT ENTRIES
		$QURY	= "DELETE FROM `po_det` WHERE ".$poCOND." AND `party_id`=".$party_id;
		$CONN	= $connection->executeQuery($QURY);

		for($i = 0; $i <= $poGENidCNT - 1; $i++)
		{
			$poGENdsgnID  = $poGENidEXP[$i];
			$poGENdsgnQTY = $poGENdqtEXP[$i];
			
			#--------[FETCH CAT & SUB CAT ID of DESIGN
			$QURYgetDSGNdt	= "SELECT * FROM `designs` WHERE `design_id`=".$poGENdsgnID;
			$CONNgetDSGNdt	= $connection->executeQuery($QURYgetDSGNdt);
			$FTCHgetDSGNdt	= $CONNgetDSGNdt->fetchAll();			
			
			#--------[INSERT PO DESIGN
			$instPOdesgDET	= "INSERT INTO `po_det`(`po_id`, `party_id`, `design_cat_id`, `design_subcat_id`, `design_id`, `qty`, `post_by`, `post_dt`) VALUES ('$pordID', '$party_id', '".$FTCHgetDSGNdt[0]['design_cat_id']."', '".$FTCHgetDSGNdt[0]['design_subcat_id']."', '".$FTCHgetDSGNdt[0]['design_id']."', '".$poGENdsgnQTY."', '".$sessionId."', '$nowDateTime')";
			$stmtPOdesgDET	= $connection->executeQuery($instPOdesgDET);
		}

		$rslt = $party_id;
		return  new JsonResponse($rslt);
	} 
	
	
   /** 
	* @Route("/updtPOdsgnQTY", name="updtPOdsgnQTY") 
	*/ 
	public function updtPOdsgnQTYact(Request $request) 
	{ 
		$session 	= $request->getSession();
		
	    $connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$qty  		= $request->get('q');
		$po_det_id  = $request->get('i');
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");			
		

		$QURY	= "UPDATE `po_det` SET `qty`='$qty',`update_by`='$sessionId',`update_dt`='$nowDateTime' WHERE `po_det_id`=".$po_det_id;
		$CONN	= $connection->executeQuery($QURY);

		$rslt = "success";
		return  new JsonResponse($rslt);
	} 	
	
	
		/**
     * @Route("/po-move-gold-ornament-stock{poSTOCKid}", name="po-move-gold-ornament-stock")  
     */
    public function poMoveGoldOrnamentStockACT(Request $request, $poSTOCKid) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");				

		########-[ MOVE to GOLD ORNAMENT STOCK
		$updtMOVEpoORNstock	= "UPDATE `po` SET `ornament_stock_status`='1',`update_by`='$sessionId',`update_dt`='$nowDateTime' WHERE `po_id`=".$poSTOCKid;
		$stmtMOVEpoORNstock	= $connection->executeQuery($updtMOVEpoORNstock);
		
		return $this->redirect('po-list');
    }

	
    /**
     * @Route("/po-design-list{poLISTid}", name="po-design-list") 
     */
    public function poDesignListACT(Request $request, $poLISTid) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		#--------[ FTCH PO DATE & PO NO
		$QURYpoNOdt		= "SELECT DATE_FORMAT(`po_date`,'%b %d, %Y - %M') AS poDATE, CONCAT(po_financial_yr,'',po_no) AS poNO FROM `po` WHERE `po_id`=".$poLISTid;			
		$CONNpoNOdt		= $connection->executeQuery($QURYpoNOdt);
		$FTCHpoNOdt		= $CONNpoNOdt->fetchAll();
		$FTCHpoNOdt['poDATE'] 	= $FTCHpoNOdt[0]['poDATE'];
		$FTCHpoNOdt['poNO'] 	= $FTCHpoNOdt[0]['poNO'];	
		
		
		#--------[ FTCH PO CLOSING QTY & WGT
		$QURYpoQTYwgt	= "SELECT SUM(`closing_qty`) AS closingQTY, FORMAT(SUM(`closing_wgt`), 3) AS closingWGT FROM `po_det` WHERE `po_id`=".$poLISTid;			
		$CONNpoQTYwgt	= $connection->executeQuery($QURYpoQTYwgt);
		$FTCHpoQTYwgt	= $CONNpoQTYwgt->fetchAll();
		$FTCHpoQTYwgt['closingQTY']	= $FTCHpoQTYwgt[0]['closingQTY'];
		$FTCHpoQTYwgt['closingWGT']	= $FTCHpoQTYwgt[0]['closingWGT'];			
		
		
		#--------[ FTCH PO DESIGN LIST
		$QURYpoDSGNlist	= "SELECT DC.design_cat_name, DSC.design_subcat_name, D.design_no, POD.qty AS poQTY, POD.closing_qty, POD.closing_wgt, D.design_id, POD.po_det_id, D.gross_wgt, PO.ornament_stock_status FROM `po` AS PO, `po_det` AS POD, designs AS D, design_cat AS DC, design_subcat AS DSC WHERE POD.design_id = D.design_id AND POD.design_cat_id = DC.design_cat_id AND POD.design_subcat_id = DSC.design_subcat_id AND POD.role_status = 1 AND POD.po_id = '$poLISTid' AND POD.po_id=PO.po_id ORDER BY D.design_no ASC";			
		$CONNpoDSGNlist	= $connection->executeQuery($QURYpoDSGNlist);
		$FTCHpoDSGNlist	= $CONNpoDSGNlist->fetchAll();
		$ornamentStckST = $FTCHpoDSGNlist[0]['ornament_stock_status'];
		
		return $this->render('po/po-design-list.html.twig', [
			'FTCHpoNOdt' => $FTCHpoNOdt,
			'FTCHpoQTYwgt' => $FTCHpoQTYwgt,
			'poDSGNlist' => $FTCHpoDSGNlist,
			'ornamentStckST' => $ornamentStckST,
			'controller_name' => 'ProductionDailyClosingController'
        ]);
    }	
}