<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class MetalDeptController extends AbstractController
{

    /**
     * @Route("/metal-receipt-data{mrID}", name="metal-receipt-data") 
     */
    public function metalRECEIPTdatatActions(Request $request, $mrID)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		
		#--------[ FETCH - PARTY DATA's
		$QURYpartDATAs = "SELECT `party_id`, CONCAT(`concern_name`,' - ',`party_name`,' - [',`pid`,']') AS partyName FROM `party` WHERE `role_status`=1 ORDER BY `concern_name` ASC";
		$CONNpartDATAs = $connection->executeQuery($QURYpartDATAs);
		$FTCHpartDATAs = $CONNpartDATAs->fetchAll();		
		
		########-[ QUICK VARIABLES
		$tableName	= "party_metal_receipt";
		$tablePrmID	= "party_metal_receipt_id";
		$getVARIid	= $mrID;
				
		########-[ LIST 
		$QURYlistDet = "SELECT PMR.`party_metal_receipt_id`, CONCAT(P.`concern_name`,' - ',P.`party_name`,' - [',P.`pid`,']') AS partyName, FORMAT(PMR.`purity` , 2) AS purity, FORMAT(PMR.`rec_wgt`, 2) AS rec_wgt, FORMAT(PMR.`conversion_perc`, 2) AS conversion_perc, FORMAT(PMR.`conversion_wgt`, 2) AS conversion_wgt, E.`emp_name`, DATE_FORMAT(PMR.`post_dt`, '%b %d, %Y - %r') AS entryDT FROM `party_metal_receipt` AS PMR, `party` AS P, `employee` AS E WHERE PMR.`party_id`=P.`party_id` AND PMR.`role_status`=1 AND E.`employee_id`=PMR.`post_by` ORDER BY PMR.`party_metal_receipt_id` DESC";
		$CONNlistDet = $connection->executeQuery($QURYlistDet);
		$FTCHlistDet = $CONNlistDet->fetchAll();
		
		if($getVARIid != 0)
		{
			#--------[ EDIT DATA's
			$QURYupdtDet = "SELECT * FROM `party_metal_receipt` WHERE `party_metal_receipt_id`='".$getVARIid."' ";
			$CONNupdtDet = $connection->executeQuery($QURYupdtDet);
			$FTCHupdtDet = $CONNupdtDet->fetchAll();
			
			$FTCHupdtDet['party_id'] 		= $FTCHupdtDet[0]['party_id'];
			$FTCHupdtDet['purity'] 			= $FTCHupdtDet[0]['purity'];
			$FTCHupdtDet['rec_wgt'] 		= $FTCHupdtDet[0]['rec_wgt'];
			$FTCHupdtDet['conversion_perc']	= $FTCHupdtDet[0]['conversion_perc'];
			$FTCHupdtDet['conversion_wgt'] 	= $FTCHupdtDet[0]['conversion_wgt'];
		}
		
		if($request->getMethod() == 'POST')
		{
			$party_id  		= $request->get('party_id');
			$purity 		= $request->get('purity');
			$rec_wgt		= $request->get('rec_wgt');
			$conver_perc  	= $request->get('conver_perc');
			$conver_wgt  	= $request->get('conver_wgt');
			
			if($getVARIid == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO ".$tableName."(`party_id`, `purity`, `rec_wgt`, `conversion_perc`, `conversion_wgt`, `post_by`, `post_dt`) VALUES ('$party_id', '$purity', '$rec_wgt', '$conver_perc', '$conver_wgt', '$sessionId', '$nowDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
			}
			else
			{
				########-[ UPDATE - DETAILS			
				$QRupdate 	= "UPDATE ".$tableName." SET `party_id`='$party_id', `purity`='$purity', `rec_wgt`='$rec_wgt', `conversion_perc`='$conver_perc', `conversion_wgt`='$conver_wgt', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE ".$tablePrmID."=".$getVARIid;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}

		return $this->render('metal/metal-receipt-data.html.twig', [
			'partDATAs' => $FTCHpartDATAs,
			'listDet' => $FTCHlistDet,
			'FTCHupdtDet' => $FTCHupdtDet,
			'controller_name' => 'MetalDeptController'
        ]);
    }


    /**
     * @Route("/metal-name-change-list", name="metal-name-change-list")
     */
    public function metalNAMEchangeLISTact(Request $request)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		
		#--------[ FETCH
		$QURY = "SELECT MCA.`metal_conver_acces_id`, MA.`metal_accessories_name`, FORMAT(MCA.`acces_conver_wgt`, 2) AS acces_conver_wgt, FORMAT(MCA.`acces_conver_loss_wgt`, 2) AS acces_conver_loss_wgt, LENGTH(MCA.`remarks_qr`) AS remarksLENGTH, SUBSTRING(MCA.`remarks_qr`, 1,9) AS remarksSUBSTR, MCA.`remarks_qr`, E.`emp_name`, DATE_FORMAT(MCA.`post_dt`, '%b %d, %Y - %r') AS entryDT FROM `metal_conver_acces` AS MCA, `metal_accessories` AS MA, `employee` AS E WHERE MCA.`metal_accessories_id`=MA.`metal_accessories_id` AND MCA.`role_status`=1 AND E.`employee_id`=MCA.`post_by`ORDER BY MCA.`metal_conver_acces_id` DESC";
		$CONN = $connection->executeQuery($QURY);
		$FTCH = $CONN->fetchAll();		
		
		
		return $this->render('metal/metal-name-change-list.html.twig', [
			'metCONVacesLIST' => $FTCH,
			'controller_name' => 'MetalDeptController'
        ]);
    }


    /**
     * @Route("/metal-name-change-add", name="metal-name-change-add")
     */
    public function metalNAMEchangeADDact(Request $request)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");

		#--------[ FETCH - METAL REC from CASTING REC (Metal Wgt)
		$QURYcastRmtWG = "SELECT SUM(`mt_wgt`) AS CASTINGrecMETALwgt FROM `casting_rec` WHERE `role_status`=1";
		$CONNcastRmtWG = $connection->executeQuery($QURYcastRmtWG);
		$FTCHcastRmtWG = $CONNcastRmtWG->fetchAll();	
		$RSLTcastRmtWG = $FTCHcastRmtWG[0]['CASTINGrecMETALwgt'];		

		#--------[ FETCH - CONVERSTION METAL WEIGHT IN HAND
		$QURYconvMTwgt = "SELECT SUM(`conversion_wgt`) AS converTOTwgtINhand FROM `party_metal_receipt` WHERE `role_status`=1";
		$CONNconvMTwgt = $connection->executeQuery($QURYconvMTwgt);
		$FTCHconvMTwgt = $CONNconvMTwgt->fetchAll();	
		$RSLTconvMTwgt = $FTCHconvMTwgt[0]['converTOTwgtINhand'];

		#--------[ FETCH - METAL ACCESSORIES CONVER WGT
		$QURYcnvACSwgt = "SELECT SUM(`acces_conver_wgt` + `acces_conver_loss_wgt`) AS acesoMTconvWGT FROM `metal_conver_acces` WHERE `role_status`=1";
		$CONNcnvACSwgt = $connection->executeQuery($QURYcnvACSwgt);
		$FTCHcnvACSwgt = $CONNcnvACSwgt->fetchAll();		
		$RSLTcnvACSwgt = $FTCHcnvACSwgt[0]['acesoMTconvWGT'];
		
		#--------[ FETCH - CASTING METAL ISSUE TOT WGT
		$QURYcsMTissWT = "SELECT SUM(`iss_mt_wt`) AS castingISSwgt FROM `casting_iss` WHERE `role_status`=1";
		$CONNcsMTissWT = $connection->executeQuery($QURYcsMTissWT);
		$FTCHcsMTissWT = $CONNcsMTissWT->fetchAll();		
		$RSLTcsMTissWT = $FTCHcsMTissWT[0]['castingISSwgt'];	
		
		#--------[ FETCH - PROD ISS/REC - FILLING Dept. REC WEIGHT
//		$QURYprdFILrcW = "SELECT SUM(`iss_mt_wt`) AS castingISSwgt FROM `casting_iss` WHERE `role_status`=1";
//		$CONNprdFILrcW = $connection->executeQuery($QURYprdFILrcW);
//		$FTCHprdFILrcW = $CONNprdFILrcW->fetchAll();		
//		$RSLTprdFILrcW = $FTCHprdFILrcW[0]['castingISSwgt'];

		#--------[ FETCH - REPAIR PO ORNAMENT WGT
		$QURYrpPOornWT = "SELECT SUM(`avg_wgt_range`) AS repairPOornWGT FROM `po_open_ord_det` WHERE `ord_type`='rp' AND `role_status`=1";
		$CONNrpPOornWT = $connection->executeQuery($QURYrpPOornWT);
		$FTCHrpPOornWT = $CONNrpPOornWT->fetchAll();		
		$RSLTrpPOornWT = $FTCHrpPOornWT[0]['repairPOornWGT'];
		
		#--------[ FETCH - SPARE PO ORNAMENT WGT
		$QURYspPOornWT = "SELECT SUM(`avg_wgt_range`) AS sparePOornWGT FROM `po_open_ord_det` WHERE `ord_type`='sp' AND `role_status`=1";
		$CONNspPOornWT = $connection->executeQuery($QURYspPOornWT);
		$FTCHspPOornWT = $CONNspPOornWT->fetchAll();		
		$RSLTspPOornWT = $FTCHspPOornWT[0]['sparePOornWGT'];
		
		#--------[ FETCH - SPARE PO ORNAMENT WGT
		$QURYmtPCscpWT = "SELECT SUM(`issed_wgt`) AS metPEACESscrapwgt FROM `metal_issue` WHERE `metal_issued_by`='PIS' AND `acknow_status`='Accepted' AND `issued_to_flag`='MD' AND `role_status`=1";
		$CONNmtPCscpWT = $connection->executeQuery($QURYmtPCscpWT);
		$FTCHmtPCscpWT = $CONNmtPCscpWT->fetchAll();		
		$RSLTmtPCscpWT = $FTCHmtPCscpWT[0]['metPEACESscrapwgt'];		
		
		#--------[ FETCH - METAL WGT REC FROM WORKER 2 METAL DEPT. - WORKER 2 WORKER SCREEEN
		$QURYwk2MTdpWT = "SELECT SUM(`issed_wgt`) AS wrk2metalDEPTwgt FROM `metal_w2w_trans` WHERE `metal_accessories_id`='5' AND `role_status`=1";
		$CONNwk2MTdpWT = $connection->executeQuery($QURYwk2MTdpWT);
		$FTCHwk2MTdpWT = $CONNwk2MTdpWT->fetchAll();		
		$RSLTwk2MTdpWT = $FTCHwk2MTdpWT[0]['wrk2metalDEPTwgt'];
		
		#--------[ FETCH - RETURN JC WGT, RETURN JC - ORNAMENT WGT will go to MAIN STOCK WGT
		$QURYjcCMPmtWT = "SELECT SUM(`wgt`) AS jcCOMPLETEDornWGT FROM `prod_iss_rec` WHERE `work_status`=4 AND `statu_s`=1";
		$CONNjcCMPmtWT = $connection->executeQuery($QURYjcCMPmtWT);
		$FTCHjcCMPmtWT = $CONNjcCMPmtWT->fetchAll();		
		$RSLTjcCMPmtWT = $FTCHjcCMPmtWT[0]['jcCOMPLETEDornWGT'];		

		$BLNCconvMTwgt = number_format((($RSLTconvMTwgt - $RSLTcnvACSwgt - $RSLTcsMTissWT) + $RSLTcastRmtWG) - ($RSLTrpPOornWT + $RSLTspPOornWT) + $RSLTmtPCscpWT + $RSLTwk2MTdpWT + $RSLTjcCMPmtWT, 2);

		
		#--------[ FETCH - METAL ACCESSORIES 
		$QURYmetACCESE = "SELECT * FROM `metal_accessories` WHERE `role_status`=1 ORDER BY `metal_accessories_name` ASC";
		$CONNmetACCESE = $connection->executeQuery($QURYmetACCESE);
		$FTCHmetACCESE = $CONNmetACCESE->fetchAll();
		
		if($request->getMethod() == 'POST')
		{
			$loopCOUNT 	= count($request->get('accs_transfer_wgt'));
			
			for($i=0; $i<=$loopCOUNT-1; $i++)
			{
				$conver_to			= $request->get('conver_to')[$i];
				$stock_acc_wgt		= $request->get('stock_acc_wgt')[$i];
				$accs_transfer_wgt	= $request->get('accs_transfer_wgt')[$i];
				$loss_wgt			= $request->get('loss_wgt')[$i];
				$remarks 			= $request->get('remarks')[$i];
				$blnc_wgt 			= $request->get('blnc_wgt')[$i];
				
				#--------[ INSERT
				$inst = "INSERT INTO `metal_conver_acces`(`metal_accessories_id`, `acces_blnc_wgt_rfrnc`, `acces_conver_wgt`, `acces_conver_loss_wgt`, `remarks_qr`, `blnc_wgt_rfrnc`, `post_by`, `post_dt`) VALUES ('$conver_to', '$stock_acc_wgt', '$accs_transfer_wgt', '$loss_wgt', '$remarks', '$blnc_wgt', '$sessionId', '$nowDateTime')";
				$stmt = $connection->executeQuery($inst);
			}
			
			return $this->redirect('metal-name-change-list');
		}			
		
		return $this->render('metal/metal-name-change-add.html.twig', [
			'convBLNCmetalWGT' => $BLNCconvMTwgt,
			'metACCESE' => $FTCHmetACCESE,
			'controller_name' => 'MetalDeptController'
        ]);
    }

	
    /**
     * @Route("/metal-name-change-updt{metNMEchnUPiD}", name="metal-name-change-updt")
     */
    public function metalNAMEchangeUPDTact(Request $request, $metNMEchnUPiD)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		
/*		#--------[ FETCH - METAL REC from CASTING REC (Metal Wgt)
		$QURYcastRmtWG = "SELECT SUM(`mt_wgt`) AS CASTINGrecMETALwgt FROM `casting_rec` WHERE `role_status`=1";
		$CONNcastRmtWG = $connection->executeQuery($QURYcastRmtWG);
		$FTCHcastRmtWG = $CONNcastRmtWG->fetchAll();	
		$RSLTcastRmtWG = $FTCHcastRmtWG[0]['CASTINGrecMETALwgt'];		

		#--------[ FETCH - CONVERSTION METAL WEIGHT IN HAND
		$QURYconvMTwgt = "SELECT SUM(`conversion_wgt`) AS converTOTwgtINhand FROM `party_metal_receipt` WHERE `role_status`=1";
		$CONNconvMTwgt = $connection->executeQuery($QURYconvMTwgt);
		$FTCHconvMTwgt = $CONNconvMTwgt->fetchAll();	
		$RSLTconvMTwgt = $FTCHconvMTwgt[0]['converTOTwgtINhand'];

		#--------[ FETCH - METAL ACCESSORIES CONVER WGT
		$QURYcnvACSwgt = "SELECT SUM(`acces_conver_wgt` + `acces_conver_loss_wgt`) AS acesoMTconvWGT FROM `metal_conver_acces` WHERE `role_status`=1";
		$CONNcnvACSwgt = $connection->executeQuery($QURYcnvACSwgt);
		$FTCHcnvACSwgt = $CONNcnvACSwgt->fetchAll();		
		$RSLTcnvACSwgt = $FTCHcnvACSwgt[0]['acesoMTconvWGT'];
		
		#--------[ FETCH - CASTING METAL ISSUE TOT WGT
		$QURYcsMTissWT = "SELECT SUM(`iss_mt_wt`) AS castingISSwgt FROM `casting_iss` WHERE `role_status`=1";
		$CONNcsMTissWT = $connection->executeQuery($QURYcsMTissWT);
		$FTCHcsMTissWT = $CONNcsMTissWT->fetchAll();		
		$RSLTcsMTissWT = $FTCHcsMTissWT[0]['castingISSwgt'];	

		$BLNCconvMTwgt = number_format(($RSLTconvMTwgt - $RSLTcnvACSwgt - $RSLTcsMTissWT) + $RSLTcastRmtWG, 2);*/
		
		
		#--------[ FETCH - METAL REC from CASTING REC (Metal Wgt)
		$QURYcastRmtWG = "SELECT SUM(`mt_wgt`) AS CASTINGrecMETALwgt FROM `casting_rec` WHERE `role_status`=1";
		$CONNcastRmtWG = $connection->executeQuery($QURYcastRmtWG);
		$FTCHcastRmtWG = $CONNcastRmtWG->fetchAll();	
		$RSLTcastRmtWG = $FTCHcastRmtWG[0]['CASTINGrecMETALwgt'];		

		#--------[ FETCH - CONVERSTION METAL WEIGHT IN HAND
		$QURYconvMTwgt = "SELECT SUM(`conversion_wgt`) AS converTOTwgtINhand FROM `party_metal_receipt` WHERE `role_status`=1";
		$CONNconvMTwgt = $connection->executeQuery($QURYconvMTwgt);
		$FTCHconvMTwgt = $CONNconvMTwgt->fetchAll();	
		$RSLTconvMTwgt = $FTCHconvMTwgt[0]['converTOTwgtINhand'];

		#--------[ FETCH - METAL ACCESSORIES CONVER WGT
		$QURYcnvACSwgt = "SELECT SUM(`acces_conver_wgt` + `acces_conver_loss_wgt`) AS acesoMTconvWGT FROM `metal_conver_acces` WHERE `role_status`=1";
		$CONNcnvACSwgt = $connection->executeQuery($QURYcnvACSwgt);
		$FTCHcnvACSwgt = $CONNcnvACSwgt->fetchAll();		
		$RSLTcnvACSwgt = $FTCHcnvACSwgt[0]['acesoMTconvWGT'];
		
		#--------[ FETCH - CASTING METAL ISSUE TOT WGT
		$QURYcsMTissWT = "SELECT SUM(`iss_mt_wt`) AS castingISSwgt FROM `casting_iss` WHERE `role_status`=1";
		$CONNcsMTissWT = $connection->executeQuery($QURYcsMTissWT);
		$FTCHcsMTissWT = $CONNcsMTissWT->fetchAll();		
		$RSLTcsMTissWT = $FTCHcsMTissWT[0]['castingISSwgt'];	
		
		#--------[ FETCH - PROD ISS/REC - FILLING Dept. REC WEIGHT
//		$QURYprdFILrcW = "SELECT SUM(`iss_mt_wt`) AS castingISSwgt FROM `casting_iss` WHERE `role_status`=1";
//		$CONNprdFILrcW = $connection->executeQuery($QURYprdFILrcW);
//		$FTCHprdFILrcW = $CONNprdFILrcW->fetchAll();		
//		$RSLTprdFILrcW = $FTCHprdFILrcW[0]['castingISSwgt'];

		#--------[ FETCH - REPAIR PO ORNAMENT WGT
		$QURYrpPOornWT = "SELECT SUM(`avg_wgt_range`) AS repairPOornWGT FROM `po_open_ord_det` WHERE `ord_type`='rp' AND `role_status`=1";
		$CONNrpPOornWT = $connection->executeQuery($QURYrpPOornWT);
		$FTCHrpPOornWT = $CONNrpPOornWT->fetchAll();		
		$RSLTrpPOornWT = $FTCHrpPOornWT[0]['repairPOornWGT'];
		
		#--------[ FETCH - SPARE PO ORNAMENT WGT
		$QURYspPOornWT = "SELECT SUM(`avg_wgt_range`) AS sparePOornWGT FROM `po_open_ord_det` WHERE `ord_type`='sp' AND `role_status`=1";
		$CONNspPOornWT = $connection->executeQuery($QURYspPOornWT);
		$FTCHspPOornWT = $CONNspPOornWT->fetchAll();		
		$RSLTspPOornWT = $FTCHspPOornWT[0]['sparePOornWGT'];
		
		#--------[ FETCH - SPARE PO ORNAMENT WGT
		$QURYmtPCscpWT = "SELECT SUM(`issed_wgt`) AS metPEACESscrapwgt FROM `metal_issue` WHERE `metal_issued_by`='PIS' AND `acknow_status`='Accepted' AND `issued_to_flag`='MD' AND `role_status`=1";
		$CONNmtPCscpWT = $connection->executeQuery($QURYmtPCscpWT);
		$FTCHmtPCscpWT = $CONNmtPCscpWT->fetchAll();		
		$RSLTmtPCscpWT = $FTCHmtPCscpWT[0]['metPEACESscrapwgt'];		
		
		#--------[ FETCH - METAL WGT REC FROM WORKER 2 METAL DEPT. - WORKER 2 WORKER SCREEEN
		$QURYwk2MTdpWT = "SELECT SUM(`issed_wgt`) AS wrk2metalDEPTwgt FROM `metal_w2w_trans` WHERE `metal_accessories_id`='5' AND `role_status`=1";
		$CONNwk2MTdpWT = $connection->executeQuery($QURYwk2MTdpWT);
		$FTCHwk2MTdpWT = $CONNwk2MTdpWT->fetchAll();		
		$RSLTwk2MTdpWT = $FTCHwk2MTdpWT[0]['wrk2metalDEPTwgt'];
		
		#--------[ FETCH - RETURN JC WGT, RETURN JC - ORNAMENT WGT will go to MAIN STOCK WGT
		$QURYjcCMPmtWT = "SELECT SUM(`wgt`) AS jcCOMPLETEDornWGT FROM `prod_iss_rec` WHERE `work_status`=4 AND `statu_s`=1";
		$CONNjcCMPmtWT = $connection->executeQuery($QURYjcCMPmtWT);
		$FTCHjcCMPmtWT = $CONNjcCMPmtWT->fetchAll();		
		$RSLTjcCMPmtWT = $FTCHjcCMPmtWT[0]['jcCOMPLETEDornWGT'];		

		$BLNCconvMTwgt = number_format((($RSLTconvMTwgt - $RSLTcnvACSwgt - $RSLTcsMTissWT) + $RSLTcastRmtWG) - ($RSLTrpPOornWT + $RSLTspPOornWT) + $RSLTmtPCscpWT + $RSLTwk2MTdpWT + $RSLTjcCMPmtWT, 2);		

		
		#--------[ FETCH - METAL ACCESSORIES 
		$QURYmetACCESE = "SELECT * FROM `metal_accessories` WHERE `role_status`=1 ORDER BY `metal_accessories_name` ASC";
		$CONNmetACCESE = $connection->executeQuery($QURYmetACCESE);
		$FTCHmetACCESE = $CONNmetACCESE->fetchAll();

		
		#--------[ FETCH - UPDATE DATA
		$QURYupateDATA 	= "SELECT * FROM `metal_conver_acces` WHERE metal_conver_acces_id = '".$metNMEchnUPiD."'";
		$CONNupateDATA 	= $connection->executeQuery($QURYupateDATA);
		$FTCHupateDATA 	= $CONNupateDATA->fetchAll();
		
		$FTCHupateDATA['metal_accessories_id'] 	= $FTCHupateDATA[0]['metal_accessories_id'];
		$FTCHupateDATA['acces_conver_wgt'] 		= $FTCHupateDATA[0]['acces_conver_wgt'];
		$FTCHupateDATA['acces_conver_loss_wgt'] = $FTCHupateDATA[0]['acces_conver_loss_wgt'];
		$FTCHupateDATA['remarks_qr'] 			= $FTCHupateDATA[0]['remarks_qr'];
		
		
		#--------[ FETCH - IN HAND METAL ACCESS WGT
		$quryMTwgtFRMstock	= "SELECT FORMAT(SUM(`acces_conver_wgt`), 2) AS acces_conver_wgt FROM `metal_conver_acces` WHERE `metal_accessories_id`='".$FTCHupateDATA['metal_accessories_id']."'";
		$stmtMTwgtFRMstock	= $connection->executeQuery($quryMTwgtFRMstock);
		$listMTwgtFRMstock	= $stmtMTwgtFRMstock->fetchAll();
		
		$quryMTwgtFRMisued	= "SELECT FORMAT(SUM(`issed_wgt`), 2) AS issed_wgt FROM `metal_issue` WHERE `metal_accessories_id`='".$FTCHupateDATA['metal_accessories_id']."' AND `acknow_status` != 'Found Diff.' AND metal_issued_by='MD'";
		$stmtMTwgtFRMisued	= $connection->executeQuery($quryMTwgtFRMisued);
		$listMTwgtFRMisued	= $stmtMTwgtFRMisued->fetchAll();
		
		$quryMTwgtRECfrmINV	= "SELECT FORMAT(SUM(`issed_wgt`), 2) AS rec_wgt_frm_inv FROM `metal_issue` WHERE `issued_to_flag`='MD' AND `metal_accessories_id`='".$FTCHupateDATA['metal_accessories_id']."' AND `acknow_status`='Accepted'";
		$stmtMTwgtRECfrmINV	= $connection->executeQuery($quryMTwgtRECfrmINV);
		$listMTwgtRECfrmINV	= $stmtMTwgtRECfrmINV->fetchAll();				
		
		$acces_conver_wgt  = $listMTwgtFRMstock[0]['acces_conver_wgt'] - $listMTwgtFRMisued[0]['issed_wgt'] + $listMTwgtRECfrmINV[0]['rec_wgt_frm_inv'];
		
		if($request->getMethod() == 'POST')
		{
			$loopCOUNT 	= count($request->get('accs_transfer_wgt'));
			
			for($i=0; $i<=$loopCOUNT-1; $i++)
			{
				$conver_to			= $request->get('conver_to')[$i];
				$stock_acc_wgt		= $request->get('stock_acc_wgt')[$i];
				$accs_transfer_wgt	= $request->get('accs_transfer_wgt')[$i];
				$loss_wgt			= $request->get('loss_wgt')[$i];
				//$remarks 			= htmlspecialchars($request->get('remarks')[$i], ENT_QUOTES);
				$remarks 			= $request->get('remarks')[$i];
				$blnc_wgt 			= $request->get('blnc_wgt')[$i];
				
				#--------[ INSERT
				//$inst = "INSERT INTO `metal_conver_acces`(`metal_accessories_id`, `acces_blnc_wgt_rfrnc`, `acces_conver_wgt`, `acces_conver_loss_wgt`, `remarks_qr`, `blnc_wgt_rfrnc`, `post_by`, `post_dt`) VALUES ('$conver_to', '$stock_acc_wgt', '$accs_transfer_wgt', '$loss_wgt', '$remarks', '$blnc_wgt', '$sessionId', '$nowDateTime')";
				$updt = "UPDATE `metal_conver_acces` SET `metal_accessories_id`='$conver_to', `acces_blnc_wgt_rfrnc`='$stock_acc_wgt', `acces_conver_wgt`='$accs_transfer_wgt', `acces_conver_loss_wgt`='$loss_wgt', `remarks_qr`='$remarks', `blnc_wgt_rfrnc`='$blnc_wgt', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE `metal_conver_acces_id`='".$metNMEchnUPiD."' ";
				$stmt = $connection->executeQuery($updt);
			}
			
			return $this->redirect('metal-name-change-list');
		}			
		
		return $this->render('metal/metal-name-change-updt.html.twig', [
			'convBLNCmetalWGT' => $BLNCconvMTwgt,
			'metACCESE' => $FTCHmetACCESE,
			'FTCHupateDATA' => $FTCHupateDATA,
			'inHANDmtWGT' => $acces_conver_wgt,
			'controller_name' => 'MetalDeptController'
        ]);
    }	
	
	
    /**
     * @Route("/metal-issue-data{mISSid}", name="metal-issue-data")
     */
    public function metalISSdatatActions(Request $request, $mISSid)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		
		########-[ QUICK VARIABLES
		$tableName	= "metal_issue";
		$tablePrmID	= "metal_issue_id";
		$getVARIid	= $mISSid;		
		
		#--------[ FETCH - EMP LIST
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM `employee` AS E, employee_salary AS ES, dept AS D, roles AS R WHERE E.dept=D.dept_id AND E.roles=R.roles_id AND E.employee_id=ES.employee_id AND E.role_status=1 GROUP BY ES.employee_id ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();
		
		#--------[ FETCH - ONLY METAL ACCESSORIES in STOCK
		//$QURYmetACCESEinSTOCK = "SELECT MA.metal_accessories_id, MA.metal_accessories_name FROM `metal_accessories` AS MA, `metal_conver_acces` AS MCA WHERE MA.`metal_accessories_id` = MCA.`metal_accessories_id` AND MA.role_status = 1 GROUP BY MA.metal_accessories_name ORDER BY MA.metal_accessories_name ASC";
		//$QURYmetACCESEinSTOCK = "SELECT metal_accessories.metal_accessories_id, metal_accessories.metal_accessories_name FROM `metal_w2w_trans` LEFT JOIN `metal_accessories` ON `metal_w2w_trans`.metal_accessories_id = `metal_accessories`.metal_accessories_id LEFT JOIN `metal_issue` ON metal_accessories.metal_accessories_id = metal_issue.metal_accessories_id";
		
		
		$QURYmetACCESEinSTOCK = "SELECT metal_accessories.metal_accessories_id AS masterBINitemID, metal_accessories.metal_accessories_name AS masterBINitemNM, metal_conver_acces.metal_accessories_id AS mainMTstckBINid, metal_w2w_trans.metal_accessories_id AS w2wMTstckBINid, metal_issue.metal_accessories_id AS inv2MTstckBINid FROM `metal_accessories` LEFT JOIN `metal_conver_acces` ON `metal_accessories`.metal_accessories_id = `metal_conver_acces`.metal_accessories_id LEFT JOIN `metal_w2w_trans` ON metal_accessories.metal_accessories_id = metal_w2w_trans.metal_accessories_id LEFT JOIN `metal_issue` ON metal_accessories.metal_accessories_id = metal_issue.metal_accessories_id AND metal_issue.metal_issued_by = 'PIS' AND metal_issue.issued_to_flag='MD' GROUP BY `metal_accessories`.metal_accessories_id";
		$CONNmetACCESEinSTOCK = $connection->executeQuery($QURYmetACCESEinSTOCK);
		$FTCHmetACCESEinSTOCK = $CONNmetACCESEinSTOCK->fetchAll();		
		
		$accBINitemsDROPdown = '<select name="conver_to" id="conver_to0" class="form-control" onchange="return metalACESstockWGT(0);" required>
		                            <option value="">Choose</option>';
		for($j=0; $j<=count($FTCHmetACCESEinSTOCK)-1; $j++)
		{
		   
		    if($FTCHmetACCESEinSTOCK[$j]['mainMTstckBINid'] != "" || $FTCHmetACCESEinSTOCK[$j]['w2wMTstckBINid'] != "" || $FTCHmetACCESEinSTOCK[$j]['inv2MTstckBINid'] != "") 
		    {
		    $accBINitemsDROPdown .= '<option value="'.$FTCHmetACCESEinSTOCK[$j]['masterBINitemID'].'">'.$FTCHmetACCESEinSTOCK[$j]['masterBINitemNM'].'</option>';
		    }
		}
        $accBINitemsDROPdown .= "</select>";

		
		########-[ LIST 
		$QURYlistDet= "SELECT MI.metal_issue_id, MI.issued_id, MI.issued_to_flag, MI.acknow_status, MA.metal_accessories_name, FORMAT(MI.issed_wgt, 2) AS issed_wgt, E.emp_name, DATE_FORMAT(MI.post_dt, '%b %d, %Y - %r') AS entryDT, FORMAT(MI.acknow_wgt, 2) AS acknow_wgt, MI.acknow_post_by, DATE_FORMAT(MI.acknow_post_dt, '%b %d, %Y - %r') AS acknowDT FROM `metal_issue` AS MI, metal_accessories AS MA, employee AS E WHERE MI.metal_accessories_id=MA.metal_accessories_id AND MI.post_by=E.employee_id AND MI.	metal_issued_by='MD' ORDER BY MI.`metal_issue_id` DESC";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();
		$CONTlistDet= count($FTCHlistDet);
		
		$data = "";
		for($i=0; $i<=$CONTlistDet-1; $i++)
		{
			$issued_to_flag = $FTCHlistDet[$i]['issued_to_flag'];
			$employee_id 	= $FTCHlistDet[$i]['issued_id'];
			
			$acknow_status 	= $FTCHlistDet[$i]['acknow_status'];
			
			if($acknow_status == "Awaiting")
			{
				$font_color = "orange";
				$actionLINK = '<a href="metal-issue-data'.$FTCHlistDet[$i]["metal_issue_id"].'"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>';
			}
			else if($acknow_status == "Accepted")
			{
				$font_color = "#66CC00";
				$actionLINK = '<a style="color:#E8E8E8"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>';
			}
			else if($acknow_status == "Found Diff.")
			{
				$font_color = "#ff0000";
				$actionLINK = '<a style="color:#E8E8E8"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>';
			}
			
			
			if($issued_to_flag == "PIS")
			{
				$issued_to 		= "Inventory";
				
				$acknowStatus  	= $FTCHlistDet[$i]["acknow_status"];
				
				if($FTCHlistDet[$i]["acknow_wgt"] != 0)
				{
					$QURY 			= "SELECT `emp_name` FROM `employee` WHERE `employee_id`=".$FTCHlistDet[$i]["acknow_post_by"];
					$CONN 			= $connection->executeQuery($QURY);
					$FTCH 			= $CONN->fetchAll();				
					$acknow_post_by = $FTCH[0]['emp_name'];
				
					$acknow_wgt		= $FTCHlistDet[$i]["acknow_wgt"];
					$acknowDT		= $FTCHlistDet[$i]["acknowDT"];
				}
				else 
				{
					$acknow_post_by = "Nil";
					$acknow_wgt		= "Nil";
					$acknowDT		= "MMM DD, YYYY - HH:MM";
				}
			}
			else if($issued_to_flag == "FR")
			{
				$issued_to 		= "Ready AC";
				
				$acknowStatus   = "";
				$acknow_wgt 	= "";
				$acknow_post_by = "";
				$acknowDT		= "";				
			}
			else
			{
				$issuedTOqty = "SELECT `employee_id`, `emp_name` FROM `employee` WHERE `employee_id`=".$employee_id;
				$issuedTOcon = $connection->executeQuery($issuedTOqty);
				$issuedTOfth = $issuedTOcon->fetchAll();
				$issued_to   = $issuedTOfth[0]['emp_name'];
				
				$acknowStatus   = "";
				$acknow_wgt 	= "";
				$acknow_post_by = "";
				$acknowDT		= "";	
				
				$actionLINK = '<a style="color:#E8E8E8"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>';							
			}
			
			$data .= '<tr>
						<td title="Serial No." style="text-align:center; vertical-align: middle;">'. ($i+1) .'</td>
						<td title="Showing - Issued To" style="text-align:left; vertical-align: middle;">'.$issued_to.'<br><small style="color:'.$font_color.'; font-weight:800;">'.$acknowStatus.'</small></td>
						<td title="Showing - Metal/Spares/Accessories Name" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['metal_accessories_name'].'</td>
						<td title="Showing - Issued Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]["issed_wgt"].'</td>
						<td title="Showing - Issued Person Name / Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;"><u>'.$FTCHlistDet[$i]["emp_name"].'</u><br>'.$FTCHlistDet[$i]["entryDT"].'</td>
						<td title="Showing - Acknowledged Weight in Grams" style="text-align:right; vertical-align: middle;">'.$acknow_wgt.'</td>
					    <td title="Showing - Acknowledged Person Name / Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;"><u>'.$acknow_post_by.'</u><br>'.$acknowDT.'</td>
						<td title="Action" style="text-align:center; vertical-align: middle;">'.$actionLINK.'</td>';
			$data .= '</tr>';
		}
		
		if($getVARIid != 0)
		{
			#--------[ EDIT DATA's
			$QURYupdtDet = "SELECT * FROM `metal_issue` WHERE `metal_issue_id`='".$getVARIid."' ";
			$CONNupdtDet = $connection->executeQuery($QURYupdtDet);
			$FTCHupdtDet = $CONNupdtDet->fetchAll();
			
			$FTCHupdtDet['issued_id'] 				= $FTCHupdtDet[0]['issued_id'];
			$FTCHupdtDet['metal_accessories_id'] 	= $FTCHupdtDet[0]['metal_accessories_id'];
			$FTCHupdtDet['issed_wgt'] 				= $FTCHupdtDet[0]['issed_wgt'];		
			$conver_to								= $FTCHupdtDet['metal_accessories_id'];
			
			$quryMTwgtFRMstock	= "SELECT FORMAT(SUM(`acces_conver_wgt`), 2) AS acces_conver_wgt FROM `metal_conver_acces` WHERE `metal_accessories_id`='".$conver_to."'";
			$stmtMTwgtFRMstock	= $connection->executeQuery($quryMTwgtFRMstock);
			$listMTwgtFRMstock	= $stmtMTwgtFRMstock->fetchAll();

			
			$quryMTwgtFRMisued	= "SELECT FORMAT(SUM(`issed_wgt`), 2) AS issed_wgt FROM `metal_issue` WHERE `metal_accessories_id`='".$conver_to."' AND `acknow_status` != 'Found Diff.' AND metal_issued_by='MD'  AND metal_issue_id != '".$getVARIid."' ";
			$stmtMTwgtFRMisued	= $connection->executeQuery($quryMTwgtFRMisued);
			$listMTwgtFRMisued	= $stmtMTwgtFRMisued->fetchAll();
			
			
			$quryMTwgtRECfrmINV	= "SELECT FORMAT(SUM(`issed_wgt`), 2) AS rec_wgt_frm_inv FROM `metal_issue` WHERE `issued_to_flag`='MD' AND `metal_accessories_id`='".$conver_to."' AND `acknow_status`='Accepted'";
			$stmtMTwgtRECfrmINV	= $connection->executeQuery($quryMTwgtRECfrmINV);
			$listMTwgtRECfrmINV	= $stmtMTwgtRECfrmINV->fetchAll();				
			
			$acces_conver_wgt  = $listMTwgtFRMstock[0]['acces_conver_wgt'] - $listMTwgtFRMisued[0]['issed_wgt'] + $listMTwgtRECfrmINV[0]['rec_wgt_frm_inv'];			
		}
		
		if($request->getMethod() == 'POST')
		{
			$issued_id  	= $request->get('issued_id');
			$conver_to 		= $request->get('conver_to');
			$in_stock_wgt	= $request->get('stock_acc_wgt');
			$iss_wgt  		= $request->get('iss_wgt');
			
			if($issued_id == "PIS")
			{
				$issued_to_flag = "PIS";
			} 
			else if($issued_id == "FR") 
			{
				$issued_to_flag = "FR";
			} 
			else 
			{
				$issued_to_flag = "W";			
			}
			
			if($getVARIid == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO ".$tableName."(`metal_issued_by`, `issued_id`, `metal_accessories_id`, `exist_stock_wgt_rfrnc`, `issed_wgt`, `issued_to_flag`, `post_by`, `post_dt`) VALUES ('MD', '$issued_id', '$conver_to', '$in_stock_wgt', '$iss_wgt', '$issued_to_flag', '$sessionId', '$nowDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
			}
			else
			{
				########-[ UPDATE - DETAILS			
				$QRupdate 	= "UPDATE ".$tableName." SET `issued_id`='$issued_id', `metal_accessories_id`='$conver_to', `exist_stock_wgt_rfrnc`='$in_stock_wgt', `issed_wgt`='$iss_wgt', `issued_to_flag`='$issued_to_flag', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE ".$tablePrmID."=".$getVARIid;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}
		
		return $this->render('metal/metal-issue-data.html.twig', [
			'empDATAs' => $FTCHemp,
			'metACCESEinSTOCK' => $FTCHmetACCESEinSTOCK,
			'data' => $data,
			'FTCHupdtDet' => $FTCHupdtDet,
			'acces_conver_wgt' => $acces_conver_wgt,
			'accBINitemsDROPdown' => $accBINitemsDROPdown,
			'controller_name' => 'MetalDeptController'
        ]);
    }


    /**
     * @Route("/metal-invent-acknow-list", name="metal-invent-acknow-list")
     */
    public function metalINVENTacknowLISTact(Request $request)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		
		########-[ LIST 
		$QURYlistDet= "SELECT MI.metal_issue_id, MA.metal_accessories_name, FORMAT(MI.issed_wgt, 2) AS issed_wgt, E.emp_name, DATE_FORMAT(MI.post_dt, '%b %d, %Y - %r') AS entryDT, MI.acknow_post_by, FORMAT(MI.acknow_wgt, 2) AS acknow_wgt, DATE_FORMAT(MI.`acknow_post_dt`, '%b %d, %Y - %r') AS acknowDT, MI.issued_to_flag, MI.acknow_status FROM `metal_issue` AS MI, metal_accessories AS MA, employee AS E WHERE MI.metal_accessories_id=MA.metal_accessories_id AND MI.post_by=E.employee_id AND MI.`issued_to_flag`='PIS' ORDER BY MI.`metal_issue_id` DESC";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();
		$CONTlistDet= count($FTCHlistDet);
		
		$data = "";
		for($i=0; $i<=$CONTlistDet-1; $i++)
		{
			
			if($FTCHlistDet[$i]['acknow_wgt'] == 0)
			{
				$acknow_wgt = "";
				$readonly	= "";
			}
			else
			{
				$acknow_wgt = $FTCHlistDet[$i]['acknow_wgt'];
				$readonly	= "readonly";
			}
			
			if($FTCHlistDet[$i]['acknow_post_by'] == 0)
			{
				$acknowBY = "Nil";
				$acknowDT = "MMM DD, YYYY - HH:MM";
			}
			else
			{
				$QURY	  = "SELECT `emp_name` FROM `employee` WHERE `employee_id`=".$FTCHlistDet[$i]['acknow_post_by'];
				$CONN	  = $connection->executeQuery($QURY);
				$FTCH	  = $CONN->fetchAll();
				$acknowBY = $FTCH[0]['emp_name'];				
				
				$acknowDT = $FTCHlistDet[$i]['acknowDT'];				
			}


			$acknow_status 	= $FTCHlistDet[$i]['acknow_status'];
			
			if($acknow_status == "Awaiting")
			{
				$font_color = "orange";
			}
			else if($acknow_status == "Accepted")
			{
				$font_color = "#66CC00";
			}
			else if($acknow_status == "Found Diff.")
			{
				$font_color = "#ff0000";
			}
			
			$data .= '<tr>
						<td title="Serial No." style="text-align:center; vertical-align: middle;">'. ($i+1) .'</td>
						<td title="Showing - Metal/Spares/Accessories Name" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['metal_accessories_name'].'</td>
              			  <td title="Showing - Issued Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]['issed_wgt'].'</td>
						  <td title="Showing - Issued Person Name / Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;"><u>'.$FTCHlistDet[$i]['emp_name'].'</u><br>'.$FTCHlistDet[$i]['entryDT'].'</td>
						  <td title="Showing - Acknowledged Weight in Grams" style="text-align:right; vertical-align: middle;"><input type="text" class="form-control" id="acknowWGT'.$i.'" name="acknowWGT'.$i.'" value="'.number_format($acknow_wgt, 2).'" '.$readonly.' placeholder="0.00"  style="text-align:right; width:100px;" />&nbsp;<i class="fas fa-check-circle" title="Accept" onclick="return acceptACKNOW('.$i.', '.$FTCHlistDet[$i]['metal_issue_id'].', '.$FTCHlistDet[$i]['issed_wgt'].' )"></i></td>
						  <td title="Showing - Acknowledged Person Name / Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;"><u id="acknowBY'.$i.'">'.$acknowBY.'</u><br><span id="acknowDT'.$i.'">'.$acknowDT.'</span></td>
						  <td title="Showing - Status of Acknowledgement" id="acknowST'.$i.'" style="text-align:center; vertical-align: middle; color:'.$font_color.'; font-weight:800;"><span id="acknowST'.$i.'">'.$acknow_status.'</span></td>';
			$data .= '</tr>';
		}		
		
		return $this->render('metal/metal-invent-acknow-list.html.twig', [
			'acknowDATAlist' => $data,
			'controller_name' => 'MetalDeptController'
        ]);
    }
	
	
    /**
     * @Route("/met-dept-metal-acknow-list", name="met-dept-metal-acknow-list")
     */
    public function metDeptMetalAcknowLISTact(Request $request)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		
		########-[ LIST 
		$QURYlistDet= "SELECT MI.metal_issue_id, MA.metal_accessories_name, FORMAT(MI.issed_wgt, 2) AS issed_wgt, E.emp_name, DATE_FORMAT(MI.post_dt, '%b %d, %Y - %r') AS entryDT, MI.acknow_post_by, FORMAT(MI.acknow_wgt, 2) AS acknow_wgt, DATE_FORMAT(MI.`acknow_post_dt`, '%b %d, %Y - %r') AS acknowDT, MI.issued_to_flag, MI.acknow_status FROM `metal_issue` AS MI, metal_accessories AS MA, employee AS E WHERE MI.metal_accessories_id=MA.metal_accessories_id AND MI.post_by=E.employee_id AND MI.`issued_to_flag`='MD' ORDER BY MI.`metal_issue_id` DESC";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();
		$CONTlistDet= count($FTCHlistDet);
		
		$data = "";
		for($i=0; $i<=$CONTlistDet-1; $i++)
		{
			
			if($FTCHlistDet[$i]['acknow_wgt'] == 0)
			{
				$acknow_wgt = "";
				$readonly	= "";
			}
			else
			{
				$acknow_wgt = $FTCHlistDet[$i]['acknow_wgt'];
				$readonly	= "readonly";
			}
			
			if($FTCHlistDet[$i]['acknow_post_by'] == 0)
			{
				$acknowBY = "Nil";
				$acknowDT = "MMM DD, YYYY - HH:MM";
			}
			else
			{
				$QURY	  = "SELECT `emp_name` FROM `employee` WHERE `employee_id`=".$FTCHlistDet[$i]['acknow_post_by'];
				$CONN	  = $connection->executeQuery($QURY);
				$FTCH	  = $CONN->fetchAll();
				$acknowBY = $FTCH[0]['emp_name'];				
				
				$acknowDT = $FTCHlistDet[$i]['acknowDT'];				
			}


			$acknow_status 	= $FTCHlistDet[$i]['acknow_status'];
			
			if($acknow_status == "Awaiting")
			{
				$font_color = "orange";
			}
			else if($acknow_status == "Accepted")
			{
				$font_color = "#66CC00";
			}
			else if($acknow_status == "Found Diff.")
			{
				$font_color = "#ff0000";
			}
			
			$data .= '<tr>
						<td title="Serial No." style="text-align:center; vertical-align: middle;">'. ($i+1) .'</td>
						<td title="Showing - Metal/Spares/Accessories Name" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['metal_accessories_name'].'</td>
              			  <td title="Showing - Issued Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]['issed_wgt'].'</td>
						  <td title="Showing - Issued Person Name / Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;"><u>'.$FTCHlistDet[$i]['emp_name'].'</u><br>'.$FTCHlistDet[$i]['entryDT'].'</td>
						  <td title="Showing - Acknowledged Weight in Grams" style="text-align:right; vertical-align: middle;"><input type="text" class="form-control" id="acknowWGT'.$i.'" name="acknowWGT'.$i.'" value="'.number_format($acknow_wgt, 2).'" '.$readonly.' placeholder="0.00"  style="text-align:right; width:100px;" />&nbsp;<i class="fas fa-check-circle" title="Accept" onclick="return acceptACKNOW('.$i.', '.$FTCHlistDet[$i]['metal_issue_id'].', '.$FTCHlistDet[$i]['issed_wgt'].' )"></i></td>
						  <td title="Showing - Acknowledged Person Name / Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;"><u id="acknowBY'.$i.'">'.$acknowBY.'</u><br><span id="acknowDT'.$i.'">'.$acknowDT.'</span></td>
						  <td title="Showing - Status of Acknowledgement" id="acknowST'.$i.'" style="text-align:center; vertical-align: middle; color:'.$font_color.'; font-weight:800;"><span id="acknowST'.$i.'">'.$acknow_status.'</span></td>';
			$data .= '</tr>';
		}		
		
		return $this->render('metal/met-dept-metal-acknow-list.html.twig', [
			'acknowDATAlist' => $data,
			'controller_name' => 'MetalDeptController'
        ]);
    }	


    /**
     * @Route("/metal-invent-iss-dept-data{invISSdeptID}", name="metal-invent-iss-dept-data")
     */
    public function metalINVENTisDEPTdataACT(Request $request, $invISSdeptID)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		
		########-[ QUICK VARIABLES
		$tableName	= "metal_issue";
		$tablePrmID	= "metal_issue_id";
		$getVARIid	= $invISSdeptID;		
		
		#--------[ FETCH - EMP LIST
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM `employee` AS E, employee_salary AS ES, dept AS D, roles AS R WHERE E.dept=D.dept_id AND E.roles=R.roles_id AND E.employee_id=ES.employee_id AND E.role_status=1 GROUP BY ES.employee_id ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();
		
		#--------[ FETCH - ONLY METAL ACCESSORIES in STOCK
		//$QURYmetACCESEinSTOCK = "SELECT MA.metal_accessories_id, MA.metal_accessories_name FROM `metal_accessories` AS MA, `metal_conver_acces` AS MCA WHERE MA.`metal_accessories_id` = MCA.`metal_accessories_id` AND MA.role_status = 1 GROUP BY MA.metal_accessories_name ORDER BY MA.metal_accessories_name ASC";
		$QURYmetACCESEinSTOCK = "SELECT MA.metal_accessories_id, MA.metal_accessories_name FROM `metal_issue` AS MI, `metal_accessories` AS MA WHERE MI.`metal_issued_by`='MD' AND MI.`issued_to_flag`='PIS' AND MI.`acknow_status`='Accepted' AND MI.metal_accessories_id=MA.metal_accessories_id";

		//$QURYmetACCESEinSTOCK = "SELECT MA.`metal_accessories_id`, MA.`metal_accessories_name` FROM `metal_worker_tally` AS MWT, `metal_accessories` AS MA WHERE MWT.`metal_accessories_id`=MA.`metal_accessories_id` GROUP BY MA.`metal_accessories_id` ORDER BY MA.`metal_accessories_name`";   KSIT
		
		//$QURYmetACCESEinSTOCK = "SELECT metal_accessories.metal_accessories_id AS masterBINitemID, metal_accessories.metal_accessories_name AS masterBINitemNM, metal_worker_tally.metal_accessories_id AS inv2MTstckBINid, metal_issue.metal_accessories_id AS invMTstckBINid FROM `metal_accessories` LEFT JOIN `metal_worker_tally` ON metal_accessories.metal_accessories_id = metal_worker_tally.metal_accessories_id LEFT JOIN `metal_issue` ON metal_accessories.metal_accessories_id = metal_issue.metal_accessories_id AND metal_issue.metal_issued_by = 'PIS' AND metal_issue.issued_to_flag = 'MD' GROUP BY `metal_accessories`.metal_accessories_id";
		$QURYmetACCESEinSTOCK = "SELECT metal_accessories.metal_accessories_id AS masterBINitemID, metal_accessories.metal_accessories_name AS masterBINitemNM, metal_worker_tally.metal_accessories_id AS inv2MTstckBINid, metal_issue.metal_accessories_id AS invMTstckBINid FROM `metal_accessories` LEFT JOIN `metal_worker_tally` ON metal_accessories.metal_accessories_id = metal_worker_tally.metal_accessories_id LEFT JOIN `metal_issue` ON metal_accessories.metal_accessories_id = metal_issue.metal_accessories_id AND metal_issue.acknow_status != 'Found Diff' GROUP BY `metal_accessories`.metal_accessories_id";
		$CONNmetACCESEinSTOCK = $connection->executeQuery($QURYmetACCESEinSTOCK);
		$FTCHmetACCESEinSTOCK = $CONNmetACCESEinSTOCK->fetchAll();		
		
		$accBINitemsDROPdown = '<select name="conver_to" id="conver_to0" class="form-control" onchange="return metalACESstockWGT(0);" required>
		                            <option value="">Choose</option>';
		for($j=0; $j<=count($FTCHmetACCESEinSTOCK)-1; $j++)
		{
		   
		    if($FTCHmetACCESEinSTOCK[$j]['inv2MTstckBINid'] != "" || $FTCHmetACCESEinSTOCK[$j]['invMTstckBINid'] != "")
		    {
		    $accBINitemsDROPdown .= '<option value="'.$FTCHmetACCESEinSTOCK[$j]['masterBINitemID'].'">'.$FTCHmetACCESEinSTOCK[$j]['masterBINitemNM'].'</option>';
		    }
		}
        $accBINitemsDROPdown .= "</select>";
		
		########-[ LIST 
		$QURYlistDet= "SELECT MI.metal_issue_id, MI.issued_id, MI.issued_to_flag, MI.acknow_status, MA.metal_accessories_name, FORMAT(MI.issed_wgt, 2) AS issed_wgt, E.emp_name, DATE_FORMAT(MI.post_dt, '%b %d, %Y - %r') AS entryDT, FORMAT(MI.acknow_wgt, 2) AS acknow_wgt, MI.acknow_post_by, DATE_FORMAT(MI.acknow_post_dt, '%b %d, %Y - %r') AS acknowDT FROM `metal_issue` AS MI, metal_accessories AS MA, employee AS E WHERE MI.metal_accessories_id=MA.metal_accessories_id AND MI.post_by=E.employee_id AND MI.	metal_issued_by='PIS' ORDER BY MI.`metal_issue_id` DESC";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();
		$CONTlistDet= count($FTCHlistDet);
		
		$data = "";
		for($i=0; $i<=$CONTlistDet-1; $i++)
		{
			$issued_to_flag = $FTCHlistDet[$i]['issued_to_flag'];
			$employee_id 	= $FTCHlistDet[$i]['issued_id'];
			
			$acknow_status 	= $FTCHlistDet[$i]['acknow_status'];
			
			if($acknow_status == "Awaiting")
			{
				$font_color = "orange";
				$actionLINK = '<a href="metal-invent-iss-dept-data'.$FTCHlistDet[$i]["metal_issue_id"].'"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>';
			}
			else if($acknow_status == "Accepted")
			{
				$font_color = "#66CC00";
				$actionLINK = '<a style="color:#E8E8E8"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>';
			}
			else if($acknow_status == "Found Diff.")
			{
				$font_color = "#ff0000";
				$actionLINK = '<a style="color:#E8E8E8"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>';
			}
			
			
			if($issued_to_flag == "MD")
			{
				$issued_to 		= "Metal Dept.";
				
				$acknowStatus  	= $FTCHlistDet[$i]["acknow_status"];
				
				if($FTCHlistDet[$i]["acknow_wgt"] != 0)
				{
					$QURY 			= "SELECT `emp_name` FROM `employee` WHERE `employee_id`=".$FTCHlistDet[$i]["acknow_post_by"];
					$CONN 			= $connection->executeQuery($QURY);
					$FTCH 			= $CONN->fetchAll();				
					$acknow_post_by = $FTCH[0]['emp_name'];
				
					$acknow_wgt		= $FTCHlistDet[$i]["acknow_wgt"];
					$acknowDT		= $FTCHlistDet[$i]["acknowDT"];
				}
				else 
				{
					$acknow_post_by = "Nil";
					$acknow_wgt		= "Nil";
					$acknowDT		= "MMM DD, YYYY - HH:MM";
				}
			}
			else
			{
				$issuedTOqty = "SELECT `employee_id`, `emp_name` FROM `employee` WHERE `employee_id`=".$employee_id;
				$issuedTOcon = $connection->executeQuery($issuedTOqty);
				$issuedTOfth = $issuedTOcon->fetchAll();
				$issued_to   = $issuedTOfth[0]['emp_name'];
				
				$acknowStatus   = "";
				$acknow_wgt 	= "";
				$acknow_post_by = "";
				$acknowDT		= "";	
				
				$actionLINK = '<a style="color:#E8E8E8"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>';			
			}
			
			$data .= '<tr>
						<td title="Serial No." style="text-align:center; vertical-align: middle;">'. ($i+1) .'</td>
						<td title="Showing - Issued To" style="text-align:left; vertical-align: middle;">'.$issued_to.'<br><small style="color:'.$font_color.'; font-weight:800;">'.$acknowStatus.'</small></td>
						<td title="Showing - Metal/Spares/Accessories Name" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['metal_accessories_name'].'</td>
						<td title="Showing - Issued Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]["issed_wgt"].'</td>
						<td title="Showing - Issued Person Name / Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;"><u>'.$FTCHlistDet[$i]["emp_name"].'</u><br>'.$FTCHlistDet[$i]["entryDT"].'</td>
						<td title="Showing - Acknowledged Weight in Grams" style="text-align:right; vertical-align: middle;">'.$acknow_wgt.'</td>
					    <td title="Showing - Acknowledged Person Name / Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;"><u>'.$acknow_post_by.'</u><br>'.$acknowDT.'</td>
						<td title="Action" style="text-align:center; vertical-align: middle;">'.$actionLINK.'</td>';
						
			$data .= '</tr>';
		}
		
		if($getVARIid != 0)
		{
			#--------[ EDIT DATA's
			$QURYupdtDet = "SELECT * FROM `metal_issue` WHERE `metal_issue_id`='".$getVARIid."' ";
			$CONNupdtDet = $connection->executeQuery($QURYupdtDet);
			$FTCHupdtDet = $CONNupdtDet->fetchAll();
			
			$FTCHupdtDet['issued_id'] 				= $FTCHupdtDet[0]['issued_id'];
			$FTCHupdtDet['metal_accessories_id'] 	= $FTCHupdtDet[0]['metal_accessories_id'];
			$FTCHupdtDet['issed_wgt'] 				= $FTCHupdtDet[0]['issed_wgt'];		
			$conver_to								= $FTCHupdtDet['metal_accessories_id'];
			
			$quryMTwgtFRMstock	= "SELECT FORMAT(SUM(`acknow_wgt`), 2) AS acknow_wgt FROM `metal_issue` WHERE `metal_issued_by`='MD' AND `issued_to_flag`='PIS' AND `acknow_status`='Accepted' AND `metal_accessories_id`='".$conver_to."' ";
			$stmtMTwgtFRMstock	= $connection->executeQuery($quryMTwgtFRMstock);
			$listMTwgtFRMstock	= $stmtMTwgtFRMstock->fetchAll();
			
			//$quryMTwgtFRMisued	= "SELECT FORMAT(SUM(`issed_wgt`), 2) AS issed_wgt FROM `metal_issue` WHERE `metal_accessories_id`='".$conver_to."' AND `acknow_status` != 'Found Diff.' AND metal_issued_by='PIS'";
			$quryMTwgtFRMisued	= "SELECT FORMAT(SUM(`issed_wgt`), 2) AS issed_wgt FROM `metal_issue` WHERE `metal_accessories_id`='".$conver_to."' AND `acknow_status` != 'Found Diff.' AND metal_issued_by='PIS'  AND metal_issue_id != '".$getVARIid."' ";
			$stmtMTwgtFRMisued	= $connection->executeQuery($quryMTwgtFRMisued);
			$listMTwgtFRMisued	= $stmtMTwgtFRMisued->fetchAll();
			
			$acces_conver_wgt  = $listMTwgtFRMstock[0]['acknow_wgt'] - $listMTwgtFRMisued[0]['issed_wgt'];		
		}		

		if($request->getMethod() == 'POST')
		{
			$issued_id  	= $request->get('issued_id');
			$conver_to 		= $request->get('conver_to');
			$in_stock_wgt	= $request->get('stock_acc_wgt');
			$iss_wgt  		= $request->get('iss_wgt');
			
			if($issued_id == "MD")
			{
				$issued_to_flag = "MD";
			} 
			else 
			{
				$issued_to_flag = "W";			
			}
			
			if($getVARIid == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO ".$tableName."(`metal_issued_by`, `issued_id`, `metal_accessories_id`, `exist_stock_wgt_rfrnc`, `issed_wgt`, `issued_to_flag`, `post_by`, `post_dt`) VALUES ('PIS', '$issued_id', '$conver_to', '$in_stock_wgt', '$iss_wgt', '$issued_to_flag', '$sessionId', '$nowDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
			}
			else
			{
				########-[ UPDATE - DETAILS			
				$QRupdate 	= "UPDATE ".$tableName." SET `issued_id`='$issued_id', `metal_accessories_id`='$conver_to', `exist_stock_wgt_rfrnc`='$in_stock_wgt', `issed_wgt`='$iss_wgt', `issued_to_flag`='$issued_to_flag', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE ".$tablePrmID."=".$getVARIid;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}
		
		return $this->render('metal/metal-invent-iss-dept-data.html.twig', [
			'empDATAs' => $FTCHemp,
			'metACCESEinSTOCK' => $FTCHmetACCESEinSTOCK,
			'data' => $data,
			'FTCHupdtDet' => $FTCHupdtDet,
			'acces_conver_wgt' => $acces_conver_wgt,
			'accBINitemsDROPdown' => $accBINitemsDROPdown,
			'controller_name' => 'MetalDeptController'
        ]);
    }


    /**
     * @Route("/metal-receipt-worker-data{metRECid}", name="metal-receipt-worker-data")
     */
    public function metalRECPworkerDATAact(Request $request, $metRECid)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		
		
		########-[ QUICK VARIABLES
		$tableName	= "metal_worker_tally";
		$tablePrmID	= "metal_worker_tally_id";
		$getVARIid	= $metRECid;		

		#--------[ FETCH - ONLY EMP WHO HAS METAL is LISTED
		$QURYempMET	= "SELECT E.employee_id, E.emp_name FROM `metal_issue` AS MI, employee AS E WHERE MI.`issued_id`!='0' AND MI.issued_id=E.employee_id GROUP BY E.emp_name ORDER BY E.emp_name ASC";
		$CONNempMET	= $connection->executeQuery($QURYempMET);
		$FTCHempMET	= $CONNempMET->fetchAll();			
				
		#--------[ FETCH - ONLY METAL ACCESSORIES in INVENTORY STOCK
		//$QURYmetACCESEinINVst = "SELECT MA.metal_accessories_id, MA.metal_accessories_name FROM `metal_issue` AS MI, metal_accessories AS MA WHERE MI.metal_accessories_id=MA.metal_accessories_id AND MI.issued_to_flag='PIS' AND MI.acknow_status='Accepted' GROUP BY MI.metal_accessories_id ORDER BY MA.metal_accessories_name ASC";
		
		#--------[ FETCH - DISPLAY ALL METAL ACCESSORIES from MASTER
		$QURYmetACCESEinINVst = "SELECT MA.metal_accessories_id, MA.metal_accessories_name FROM metal_accessories AS MA ORDER BY MA.metal_accessories_name ASC";
		$CONNmetACCESEinINVst = $connection->executeQuery($QURYmetACCESEinINVst);
		$CONNmetACCESEinINVst = $connection->executeQuery($QURYmetACCESEinINVst);
		$FTCHmetACCESEinINVst = $CONNmetACCESEinINVst->fetchAll();
		
        $QURYempMET	= "SELECT E.employee_id, E.emp_name FROM employee AS E LEFT JOIN prod_iss_rec AS issRec ON issRec.employee_id = E.employee_id LEFT JOIN metal_issue AS MI ON MI.issued_id = E.employee_id GROUP BY issRec.employee_id ORDER BY E.emp_name ASC";
		$CONNempMET	= $connection->executeQuery($QURYempMET);
		$FTCHempMET	= $CONNempMET->fetchAll();			
																			 /*onchange="return workerSTspares( this.value );"*/
		$issWRKERdropDown = '<select name="iss_work_id" id="iss_work_id" class="form-control" required onchange="return workerMTwgtINhand( this.value );">
								<option value="">Choose One</option>';	
		for($i=0; $i<=count($FTCHempMET)-1; $i++)
		{
			$QURYissWGT = "SELECT sum(`wgt`) AS issWGT FROM prod_iss_rec WHERE employee_id='".$FTCHempMET[$i]['employee_id']."' AND type='iss'";
			$CONNissWGT = $connection->executeQuery($QURYissWGT);
			$FTCHissWGT = $CONNissWGT->fetchAll();
			$RSLTissWGT = $FTCHissWGT[0]['issWGT'];
			
			$QURYrecWGT = "SELECT sum(`wgt`) AS recWGT FROM prod_iss_rec WHERE employee_id='".$FTCHempMET[$i]['employee_id']."' AND type='rec'";
			$CONNrecWGT = $connection->executeQuery($QURYrecWGT);
			$FTCHrecWGT = $CONNrecWGT->fetchAll();
			$RSLTrecWGT = $FTCHrecWGT[0]['recWGT'];	
			
			if($RSLTissWGT !=0 && $RSLTissWGT >= $RSLTrecWGT)
			{
/*				echo $FTCHempMET[$i]['emp_name'].$FTCHempMET[$i]['employee_id']; 
				echo $RSLTissWGT;
				echo "-";
				echo $RSLTrecWGT;
				echo "<br>";*/
				$issWRKERdropDown .= '<option value="'.$FTCHempMET[$i]['employee_id'].'" >'.$FTCHempMET[$i]['emp_name'].'</option>';
			}		
		}
		$issWRKERdropDown .= '</select>';		
		
			
		########-[ LIST 
		$QURYlistDet = "SELECT MWT.`employee_id`, MA.metal_accessories_name, FORMAT(MWT.`exist_stock_wgt_rfrnc`, 2) AS inhand_wgt, FORMAT(MWT.`rec_wgt`, 2) AS rec_wgt, FORMAT(MWT.`other_wgt`, 2) AS other_wgt, E.emp_name, DATE_FORMAT(MWT.post_dt, '%b %d, %Y - %r') AS entryDT FROM `metal_worker_tally` AS MWT, metal_accessories AS MA, employee AS E WHERE MWT.metal_accessories_id = MA.metal_accessories_id AND MWT.post_by = E.employee_id ORDER BY MWT.`metal_worker_tally_id` DESC";
		$CONNlistDet = $connection->executeQuery($QURYlistDet);
		$FTCHlistDet = $CONNlistDet->fetchAll();
		$CONTlistDet= count($FTCHlistDet);
		
		$data = "";
		for($i=0; $i<=$CONTlistDet-1; $i++)
		{
			
			$QURYrecEMP = "SELECT emp_name FROM `employee` WHERE employee_id=".$FTCHlistDet[$i]['employee_id'];
			$CONNrecEMP = $connection->executeQuery($QURYrecEMP);
			$FTCHrecEMP = $CONNrecEMP->fetchAll();
			
			$data .= '<tr>
						<td title="Showing - Serial No." style="text-align:center; vertical-align: middle;">'. ($i+1) .'</td>
						<td title="Showing - Receive Worker" style="text-align:left; vertical-align: middle;">'.$FTCHrecEMP[0]['emp_name'].'</td>
						<td title="Showing - Product/Accessories" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['metal_accessories_name'].'</td>';
			  /*
			  $data .= '<td title="Showing - In-Hand Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]['inhand_wgt'].'</td>';
			  */
			  $data .= '<td title="Showing - Received Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]['rec_wgt'].'</td>';
			  /*
			  $data .= '<td title="Showing - Other Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]['other_wgt'].'</td>';
			  */
			  /*	  
			  $data .= '<td title="Showing - Diferene in Weight in Grams" style="text-align:right; vertical-align: middle;">'.number_format(($FTCHlistDet[$i]['rec_wgt'] - $FTCHlistDet[$i]['inhand_wgt']), 2).'</td>';
			  */
			  $data .= '<td title="Showing - Entered Person Name / Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;"><u>'.$FTCHlistDet[$i]['emp_name'].'</u><br> '.$FTCHlistDet[$i]['entryDT'].'</td>';
			$data .= '</tr>';
		}		
		
		
		if($request->getMethod() == 'POST')
		{
			$rec_work_id	= $request->get('iss_work_id');
			$conver_to		= $request->get('conver_to');
			$stock_acc_wgt	= $request->get('stock_acc_wgt');
			$rec_wgt		= $request->get('iss_wgt');
			//$other_wgt	= $request->get('other_wgt');
			
			if($getVARIid == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO ".$tableName."(`employee_id`, `metal_accessories_id`, `exist_stock_wgt_rfrnc`, `rec_wgt`,  `post_by`, `post_dt`) VALUES ('$rec_work_id', '$conver_to', '$stock_acc_wgt', '$rec_wgt', '$sessionId', '$nowDateTime')";   // `other_wgt`, //'$other_wgt',
				$CNexecut = $connection->executeQuery($QRinsert);
			}
			else
			{
				########-[ UPDATE - DETAILS			
				$QRupdate 	= "UPDATE ".$tableName." SET `stone_shape`='$stone_shape', `stone_size`='$stone_size', `stone_weight`='$stone_weight', `stone_color`='$stone_color', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE ".$tablePrmID."=".$getVARIid;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}
		
		return $this->render('metal/metal-receipt-worker-data.html.twig', [
			'empMETdatas' => $FTCHempMET,
			'metACCESEinSTOCK' => $FTCHmetACCESEinINVst,
			'w2wMtranDATA' => $data,
			'issWRKERdropDown' => $issWRKERdropDown,
			'controller_name' => 'MetalDeptController'
        ]);
    }


    /**
     * @Route("/daily-tally-data{dtalID}", name="daily-tally-data")
     */
    public function dailyTALLYdataACT(Request $request, $dtalID)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		
		
		########-[ QUICK VARIABLES
		$tableName	= "metal_daily_tally";
		$tablePrmID	= "metal_daily_tally_id";
		$getVARIid	= $metRECid;
		
		#--------[ GET DEPT LIST
		$QURYdeptlist	= "SELECT `dept_id`, `dept_name` FROM `dept` WHERE `role_status`=1 AND `avail_dept`=1 ORDER BY `dept_name` ASC";
		$CONNdeptlist	= $connection->executeQuery($QURYdeptlist);
		$FTCHdeptlist	= $CONNdeptlist->fetchAll();		
		
		#--------[ FETCH - ALL EMP LISTED
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM `employee` AS E, employee_salary AS ES, dept AS D, roles AS R WHERE E.dept=D.dept_id AND E.roles=R.roles_id AND E.employee_id=ES.employee_id AND E.role_status=1 GROUP BY ES.employee_id ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();	
		
		########-[ LIST 
		$QURYlistDet = "SELECT MDT.employee_id, FORMAT(MDT.`exist_stock_wgt_rfrnc`, 2) AS exist_stock_wgt_rfrnc, FORMAT(MDT.`rec_wgt`, 2) AS rec_wgt, E.emp_name, DATE_FORMAT(MDT.post_dt, '%b %d, %Y - %r') AS entryDT FROM `metal_daily_tally` AS MDT, employee AS E WHERE MDT.post_by=E.employee_id ORDER BY MDT.`metal_daily_tally_id` DESC";
		$CONNlistDet = $connection->executeQuery($QURYlistDet);
		$FTCHlistDet = $CONNlistDet->fetchAll();
		$CONTlistDet= count($FTCHlistDet);
		
		$data = "";
		for($i=0; $i<=$CONTlistDet-1; $i++)
		{
			$QURYrecEMP = "SELECT emp_name FROM `employee` WHERE employee_id=".$FTCHlistDet[$i]['employee_id'];
			$CONNrecEMP = $connection->executeQuery($QURYrecEMP);
			$FTCHrecEMP = $CONNrecEMP->fetchAll();		

			$data .= '<tr>
						<td title="Serial No." style="text-align:center; vertical-align: middle;">'.($i+1).'</td>
						<td title="Showing - Worker Name" style="text-align:left; vertical-align: middle;">'.$FTCHrecEMP[0]['emp_name'].'</td>
              			<td title="Showing - Last Carry Forword Balance Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]['exist_stock_wgt_rfrnc'].'</td>
						<td title="Showing - Difference/Actual Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]['rec_wgt'].'</td>
						<td title="Showing - Entered Person Name" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['emp_name'].'</td>
						<td title="Showing - Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['entryDT'].'</td>';
			$data .= '</tr>';
		}		
		
		if($request->getMethod() == 'POST')
		{
			$employee_id	= $request->get('employee_id');
			$stock_acc_wgt	= $request->get('inHANDwgt');
			$rec_wgt		= $request->get('weight');
			
			if($getVARIid == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO ".$tableName."(`employee_id`, `exist_stock_wgt_rfrnc`, `rec_wgt`, `post_by`, `post_dt`) VALUES ('$employee_id', '$stock_acc_wgt', '$rec_wgt', '$sessionId', '$nowDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
			}
			else
			{
				########-[ UPDATE - DETAILS			
				$QRupdate 	= "UPDATE ".$tableName." SET `stone_shape`='$stone_shape', `stone_size`='$stone_size', `stone_weight`='$stone_weight', `stone_color`='$stone_color', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE ".$tablePrmID."=".$getVARIid;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}		
		
		return $this->render('metal/daily-tally-data.html.twig', [
			'deptlist' => $FTCHdeptlist,
			'empDATAs' =>  $FTCHemp,
			'DAILYtallyDATAs' =>  $data,
			'controller_name' => 'MetalDeptController'
        ]);
    }			


    /**
     * @Route("/metal-invet-w2w-data{mINVw2wID}", name="metal-invet-w2w-data")
     */
    public function metalINVTw2wDATAact(Request $request, $mINVw2wID)
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		
		########-[ QUICK VARIABLES
		$tableName	= "metal_w2w_trans";
		$tablePrmID	= "metal_w2w_trans_id";
		$getVARIid	= $mINVw2wID;		

		#--------[ FETCH - ALL EMP LISTED
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM `employee` AS E, employee_salary AS ES, dept AS D, roles AS R WHERE E.dept=D.dept_id AND E.roles=R.roles_id AND E.employee_id=ES.employee_id AND E.role_status=1 GROUP BY ES.employee_id ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();	
		
		#--------[ FETCH - ONLY EMP WHO HAS METAL is LISTED
		//$QURYempMET	= "SELECT E.employee_id, E.emp_name FROM `metal_issue` AS MI, employee AS E WHERE MI.`issued_id`!='0' AND MI.issued_id=E.employee_id GROUP BY E.emp_name ORDER BY E.emp_name ASC";
		$QURYempMET	= "SELECT E.employee_id, E.emp_name FROM employee AS E LEFT JOIN prod_iss_rec AS issRec ON issRec.employee_id = E.employee_id LEFT JOIN metal_issue AS MI ON MI.issued_id = E.employee_id GROUP BY issRec.employee_id ORDER BY E.emp_name ASC";
		$CONNempMET	= $connection->executeQuery($QURYempMET);
		$FTCHempMET	= $CONNempMET->fetchAll();			
																			 /*onchange="return workerSTspares( this.value );"*/
		$issWRKERdropDown = '<select name="iss_work_id" id="iss_work_id" class="form-control" required onchange="return workerMTwgtINhand( this.value );">
								<option value="">Choose One</option>';	
		for($i=0; $i<=count($FTCHempMET)-1; $i++)
		{
			$QURYissWGT = "SELECT sum(`wgt`) AS issWGT FROM prod_iss_rec WHERE employee_id='".$FTCHempMET[$i]['employee_id']."' AND type='iss'";
			$CONNissWGT = $connection->executeQuery($QURYissWGT);
			$FTCHissWGT = $CONNissWGT->fetchAll();
			$RSLTissWGT = $FTCHissWGT[0]['issWGT'];
			
			$QURYrecWGT = "SELECT sum(`wgt`) AS recWGT FROM prod_iss_rec WHERE employee_id='".$FTCHempMET[$i]['employee_id']."' AND type='rec'";
			$CONNrecWGT = $connection->executeQuery($QURYrecWGT);
			$FTCHrecWGT = $CONNrecWGT->fetchAll();
			$RSLTrecWGT = $FTCHrecWGT[0]['recWGT'];	
			
			$QURYmetISS = "SELECT sum(`issed_wgt`) AS iSSedWGT FROM metal_issue WHERE issued_id='".$FTCHempMET[$i]['employee_id']."' ";
			$CONNmetISS = $connection->executeQuery($QURYmetISS);
			$FTCHmetISS = $CONNmetISS->fetchAll();
			$RSLTmetISS = $FTCHmetISS[0]['iSSedWGT'];				
			
			if($RSLTissWGT !=0 && $RSLTissWGT >= $RSLTrecWGT)
			{
/*				echo $FTCHempMET[$i]['emp_name'].$FTCHempMET[$i]['employee_id']; 
				echo $RSLTissWGT;
				echo "-";
				echo $RSLTrecWGT;
				echo "<br>";*/
				$issWRKERdropDown .= '<option value="'.$FTCHempMET[$i]['employee_id'].'" >'.$FTCHempMET[$i]['emp_name'].'</option>';
			}
			else if($RSLTmetISS != 0)
			{
				$issWRKERdropDown .= '<option value="'.$FTCHempMET[$i]['employee_id'].'" >'.$FTCHempMET[$i]['emp_name'].'</option>';
			}
		}
		$issWRKERdropDown .= '</select>';
			
		#--------[ FETCH - ONLY METAL ACCESSORIES in INVENTORY STOCK
		//$QURYmetACCESEinINVst = "SELECT MA.metal_accessories_id, MA.metal_accessories_name FROM `metal_issue` AS MI, metal_accessories AS MA WHERE MI.metal_accessories_id=MA.metal_accessories_id AND MI.issued_to_flag='PIS' AND MI.acknow_status='Accepted' GROUP BY MI.metal_accessories_id ORDER BY MA.metal_accessories_name ASC";
		
		#--------[ FETCH - DISPLAY ALL METAL ACCESSORIES from MASTER
		$QURYmetACCESEinINVst = "SELECT MA.metal_accessories_id, MA.metal_accessories_name FROM metal_accessories AS MA ORDER BY MA.metal_accessories_name ASC";
		$CONNmetACCESEinINVst = $connection->executeQuery($QURYmetACCESEinINVst);
		$FTCHmetACCESEinINVst = $CONNmetACCESEinINVst->fetchAll();
			
		########-[ LIST 
		$QURYlistDet = "SELECT w2w.rec_employee_id, w2w.iss_employee_id, MA.metal_accessories_name, FORMAT(w2w.issed_wgt, 2) AS issed_wgt, E.emp_name, DATE_FORMAT(w2w.post_dt, '%b %d, %Y - %r') AS entryDT FROM `metal_w2w_trans` AS w2w, metal_accessories AS MA, employee AS E WHERE w2w.metal_accessories_id=MA.metal_accessories_id AND w2w.post_by=E.employee_id ORDER BY w2w.metal_w2w_trans_id DESC";
		$CONNlistDet = $connection->executeQuery($QURYlistDet);
		$FTCHlistDet = $CONNlistDet->fetchAll();
		$CONTlistDet= count($FTCHlistDet);
		
		$data = "";
		for($i=0; $i<=$CONTlistDet-1; $i++)
		{
			
			$QURYrecEMP = "SELECT emp_name FROM `employee` WHERE employee_id=".$FTCHlistDet[$i]['rec_employee_id'];
			$CONNrecEMP = $connection->executeQuery($QURYrecEMP);
			$FTCHrecEMP = $CONNrecEMP->fetchAll();

			$QURYissEMP = "SELECT emp_name FROM `employee` WHERE employee_id=".$FTCHlistDet[$i]['iss_employee_id'];
			$CONNissEMP = $connection->executeQuery($QURYissEMP);
			$FTCHissEMP = $CONNissEMP->fetchAll();
			
			if($FTCHlistDet[$i]['rec_employee_id'] == 0){
				$receiver = "Metal Dept.";
			} else {
				$receiver = $FTCHrecEMP[0]['emp_name'];
			}
			
			$data .= '<tr>
						<td title="Showing - Serial No." style="text-align:center; vertical-align: middle;">'. ($i+1) .'</td>
						<td title="Showing - Receiver" style="text-align:left; vertical-align: middle;">'.$receiver.'</td>
						<td title="Showing - Issue Worker" style="text-align:left; vertical-align: middle;">'.$FTCHissEMP[0]['emp_name'].'</td>
						<td title="Showing - Product/Accessories" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['metal_accessories_name'].'</td>
						<td title="Showing - Issed Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]['issed_wgt'].'</td>
						<td title="Showing - Entered Person Name / Entry Date & Time of an event that a computer records" style="text-align:left; vertical-align: middle;"><u>'.$FTCHlistDet[$i]['emp_name'].'</u><br> '.$FTCHlistDet[$i]['entryDT'].'</td>';
			$data .= '</tr>';
		}		
		
		
		if($request->getMethod() == 'POST')
		{
			$rec_work_id 	= $request->get('rec_work_id');
			$iss_work_id	= $request->get('iss_work_id');
			$conver_to		= $request->get('conver_to');
			$stock_acc_wgt	= $request->get('stock_acc_wgt');
			$iss_wgt		= $request->get('iss_wgt');
			
			if($getVARIid == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO ".$tableName."(`rec_employee_id`, `iss_employee_id`, `metal_accessories_id`, `exist_stock_wgt_rfrnc`, `issed_wgt`, `post_by`, `post_dt`) VALUES ('$rec_work_id', '$iss_work_id', '$conver_to', '$stock_acc_wgt', '$iss_wgt', '$sessionId', '$nowDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
			}
			else
			{
				########-[ UPDATE - DETAILS			
				$QRupdate 	= "UPDATE ".$tableName." SET `stone_shape`='$stone_shape', `stone_size`='$stone_size', `stone_weight`='$stone_weight', `stone_color`='$stone_color', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE ".$tablePrmID."=".$getVARIid;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}				
		
		return $this->render('metal/metal-invet-w2w-data.html.twig', [
			'empDATAs' => $FTCHemp,
			'empMETdatas' => $FTCHempMET,
			'metACCESEinSTOCK' => $FTCHmetACCESEinINVst,
			'w2wMtranDATA' => $data,
			'issWRKERdropDown' => $issWRKERdropDown,
			'controller_name' => 'MetalDeptController'
        ]);
    }					
}