<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class InstockCashController extends AbstractController
{
    /**
     * @Route("/instock-cash{instockCashID}", name="instock-cash")
     */
    public function instockCASHact(Request $request, $instockCashID) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		date_default_timezone_set("Asia/Kolkata");
		$current_dt = date("Y-m-d");
		
		########-[ QUICK VARIABLES
		$tableName	= "instock_cash";
		$tablePrmID	= "instock_cash_id";
		$getVARIid	= $instockCashID;
		
		########-[ LIST - DETAILS
		$QURYlistDet= "SELECT * FROM ".$tableName." ORDER BY ".$tablePrmID." DESC";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();
		
		if($getVARIid != 0)
		{
			########-[ GET UPDATE - DETAILS
			$QURYupdtDet	= "SELECT * FROM ".$tableName." WHERE ".$tablePrmID."=".$getVARIid;
			$CONNupdtDet	= $connection->executeQuery($QURYupdtDet);
			$FTCHupdtDet	= $CONNupdtDet->fetchAll();
			
			$FTCHupdtDet['entry_dt'] 	= $FTCHupdtDet[0]['entry_date'];
			$FTCHupdtDet['cash_inward'] = $FTCHupdtDet[0]['cash_inward'];
		}
		else
		{
			$FTCHupdtDet = "";
		}
		
		if($request->getMethod() == 'POST')
		{
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime = date("Y-m-d H:i:s");
			
			$current_dt = date("Y-m-d");
			$cash_inward= $request->get('cash_inward');
			$sessionId  = $session->get('empId');
			
			if($getVARIid == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO ".$tableName."(`entry_date`, `cash_inward`, `post_by`, `post_dt`) VALUES ('$current_dt','$cash_inward','$sessionId', '$nwDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
			}
			else
			{
				########-[ UPDATE - DETAILS			
				$QRupdate 	= "UPDATE ".$tableName." SET `cash_inward`='$cash_inward', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE ".$tablePrmID."=".$getVARIid;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}
		
		
		return $this->render('instock-cash/instock-cash-data.html.twig', [
			'FTCHlistDet' => $FTCHlistDet,
			'FTCHupdtDet' => $FTCHupdtDet,
			'controller_name' => 'InstockCashController'
        ]);
    }
}
