<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class InstockAssetController extends AbstractController
{
    /**
     * @Route("/asset-list", name="asset-list")
     */
    public function assetLISTact(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		########-[ GET ASSET LIST
		$QURYlist	= "SELECT * FROM `instock_asset` ORDER BY `instock_asset_id` DESC";
		$CONNlist	= $connection->executeQuery($QURYlist);
		$FTCHlist	= $CONNlist->fetchAll();
		
		return $this->render('instock-asset/instock-asset-list.html.twig', [
			'assetList' => $FTCHlist,
			'controller_name' => 'InstockAssetController'
        ]);
    }
	
	
    /**
     * @Route("/asset-reg", name="asset-reg")
     */
    public function assetREGact(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		if($request->getMethod() == 'POST')
		{
			$prod_name			= $request->get('prod_name');
			$brand_name			= $request->get('brand_name');
			$dop				= $request->get('dop');
			$dop 				= explode("-",$dop);
			$dop 				= $dop[2]."-".$dop[1]."-".$dop[0];
			$purchase_cost		= $request->get('purchase_cost');
			$replace_wp			= $request->get('replace_wp');
			$warrenty_period	= $request->get('warrenty_period');
			$warrenty_end_date	= $request->get('warrenty_end_date');
			$warrenty_end_date  = explode("-",$warrenty_end_date);
			$warrenty_end_date  = $warrenty_end_date[2]."-".$warrenty_end_date[1]."-".$warrenty_end_date[0];
			$no_of_free_service	= $request->get('no_of_free_service');
			$concern_name		= $request->get('concern_name');
			$door_no			= $request->get('door_no');
			$street				= $request->get('street');
			$city				= $request->get('city');
			$state				= $request->get('state');
			$sales_person		= $request->get('sales_person');
			$sales_mbl			= $request->get('sales_mbl');
			$sales_mail			= $request->get('sales_mail');
			$service_person		= $request->get('service_person');
			$service_mbl		= $request->get('service_mbl');
			$service_mail		= $request->get('service_mail');
			$sessionId  		= $session->get('empId');
			
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime = date("Y-m-d H:i:s");
			
			########-[ INSERT - DETAILS
			$QRinsert = "INSERT INTO `instock_asset`(`prod_name`, `brand_name`, `date_of_purchase`, `purchase_cost`, `replace_warrenty_period`, `warrenty_period`, `warrenty_end_dt`, `no_of_free_services`, `concern_name`, `door_no`, `street1`, `city`, `state`, `sales_person`, `sales_mbl_no`, `sales_mail_id`, `service_person`, `service_mbl_no`, `service_mail_id`, `post_by`, `post_dt`) VALUES ('$prod_name', '$brand_name', '$dop', '$purchase_cost', '$replace_wp', '$warrenty_period', '$warrenty_end_date', '$no_of_free_service', '$concern_name', '$door_no', '$street', '$city', '$state', '$sales_person', '$sales_mbl', '$sales_mail', '$service_person', '$service_mbl', '$service_mail', '$sessionId', '$nwDateTime')";
			$CNexecut = $connection->executeQuery($QRinsert);
			
			return $this->redirectToRoute('asset-list');
		}
		
		return $this->render('instock-asset/instock-asset-reg.html.twig', [
			'maxPID' => $FTCHmaxPID,
			'controller_name' => 'InstockAssetController'
        ]);
    }


    /**
     * @Route("/asset-upt{asset_upt_id}", name="asset-upt")
     */
    public function assetUPTact(Request $request, $asset_upt_id) 
    {	
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 	
		
		########-[ GET UPDATE DATA
		$QURYuptDATA	= "SELECT * FROM `instock_asset` WHERE instock_asset_id = ".$asset_upt_id;
		$CONNuptDATA	= $connection->executeQuery($QURYuptDATA);
		$FTCHuptDATA	= $CONNuptDATA->fetchAll();
		
		if($request->getMethod() == 'POST')
		{
			$prod_name			= $request->get('prod_name');
			$brand_name			= $request->get('brand_name');
			$dop				= $request->get('dop');
			$dop 				= explode("-",$dop);
			$dop 				= $dop[2]."-".$dop[1]."-".$dop[0];
			$purchase_cost		= $request->get('purchase_cost');
			$replace_wp			= $request->get('replace_wp');
			$warrenty_period	= $request->get('warrenty_period');
			$warrenty_end_date	= $request->get('warrenty_end_date');
			$warrenty_end_date  = explode("-",$warrenty_end_date);
			$warrenty_end_date  = $warrenty_end_date[2]."-".$warrenty_end_date[1]."-".$warrenty_end_date[0];
			$no_of_free_service	= $request->get('no_of_free_service');
			$concern_name		= $request->get('concern_name');
			$door_no			= $request->get('door_no');
			$street				= $request->get('street');
			$city				= $request->get('city');
			$state				= $request->get('state');
			$sales_person		= $request->get('sales_person');
			$sales_mbl			= $request->get('sales_mbl');
			$sales_mail			= $request->get('sales_mail');
			$service_person		= $request->get('service_person');
			$service_mbl		= $request->get('service_mbl');
			$service_mail		= $request->get('service_mail');
			
			$sessionId  		= $session->get('empId');
			
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime 		= date("Y-m-d H:i:s");
			
			########-[ UPDATE - DETAILS
			$QRuptDATA = "UPDATE `instock_asset` SET `prod_name`='$prod_name', `brand_name`='$brand_name', `date_of_purchase`='$dop', `purchase_cost`='$purchase_cost', `replace_warrenty_period`='$replace_wp', `warrenty_period`='$warrenty_period', `warrenty_end_dt`='$warrenty_end_date', `no_of_free_services`='$no_of_free_service', `concern_name`='$concern_name', `door_no`='$door_no', `street1`='$street', `city`='$city', `state`='$state', `sales_person`='$sales_person', `sales_mbl_no`='$sales_mbl', `sales_mail_id`='$sales_mail', `service_person`='$service_person', `service_mbl_no`='$service_mbl', `service_mail_id`='$service_mail', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `instock_asset_id`=".$asset_upt_id;
			$CNuptDATA = $connection->executeQuery($QRuptDATA);
			
			return $this->redirectToRoute('asset-list');
		}
		
		return $this->render('instock-asset/instock-asset-upt.html.twig', [
			'UPDTdata' => $FTCHuptDATA,
			'controller_name' => 'InstockAssetController'
        ]);
	}	
}
