<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class GoldStockController extends AbstractController
{
    /**
     * @Route("/gold-stock-particulars{gspID}", name="gold-stock-particulars")
     */
    public function goldStockParticularsACT(Request $request, $gspID)  
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		########-[ LIST - DETAILS
		$QURYlistDet= "SELECT *, IF(`type`='iss', 'Issue', 'Receive') AS tyPE FROM `gold_stock_parti` ORDER BY `gold_stock_parti_id` DESC";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();
		
		if($gspID != 0)
		{
			########-[ GET UPDATE - DETAILS
			$QURYupdtDet	= "SELECT * FROM `gold_stock_parti` WHERE `gold_stock_parti_id`=".$gspID;
			$CONNupdtDet	= $connection->executeQuery($QURYupdtDet);
			$FTCHupdtDet	= $CONNupdtDet->fetchAll();
			
			$FTCHupdtDet['type'] 					= $FTCHupdtDet[0]['type'];
			$FTCHupdtDet['gold_stock_parti_name']   = $FTCHupdtDet[0]['gold_stock_parti_name'];
		}
		else
		{
			$FTCHupdtDet = "";
		}
		
		if($request->getMethod() == 'POST')
		{
			$type				= $request->get('type');
			$gold_stock_partic	= $request->get('gold_stock_partic');
			$sessionId  		= $session->get('empId');
			
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime = date("Y-m-d H:i:s");
			
			if($gspID == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO `gold_stock_parti`(`type`, `gold_stock_parti_name`, `post_by`, `post_dt`) VALUES ('$type','$gold_stock_partic','$sessionId','$nwDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
			}
			else
			{
				########-[ UPDATE - DETAILS			
				$QRupdate 	= "UPDATE `gold_stock_parti` SET `type`='$type', `gold_stock_parti_name`='$gold_stock_partic', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE gold_stock_parti_id=".$gspID;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}
		
		return $this->render('gold-stock/gold-stock-particulars-data.html.twig', [
			'listDet' => $FTCHlistDet,
			'FTCHupdtDet' => $FTCHupdtDet,
			'controller_name' => 'GoldStockController'
        ]);
    }
	
	
    /**
     * @Route("/gold-stock-iss-rec-data{gsIssRecID}", name="gold-stock-iss-rec-data")
     */
    public function goldStockIssRecLISTact(Request $request, $gsIssRecID) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		########-[ GET TRANS NO
		$QURYtransNO	= "SELECT IF(MAX(`trans_no`) IS NULL,1,MAX(`trans_no`)+1) AS transNo FROM `gold_stock_iss_rec` WHERE `role_status`=1";
		$CONNtransNO	= $connection->executeQuery($QURYtransNO);
		$FTCHtransNO	= $CONNtransNO->fetchAll();
		$RSLTtransNO	= $FTCHtransNO[0]['transNo'];
		
		########-[ GET PARTICULAR's on ISS
		$QURYtypeISS	= "SELECT `gold_stock_parti_id`, `gold_stock_parti_name` FROM `gold_stock_parti` WHERE `role_status`=1 AND `type`='iss' ORDER BY `gold_stock_parti_name` ASC";
		$CONNtypeISS	= $connection->executeQuery($QURYtypeISS);
		$FTCHtypeISS	= $CONNtypeISS->fetchAll();
		
		########-[ GET PARTICULAR's on REC
		$QURYtypeREC	= "SELECT `gold_stock_parti_id`, `gold_stock_parti_name` FROM `gold_stock_parti` WHERE `role_status`=1 AND `type`='rec' ORDER BY `gold_stock_parti_name` ASC";
		$CONNtypeREC	= $connection->executeQuery($QURYtypeREC);
		$FTCHtypeREC	= $CONNtypeREC->fetchAll();		
		
		########-[ GET PARTY LIST
		$QURYpartyLIST	= "SELECT `party_id`, CONCAT(`pid`,' - ',`concern_name`) AS partyName FROM `party` WHERE `role_status`=1 ORDER BY partyName ASC";
		$CONNpartyLIST	= $connection->executeQuery($QURYpartyLIST);
		$FTCHpartyLIST	= $CONNpartyLIST->fetchAll();
		
		########-[ GET PROD TRANS LIST
/*		$QURYtranslist	= "SELECT
								c.gold_stock_iss_rec_id,
								c.`type`,
								c.`trans_no`,
								DATE_FORMAT(c.trans_date, '%b %d, %y - %a') AS tranDate,
								gsp.gold_stock_parti_name AS partiName,
								tp.concern_name,
								CONCAT(p.po_financial_yr, '', p.po_no) AS poNO,
								c.notes,
								c.wgt,
								c.piece_bit,
								c.purity
							FROM
								gold_stock_iss_rec c
							LEFT OUTER JOIN po p ON
								(
									c.`other_ids` = p.po_id AND c.`parti_id` = '1'
								)
							LEFT OUTER JOIN party tp ON
								(
									c.other_ids = tp.party_id AND c.`parti_id` = '3'
								)
							LEFT OUTER JOIN gold_stock_parti gsp ON
								(
									c.`parti_id` = gsp.gold_stock_parti_id
								)
							ORDER BY
								c.`gold_stock_iss_rec_id`
							DESC";*/

/*			$QURYtranslist	= "SELECT
									c.gold_stock_iss_rec_id,
									c.`type`,
									c.`trans_no`,
									DATE_FORMAT(c.trans_date, '%b %d, %y - %a') AS tranDate,
									gsp.gold_stock_parti_name AS partiName,
									tp.concern_name,
									CONCAT(p.po_financial_yr, '', p.po_no) AS poNO,
									c.notes,
									c.wgt,
									c.piece_bit,
									c.purity
								FROM
									gold_stock_iss_rec c
								LEFT OUTER JOIN po p ON
									(
										c.`other_ids` = p.po_id AND c.`parti_id` = '1'
									)
								LEFT OUTER JOIN party tp ON
									(c.other_ids = tp.party_id) AND c.`parti_id` = '3' OR (c.other_ids = tp.party_id) AND c.`parti_id` = '5'
								LEFT OUTER JOIN gold_stock_parti gsp ON
									(
										c.`parti_id` = gsp.gold_stock_parti_id
									)
								ORDER BY
									c.`gold_stock_iss_rec_id`
								DESC";	*/	
			
			$QURYtranslist	= "SELECT
									c.gold_stock_iss_rec_id,
									c.`type`,
									c.`trans_no`,
									DATE_FORMAT(c.trans_date, '%b %d, %y - %a') AS tranDate,
									gsp.gold_stock_parti_name AS partiName,
									gsp.gold_stock_parti_id AS partiID,
									tp.concern_name,
									CONCAT(p.po_financial_yr, '', p.po_no) AS poNO,
									c.notes,
									c.wgt,
									c.piece_bit,
									c.purity
								FROM
									gold_stock_iss_rec c
								LEFT OUTER JOIN po p ON
									(
										(c.`other_ids` = p.po_id) AND c.`parti_id` = '1' OR(c.other_ids = p.po_id) AND c.`parti_id` = '6'
									)
								LEFT OUTER JOIN party tp ON
									(c.other_ids = tp.party_id) AND c.`parti_id` = '3' OR(c.other_ids = tp.party_id) AND c.`parti_id` = '5' OR(
										c.other_ids = p.po_id AND p.party_id = tp.party_id
									) AND c.`parti_id` = '1' OR(
										c.other_ids = p.po_id AND p.party_id = tp.party_id
									) AND c.`parti_id` = '6'
								LEFT OUTER JOIN gold_stock_parti gsp ON
									(
										c.`parti_id` = gsp.gold_stock_parti_id
									)
								ORDER BY
									c.`gold_stock_iss_rec_id`
								DESC";													
		$CONNtranslist	= $connection->executeQuery($QURYtranslist);
		$FTCHtranslist	= $CONNtranslist->fetchAll();
		
		########-[ GET PROD TRANS DATA to UPDATE
		$QURYtransDATA					= "SELECT * FROM `gold_stock_iss_rec` WHERE gold_stock_iss_rec_id='$gsIssRecID'";
		$CONNtransDATA					= $connection->executeQuery($QURYtransDATA);
		$FTCHtransDATA					= $CONNtransDATA->fetchAll();
		$FTCHtransDATA['trans_no'] 		= $FTCHtransDATA[0]['trans_no'];
		$FTCHtransDATA['trans_date']	= $FTCHtransDATA[0]['trans_date'];
		$FTCHtransDATA['type'] 			= $FTCHtransDATA[0]['type'];		
		$FTCHtransDATA['parti_id'] 		= $FTCHtransDATA[0]['parti_id'];
		$FTCHtransDATA['other_ids']		= $FTCHtransDATA[0]['other_ids'];
		$FTCHtransDATA['notes'] 		= $FTCHtransDATA[0]['notes'];
		$FTCHtransDATA['wgt'] 			= $FTCHtransDATA[0]['wgt'];
		$FTCHtransDATA['piece_bit']		= $FTCHtransDATA[0]['piece_bit'];
		$FTCHtransDATA['purity']		= $FTCHtransDATA[0]['purity'];		
		
		if($gsIssRecID == 0)
		{		
			########-[ GET PO LIST
			$QURYpoLIST		= "SELECT `po_id`, CONCAT(`po_financial_yr`,'',`po_no`) AS poNO FROM `po` WHERE `po_status`=0 AND `role_status`=1 ORDER BY poNO ASC";
			$CONNpoLIST		= $connection->executeQuery($QURYpoLIST);
			$FTCHpoLIST		= $CONNpoLIST->fetchAll();
		}
		else
		{
			if($FTCHtransDATA['parti_id'] == 1)
			{
				########-[ GET PO LIST
				$QURYpoLIST		= "SELECT `po_id`, CONCAT(`po_financial_yr`,'',`po_no`) AS poNO FROM `po` WHERE `role_status`=1 ORDER BY poNO ASC";
				$CONNpoLIST		= $connection->executeQuery($QURYpoLIST);
				$FTCHpoLIST		= $CONNpoLIST->fetchAll();		
			}
			elseif($FTCHtransDATA['parti_id'] == 6)
			{
				########-[ GET PO LIST
				$QURYpoLIST		= "SELECT `po_id`, CONCAT(`po_financial_yr`,'',`po_no`) AS poNO FROM `po` WHERE `ornament_stock_status`=2 AND `role_status`=1 ORDER BY poNO ASC";
				$CONNpoLIST		= $connection->executeQuery($QURYpoLIST);
				$FTCHpoLIST		= $CONNpoLIST->fetchAll();		
			}
			
		}		
		
		if($request->getMethod() == 'POST')
		{
			$tran_no		= $request->get('tran_no');
			$iss_rec_date	= $request->get('iss_rec_date');
			$iss_rec_date 	= explode("-",$iss_rec_date);
			$iss_rec_date 	= $iss_rec_date[2]."-".$iss_rec_date[1]."-".$iss_rec_date[0];
			$type			= $request->get('type');			
			$parti			= $request->get('parti');
			$dynamicID		= $request->get('dynamicID');
			$dynamicID1		= $request->get('dynamicID1');
			$wgt			= $request->get('wgt');
			$pieces			= $request->get('pieces');
			$purity			= $request->get('purity');
			
			$sessionId  	= $session->get('empId');
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime 	= date("Y-m-d H:i:s");
			
			if($parti == 1)
			{
				$RSLTpoID 	= $dynamicID;
				
				########-[ GET PARTY ID
				$QURYpartyIDofPO = "SELECT `party_id` FROM `po` WHERE po_id=".$RSLTpoID;
				$CONNpartyIDofPO = $connection->executeQuery($QURYpartyIDofPO);
				$FTCHpartyIDofPO = $CONNpartyIDofPO->fetchAll();				
				$RSLTpartyID	 = $FTCHpartyIDofPO[0]['party_id'];
			}
			elseif($parti == 3)
			{
				$RSLTpartyID = $dynamicID;
			}
			elseif($parti == 6)
			{
				$RSLTpoID 	= $dynamicID;
				
				########-[ GET PARTY ID
				$QURYpartyIDofPO = "SELECT `party_id` FROM `po` WHERE po_id=".$RSLTpoID;
				$CONNpartyIDofPO = $connection->executeQuery($QURYpartyIDofPO);
				$FTCHpartyIDofPO = $CONNpartyIDofPO->fetchAll();				
				$RSLTpartyID	 = $FTCHpartyIDofPO[0]['party_id'];				
			}
			
			if($gsIssRecID == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO `gold_stock_iss_rec`(`trans_no`, `trans_date`, `type`, `parti_id`, `other_ids`, `party_id`, `po_id`, `notes`, `wgt`, `piece_bit`, `purity`, `post_by`, `post_dt`) VALUES ( '$tran_no', '$iss_rec_date', '$type', '$parti', '$dynamicID', '$RSLTpartyID', '$RSLTpoID', '$dynamicID1', '$wgt', '$pieces', '$purity', '$sessionId', '$nwDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
				
				if($parti == 6)
				{
					########-[ UPDATE - PO STATUS to DELIVERY
					$QRupdate = "UPDATE `po` SET `ornament_stock_status` = '2' WHERE `po`.`po_id` = $dynamicID";
					$CNexecut = $connection->executeQuery($QRupdate);
				}
			}
			else
			{
				########-[ UPDATE - DETAILS
				echo
				$QRupdate = "UPDATE `gold_stock_iss_rec` SET `trans_no`='$tran_no', `trans_date`='$iss_rec_date', `type`='$type', `parti_id`='$parti', `other_ids`='$dynamicID', `notes`='$dynamicID1', `party_id`='$RSLTpartyID', `po_id`='$RSLTpoID', `wgt`='$wgt', `piece_bit`='$pieces', `purity`='$purity', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `gold_stock_iss_rec_id`='$gsIssRecID'";
				$CNexecut = $connection->executeQuery($QRupdate);
			}

		return $this->redirectToRoute('gold-stock-iss-rec-data', array('gsIssRecID' => $gsIssRecID) );		
		}
		
		return $this->render('gold-stock/gold-stock-iss-rec-data.html.twig', [
			'transNO' => $RSLTtransNO,
			'PARTItypeISS' => $FTCHtypeISS,
			'PARTItypeREC' => $FTCHtypeREC,
			'poLIST' => $FTCHpoLIST,
			'partyLIST' => $FTCHpartyLIST,
			'TRANSlist' => $FTCHtranslist,
			'FTCHtransDATA' => $FTCHtransDATA,
			'controller_name' => 'GoldStockController'
        ]);
    }	
	
	
   /** 
	* @Route("/loadParticulars", name="loadParticulars") 
	*/ 
	public function loadParticularsAct(Request $request) 
	{ 
		$session 	= $request->getSession();
		
	    $connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$partiVal  	= $request->get('partiVal');

		#--------[FETCH GOLD STOCK  PARTICULARS
		$QURY	= "SELECT * FROM `gold_stock_parti` WHERE `type`='".$partiVal."' AND role_status=1 ORDER BY gold_stock_parti_name ASC";
		$CONN	= $connection->executeQuery($QURY);
		$FTCH	= $CONN->fetchAll();			

		$rslt = $FTCH;
		return  new JsonResponse($rslt);
	}	
	
	
   /** 
	* @Route("/loadParticularsDATAs", name="loadParticularsDATAs") 
	*/ 
	public function loadParticularsDataAct(Request $request) 
	{ 
		$session 	= $request->getSession();
		
	    $connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$dynamicID 	= $request->get('dynamicID');
		
		if($dynamicID == "1")		#--------[1 - Production Data's
		{
			#--------[FETCH PARTY DATA's
			$QURY  = "SELECT `po_id`, CONCAT(`po_financial_yr`,'',`po_no`) AS poNO FROM `po` WHERE `po_status`=0 AND `role_status`=1";
			$CONN  = $connection->executeQuery($QURY);
			$RSLT  = $CONN->fetchAll();			
		}
		else if($dynamicID == "6")		#--------[6 - Sales - Party Data's
		{
			#--------[FETCH PARTY DATA's
			$QURY  = "SELECT `po_id`, CONCAT(`po_financial_yr`,'',`po_no`) AS poNO FROM `po` WHERE `po_status`=1 AND `ornament_stock_status`=1 AND `role_status`=1";
			$CONN  = $connection->executeQuery($QURY);
			$RSLT  = $CONN->fetchAll();			
		}
		else if($dynamicID == "2")		#--------[2 mean for Sale Data's
		{
			$RSLT  = 2;
		}			
		else if($dynamicID == "3" || $dynamicID == "5")		#--------[ 3 - Party Data's, 5 - Gold Stock Data's
		{
			#--------[FETCH PARTY DATA's
			$QURY  = "SELECT party_id, CONCAT(pid,' - ',concern_name) AS partyName FROM `party` WHERE role_status=1 ORDER BY partyName ASC";
			$CONN  = $connection->executeQuery($QURY);
			$RSLT  = $CONN->fetchAll();			
		}
		else if($dynamicID == "4")		#--------[4 mean for Purchase Data's
		{
			$RSLT  = 4;
		}	

		$rslt = $RSLT;
		return  new JsonResponse($rslt);
	}	
	
	
   /** 
	* @Route("/gold-stock-iss-rec-dlt{gsIssRecDltID}", name="gold-stock-iss-rec-dlt") 
	*/ 	 
    public function vendorDLTact(Request $request, $gsIssRecDltID) 
    {	
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 	
		
		########-[ DELETE - DETAILS
		$QRdlt = "DELETE FROM `gold_stock_iss_rec` WHERE `gold_stock_iss_rec_id`=".$gsIssRecDltID;
		$CNdlt = $connection->executeQuery($QRdlt);
		
		return $this->redirectToRoute('gold-stock-iss-rec-data', array('gsIssRecID' => 0));
	}
	
	
	/**
     * @Route("/ornament-stock-list", name="ornament-stock-list")
     */
    public function ornamentStockListACT(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		########-[ GET DESIGN LIST
		//$QURYlist	= "SELECT P.po_id, CONCAT(P.po_financial_yr, P.po_no) AS poNO, DATE_FORMAT(P.po_date,'%b %d, %y - %a') AS poDATE, PR.pid AS partyCD, PR.concern_name AS partyNm, COUNT(PD.po_det_id) AS poDSGNcont, SUM(D.st_wgt * PD.qty) AS poSTwt, SUM(D.gross_wgt * PD.qty) AS poGROSSwt FROM `po` AS P, `po_det` AS PD, `party` AS PR, `designs` AS D WHERE P.po_id=PD.po_id AND PD.design_id=D.design_id AND P.party_id=PR.party_id GROUP BY poNO ORDER BY P.`po_id` DESC";
		
		$QURYlist	= "SELECT
							P.po_id,
							P.`ornament_stock_status`,
							CONCAT(P.po_financial_yr, P.po_no) AS poNO,
							DATE_FORMAT(P.po_date, '%b %d, %y - %a') AS poDATE,
							PR.pid AS partyCD,
							PR.concern_name AS partyNm,
							COUNT(PD.po_det_id) AS poDSGNcont,
							SUM(D.st_wgt * PD.qty) AS poSTwt,
							SUM(D.gross_wgt * PD.qty) AS poGROSSwt,
							-- GSIR.other_ids AS goldSTOCKadded,
							SUM(PD.closing_wgt) AS prodWT
						FROM
							`po` AS P
						LEFT JOIN `po_det` AS PD
						ON
							P.po_id = PD.po_id
						LEFT JOIN `designs` AS D
						ON
							PD.design_id = D.design_id
						LEFT JOIN `party` AS PR
						ON
							P.party_id = PR.party_id
						-- LEFT JOIN `gold_stock_iss_rec` AS GSIR
						-- ON
							-- GSIR.parti_id = 1 AND GSIR.other_ids = P.po_id
						WHERE
							P.ornament_stock_status = 1
						GROUP BY
							poNO
						ORDER BY
							P.`update_dt`
						DESC
							,
							P.`po_id`
						DESC";
		$CONNlist	= $connection->executeQuery($QURYlist);
		$FTCHlist	= $CONNlist->fetchAll();
		
		return $this->render('gold-stock/ornament-stock-list.html.twig', [
			'list' => $FTCHlist,
			'controller_name' => 'GoldStockController'
        ]);
    }	
	
	
   /** 
	* @Route("/loadPOclosingWGT", name="loadPOclosingWGT") 
	*/ 
	public function loadPOclosingWGTact(Request $request) 
	{ 
		$session 	= $request->getSession();
		
	    $connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$poID 		= $request->get('poID');
		$gsIssRecID = $request->get('gsIssRecID');
		
		if($gsIssRecID != 0)
		{
			$QURY  = "SELECT FORMAT(SUM(`wgt`), 3) AS POwgt FROM `po_daily_closing` WHERE `po_id`=".$poID;
		} 
		else 
		{
			//$QURY  = "SELECT SUM(PD.qty * (D.gross_wgt - D.st_wgt)) AS POwgt FROM `po_det` AS PD, `designs` AS D WHERE PD.design_id=D.design_id AND PD.po_id=".$poID;
			$QURY  = "SELECT SUM(PD.qty * D.gross_wgt) AS POwgt FROM `po_det` AS PD, `designs` AS D WHERE PD.design_id=D.design_id AND PD.po_id=".$poID;
		}
		
		$CONN  = $connection->executeQuery($QURY);
		$FTCH  = $CONN->fetchAll();			

		$rslt = $FTCH[0]['POwgt'];
		//$rslt = $QURY;
		return  new JsonResponse($rslt);
	}	
	
	
	/**
     * @Route("/ornament-stock-po-design-updt-submit{poNoLISTid}", name="ornament-stock-po-design-updt-submit")
     */
    public function ornamentStockPOdesignUpdtSubmitACT(Request $request, $poNoLISTid) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		if($request->getMethod() == 'POST')
		{

			$alter_po_id = $request->get('alter_po_id');
			$exist_po_id = $request->get('existing_po_id');
			$existPrtyId = $request->get('existing_party_id');
			
			$sessionId  	= $session->get('empId');
			date_default_timezone_set("Asia/Kolkata");
			$nwDate 		= date("Y-m-d");
			$nwDateTime 	= date("Y-m-d H:i:s");			
			
			#--------[ FETCH ALTER PARTY ID		
			$QURYpartyID  = "SELECT `party_id` FROM `po` WHERE `po_id`=".$alter_po_id;
			$CONNpartyID  = $connection->executeQuery($QURYpartyID);
			$FTCHpartyID  = $CONNpartyID->fetchAll();
			$RSLTpartyID  = $FTCHpartyID[0]['party_id'];
			
			
			#--------[ FETCH
			//echo
			//$QURYuptPOlp  = "SELECT D.design_no, POD.* FROM `po_det` AS POD, `designs` AS D WHERE POD.`po_id` = ".$alter_po_id." AND POD.`party_id` = ".$RSLTpartyID." AND D.design_id = POD.design_id ORDER BY D.design_no ASC";
			$QURYuptPOlp  = "SELECT D.design_no, POD.* FROM `po_det` AS POD, `designs` AS D WHERE POD.`po_id` = $poNoLISTid AND D.design_id = POD.design_id ORDER BY D.design_no ASC";
			//echo "<br>";
			$CONNuptPOlp  = $connection->executeQuery($QURYuptPOlp);
			$FTCHuptPOlp  = $CONNuptPOlp->fetchAll();

			$CONTuptPOlp  = count($FTCHuptPOlp);

			for($i = 0; $i <= $CONTuptPOlp - 1; $i++)
			{
				$alter_po_id	= $_POST['alter_po_id'];
				//echo
				$design_id 		= $_POST['design_id'][$i];
				//echo "<br>";
				$po_det_id 		= $_POST['po_det_id'][$i];
				$closing_qty	= $_POST['closing_qty'][$i];
				$closing_wgt 	= $_POST['closing_wgt'][$i];
				$selectAll 		= $_POST['selectAll'][$i];
				
				$selectedItems	= explode(",",$selectAll);
				//print_r($selectedItems);
				//echo "<br>";
				$design_idSLCT	= $selectedItems[0];
				$closingQtySLCT = $selectedItems[1];
				$closingWgtSLCT = $selectedItems[2];
				$po_det_idSLCT	= $selectedItems[3];
				
				if(isset($_POST['selectAll'][$i]))// && $design_id == $FTCHuptPOlp[$i]['design_id'])
				{
				#--------[UPDATE - ALTER PO DET TBL
				//echo
				//$UPDTalterPOdet = "UPDATE `po_det` SET `closing_qty`='$closing_qty',`closing_wgt`='$closing_wgt',`update_by`='$sessionId',`update_dt`='' WHERE po_det_id = ".$FTCHuptPOlp[$i]['po_det_id'];
				$UPDTalterPOdet = "UPDATE `po_det` SET `closing_qty`='$closingQtySLCT',`closing_wgt`='$closingWgtSLCT',`update_by`='$sessionId',`update_dt`='' WHERE po_id = '".$alter_po_id."' AND design_id='$design_idSLCT'";
				$CONNalterPOdet = $connection->executeQuery($UPDTalterPOdet);
				//echo "<br>";
				
				#--------[UPDATE - EXISTING PO DET TBL
				//echo 
				$UPDTexistPOdet = "UPDATE `po_det` SET `closing_qty`='',`closing_wgt`='',`update_by`='$sessionId',`update_dt`='$nwDateTime' WHERE po_det_id = ".$po_det_idSLCT;
				$CONNexistPOdet = $connection->executeQuery($UPDTexistPOdet);	
				//echo "<br>";
				
				#--------[UPDATE - EXISTING PO DAILY CLOSING TBL
				//echo
				$UPDTexistPOdailyCL = "UPDATE `po_daily_closing` SET `po_id`='$alter_po_id',`update_by`='$sessionId',`update_dt`='$nwDateTime' WHERE `po_det_id`=".$po_det_idSLCT;
				$CONNexistPOdailyCL = $connection->executeQuery($UPDTexistPOdailyCL);	
				//echo "<br>";
				}
				
				#--------[INSERT - EXISTING PO DAILY CLOSING TBL
				//$INSTpoDAILYcl = "INSERT INTO `po_daily_closing`(`po_id`, `po_det_id`, `qty`, `wgt`, `closing_date`, `post_by`, `post_dt`) VALUES ('$alter_po_id', '".$FTCHuptPOlp[$i]['po_det_id']."', '$closing_qty', '$closing_wgt', '$nwDate', '$$sessionId', '$nwDateTime')";
				//$CONNpoDAILYcl = $connection->executeQuery($INSTpoDAILYcl);	
			}

			#--------[UPDATE - EXIXTING PO TBL
			//$UPDTalterPO = "UPDATE `po` SET `party_id`='$RSLTpartyID',`po_status`='0',`ornament_stock_status`='0',`update_by`='$sessionId',`update_dt`='$nwDateTime' WHERE `po_id`=".$exist_po_id;
			//echo
			$UPDTalterPO = "UPDATE `po` SET `po_status`='0',`ornament_stock_status`='0',`update_by`='$sessionId',`update_dt`='$nwDateTime' WHERE `po_id`=".$exist_po_id;
			$CONNalterPO = $connection->executeQuery($UPDTalterPO);
			//echo "<br>";
			
			#--------[UPDATE - EXISTING PO DET TBL
			//$UPDTexistPO = "UPDATE `po` SET `party_id`='$existPrtyId',`po_status`='1',`ornament_stock_status`='1',`update_by`='$sessionId',`update_dt`='$nwDateTime' WHERE `po_id`=".$alter_po_id;
			//echo
			$UPDTexistPO = "UPDATE `po` SET `po_status`='1',`ornament_stock_status`='1',`update_by`='$sessionId',`update_dt`='$nwDateTime' WHERE `po_id`=".$alter_po_id;
			$CONNalterPO = $connection->executeQuery($UPDTexistPO);	
			//echo "<br>";
			
			
			#--------[UPDATE - EXISTING PO DAILY CLOSING TBL
			//echo
			//$UPDTexistPOdailyCL = "UPDATE `po_daily_closing` SET `po_id`='$alter_po_id',`update_by`='$sessionId',`update_dt`='$nwDateTime' WHERE `po_id`=".$exist_po_id;
			//$CONNexistPOdailyCL = $connection->executeQuery($UPDTexistPOdailyCL);	
			//echo "<br>";
			
			
			#--------[UPDATE - PO in GOLD STOCK ISS/REC TBL
			//echo
			$UPDTpoIDgoldSTisRe = "UPDATE `gold_stock_iss_rec` SET `other_ids` = '$alter_po_id' WHERE `parti_id`=1 AND `other_ids`=".$exist_po_id;
			$CONNpoIDgoldSTisRe = $connection->executeQuery($UPDTpoIDgoldSTisRe);				
			//echo "<br>";
		}
		//die();		
		return $this->redirectToRoute('po-list');
    }		
	
	
    /**
     * @Route("/ornament-stock-po-design-updt{poLISTid}", name="ornament-stock-po-design-updt") 
     */
    public function ornamentStockPOdesignUpdtACT(Request $request, $poLISTid) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		#--------[ FTCH ALTER PO NO
		$QURYalterPONo	= "SELECT PO.po_id, CONCAT(po_financial_yr, '', po_no) AS poNO FROM `po` AS PO LEFT OUTER JOIN `gold_stock_iss_rec` AS GSIR ON GSIR.parti_id = 5 AND GSIR.other_ids = PO.po_id WHERE PO.`po_status` = 0 AND PO.`role_status` = 1 ORDER BY poNO ASC";			
		$CONNalterPONo	= $connection->executeQuery($QURYalterPONo);
		$FTCHalterPONo	= $CONNalterPONo->fetchAll();

		
		#--------[ FTCH PO DATE & PO NO
		$QURYpoNOdt		= "SELECT po_id, party_id, DATE_FORMAT(`po_date`,'%b %d, %Y - %M') AS poDATE, CONCAT(po_financial_yr,'',po_no) AS poNO FROM `po` WHERE `po_id`=".$poLISTid;			
		$CONNpoNOdt		= $connection->executeQuery($QURYpoNOdt);
		$FTCHpoNOdt		= $CONNpoNOdt->fetchAll();
		$FTCHpoNOdt['poDATE'] 	= $FTCHpoNOdt[0]['poDATE'];
		$FTCHpoNOdt['poNO'] 	= $FTCHpoNOdt[0]['poNO'];	
		$FTCHpoNOdt['po_id'] 	= $FTCHpoNOdt[0]['po_id'];
		$FTCHpoNOdt['party_id']	= $FTCHpoNOdt[0]['party_id'];
		
		
		#--------[ FTCH PO CLOSING QTY & WGT
		$QURYpoQTYwgt	= "SELECT SUM(`closing_qty`) AS closingQTY, FORMAT(SUM(`closing_wgt`), 3) AS closingWGT FROM `po_det` WHERE `po_id`=".$poLISTid;			
		$CONNpoQTYwgt	= $connection->executeQuery($QURYpoQTYwgt);
		$FTCHpoQTYwgt	= $CONNpoQTYwgt->fetchAll();
		$FTCHpoQTYwgt['closingQTY']	= $FTCHpoQTYwgt[0]['closingQTY'];
		$FTCHpoQTYwgt['closingWGT']	= $FTCHpoQTYwgt[0]['closingWGT'];			
		
		
		#--------[ FTCH PO DESIGN LIST
		$QURYpoDSGNlist	= "SELECT DC.design_cat_name, DSC.design_subcat_name, D.design_no, POD.qty AS poQTY, POD.closing_qty, POD.closing_wgt, D.design_id, POD.po_det_id, D.gross_wgt, PO.ornament_stock_status FROM `po` AS PO, `po_det` AS POD, designs AS D, design_cat AS DC, design_subcat AS DSC WHERE POD.design_id = D.design_id AND POD.design_cat_id = DC.design_cat_id AND POD.design_subcat_id = DSC.design_subcat_id AND POD.role_status = 1 AND POD.po_id = '$poLISTid' AND POD.po_id=PO.po_id ORDER BY D.design_no ASC";			
		$CONNpoDSGNlist	= $connection->executeQuery($QURYpoDSGNlist);
		$FTCHpoDSGNlist	= $CONNpoDSGNlist->fetchAll();
		$ornamentStckST = $FTCHpoDSGNlist[0]['ornament_stock_status'];
		
		return $this->render('gold-stock/ornament-stock-po-design-updt.html.twig', [
			'alterPONo' => $FTCHalterPONo,
			'FTCHpoNOdt' => $FTCHpoNOdt,
			'FTCHpoQTYwgt' => $FTCHpoQTYwgt,
			'poDSGNlist' => $FTCHpoDSGNlist,
			'ornamentStckST' => $ornamentStckST,
			'controller_name' => 'GoldStockController'
        ]);
    }	
}
