<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;
use Symfony\Component\Filesystem\Filesystem;
class DesignsController extends AbstractController
{
    /**
     * @Route("/design-category{desCatID}", name="design-category")
     */
    public function designCATEGORYact(Request $request, $desCatID) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		########-[ LIST - DETAILS
		$QURYlistDet= "SELECT * FROM `design_cat` ORDER BY `design_cat_id` DESC";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();
		
		if($desCatID != 0)
		{
			########-[ GET UPDATE - DETAILS
			$QURYupdtDet	= "SELECT * FROM `design_cat` WHERE `design_cat_id`=".$desCatID;
			$CONNupdtDet	= $connection->executeQuery($QURYupdtDet);
			$FTCHupdtDet	= $CONNupdtDet->fetchAll();
			
			$FTCHupdtDet['design_cat_name']       = $FTCHupdtDet[0]['design_cat_name'];
			$FTCHupdtDet['dashboard_designs_ext'] = $FTCHupdtDet[0]['dashboard_designs_ext'];
		}
		else
		{
			$FTCHupdtDet = "";
		}
		
		if($request->getMethod() == 'POST')
		{
			$design_cat_name	= $request->get('design_cat_name');
			$sessionId  		= $session->get('empId');
			
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime = date("Y-m-d H:i:s");
			
			if($desCatID == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO `design_cat`(`design_cat_name`,`dashboard_designs_ext`, `post_by`, `post_dt`) VALUES ('$design_cat_name','$prod_extn1','$sessionId','$nwDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
				$LASTinID = $connection->lastInsertId();
				
				#--------[IMAGE UPLOAD
				if($_FILES['dashboard_cat_photo']['name'] !=""){
					$design_img1 	= $_FILES['dashboard_cat_photo']['name']; 
					$getprdExtn1= $_FILES['dashboard_cat_photo']['type'];
					$getprdExtn2= explode("/", $getprdExtn1);
					$prod_extn1	= $getprdExtn2[1];
					$prod_name	= $design_no;
					$file_name1	= $LASTinID.".".$prod_extn1;
					move_uploaded_file($_FILES["dashboard_cat_photo"]["tmp_name"], "dashboard_designs/" . $file_name1);
				}else{
					$design_img1 = "";
				}	
				
				########-[ UPDATE img extn - DETAILS
				$QRinsert = "UPDATE `design_cat` SET `dashboard_designs_ext`='$prod_extn1' WHERE `design_cat_id`='$LASTinID'";
				$CNexecut = $connection->executeQuery($QRinsert);
				$LASTinID = $connection->lastInsertId();				
							
			}
			else
			{
				#--------[UPDATE DESIGN
				if($_FILES['dashboard_cat_photo']['name'] !=""){
					$prod_img1 	= $_FILES['dashboard_cat_photo']['name']; 
					$getprdExtn1= $_FILES['dashboard_cat_photo']['type'];
					$getprdExtn2= explode("/", $getprdExtn1);
	
					if($FTCHuptDATA[0]['dashboard_cat_photo'] != ""){
						$prod_extn1	= $FTCHuptDATA[0]['dashboard_cat_photo'];
					} else if($FTCHuptDATA[0]['dashboard_cat_photo'] == ""){
						$prod_extn1	= $getprdExtn2[1];
					}
	
					$prod_name	= $FTCHupdtDet[0]['design_cat_id'];
					$prodImgExtn= $FTCHupdtDet[0]['dashboard_designs_ext'];
					$file_name1	= $prod_name.".".$prod_extn1;
					
					if($prodImgExtn != ""){
						unlink("dashboard_designs/" . $file_name1);
					}
					
					move_uploaded_file($_FILES["dashboard_cat_photo"]["tmp_name"], "dashboard_designs/" . $file_name1);
				}else{
					$prod_extn1 = $FTCHuptDATA[0]['design_image_ext_1'];
				}
			

				########-[ UPDATE - DETAILS			
				$QRupdate 	= "UPDATE `design_cat` SET `design_cat_name`='$design_cat_name', `dashboard_designs_ext`='$prod_extn1', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE design_cat_id=".$desCatID;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}		
		
		return $this->render('designs/design-category-data.html.twig', [
			'designCATlist' => $FTCHlistDet,
			'FTCHupdtDet' => $FTCHupdtDet,
			'controller_name' => 'DesignsController'
        ]);
    }

	
	/**
     * @Route("/design-subcategory{dsCatID}", name="design-subcategory")
     */
    public function designSUBCATEGORYact(Request $request, $dsCatID) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		########-[ LIST DESIGN CAT - DETAILS
		$QURYdesgCAT	= "SELECT * FROM `design_cat` ORDER BY `design_cat_name` ASC";
		$CONNdesgCAT	= $connection->executeQuery($QURYdesgCAT);
		$FTCHdesgCAT	= $CONNdesgCAT->fetchAll();
		
		########-[ LIST - DETAILS
		$QURYlistDet= "SELECT SC.`design_subcat_id`, C.design_cat_name, SC.design_subcat_name FROM `design_subcat` AS SC, `design_cat` AS C WHERE SC.design_cat_id=C.design_cat_id ORDER BY SC.`design_subcat_name` ASC";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();
		
		if($dsCatID != 0)
		{
			########-[ GET UPDATE - DETAILS
			$QURYupdtDet	= "SELECT * FROM `design_subcat` WHERE `design_subcat_id`=".$dsCatID;
			$CONNupdtDet	= $connection->executeQuery($QURYupdtDet);
			$FTCHupdtDet	= $CONNupdtDet->fetchAll();
			
			$FTCHupdtDet['design_cat_id'] 		= $FTCHupdtDet[0]['design_cat_id'];
			$FTCHupdtDet['design_subcat_name'] 	= $FTCHupdtDet[0]['design_subcat_name'];
		}
		else
		{
			$FTCHupdtDet = "";
		}
		
		if($request->getMethod() == 'POST')
		{
			$design_category	= $request->get('design_category');
			$design_subcategory	= $request->get('design_subcategory');
			$sessionId  		= $session->get('empId');
			
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime = date("Y-m-d H:i:s");
			
			if($dsCatID == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO `design_subcat`(`design_cat_id`, `design_subcat_name`, `post_by`, `post_dt`) VALUES ('$design_category','$design_subcategory','$sessionId','$nwDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
			}
			else
			{
				########-[ UPDATE - DETAILS			
				$QRupdate 	= "UPDATE `design_subcat` SET `design_cat_id`='$design_category', `design_subcat_name`='$design_subcategory', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE design_subcat_id=".$dsCatID;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}
		
		return $this->render('designs/design-subcategory-data.html.twig', [
			'desgCAT' => $FTCHdesgCAT,
			'designSUBCATlist' => $FTCHlistDet,
			'FTCHupdtDet' => $FTCHupdtDet,
			'controller_name' => 'DesignsController'
        ]);
    }
	
	
	/**
     * @Route("/design-super-subcategory{dSUPsCatID}", name="design-super-subcategory")
     */
    public function designSUPERSUBCATEGORYact(Request $request, $dSUPsCatID) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		########-[ LIST DESIGN CAT - DETAILS
		$QURYdesgCAT	= "SELECT * FROM `design_cat` ORDER BY `design_cat_name` ASC";
		$CONNdesgCAT	= $connection->executeQuery($QURYdesgCAT);
		$FTCHdesgCAT	= $CONNdesgCAT->fetchAll();
		
		########-[ LIST DESIGN SUB-CAT - DETAILS
//		$QURYdesgSCAT	= "SELECT * FROM `design_subcat` ORDER BY `design_subcat_name` ASC";
//		$CONNdesgSCAT	= $connection->executeQuery($QURYdesgSCAT);
//		$FTCHdesgSCAT	= $CONNdesgSCAT->fetchAll();		
		
		########-[ LIST - DETAILS
		$QURYlistDet= "SELECT SSC.`design_super_subcat_id`, C.design_cat_name, SC.design_subcat_name, SSC.design_super_subcat_name FROM `design_subcat` AS SC, `design_cat` AS C, `design_super_subcat` AS SSC WHERE SSC.design_cat_id=C.design_cat_id AND SSC.design_subcat_id=SC.design_subcat_id ORDER BY SC.`design_subcat_name` ASC";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();
		
		if($dSUPsCatID != 0)
		{
			########-[ GET UPDATE - DETAILS
			$QURYupdtDet	= "SELECT * FROM `design_super_subcat` WHERE `design_super_subcat_id`=".$dSUPsCatID;
			$CONNupdtDet	= $connection->executeQuery($QURYupdtDet);
			$FTCHupdtDet	= $CONNupdtDet->fetchAll();
			
			$FTCHupdtDet['design_cat_id'] 			= $FTCHupdtDet[0]['design_cat_id'];
			$FTCHupdtDet['design_subcat_id']		= $FTCHupdtDet[0]['design_subcat_id'];
			$FTCHupdtDet['design_super_subcat_name']= $FTCHupdtDet[0]['design_super_subcat_name'];
			
			########-[ LIST DESIGN SUB-CAT - DETAILS
			$QURYdesgSCAT	= "SELECT * FROM `design_subcat` WHERE `design_cat_id`='".$FTCHupdtDet['design_cat_id']."' ORDER BY `design_subcat_name` ASC";
			$CONNdesgSCAT	= $connection->executeQuery($QURYdesgSCAT);
			$FTCHdesgSCAT	= $CONNdesgSCAT->fetchAll();
		}
		else
		{
			$FTCHdesgSCAT= "";
			$FTCHupdtDet = "";
		}
		
		if($request->getMethod() == 'POST')
		{
			$design_category	= $request->get('design_category');
			$design_subcategory	= $request->get('design_subcategory');
			$design_super_subcat= $request->get('design_super_subcat');
			$sessionId  		= $session->get('empId');
			
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime = date("Y-m-d H:i:s");
			
			if($dSUPsCatID == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO `design_super_subcat`(`design_cat_id`, `design_subcat_id`, `design_super_subcat_name`, `post_by`, `post_dt`) VALUES ('$design_category','$design_subcategory','$design_super_subcat','$sessionId','$nwDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
			}
			else
			{
				########-[ UPDATE - DETAILS		
				$QRupdate 	= "UPDATE `design_super_subcat` SET `design_cat_id`='$design_category', `design_subcat_id`='$design_subcategory', `design_super_subcat_name`='$design_super_subcat', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE design_super_subcat_id=".$dSUPsCatID;
				$CNexecut 	= $connection->executeQuery($QRupdate);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}
		
		return $this->render('designs/design-super-subcategory-data.html.twig', [
			'desgCAT' => $FTCHdesgCAT,
			'desgSCAT' => $FTCHdesgSCAT,
			'designSUPSUBCATlist' => $FTCHlistDet,
			'FTCHupdtDet' => $FTCHupdtDet,
			'controller_name' => 'DesignsController'
        ]);
    }


	/**
     * @Route("/design-list", name="design-list")
     */
    public function designLISTact(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$record_per_page = 100;
		
		$page = '';
		
		if(isset($_GET["page"])){
			$page = $_GET["page"];
		}else{
		 	$page = 1;
		}

		$start_from = ($page-1) * $record_per_page;		
				
		
		if($request->getMethod() == 'POST')
		{
			$search_by		 = $request->get('search_by');	
			$searchWHEREcond = "AND CONCAT_WS(' ',CONCAT(`design_short_form`,'',`design_no`)) LIKE '%".$search_by."'";
			$limitCOND		 = "";
			$searchTOKEN	 = "yes";
		}	
		else
		{
			$search_by		 = "";
			$searchWHEREcond = "";
			$limitCOND		 = "LIMIT $start_from, $record_per_page";			
			$searchTOKEN	 = "no";			
		}	
		
		########-[ GET DESIGN LIST with PAGINATION
		$QURYlist	= "SELECT D.`design_id`, D.`design_image_ext_1`, CONCAT(D.`design_short_form`,'',D.`design_no`) AS design_no, C.design_cat_name, SC.design_subcat_name, D.no_of_st, D.st_wgt, D.gross_wgt FROM `designs` AS D, design_cat AS C, design_subcat AS SC WHERE D.design_cat_id=C.design_cat_id AND D.design_subcat_id=SC.design_subcat_id ".$searchWHEREcond." ORDER BY D.`design_id` DESC ".$limitCOND;
		$CONNlist	= $connection->executeQuery($QURYlist);
		$FTCHlist	= $CONNlist->fetchAll();
		
		
		########-[ GET No. of PAGE's
		$QURYpages	= "SELECT D.`design_id`, D.`design_image_ext_1`, CONCAT(D.`design_short_form`,'',D.`design_no`) AS design_no, C.design_cat_name, SC.design_subcat_name, D.no_of_st, D.st_wgt, D.gross_wgt FROM `designs` AS D, design_cat AS C, design_subcat AS SC WHERE D.design_cat_id=C.design_cat_id AND D.design_subcat_id=SC.design_subcat_id ".$searchWHEREcond." ORDER BY D.`design_id` DESC";
		$CONNpages	= $connection->executeQuery($QURYpages);
		$FTCHpages	= count($CONNpages->fetchAll());
		
		$total_pages = ceil($FTCHpages/$record_per_page);
		$start_loop  = $page;
		$difference  = $total_pages - $page;
		
		if($difference <= 10){
		 	$start_loop = $total_pages - 10;
		}
			$end_loop = $start_loop + (9);					
		
		return $this->render('designs/design-list.html.twig', [
			'DESIGNlist' => $FTCHlist,
			'page' => $page,
			'record_per_page' => $record_per_page,
			'start_from' => $start_from,
			'start_loop' => $start_loop,
			'end_loop' => $end_loop,
			'total_pages' => $total_pages,
			'searchTOKEN' => $searchTOKEN,
			'searchBy' => $search_by,
			'searchQRYrslt' => $FTCHpages,
			'controller_name' => 'DesignsController'
        ]);
    }


	/**
     * @Route("/design-add", name="design-add")
     */
    public function designADDact(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		$sessionId  = $session->get('empId');
		
		########-[ LIST DESIGN CAT - DETAILS
		$QURYdesgCAT	= "SELECT * FROM `design_cat` ORDER BY `design_cat_name` ASC";
		$CONNdesgCAT	= $connection->executeQuery($QURYdesgCAT);
		$FTCHdesgCAT	= $CONNdesgCAT->fetchAll();
		
		########-[ LIST - STONE DETAILS
		$QURYlistST = "SELECT * FROM stones WHERE role_status=1 ORDER BY stone_shape ASC";
		$CONNlistST = $connection->executeQuery($QURYlistST);
		$FTCHlistST = $CONNlistST->fetchAll();
		
		########-[ QUICK ADD - FETCHING LAST ADDED DATA's
		$QURYqckADD = "SELECT `design_id`, `design_cat_id`, `design_gen_cat_id`, `design_short_form`, `design_no`+1 AS designNo, `design_date`, `design_subcat_id`, `no_of_St` FROM `designs` WHERE `design_id`=(select MAX(`design_id`) from `designs` WHERE `post_by`='$sessionId')";
		$CONNqckADD = $connection->executeQuery($QURYqckADD);
		$FTCHqckADD = $CONNqckADD->fetchAll();
		
		$design_id_img_name				 = $FTCHqckADD[0]['design_id'] + 1;
		$FTCHqckADD['design_cat_id'] 	 = $FTCHqckADD[0]['design_cat_id'];
		$FTCHqckADD['design_gen_cat_id'] = $FTCHqckADD[0]['design_gen_cat_id'];
		$FTCHqckADD['design_short_form'] = $FTCHqckADD[0]['design_short_form'];
		$FTCHqckADD['no_of_St'] 		 = $FTCHqckADD[0]['no_of_St'];
		
		if($FTCHqckADD[0]['designNo'] != ""){
			$designNo				 = $FTCHqckADD[0]['designNo'];
//			$FTCHqckADD['design_no'] = sprintf('%04d', $designNo);
			$FTCHqckADD['design_no'] = $designNo;
		}else{
			$FTCHqckADD['design_no'] = "";
		}
		
		$FTCHqckADD['design_date'] 		 = $FTCHqckADD[0]['design_date'];
		$FTCHqckADD['design_subcat_id']  = $FTCHqckADD[0]['design_subcat_id'];

		########-[ LIST DESIGN SHORTFORM - DETAILS
		$QURYshrtFORM	= "SELECT `design_gen_cat_id`, CONCAT(`short_form`, ' - ',`expansion`) AS shortForm FROM `design_gen_cat` WHERE `design_cat_id`='".$FTCHqckADD[0]['design_cat_id']."' ORDER BY `short_form` ASC";
		$CONNshrtFORM	= $connection->executeQuery($QURYshrtFORM);
		$FTCHshrtFORM	= $CONNshrtFORM->fetchAll();	
				
		########-[ LIST SUBDESIGN CAT - DETAILS
		$QURYdesgSCAT	= "SELECT DISTINCT DSC.`design_subcat_id`, DSC.`design_subcat_name` FROM `design_gen_cat_det` AS DGCD, design_subcat AS DSC WHERE DGCD.`design_gen_cat_id`='".$FTCHqckADD[0]['design_gen_cat_id']."' AND DGCD.`design_subcat_id`=DSC.`design_subcat_id` ORDER BY DSC.`design_subcat_name` ASC";
		$CONNdesgSCAT	= $connection->executeQuery($QURYdesgSCAT);
		$FTCHdesgSCAT	= $CONNdesgSCAT->fetchAll();
		
		if($request->getMethod() == 'POST')
		{
			$desg_cat		 = $request->get('desg_cat');
			$short_name_exp	 = $request->get('short_name_exp');
			$designShortForm = $request->get('design_short_form');
			$design_type 	 = $request->get('design_type');
			$design_no		 = $request->get('design_no');
			
			$design_entry_dt1= $request->get('design_entry_dt');
			$design_entry_dt2= explode("-",$design_entry_dt1);
			$design_entry_dt = $design_entry_dt2[2]."-".$design_entry_dt2[1]."-".$design_entry_dt2[0];
			
			$design_img1	 = $request->get('design_img1');
			$desg_scat		 = $request->get('desg_scat');
			
			
			$stone_flagg	 = $request->get('stone_flagg');
			$stone_weight	 = $request->get('stone_weight');
			$stone_wt_flagg	 = $request->get('stone_wt_flagg');			

			if($design_type == "Stone" || $design_type == 0){
				$no_of_stone	 = $request->get('no_of_stone');
				$net_weight		 = $request->get('st_net_weight');
				$net_wt_flagg	 = $request->get('st_net_wt_flagg');			
				$gross_wgt		 = $request->get('st_gross_weight');
			}else if($design_type == "Plain" || $design_type == ""){
				$no_of_stone	 = "";
				$net_weight		 = $request->get('pl_net_weight');
				$net_wt_flagg	 = $request->get('pl_net_wt_flagg');			
				$gross_wgt		 = $request->get('pl_gross_weight');
			}
			
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime 	 = date("Y-m-d H:i:s");
			
			#--------[PRODUCT IMAGE UPLOAD
			if($_FILES['design_img1']['name'] !=""){
				$design_img1 	= $_FILES['design_img1']['name']; 
				$getprdExtn1= $_FILES['design_img1']['type'];
				$getprdExtn2= explode("/", $getprdExtn1);
				$prod_extn1	= $getprdExtn2[1];
				//$prod_name	= $design_id_img_name;
				$prod_name	= $designShortForm.$design_no;
				$file_name1	= $prod_name.".".$prod_extn1;
				move_uploaded_file($_FILES["design_img1"]["tmp_name"], "designs/" . $file_name1);
			}else{
				$design_img1 = "";
			}				
		
			########-[ INSERT - DESIGN BASIC
			$QRinsert = "INSERT INTO `designs`(`design_cat_id`, `design_gen_cat_id`, `design_short_form`, `design_no`, `design_date`, `design_image_ext_1`, `design_subcat_id`, `no_of_st`, `stone_flagg`, `st_wgt`, `stone_wt_flagg`, `net_weight`, `net_wt_flagg`, `gross_wgt`, `post_by`, `post_dt`) VALUES ('$desg_cat', '$short_name_exp', '$designShortForm', '$design_no', '$design_entry_dt', '$prod_extn1', '$desg_scat', '$no_of_stone', '$stone_flagg', '$stone_weight', '$stone_wt_flagg', '$net_weight', '$net_wt_flagg', '$gross_wgt', '$sessionId', '$nwDateTime')";
			$CNexecut = $connection->executeQuery($QRinsert);
			$designId = $connection->lastInsertId();
			
			if($design_type == "Stone" || $design_type >= 0)
			{
				########-[ INSERT - DESIGN - STONE DETAILS
				$piece_addmore	 = $request->get('piece_addmore');
				$pieceAddmretCONT= count($piece_addmore);
				
				for($i=0; $i<=$pieceAddmretCONT-1; $i++)
				{
					$piece_addmore  	= $request->get('piece_addmore')[$i];
					$die_no_addmore 	= $request->get('die_no_addmore')[$i];
					$stone_shape_size   = $request->get('stone_shape_size')[$i];
					$stone_shape_size	= explode(",",$stone_shape_size);
					$stone_shape_size	= $stone_shape_size[0];
					$stone_qty  		= $request->get('stone_qty')[$i];
					$sub_tot_stone_qty	= $request->get('sub_tot_stone_qty')[$i];
	
					########-[ INSERT - DESIGN GENERATE CATEGORY DETAILS
					$QRinstSTONEdt = "INSERT INTO `design_det`(`design_cat_id`, `design_subcat_id`, `design_gen_cat_id`, `design_id`, `design_die_no`, `piece`, `no_of_st`, `stones_id`, `stones_sub_tot`, `post_by`, `post_dt`) VALUES ('$desg_cat', '$desg_scat', '$short_name_exp', '$designId', '$die_no_addmore','$piece_addmore', '$stone_qty', '$stone_shape_size', '$sub_tot_stone_qty', '$sessionId', '$nwDateTime')";
					$CNinstSTONEdt = $connection->executeQuery($QRinstSTONEdt);
				}
			}	

			return $this->redirectToRoute('design-list');
		}
		
		return $this->render('designs/design-add.html.twig', [
			'desgCAT' => $FTCHdesgCAT,
			'desgSCAT' => $FTCHdesgSCAT,
			'FTCHlistST' => $FTCHlistST,
			'shrtFORM' => $FTCHshrtFORM,
			'qckADD' => $FTCHqckADD,
			'controller_name' => 'DesignsController'
        ]);
    }
	
	
    /**
     * @Route("/design-upt{design_upt_id}", name="design-upt")
     */
	public function designUPTact(Request $request, $design_upt_id)
    {	
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 	
		
		########-[ LIST DESIGN CAT - DETAILS
		$QURYdesgCAT	= "SELECT * FROM `design_cat` ORDER BY `design_cat_name` ASC";
		$CONNdesgCAT	= $connection->executeQuery($QURYdesgCAT);
		$FTCHdesgCAT	= $CONNdesgCAT->fetchAll();
		
		########-[ LIST SUBDESIGN CAT - DETAILS
		$QURYdesgSCAT	= "SELECT * FROM `design_subcat` ORDER BY `design_subcat_name` ASC";
		$CONNdesgSCAT	= $connection->executeQuery($QURYdesgSCAT);
		$FTCHdesgSCAT	= $CONNdesgSCAT->fetchAll();
		
		########-[ LIST - STONE DETAILS
		$QURYlistST = "SELECT * FROM stones WHERE role_status=1 ORDER BY stone_shape ASC";
		$CONNlistST = $connection->executeQuery($QURYlistST);
		$FTCHlistST = $CONNlistST->fetchAll();		
		
		########-[ GET UPDATE DATA
		$QURYuptDATA	= "SELECT D.design_id, D.design_cat_id, DGC.`design_gen_cat_id`, DGC.`short_form`, CONCAT( DGC.`short_form`, ' - ', DGC.`expansion` ) AS shortForm, D.design_no, D.design_date, D.design_image_ext_1, D.design_subcat_id, DSC.design_subcat_name, D.st_wgt, D.no_of_st, D.net_weight, D.net_wt_flagg, D.gross_wgt FROM `designs` AS D, `design_gen_cat` AS DGC, `design_subcat` AS DSC WHERE D.design_id = '".$design_upt_id."' AND D.design_gen_cat_id=DGC.`design_gen_cat_id` AND D.design_subcat_id = DSC.design_subcat_id";
		$CONNuptDATA	= $connection->executeQuery($QURYuptDATA);
		$FTCHuptDATA	= $CONNuptDATA->fetchAll();
		
		########-[ LIST STONE - DETAILS
		$QURYstoneDET	= "SELECT `design_id`, `design_det_id`, `piece`, `design_die_no`, `stones_id`, `no_of_st`, `stones_sub_tot` FROM `design_det` WHERE `design_id`= '".$design_upt_id."' ORDER BY `design_det_id` ASC";
		$CONNstoneDET	= $connection->executeQuery($QURYstoneDET);
		$FTCHstoneDET	= $CONNstoneDET->fetchAll();			
		$CONTstoneDET	= count($FTCHstoneDET);
		
		$FTCHuptDATA['design_id'] 	 		= $FTCHuptDATA[0]['design_id'];
		$FTCHuptDATA['design_cat_id'] 	 	= $FTCHuptDATA[0]['design_cat_id'];
		$FTCHuptDATA['design_gen_cat_id'] 	= $FTCHuptDATA[0]['design_gen_cat_id'];
		$FTCHuptDATA['shortForm'] 		 	= $FTCHuptDATA[0]['shortForm'];
		$FTCHuptDATA['short_form'] 		 	= $FTCHuptDATA[0]['short_form'];
		$FTCHuptDATA['design_no'] 		 	= $FTCHuptDATA[0]['design_no'];
		$FTCHuptDATA['dsgnIMGname']		 	= $FTCHuptDATA[0]['short_form'].$FTCHuptDATA[0]['design_no'];
		$FTCHuptDATA['design_date'] 	 	= $FTCHuptDATA[0]['design_date'];
		$FTCHuptDATA['design_subcat_id']  	= $FTCHuptDATA[0]['design_subcat_id'];
		$FTCHuptDATA['design_subcat_name']	= $FTCHuptDATA[0]['design_subcat_name'];
		$FTCHuptDATA['design_image_ext_1']	= $FTCHuptDATA[0]['design_image_ext_1'];
		$FTCHuptDATA['no_of_st']			= $FTCHuptDATA[0]['no_of_st'];
		$FTCHuptDATA['st_wgt'	]			= $FTCHuptDATA[0]['st_wgt'];
		$FTCHuptDATA['net_weight']			= $FTCHuptDATA[0]['net_weight'];
		$FTCHuptDATA['net_wt_flagg']		= $FTCHuptDATA[0]['net_wt_flagg'];
		$FTCHuptDATA['gross_wgt']			= $FTCHuptDATA[0]['gross_wgt'];
		
		########-[ FETCH CURRENT VALUE - No.of.Stones, Stone Wgt
		$QURYstNoWg	= "SELECT SUM(`no_of_st`) AS totSTno, SUM(`no_of_st` * `stone_weight`) AS totSTwt FROM `design_det` AS DD, `stones` AS S WHERE DD.`design_id`='".$design_upt_id."' AND DD.stones_id=S.stones_id";
		$CONNstNoWg	= $connection->executeQuery($QURYstNoWg);
		$FTCHstNoWg	= $CONNstNoWg->fetchAll();		
		
		$FTCHstNoWg['totSTno'] = $FTCHstNoWg[0]['totSTno'];
		$FTCHstNoWg['totSTwt'] = $FTCHstNoWg[0]['totSTwt'];
		
		########-[ LIST DESIGN SHORTFORM - DETAILS
		$QURYshrtFORM	= "SELECT `design_gen_cat_id`, CONCAT(`short_form`, ' - ',`expansion`) AS shortForm FROM `design_gen_cat` WHERE `design_cat_id`='".$FTCHuptDATA[0]['design_cat_id']."' ORDER BY `short_form` ASC";
		$CONNshrtFORM	= $connection->executeQuery($QURYshrtFORM);
		$FTCHshrtFORM	= $CONNshrtFORM->fetchAll();	
		
		########-[ LIST SUBDESIGN CAT - DETAILS
		$QURYdesgSCAT	= "SELECT DISTINCT DSC.`design_subcat_id`, DSC.`design_subcat_name` FROM `design_gen_cat_det` AS DGCD, design_subcat AS DSC WHERE DGCD.`design_gen_cat_id`='".$FTCHuptDATA[0]['design_gen_cat_id']."' AND DGCD.`design_subcat_id`=DSC.`design_subcat_id` ORDER BY DSC.`design_subcat_name` ASC";
		$CONNdesgSCAT	= $connection->executeQuery($QURYdesgSCAT);
		$FTCHdesgSCAT	= $CONNdesgSCAT->fetchAll();				
				
		if($request->getMethod() == 'POST')
		{
			$desg_cat	  = $request->get('desg_cat');
			$shortNameExp = $request->get('short_name_exp');
			$desgnShrtFrm = $request->get('design_short_form');
			$desg_scat	  = $request->get('desg_scat');
			$design_no	  = $request->get('design_no');
			$dsgn_ent_dt1 = $request->get('design_entry_dt');
			$dsgn_ent_dt2 = explode("-",$dsgn_ent_dt1);
			$dsgn_ent_dt  = $dsgn_ent_dt2[2]."-".$dsgn_ent_dt2[1]."-".$dsgn_ent_dt2[0];
			$no_of_st	  = $request->get('no_of_stone');
			$st_wgt		  = $request->get('stone_weight');
			$net_weight	  = $request->get('net_weight');
			$net_wt_flagg = $request->get('net_wt_flagg');			
			$gross_wgt	  = $request->get('gross_weight');
			
			$sessionId    = $session->get('empId');
			
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime   = date("Y-m-d H:i:s");
			
			#--------[UPDATE DESIGN
			if($_FILES['design_img1']['name'] !=""){
				$prod_img1 	= $_FILES['design_img1']['name']; 
				$getprdExtn1= $_FILES['design_img1']['type'];
				$getprdExtn2= explode("/", $getprdExtn1);

				if($FTCHuptDATA[0]['design_image_ext_1'] != ""){
					$prod_extn1	= $FTCHuptDATA[0]['design_image_ext_1'];
				} else if($FTCHuptDATA[0]['design_image_ext_1'] == ""){
					$prod_extn1	= $getprdExtn2[1];
				}

				//$prod_name	= $FTCHuptDATA[0]['design_id'];
				$prod_name	= $desgnShrtFrm.$design_no;
				$prodImgExtn= $FTCHuptDATA[0]['design_image_ext_1'];
				$file_name1	= $prod_name.".".$prod_extn1;
				
				if($prodImgExtn != ""){
					unlink("designs/" . $file_name1);
				}
				
				move_uploaded_file($_FILES["design_img1"]["tmp_name"], "designs/" . $file_name1);
			}else{
				$prod_extn1 = $FTCHuptDATA[0]['design_image_ext_1'];
			}
			
			#--------[UPDATE DESIGN
			//$quryDESGNupdt	= "UPDATE `designs` SET `design_date`='$dsgn_ent_dt', `design_image_ext_1`='$prod_extn1' WHERE `design_id`='$design_upt_id'";
			$quryDESGNupdt	= "UPDATE `designs` SET `design_gen_cat_id`='$shortNameExp', `design_date`='$dsgn_ent_dt', `design_image_ext_1`='$prod_extn1', `design_subcat_id`='$desg_scat', `update_by`='$sessionId', `update_dt`='$nwDateTime'  WHERE `design_id`='$design_upt_id'";
			$stmtDESGNupdt  = $connection->executeQuery($quryDESGNupdt);
						
			#--------[UPDATE STONE DETAILS - ALREADY ADDED
			$piece	 = $request->get('piece_addmore');
			$pieceCT = count($piece);
			
			for($i=0; $i<=$pieceCT-1; $i++)
			{
				$DSGNdetID 		= $request->get('DSGNdetID')[$i];
				$piece  		= $request->get('piece_addmore')[$i];
				$die_no 		= $request->get('die_no_addmore')[$i];
				$stone_shape   	= $request->get('stone_shape_size')[$i];
				$stone_shape	= explode(",",$stone_shape);
				$stone_shape	= $stone_shape[0];
				$stoneQty  		= $request->get('stone_qty')[$i];
				$subTotStoneQty	= $request->get('sub_tot_stone_qty')[$i];

				$QRupdtSTDT = "UPDATE `design_det` SET `piece`='$piece', `design_die_no`='$die_no', `stones_id`='$stone_shape', `no_of_st`='$stoneQty', `stones_sub_tot`='$subTotStoneQty', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `design_det_id`='$DSGNdetID'";
				$CNupdtSTDT = $connection->executeQuery($QRupdtSTDT);
			}				
			
			#--------[UPDATE STONE DETAILS - ADD NEW STONES		
			if($CONTstoneDET < $pieceCT)
			{
				for($i=$CONTstoneDET; $i<$pieceCT; $i++)
				{
					$piece_addmore		= $request->get('piece_addmore')[$i];
					$die_no_addmore		= $request->get('die_no_addmore')[$i];
					$stone_shape_size	= $request->get('stone_shape_size')[$i];
					$stone_shape_size	= explode(",",$stone_shape_size);
					$stone_shape_size	= $stone_shape_size[0];
					$stone_qty 			= $request->get('stone_qty')[$i];
					$sub_tot_stone_qty	= $request->get('sub_tot_stone_qty')[$i];
					
					$QRinstSTONEdt = "INSERT INTO `design_det`(`design_cat_id`, `design_subcat_id`, `design_gen_cat_id`, `design_id`, `design_die_no`, `piece`, `no_of_st`, `stones_id`, `stones_sub_tot`, `post_by`, `post_dt`) VALUES ('".$FTCHuptDATA[0]['design_cat_id']."', '".$FTCHuptDATA[0]['design_subcat_id']."', '".$FTCHuptDATA[0]['design_gen_cat_id']."', '$design_upt_id', '$die_no_addmore','$piece_addmore', '$stone_qty', '$stone_shape_size', '$sub_tot_stone_qty', '$sessionId', '$nwDateTime')";
					$CNinstSTONEdt = $connection->executeQuery($QRinstSTONEdt);
				}			
			}
		
			########-[ UPDATE (all) - DETAILS
//			$QRuptDATA = "UPDATE `designs` SET `design_cat_id`='$desg_cat',`design_subcat_id`='$desg_scat',`design_no`='$design_no',`no_of_st`='$no_of_st',`st_wgt`='$st_wgt',`net_weight`='$net_weight',`net_wt_flagg`='$net_wt_flagg'`gross_wgt`='$gross_wgt',`update_by`='$sessionId',`update_dt`='$nwDateTime' WHERE `design_id`=".$design_upt_id;

			########-[ UPDATE (limited) - DETAILS
			$QRuptDATA = "UPDATE `designs` SET `no_of_st`='$no_of_st', `st_wgt`='$st_wgt', `net_weight`='$net_weight', `net_wt_flagg`='$net_wt_flagg', `gross_wgt`='$gross_wgt', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `design_id`=".$design_upt_id;
			$CNuptDATA = $connection->executeQuery($QRuptDATA);
			
			return $this->redirectToRoute('design-list');
		}
		//die();
		return $this->render('designs/design-upt.html.twig', [
			'desgCAT' => $FTCHdesgCAT,
			'desgSCAT' => $FTCHdesgSCAT,
			'designUPDTdata' => $FTCHuptDATA,
			'FTCHlistST' => $FTCHlistST,
			'stoneDET' => $FTCHstoneDET,
			'stoneCONT' => $CONTstoneDET,
			'stNoWg' => $FTCHstNoWg,
			'shrtFORM' => $FTCHshrtFORM,
			'desgSCAT' => $FTCHdesgSCAT,
			'controller_name' => 'PartiesController'
        ]);
	}		


    /**
     * @Route("/design-dlt{design_dlt_id}", name="design-dlt")
     */
    public function designDLTact(Request $request, $design_dlt_id) 
    {	
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 	
		
		########-[ DELETE - DETAILS
		$QRdlt = "DELETE FROM `designs` WHERE `design_id`=".$design_dlt_id;
		$CNdlt = $connection->executeQuery($QRdlt);
		
		return $this->redirectToRoute('design-list');
	}
	
	
	/**
     * @Route("/design-generate-category-list", name="design-generate-category-list")
     */
    public function designGENcatlistACTION(Request $request) 
    {	
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 	
		
		########-[ LIST GENERATED CATEGORY - DETAILS
		$QURYdesgGENcat	= "SELECT GC.design_gen_cat_id, CAT.design_cat_name, GEN.gender_name, IF( GC.`design_type_id` = 1, 'Plain', 'Stone' ) AS desgnType, GC.`short_form`, GC.expansion FROM `design_gen_cat` AS GC, genders AS GEN, design_cat AS CAT WHERE GC.genders_id=GEN.genders_id AND GC.design_cat_id=CAT.design_cat_id";
		$CONNdesgGENcat	= $connection->executeQuery($QURYdesgGENcat);
		$FTCHdesgGENcat	= $CONNdesgGENcat->fetchAll();		
			
		return $this->render('designs/design-generate-category-list.html.twig', [
			'desgGENcat' => $FTCHdesgGENcat,
			'controller_name' => 'DesignsController'
        ]);
	}
	
	
	/**
     * @Route("/design-generate-category-add", name="design-generate-category-add")
     */
    public function designGENcataddACTION(Request $request) 
    {	
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 	
		
		########-[ LIST DESIGN CAT - DETAILS
		$QURYdesgCAT	= "SELECT * FROM `design_cat` WHERE role_status=1 ORDER BY `design_cat_name` ASC";
		$CONNdesgCAT	= $connection->executeQuery($QURYdesgCAT);
		$FTCHdesgCAT	= $CONNdesgCAT->fetchAll();
		
		########-[ LIST GENDER - DETAILS
		$QURYgender		= "SELECT * FROM `genders` WHERE role_status=1 ORDER BY `gender_name` ASC";
		$CONNgender		= $connection->executeQuery($QURYgender);
		$FTCHgender		= $CONNgender->fetchAll();
		
		if($request->getMethod() == 'POST')
		{
			$desg_cat		= $request->get('desg_cat');
			$gender_id		= $request->get('gender_id');
			$prod_type		= $request->get('prod_type');
			$cat_shortform	= $request->get('cat_shortform');
			$cat_expansion	= $request->get('cat_expansion');
			
			$desg_scat		= $request->get('desg_scat');
			$desg_scatCONT	= count($desg_scat);
			
			$sessionId  	= $session->get('empId');
			
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime = date("Y-m-d H:i:s");
			
			########-[ INSERT - DESIGN GENERATE CATEGORY
			$QRinstGENCAT 		= "INSERT INTO `design_gen_cat`(`design_cat_id`, `genders_id`, `design_type_id`, `short_form`, `expansion`, `post_by`, `post_dt`) VALUES ('$desg_cat','$gender_id','$prod_type','$cat_shortform','$cat_expansion','$sessionId','$nwDateTime')";
			$CNinstGENCAT 		= $connection->executeQuery($QRinstGENCAT);
			$design_gen_cat_id 	= $connection->lastInsertId();
			
			for($i=0; $i<=$desg_scatCONT-1; $i++)
			{
				$desgScatID = $desg_scat[$i];

				########-[ INSERT - DESIGN GENERATE CATEGORY DETAILS
				$QRinstGENCATdet = "INSERT INTO `design_gen_cat_det`(`design_gen_cat_id`, `design_subcat_id`, `post_by`, `post_dt`) VALUES ('$design_gen_cat_id','$desgScatID','$sessionId','$nwDateTime')";
				$CNinstGENCATdet = $connection->executeQuery($QRinstGENCATdet);
			}

			return $this->redirectToRoute('design-generate-category-list');
		}		
			
		return $this->render('designs/design-generate-category-add.html.twig', [
			'desgCAT' => $FTCHdesgCAT,
			'genders' => $FTCHgender,			
			//'designUPDTdata' => $FTCHuptDATA,
			'controller_name' => 'DesignsController'
        ]);
	}
	
	
	/**
     * @Route("/design-generate-category-upt{DESGNgenCATid}", name="design-generate-category-upt")
     */
    public function designGENcatuptACTION(Request $request, $DESGNgenCATid) 
    {	
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 	
		
		########-[ LIST DESIGN CAT - DETAILS
		$QURYdesgCAT	= "SELECT * FROM `design_cat` WHERE role_status=1 ORDER BY `design_cat_name` ASC";
		$CONNdesgCAT	= $connection->executeQuery($QURYdesgCAT);
		$FTCHdesgCAT	= $CONNdesgCAT->fetchAll();
		
		########-[ LIST GENDER - DETAILS
		$QURYgender		= "SELECT * FROM `genders` WHERE role_status=1 ORDER BY `gender_name` ASC";
		$CONNgender		= $connection->executeQuery($QURYgender);
		$FTCHgender		= $CONNgender->fetchAll();

		########-[ LIST DESIGN GENERATE CAT - DETAILS
		$QURYgenCATdata	= "SELECT `design_cat_id`, `genders_id`, `design_type_id`, `short_form`, `expansion` FROM `design_gen_cat` WHERE `design_gen_cat_id`=".$DESGNgenCATid;
		$CONNgenCATdata = $connection->executeQuery($QURYgenCATdata);
		$FTCHgenCATdata	= $CONNgenCATdata->fetchAll();		
		
		$FTCHgenCATdata['design_gen_cat_id']= $FTCHgenCATdata[0]['design_gen_cat_id'];
		$FTCHgenCATdata['design_cat_id'] 	= $FTCHgenCATdata[0]['design_cat_id'];
		$FTCHgenCATdata['genders_id'] 		= $FTCHgenCATdata[0]['genders_id'];
		$FTCHgenCATdata['design_type_id'] 	= $FTCHgenCATdata[0]['design_type_id'];
		$FTCHgenCATdata['short_form'] 		= $FTCHgenCATdata[0]['short_form'];
		$FTCHgenCATdata['expansion'] 		= $FTCHgenCATdata[0]['expansion'];
		
		########-[ FETCH DESIGN SUB CAT - DETAILS
		//echo
		$QURYsubCAT	= "SELECT
							`design_subcat`.`design_subcat_id` AS subCATid,
							`design_subcat`.`design_subcat_name` AS subCATname,
							`design_gen_cat_det`.`design_subcat_id` AS genSUBcatID,
							`design_gen_cat_det`.`design_gen_cat_id` AS genCATid
						FROM
							`design_gen_cat_det`
						RIGHT JOIN `design_subcat` ON `design_gen_cat_det`.`design_subcat_id` = `design_subcat`.`design_subcat_id` AND `design_gen_cat_det`.`design_gen_cat_id` = '".$DESGNgenCATid."' AND `design_gen_cat_det`.`update_by` = 0
						WHERE
							`design_subcat`.`role_status` = 1 AND `design_subcat`.design_cat_id='".$FTCHgenCATdata[0]['design_cat_id']."'
						ORDER BY
							`design_subcat`.`design_subcat_name` ASC";
							
		$CONNsubCAT	= $connection->executeQuery($QURYsubCAT);
		$FTCHsubCAT	= $CONNsubCAT->fetchAll();
		
		if($request->getMethod() == 'POST')
		{
			$desg_cat		= $request->get('desg_cat');
			$gender_id		= $request->get('gender_id');
			$prod_type		= $request->get('prod_type');
			$cat_shortform	= $request->get('cat_shortform');
			$cat_expansion	= $request->get('cat_expansion');
			
			$desg_scat		= $request->get('desg_scat');
			$desg_scatCONT	= count($desg_scat);
			
			$sessionId  	= $session->get('empId');
			
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime = date("Y-m-d H:i:s");
			
			########-[ UPDATE NEW SUB-CAT - INSTEAD OF DELETE HERE, IT CHANGE FLAG TO MAINTAIN LOG
			$UPTnewSUBCAT	= "UPDATE `design_gen_cat_det` SET `update_by`='$sessionId',`update_dt`='$nwDateTime' WHERE `design_gen_cat_id`=".$DESGNgenCATid;
			$CONnewSUBCAT	= $connection->executeQuery($UPTnewSUBCAT);
			
			for($i=0; $i<=$desg_scatCONT-1; $i++)
			{
				$desgScatID = $desg_scat[$i];

				########-[ INSERT - DESIGN GENERATE CATEGORY DETAILS
				$QRinstGENCATdet = "INSERT INTO `design_gen_cat_det`(`design_gen_cat_id`, `design_subcat_id`, `post_by`, `post_dt`) VALUES ('".$DESGNgenCATid."','$desgScatID','$sessionId','$nwDateTime')";
				$CNinstGENCATdet = $connection->executeQuery($QRinstGENCATdet);
			}

			return $this->redirectToRoute('design-generate-category-list');
		}		
			
		return $this->render('designs/design-generate-category-upt.html.twig', [
			'desgCAT' => $FTCHdesgCAT,
			'genders' => $FTCHgender,
			'subCAT' => $FTCHsubCAT,			
			//'designUPDTdata' => $FTCHuptDATA,
			'genCATdata' => $FTCHgenCATdata,
			'controller_name' => 'DesignsController'
        ]);
	}		
	
	
   /** 
	* @Route("/loadShortSCat", name="loadShortSCat") 
	*/ 
	public function loadShortSCatACT(Request $request) 
	{ 
	    $var	= $request->get('catID');
	 
		$connection   = $this->getDoctrine()->getManager()->getConnection(); 

		########-[ FETCH - SHORT FORM
		$QurySHORTform	= "SELECT `design_gen_cat_id`, CONCAT(`short_form`, ' - ', `expansion`) AS shortFORM FROM `design_gen_cat` WHERE `design_cat_id`='".$var."' ORDER BY `short_form` ASC";
		$stmtSHORTform	= $connection->executeQuery($QurySHORTform);
		$listSHORTform  = $stmtSHORTform->fetchAll();

		$rslt = $listSHORTform;
		return  new JsonResponse($rslt);
	} 
	
	
   /** 
	* @Route("/loadLATdesgNO", name="loadLATdesgNO") 
	*/ 
	public function loadLATdesgNOACT(Request $request) 
	{ 
		$connection   = $this->getDoctrine()->getManager()->getConnection(); 

	    $catID	= $request->get('catID');
		$genID	= $request->get('genID');
	 
		$Qury	= "SELECT MAX(`design_no`)+1 AS maxDESGINno FROM `designs` WHERE `design_cat_id`='$catID' AND `design_gen_cat_id`='$genID'";
		$stmt	= $connection->executeQuery($Qury);
		$ftch  	= $stmt->fetchAll();
		
		if($ftch[0]['maxDESGINno'] != "")
		{
			$dsgnNo	= $ftch[0]['maxDESGINno'];
//			$dsgnNo	= sprintf('%05d', $dsgnNo);
			$dsgnNo	= $dsgnNo;
		}
		else
		{
			$dsgnNo	= "1";
//			$dsgnNo	= sprintf('%05d', $dsgnNo);
		}	

		$rslt = $dsgnNo;
		return  new JsonResponse($rslt);
	}


   /** 
	* @Route("/checkDSGNNOdupli", name="checkDSGNNOdupli") 
	*/ 
	public function checkDSGNNOdupliACT(Request $request) 
	{ 
		$connection   = $this->getDoctrine()->getManager()->getConnection(); 

	    $designNO		 = $request->get('designNO');
		$designShortForm = $request->get('designShortForm');
	 
		$Qury	= "SELECT `design_id` FROM `designs` WHERE `design_shortform`='$designShortForm' AND `design_no`='$designNO'";
		$stmt	= $connection->executeQuery($Qury);
		$ftch  	= $stmt->fetchAll();
		
		if(!isset($ftch[0]['design_id']))
		{
			$DUPdesign_noCHECK = 0;
		}
		else
		{
			$DUPdesign_noCHECK = 1;
		}	

		$rslt = $DUPdesign_noCHECK;
		return  new JsonResponse($rslt);
	}		
	
	
   /** 
	* @Route("/loadsubcatShortFormWise", name="loadsubcatShortFormWise") 
	*/ 
	public function loadsubcatShortFormWise(Request $request) 
	{ 
	    $desg_cat		= $request->get('desg_cat');
		$shortFORMid	= $request->get('shortFORMid');
	 
		$connection   	= $this->getDoctrine()->getManager()->getConnection(); 
		
		$Qury	= "SELECT SC.`design_subcat_id`, SC.`design_subcat_name`, IF( GC.`design_type_id` = 1, 'Plain', 'Stone' ) AS desgnType, GC.`short_form` FROM `design_gen_cat` AS GC, `design_gen_cat_det` AS GCD, `design_subcat` AS SC WHERE GC.`design_cat_id` = '".$desg_cat."' AND GC.`design_gen_cat_id` = '".$shortFORMid."' AND GC.`design_gen_cat_id` = GCD.`design_gen_cat_id` AND GCD.`update_by` = 0 AND GCD.`design_subcat_id` = SC.`design_subcat_id` ORDER BY SC.`design_subcat_name` ASC";
		$stmt	= $connection->executeQuery($Qury);
		$list   = $stmt->fetchAll();
	  
		return  new JsonResponse($list);
	}		
	
	
	/**
     * @Route("/design-check-img-exists", name="design-check-img-exists")
     */
    public function designCheckImgExistsACT(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		

		########-[ GET DESIGN LIST
		#-[ GET ALL DESIGNS FROM TABLE
		//$QURYlist	= "SELECT D.`design_id`, D.`design_image_ext_1`, CONCAT(D.`design_short_form`,'',D.`design_no`) AS design_no, C.design_cat_name, SC.design_subcat_name, D.no_of_st, D.st_wgt, D.gross_wgt FROM `designs` AS D, design_cat AS C, design_subcat AS SC WHERE D.design_cat_id=C.design_cat_id AND D.design_subcat_id=SC.design_subcat_id ORDER BY D.`design_id` DESC";
		
		#-[ GET DESIGNS FROM A PARTICULAR GEN-CATEGORY -BETWEEN
		//$QURYlist	= "SELECT D.`design_id`, D.`design_image_ext_1`, CONCAT(D.`design_short_form`,'',D.`design_no`) AS design_no, C.design_cat_name, SC.design_subcat_name, D.no_of_st, D.st_wgt, D.gross_wgt FROM `designs` AS D, design_cat AS C, design_subcat AS SC WHERE D.design_cat_id=C.design_cat_id AND D.design_subcat_id=SC.design_subcat_id AND D.`design_gen_cat_id` BETWEEN 40 AND 41 ORDER BY D.`design_id` DESC";

		$QURYlist	= "SELECT D.`design_id`, D.`design_image_ext_1`, CONCAT(D.`design_short_form`,'',D.`design_no`) AS design_no, C.design_cat_name, SC.design_subcat_name, D.no_of_st, D.st_wgt, D.gross_wgt FROM `designs` AS D, design_cat AS C, design_subcat AS SC WHERE D.design_cat_id=C.design_cat_id AND D.design_subcat_id=SC.design_subcat_id AND D.`design_gen_cat_id` = 42 ORDER BY D.`design_id` DESC";
		$CONNlist	= $connection->executeQuery($QURYlist);
		$FTCHlist	= $CONNlist->fetchAll();
		$CONTlist	= count($FTCHlist);
		
		for($i=0; $i<=$CONTlist; $i++)
		{
			$design_id	= $FTCHlist[$i]['design_id'];
			$design_no	= $FTCHlist[$i]['design_no'];
			$dsgnIMGext	= $FTCHlist[$i]['design_image_ext_1'];
			
			//if(file_exists("designs/".$design_no.".".$dsgnIMGext))
			if(file_exists("31.SHS/31.SHS/".$design_no.".".$dsgnIMGext))
			{
				echo 
				$design_no.".".$dsgnIMGext." - Image Exists";
				echo "<br>";
			}
			else
			{
				echo
				$updt = "UPDATE `designs` SET `design_image_ext_1`='' WHERE `design_id`=".$design_id;
				$CONN = $connection->executeQuery($updt);
				echo "<br>";				
			}		
		}
		
		die();
    }
	
	
	/**
     * @Route("/design-img-convertion", name="design-img-convertion")
     */
    public function desgnImgCconvertionACT(Request $request) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		//$imgPath = "designs/";
		$imgPath = "31.SHS/31.SHS/";
		
		// Sort in ascending order - this is default
		$imgName = scandir($imgPath);
		
		// Sort in descending order
		//$imgName = scandir($imgPath,1);
		
		//print_r($imgName);
		
		//print_r($b);
		
		$imgNmCont = count($imgName);
		
		for($i=3; $i<= $imgNmCont-1; $i++)
		{
			$expimgNm 	= explode(".",$imgName[$i]);
			$imgExtn 	= $expimgNm[1];
				
			echo
			$updt = "UPDATE `designs` SET `design_image_ext_1`='$imgExtn' WHERE `design_no_sup`='".$expimgNm[0]."'";
			$CONN = $connection->executeQuery($updt);
			echo "<br>";
		}
		
		die();
    }	
	
}
