<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class CastingDeptController extends AbstractController
{
    /**
     * @Route("/casting-iss-data{castISSid}", name="casting-iss-data") 
     */
    public function castingIssDataActions(Request $request, $castISSid) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		$sessionId  = $session->get('empId');
		
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");	 
		
		#--------[ FETCH - METAL stock WGT
/*		$QURYmtSTwt = "SELECT SUM(`conversion_wgt`) AS mtSTwg FROM `party_metal_receipt` WHERE `role_status`='1'";
		$CONNmtSTwt = $connection->executeQuery($QURYmtSTwt);
		$FTCHmtSTwt = $CONNmtSTwt->fetchAll();		
		
		if($FTCHmtSTwt[0]['mtSTwg'] == "")
		{
			$RSLTmtSTwt = 0;
		}
		else if($FTCHmtSTwt[0]['mtSTwg'] != "")
		{
			$RSLTmtSTwt = $FTCHmtSTwt[0]['mtSTwg'];
		}*/
		
		#--------[ FETCH - CONVERSTION METAL WEIGHT IN HAND
		$QURYconvMTwgt = "SELECT SUM(`conversion_wgt`) AS converTOTwgtINhand FROM `party_metal_receipt` WHERE `role_status`=1";
		$CONNconvMTwgt = $connection->executeQuery($QURYconvMTwgt);
		$FTCHconvMTwgt = $CONNconvMTwgt->fetchAll();	
		$RSLTconvMTwgt = $FTCHconvMTwgt[0]['converTOTwgtINhand'];

		#--------[ FETCH - METAL ACCESSORIES CONVER WGT
		$QURYcnvACSwgt = "SELECT SUM(`acces_conver_wgt` + `acces_conver_loss_wgt`) AS acesoMTconvWGT FROM `metal_conver_acces` WHERE `role_status`=1";
		$CONNcnvACSwgt = $connection->executeQuery($QURYcnvACSwgt);
		$FTCHcnvACSwgt = $CONNcnvACSwgt->fetchAll();		
		$RSLTcnvACSwgt = $FTCHcnvACSwgt[0]['acesoMTconvWGT'];

		$BLNCconvMTwgt = number_format($RSLTconvMTwgt - $RSLTcnvACSwgt, 2);		

		#--------[ FETCH - TREE NO
		$QURYtreeNO = "SELECT `wax_tree_making_id`, CONCAT(tree_no_code,'/',tree_no) AS tree_no FROM `wax_tree_making` WHERE `role_status`=1 AND `tree_status`='open' ORDER BY `wax_tree_making_id` ASC";
		$CONNtreeNO = $connection->executeQuery($QURYtreeNO);
		$FTCHtreeNO = $CONNtreeNO->fetchAll();			
		
		#--------[ FETCH - EMP LIST
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM `employee` AS E, employee_salary AS ES, dept AS D, roles AS R WHERE E.dept=D.dept_id AND E.roles=R.roles_id AND E.employee_id=ES.employee_id AND E.role_status=1 GROUP BY ES.employee_id ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();		
		
		########-[ QUICK VARIABLES
		$tableName	= "casting_iss";
		$tablePrmID	= "casting_iss_id";
		$getVARIid	= $castISSid;
			
		########-[ LIST 
		$QURYlistDet= "SELECT CISS.casting_iss_id, CISS.wax_tree_making_id, CONCAT(TM.tree_no_code,'/',TM.tree_no) AS tree_no, FORMAT(CISS.gross_wgt, 3) AS gross_wgt, FORMAT(CISS.st_wgt, 3) AS st_wgt, FORMAT(CISS.mt_wgt, 3) AS mt_wgt, CISS.perc, FORMAT(CISS.act_iss_mt_wt, 3) AS act_iss_mt_wt, FORMAT(CISS.iss_mt_wt, 3) AS iss_mt_wt, DATE_FORMAT(CISS.post_dt, '%b %D, %y %I:%i %p') AS entry_date, E.emp_name FROM `casting_iss` AS CISS, wax_tree_making AS TM, employee AS E WHERE CISS.wax_tree_making_id=TM.wax_tree_making_id AND CISS.emp_id=E.employee_id ORDER BY CISS.`casting_iss_id` DESC";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();
		$CONTlistDet= count($FTCHlistDet);
		
		$data = "";
		for($i=0; $i<=$CONTlistDet-1; $i++)
		{
		
			#--------[ CHECKing
			$QURYwxENT = "SELECT `casting_rec_id` FROM `casting_rec` WHERE `casting_iss_id`='".$FTCHlistDet[$i]['casting_iss_id']."'";
			$CONNwxENT = $connection->executeQuery($QURYwxENT);
			$FTCHwxENT = $CONNwxENT->fetchAll();
			$CHCKwxENT = $FTCHwxENT[0]['casting_rec_id'];	
			
			$data .= '<tr>
						<td title="Showing - Serial No." style="text-align:center; vertical-align: middle;">'.($i+1).'</td>
						<td title="Showing - Tree No." style="text-align:center; vertical-align: middle;">'.$FTCHlistDet[$i]['tree_no'].'</td>
						<td title="Showing - Gross Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]['gross_wgt'].'</td>
						<td title="Showing - Stone Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]['st_wgt'].'</td>
						<td title="Showing - Net/Metal Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]['mt_wgt'].'</td>
						<td title="Showing - Percentage %" style="text-align:center; vertical-align: middle;">'.$FTCHlistDet[$i]['perc'].'</td>
						<td title="Showing - Actual Issue Metal Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]['act_iss_mt_wt'].'</td>
						<td title="Showing - Issued Metal Weight in Grams" style="text-align:right; vertical-align: middle;">'.$FTCHlistDet[$i]['iss_mt_wt'].'</td>
						<td title="Showing - Entry Date" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['entry_date'].'</td>
						<td title="Showing - Issued Employee" style="text-align:left; vertical-align: middle;">'.$FTCHlistDet[$i]['emp_name'].'</td>
						<td title="Action" style="text-align:center; vertical-align: middle;">';
				if($CHCKwxENT == "")
		  		{
				   $data .= '<a href="casting-iss-data'.$FTCHlistDet[$i]['casting_iss_id'].'"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>
							&nbsp;&nbsp;&nbsp;
							<a href="casting-iss-dlt'.$FTCHlistDet[$i]['casting_iss_id'].'?wx='.$FTCHlistDet[$i]['wax_tree_making_id'].'"><i class="fa fa-trash" aria-hidden="true" style="color:red;"></i></a>';
				}
				else if($CHCKwxENT != "")
				{
				   $data .= '<i class="fa fa-pencil-square-o" aria-hidden="true" style="color:#E8E8E8"></i>
								&nbsp;&nbsp;&nbsp;
							  <i class="fa fa-trash" aria-hidden="true" style="color:#E8E8E8;"></i>';				
				}
						
			  $data .= '</td>
					</tr>';		
		}
		
		if($getVARIid != 0)
		{
			########-[ GET UPDATE - DETAILS
			$QURYupdtDet	= "SELECT TM.wax_tree_making_id, CONCAT(TM.tree_no_code,'/',TM.tree_no) AS tree_no, FORMAT(CISS.gross_wgt, 3) AS gross_wgt, FORMAT(CISS.st_wgt, 3) AS st_wgt, FORMAT(CISS.mt_wgt, 3) AS mt_wgt, CISS.perc, FORMAT(CISS.act_iss_mt_wt, 3) AS act_iss_mt_wt, FORMAT(CISS.iss_mt_wt, 3) AS iss_mt_wt,  CISS.emp_id FROM `casting_iss` AS CISS, wax_tree_making AS TM WHERE CISS.wax_tree_making_id=TM.wax_tree_making_id AND CISS.casting_iss_id='$castISSid'";
			$CONNupdtDet	= $connection->executeQuery($QURYupdtDet);
			$FTCHupdtDet	= $CONNupdtDet->fetchAll();
			
			$FTCHupdtDet['wax_tree_making_id'] = $FTCHupdtDet[0]['wax_tree_making_id'];
			$FTCHupdtDet['tree_no']  		= $FTCHupdtDet[0]['tree_no'];
			$FTCHupdtDet['gross_wgt']		= $FTCHupdtDet[0]['gross_wgt'];
			$FTCHupdtDet['st_wgt'] 			= $FTCHupdtDet[0]['st_wgt'];
			$FTCHupdtDet['mt_wgt']  		= $FTCHupdtDet[0]['mt_wgt'];
			$FTCHupdtDet['perc']  			= $FTCHupdtDet[0]['perc'];
			$FTCHupdtDet['act_iss_mt_wt']  	= $FTCHupdtDet[0]['act_iss_mt_wt'];
			$FTCHupdtDet['iss_mt_wt']  		= $FTCHupdtDet[0]['iss_mt_wt'];
			$FTCHupdtDet['emp_id']  		= $FTCHupdtDet[0]['emp_id'];
		}
		else
		{
			$FTCHupdtDet = "";
		}
		
		if($request->getMethod() == 'POST')
		{
			
			$tree_id  		= $request->get('tree_id');
			$gross_wgt   	= $request->get('gross_wgt');
			$st_wgt 		= $request->get('st_wgt');						
			$mt_wgt  		= $request->get('mt_wgt');
			$percentage  	= $request->get('percentage');
			$act_iss_mt_wgt	= $request->get('act_iss_mt_wgt');
			$issued_mt_wgt  = $request->get('issued_mt_wgt');
			$entry_date		= explode("-", $request->get('entry_date'));
			$entry_date		= $entry_date[2]."-".$entry_date[1]."-".$entry_date[0];
			$emp_id    		= $request->get('emp_id');
			
			if($getVARIid == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO ".$tableName."(`wax_tree_making_id`, `gross_wgt`, `st_wgt`, `mt_wgt`, `perc`, `act_iss_mt_wt`, `iss_mt_wt`, `entry_date`, `emp_id`, `post_by`, `post_dt`) VALUES ('$tree_id', '$gross_wgt', '$st_wgt', '$mt_wgt', '$percentage', '$act_iss_mt_wgt', '$issued_mt_wgt', '$entry_date', '$emp_id', '$sessionId', '$nowDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
				
				########-[ UPDATE - CLOSE TREE STATUS
				$QRupdt = "UPDATE `wax_tree_making` SET `tree_status`='close', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE `wax_tree_making_id`='$tree_id'";
				$CNupdt = $connection->executeQuery($QRupdt);
			}
			else
			{
				########-[ UPDATE - DETAILS			
				$QRupdate 	= "UPDATE ".$tableName." SET `iss_mt_wt`='$issued_mt_wgt', `emp_id`='$emp_id', `rec_status`='open' ,`update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE ".$tablePrmID."=".$getVARIid;
				$CNexecut 	= $connection->executeQuery($QRupdate);
				
				########-[ UPDATE - CLOSE TREE STATUS
				$QRupdt = "UPDATE `wax_tree_making` SET `tree_status`='open', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE `wax_tree_making_id`='$tree_id'";
				$CNupdt = $connection->executeQuery($QRupdt);
			}
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}
		
		
		return $this->render('dept/casting-iss-data.html.twig', [
			'treeNOlist' => $FTCHtreeNO,
			'empLIST' => $FTCHemp,
			'listDet' => $FTCHlistDet,
			'mtSTwt' => $BLNCconvMTwgt,
			'FTCHupdtDet' => $FTCHupdtDet,
			'data' => $data,
			'controller_name' => 'CastingDeptController'
        ]);
    }
	
	
    /**
     * @Route("/casting-rec-data{castRECid}", name="casting-rec-data")
     */
    public function castingRecDataActions(Request $request, $castRECid) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 
		
		date_default_timezone_set("Asia/Kolkata");
		$current_dt = date("Y-m-d");
		
		#--------[ FETCH - TREE NO
		$QURYtreeNO = "SELECT CASTiss.`wax_tree_making_id`, CONCAT(TREE.tree_no_code,'/',TREE.tree_no) AS tree_no FROM `casting_iss` AS CASTiss, wax_tree_making AS TREE WHERE CASTiss.`role_status`=1 AND CASTiss.rec_status='open' AND TREE.wax_tree_making_id = CASTiss.wax_tree_making_id ORDER BY CASTiss.`wax_tree_making_id` ASC";
		$CONNtreeNO = $connection->executeQuery($QURYtreeNO);
		$FTCHtreeNO = $CONNtreeNO->fetchAll();			
		
		#--------[ FETCH - EMP LIST
		$QURYemp	= "SELECT E.employee_id, E.emp_name FROM `employee` AS E, employee_salary AS ES, dept AS D, roles AS R WHERE E.dept=D.dept_id AND E.roles=R.roles_id AND E.employee_id=ES.employee_id AND E.role_status=1 GROUP BY ES.employee_id ORDER BY E.emp_name ASC";
		$CONNemp	= $connection->executeQuery($QURYemp);
		$FTCHemp	= $CONNemp->fetchAll();			
		
		########-[ QUICK VARIABLES
		$tableName	= "casting_rec";
		$tablePrmID	= "casting_rec_id";
		$getVARIid	= $castRECid;
		
		########-[ LIST 
		//$QURYlistDet= "SELECT CREC.casting_rec_id, DATE_FORMAT(CREC.post_dt, '%b %D, %y %I:%i %p') AS entry_date, CONCAT(TM.tree_no_code,'/',TM.tree_no) AS tree_no, FORMAT(CREC.`iss_mt_wt`, 3) AS iss_mt_wt, FORMAT(CREC.`orn_wgt`, 3) AS orn_wgt, FORMAT(CREC.mt_wgt, 3) AS mt_wgt, FORMAT(CREC.`loss_wgt`, 3) AS loss_wgt, E.emp_name, concat(UPPER(SUBSTRING(trim(CREC.cast_rec_status),1,1)), lower(SUBSTRING(trim(CREC.cast_rec_status),2))) AS cast_rec_status, CREC.notess FROM `casting_rec` AS CREC, wax_tree_making AS TM, employee AS E WHERE CREC.wax_tree_making_id=TM.wax_tree_making_id AND CREC.emp_id=E.employee_id ORDER BY CREC.`casting_rec_id` DESC";
		$QURYlistDet= "SELECT DISTINCT TMD.sepration_emp_id, CREC.casting_rec_id, CREC.wax_tree_making_id, DATE_FORMAT( CREC.post_dt, '%b %D, %y %I:%i %p' ) AS entry_date, CONCAT(TM.tree_no_code, '/', TM.tree_no) AS tree_no, FORMAT(CREC.`iss_mt_wt`, 3) AS iss_mt_wt, FORMAT(CREC.`orn_wgt`, 3) AS orn_wgt, FORMAT(CREC.mt_wgt, 3) AS mt_wgt, FORMAT(CREC.`loss_wgt`, 3) AS loss_wgt, E.emp_name, CONCAT( UPPER( SUBSTRING( TRIM(CREC.cast_rec_status), 1, 1 ) ), LOWER( SUBSTRING(TRIM(CREC.cast_rec_status), 2) ) ) AS cast_rec_status, CREC.notess FROM `casting_rec` AS CREC, `wax_tree_making` AS TM, `employee` AS E, `wax_tree_making_det` AS TMD WHERE CREC.wax_tree_making_id = TM.wax_tree_making_id AND TM.wax_tree_making_id = TMD.wax_tree_making_id AND CREC.emp_id = E.employee_id ORDER BY CREC.`casting_rec_id` DESC";
		$CONNlistDet= $connection->executeQuery($QURYlistDet);
		$FTCHlistDet= $CONNlistDet->fetchAll();		

						
		if($getVARIid != 0)
		{
			########-[ GET UPDATE - DETAILS
			//$QURYupdtDet	= "SELECT TM.tree_no_code, TM.tree_no, TM.wax_tree_making_id, CR.casting_iss_id, CR.iss_mt_wt, CR.orn_wgt, CR.mt_wgt, CR.loss_wgt, CR.emp_id, CR.cast_rec_status, CR.notess FROM `casting_rec` AS CR, wax_tree_making AS TM WHERE CR.wax_tree_making_id=TM.wax_tree_making_id AND CR.casting_rec_id='".$FTCHlistDet[0]['casting_rec_id']."'";
			$QURYupdtDet	= "SELECT TM.tree_no_code, TM.tree_no, TM.wax_tree_making_id, CR.casting_iss_id, CR.iss_mt_wt, CR.orn_wgt, CR.mt_wgt, CR.loss_wgt, CR.emp_id, CR.cast_rec_status, CR.notess FROM `casting_rec` AS CR, wax_tree_making AS TM WHERE CR.wax_tree_making_id=TM.wax_tree_making_id AND CR.casting_rec_id='".$getVARIid."'";
			$CONNupdtDet	= $connection->executeQuery($QURYupdtDet);
			$FTCHupdtDet	= $CONNupdtDet->fetchAll();
			
			$FTCHupdtDet['tree_no'] 			= $FTCHupdtDet[0]['tree_no_code']."/".$FTCHupdtDet[0]['tree_no'];
			$FTCHupdtDet['wax_tree_making_id'] 	= $FTCHupdtDet[0]['wax_tree_making_id'];
			$FTCHupdtDet['casting_iss_id'] 		= $FTCHupdtDet[0]['casting_iss_id'];
			$FTCHupdtDet['iss_mt_wt'] 			= number_format($FTCHupdtDet[0]['iss_mt_wt'], 3);
			$FTCHupdtDet['orn_wgt']  			= number_format($FTCHupdtDet[0]['orn_wgt'], 3);
			$FTCHupdtDet['mt_wgt']  			= number_format($FTCHupdtDet[0]['mt_wgt'], 3);
			$FTCHupdtDet['loss_wgt']  			= number_format($FTCHupdtDet[0]['loss_wgt'], 3);
			$FTCHupdtDet['emp_id']  			= $FTCHupdtDet[0]['emp_id'];
			$FTCHupdtDet['cast_rec_status']		= $FTCHupdtDet[0]['cast_rec_status'];
			$FTCHupdtDet['notess']  			= $FTCHupdtDet[0]['notess'];
		}
		else
		{
			$FTCHupdtDet = "";
		}
		
		if($request->getMethod() == 'POST')
		{
			date_default_timezone_set("Asia/Kolkata");
			$nwDateTime  = date("Y-m-d H:i:s");
			
			$entry_date	= explode("-", $request->get('entry_date'));
			$entry_date	= $entry_date[2]."-".$entry_date[1]."-".$entry_date[0];
			$tree_id   	= $request->get('tree_id');
			$castISSid 	= $request->get('castISSid');
			$issed_wgt 	= $request->get('issed_wgt');						
			$orn_wgt  	= $request->get('orn_wgt');
			$mt_wgt    	= $request->get('mt_wgt');
			$loss_wgt   = $request->get('loss_wgt');
			$emp_id    	= $request->get('emp_id');
			$rec_status	= $request->get('rec_status');
			$notes		= addcslashes($request->get('notes'));
			
			if($getVARIid == 0)
			{
				########-[ INSERT - DETAILS
				$QRinsert = "INSERT INTO ".$tableName."(`entry_date`, `casting_iss_id`, `wax_tree_making_id`, `iss_mt_wt`, `orn_wgt`, `mt_wgt`, `loss_wgt`, `emp_id`, `cast_rec_status`, `notess`, `post_by`, `post_dt`) VALUES ('$entry_date', '$castISSid', '$tree_id', '$issed_wgt', '$orn_wgt', '$mt_wgt', '$loss_wgt', '$emp_id', '$rec_status', '$notes', '$sessionId', '$nwDateTime')";
				$CNexecut = $connection->executeQuery($QRinsert);
				
				########-[ UPDATE - REC STATUS
				$QRupdt = "UPDATE `casting_iss` SET `rec_status`='$rec_status', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE `casting_iss_id`='$castISSid'";
				$CNupdt = $connection->executeQuery($QRupdt);				
			}
			else
			{
				########-[ UPDATE - REC STATUS
				$QRupdt = "UPDATE `casting_rec` SET `orn_wgt`='$orn_wgt', `mt_wgt`='$mt_wgt', `loss_wgt`='$loss_wgt', `emp_id`='$emp_id', `cast_rec_status`='$rec_status', `notess`='$notes', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `casting_rec_id`='".$FTCHlistDet[0]['casting_rec_id']."'";
				$CNupdt = $connection->executeQuery($QRupdt);
				
				########-[ UPDATE - REC STATUS
				$QRupdt = "UPDATE `casting_iss` SET `rec_status`='$rec_status', `update_by`='$sessionId', `update_dt`='$nowDateTime' WHERE `casting_iss_id`='".$FTCHupdtDet['casting_iss_id']."'";
				$CNupdt = $connection->executeQuery($QRupdt);	
			}
			
			return $this->redirect($request->getUri());	########-[THIS AVOID DUPLICATION while refreshing
		}
		
		return $this->render('dept/casting-rec-data.html.twig', [
			'treeNOlist' => $FTCHtreeNO,
			'empLIST' => $FTCHemp,
			'listDet' => $FTCHlistDet,
			'FTCHupdtDet' => $FTCHupdtDet,
			'controller_name' => 'CastingDeptController'
        ]);
    }
	
	
	/**
     * @Route("/casting-iss-dlt{castISSid}", name="casting-iss-dlt")   
     */
    public function castingISSdltAct(Request $request, $castISSid) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		#--------[ UPDATE FLAG
		$QURYjc = "UPDATE `wax_tree_making` SET `tree_status`='open', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `wax_tree_making_id`='".$_GET['wx']."'";
		$CONNjc = $connection->executeQuery($QURYjc);
		
		#--------[ DEELTE - CASTING ISSUE
		$QURYci = "DELETE FROM `casting_iss` WHERE `casting_iss_id`='".$castISSid."'";
		$CONNci = $connection->executeQuery($QURYci);

		return $this->redirectToRoute('casting-iss-data', ['castISSid' => 0]);
    }	
	
	
	
	/**
     * @Route("/casting-rec-dlt{castRECid}", name="casting-rec-dlt")   
     */
    public function castingRECdltAct(Request $request, $castRECid) 
    {
		$session =$request->getSession();
		
        if(!$session->has('LoginToken'))
        {
        	return $this->redirectToRoute('index');
        }
		
		error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		#--------[ UPDATE FLAG
/*		$QURYjc = "UPDATE `casting_rec` SET `cast_rec_status`='open', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `casting_rec_id`='".$castRECdltID."'";
		$CONNjc = $connection->executeQuery($QURYjc);*/
		
		#--------[ UPDATE FLAG - CASTING ISS - TABLE
		$QURYcastISS = "UPDATE `casting_iss` SET `rec_status`='open', `update_by`='$sessionId', `update_dt`='$nwDateTime' WHERE `wax_tree_making_id`='".$_GET['waxTreeMakID']."'";
		$CONNcastISS = $connection->executeQuery($QURYcastISS);
		
		#--------[ DELETE - CASTING ISSUE
		$QURYci = "DELETE FROM `casting_rec` WHERE `casting_rec_id`='".$castRECid."'";
		$CONNci = $connection->executeQuery($QURYci);

		return $this->redirectToRoute('casting-rec-data', ['castRECid' => 0]);
    }		
}