<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ProdWgtDatas
 *
 * @ORM\Table(name="prod_wgt_datas")
 * @ORM\Entity
 */
class ProdWgtDatas
{
    /**
     * @var int
     *
     * @ORM\Column(name="prod_wgt_datas_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $prodWgtDatasId;

    /**
     * @var int
     *
     * @ORM\Column(name="prod_wgt_datas_rfrnc_id", type="integer", nullable=false)
     */
    private $prodWgtDatasRfrncId;

    /**
     * @var int
     *
     * @ORM\Column(name="prod_id", type="integer", nullable=false, options={"comment"="prod tbl primary key"})
     */
    private $prodId;

    /**
     * @var string
     *
     * @ORM\Column(name="prod_wgt", type="string", length=10, nullable=false)
     */
    private $prodWgt;

    /**
     * @var string
     *
     * @ORM\Column(name="selling_price", type="string", length=10, nullable=false)
     */
    private $sellingPrice;

    /**
     * @var string
     *
     * @ORM\Column(name="disc_price", type="string", length=10, nullable=false)
     */
    private $discPrice;

    /**
     * @var string
     *
     * @ORM\Column(name="min_ord_qty", type="string", length=10, nullable=false)
     */
    private $minOrdQty;

    /**
     * @var string
     *
     * @ORM\Column(name="max_ord_qty", type="string", length=10, nullable=false)
     */
    private $maxOrdQty;

    /**
     * @var string
     *
     * @ORM\Column(name="buffer_stock_qty", type="string", length=10, nullable=false)
     */
    private $bufferStockQty;

    /**
     * @var string
     *
     * @ORM\Column(name="role_status", type="string", length=1, nullable=false, options={"default"="'1'","comment"="1 - Active, 0 - In-Active"})
     */
    private $roleStatus = '\'1\'';

    /**
     * @var string
     *
     * @ORM\Column(name="action_type", type="string", length=10, nullable=false, options={"comment"="inst - Insert, edit - Edit, dlt - Delete, role - Role Status"})
     */
    private $actionType;

    /**
     * @var string
     *
     * @ORM\Column(name="active_row", type="string", length=3, nullable=false, options={"comment"="Lat - Latest Row, Old - Old Row"})
     */
    private $activeRow;

    /**
     * @var int
     *
     * @ORM\Column(name="post_by", type="integer", nullable=false)
     */
    private $postBy;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="post_dt", type="datetime", nullable=false)
     */
    private $postDt;

    /**
     * @var int
     *
     * @ORM\Column(name="update_by", type="integer", nullable=false)
     */
    private $updateBy;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="update_dt", type="datetime", nullable=false)
     */
    private $updateDt;

    public function getProdWgtDatasId(): ?int
    {
        return $this->prodWgtDatasId;
    }

    public function getProdWgtDatasRfrncId(): ?int
    {
        return $this->prodWgtDatasRfrncId;
    }

    public function setProdWgtDatasRfrncId(int $prodWgtDatasRfrncId): self
    {
        $this->prodWgtDatasRfrncId = $prodWgtDatasRfrncId;

        return $this;
    }

    public function getProdId(): ?int
    {
        return $this->prodId;
    }

    public function setProdId(int $prodId): self
    {
        $this->prodId = $prodId;

        return $this;
    }

    public function getProdWgt(): ?string
    {
        return $this->prodWgt;
    }

    public function setProdWgt(string $prodWgt): self
    {
        $this->prodWgt = $prodWgt;

        return $this;
    }

    public function getSellingPrice(): ?string
    {
        return $this->sellingPrice;
    }

    public function setSellingPrice(string $sellingPrice): self
    {
        $this->sellingPrice = $sellingPrice;

        return $this;
    }

    public function getDiscPrice(): ?string
    {
        return $this->discPrice;
    }

    public function setDiscPrice(string $discPrice): self
    {
        $this->discPrice = $discPrice;

        return $this;
    }

    public function getMinOrdQty(): ?string
    {
        return $this->minOrdQty;
    }

    public function setMinOrdQty(string $minOrdQty): self
    {
        $this->minOrdQty = $minOrdQty;

        return $this;
    }

    public function getMaxOrdQty(): ?string
    {
        return $this->maxOrdQty;
    }

    public function setMaxOrdQty(string $maxOrdQty): self
    {
        $this->maxOrdQty = $maxOrdQty;

        return $this;
    }

    public function getBufferStockQty(): ?string
    {
        return $this->bufferStockQty;
    }

    public function setBufferStockQty(string $bufferStockQty): self
    {
        $this->bufferStockQty = $bufferStockQty;

        return $this;
    }

    public function getRoleStatus(): ?string
    {
        return $this->roleStatus;
    }

    public function setRoleStatus(string $roleStatus): self
    {
        $this->roleStatus = $roleStatus;

        return $this;
    }

    public function getActionType(): ?string
    {
        return $this->actionType;
    }

    public function setActionType(string $actionType): self
    {
        $this->actionType = $actionType;

        return $this;
    }

    public function getActiveRow(): ?string
    {
        return $this->activeRow;
    }

    public function setActiveRow(string $activeRow): self
    {
        $this->activeRow = $activeRow;

        return $this;
    }

    public function getPostBy(): ?int
    {
        return $this->postBy;
    }

    public function setPostBy(int $postBy): self
    {
        $this->postBy = $postBy;

        return $this;
    }

    public function getPostDt(): ?\DateTimeInterface
    {
        return $this->postDt;
    }

    public function setPostDt(\DateTimeInterface $postDt): self
    {
        $this->postDt = $postDt;

        return $this;
    }

    public function getUpdateBy(): ?int
    {
        return $this->updateBy;
    }

    public function setUpdateBy(int $updateBy): self
    {
        $this->updateBy = $updateBy;

        return $this;
    }

    public function getUpdateDt(): ?\DateTimeInterface
    {
        return $this->updateDt;
    }

    public function setUpdateDt(\DateTimeInterface $updateDt): self
    {
        $this->updateDt = $updateDt;

        return $this;
    }


}
