<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Prod
 *
 * @ORM\Table(name="prod")
 * @ORM\Entity
 */
class Prod
{
    /**
     * @var int
     *
     * @ORM\Column(name="prod_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $prodId;

    /**
     * @var int
     *
     * @ORM\Column(name="prod_rfrnc_id", type="integer", nullable=false)
     */
    private $prodRfrncId;

    /**
     * @var string
     *
     * @ORM\Column(name="pid", type="string", length=10, nullable=false, options={"comment"="prod auto increment id"})
     */
    private $pid;

    /**
     * @var int
     *
     * @ORM\Column(name="cat_id", type="integer", nullable=false, options={"comment"="category tbl primary key"})
     */
    private $catId;

    /**
     * @var int
     *
     * @ORM\Column(name="sub_cat_id", type="integer", nullable=false, options={"comment"="sub category tbl primary key"})
     */
    private $subCatId;

    /**
     * @var string
     *
     * @ORM\Column(name="prod_name", type="string", length=50, nullable=false)
     */
    private $prodName;

    /**
     * @var string
     *
     * @ORM\Column(name="frozen_type", type="string", length=3, nullable=false, options={"comment"="yes, no [flag for preserved prod]"})
     */
    private $frozenType;

    /**
     * @var string
     *
     * @ORM\Column(name="wgt_units", type="string", length=3, nullable=false, options={"comment"="Ml - Milli liter, Ltr - Liter, Grm - Grams, Kg - Kilo gram"})
     */
    private $wgtUnits;

    /**
     * @var string
     *
     * @ORM\Column(name="prod_wgt", type="string", length=10, nullable=false)
     */
    private $prodWgt;

    /**
     * @var string
     *
     * @ORM\Column(name="selling_price", type="string", length=10, nullable=false)
     */
    private $sellingPrice;

    /**
     * @var string
     *
     * @ORM\Column(name="disc_price", type="string", length=10, nullable=false)
     */
    private $discPrice;	

    /**
     * @var string
     *
     * @ORM\Column(name="min_ord_qty", type="string", length=10, nullable=false)
     */
    private $minOrdQty;	

    /**
     * @var string
     *
     * @ORM\Column(name="max_ord_qty", type="string", length=10, nullable=false)
     */
    private $maxOrdQty;	

    /**
     * @var string
     *
     * @ORM\Column(name="buffer_stock_qty", type="string", length=10, nullable=false)
     */
    private $bufferStockQty;	
				
    /**
     * @var string
     *
     * @ORM\Column(name="barcode_extn", type="string", length=5, nullable=false)
     */
    private $barcodeExtn;

    /**
     * @var string
     *
     * @ORM\Column(name="qrcode_extn", type="string", length=5, nullable=false)
     */
    private $qrcodeExtn;

    /**
     * @var string
     *
     * @ORM\Column(name="prod_img1_extn", type="string", length=5, nullable=false)
     */
    private $prodImg1Extn;

    /**
     * @var string
     *
     * @ORM\Column(name="prod_img2_extn", type="string", length=5, nullable=false)
     */
    private $prodImg2Extn;

    /**
     * @var string
     *
     * @ORM\Column(name="prod_img3_extn", type="string", length=5, nullable=false)
     */
    private $prodImg3Extn;

    /**
     * @var string
     *
     * @ORM\Column(name="prod_img4_extn", type="string", length=5, nullable=false)
     */
    private $prodImg4Extn;

    /**
     * @var string
     *
     * @ORM\Column(name="prod_tag_id", type="string", length=300, nullable=false)
     */
    private $prodTagId;

    /**
     * @var string
     *
     * @ORM\Column(name="brand_id", type="string", length=300, nullable=false)
     */
    private $brandId;

    /**
     * @var string
     *
     * @ORM\Column(name="prod_desc", type="text", length=0, nullable=false)
     */
    private $prodDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="role_status", type="string", length=1, nullable=false, options={"default"="'1'","comment"="1 - Active, 0 - In-Active"})
     */
    private $roleStatus = '\'1\'';

    /**
     * @var string
     *
     * @ORM\Column(name="action_type", type="string", length=10, nullable=false, options={"comment"="inst - Insert, edit - Edit, dlt - Delete, role - Role Status"})
     */
    private $actionType;

    /**
     * @var string
     *
     * @ORM\Column(name="active_row", type="string", length=3, nullable=false, options={"comment"="Lat - Latest Row, Old - Old Row"})
     */
    private $activeRow;

    /**
     * @var int
     *
     * @ORM\Column(name="post_by", type="integer", nullable=false)
     */
    private $postBy;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="post_dt", type="datetime", nullable=false)
     */
    private $postDt;

    /**
     * @var int
     *
     * @ORM\Column(name="update_by", type="integer", nullable=false)
     */
    private $updateBy;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="update_dt", type="datetime", nullable=false)
     */
    private $updateDt;

    public function getProdId(): ?int
    {
        return $this->prodId;
    }

    public function getProdRfrncId(): ?int
    {
        return $this->prodRfrncId;
    }

    public function setProdRfrncId(int $prodRfrncId): self
    {
        $this->prodRfrncId = $prodRfrncId;

        return $this;
    }

    public function getPid(): ?string
    {
        return $this->pid;
    }

    public function setPid(string $pid): self
    {
        $this->pid = $pid;

        return $this;
    }

    public function getCatId(): ?int
    {
        return $this->catId;
    }

    public function setCatId(int $catId): self
    {
        $this->catId = $catId;

        return $this;
    }

    public function getSubCatId(): ?int
    {
        return $this->subCatId;
    }

    public function setSubCatId(int $subCatId): self
    {
        $this->subCatId = $subCatId;

        return $this;
    }

    public function getProdName(): ?string
    {
        return $this->prodName;
    }

    public function setProdName(string $prodName): self
    {
        $this->prodName = $prodName;

        return $this;
    }

    public function getFrozenType(): ?string
    {
        return $this->frozenType;
    }

    public function setFrozenType(string $frozenType): self
    {
        $this->frozenType = $frozenType;

        return $this;
    }

    public function getWgtUnits(): ?string
    {
        return $this->wgtUnits;
    }

    public function setWgtUnits(string $wgtUnits): self
    {
        $this->wgtUnits = $wgtUnits;

        return $this;
    }

    public function getProdWgt(): ?string
    {
        return $this->prodWgt;
    }

    public function setProdWgt(string $prodWgt): self
    {
        $this->prodWgt = $prodWgt;

        return $this;
    }
	
    public function getSellingPrice(): ?string
    {
        return $this->sellingPrice;
    }

    public function setSellingPrice(string $sellingPrice): self
    {
        $this->sellingPrice = $sellingPrice;

        return $this;
    }	
	
    public function getDiscPrice(): ?string
    {
        return $this->discPrice;
    }

    public function setDiscPrice(string $discPrice): self
    {
        $this->discPrice = $discPrice;

        return $this;
    }		

    public function getMinOrdQty(): ?string
    {
        return $this->minOrdQty;
    }

    public function setMinOrdQty(string $minOrdQty): self
    {
        $this->minOrdQty = $minOrdQty;

        return $this;
    }		

    public function getMaxOrdQty(): ?string
    {
        return $this->maxOrdQty;
    }

    public function setMaxOrdQty(string $maxOrdQty): self
    {
        $this->maxOrdQty = $maxOrdQty;

        return $this;
    }		

    public function getBufferStockQty(): ?string
    {
        return $this->bufferStockQty;
    }

    public function setBufferStockQty(string $bufferStockQty): self
    {
        $this->bufferStockQty = $bufferStockQty;

        return $this;
    }		

    public function getBarcodeExtn(): ?string
    {
        return $this->barcodeExtn;
    }

    public function setBarcodeExtn(string $barcodeExtn): self
    {
        $this->barcodeExtn = $barcodeExtn;

        return $this;
    }

    public function getQrcodeExtn(): ?string
    {
        return $this->qrcodeExtn;
    }

    public function setQrcodeExtn(string $qrcodeExtn): self
    {
        $this->qrcodeExtn = $qrcodeExtn;

        return $this;
    }

    public function getProdImg1Extn(): ?string
    {
        return $this->prodImg1Extn;
    }

    public function setProdImg1Extn(string $prodImg1Extn): self
    {
        $this->prodImg1Extn = $prodImg1Extn;

        return $this;
    }

    public function getProdImg2Extn(): ?string
    {
        return $this->prodImg2Extn;
    }

    public function setProdImg2Extn(string $prodImg2Extn): self
    {
        $this->prodImg2Extn = $prodImg2Extn;

        return $this;
    }

    public function getProdImg3Extn(): ?string
    {
        return $this->prodImg3Extn;
    }

    public function setProdImg3Extn(string $prodImg3Extn): self
    {
        $this->prodImg3Extn = $prodImg3Extn;

        return $this;
    }

    public function getProdImg4Extn(): ?string
    {
        return $this->prodImg4Extn;
    }

    public function setProdImg4Extn(string $prodImg4Extn): self
    {
        $this->prodImg4Extn = $prodImg4Extn;

        return $this;
    }

    public function getProdTagId(): ?string
    {
        return $this->prodTagId;
    }

    public function setProdTagId(string $prodTagId): self
    {
        $this->prodTagId = $prodTagId;

        return $this;
    }

    public function getBrandId(): ?string
    {
        return $this->brandId;
    }

    public function setBrandId(string $brandId): self
    {
        $this->brandId = $brandId;

        return $this;
    }

    public function getProdDesc(): ?string
    {
        return $this->prodDesc;
    }

    public function setProdDesc(string $prodDesc): self
    {
        $this->prodDesc = $prodDesc;

        return $this;
    }

    public function getRoleStatus(): ?string
    {
        return $this->roleStatus;
    }

    public function setRoleStatus(string $roleStatus): self
    {
        $this->roleStatus = $roleStatus;

        return $this;
    }

    public function getActionType(): ?string
    {
        return $this->actionType;
    }

    public function setActionType(string $actionType): self
    {
        $this->actionType = $actionType;

        return $this;
    }

    public function getActiveRow(): ?string
    {
        return $this->activeRow;
    }

    public function setActiveRow(string $activeRow): self
    {
        $this->activeRow = $activeRow;

        return $this;
    }

    public function getPostBy(): ?int
    {
        return $this->postBy;
    }

    public function setPostBy(int $postBy): self
    {
        $this->postBy = $postBy;

        return $this;
    }

    public function getPostDt(): ?\DateTimeInterface
    {
        return $this->postDt;
    }

    public function setPostDt(\DateTimeInterface $postDt): self
    {
        $this->postDt = $postDt;

        return $this;
    }

    public function getUpdateBy(): ?int
    {
        return $this->updateBy;
    }

    public function setUpdateBy(int $updateBy): self
    {
        $this->updateBy = $updateBy;

        return $this;
    }

    public function getUpdateDt(): ?\DateTimeInterface
    {
        return $this->updateDt;
    }

    public function setUpdateDt(\DateTimeInterface $updateDt): self
    {
        $this->updateDt = $updateDt;

        return $this;
    }


}
