<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Log
 *
 * @ORM\Table(name="log")
 * @ORM\Entity
 */
class Log
{
    /**
     * @var int
     *
     * @ORM\Column(name="log_id", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $logId;

    /**
     * @var string
     *
     * @ORM\Column(name="page_name", type="string", length=100, nullable=false)
     */
    private $pageName;

    /**
     * @var string
     *
     * @ORM\Column(name="page_action", type="string", length=100, nullable=false)
     */
    private $pageAction;

    /**
     * @var string
     *
     * @ORM\Column(name="affected_fields", type="text", length=65535, nullable=false)
     */
    private $affectedFields;

    /**
     * @var string
     *
     * @ORM\Column(name="ip_address", type="string", length=20, nullable=false)
     */
    private $ipAddress;

    /**
     * @var string
     *
     * @ORM\Column(name="user_agent", type="text", length=65535, nullable=false)
     */
    private $userAgent;

    /**
     * @var int
     *
     * @ORM\Column(name="post_by", type="integer", nullable=false)
     */
    private $postBy;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="post_dt", type="datetime", nullable=false, options={"default"="current_timestamp()"})
     */
    private $postDt = 'current_timestamp()';

    public function getLogId(): ?string
    {
        return $this->logId;
    }

    public function getPageName(): ?string
    {
        return $this->pageName;
    }

    public function setPageName(string $pageName): self
    {
        $this->pageName = $pageName;

        return $this;
    }

    public function getPageAction(): ?string
    {
        return $this->pageAction;
    }

    public function setPageAction(string $pageAction): self
    {
        $this->pageAction = $pageAction;

        return $this;
    }

    public function getAffectedFields(): ?string
    {
        return $this->affectedFields;
    }

    public function setAffectedFields(string $affectedFields): self
    {
        $this->affectedFields = $affectedFields;

        return $this;
    }

    public function getIpAddress(): ?string
    {
        return $this->ipAddress;
    }

    public function setIpAddress(string $ipAddress): self
    {
        $this->ipAddress = $ipAddress;

        return $this;
    }

    public function getUserAgent(): ?string
    {
        return $this->userAgent;
    }

    public function setUserAgent(string $userAgent): self
    {
        $this->userAgent = $userAgent;

        return $this;
    }

    public function getPostBy(): ?int
    {
        return $this->postBy;
    }

    public function setPostBy(int $postBy): self
    {
        $this->postBy = $postBy;

        return $this;
    }

    public function getPostDt(): ?\DateTimeInterface
    {
        return $this->postDt;
    }

    public function setPostDt(\DateTimeInterface $postDt): self
    {
        $this->postDt = $postDt;

        return $this;
    }


}
