<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Emp
 *
 * @ORM\Table(name="emp")
 * @ORM\Entity
 */
class Emp
{
    /**
     * @var int
     *
     * @ORM\Column(name="emp_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $empId;

    /**
     * @var int
     *
     * @ORM\Column(name="emp_rfrnc_id", type="integer", nullable=false)
     */
    private $empRfrncId;

    /**
     * @var string
     *
     * @ORM\Column(name="eid", type="string", length=10, nullable=false, options={"comment"="Employee ID - Auto Increment"})
     */
    private $eid;

    /**
     * @var string
     *
     * @ORM\Column(name="emp_name", type="string", length=50, nullable=false)
     */
    private $empName;

    /**
     * @var string
     *
     * @ORM\Column(name="emp_mbl1", type="string", length=15, nullable=false)
     */
    private $empMbl1;

    /**
     * @var string
     *
     * @ORM\Column(name="emp_mbl2", type="string", length=15, nullable=false)
     */
    private $empMbl2;

    /**
     * @var string
     *
     * @ORM\Column(name="emp_door_no", type="string", length=15, nullable=false)
     */
    private $empDoorNo;

    /**
     * @var string
     *
     * @ORM\Column(name="emp_street1", type="string", length=50, nullable=false)
     */
    private $empStreet1;

    /**
     * @var string
     *
     * @ORM\Column(name="emp_street2", type="string", length=50, nullable=false)
     */
    private $empStreet2;

    /**
     * @var string
     *
     * @ORM\Column(name="emp_city", type="string", length=50, nullable=false)
     */
    private $empCity;

    /**
     * @var string
     *
     * @ORM\Column(name="emp_state", type="string", length=50, nullable=false)
     */
    private $empState;

    /**
     * @var string
     *
     * @ORM\Column(name="doc_ext", type="string", length=5, nullable=false)
     */
    private $docExt;

    /**
     * @var string
     *
     * @ORM\Column(name="nric", type="string", length=30, nullable=false)
     */
    private $nric;

    /**
     * @var string
     *
     * @ORM\Column(name="doc_no", type="string", length=30, nullable=false)
     */
    private $docNo;

    /**
     * @var string
     *
     * @ORM\Column(name="emp_dept", type="string", length=50, nullable=false)
     */
    private $empDept;

    /**
     * @var string
     *
     * @ORM\Column(name="role_status", type="string", length=1, nullable=false, options={"default"="'1'","comment"="1 - Active, 0 - In-Active"})
     */
    private $roleStatus = '\'1\'';

    /**
     * @var string
     *
     * @ORM\Column(name="action_type", type="string", length=10, nullable=false, options={"comment"="inst - Insert, edit - Edit, dlt - Delete, role - Role Status"})
     */
    private $actionType;

    /**
     * @var string
     *
     * @ORM\Column(name="active_row", type="string", length=3, nullable=false, options={"comment"="Lat - Latest Row, Old - Old Row"})
     */
    private $activeRow;

    /**
     * @var int
     *
     * @ORM\Column(name="post_by", type="integer", nullable=false)
     */
    private $postBy;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="post_dt", type="datetime", nullable=false)
     */
    private $postDt;

    /**
     * @var int
     *
     * @ORM\Column(name="update_by", type="integer", nullable=false)
     */
    private $updateBy;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="update_dt", type="datetime", nullable=false)
     */
    private $updateDt;

    public function getEmpId(): ?int
    {
        return $this->empId;
    }

    public function getEmpRfrncId(): ?int
    {
        return $this->empRfrncId;
    }

    public function setEmpRfrncId(int $empRfrncId): self
    {
        $this->empRfrncId = $empRfrncId;

        return $this;
    }

    public function getEid(): ?string
    {
        return $this->eid;
    }

    public function setEid(string $eid): self
    {
        $this->eid = $eid;

        return $this;
    }

    public function getEmpName(): ?string
    {
        return $this->empName;
    }

    public function setEmpName(string $empName): self
    {
        $this->empName = $empName;

        return $this;
    }

    public function getEmpMbl1(): ?string
    {
        return $this->empMbl1;
    }

    public function setEmpMbl1(string $empMbl1): self
    {
        $this->empMbl1 = $empMbl1;

        return $this;
    }

    public function getEmpMbl2(): ?string
    {
        return $this->empMbl2;
    }

    public function setEmpMbl2(string $empMbl2): self
    {
        $this->empMbl2 = $empMbl2;

        return $this;
    }

    public function getEmpDoorNo(): ?string
    {
        return $this->empDoorNo;
    }

    public function setEmpDoorNo(string $empDoorNo): self
    {
        $this->empDoorNo = $empDoorNo;

        return $this;
    }

    public function getEmpStreet1(): ?string
    {
        return $this->empStreet1;
    }

    public function setEmpStreet1(string $empStreet1): self
    {
        $this->empStreet1 = $empStreet1;

        return $this;
    }

    public function getEmpStreet2(): ?string
    {
        return $this->empStreet2;
    }

    public function setEmpStreet2(string $empStreet2): self
    {
        $this->empStreet2 = $empStreet2;

        return $this;
    }

    public function getEmpCity(): ?string
    {
        return $this->empCity;
    }

    public function setEmpCity(string $empCity): self
    {
        $this->empCity = $empCity;

        return $this;
    }

    public function getEmpState(): ?string
    {
        return $this->empState;
    }

    public function setEmpState(string $empState): self
    {
        $this->empState = $empState;

        return $this;
    }

    public function getDocExt(): ?string
    {
        return $this->docExt;
    }

    public function setDocExt(string $docExt): self
    {
        $this->docExt = $docExt;

        return $this;
    }

    public function getNric(): ?string
    {
        return $this->nric;
    }

    public function setNric(string $nric): self
    {
        $this->nric = $nric;

        return $this;
    }

    public function getDocNo(): ?string
    {
        return $this->docNo;
    }

    public function setDocNo(string $docNo): self
    {
        $this->docNo = $docNo;

        return $this;
    }

    public function getEmpDept(): ?string
    {
        return $this->empDept;
    }

    public function setEmpDept(string $empDept): self
    {
        $this->empDept = $empDept;

        return $this;
    }

    public function getRoleStatus(): ?string
    {
        return $this->roleStatus;
    }

    public function setRoleStatus(string $roleStatus): self
    {
        $this->roleStatus = $roleStatus;

        return $this;
    }

    public function getActionType(): ?string
    {
        return $this->actionType;
    }

    public function setActionType(string $actionType): self
    {
        $this->actionType = $actionType;

        return $this;
    }

    public function getActiveRow(): ?string
    {
        return $this->activeRow;
    }

    public function setActiveRow(string $activeRow): self
    {
        $this->activeRow = $activeRow;

        return $this;
    }

    public function getPostBy(): ?int
    {
        return $this->postBy;
    }

    public function setPostBy(int $postBy): self
    {
        $this->postBy = $postBy;

        return $this;
    }

    public function getPostDt(): ?\DateTimeInterface
    {
        return $this->postDt;
    }

    public function setPostDt(\DateTimeInterface $postDt): self
    {
        $this->postDt = $postDt;

        return $this;
    }

    public function getUpdateBy(): ?int
    {
        return $this->updateBy;
    }

    public function setUpdateBy(int $updateBy): self
    {
        $this->updateBy = $updateBy;

        return $this;
    }

    public function getUpdateDt(): ?\DateTimeInterface
    {
        return $this->updateDt;
    }

    public function setUpdateDt(\DateTimeInterface $updateDt): self
    {
        $this->updateDt = $updateDt;

        return $this;
    }


}
