<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Customers
 *
 * @ORM\Table(name="customers")
 * @ORM\Entity
 */
class Customers
{
    /**
     * @var int
     *
     * @ORM\Column(name="customer_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $customerId;

    /**
     * @var string
     *
     * @ORM\Column(name="cid", type="string", length=10, nullable=false, options={"comment"="cid - Customer ID Auto Generate"})
     */
    private $cid;

    /**
     * @var string
     *
     * @ORM\Column(name="first_name", type="string", length=100, nullable=false)
     */
    private $firstName;

    /**
     * @var string
     *
     * @ORM\Column(name="last_name", type="string", length=100, nullable=false)
     */
    private $lastName;

    /**
     * @var string
     *
     * @ORM\Column(name="mbl1", type="string", length=15, nullable=false)
     */
    private $mbl1;

    /**
     * @var string
     *
     * @ORM\Column(name="mbl2", type="string", length=15, nullable=false)
     */
    private $mbl2;

    /**
     * @var string
     *
     * @ORM\Column(name="email_id", type="string", length=100, nullable=false)
     */
    private $emailId;

    /**
     * @var string
     *
     * @ORM\Column(name="password", type="string", length=50, nullable=false)
     */
    private $password;

    /**
     * @var string
     *
     * @ORM\Column(name="profile_img", type="string", length=5, nullable=false)
     */
    private $profileImg;

    /**
     * @var string
     *
     * @ORM\Column(name="street", type="text", length=65535, nullable=false)
     */
    private $street;

    /**
     * @var string
     *
     * @ORM\Column(name="country", type="string", length=25, nullable=false)
     */
    private $country;

    /**
     * @var string
     *
     * @ORM\Column(name="zipcode", type="string", length=15, nullable=false)
     */
    private $zipcode;

    /**
     * @var string
     *
     * @ORM\Column(name="care_more", type="string", length=3, nullable=false, options={"default"="'no'","comment"="Yes, No - (problematic clients highlighted by 'Yes' to care more)"})
     */
    private $careMore = '\'no\'';

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="post_dt", type="datetime", nullable=false)
     */
    private $postDt;

    /**
     * @var int
     *
     * @ORM\Column(name="update_by", type="integer", nullable=false)
     */
    private $updateBy;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="update_dt", type="datetime", nullable=false)
     */
    private $updateDt;

    public function getCustomerId(): ?int
    {
        return $this->customerId;
    }

    public function getCid(): ?string
    {
        return $this->cid;
    }

    public function setCid(string $cid): self
    {
        $this->cid = $cid;

        return $this;
    }

    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    public function setFirstName(string $firstName): self
    {
        $this->firstName = $firstName;

        return $this;
    }

    public function getLastName(): ?string
    {
        return $this->lastName;
    }

    public function setLastName(string $lastName): self
    {
        $this->lastName = $lastName;

        return $this;
    }

    public function getMbl1(): ?string
    {
        return $this->mbl1;
    }

    public function setMbl1(string $mbl1): self
    {
        $this->mbl1 = $mbl1;

        return $this;
    }

    public function getMbl2(): ?string
    {
        return $this->mbl2;
    }

    public function setMbl2(string $mbl2): self
    {
        $this->mbl2 = $mbl2;

        return $this;
    }

    public function getEmailId(): ?string
    {
        return $this->emailId;
    }

    public function setEmailId(string $emailId): self
    {
        $this->emailId = $emailId;

        return $this;
    }

    public function getPassword(): ?string
    {
        return $this->password;
    }

    public function setPassword(string $password): self
    {
        $this->password = $password;

        return $this;
    }

    public function getProfileImg(): ?string
    {
        return $this->profileImg;
    }

    public function setProfileImg(string $profileImg): self
    {
        $this->profileImg = $profileImg;

        return $this;
    }

    public function getStreet(): ?string
    {
        return $this->street;
    }

    public function setStreet(string $street): self
    {
        $this->street = $street;

        return $this;
    }

    public function getCountry(): ?string
    {
        return $this->country;
    }

    public function setCountry(string $country): self
    {
        $this->country = $country;

        return $this;
    }

    public function getZipcode(): ?string
    {
        return $this->zipcode;
    }

    public function setZipcode(string $zipcode): self
    {
        $this->zipcode = $zipcode;

        return $this;
    }

    public function getCareMore(): ?string
    {
        return $this->careMore;
    }

    public function setCareMore(string $careMore): self
    {
        $this->careMore = $careMore;

        return $this;
    }

    public function getPostDt(): ?\DateTimeInterface
    {
        return $this->postDt;
    }

    public function setPostDt(\DateTimeInterface $postDt): self
    {
        $this->postDt = $postDt;

        return $this;
    }

    public function getUpdateBy(): ?int
    {
        return $this->updateBy;
    }

    public function setUpdateBy(int $updateBy): self
    {
        $this->updateBy = $updateBy;

        return $this;
    }

    public function getUpdateDt(): ?\DateTimeInterface
    {
        return $this->updateDt;
    }

    public function setUpdateDt(\DateTimeInterface $updateDt): self
    {
        $this->updateDt = $updateDt;

        return $this;
    }


}
