<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class ShowcaseController extends AbstractController
{

/**
 * @Route("/mould-showcase", name="mould-showcase", methods={"GET","POST"})
 */
public function IndexActions(Request $request) 
{
	$session = $request->getSession();
    $session_user = $session->get('admin_id');
    $loginId = $session->get('loginId');

    if (!$session->has('login')) {
        return $this->redirectToRoute('login');
    }

    $connection = $this->getDoctrine()->getManager()->getConnection();

    // Fetch CAD types
    $QURYcad = "SELECT * FROM master_cad_type WHERE statu_s='active' ORDER BY master_cad_type_id ASC";
    $CONNcad = $connection->executeQuery($QURYcad);
    $FTCHcad = $CONNcad->fetchAll();
	$filter_arr = array();

	foreach($FTCHcad as $cadfltr){
		$selPlcat  = "SELECT distinct(d.master_cat_id),mc.cat_name FROM mas_finishing as m,show_case as s,design_det as d,master_cat as mc WHERE mc.master_cat_id = d.master_cat_id and mc.master_cad_type_id='".$cadfltr['master_cad_type_id']."' and mc.category='plain' AND d.design_det_id = s.design_det_id AND d.statu_s='active' AND d.up_status='no' AND s.up_status='no' AND m.design_det_id = s.design_det_id AND m.up_status='no' AND s.design_det_id NOT IN(SELECT pd.design_det_id FROM po_entry_det AS pd,po_entry AS p WHERE p.party_det_id = '".$loginId."' AND pd.po_entry_id = p.po_entry_id AND p.cancelled='no') AND s.design_det_id NOT IN (SELECT design_det_id FROM design_sel_det WHERE party_det_id = '".$loginId."' AND ord_status='no') ORDER BY mc.cat_name";
		$CONNPlcat = $connection->executeQuery($selPlcat);
		$FTCHPlcat = $CONNPlcat->fetchAll();
		$filter_arr[$cadfltr['master_cad_type_id']]['Plain'] = $FTCHPlcat;

		$selStcat  = "SELECT distinct(d.master_cat_id),mc.cat_name FROM mas_finishing as m,show_case as s,design_det as d,master_cat as mc WHERE mc.master_cat_id = d.master_cat_id and mc.master_cad_type_id='".$cadfltr['master_cad_type_id']."' and mc.category='stone' AND d.design_det_id = s.design_det_id AND d.statu_s='active' AND d.up_status='no' AND s.up_status='no' AND m.design_det_id = s.design_det_id AND m.up_status='no' AND s.design_det_id NOT IN(SELECT pd.design_det_id FROM po_entry_det AS pd,po_entry AS p WHERE p.party_det_id = '".$loginId."' AND pd.po_entry_id = p.po_entry_id AND p.cancelled='no') AND s.design_det_id NOT IN (SELECT design_det_id FROM design_sel_det WHERE party_det_id = '".$loginId."' AND ord_status='no') ORDER BY mc.cat_name";
		$CONNStcat = $connection->executeQuery($selStcat);
		$FTCHStcat = $CONNStcat->fetchAll();
		$filter_arr[$cadfltr['master_cad_type_id']]['Stone'] = $FTCHStcat;
	}
    $search_by = '';
	$loginId = $request->getSession()->get('loginId');

    // -------------------------------
    // COMMON VARIABLES
    // -------------------------------
    $limit = 20;
	$page  = (int) $request->query->get('page', 0);
	$offset = $page * $limit;

    $search_by = '';
    $search_wt_by = '';
    $isAjax = $request->isXmlHttpRequest();
    $lastId = $request->query->get('last_id');

   // $offset = 0;
	$mas_cat='';
	$mas_subcat='';
	$mas_wgt='';
	$designType='';
	$cadTypeId  = $request->get('master_cad_type', '');
	$mas_subcat_arr='';

	if ($isAjax) {
		// AJAX values (GET query)
		$designType = $request->query->get('design_type', '');
		$mas_cat    = $request->query->get('mas_cat', '');
		$mas_subcat = $request->query->get('mas_subcat', '');
		$cadTypeId  = $request->query->get('master_cad_type', '');
        $mas_subcat_arr = (array) $request->request->get('mas_subcat', []);
        //$mas_subcat = implode(',', $mas_subcat_arr);
        $weightfrom    = $request->query->get('weightfrom', '');
		$weightto    = $request->query->get('weightto', '');
if(is_array($mas_subcat)){
			// case: categories[]=20&categories[]=104
			$mas_subcat_arr = array_map('intval', $mas_subcat);
		}else{
			// case: categories="20,104"
			$mas_subcat_arr = array_map('intval', explode(',', $mas_subcat));
		}

		$mas_subcat = implode(',', $mas_subcat_arr);
			if ($designType) {
				$search_by .= " AND mc.category='".$designType."'";
			}
			if ($mas_cat) {
				$search_by .= " AND mc.master_cat_id='".$mas_cat."'";
			}
			if ($mas_subcat) {
			  /*  $mas_subcat1 = explode(',',$mas_subcat);
			    $mc_arr_sub='';
			    for($m=0;$m<count($mas_subcat1);$m++){
			        $mc_arr_sub .= "'".$mas_subcat1[$m]."',";
			    }
			    $mas_subcat  =substr($mas_subcat,0,-1);
				$search_by .= " AND d.master_sub_category_id IN ('".$mas_subcat."')";*/
							        $mas_subcat_arr = array_map('intval', explode(',', $mas_subcat));
    $search_by .= " AND d.master_sub_category_id IN (" . implode(',', $mas_subcat_arr) . ")";

			}
			if($cadTypeId!=''){
				$search_by .= " AND mc.master_cad_type_id='".$cadTypeId."'";
			}

			/*if($weightfrom!='' && $weightto!=''){
			    $search_by .= " AND m.mas_weight BETWEEN ".$weightfrom." AND ".$weightto."";
			}*/

			if ($weightfrom > 0 && $weightto > 0) {
				if ($weightfrom == $weightto) {
					//$search_by .= " AND m.mas_weight = " . (float)$weightfrom;
					$search_wt_by .= " AND CAST(m.mas_weight AS DECIMAL(10,2)) = ".$weightfrom."";
				} else {
				//	$search_by .= " AND m.mas_weight BETWEEN " . (float)$weightfrom . " AND " . (float)$weightto;
				$search_wt_by .= " AND m.mas_weight >= (".$weightfrom."- 0.001) AND m.mas_weight <= ".$weightto."";
				}
			}
	} else {
		// POST values (form submit)
		$designType = $request->request->get('design_type', '');
		$mas_cat    = $request->request->get('select-cat', '');
		$mas_subcat = $request->request->get('categories', '');
		$mas_wgt    = $request->request->get('select-wgt', '');
		$cadTypeId  = $request->request->get('master_cad_type', '');

    	$weightfrom = $request->request->get('weightfrom');
        $weightto   = $request->request->get('weightto');

		/*$mas_subcat_arr = (array) $request->request->get('categories', []);
        $mas_subcat = implode(',', $mas_subcat_arr);*/

		$mas_subcat = $request->request->get('categories', []);
		/*$mas_subcat1 = $request->request->get('mas_subcat', []);
		print_r($mas_subcat1);*/

		if(is_array($mas_subcat)){
			// case: categories[]=20&categories[]=104
			$mas_subcat_arr = array_map('intval', $mas_subcat);
		}else{
			// case: categories="20,104"
			$mas_subcat_arr = array_map('intval', explode(',', $mas_subcat));
		}

		$mas_subcat = implode(',', $mas_subcat_arr);

			if ($designType) {
				$search_by .= " AND mc.category='".$designType."'";
			}
			if ($mas_cat) {
				$search_by .= " AND mc.master_cat_id='".$mas_cat."'";
			}
			if ($mas_subcat) {
			    /* $mas_subcat1 = explode(',',$mas_subcat);
			    $mc_arr_sub='';
			    for($m=0;$m<count($mas_subcat1);$m++){
			        $mc_arr_sub .= "'".$mas_subcat1[$m]."',";
			    }
			    $mas_subcat  =substr($mc_arr_sub,0,-1);*/
			        $mas_subcat_arr = array_map('intval', explode(',', $mas_subcat));
    $search_by .= " AND d.master_sub_category_id IN (" . implode(',', $mas_subcat_arr) . ")";

			//	$search_by .= " AND d.master_sub_category_id IN (".$mas_subcat.")";
			}
			if($cadTypeId!=''){
				$search_by .= " AND mc.master_cad_type_id='".$cadTypeId."'";
			}
			/*if($weightfrom!='' && $weightto!=''){
			    $search_by .= " AND m.mas_weight BETWEEN ".$weightfrom." AND ".$weightto."";
			}*/

			if ($weightfrom > 0 && $weightto > 0) {
				if ($weightfrom == $weightto) {
					//$search_by .= " AND m.mas_weight = " . (float)$weightfrom;
					$search_wt_by .= " AND CAST(m.mas_weight AS DECIMAL(10,2)) = ".$weightfrom."";
				} else {
					//$search_by .= " AND m.mas_weight BETWEEN " .(float)$weightfrom . " AND " . (float)$weightto;
					$search_wt_by .= " AND m.mas_weight >= (".$weightfrom."- 0.001) AND m.mas_weight <= ".$weightto."";
				}
			}
	}

//print_r($mas_subcat_arr);

		if($cadTypeId==''){
			$cadTypeId = $FTCHcad[0]['master_cad_type_id']; 
		}

		//$selscat = "SELECT MSC.master_sub_category_id, MSC.sub_category_name FROM `design_det` AS DD, master_sub_category AS MSC,master_cat as MC WHERE DD.`master_cat_id` = '".$mas_cat."' AND MSC.master_sub_category_id = DD.`master_sub_category_id`  GROUP BY MSC.sub_category_name ORDER BY MSC.sub_category_name ASC";
		$search_sub_by='';
		if ($mas_cat!='') {
            $search_sub_by .= " AND mc.master_cat_id='".$mas_cat."'";
        }

	//	$selscat = "SELECT DISTINCT msc.master_sub_category_id, msc.sub_category_name FROM master_cat mc INNER JOIN design_det dd ON dd.master_cat_id = mc.master_cat_id INNER JOIN master_sub_category msc ON msc.master_sub_category_id = dd.master_sub_category_id WHERE mc.master_cad_type_id = '".$cadTypeId."' ".$search_sub_by." and dd.statu_s='active' and dd.up_status='no' ORDER BY msc.sub_category_name";
	    $selscat = "SELECT DISTINCT msc.master_sub_category_id, msc.sub_category_name FROM master_cat mc INNER JOIN design_det dd ON dd.master_cat_id = mc.master_cat_id INNER JOIN master_sub_category msc ON msc.master_sub_category_id = dd.master_sub_category_id WHERE mc.master_cad_type_id = '".$cadTypeId."' ".$search_sub_by." and dd.statu_s='active' and dd.up_status='no' and dd.design_det_id IN(SELECT distinct(d.design_det_id) FROM mas_finishing as m,show_case as s,design_det as d,master_cat as mc WHERE mc.master_cat_id = d.master_cat_id  AND d.design_det_id = s.design_det_id AND d.statu_s='active' AND d.up_status='no' AND s.up_status='no' AND m.design_det_id = s.design_det_id AND m.up_status='no' AND s.design_det_id NOT IN(SELECT pd.design_det_id FROM po_entry_det AS pd,po_entry AS p WHERE p.party_det_id = '".$loginId."' AND pd.po_entry_id = p.po_entry_id AND p.cancelled='no') AND s.design_det_id NOT IN (SELECT design_det_id FROM design_sel_det WHERE party_det_id = '".$loginId."' AND ord_status='no') ORDER BY s.show_case_id DESC) ORDER BY msc.sub_category_name ";
		$CONNscat = $connection->executeQuery($selscat);
		$FTCHscat = $CONNscat->fetchAll();

		// Fetch designs
		if($cadTypeId!=''){
			$search_by .= " AND mc.master_cad_type_id='".$cadTypeId."'";
		}

		// Fetch Design types
		$QURYdesgn = "SELECT * FROM master_cat WHERE master_cad_type_id='".$cadTypeId."' group by category";
		$CONNdesgn = $connection->executeQuery($QURYdesgn);
		$FTCHdesgn = $CONNdesgn->fetchAll();

	   $QURYdesg = "SELECT d.mas_fin_ext, d.cad_fin_ext,d.imag_ext, s.show_case_id, mc.master_cat_name,mc.category, d.design_no, FORMAT(m.mas_weight,2) as mas_weight,s.master_cat_id, s.design_det_id 
	   FROM mas_finishing as m,show_case as s,design_det as d,master_cat  as mc WHERE mc.master_cat_id = d.master_cat_id  ".$search_by." ".$search_wt_by." AND d.design_det_id = s.design_det_id AND d.statu_s='active'
	   AND d.up_status='no' AND s.up_status='no' AND m.design_det_id = s.design_det_id AND m.up_status='no' AND s.design_det_id NOT IN(SELECT pd.design_det_id FROM po_entry_det AS pd,po_entry AS p WHERE p.party_det_id = ".$loginId." AND pd.po_entry_id = p.po_entry_id AND p.cancelled='no') AND s.design_det_id NOT IN (SELECT design_det_id FROM design_sel_det WHERE party_det_id = ".$loginId." AND ord_status='no') ORDER BY s.show_case_id DESC LIMIT ".$offset.",".$limit;
 
		$CONNdesg = $connection->executeQuery($QURYdesg);
		$FTCHdesg = $CONNdesg->fetchAll();

		//get counts

		$QURYdesgcnt = "SELECT d.mas_fin_ext, d.cad_fin_ext, d.imag_ext, s.show_case_id, mc.master_cat_name,mc.category, d.design_no, FORMAT(m.mas_weight,2) as mas_weight, s.master_cat_id, s.design_det_id FROM mas_finishing as m,show_case as s,design_det as d,master_cat  as mc WHERE mc.master_cat_id = d.master_cat_id  ".$search_by." ".$search_wt_by." AND d.design_det_id = s.design_det_id AND d.statu_s='active' AND d.up_status='no' AND s.up_status='no' AND m.design_det_id = s.design_det_id AND m.up_status='no' AND s.design_det_id NOT IN(SELECT pd.design_det_id FROM po_entry_det AS pd,po_entry AS p WHERE p.party_det_id = ".$loginId." AND pd.po_entry_id = p.po_entry_id AND p.cancelled='no') AND s.design_det_id NOT IN (SELECT design_det_id FROM design_sel_det WHERE party_det_id = ".$loginId." AND ord_status='no') ORDER BY s.show_case_id DESC";

		$CONNdesgcnt = $connection->executeQuery($QURYdesgcnt);
		$FTCHdesgcnt = $CONNdesgcnt->fetchAll();

		$total_designs = count($FTCHdesgcnt);

    // Fetch other dropdowns (categories, subcategories, weights)
	$cat_search = "";
	$mas_cat_srch = "";
	$mas_scat_srch="";
	if($cadTypeId!='')
			{
				$cat_search .= " WHERE MC.master_cad_type_id=".$cadTypeId;

				$QURYdesgcntmc = "SELECT mc.`master_cat_id` FROM `master_cat` AS mc where master_cad_type_id='".$cadTypeId."'";
				$CONNdesgcntmc = $connection->executeQuery($QURYdesgcntmc);
				$FTCHdesgcntmc = $CONNdesgcntmc->fetchAll();

				$mas_cat_srch .= " AND DD.master_cat_id='".$FTCHdesgcntmc[0]['master_cat_id']."'";
				//$mas_scat_srch.= " AND d.master_cat_id='".$FTCHdesgcntmc[0]['master_cat_id']."'";
			}


    $FTCHdescat = $connection->executeQuery("SELECT MC.* FROM mas_finishing AS MS
                                            JOIN design_det AS DD ON MS.design_det_id = DD.design_det_id
                                            JOIN master_cat MC ON DD.master_cat_id = MC.master_cat_id
                                            JOIN show_case SC ON MS.design_det_id = SC.design_det_id ".$cat_search."
                                            GROUP BY MC.cat_name ORDER BY MC.master_cat_id ASC")->fetchAll();

	if($mas_cat!='')
			{
				$mas_cat_srch .= " AND DD.master_cat_id='".$mas_cat."'";	
			}

    $FTCHdesscat = $connection->executeQuery("SELECT MSC.master_sub_category_id, MSC.sub_category_name
                                             FROM design_det AS DD
                                             JOIN master_sub_category AS MSC ON MSC.master_sub_category_id = DD.master_sub_category_id where 1 ".$mas_cat_srch."
                                             GROUP BY MSC.sub_category_name ORDER BY MSC.sub_category_name ASC")->fetchAll();
	if($mas_subcat!='')
			{
				$mas_scat_srch .= " AND d.master_sub_category_id='".$mas_subcat."'";	
			}

	if($mas_cat!='')
			{
				$mas_scat_srch .= " AND d.master_cat_id='".$mas_cat."'";	
			}

    $FTCHdeswgt = $connection->executeQuery("SELECT CONCAT(FLOOR(m.mas_weight), '.00') AS startVal, CONCAT(FLOOR(m.mas_weight) + .99) AS endVal
                                            FROM mas_finishing AS m
                                            JOIN show_case AS s ON m.design_det_id = s.design_det_id
                                            JOIN design_det AS d ON d.design_det_id = s.design_det_id
                                            JOIN master_cat AS mc ON mc.master_cat_id = d.master_cat_id
                                            WHERE d.statu_s='active' AND d.up_status='no' AND s.up_status='no' AND m.up_status='no' ".$mas_scat_srch." GROUP BY FLOOR(m.mas_weight) ORDER BY FLOOR(m.mas_weight) ASC")->fetchAll();

  
   $FTCHdeswgt1 = $connection->executeQuery("
    SELECT 
        d.mas_fin_ext,
        d.cad_fin_ext,
        d.imag_ext,
        s.show_case_id,
        mc.master_cat_name,
        mc.category,
        d.design_no,
        FORMAT(m.mas_weight,2) AS mas_weight,
        s.master_cat_id,
        s.design_det_id
    FROM mas_finishing AS m
    JOIN show_case AS s ON m.design_det_id = s.design_det_id
    JOIN design_det AS d ON d.design_det_id = s.design_det_id
    JOIN master_cat AS mc ON mc.master_cat_id = d.master_cat_id
    WHERE d.statu_s = 'active'
      AND d.up_status = 'no'
      AND s.up_status = 'no'
      AND m.up_status = 'no'
      $search_by
      AND s.design_det_id NOT IN (
          SELECT pd.design_det_id
          FROM po_entry_det AS pd
          JOIN po_entry AS p ON pd.po_entry_id = p.po_entry_id
          WHERE p.party_det_id = $loginId
            AND p.cancelled = 'no'
      )
      AND s.design_det_id NOT IN (
          SELECT design_det_id
          FROM design_sel_det
          WHERE party_det_id = $loginId
            AND ord_status = 'no'
      ) and m.mas_weight!='0' group by m.mas_weight order by m.mas_weight
")->fetchAll();

 			$FTCHdeswgt1 = array_column($FTCHdeswgt1, 'mas_weight');


    $wg_dropdown = '';
    foreach ($FTCHdeswgt as $wgt) {
        $wgt_range = $wgt['startVal'] . '-' . $wgt['endVal'];
        $wg_dropdown .= "<option value='" . $wgt_range . "'>" . $wgt_range . "</option>";
    }

    
    $wg_dropdown = '';
    foreach ($FTCHdeswgt as $wgt) {
        $wgt_range = $wgt['startVal'] . '-' . $wgt['endVal'];
        $wg_dropdown .= "<option value='" . $wgt_range . "'>" . $wgt_range . "</option>";
    }

	$wg_dropdownqry = "";
	$design_images = array();
    // Prepare height, width, and stone details for designs
    $hwdesgnhgt = $hwdesgnwigt = $empsize = $cart_item = [];
    foreach($FTCHdesg as $desg) {
        $FTCHhw = $connection->executeQuery("SELECT * FROM emp_current_design WHERE design_det_id='" . $desg['design_det_id'] . "'")->fetchAll();
        $hwdesgnhgt[$desg['design_det_id']] = $FTCHhw[0]['design_height'] ?? '';
        $hwdesgnwigt[$desg['design_det_id']] = $FTCHhw[0]['design_width'] ?? '';

        $FTCHempcrt = $connection->executeQuery("SELECT * FROM des_sel_temp_des WHERE design_det_id='" . $desg['design_det_id'] . "' AND party_det_id='" . $loginId . "'")->fetchAll();
        $cart_item[$desg['design_det_id']] = count($FTCHempcrt);

        $FTCHempcrnt = $connection->executeQuery("SELECT * FROM emp_current_design_stone WHERE design_det_id='" . $desg['design_det_id'] . "'")->fetchAll();
        $stoneRows = [];
        foreach ($FTCHempcrnt as $empcrnt) {
            $stoneRows[] = [
                'shape' => $this->getShapeName($empcrnt['mas_stone_cat_id']),
                'size' => $this->getSizeName($empcrnt['mas_stone_type_id']),
                'quantity' => $empcrnt['quantity'],
                'stone_weight' => $empcrnt['stone_weight'],
                'total_weight' => $empcrnt['total_weight'],
            ];
        }
        $empsize[$desg['design_det_id']] = $stoneRows;
    }

    $cart_count = $this->cart_count($loginId);
 

	if ($isAjax) {
		return $this->render('mdshowcase/mdshowcase_load.html.twig', [
			'FTCHdesg' => $FTCHdesg,
			'QURYdesg'=>$QURYdesg,
			'empsize' => $empsize,
			'weightfrom'=>$weightfrom,
			'weightto'=>$weightto,
			'mas_subcat'=>$mas_subcat,
			'total'=>count($FTCHdesg),
			'cart_item' => $cart_item,
			'hwdesgnhgt' => $hwdesgnhgt,
			'hwdesgnwigt' => $hwdesgnwigt,
		]);
	}

    // Render template
    return $this->render('mdshowcase/mdshowcase.html.twig', [
        'FTCHcad' => $FTCHcad,
		'FTCHscat'=>$FTCHscat,
		'mas_subcat_arr'=>$mas_subcat_arr,
		'mas_cat'=>$mas_cat,
		'QURYdesg'=>$QURYdesg,
		'FTCHdesgn'=>$FTCHdesgn,
		'designType'=>$designType,
		'mas_subcat'=>$mas_subcat,
		'FTCHdeswgt1'=>$FTCHdeswgt1,
		'weightfrom'=>$weightfrom,
		'weightto'=>$weightto,
		'mas_wgt'=>$mas_wgt,
		'filter_arr'=>$filter_arr,
		'activeType'=>$cadTypeId,
        'FTCHdesg' => $FTCHdesg,
        'empsize' => $empsize,
		'wg_dropdownqry'=>$wg_dropdownqry,
        'cart_item' => $cart_item,
        'hwdesgnhgt' => $hwdesgnhgt,
        'hwdesgnwigt' => $hwdesgnwigt,
        'FTCHdescat' => $FTCHdescat,
        'subcat' => $FTCHdesscat,
        'deswgt' => $FTCHdeswgt,
        'cart_count' => $cart_count,
        'dropdown' => $wg_dropdown,
        'total_designs' => $total_designs,
        'controller_name' => 'ShowcaseController',
    ]);

}

	function getShapeName($stone_cat_id){
		$connection= $this->getDoctrine()->getManager()->getConnection();
			$selempcrnt  = "select * from mas_stone_cat where mas_stone_cat_id='".$stone_cat_id."'";
			$CONNempcrnt = $connection->executeQuery($selempcrnt);
			$FTCHempcrnt = $CONNempcrnt->fetchAll();
			
			$cat_name='';
			if(count($FTCHempcrnt)>0){
			 $cat_name = $FTCHempcrnt[0]['cat_name'];
			}
			
			return $cat_name;
	}

	function getSizeName($stone_type_id){
		$connection= $this->getDoctrine()->getManager()->getConnection();
			$selempcrnt  = "select * from mas_stone_type where mas_stone_type_id='".$stone_type_id."'";
			$CONNempcrnt = $connection->executeQuery($selempcrnt);
			$FTCHempcrnt = $CONNempcrnt->fetchAll();
			$stone_name='';
			if(count($FTCHempcrnt)>0){
			 $stone_name = $FTCHempcrnt[0]['stone_name'];
			}
			
			return $stone_name;
	}

	/** 
	* @Route("/get_filter_dropdown", name="get_filter_dropdown")
	*/
	public function get_filter_dropdownLists(Request $request) 
	{
		$connection   = $this->getDoctrine()->getManager()->getConnection();
		$dtId =  $request->get('design_det');
 		$session = $request->getSession();
		$login_id =  $session->get('loginId');
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		$cadTypeId = $request->get('master_cad_type_id');
		$filter_cat = $request->get('filter_cat');

		// Fetch Design types
		$QURYdesgn = "SELECT * FROM master_cat WHERE master_cad_type_id='".$cadTypeId."' group by category";
		$CONNdesgn = $connection->executeQuery($QURYdesgn);
		$FTCHdesgn = $CONNdesgn->fetchAll();

		$FTCHdescat = $connection->executeQuery("SELECT MC.* FROM mas_finishing AS MS
					JOIN design_det AS DD ON MS.design_det_id = DD.design_det_id
					JOIN master_cat MC ON DD.master_cat_id = MC.master_cat_id
					JOIN show_case SC ON MS.design_det_id = SC.design_det_id WHERE MC.master_cad_type_id='".$cadTypeId."' GROUP BY MC.cat_name ORDER BY MC.master_cat_id ASC")->fetchAll();

		$FTCHdesscat = $connection->executeQuery("SELECT MSC.master_sub_category_id, MSC.sub_category_name
                            FROM design_det AS DD JOIN master_sub_category AS MSC ON MSC.master_sub_category_id = DD.master_sub_category_id where 1   GROUP BY MSC.sub_category_name ORDER BY MSC.sub_category_name ASC")->fetchAll();

		$FTCHdeswgt = $connection->executeQuery("SELECT CONCAT(FLOOR(m.mas_weight), '.00') AS startVal, CONCAT(FLOOR(m.mas_weight) + .99) AS endVal
                                            FROM mas_finishing AS m
                                            JOIN show_case AS s ON m.design_det_id = s.design_det_id
                                            JOIN design_det AS d ON d.design_det_id = s.design_det_id
                                            JOIN master_cat AS mc ON mc.master_cat_id = d.master_cat_id
                                            WHERE d.statu_s='active' AND d.up_status='no' AND s.up_status='no' AND m.up_status='no' AND mc.master_cad_type_id='".$cadTypeId."'
                                            GROUP BY FLOOR(m.mas_weight) ORDER BY FLOOR(m.mas_weight) ASC")->fetchAll();

		$wg_dropdown = '<option ';
		foreach ($FTCHdeswgt as $wgt) {
			$wgt_range = $wgt['startVal'] . '-' . $wgt['endVal'];
			$wg_dropdown .= "<option value='" . $wgt_range . "'>" . $wgt_range . "</option>";
		}
 		$filter_lists = '<input type="hidden" id="active_master_cad_type" name="active_master_cad_type" value='.$cadTypeId.'>
					<input type="hidden" id="design_type" name="design_type"  >
					<input type="hidden" id="type" name="type">';
		
		$filter_lists .= ' <div class="gender">
                                <label for="gender" class="caption1 capitalize">Design Type <span class="text-red">*</span></label>
                                <div class="list-size flex items-center flex-wrap gap-3 gap-y-4 mt-4">';
								foreach($FTCHdesgn as $desg){
									$filter_lists .= '<div class="size-item text-button px-4 py-2 flex items-center justify-center rounded-full border border-line  filter-design"
									data-item="'.$desg['category'].'"  onclick="getDsgTye(\''.$desg['category'].'\',this);">'.$desg['category'].'</div>';
								}
        $filter_lists .= '</div>
                            </div>';

		$filter_lists .= '<div class="gender">
                                        <label for="gender" class="caption1 capitalize">Categories <span class="text-red">*</span></label>
                                        <div class="select-block mt-2">
										<span id="fcatList">
                                            <select class="border border-line px-4 py-3 w-full rounded-lg" id="select-cat" name="select-cat" onchange="filtercat(this.value);">
                                                <option value="">Choose Categories</option>';
                            foreach($FTCHdescat as $cat){
								$selc = '';
								if($filter_cat==$cat['master_cat_id']){$selc = 'selected';}
								$filter_lists .= '<option value='.$cat['master_cat_id'].'" '.$selc.'>'.$cat['cat_name'].'</option>';
								}
                                 $filter_lists .= '</select>
										</span>
                                            <span class="ph ph-caret-down arrow-down text-lg"></span>
                                        </div>
                                    </div>';

		$filter_lists .= '<div class="gender">
                                        <label for="gender" class="caption1 capitalize">Sub Categories <span class="text-red">*</span></label>
                                        <div class="select-block mt-2">
										<span id="filter_scat">
                                            <select class="border border-line px-4 py-3 w-full rounded-lg" id="select-subcat" name="select-subcat" onchange="getfilterwgt(this.value);">
                                                <option value="" >Choose Sub Categories</option>';

										foreach($FTCHdesscat as $scat){
											$filter_lists .= '<option value="'.$scat['master_sub_category_id'].'">'.$scat['sub_category_name'].'</option>';
										}

                                          $filter_lists .= '</select></span>
                                            <span class="ph ph-caret-down arrow-down text-lg"></span>
                                        </div>
                                    </div>';

		$filter_lists .= '<div class="gender">
                                        <label for="gender" class="caption1 capitalize">Weight Range <span class="text-red">*</span></label>
                                        <div class="select-block mt-2">
										<span id="wgtlist">
                                            <select class="border border-line px-4 py-3 w-full rounded-lg" id="select-wgt" name="select-wgt">
                                                <option value="">Choose Weight Range</option>
												'.$wg_dropdown.'
                                            </select></span>
                                            <span class="ph ph-caret-down arrow-down text-lg"></span>
                                        </div>
                                    </div>';
									
		$filter_lists .= '<div class="gender">
		<div id="filterErr" style="color:red; font-size:12px;"></div>
                                        <button
    type="button"
    style="background-color:#000;color:#fff;border-radius:10px;margin:10px;padding:10px;"
    id="applyFilterBtn"
    onclick="return validateSearch();">
    Search
</button>

<button
    type="button"
    style="background-color:#000;color:#fff;border-radius:10px;margin:10px;padding:10px;"
    id="viewAllBtn"
    onclick="viewAllResults();">
    View All
</button>

                                    </div>';

		return  new JsonResponse($filter_lists);
	}

	
	
	/** 
	* @Route("/getfiltercatList", name="getfiltercatList")
	*/
	public function getfiltercatList(Request $request) 
	{
		$connection   = $this->getDoctrine()->getManager()->getConnection();
		$dtId =  $request->get('design_det');
 		$session = $request->getSession();
		$login_id =  $session->get('loginId');
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		$master_cad_type_id = $request->get('master_cad_type_id');
		$design_type = $request->get('design_type');
		$cat_html = '<select id="select-cat" name="select-cat" class="caption1 py-2 pl-3 md:pr-20 pr-10 rounded-lg border border-line" onchange="filtercat(this.value);"><option value="">Select</option>';

		$FTCHdescat = $connection->executeQuery("SELECT MC.* FROM mas_finishing AS MS
                                            JOIN design_det AS DD ON MS.design_det_id = DD.design_det_id
                                            JOIN master_cat MC ON DD.master_cat_id = MC.master_cat_id
                                            JOIN show_case SC ON MS.design_det_id = SC.design_det_id  where category='".$design_type."' and master_cad_type_id='".$master_cad_type_id."'
                                            GROUP BY MC.cat_name ORDER BY MC.master_cat_id ASC")->fetchAll();
		foreach ($FTCHdescat as $cat) {
			$cat_html .= '<option value="'.$cat['master_cat_id'].'">'.$cat['cat_name'].'</option>';
		}

		$cat_html .= '</select>';

		return  new JsonResponse($cat_html);

	}

	
	/** 
	* @Route("/design-details", name="design-details")
	*/
	public function designdetails(Request $request) 
	{
		$connection   = $this->getDoctrine()->getManager()->getConnection();
		$dtId =   $request->get('design_det');
 		$session = $request->getSession();
		$login_id =  $session->get('loginId');
		date_default_timezone_set("Asia/Calcutta");
		
			$selempcrnt  = "select * from design_det where design_det_id='".$dtId."'";
			$CONNempcrnt = $connection->executeQuery($selempcrnt);
			$FTCHempcrnt = $CONNempcrnt->fetchAll();

			$selempcat  = "select * from master_cat where master_cat_id='".$FTCHempcrnt[0]['master_cat_id']."'";
			$CONNempcat = $connection->executeQuery($selempcat);
			$FTCHempcat = $CONNempcat->fetchAll();
			
			$selempmwt  = "select FORMAT(mas_weight,2) as mas_weight from mas_finishing where design_det_id='".$dtId."'";
			$CONNempmwt = $connection->executeQuery($selempmwt);
			$FTCHempmwt = $CONNempmwt->fetchAll();

			$design_no = $FTCHempcat[0]['master_cat_name']." ".$FTCHempcrnt[0]['design_no'];
			$design_image  = $FTCHempcrnt[0]['mas_fin_ext'];
			
			$design_percent=0;
			$FTCHemppercent = $connection->executeQuery("SELECT * FROM emp_current_design_stone where  design_det_id='".$dtId."' limit 0,3")->fetchAll();
			$design_percent = ($FTCHemppercent[0]['total_weight'] / $FTCHempmwt[0]['mas_weight']) * 100;
			$design_percent = number_format($design_percent,2);
			$imgurl = 'https://meways.in/';
			$des_img_url = 'mas_fin_images/';
			$cad_img_url = 'cad_fin_images/';
			$mas_img_url = 'design_images/';

			if($FTCHempcrnt[0]['mas_fin_ext']!=''){ $imag = $imgurl.$des_img_url."L.".$FTCHempcrnt[0]['mas_fin_ext']; }
			else if($FTCHempcrnt[0]['cad_fin_ext']!=''){ $imag = $imgurl.$cad_img_url."L.".$FTCHempcrnt[0]['cad_fin_ext']; }
			else if($FTCHempcrnt[0]['imag_ext']!=''){ $imag = $imgurl.$mas_img_url."L.".$FTCHempcrnt[0]['imag_ext']; }
			
			
			$FTCHempcrt = $connection->executeQuery("SELECT * FROM des_sel_temp_des WHERE design_det_id='".$dtId."' AND party_det_id='".$login_id."'")->fetchAll();
		    $stone_html= '';
		    
		    $style_html='';
		    if(count($FTCHempcrt)==0){
		       $style_html .= "background-color:#4E4E4E; color:#fff; background-color: rgb(78, 78, 78); color: rgb(255, 255, 255); 
		        box-shadow: rgba(0, 0, 0, 0.1) 0px 0px 4px; border-radius: 4px; backdrop-filter: blur(4px);  opacity: 0.8; margin-top:10px;";
		    }else {
		    $style_html .= "background-color:#ADCC57; color:#fff; box-shadow: 0 0 4px rgba(0, 0, 0, 0.1); border-radius: 4px; backdrop-filter: blur(4px);opacity: 0.8; margin-top:10px;";
		    }

		$stone_html =  '<div class="left w-1/2 border-r border-line py-6 max-md:hidden">
                <!--<div class="heading5 px-6 pb-3">'.$design_no.'</div>-->
                
                    <div style="display:flex; justify-content:space-between; align-items:center; font-size:13px; margin-top:-4px;">

         <span style="margin-left: 5%;">
         
         <div class="product-tag text-button-uppercase bg-green px-2 py-0.5 inline-block rounded-full absolute top-3 left-3 z-[1]" id="cart_icon_stone'.$dtId.'" style="'.$style_html.'">';
			if(count($FTCHempcrt)==0){
            $stone_html .= '<a href="javascript:;"  onclick="incaddcart_stone(\''.$dtId.'\');" class="add-to-cart-btn1"  data-id="'.$dtId.'" title="Add to Cart - Design No"><i class="ph ph-shopping-bag-open text-xl" style="font-size:14px;"></i> &nbsp; '.$design_no.'</a>';
			 } else {
 			$stone_html .= '<a href="javascript:;"  onclick="dec_cart_stone(\''.$dtId.'\');"  title="Remove From Cart - Design No" data-id="'.$dtId.'"><i class="ph ph-x text-lg"style="font-size:14px;"></i> &nbsp; '.$design_no.'</a>';
			 }
            $stone_html .='</div>

        </span>

         <span style="margin-right: 10px; color:#4E4E4E;font-size:12px;border-radius:4px;background-color: rgba(255, 255, 255, 0.1);box-shadow: 0 0 2px rgba(0, 0, 0, 0.3);border: 1px solid rgba(255, 255, 255, 0.1);backdrop-filter: blur(40px);z-index:0;padding: 7px;" title="Design Wt - Stone%">
         
            '.$FTCHempmwt[0]['mas_weight'].' g – '.$design_percent.' %
        </span>

    </div>

                
                <div class="list px-6" style="margin-top:2px;">
                    <div class="heading relative flex flex-col items-center justify-center">
					    <button class="img-nav prev" data-dir="prev">❮</button>
                        <img src="'.$imag.'" width="600">
						    <button class="img-nav next" data-dir="next">❯</button>
 
                    </div>
                </div>
              </div>';

        $stone_html .= '<div class="right cart-block md:w-1/2 w-full py-6 relative">
                <div class="heading px-6 pb-3 flex items-center justify-between relative">
                  <div class="heading5">Stone Details</div>
               <div>
    <a href="#" class="close-btn">✖</a>
	</div>
               </div>
                <div class="px-6"><div class="stone-list max-h-[420px] overflow-y-auto" style="min-height:450px;">';
				
				$FTCHhw = $connection->executeQuery("SELECT * FROM emp_current_design WHERE design_det_id='".$dtId."'")->fetchAll();
				
				//$FTCHempcrnt = $connection->executeQuery("SELECT * FROM emp_current_design_stone WHERE design_det_id='".$dtId."'")->fetchAll();
				$FTCHempcrnt = $connection->executeQuery("SELECT * FROM emp_current_design_stone where  design_det_id='".$dtId."' limit 0,3")->fetchAll();
				$totalQty =0;
				$totalWgt =0;
				 foreach ($FTCHempcrnt as $empcrnt) {
					 $shape_name = $this->getShapeName($empcrnt['mas_stone_cat_id']);
					 $size_name  = $this->getSizeName($empcrnt['mas_stone_type_id']);
					 $totalQty = $totalQty+$empcrnt['quantity'];
					 $totalWgt = $totalWgt+$empcrnt['total_weight'];
                 $stone_html .= '<div data-item="3" class="item py-5 flex items-center justify-between gap-3 border-b border-line">
                    <div class="infor flex items-center gap-3 w-full">
                      <div class="w-full">
                        <div class="flex items-center justify-between w-full">
                          <div class="name text-button"><img src="assets/images/stone-details/stone-shape.png" width="20" style="float:left;"> &nbsp; '.$shape_name.' <span style="font-size:10px; color:gray; letter-spacing:1px; text-transform: uppercase;">(SHAPE)</span></div>
                          <div class="name text-button"><img src="assets/images/stone-details/stone-size.png" width="20" style="float:left;"> &nbsp;&nbsp; '.$size_name.' <span style="font-size:10px; color:gray; letter-spacing:1px; text-transform: uppercase;">(SIZE)</span></div>
                        </div>
                        <div class="flex items-center justify-between gap-2 mt-3 w-full">
                          <div class="name text-button"><img src="assets/images/stone-details/stone-qty.png" width="20" style="float:left;"> &nbsp;&nbsp; '.$empcrnt['quantity'].' <span style="font-size:10px; color:gray; letter-spacing:1px; text-transform: uppercase;">(Qty)</span></div>
                          <div class="product-price text-title"><img src="assets/images/stone-details/stone-tot-wgt.png" width="20" style="float:left;"> &nbsp;&nbsp; '.number_format($empcrnt['total_weight'],2).' <span style="text-transform: lowercase;">g</span> <span style="font-size:10px; color:gray; letter-spacing:1px; text-transform: uppercase;">(Wt)</span> </div>
                        </div>
                      </div>
                    </div>
                  </div>';
				}
				
				$stone_percent = 0;
				$FTCHmasfin = $connection->executeQuery("SELECT * FROM mas_finishing WHERE design_det_id='".$dtId."'")->fetchAll();
				$stone_percent = ($totalWgt / $FTCHmasfin[0]['mas_weight'] * 100);
               $stone_html .= '</div> </div><div class="footer-modal bg-white absolute bottom-0 left-0 w-full" style="box-shadow: 6px 0 15px rgba(0,0,0,0.15);">
                  <div class="flex items-center justify-center lg:gap-14 gap-8 px-6 py-4 border-b border-line">
                    <div class="item flex items-center gap-3 cursor-pointer"> 
                      <img src="assets/images/stone-details/height.png" width="20" style="float:left;"> <div class="caption1">'.$FTCHhw[0]['design_height'].' mm</div>
                    </div>
                    <div class="coupon-btn item flex items-center gap-3 cursor-pointer"> 
                      <img src="assets/images/stone-details/width.png" width="32" style="float:left;"> <div class="caption1">'.$FTCHhw[0]['design_width'].' mm</div>
                    </div>
                  </div>
                  <div class="flex items-center justify-between pt-6 px-6">
                    <div class="name text-button"><img src="assets/images/stone-details/stone-qty.png" width="20" style="float:left;"> &nbsp;&nbsp; '.$totalQty.' <span style="font-size:10px; color:gray; letter-spacing:1px; text-transform: uppercase;">(Total Stone Qty)</span></div>
                    <div class="product-price text-title"><span style="font-size:10px; color:gray; letter-spacing:1px; text-transform: uppercase;">(Tot Stone Wgt)</span> '.number_format($totalWgt,2).' <span style="text-transform: lowercase;">g</span> &nbsp;&nbsp; <img src="assets/images/stone-details/stone-tot-wgt.png" style="float:right;"></div>
                  </div>
                  <div class="flex items-center justify-between pt-6 px-6 block-button p-6">
                    <div class="name text-button"><img src="assets/images/stone-details/stone-perc.png" width="20" style="float:left;"> &nbsp;&nbsp;'.number_format($stone_percent,2).'% <span style="font-size:10px; color:gray; letter-spacing:1px; text-transform: uppercase;">(Stone %)</span></div>
                    <div class="product-price text-title"> <span style="font-size:10px; color:gray; letter-spacing:1px; text-transform: uppercase;">(Gold Wgt)</span> '.number_format($FTCHmasfin[0]['mas_weight'],2).'  <span style="text-transform: lowercase;">g</span> &nbsp;&nbsp; <img src="assets/images/stone-details/gold-weight.png" width="24" style="float:right;"></div>
                  </div>
                  </div>
              </div>';

		return  new JsonResponse($stone_html);

	}

/** 
	* @Route("/getfilterwgtList", name="getfilterwgtList")
	*/
	public function getfilterwgtList(Request $request) 
	{
		$connection   = $this->getDoctrine()->getManager()->getConnection();
		$dtId =  $request->get('design_det');
 		$session = $request->getSession();
		$login_id =  $session->get('loginId');
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		$master_cad_type_id = $request->get('master_cad_type_id');
		$design_type = $request->get('design_type');
		$subcat = $request->get('subcat');
		$wg_dropdown = '<select class="border border-line px-4 py-3 w-full rounded-lg" id="select-wgt" name="select-wgt"><option value="">Select</option>';
		$des_cat_qry='';
		$sub_cat_qry='';
		if($design_type!=''){
			$des_cat_qry = " and mc.category='".$design_type."'";
		}
		if($subcat!=''){
			$sub_cat_qry = " and d.master_sub_category_id='".$subcat."'";
		}
		$FTCHdeswgt = $connection->executeQuery("SELECT CONCAT(FLOOR(m.mas_weight), '.00') AS startVal, CONCAT(FLOOR(m.mas_weight) + .99) AS endVal
                                            FROM mas_finishing AS m
                                            JOIN show_case AS s ON m.design_det_id = s.design_det_id
                                            JOIN design_det AS d ON d.design_det_id = s.design_det_id
                                            JOIN master_cat AS mc ON mc.master_cat_id = d.master_cat_id
                                            WHERE d.statu_s='active' AND d.up_status='no' AND s.up_status='no' AND m.up_status='no' ".$des_cat_qry." ".$sub_cat_qry." and mc.master_cad_type_id='".$master_cad_type_id."'
                                            GROUP BY FLOOR(m.mas_weight) ORDER BY FLOOR(m.mas_weight) ASC")->fetchAll();

    foreach ($FTCHdeswgt as $wgt) {
        $wgt_range = $wgt['startVal'] . '-' . $wgt['endVal'];
        $wg_dropdown .= "<option value='" . $wgt_range . "'>" . $wgt_range . "</option>";
    }

		$wg_dropdown .= '</select>';

		return  new JsonResponse($wg_dropdown);

	}

	/** 
	* @Route("/getfilterCatlists", name="getfilterCatlists")
	*/
	public function getfilterCatLists(Request $request) 
	{
		$connection = $this->getDoctrine()->getManager()->getConnection();
 		$session = $request->getSession();
		$login_id =  $session->get('loginId');
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		$master_cad_type_id =  $request->get('master_cad_type_id');
		$design_type =  $request->get('design_type');
		$catId =  $request->get('catId');

		$selempcat  = "SELECT * FROM `master_cat` WHERE master_cad_type_id='".$master_cad_type_id."' and category='".$design_type."'";
		$CONNempcat= $connection->executeQuery($selempcat);
		$FTCHempcat = $CONNempcat->fetchAll();
		$fcatlist='';
		$filtercatlist='';
		$fcatlist .='<select class="border border-line px-4 py-3 w-full rounded-lg" id="select-cat" name="select-cat" onchange="filtercat(this.value);"><option value="">Choose Categories</option>';
		foreach($FTCHempcat as $cat){
			$fcatlist .= '<option value='.$cat['master_cat_id'].'" >'.$cat['cat_name'].'</option>';
			}
			 $fcatlist .= '</select>';

		$filtercatlist ='<select class="border border-line px-4 py-3 w-full rounded-lg" id="select-subcat" name="select-subcat" onchange="getfilterwgt(this.value);"><option value="">Choose SubCategories</option>';

			$selempcrnt  = "SELECT MSC.master_sub_category_id, MSC.sub_category_name
                                             FROM design_det AS DD
                                             JOIN master_sub_category AS MSC ON MSC.master_sub_category_id = DD.master_sub_category_id JOIN master_cat AS MC ON MC.master_cat_id=DD.master_cat_id where MC.category='".$design_type."' and MC.master_cad_type_id='".$master_cad_type_id."'  
                                             GROUP BY MSC.sub_category_name ORDER BY MSC.sub_category_name ASC";
			$CONNempcrnt = $connection->executeQuery($selempcrnt);
			$FTCHempcrnt = $CONNempcrnt->fetchAll();

			foreach($FTCHempcrnt as $cat){
				$filtercatlist .="<option value='".$cat['master_sub_category_id']."'>".$cat['sub_category_name']."</option>";
			}

		$filtercatlist .='</select>';

		$wg_dropdown = '<select class="border border-line px-4 py-3 w-full rounded-lg" id="select-wgt" name="select-wgt"><option value="">Select</option>';
		$catQry ='';
		if($design_type!=''){
			$catQry .= " and mc.category='".$design_type."'";
		}
		if($catId!=''){
			$catQry .= " and mc.master_cat_id='".$catId."'";
		}

		if($master_cad_type_id!=''){
			$catQry .= " and mc.master_cad_type_id='".$master_cad_type_id."'";
		}

		$FTCHdeswgt = $connection->executeQuery("SELECT CONCAT(FLOOR(m.mas_weight), '.00') AS startVal, CONCAT(FLOOR(m.mas_weight) + .99) AS endVal
                                            FROM mas_finishing AS m
                                            JOIN show_case AS s ON m.design_det_id = s.design_det_id
                                            JOIN design_det AS d ON d.design_det_id = s.design_det_id
                                            JOIN master_cat AS mc ON mc.master_cat_id = d.master_cat_id
                                            WHERE d.statu_s='active' AND d.up_status='no' AND s.up_status='no' AND m.up_status='no' ".$catQry."  
                                            GROUP BY FLOOR(m.mas_weight) ORDER BY FLOOR(m.mas_weight) ASC")->fetchAll();

		foreach ($FTCHdeswgt as $wgt) {
			$wgt_range = $wgt['startVal'] . '-' . $wgt['endVal'];
			$wg_dropdown .= "<option value='" . $wgt_range . "'>" . $wgt_range . "</option>";
		}

		$wg_dropdown .= '</select>';

		return  new JsonResponse($fcatlist.'###'.$filtercatlist.'###'.$wg_dropdown);
	}

	/** 
	* @Route("/getfilterCatdropdown", name="getfilterCatdropdown")
	*/
	public function getfilterCatdropdown(Request $request) 
	{
		$connection = $this->getDoctrine()->getManager()->getConnection();
		$dtId =  $request->get('design_det');
 		$session = $request->getSession();
		$login_id =  $session->get('loginId');
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		$master_cad_type_id =  $request->get('master_cad_type_id');
		$design_type =  $request->get('design_type');
		$catId =  $request->get('catId');
		$filtercatlist ='<select class="border border-line px-4 py-3 w-full rounded-lg" id="select-subcat" name="select-subcat" onchange="getfilterwgt(this.value);"><option value="">Choose Sub Categories</option>';

			$selempcrnt  = "SELECT MSC.master_sub_category_id, MSC.sub_category_name
                                             FROM design_det AS DD
                                             JOIN master_sub_category AS MSC ON MSC.master_sub_category_id = DD.master_sub_category_id where 1 and DD.master_cat_id='".$catId."'
                                             GROUP BY MSC.sub_category_name ORDER BY MSC.sub_category_name ASC";
			$CONNempcrnt = $connection->executeQuery($selempcrnt);
			$FTCHempcrnt = $CONNempcrnt->fetchAll();

			foreach($FTCHempcrnt as $cat){
				$filtercatlist .="<option value='".$cat['master_sub_category_id']."'>".$cat['sub_category_name']."</option>";
			}

		$filtercatlist .='</select>';

		$wg_dropdown = '<select class="border border-line px-4 py-3 w-full rounded-lg" id="select-wgt" name="select-wgt"><option value="">Choose Weight Range</option>';
		$catQry ='';
		if($design_type!=''){
			$catQry .= " and mc.category='".$design_type."'";
		}
		if($catId!=''){
			$catQry .= " and mc.master_cat_id='".$catId."'";
		}
		
		if($master_cad_type_id!=''){
			$catQry .= " and mc.master_cad_type_id='".$master_cad_type_id."'";
		}
		
		 
		$FTCHdeswgt = $connection->executeQuery("SELECT CONCAT(FLOOR(m.mas_weight), '.00') AS startVal, CONCAT(FLOOR(m.mas_weight) + .99) AS endVal
                                            FROM mas_finishing AS m
                                            JOIN show_case AS s ON m.design_det_id = s.design_det_id
                                            JOIN design_det AS d ON d.design_det_id = s.design_det_id
                                            JOIN master_cat AS mc ON mc.master_cat_id = d.master_cat_id
                                            WHERE d.statu_s='active' AND d.up_status='no' AND s.up_status='no' AND m.up_status='no' ".$catQry."  
                                            GROUP BY FLOOR(m.mas_weight) ORDER BY FLOOR(m.mas_weight) ASC")->fetchAll();

		foreach ($FTCHdeswgt as $wgt) {
			$wgt_range = $wgt['startVal'] . '-' . $wgt['endVal'];
			$wg_dropdown .= "<option value='" . $wgt_range . "'>" . $wgt_range . "</option>";
		}

		$wg_dropdown .= '</select>';

		return  new JsonResponse($filtercatlist.'###'.$wg_dropdown);
	}

	/** 
	* @Route("/AdditemsCart", name="AdditemsCart")
	*/
	public function addtoCartitems(Request $request) 
	{
		$connection   = $this->getDoctrine()->getManager()->getConnection();
		$dtId =  $request->get('design_det');
 		$session = $request->getSession();
		$login_id =  $session->get('loginId');
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		$pr_price=0;
		$tprice=0;
		$tot_cst=0;

		$sessionId = session_id();

		$selempcrnt  = "select * from design_det where design_det_id='".$dtId."'";
		$CONNempcrnt = $connection->executeQuery($selempcrnt);
		$FTCHempcrnt = $CONNempcrnt->fetchAll();
		$master_cat_id = $FTCHempcrnt[0]['master_cat_id'];
		$design_no = $FTCHempcrnt[0]['design_no'];
		
		$selcost  = "select master_cat_name,cost_vl from master_cat where master_cat_id='".$master_cat_id."' ";
		$CONNcost = $connection->executeQuery($selcost);
		$FTCHcost = $CONNcost->fetchAll();
		$cost_val = $FTCHcost[0]['cost_vl'];
		$master_cat_name = $FTCHcost[0]['master_cat_name'];

		$seltemp  = "select * from des_sel_temp where master_cat_id='".$master_cat_id."' and party_det_id='".$login_id."'";
		$CONNtemp = $connection->executeQuery($seltemp);
		$FTCHtemp = $CONNtemp->fetchAll();
		if(count($FTCHtemp)>0){
			$newcnt = $FTCHtemp[0]['coun_t']+1;
			$new_cost = $newcnt*$FTCHtemp[0]['cos_t'];
			$QURYInsCart = "update des_sel_temp set coun_t='".$newcnt."',tot_cost='".$new_cost."' where master_cat_id='".$master_cat_id."' and party_det_id='".$login_id."'";
			$CONNempcrnt = $connection->executeQuery($QURYInsCart);
		} else {
			$selcost1  = "select * from des_sel_temp where master_cat_id='".$master_cat_id."' and party_det_id='".$login_id."'";
			$CONNcost1 = $connection->executeQuery($selcost1);
			$FTCHcost1 = $CONNcost1->fetchAll();
			if(count($FTCHcost1)==0){

			$QURYUpdCart = "INSERT INTO des_sel_temp(party_det_id, ses_id, master_cat_id, coun_t, cos_t, tot_cost, post_dt)VALUES('$login_id', '$sessionId', '$master_cat_id', '1', '$cost_val' ,'$cost_val = ',now())";
			$CONNempcrnt = $connection->executeQuery($QURYUpdCart);
			}
		}
			$selcost1a  = "select * from des_sel_temp_des where master_cat_id='".$master_cat_id."' and party_det_id='".$login_id."' and design_det_id='".$dtId."'";
			$CONNcost1a = $connection->executeQuery($selcost1a);
			$FTCHcost1a = $CONNcost1a->fetchAll();
			if(count($FTCHcost1a)==0){
		$QURYInscrtdes	= "INSERT INTO des_sel_temp_des(party_det_id,designation,ses_id, master_cat_id, design_det_id, post_dt)VALUES('".$login_id."','client','".$sessionId."','".$master_cat_id."','".$dtId."',now())";

		$CONNselCart	= $connection->executeQuery($QURYInscrtdes);
			}

	//	$rslt='1';
		$header_cart = '';//$this->cart_index($login_id);
		$cart_count = $this->cart_count($login_id);
		$show_dno = $master_cat_name." ".$design_no;
		return  new JsonResponse($header_cart."***".$cart_count."***".number_format($tot_cst,2)."***".$show_dno);
	}
	
	/** 
	* @Route("/UpdateitemsCart", name="UpdateitemsCart")
	*/
	public function UpdateCartitems(Request $request) 
	{
		$connection   = $this->getDoctrine()->getManager()->getConnection();
		$dtId =   $request->get('design_det');
 		$session = $request->getSession();
		$login_id =  $session->get('loginId');
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		$pr_price=0;
		$tprice=0;
		$tot_cst=0;

		$sessionId = session_id();

		$selempcrnt  = "select * from design_det where design_det_id='".$dtId."'";
		$CONNempcrnt = $connection->executeQuery($selempcrnt);
		$FTCHempcrnt = $CONNempcrnt->fetchAll();
		$master_cat_id = $FTCHempcrnt[0]['master_cat_id'];
		$design_no = $FTCHempcrnt[0]['design_no'];
		
		$selcost  = "select master_cat_name,cost_vl from master_cat where master_cat_id='".$master_cat_id."' ";
		$CONNcost = $connection->executeQuery($selcost);
		$FTCHcost = $CONNcost->fetchAll();

		$master_cat_name = $FTCHcost[0]['master_cat_name'];

		$seltemp  = "select * from des_sel_temp where master_cat_id='".$master_cat_id."' and party_det_id='".$login_id."'";
		$CONNtemp = $connection->executeQuery($seltemp);
		$FTCHtemp = $CONNtemp->fetchAll();
		if($FTCHtemp[0]['coun_t']==1){
			$QURYInsCart= "delete from des_sel_temp where master_cat_id='".$master_cat_id."' and party_det_id='".$login_id."'";
			$CONNempcrnt = $connection->executeQuery($QURYInsCart);
		} else {
			$newcnt = $FTCHtemp[0]['coun_t']-1;
			$new_cost = $newcnt*$FTCHtemp[0]['cos_t'];
			$QURYInsCart = "update des_sel_temp set coun_t='".$newcnt."',tot_cost='".$new_cost."' where master_cat_id='".$master_cat_id."' and party_det_id='".$login_id."'";
			$CONNempcrnt = $connection->executeQuery($QURYInsCart);
		}

		$QURYInscrtdes="delete from des_sel_temp_des where design_det_id='".$dtId."' and party_det_id='".$login_id."'";
		$CONNselCart	= $connection->executeQuery($QURYInscrtdes);

	//	$rslt='1';
		$header_cart = '';//$this->cart_index($login_id);
		$cart_count = $this->cart_count($login_id);
		$show_dno = $master_cat_name." ".$design_no;
		return  new JsonResponse($header_cart."***".$cart_count."***".number_format($tot_cst,2)."***".$show_dno);
	}
	
	
	
		/** 
	* @Route("/clearCartItems", name="clearCartItems")
	*/
	public function clearCartitems(Request $request) 
	{
		$connection   = $this->getDoctrine()->getManager()->getConnection();
  		$session = $request->getSession();
		$login_id =  $session->get('loginId');
 
		$selcart1  = "delete from des_sel_temp where party_det_id='".$login_id."'";
		$CONNcost = $connection->executeQuery($selcart1);	
		
		$selcart2  = "delete from des_sel_temp_des where party_det_id='".$login_id."'";
		$CONNcost1 = $connection->executeQuery($selcart2);	

		
		$header_cart = '';//$this->cart_index($login_id);
		$cart_count = $this->cart_count($login_id);
		return  new JsonResponse($cart_count);
	}

	/**
	 * @Route("/getShowcasesearch", name="getShowcasesearch")
	 */
	public function getShowcasesearch(Request $request)
	{
		$connection= $this->getDoctrine()->getManager()->getConnection();
		$session = $request->getSession();

		$session_Id = $session->get('loginId');

		$master_cad_type_id = $request->get('master_cad_type_id');

		$limit = 20;
		$offset = 0;
		if($search_by!=''){
			$search_by = " AND mc.master_cad_type_id='".$master_cad_type_id."'";
		}

		$QURYdesg = "SELECT d.mas_fin_ext, d.cad_fin_ext, d.imag_ext, s.show_case_id, mc.master_cat_name, mc.master_cad_type_id, d.design_no, FORMAT(m.mas_weight,2) as mas_weight, s.master_cat_id, s.design_det_id FROM mas_finishing as m,show_case as s,design_det as d,master_cat  as mc WHERE mc.master_cat_id = d.master_cat_id ".$search_by." AND d.design_det_id = s.design_det_id AND d.statu_s='active' AND d.up_status='no' AND s.up_status='no' AND m.design_det_id = s.design_det_id AND m.up_status='no' AND s.design_det_id NOT IN(SELECT pd.design_det_id FROM po_entry_det AS pd,po_entry AS p WHERE p.party_det_id = '".$loginId."' AND pd.po_entry_id = p.po_entry_id AND p.cancelled='no') AND s.design_det_id NOT IN (SELECT design_det_id FROM design_sel_det WHERE party_det_id = '".$loginId."' AND ord_status='no') ORDER BY s.show_case_id DESC LIMIT ".$limit." OFFSET ".$offset."";
		$CONNdesg	= $connection->executeQuery($QURYdesg);
		$FTCHdesg = $CONNdesg->fetchAll();

		$design_html = "";

		foreach($FTCHdesg as $desg){
			$design_html .= '<div class="product-item grid-type" data-showcase-id="'.$desg['show_case_id'].'">

	<div class="product-main cursor-pointer block">
    <div class="product-thumb bg-white relative overflow-hidden rounded-2xl">
        <div class="product-tag text-button-uppercase bg-green px-3 py-0.5 inline-block rounded-full absolute top-3 left-3 z-[1]">
           '.$desg['mas_weight'].' <small>g</small>
        </div>

        <div class="list-action-right absolute top-3 right-3 max-lg:hidden">
            <div class="add-wishlist-btn w-[32px] h-[32px] flex items-center justify-center rounded-full bg-white duration-300 relative">
                <div class="tag-action bg-black text-white caption2 px-1.5 py-0.5 rounded-sm">
                    Add To Cart
                </div>
                <i class="ph ph-plus text-lg"></i>
            </div>

        </div>

        <div class="product-img w-full h-full aspect-[3/4]">
            <img class="w-full h-full object-cover duration-700" src="./assets/images/product/1000x1000.png" alt="img">
        </div>

        <div class="list-action grid grid-cols-2 gap-3 px-5 absolute w-full bottom-5 max-lg:hidden">
            <div class="quick-view-btn w-full text-button-uppercase py-2 text-center rounded-full duration-300 bg-white hover:bg-black hover:text-white">
                <span class="max-lg:hidden">'.$desg['master_cat_name'].' '.$desg['design_no'].'</span>
                <i class="ph ph-eye lg:hidden text-xl"></i>
            </div>

            <div class="quick-shop-btn text-button-uppercase py-2 text-center rounded-full duration-500 bg-white hover:bg-black hover:text-white max-lg:hidden">
                View Stone
            </div>
        </div>

    </div>
</div>
 
    </div>';
		}
		return new JsonResponse($design_html);
	}

/**
	 * @Route("/getWgtlists", name="getWgtlists")
	 */
	public function getWgtlistsact(Request $request)
	{
		$connection= $this->getDoctrine()->getManager()->getConnection();
		$session = $request->getSession();

		$session_Id = $session->get('loginId');

		$design_type = $request->get('design_type');
		$selectcat = $request->get('selectcat');
		$master_cad_type = $request->get('master_cad_type');
		$subcatIds = $request->get('subcatIds');
		
		 $loginId = $session->get('loginId');

		$search_by='';

		if($design_type){
			$search_by .= " AND mc.category='".$design_type."'";
		}
		if($selectcat) {
			$search_by .= " AND mc.master_cat_id='".$selectcat."'";
		}
		if($subcatIds) {
			$search_by .= " AND d.master_sub_category_id IN ('".$subcatIds."')";
		}
		if($master_cad_type!=''){
			$search_by .= " AND mc.master_cad_type_id='".$master_cad_type."'";
		}

	/*	$selempcrnt  = "SELECT DISTINCT m.mas_weight FROM mas_finishing AS m
		JOIN show_case AS s ON m.design_det_id = s.design_det_id
		JOIN design_det AS d ON d.design_det_id = s.design_det_id
		JOIN master_cat AS mc ON mc.master_cat_id = d.master_cat_id
		WHERE 
		d.statu_s = 'active'
		AND d.up_status = 'no'
		AND s.up_status = 'no'
		AND m.up_status = 'no'
		".$search_by." ORDER BY m.mas_weight ASC";*/
		
		  $selempcrnt = "
    SELECT 
        d.mas_fin_ext,
        d.cad_fin_ext,
        d.imag_ext,
        s.show_case_id,
        mc.master_cat_name,
        mc.category,
        d.design_no,
        FORMAT(m.mas_weight,2) AS mas_weight,
        s.master_cat_id,
        s.design_det_id
    FROM mas_finishing AS m
    JOIN show_case AS s ON m.design_det_id = s.design_det_id
    JOIN design_det AS d ON d.design_det_id = s.design_det_id
    JOIN master_cat AS mc ON mc.master_cat_id = d.master_cat_id
    WHERE d.statu_s = 'active'
      AND d.up_status = 'no'
      AND s.up_status = 'no'
      AND m.up_status = 'no'
      $search_by
      AND s.design_det_id NOT IN (
          SELECT pd.design_det_id
          FROM po_entry_det AS pd
          JOIN po_entry AS p ON pd.po_entry_id = p.po_entry_id
          WHERE p.party_det_id = $loginId
            AND p.cancelled = 'no'
      )
      AND s.design_det_id NOT IN (
          SELECT design_det_id
          FROM design_sel_det
          WHERE party_det_id = $loginId
            AND ord_status = 'no'
      ) and m.mas_weight!='0' order by m.mas_weight";
		
		$CONNempcrnt = $connection->executeQuery($selempcrnt);
		$FTCHempcrnt = $CONNempcrnt->fetchAll();

		$subids_search ='';
		foreach($FTCHempcrnt as $mswgt){
			$subids_search .= $mswgt['mas_weight'].",";
		}
		$subids_search = substr($subids_search,0,-1);
		return new JsonResponse($subids_search);
	}

}
