<?php

namespace App\Controller;
 
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class OrderController extends AbstractController
{
 
	/** 
	* @Route("/orders", name="orders")
	*/
	public function OrderItemsAct(Request $request) 
	{
		$connection   = $this->getDoctrine()->getManager()->getConnection();
 		$session = $request->getSession();
		$login_id =  $session->get('loginId');
		if(!$session->has('login'))
        {
        	return $this->redirectToRoute('login');
        }

		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		$sel_crt = "SELECT * FROM po_entry WHERE party_det_id='".$login_id."' ORDER BY po_entry_id DESC";
		$CONNselCrt	= $connection->executeQuery($sel_crt);
		$FTCHselCrt	= $CONNselCrt->fetchAll();
		$order_html = '';
		$order_html .= '<table class="w-full max-[1400px]:w-[700px] max-md:w-[700px]" style="width:100%;">
        						<thead class="border-b border-line">
        							<tr style="border-bottom:2px solid #ADCC57;">
        								<th scope="col" class="pb-3 text-sm font-bold text-secondary whitespace-nowrap">S.No.</th>
        								<th scope="col" class="pb-3 text-left text-sm font-bold text-secondary whitespace-nowrap">Purchase Order No.</th>
        								<th scope="col" class="pb-3 text-left text-sm font-bold text-secondary whitespace-nowrap">Purchase Order Date</th>
        								<th scope="col" class="pb-3 text-sm font-bold text-secondary whitespace-nowrap">Order Qty</th>
        								<th scope="col" class="pb-3 text-sm font-bold text-secondary whitespace-nowrap">Delivery Qty</th>
        								<th scope="col" class="pb-3 text-sm font-bold text-secondary whitespace-nowrap" title="View/Print - PO Design\'s">Design\'s</th>
        							</tr>
        						</thead>';
		if(count($FTCHselCrt)>0){
			$cartsno=1;

		foreach($FTCHselCrt as $ord){
		$timestamp = strtotime($ord['po_date']);
		$formattedDate =  date('M j, Y', $timestamp);

		$sel_crt_po = "SELECT  COUNT(po_entry_det_id) AS tot_cnt FROM po_entry_det WHERE cancelled = 'no' AND po_entry_id ='".$ord['po_entry_id']."'";
		$CONNselCrt_po	= $connection->executeQuery($sel_crt_po);
		$FTCHselCrt_po	= $CONNselCrt_po->fetchAll();
		$tot_cnt   = $FTCHselCrt_po[0]['tot_cnt'];

		$sel_crt1 = "SELECT  COUNT(po_entry_det_id) AS del_cnt FROM po_entry_det WHERE cancelled = 'no' AND del_status = 'yes' AND po_entry_id ='".$ord['po_entry_id']."'";
		$CONNselCrt1 = $connection->executeQuery($sel_crt1);
		$FTCHselCrt1 = $CONNselCrt1->fetchAll();
		$del_cnt   = $FTCHselCrt1[0]['del_cnt'];
		$po_entry_id = base64_encode(base64_encode(base64_encode($ord['po_entry_id'])));
		$class_last ='';
		if($cartsno != count($FTCHselCrt)){
			$class_last = 'border-b border-line';
		}
		
			$order_html .='<tr class="item duration-300 '.$class_last.'"> 
        								<td scope="row" class="py-3" align="center" style="font-size:14px;">'.$cartsno.'</td>
        								<td class="py-3"><strong class="product_name text-button" style="font-size:14px;">'.$ord['po_no'].'</strong></td>
        								<td class="py-3" style="font-size:14px;">'.$formattedDate.'</td>
        								<td class="py-3" align="center" style="font-size:14px;">'.$tot_cnt.'</td>
        								<td class="py-3" align="center" style="font-size:14px;">'.$del_cnt.'</td>
        								<td class="py-3" style="width: 100%; text-align: center; display: flex; justify-content: center; gap: 5px;">
        								    <a href="/order-po-details'.$po_entry_id.'">
        								        <img src="assets/images/view.png" width="24" title="View - PO Design\'s">
        								    </a>
        								    &nbsp;
											<a href="/order-pdf-details'.$po_entry_id.'" target="_blank">
        								    <img src="assets/images/printer-grey.png" width="24" title="Print - PO Design\'s">
											</a>
        								</td>
        							</tr>';
			$cartsno = $cartsno+1;
		}

		} else {
			$order_html .='<tr class="item duration-300 border-b border-line"><td colspan="4" style="  text-align: center; justify-content: center; gap: 5px;"><b>There are no orders yet.</b></td></tr>';
		}

		$order_html .= "</tbody>
				</table>";
	// Fetch CAD types
    $QURYcad = "SELECT * FROM master_cad_type WHERE statu_s='active' ORDER BY master_cad_type_id ASC";
    $CONNcad = $connection->executeQuery($QURYcad);
    $FTCHcad = $CONNcad->fetchAll();
	$cart_count = $this->cart_count($login_id);
	
	
	$filter_arr = array();

	foreach($FTCHcad as $cadfltr){
		$selPlcat  = "SELECT distinct(d.master_cat_id),mc.cat_name FROM mas_finishing as m,show_case as s,design_det as d,master_cat as mc WHERE mc.master_cat_id = d.master_cat_id and mc.master_cad_type_id='".$cadfltr['master_cad_type_id']."' and mc.category='plain' AND d.design_det_id = s.design_det_id AND d.statu_s='active' AND d.up_status='no' AND s.up_status='no' AND m.design_det_id = s.design_det_id AND m.up_status='no' AND s.design_det_id NOT IN(SELECT pd.design_det_id FROM po_entry_det AS pd,po_entry AS p WHERE p.party_det_id = '".$login_id."' AND pd.po_entry_id = p.po_entry_id AND p.cancelled='no') AND s.design_det_id NOT IN (SELECT design_det_id FROM design_sel_det WHERE party_det_id = '".$login_id."' AND ord_status='no') ORDER BY mc.cat_name";
		$CONNPlcat = $connection->executeQuery($selPlcat);
		$FTCHPlcat = $CONNPlcat->fetchAll();
		$filter_arr[$cadfltr['master_cad_type_id']]['Plain'] = $FTCHPlcat;

		$selStcat  = "SELECT distinct(d.master_cat_id),mc.cat_name FROM mas_finishing as m,show_case as s,design_det as d,master_cat as mc WHERE mc.master_cat_id = d.master_cat_id and mc.master_cad_type_id='".$cadfltr['master_cad_type_id']."' and mc.category='stone' AND d.design_det_id = s.design_det_id AND d.statu_s='active' AND d.up_status='no' AND s.up_status='no' AND m.design_det_id = s.design_det_id AND m.up_status='no' AND s.design_det_id NOT IN(SELECT pd.design_det_id FROM po_entry_det AS pd,po_entry AS p WHERE p.party_det_id = '".$login_id."' AND pd.po_entry_id = p.po_entry_id AND p.cancelled='no') AND s.design_det_id NOT IN (SELECT design_det_id FROM design_sel_det WHERE party_det_id = '".$login_id."' AND ord_status='no') ORDER BY mc.cat_name";
		$CONNStcat = $connection->executeQuery($selStcat);
		$FTCHStcat = $CONNStcat->fetchAll();
		$filter_arr[$cadfltr['master_cad_type_id']]['Stone'] = $FTCHStcat;
	}

	return $this->render('orders/orderlist.html.twig', [
			'order_html'=>$order_html,
			'FTCHcad'=>$FTCHcad,
			'activeType'=>'',
			'designType'=>'',
			'mas_cat'=>'',
			'filter_arr'=>$filter_arr,
			'cart_count'=>$cart_count,
			'party_id'=>$login_id,
			'controller_name' => 'OrderController'
        ]);
}

/** 
	* @Route("/order-po-details{ord_id}", name="order-po-details")
	*/
	public function ORderDetails(Request $request,$ord_id) 
	{
		$connection   = $this->getDoctrine()->getManager()->getConnection();
 		$session = $request->getSession();
		$login_id =  $session->get('loginId');
		if(!$session->has('login'))
        {
        	return $this->redirectToRoute('login');
        }

		$po_entry_id = base64_decode(base64_decode(base64_decode($ord_id)));
		$sel_crt = "SELECT  * FROM po_entry WHERE po_entry_id ='".$po_entry_id."'";
		$CONNselCrt	= $connection->executeQuery($sel_crt);
		$FTCHselCrt	= $CONNselCrt->fetchAll();
		$party_det_id = $FTCHselCrt[0]['party_det_id'];
		$po_no        = $FTCHselCrt[0]['po_no'];
		$po_date      = $FTCHselCrt[0]['po_date'];
		$timestamp = strtotime($po_date);
		$po_date =  date('M j, Y', $timestamp);
		
		$sel_poQty = "SELECT COUNT(design_det_id) AS des_nt FROM po_entry_det WHERE po_entry_id ='".$po_entry_id."' AND cancelled='no'";
		$CONNpoQty	= $connection->executeQuery($sel_poQty);
		$FTCHpoQty	= $CONNpoQty->fetchAll();
		$po_qty = $FTCHpoQty[0]['des_nt'];
		
		$order_html = '';
		$order_html .= '<table class="w-full max-[1400px]:w-[700px] max-md:w-[700px]" style="width:100%;">
        						<thead class="border-b border-line">
        							<tr style="border-bottom:2px solid #ADCC57;">
        								<th scope="col" class="pb-3 text-sm font-bold text-secondary whitespace-nowrap">S.No.</th>
        								<th scope="col" class="pb-3 text-left text-sm font-bold text-secondary whitespace-nowrap">Design No.</th>
        								<th scope="col" class="pb-3 text-left text-sm font-bold text-secondary whitespace-nowrap">Order Status</th>
        								<th scope="col" class="pb-3 text-sm font-bold text-secondary whitespace-nowrap">Design</th>
        								<th scope="col" class="pb-3 text-sm font-bold text-secondary whitespace-nowrap">Delivery Date</th>
        							</tr>
        						</thead>
        						<tbody>';
								
		$sel_podet = "SELECT * FROM po_entry_det WHERE   po_entry_id = '$po_entry_id' ORDER BY master_cat_id, design_det_id ASC";
		$CONNpodet	= $connection->executeQuery($sel_podet);
		$FTCHpodet	= $CONNpodet->fetchAll();

		if(count($FTCHselCrt)>0){
			$cartsno=1;
			$cad_img_url = 'design_images/';
			$des_img_url = 'design_images/';
		$i=0;
		foreach($FTCHpodet as $podet){
			$design_det_id = $podet['design_det_id'];
			$cancelled     = $podet['cancelled'];
			$fin_status    = $podet['fin_status'];
			$del_status    = $podet['del_status'];
			$remark_s      = $podet['remark_s'];
			$design_id	   = base64_encode(base64_encode(base64_encode($design_det_id)));
			
			$sel_desdet = "SELECT * FROM design_det WHERE design_det_id ='".$design_det_id."'";
			$CONNdesdet	= $connection->executeQuery($sel_desdet);
			$FTCHdesdet	= $CONNdesdet->fetchAll();
			$master_cat_id   = $FTCHdesdet[0]['master_cat_id'];
			$mas_fin_ext     = $FTCHdesdet[0]['mas_fin_ext'];
			$cad_fin_ext     = $FTCHdesdet[0]['cad_fin_ext'];
			$imag_ext        = $FTCHdesdet[0]['imag_ext'];
			$design_no       = $FTCHdesdet[0]['design_no'];

			$sel_cat = "SELECT * FROM master_cat WHERE master_cat_id ='".$master_cat_id."'";
			$CONNcat	= $connection->executeQuery($sel_cat);
			$FTCHcat	= $CONNcat->fetchAll();
			$master_cat_name   = $FTCHcat[0]['master_cat_name'];
 
			$sel_mcat = "SELECT MS.* FROM mas_finishing AS MS,design_det AS DD WHERE MS.`design_det_id`=DD.`design_det_id` AND DD.design_det_id='".$design_det_id."'";
			$CONNmcat	= $connection->executeQuery($sel_mcat);
			$getMastersData3	= $CONNmcat->fetchAll();
			
			$mas_wght = $getMastersData3[0]['mas_weight'];
			
			$sel_emp = "SELECT design_height,design_width FROM emp_current_design WHERE design_det_id ='".$design_det_id."'";
			$CONNemp	= $connection->executeQuery($sel_emp);
			$getEmpDetId	= $CONNemp->fetchAll();

			//$des_height 	= $getEmpDetId[0]['design_height'];
			//$des_width	 	= $getEmpDetId[0]['design_width'];
			$imgurl = 'https://meways.in/';
			$des_img_url = 'mas_fin_images/';
			$cad_img_url = 'cad_fin_images/';
			$mas_img_url = 'design_images/';
			$sel_dsgtbl = "SELECT ec.stone_weight,ec.quantity,FORMAT(ec.total_weight,2) as total_weight,ms.cat_name,mt.stone_name FROM emp_current_design_stone AS ec, mas_stone_cat AS ms, mas_stone_type AS mt WHERE ec.mas_stone_cat_id = ms.mas_stone_cat_id AND ec.mas_stone_type_id = mt.mas_stone_type_id AND ec.statu_s =1 AND ec.design_det_id ='".$design_det_id."' ORDER BY ms.mas_stone_cat_id ASC, mt.mas_stone_type_id ASC";
			$CONNdsgtbl	= $connection->executeQuery($sel_dsgtbl);
			$getDesignTable = $CONNdsgtbl->fetchAll();
			/*$arr_qty = array();
			$arr_wgt = array();

			foreach($getDesignTable AS $key => $value)
				{
					$arr_qty[] = $value['quantity'];
					$arr_wgt[] = $value['total_weight'];
				}
				$qty = array_sum($arr_qty);
				$wgt = array_sum($arr_wgt);
				if($wgt!='0')
				{
					$totl_perc = number_format((($wgt/$mas_wght)*100), 2);
				}else{
					$totl_perc = 0.00;
				}*/

				if($cancelled=="yes")
				{
					$statu_s = "Cancelled";
				}
				else if($fin_status=="yes")
				{
					$statu_s = "Finished";
				}
				else if($del_status=="yes")
				{
					$statu_s = "Delivered";
				}
				else if($fin_status=="no")
				{
					$statu_s = "On Process";
				}
				if($mas_fin_ext!=''){ $imag = $imgurl.$des_img_url."S.".$mas_fin_ext; $imag1 = $imgurl.$des_img_url."L.".$mas_fin_ext; }

				else if($cad_fin_ext!=''){ $imag = $imgurl.$cad_img_url."S.".$cad_fin_ext;  $imag1 = $imgurl.$cad_img_url."L.".$cad_fin_ext;}

				else if($imag_ext!=''){ $imag = $imgurl.$cad_img_url."S.".$imag_ext; $imag1 = $imgurl.$cad_img_url."L.".$imag_ext; }
				$title = $master_cat_name." ".$design_no;
				//$imag  = "phpThumb/phpThumbS.php?src=../".$imag."";
				$imag  = $imag;
				//$imag1  = "phpThumb/phpThumb.php?src=../".$imag1."";
				$imag1 = $imag1;

				$tot_var = "";//$i.'$$'.$master_cat_id.'$$'.$design_det_id.'$$$$$$'.$title.'$$'.$des_height.'$$'.$des_width.'$$'.$totl_perc.'$$'.$mas_wght.' g';
				$arr_stn=null;
				$arr_wgt=null;
				$class_last ='';
				if($cartsno != count($FTCHpodet)){
					$class_last = 'border-b border-line';
				}
				
			$order_html .='<tr class="item duration-300 '.$class_last.'">
								<td scope="row" class="py-3" align="center" style="font-size:14px;">'.$cartsno.'</td>
								<td class="py-3"><strong class="product_name text-button" style="font-size:14px;">'.$master_cat_name." ".$design_no.'</strong></td>
								<td class="py-3" style="font-size:14px;">'.$statu_s.'</td>
								<td class="py-3" align="center" style="font-size:14px;">
								<a href="'.$imag1.'" data-caption="'.$master_cat_name." ".$design_no.'">
  <img src="'.$imag.'" alt="'.$master_cat_name." ".$design_no.'"  style="border:1px solid rgb(233 233 233 / var(--tw-border-opacity));">
</a>
 </td>
								<td class="py-3" style="width: 100%; text-align: center; display: flex; justify-content: center; gap: 5px;">
									'.$remark_s.'
								</td>
							</tr>';
			$cartsno = $cartsno+1;
			$i++;
		}

		} else {
			$order_html .='<tr class="item duration-300 border-b border-line"><td colspan="4" style="  text-align: center; justify-content: center; gap: 5px;"><b>There are no orders yet.</b></td></tr>';
		}

		$order_html .= "</tbody>
				</table>";
	// Fetch CAD types
    $QURYcad = "SELECT * FROM master_cad_type WHERE statu_s='active' ORDER BY master_cad_type_id ASC";
    $CONNcad = $connection->executeQuery($QURYcad);
    $FTCHcad = $CONNcad->fetchAll();
	$cart_count = $this->cart_count($login_id);

	return $this->render('orders/orderdetails.html.twig', [
			'order_html'=>$order_html,
			'FTCHcad'=>$FTCHcad,
			'activeType'=>'',
			'po_no'=>$po_no,
			'po_date'=>$po_date,
			'po_qty'=>$po_qty,
			'cart_count'=>$cart_count,
			'party_id'=>$login_id,
			'controller_name' => 'OrderController'
        ]);
	}

	/**
     * @Route("/order-pdf-details{poId}", name="order-pdf-details")
     */
    public function clientOrderPDFList(Request $request, $poId)
    {
        
 		$session = $request->getSession();
		$sessionId  = $session->get('empId');
		if(!$session->has('login'))
        {
        	return $this->redirectToRoute('login');
        }

		//error_reporting(0);
		$connection = $this->getDoctrine()->getManager()->getConnection(); 

		$poId =  base64_decode(base64_decode(base64_decode($poId))); 

		$QURYPoid = "SELECT  * FROM po_entry WHERE po_entry_id ='".$poId."'";
		$CONNPoid = $connection->executeQuery($QURYPoid);
		$FTCHPoid = $CONNPoid->fetchAll();
		$party_det_id  = $FTCHPoid[0]['party_det_id'];
		$po_no         = $FTCHPoid[0]['po_no'];
		$po_date       = $FTCHPoid[0]['po_date'];

		$QURYPoid = "SELECT  * FROM po_entry WHERE po_entry_id ='".$poId."'";
		$CONNPoid = $connection->executeQuery($QURYPoid);
		$FTCHPoid = $CONNPoid->fetchAll();

		$QURYPoidet = "SELECT * FROM party_det WHERE party_det_id ='".$party_det_id."'";
		$CONNPoidet = $connection->executeQuery($QURYPoidet);
		$FTCHPoidet = $CONNPoidet->fetchAll();
		$party_code  = $FTCHPoidet[0]['party_code'];
		$cmp_name  = $FTCHPoidet[0]['cmp_name'];
		$h_br1='T';
		$h_br='0';

		$SLCT = "SELECT  * FROM po_entry_det pe,design_det dd WHERE pe.cancelled = 'no' AND pe.po_entry_id =".$poId." AND dd.design_det_id = pe.design_det_id ORDER BY pe.master_cat_id,dd.design_no,pe.po_entry_det_id ASC";
		$CONNPoentry = $connection->executeQuery($SLCT);
		$printPoEntryDetails = $CONNPoentry->fetchAll();

		$des_id = array();
		$des_det_id = array();
		$des_ext = array();
		$i=1;
		$del_date = '';

		$SLCT1 = "SELECT  COUNT(po_entry_det_id) AS tot_cnt FROM po_entry_det WHERE cancelled = 'no' AND po_entry_id =".$poId;
		$CONNPoentry1 = $connection->executeQuery($SLCT1);
		$printPoEntryDetailsCount = $CONNPoentry1->fetchAll();
		$tot_cnt  =  $printPoEntryDetailsCount[0]['tot_cnt'];

		require('tcpdf/tcpdf.php');
		// create new PDF document
		$pdf = new \TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

		// set document information
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetTitle('Order Details');
		$table_head = "PO No: ".$po_no."                          PO Date: ".date('d M, Y', strtotime($po_date))."                                                                                    Qty: ".$tot_cnt."";
		// set default header data
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, '                                               Company Name: '.$cmp_name , $table_head);

		// set header and footer fonts
		$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
		$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

		// set default monospaced font
		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

		// set margins
		$pdf->SetMargins(2, 20, 2);
		$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
		$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

		// set auto page breaks
		$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

		// set image scale factor
		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

		// add a page
		$pdf->AddPage();
		$html = '<table>';
		$l=1;
		$i=1;
		$temp =1;

		$cnt = count($printPoEntryDetails);
			$imgurl = 'https://meways.in/';
			$des_img_url = $imgurl.'mas_fin_images/';
			$cad_img_url = $imgurl.'cad_fin_images/';
			$mas_img_url = $imgurl.'design_images/';
		foreach($printPoEntryDetails as $po_details){

			$del_date       = $po_details['post_dt'];
			$design_det_id  = $po_details['design_det_id'];
			$design_id	    = base64_encode(base64_encode(base64_encode($design_det_id)));
			$master_cat_id  = $po_details['master_cat_id'];
			$design_no      = $po_details['design_no'];
			$mas_fin_ext    = $po_details['mas_fin_ext'];
			$cad_fin_ext    = $po_details['cad_fin_ext'];
			$imag_ext       = $po_details['imag_ext'];

			$SLCT3 = "SELECT MS.* FROM mas_finishing AS MS,design_det AS DD WHERE MS.`design_det_id`=DD.`design_det_id` AND DD.design_det_id=".$design_det_id;
			$CONNPoentry3 = $connection->executeQuery($SLCT3);
			$getMastersData3 = $CONNPoentry3->fetchAll();
			$mas_wght = $getMastersData3[0]['mas_weight'];

			$SLCT4 = "SELECT * FROM  master_cat WHERE  master_cat_id='".$master_cat_id."'";
			$CONNPoentry4 = $connection->executeQuery($SLCT4);
			$printPoMasterDetails = $CONNPoentry4->fetchAll();
			$master_cat_name  = $printPoMasterDetails[0]['master_cat_name'];

			$SLCT5 = "SELECT COUNT(design_det_id) AS or_cnt FROM po_entry_det WHERE cancelled = 'no' AND design_det_id ='".$design_det_id."' AND fin_status = 'no'";
			$CONNPoentry6 = $connection->executeQuery($SLCT5);
			$printPoDesignDetailsCount = $CONNPoentry6->fetchAll();
			$or_cnt  = $printPoDesignDetailsCount[0]['or_cnt'];

			$SLCT6 = "SELECT COUNT(design_det_id) AS st_cnt FROM stock_det WHERE st_fin_status = 'no' AND design_det_id ='".$design_det_id."'";
			$CONNPoentry6a = $connection->executeQuery($SLCT6);
			$printPoDesignDetailsCount2 = $CONNPoentry6a->fetchAll();
			$st_cnt  = $printPoDesignDetailsCount2[0]['st_cnt'];
			$or_cnt[$i] = $or_cnt;
			$st_cnt[$i] = $st_cnt;

			$des_det_id[$i] = $design_det_id;

			$des_id  = $master_cat_name." ".$design_no; 
			$weigh   = number_format($mas_wght,2)." g";

			if($mas_fin_ext!=''){ $des_ext  = $des_img_url."L.".$mas_fin_ext;}

			else if($cad_fin_ext!=''){ $des_ext  = $cad_img_url."L.".$cad_fin_ext; }

			else if($imag_ext!=''){ $des_ext  = $mas_img_url."L.".$imag_ext; }

			/*if(file_exists($des_ext))
			{
				$des_ext = $des_ext;
			}
			else
			{
				$des_ext  = "images/no_image.jpg";
			}*/
			$i++;

			if($temp == 1){   $html .= '<tr>'; } 

			$html .= '<td style="width:20%;font-size:10px; text-align:center;">
				<img src="'.$des_ext.'" width="100" height="100"><br>'.$des_id.'<br>'.$weigh.'</td>';
			if($temp == 5|| $i==$cnt){ $html .= '</tr>'; $temp = 0; }
			$temp++;
			$i++;
		}

		$html .= '</table>';
	//echo $html;
	//exit;
	$pdf->writeHTML($html, true, false, true, false, '');

		//$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

	// reset pointer to the last page
	$pdf->lastPage();
	//Close and output PDF document
	$pdf->Output('example.pdf', 'I');
    }

}