<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Cookie;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\FileBag;

class CartController extends AbstractController
{
 
	/** 
	* @Route("/cart", name="cart")
	*/
	public function cartItemsAct(Request $request) 
	{
		$connection   = $this->getDoctrine()->getManager()->getConnection();
 		$session = $request->getSession();
		$login_id =  $session->get('loginId');
		if(!$session->has('login'))
        {
        	return $this->redirectToRoute('login');
        }

		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		$sel_crt = "select * from des_sel_temp_des where party_det_id='".$login_id."'";
		$CONNselCrt	= $connection->executeQuery($sel_crt);
		$FTCHselCrt	= $CONNselCrt->fetchAll();
		$cart_html = '<table class="w-full max-[1400px]:w-[700px] max-md:w-[700px]" style="width:100%;" id="cart-body">
								<thead class="border-b border-line">
									<tr style="border-bottom:2px solid #ADCC57;">
										<th scope="col" class="pb-3 text-sm font-bold text-secondary whitespace-nowrap">S.No.</th>
										<th scope="col" class="pb-3 text-left text-sm font-bold text-secondary whitespace-nowrap">Design</th>
										<th scope="col" class="pb-3 text-left text-sm font-bold text-secondary whitespace-nowrap">Design No.</th>
										<th scope="col" class="pb-3 text-sm font-bold text-secondary whitespace-nowrap">Delete</th>
									</tr>
								</thead>
								<tbody id="cartpagelist">';
		if(count($FTCHselCrt)>0){
			$cartsno=1;
			
			$imgurl = 'https://meways.in/';
			$des_img_url = 'mas_fin_images/';
			$cad_img_url = 'cad_fin_images/';
			$mas_img_url = 'design_images/';



		foreach($FTCHselCrt as $crt){
			$sel_det ="SELECT d.mas_fin_ext, d.cad_fin_ext, d.imag_ext, mc.master_cat_name, d.design_det_id, d.design_no FROM design_det as d,master_cat as mc WHERE mc.master_cat_id = d.master_cat_id AND d.statu_s='active' and d.design_det_id='".$crt['design_det_id']."' AND d.up_status='no'";
			$CONNseldet	= $connection->executeQuery($sel_det);
			$FTCHseldet	= $CONNseldet->fetchAll();
			if (!empty($FTCHseldet)){
				
			if($FTCHseldet[0]['mas_fin_ext']!=''){ $imag = $imgurl.$des_img_url."L.".$FTCHseldet[0]['mas_fin_ext']; }
			else if($FTCHseldet[0]['cad_fin_ext']!=''){ $imag = $imgurl.$cad_img_url."L.".$FTCHseldet[0]['cad_fin_ext']; }
			else if($FTCHseldet[0]['imag_ext']!=''){ $imag = $imgurl.$mas_img_url."L.".$FTCHseldet[0]['imag_ext']; } else {
			$imag = './assets/images/product/1000x1000.png';
			}

			$cart_html .='<tr class="item duration-300 border-b border-line" id="crt_'.$crt['design_det_id'].'">
										<td class="serial-no" scope="row" class="py-3" align="center" style="font-size:14px;">'.$cartsno.'</td>
										<td class="py-3" align="left" style="font-size:14px;">';
											$cart_html .='<img class="design-image object-cover cursor-pointer" style="width:3rem; height:3rem; border:1px solid rgb(233 233 233 / var(--tw-border-opacity));" src="'.$imag.'" alt="'.$FTCHseldet[0]['master_cat_name'].' '.$FTCHseldet[0]['design_no'].'" class="flex-shrink-0 w-12 h-12 rounded" data-caption="'.$FTCHseldet[0]['master_cat_name'].' '.$FTCHseldet[0]['design_no'].'">';
									$cart_html .='</td>
										<td class="py-3"><strong class="product_name text-button" style="font-size:14px;">'.$FTCHseldet[0]['master_cat_name'].' '.$FTCHseldet[0]['design_no'].'</strong></td>
										<td class="py-3" style="width: 100%; text-align: center; display: flex; justify-content: center; gap: 5px;">
										<a href="javascript:;" onclick="rem_cart(\''.$crt['design_det_id'].'\');"><img src="./assets/images/cart_delete.png" width="20" title="Remove From Cart"></a>
										</td>
									</tr>';
			$cartsno = $cartsno+1;
		}

		}
		} else {
			$cart_html .='<tr class="item duration-300 border-b border-line"><td colspan="4" style="  text-align: center; justify-content: center; gap: 5px;"><b>There are no items in your cart</b></td></tr>';
		}

		$cart_html .= "</tbody>
				</table>";
	// Fetch CAD types
    $QURYcad = "SELECT * FROM master_cad_type WHERE statu_s='active' ORDER BY master_cad_type_id ASC";
    $CONNcad = $connection->executeQuery($QURYcad);
    $FTCHcad = $CONNcad->fetchAll();
	$cart_count = $this->cart_count($login_id);

	return $this->render('cart/cartlist.html.twig', [
			'cart_html'=>$cart_html,
			'FTCHcad'=>$FTCHcad,
			'activeType'=>'',
			'cart_count'=>$cart_count,
			'party_id'=>$login_id,
			'controller_name' => 'CartController'
        ]);
}

/** 
	* @Route("/SubmititemstoCart", name="SubmititemstoCart")
	*/
	public function SubmitCartitems(Request $request) 
	{
		$connection   = $this->getDoctrine()->getManager()->getConnection();
		$partyId =   $request->get('partyId');
 		$session = $request->getSession();
		$login_id =  $session->get('loginId');
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		$pr_price=0;
		$tprice=0;
		$tot_cst=0;

		$sessionId = session_id();

		$selempcrnt  = "select * from des_sel_temp_des where party_det_id='".$partyId."'";
		$CONNempcrnt = $connection->executeQuery($selempcrnt);
		$FTCHempcrnt = $CONNempcrnt->fetchAll();
			$cur_date = date("d-m-Y h:i:s");
			$sel_date = date("d-m-Y", strtotime($cur_date));

		foreach($FTCHempcrnt as $cart){
			$selempcrnt1  = "INSERT INTO design_sel_det(`party_det_id`,`design_det_id`,`sel_date`, `post_dt`) VALUES ('".$partyId."','".$cart['design_det_id']."','".$cur_date."',now())";
			$CONNempcrnt1 = $connection->executeQuery($selempcrnt1);
		}

		$del_tempdes = "delete from des_sel_temp_des where party_det_id='".$partyId."'";
		$CONNtempdes = $connection->executeQuery($del_tempdes);

		$del_temp = "delete from des_sel_temp where party_det_id='".$partyId."'";
		$CONNtemp = $connection->executeQuery($del_temp);
 
		$cart_count = $this->cart_count($partyId);
		return  new JsonResponse($cart_count);
	}
	
	
	
	/** 
	* @Route("/getCartItems", name="getCartItems")
	*/
	public function getCartItemsList(Request $request) 
	{
		$connection   = $this->getDoctrine()->getManager()->getConnection();
 		$session = $request->getSession();
		$login_id =   $session->get('loginId');
		date_default_timezone_set("Asia/Calcutta") ;
		$nowDateTime = date("Y-m-d H:i:s");
		
		$sel_crt = "select * from des_sel_temp_des where party_det_id='".$login_id."'";
		$CONNselCrt	= $connection->executeQuery($sel_crt);
		$FTCHselCrt	= $CONNselCrt->fetchAll();
		$cart_html ='';
		$imgurl = 'https://meways.in/';
		$des_img_url = 'mas_fin_images/';
		$cad_img_url = 'cad_fin_images/';
		$mas_img_url = 'design_images/';


		if(count($FTCHselCrt)>0){
		foreach($FTCHselCrt as $crt){
			$sel_det ="SELECT d.mas_fin_ext, d.cad_fin_ext, d.imag_ext, mc.master_cat_name, d.design_det_id, d.design_no FROM design_det as d,master_cat as mc WHERE mc.master_cat_id = d.master_cat_id AND d.statu_s='active' and d.design_det_id='".$crt['design_det_id']."' AND d.up_status='no'";
			$CONNseldet	= $connection->executeQuery($sel_det);
			$FTCHseldet	= $CONNseldet->fetchAll();
			if (!empty($FTCHseldet)){
				if($FTCHseldet[0]['mas_fin_ext']!=''){ $imag = $imgurl.$des_img_url."L.".$FTCHseldet[0]['mas_fin_ext']; }
				else if($FTCHseldet[0]['cad_fin_ext']!=''){ $imag = $imgurl.$cad_img_url."L.".$FTCHseldet[0]['cad_fin_ext']; }
				else if($FTCHseldet[0]['imag_ext']!=''){ $imag = $imgurl.$mas_img_url."L.".$FTCHseldet[0]['imag_ext']; 
				} else {
				$imag = './assets/images/product/1000x1000.png';
				}

				$cart_html .='<div class="px-6" id="crt_'.$crt['design_det_id'].'">
					<div data-item="7" class="item py-5 flex items-center justify-between gap-3 border-b border-line">
						<div class="infor flex items-center gap-5">
							<div class="bg-img">';
											$cart_html .='<img src="'.$imag.'" alt="'.$FTCHseldet[0]['master_cat_name'].' '.$FTCHseldet[0]['design_no'].'" class="w-[100px] aspect-square flex-shrink-0 rounded-lg" title="'.$FTCHseldet[0]['master_cat_name'].' '.$FTCHseldet[0]['design_no'].'" style="border:1px solid rgb(233 233 233 / var(--tw-border-opacity));">';
										
							$cart_html .='</div>
							<div>
								<div class="name text-button">'.$FTCHseldet[0]['master_cat_name'].' '.$FTCHseldet[0]['design_no'].'</div>
							</div>
						</div>
						<div class="remove-wishlist-btn remove-btn caption1 font-semibold text-red underline cursor-pointer">
							<a href="javascript:;" onclick="dec_cart1(\''.$crt['design_det_id'].'\');"><img src="./assets/images/cart_delete.png" width="20" title="Remove From Cart"></a>
						</div>
					</div>
				</div>';
			} 
		}
		}else {
				$cart_html .='<div class="px-6"  style="text-align:center; min-height:450px; "><b>There are no items in Cart</b></div>';
			}
		return  new JsonResponse(count($FTCHselCrt)."###".$cart_html);
	}

}